
package org.modeldriven.fuml.repository.model;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fUML.Syntax.Classes.Kernel.Association;
import fUML.Syntax.Classes.Kernel.Class_;
import fUML.Syntax.Classes.Kernel.Generalization;
import fUML.Syntax.Classes.Kernel.Classifier;
import fUML.Syntax.Classes.Kernel.LiteralInteger;
import fUML.Syntax.Classes.Kernel.LiteralUnlimitedNatural;
import fUML.Syntax.Classes.Kernel.PrimitiveType;
import UMLPrimitiveTypes.UnlimitedNatural;
import fUML.Syntax.Classes.Kernel.ValueSpecification;
import fUML.Syntax.Classes.Kernel.Enumeration;
import fUML.Syntax.Classes.Kernel.EnumerationLiteral;
import fUML.Syntax.Classes.Kernel.Package;
import fUML.Syntax.Classes.Kernel.Property;

import org.modeldriven.fuml.repository.RepositoryArtifact;
import org.modeldriven.fuml.repository.RepositoryMapping;
import org.modeldriven.fuml.repository.Repository;

import org.modeldriven.fuml.repository.config.Artifact;

// this needs to read the artifact namespace info from the content
public class SuperstructureAssembler extends ModelAssembler 
    implements RepositoryArtifact
{

    private static Log log = LogFactory.getLog(SuperstructureAssembler.class);
    private ModelFactory factory;

    public SuperstructureAssembler(Artifact artifact, RepositoryMapping mapping, Repository model) {
        super(artifact, mapping, model);
        this.factory = new ModelFactory(mapping, model);
        construct();
    }

    private void construct() {
        log.info("initializing...");
        constructPackages();
        constructPrimitiveTypes();
        constructEnumerations();
        constructClasses();
        constructProperties();
        constructGeneralizations();
        constructAssociations();
    } 

    public String getURN() {
        return this.artifact.getUrn();
    }
    
    public String getNamespaceURI() {
        return this.artifact.getNamespaceURI();
    }
    
    private void constructPackages()
    {
        Package pkg = null;
         
                     
        // UML            
    	pkg  = factory.createPackage("UML", "UML", "UML", this); // root package
    	mapping.mapPackage(pkg, null, this); 
                
                     
        // UML.Actions                                                    
    	pkg  = factory.createPackage("Actions", "UML.Actions", "Actions", pkg, this);
    	mapping.mapPackage(pkg, "UML", this); 
                
                     
        // UML.Actions.BasicActions                                                    
    	pkg  = factory.createPackage("BasicActions", "UML.Actions.BasicActions", "Actions-BasicActions", pkg, this);
    	mapping.mapPackage(pkg, "UML.Actions", this); 
                
                     
        // UML.Actions.CompleteActions                                                    
    	pkg  = factory.createPackage("CompleteActions", "UML.Actions.CompleteActions", "Actions-CompleteActions", pkg, this);
    	mapping.mapPackage(pkg, "UML.Actions", this); 
                        
        mapping.mapPackageMerge(pkg, "Actions-IntermediateActions");
                        
        mapping.mapPackageMerge(pkg, "Actions-StructuredActions");
                
                     
        // UML.Actions.IntermediateActions                                                    
    	pkg  = factory.createPackage("IntermediateActions", "UML.Actions.IntermediateActions", "Actions-IntermediateActions", pkg, this);
    	mapping.mapPackage(pkg, "UML.Actions", this); 
                        
        mapping.mapPackageMerge(pkg, "CommonBehaviors-BasicBehaviors");
                
                     
        // UML.Actions.StructuredActions                                                    
    	pkg  = factory.createPackage("StructuredActions", "UML.Actions.StructuredActions", "Actions-StructuredActions", pkg, this);
    	mapping.mapPackage(pkg, "UML.Actions", this); 
                
                     
        // UML.Activities                                                    
    	pkg  = factory.createPackage("Activities", "UML.Activities", "Activities", pkg, this);
    	mapping.mapPackage(pkg, "UML", this); 
                
                     
        // UML.Activities.BasicActivities                                                    
    	pkg  = factory.createPackage("BasicActivities", "UML.Activities.BasicActivities", "Activities-BasicActivities", pkg, this);
    	mapping.mapPackage(pkg, "UML.Activities", this); 
                        
        mapping.mapPackageMerge(pkg, "CommonBehaviors-BasicBehaviors");
                        
        mapping.mapPackageMerge(pkg, "Activities-FundamentalActivities");
                
                     
        // UML.Activities.CompleteActivities                                                    
    	pkg  = factory.createPackage("CompleteActivities", "UML.Activities.CompleteActivities", "Activities-CompleteActivities", pkg, this);
    	mapping.mapPackage(pkg, "UML.Activities", this); 
                        
        mapping.mapPackageMerge(pkg, "Activities-IntermediateActivities");
                
                     
        // UML.Activities.CompleteStructuredActivities                                                    
    	pkg  = factory.createPackage("CompleteStructuredActivities", "UML.Activities.CompleteStructuredActivities", "Activities-CompleteStructuredActivities", pkg, this);
    	mapping.mapPackage(pkg, "UML.Activities", this); 
                        
        mapping.mapPackageMerge(pkg, "Activities-BasicActivities");
                        
        mapping.mapPackageMerge(pkg, "Activities-StructuredActivities");
                
                     
        // UML.Activities.ExtraStructuredActivities                                                    
    	pkg  = factory.createPackage("ExtraStructuredActivities", "UML.Activities.ExtraStructuredActivities", "Activities-ExtraStructuredActivities", pkg, this);
    	mapping.mapPackage(pkg, "UML.Activities", this); 
                        
        mapping.mapPackageMerge(pkg, "Activities-StructuredActivities");
                
                     
        // UML.Activities.FundamentalActivities                                                    
    	pkg  = factory.createPackage("FundamentalActivities", "UML.Activities.FundamentalActivities", "Activities-FundamentalActivities", pkg, this);
    	mapping.mapPackage(pkg, "UML.Activities", this); 
                        
        mapping.mapPackageMerge(pkg, "Actions-BasicActions");
                        
        mapping.mapPackageMerge(pkg, "CommonBehaviors-BasicBehaviors");
                
                     
        // UML.Activities.IntermediateActivities                                                    
    	pkg  = factory.createPackage("IntermediateActivities", "UML.Activities.IntermediateActivities", "Activities-IntermediateActivities", pkg, this);
    	mapping.mapPackage(pkg, "UML.Activities", this); 
                        
        mapping.mapPackageMerge(pkg, "Activities-BasicActivities");
                
                     
        // UML.Activities.StructuredActivities                                                    
    	pkg  = factory.createPackage("StructuredActivities", "UML.Activities.StructuredActivities", "Activities-StructuredActivities", pkg, this);
    	mapping.mapPackage(pkg, "UML.Activities", this); 
                        
        mapping.mapPackageMerge(pkg, "Activities-FundamentalActivities");
                
                     
        // UML.AuxiliaryConstructs                                                    
    	pkg  = factory.createPackage("AuxiliaryConstructs", "UML.AuxiliaryConstructs", "AuxiliaryConstructs", pkg, this);
    	mapping.mapPackage(pkg, "UML", this); 
                
                     
        // UML.AuxiliaryConstructs.InformationFlows                                                    
    	pkg  = factory.createPackage("InformationFlows", "UML.AuxiliaryConstructs.InformationFlows", "AuxiliaryConstructs-InformationFlows", pkg, this);
    	mapping.mapPackage(pkg, "UML.AuxiliaryConstructs", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Kernel");
                
                     
        // UML.AuxiliaryConstructs.Models                                                    
    	pkg  = factory.createPackage("Models", "UML.AuxiliaryConstructs.Models", "AuxiliaryConstructs-Models", pkg, this);
    	mapping.mapPackage(pkg, "UML.AuxiliaryConstructs", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Kernel");
                
                     
        // UML.AuxiliaryConstructs.Profiles                                                    
    	pkg  = factory.createPackage("Profiles", "UML.AuxiliaryConstructs.Profiles", "AuxiliaryConstructs-Profiles", pkg, this);
    	mapping.mapPackage(pkg, "UML.AuxiliaryConstructs", this); 
                                                                
        mapping.mapPackageMerge(pkg, "http://www.omg.org/spec/UML/20110701/Infrastructure.xmi#Profiles");
                
                     
        // UML.AuxiliaryConstructs.Templates                                                    
    	pkg  = factory.createPackage("Templates", "UML.AuxiliaryConstructs.Templates", "AuxiliaryConstructs-Templates", pkg, this);
    	mapping.mapPackage(pkg, "UML.AuxiliaryConstructs", this); 
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-InternalStructures");
                
                     
        // UML.Classes                                                    
    	pkg  = factory.createPackage("Classes", "UML.Classes", "Classes", pkg, this);
    	mapping.mapPackage(pkg, "UML", this); 
                
                     
        // UML.Classes.AssociationClasses                                                    
    	pkg  = factory.createPackage("AssociationClasses", "UML.Classes.AssociationClasses", "Classes-AssociationClasses", pkg, this);
    	mapping.mapPackage(pkg, "UML.Classes", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Kernel");
                
                     
        // UML.Classes.Dependencies                                                    
    	pkg  = factory.createPackage("Dependencies", "UML.Classes.Dependencies", "Classes-Dependencies", pkg, this);
    	mapping.mapPackage(pkg, "UML.Classes", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Kernel");
                
                     
        // UML.Classes.Interfaces                                                    
    	pkg  = factory.createPackage("Interfaces", "UML.Classes.Interfaces", "Classes-Interfaces", pkg, this);
    	mapping.mapPackage(pkg, "UML.Classes", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Dependencies");
                
                     
        // UML.Classes.Kernel                                                    
    	pkg  = factory.createPackage("Kernel", "UML.Classes.Kernel", "Classes-Kernel", pkg, this);
    	mapping.mapPackage(pkg, "UML.Classes", this); 
                                                                
        mapping.mapPackageMerge(pkg, "http://www.omg.org/spec/UML/20110701/Infrastructure.xmi#Core-Constructs");
                
                     
        // UML.Classes.PowerTypes                                                    
    	pkg  = factory.createPackage("PowerTypes", "UML.Classes.PowerTypes", "Classes-PowerTypes", pkg, this);
    	mapping.mapPackage(pkg, "UML.Classes", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Kernel");
                
                     
        // UML.CommonBehaviors                                                    
    	pkg  = factory.createPackage("CommonBehaviors", "UML.CommonBehaviors", "CommonBehaviors", pkg, this);
    	mapping.mapPackage(pkg, "UML", this); 
                
                     
        // UML.CommonBehaviors.BasicBehaviors                                                    
    	pkg  = factory.createPackage("BasicBehaviors", "UML.CommonBehaviors.BasicBehaviors", "CommonBehaviors-BasicBehaviors", pkg, this);
    	mapping.mapPackage(pkg, "UML.CommonBehaviors", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Kernel");
                
                     
        // UML.CommonBehaviors.Communications                                                    
    	pkg  = factory.createPackage("Communications", "UML.CommonBehaviors.Communications", "CommonBehaviors-Communications", pkg, this);
    	mapping.mapPackage(pkg, "UML.CommonBehaviors", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Interfaces");
                
                     
        // UML.CommonBehaviors.SimpleTime                                                    
    	pkg  = factory.createPackage("SimpleTime", "UML.CommonBehaviors.SimpleTime", "CommonBehaviors-SimpleTime", pkg, this);
    	mapping.mapPackage(pkg, "UML.CommonBehaviors", this); 
                        
        mapping.mapPackageMerge(pkg, "Actions-IntermediateActions");
                
                     
        // UML.Components                                                    
    	pkg  = factory.createPackage("Components", "UML.Components", "Components", pkg, this);
    	mapping.mapPackage(pkg, "UML", this); 
                
                     
        // UML.Components.BasicComponents                                                    
    	pkg  = factory.createPackage("BasicComponents", "UML.Components.BasicComponents", "Components-BasicComponents", pkg, this);
    	mapping.mapPackage(pkg, "UML.Components", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Dependencies");
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-StructuredClasses");
                
                     
        // UML.Components.PackagingComponents                                                    
    	pkg  = factory.createPackage("PackagingComponents", "UML.Components.PackagingComponents", "Components-PackagingComponents", pkg, this);
    	mapping.mapPackage(pkg, "UML.Components", this); 
                        
        mapping.mapPackageMerge(pkg, "Components-BasicComponents");
                
                     
        // UML.CompositeStructures                                                    
    	pkg  = factory.createPackage("CompositeStructures", "UML.CompositeStructures", "CompositeStructures", pkg, this);
    	mapping.mapPackage(pkg, "UML", this); 
                
                     
        // UML.CompositeStructures.Collaborations                                                    
    	pkg  = factory.createPackage("Collaborations", "UML.CompositeStructures.Collaborations", "CompositeStructures-Collaborations", pkg, this);
    	mapping.mapPackage(pkg, "UML.CompositeStructures", this); 
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-InternalStructures");
                
                     
        // UML.CompositeStructures.InternalStructures                                                    
    	pkg  = factory.createPackage("InternalStructures", "UML.CompositeStructures.InternalStructures", "CompositeStructures-InternalStructures", pkg, this);
    	mapping.mapPackage(pkg, "UML.CompositeStructures", this); 
                        
        mapping.mapPackageMerge(pkg, "Classes-Interfaces");
                
                     
        // UML.CompositeStructures.InvocationActions                                                    
    	pkg  = factory.createPackage("InvocationActions", "UML.CompositeStructures.InvocationActions", "CompositeStructures-InvocationActions", pkg, this);
    	mapping.mapPackage(pkg, "UML.CompositeStructures", this); 
                        
        mapping.mapPackageMerge(pkg, "Actions-BasicActions");
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-Ports");
                
                     
        // UML.CompositeStructures.Ports                                                    
    	pkg  = factory.createPackage("Ports", "UML.CompositeStructures.Ports", "CompositeStructures-Ports", pkg, this);
    	mapping.mapPackage(pkg, "UML.CompositeStructures", this); 
                        
        mapping.mapPackageMerge(pkg, "CommonBehaviors-Communications");
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-InternalStructures");
                
                     
        // UML.CompositeStructures.StructuredActivities                                                    
    	pkg  = factory.createPackage("StructuredActivities", "UML.CompositeStructures.StructuredActivities", "CompositeStructures-StructuredActivities", pkg, this);
    	mapping.mapPackage(pkg, "UML.CompositeStructures", this); 
                        
        mapping.mapPackageMerge(pkg, "Activities-StructuredActivities");
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-InternalStructures");
                
                     
        // UML.CompositeStructures.StructuredClasses                                                    
    	pkg  = factory.createPackage("StructuredClasses", "UML.CompositeStructures.StructuredClasses", "CompositeStructures-StructuredClasses", pkg, this);
    	mapping.mapPackage(pkg, "UML.CompositeStructures", this); 
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-Ports");
                
                     
        // UML.Deployments                                                    
    	pkg  = factory.createPackage("Deployments", "UML.Deployments", "Deployments", pkg, this);
    	mapping.mapPackage(pkg, "UML", this); 
                
                     
        // UML.Deployments.Artifacts                                                    
    	pkg  = factory.createPackage("Artifacts", "UML.Deployments.Artifacts", "Deployments-Artifacts", pkg, this);
    	mapping.mapPackage(pkg, "UML.Deployments", this); 
                
                     
        // UML.Deployments.ComponentDeployments                                                    
    	pkg  = factory.createPackage("ComponentDeployments", "UML.Deployments.ComponentDeployments", "Deployments-ComponentDeployments", pkg, this);
    	mapping.mapPackage(pkg, "UML.Deployments", this); 
                        
        mapping.mapPackageMerge(pkg, "Deployments-Nodes");
                
                     
        // UML.Deployments.Nodes                                                    
    	pkg  = factory.createPackage("Nodes", "UML.Deployments.Nodes", "Deployments-Nodes", pkg, this);
    	mapping.mapPackage(pkg, "UML.Deployments", this); 
                        
        mapping.mapPackageMerge(pkg, "Deployments-Artifacts");
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-StructuredClasses");
                
                     
        // UML.Interactions                                                    
    	pkg  = factory.createPackage("Interactions", "UML.Interactions", "Interactions", pkg, this);
    	mapping.mapPackage(pkg, "UML", this); 
                
                     
        // UML.Interactions.BasicInteractions                                                    
    	pkg  = factory.createPackage("BasicInteractions", "UML.Interactions.BasicInteractions", "Interactions-BasicInteractions", pkg, this);
    	mapping.mapPackage(pkg, "UML.Interactions", this); 
                        
        mapping.mapPackageMerge(pkg, "CommonBehaviors-BasicBehaviors");
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-InternalStructures");
                
                     
        // UML.Interactions.Fragments                                                    
    	pkg  = factory.createPackage("Fragments", "UML.Interactions.Fragments", "Interactions-Fragments", pkg, this);
    	mapping.mapPackage(pkg, "UML.Interactions", this); 
                        
        mapping.mapPackageMerge(pkg, "Interactions-BasicInteractions");
                
                     
        // UML.StateMachines                                                    
    	pkg  = factory.createPackage("StateMachines", "UML.StateMachines", "StateMachines", pkg, this);
    	mapping.mapPackage(pkg, "UML", this); 
                
                     
        // UML.StateMachines.BehaviorStateMachines                                                    
    	pkg  = factory.createPackage("BehaviorStateMachines", "UML.StateMachines.BehaviorStateMachines", "StateMachines-BehaviorStateMachines", pkg, this);
    	mapping.mapPackage(pkg, "UML.StateMachines", this); 
                        
        mapping.mapPackageMerge(pkg, "CommonBehaviors-Communications");
                
                     
        // UML.StateMachines.ProtocolStateMachines                                                    
    	pkg  = factory.createPackage("ProtocolStateMachines", "UML.StateMachines.ProtocolStateMachines", "StateMachines-ProtocolStateMachines", pkg, this);
    	mapping.mapPackage(pkg, "UML.StateMachines", this); 
                        
        mapping.mapPackageMerge(pkg, "StateMachines-BehaviorStateMachines");
                        
        mapping.mapPackageMerge(pkg, "Classes-Interfaces");
                        
        mapping.mapPackageMerge(pkg, "CompositeStructures-Ports");
                
                     
        // UML.UseCases                                                    
    	pkg  = factory.createPackage("UseCases", "UML.UseCases", "UseCases", pkg, this);
    	mapping.mapPackage(pkg, "UML", this); 
                        
        mapping.mapPackageMerge(pkg, "CommonBehaviors-BasicBehaviors");
            
    }   

    private void constructPrimitiveTypes()
    {
    Package pkg = null;
    String packageId = null;
    PrimitiveType type = null;
    
    }   
       
    private void constructClasses()
    {
        Package pkg = null;
        String packageId = null;
        Class_ clss = null;
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.Action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("Action", "Actions-BasicActions-Action", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.CallAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("CallAction", "Actions-BasicActions-CallAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.CallBehaviorAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("CallBehaviorAction", "Actions-BasicActions-CallBehaviorAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.CallOperationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("CallOperationAction", "Actions-BasicActions-CallOperationAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.InputPin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("InputPin", "Actions-BasicActions-InputPin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.InvocationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("InvocationAction", "Actions-BasicActions-InvocationAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.MultiplicityElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("MultiplicityElement", "Actions-BasicActions-MultiplicityElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.OpaqueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("OpaqueAction", "Actions-BasicActions-OpaqueAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.OutputPin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("OutputPin", "Actions-BasicActions-OutputPin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.Pin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("Pin", "Actions-BasicActions-Pin", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.SendSignalAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("SendSignalAction", "Actions-BasicActions-SendSignalAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.ValuePin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.BasicActions").getDelegate();       
    	clss  = factory.createClass("ValuePin", "Actions-BasicActions-ValuePin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.BasicActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.AcceptCallAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("AcceptCallAction", "Actions-CompleteActions-AcceptCallAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.AcceptEventAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("AcceptEventAction", "Actions-CompleteActions-AcceptEventAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.CreateLinkObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("CreateLinkObjectAction", "Actions-CompleteActions-CreateLinkObjectAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.LinkEndData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("LinkEndData", "Actions-CompleteActions-LinkEndData", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.QualifierValue 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("QualifierValue", "Actions-CompleteActions-QualifierValue", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.ReadExtentAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("ReadExtentAction", "Actions-CompleteActions-ReadExtentAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.ReadIsClassifiedObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("ReadIsClassifiedObjectAction", "Actions-CompleteActions-ReadIsClassifiedObjectAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.ReadLinkObjectEndAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("ReadLinkObjectEndAction", "Actions-CompleteActions-ReadLinkObjectEndAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.ReadLinkObjectEndQualifierAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("ReadLinkObjectEndQualifierAction", "Actions-CompleteActions-ReadLinkObjectEndQualifierAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.ReclassifyObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("ReclassifyObjectAction", "Actions-CompleteActions-ReclassifyObjectAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.ReduceAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("ReduceAction", "Actions-CompleteActions-ReduceAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.ReplyAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("ReplyAction", "Actions-CompleteActions-ReplyAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.StartClassifierBehaviorAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("StartClassifierBehaviorAction", "Actions-CompleteActions-StartClassifierBehaviorAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.StartObjectBehaviorAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("StartObjectBehaviorAction", "Actions-CompleteActions-StartObjectBehaviorAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.UnmarshallAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.CompleteActions").getDelegate();       
    	clss  = factory.createClass("UnmarshallAction", "Actions-CompleteActions-UnmarshallAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.CompleteActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.AddStructuralFeatureValueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("AddStructuralFeatureValueAction", "Actions-IntermediateActions-AddStructuralFeatureValueAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.BroadcastSignalAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("BroadcastSignalAction", "Actions-IntermediateActions-BroadcastSignalAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.ClearAssociationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("ClearAssociationAction", "Actions-IntermediateActions-ClearAssociationAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.ClearStructuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("ClearStructuralFeatureAction", "Actions-IntermediateActions-ClearStructuralFeatureAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.CreateLinkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("CreateLinkAction", "Actions-IntermediateActions-CreateLinkAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.CreateObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("CreateObjectAction", "Actions-IntermediateActions-CreateObjectAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.DestroyLinkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("DestroyLinkAction", "Actions-IntermediateActions-DestroyLinkAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.DestroyObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("DestroyObjectAction", "Actions-IntermediateActions-DestroyObjectAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.LinkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("LinkAction", "Actions-IntermediateActions-LinkAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.LinkEndCreationData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("LinkEndCreationData", "Actions-IntermediateActions-LinkEndCreationData", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.LinkEndData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("LinkEndData", "Actions-IntermediateActions-LinkEndData", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.LinkEndDestructionData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("LinkEndDestructionData", "Actions-IntermediateActions-LinkEndDestructionData", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.ReadLinkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("ReadLinkAction", "Actions-IntermediateActions-ReadLinkAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.ReadSelfAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("ReadSelfAction", "Actions-IntermediateActions-ReadSelfAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.ReadStructuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("ReadStructuralFeatureAction", "Actions-IntermediateActions-ReadStructuralFeatureAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.RemoveStructuralFeatureValueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("RemoveStructuralFeatureValueAction", "Actions-IntermediateActions-RemoveStructuralFeatureValueAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.SendObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("SendObjectAction", "Actions-IntermediateActions-SendObjectAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.StructuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("StructuralFeatureAction", "Actions-IntermediateActions-StructuralFeatureAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.TestIdentityAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("TestIdentityAction", "Actions-IntermediateActions-TestIdentityAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.ValueSpecificationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("ValueSpecificationAction", "Actions-IntermediateActions-ValueSpecificationAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.WriteLinkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("WriteLinkAction", "Actions-IntermediateActions-WriteLinkAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.WriteStructuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.IntermediateActions").getDelegate();       
    	clss  = factory.createClass("WriteStructuralFeatureAction", "Actions-IntermediateActions-WriteStructuralFeatureAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Actions.IntermediateActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // UML.Actions.StructuredActions.ActionInputPin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.StructuredActions").getDelegate();       
    	clss  = factory.createClass("ActionInputPin", "Actions-StructuredActions-ActionInputPin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.StructuredActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // UML.Actions.StructuredActions.AddVariableValueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.StructuredActions").getDelegate();       
    	clss  = factory.createClass("AddVariableValueAction", "Actions-StructuredActions-AddVariableValueAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.StructuredActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // UML.Actions.StructuredActions.ClearVariableAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.StructuredActions").getDelegate();       
    	clss  = factory.createClass("ClearVariableAction", "Actions-StructuredActions-ClearVariableAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.StructuredActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // UML.Actions.StructuredActions.RaiseExceptionAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.StructuredActions").getDelegate();       
    	clss  = factory.createClass("RaiseExceptionAction", "Actions-StructuredActions-RaiseExceptionAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.StructuredActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // UML.Actions.StructuredActions.ReadVariableAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.StructuredActions").getDelegate();       
    	clss  = factory.createClass("ReadVariableAction", "Actions-StructuredActions-ReadVariableAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.StructuredActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // UML.Actions.StructuredActions.RemoveVariableValueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.StructuredActions").getDelegate();       
    	clss  = factory.createClass("RemoveVariableValueAction", "Actions-StructuredActions-RemoveVariableValueAction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Actions.StructuredActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // UML.Actions.StructuredActions.VariableAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.StructuredActions").getDelegate();       
    	clss  = factory.createClass("VariableAction", "Actions-StructuredActions-VariableAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Actions.StructuredActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // UML.Actions.StructuredActions.WriteVariableAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Actions.StructuredActions").getDelegate();       
    	clss  = factory.createClass("WriteVariableAction", "Actions-StructuredActions-WriteVariableAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Actions.StructuredActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.Activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("Activity", "Activities-BasicActivities-Activity", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.ActivityEdge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ActivityEdge", "Activities-BasicActivities-ActivityEdge", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.ActivityFinalNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ActivityFinalNode", "Activities-BasicActivities-ActivityFinalNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.ActivityGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ActivityGroup", "Activities-BasicActivities-ActivityGroup", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.ActivityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ActivityNode", "Activities-BasicActivities-ActivityNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.ActivityParameterNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ActivityParameterNode", "Activities-BasicActivities-ActivityParameterNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.ControlFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ControlFlow", "Activities-BasicActivities-ControlFlow", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.ControlNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ControlNode", "Activities-BasicActivities-ControlNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.InitialNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("InitialNode", "Activities-BasicActivities-InitialNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.ObjectFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ObjectFlow", "Activities-BasicActivities-ObjectFlow", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.ObjectNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ObjectNode", "Activities-BasicActivities-ObjectNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.Pin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("Pin", "Activities-BasicActivities-Pin", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.ValuePin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.BasicActivities").getDelegate();       
    	clss  = factory.createClass("ValuePin", "Activities-BasicActivities-ValuePin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.BasicActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.Action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("Action", "Activities-CompleteActivities-Action", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.Activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("Activity", "Activities-CompleteActivities-Activity", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.ActivityEdge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("ActivityEdge", "Activities-CompleteActivities-ActivityEdge", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.ActivityGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("ActivityGroup", "Activities-CompleteActivities-ActivityGroup", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.ActivityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("ActivityNode", "Activities-CompleteActivities-ActivityNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.Behavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("Behavior", "Activities-CompleteActivities-Behavior", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.BehavioralFeature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("BehavioralFeature", "Activities-CompleteActivities-BehavioralFeature", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.DataStoreNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("DataStoreNode", "Activities-CompleteActivities-DataStoreNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.InterruptibleActivityRegion 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("InterruptibleActivityRegion", "Activities-CompleteActivities-InterruptibleActivityRegion", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.JoinNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("JoinNode", "Activities-CompleteActivities-JoinNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.ObjectFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("ObjectFlow", "Activities-CompleteActivities-ObjectFlow", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.ObjectNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("ObjectNode", "Activities-CompleteActivities-ObjectNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.Parameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("Parameter", "Activities-CompleteActivities-Parameter", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.ParameterSet 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("ParameterSet", "Activities-CompleteActivities-ParameterSet", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.Pin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteActivities").getDelegate();       
    	clss  = factory.createClass("Pin", "Activities-CompleteActivities-Pin", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.CompleteActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.Action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteStructuredActivities").getDelegate();       
    	clss  = factory.createClass("Action", "Activities-CompleteStructuredActivities-Action", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.ActivityEdge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteStructuredActivities").getDelegate();       
    	clss  = factory.createClass("ActivityEdge", "Activities-CompleteStructuredActivities-ActivityEdge", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.ActivityGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteStructuredActivities").getDelegate();       
    	clss  = factory.createClass("ActivityGroup", "Activities-CompleteStructuredActivities-ActivityGroup", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.Clause 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteStructuredActivities").getDelegate();       
    	clss  = factory.createClass("Clause", "Activities-CompleteStructuredActivities-Clause", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.ConditionalNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteStructuredActivities").getDelegate();       
    	clss  = factory.createClass("ConditionalNode", "Activities-CompleteStructuredActivities-ConditionalNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.InputPin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteStructuredActivities").getDelegate();       
    	clss  = factory.createClass("InputPin", "Activities-CompleteStructuredActivities-InputPin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.LoopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteStructuredActivities").getDelegate();       
    	clss  = factory.createClass("LoopNode", "Activities-CompleteStructuredActivities-LoopNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.OutputPin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteStructuredActivities").getDelegate();       
    	clss  = factory.createClass("OutputPin", "Activities-CompleteStructuredActivities-OutputPin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.StructuredActivityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.CompleteStructuredActivities").getDelegate();       
    	clss  = factory.createClass("StructuredActivityNode", "Activities-CompleteStructuredActivities-StructuredActivityNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // UML.Activities.ExtraStructuredActivities.ExceptionHandler 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.ExtraStructuredActivities").getDelegate();       
    	clss  = factory.createClass("ExceptionHandler", "Activities-ExtraStructuredActivities-ExceptionHandler", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.ExtraStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // UML.Activities.ExtraStructuredActivities.ExecutableNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.ExtraStructuredActivities").getDelegate();       
    	clss  = factory.createClass("ExecutableNode", "Activities-ExtraStructuredActivities-ExecutableNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.ExtraStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // UML.Activities.ExtraStructuredActivities.ExpansionNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.ExtraStructuredActivities").getDelegate();       
    	clss  = factory.createClass("ExpansionNode", "Activities-ExtraStructuredActivities-ExpansionNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.ExtraStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // UML.Activities.ExtraStructuredActivities.ExpansionRegion 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.ExtraStructuredActivities").getDelegate();       
    	clss  = factory.createClass("ExpansionRegion", "Activities-ExtraStructuredActivities-ExpansionRegion", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.ExtraStructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";   
                      
        // UML.Activities.FundamentalActivities.Action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.FundamentalActivities").getDelegate();       
    	clss  = factory.createClass("Action", "Activities-FundamentalActivities-Action", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.FundamentalActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";   
                      
        // UML.Activities.FundamentalActivities.Activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.FundamentalActivities").getDelegate();       
    	clss  = factory.createClass("Activity", "Activities-FundamentalActivities-Activity", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.FundamentalActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";   
                      
        // UML.Activities.FundamentalActivities.ActivityGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.FundamentalActivities").getDelegate();       
    	clss  = factory.createClass("ActivityGroup", "Activities-FundamentalActivities-ActivityGroup", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.FundamentalActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";   
                      
        // UML.Activities.FundamentalActivities.ActivityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.FundamentalActivities").getDelegate();       
    	clss  = factory.createClass("ActivityNode", "Activities-FundamentalActivities-ActivityNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.FundamentalActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.Activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("Activity", "Activities-IntermediateActivities-Activity", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.ActivityEdge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("ActivityEdge", "Activities-IntermediateActivities-ActivityEdge", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.ActivityFinalNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("ActivityFinalNode", "Activities-IntermediateActivities-ActivityFinalNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.ActivityGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("ActivityGroup", "Activities-IntermediateActivities-ActivityGroup", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.ActivityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("ActivityNode", "Activities-IntermediateActivities-ActivityNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.ActivityPartition 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("ActivityPartition", "Activities-IntermediateActivities-ActivityPartition", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.CentralBufferNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("CentralBufferNode", "Activities-IntermediateActivities-CentralBufferNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.DecisionNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("DecisionNode", "Activities-IntermediateActivities-DecisionNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.FinalNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("FinalNode", "Activities-IntermediateActivities-FinalNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.FlowFinalNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("FlowFinalNode", "Activities-IntermediateActivities-FlowFinalNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.ForkNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("ForkNode", "Activities-IntermediateActivities-ForkNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.JoinNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("JoinNode", "Activities-IntermediateActivities-JoinNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.MergeNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.IntermediateActivities").getDelegate();       
    	clss  = factory.createClass("MergeNode", "Activities-IntermediateActivities-MergeNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.Action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("Action", "Activities-StructuredActivities-Action", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.Activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("Activity", "Activities-StructuredActivities-Activity", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.ActivityGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("ActivityGroup", "Activities-StructuredActivities-ActivityGroup", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.ActivityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("ActivityNode", "Activities-StructuredActivities-ActivityNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.Clause 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("Clause", "Activities-StructuredActivities-Clause", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.ConditionalNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("ConditionalNode", "Activities-StructuredActivities-ConditionalNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.ExecutableNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("ExecutableNode", "Activities-StructuredActivities-ExecutableNode", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.LoopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("LoopNode", "Activities-StructuredActivities-LoopNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.OutputPin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("OutputPin", "Activities-StructuredActivities-OutputPin", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.SequenceNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("SequenceNode", "Activities-StructuredActivities-SequenceNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.StructuredActivityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("StructuredActivityNode", "Activities-StructuredActivities-StructuredActivityNode", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.Variable 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Activities.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("Variable", "Activities-StructuredActivities-Variable", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Activities.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // UML.AuxiliaryConstructs.InformationFlows.InformationFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.InformationFlows").getDelegate();       
    	clss  = factory.createClass("InformationFlow", "AuxiliaryConstructs-InformationFlows-InformationFlow", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.InformationFlows", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // UML.AuxiliaryConstructs.InformationFlows.InformationItem 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.InformationFlows").getDelegate();       
    	clss  = factory.createClass("InformationItem", "AuxiliaryConstructs-InformationFlows-InformationItem", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.InformationFlows", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Models";   
                      
        // UML.AuxiliaryConstructs.Models.Model 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Models").getDelegate();       
    	clss  = factory.createClass("Model", "AuxiliaryConstructs-Models-Model", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Models", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Profiles";   
                      
        // UML.AuxiliaryConstructs.Profiles.ExtensionEnd 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Profiles").getDelegate();       
    	clss  = factory.createClass("ExtensionEnd", "AuxiliaryConstructs-Profiles-ExtensionEnd", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Profiles", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.Classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("Classifier", "AuxiliaryConstructs-Templates-Classifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.ClassifierTemplateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("ClassifierTemplateParameter", "AuxiliaryConstructs-Templates-ClassifierTemplateParameter", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.ConnectableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("ConnectableElement", "AuxiliaryConstructs-Templates-ConnectableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.ConnectableElementTemplateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("ConnectableElementTemplateParameter", "AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.NamedElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("NamedElement", "AuxiliaryConstructs-Templates-NamedElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.Operation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("Operation", "AuxiliaryConstructs-Templates-Operation", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.OperationTemplateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("OperationTemplateParameter", "AuxiliaryConstructs-Templates-OperationTemplateParameter", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.Package 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("Package", "AuxiliaryConstructs-Templates-Package", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.PackageableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("PackageableElement", "AuxiliaryConstructs-Templates-PackageableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.ParameterableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("ParameterableElement", "AuxiliaryConstructs-Templates-ParameterableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.Property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("Property", "AuxiliaryConstructs-Templates-Property", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.RedefinableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("RedefinableElement", "AuxiliaryConstructs-Templates-RedefinableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.RedefinableTemplateSignature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("RedefinableTemplateSignature", "AuxiliaryConstructs-Templates-RedefinableTemplateSignature", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.StringExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("StringExpression", "AuxiliaryConstructs-Templates-StringExpression", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.TemplateBinding 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("TemplateBinding", "AuxiliaryConstructs-Templates-TemplateBinding", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.TemplateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("TemplateParameter", "AuxiliaryConstructs-Templates-TemplateParameter", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.TemplateParameterSubstitution 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("TemplateParameterSubstitution", "AuxiliaryConstructs-Templates-TemplateParameterSubstitution", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.TemplateSignature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("TemplateSignature", "AuxiliaryConstructs-Templates-TemplateSignature", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.TemplateableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("TemplateableElement", "AuxiliaryConstructs-Templates-TemplateableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.ValueSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.AuxiliaryConstructs.Templates").getDelegate();       
    	clss  = factory.createClass("ValueSpecification", "AuxiliaryConstructs-Templates-ValueSpecification", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-AssociationClasses";   
                      
        // UML.Classes.AssociationClasses.AssociationClass 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.AssociationClasses").getDelegate();       
    	clss  = factory.createClass("AssociationClass", "Classes-AssociationClasses-AssociationClass", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.AssociationClasses", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-AssociationClasses";   
                      
        // UML.Classes.AssociationClasses.Property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.AssociationClasses").getDelegate();       
    	clss  = factory.createClass("Property", "Classes-AssociationClasses-Property", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.AssociationClasses", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // UML.Classes.Dependencies.Abstraction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("Abstraction", "Classes-Dependencies-Abstraction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // UML.Classes.Dependencies.Classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("Classifier", "Classes-Dependencies-Classifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // UML.Classes.Dependencies.Dependency 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("Dependency", "Classes-Dependencies-Dependency", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // UML.Classes.Dependencies.NamedElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("NamedElement", "Classes-Dependencies-NamedElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // UML.Classes.Dependencies.Namespace 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("Namespace", "Classes-Dependencies-Namespace", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // UML.Classes.Dependencies.PackageableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("PackageableElement", "Classes-Dependencies-PackageableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // UML.Classes.Dependencies.Realization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("Realization", "Classes-Dependencies-Realization", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // UML.Classes.Dependencies.Substitution 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("Substitution", "Classes-Dependencies-Substitution", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // UML.Classes.Dependencies.Usage 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Dependencies").getDelegate();       
    	clss  = factory.createClass("Usage", "Classes-Dependencies-Usage", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Dependencies", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // UML.Classes.Interfaces.BehavioredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Interfaces").getDelegate();       
    	clss  = factory.createClass("BehavioredClassifier", "Classes-Interfaces-BehavioredClassifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Interfaces", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // UML.Classes.Interfaces.Classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Interfaces").getDelegate();       
    	clss  = factory.createClass("Classifier", "Classes-Interfaces-Classifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Interfaces", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // UML.Classes.Interfaces.Interface 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Interfaces").getDelegate();       
    	clss  = factory.createClass("Interface", "Classes-Interfaces-Interface", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Interfaces", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // UML.Classes.Interfaces.InterfaceRealization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Interfaces").getDelegate();       
    	clss  = factory.createClass("InterfaceRealization", "Classes-Interfaces-InterfaceRealization", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Interfaces", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // UML.Classes.Interfaces.Operation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Interfaces").getDelegate();       
    	clss  = factory.createClass("Operation", "Classes-Interfaces-Operation", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Interfaces", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // UML.Classes.Interfaces.Property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Interfaces").getDelegate();       
    	clss  = factory.createClass("Property", "Classes-Interfaces-Property", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Interfaces", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Association 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Association", "Classes-Kernel-Association", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.BehavioralFeature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("BehavioralFeature", "Classes-Kernel-BehavioralFeature", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Class", "Classes-Kernel-Class", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Classifier", "Classes-Kernel-Classifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Comment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Comment", "Classes-Kernel-Comment", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Constraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Constraint", "Classes-Kernel-Constraint", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.DataType 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("DataType", "Classes-Kernel-DataType", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.DirectedRelationship 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("DirectedRelationship", "Classes-Kernel-DirectedRelationship", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Element 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Element", "Classes-Kernel-Element", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.ElementImport 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("ElementImport", "Classes-Kernel-ElementImport", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Enumeration 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Enumeration", "Classes-Kernel-Enumeration", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.EnumerationLiteral 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("EnumerationLiteral", "Classes-Kernel-EnumerationLiteral", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Expression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Expression", "Classes-Kernel-Expression", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Feature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Feature", "Classes-Kernel-Feature", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Generalization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Generalization", "Classes-Kernel-Generalization", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.InstanceSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("InstanceSpecification", "Classes-Kernel-InstanceSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.InstanceValue 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("InstanceValue", "Classes-Kernel-InstanceValue", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.LiteralBoolean 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("LiteralBoolean", "Classes-Kernel-LiteralBoolean", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.LiteralInteger 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("LiteralInteger", "Classes-Kernel-LiteralInteger", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.LiteralNull 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("LiteralNull", "Classes-Kernel-LiteralNull", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.LiteralReal 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("LiteralReal", "Classes-Kernel-LiteralReal", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.LiteralSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("LiteralSpecification", "Classes-Kernel-LiteralSpecification", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.LiteralString 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("LiteralString", "Classes-Kernel-LiteralString", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.LiteralUnlimitedNatural 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("LiteralUnlimitedNatural", "Classes-Kernel-LiteralUnlimitedNatural", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.MultiplicityElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("MultiplicityElement", "Classes-Kernel-MultiplicityElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.NamedElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("NamedElement", "Classes-Kernel-NamedElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Namespace 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Namespace", "Classes-Kernel-Namespace", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.OpaqueExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("OpaqueExpression", "Classes-Kernel-OpaqueExpression", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Operation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Operation", "Classes-Kernel-Operation", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Package 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Package", "Classes-Kernel-Package", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.PackageImport 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("PackageImport", "Classes-Kernel-PackageImport", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.PackageMerge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("PackageMerge", "Classes-Kernel-PackageMerge", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.PackageableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("PackageableElement", "Classes-Kernel-PackageableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Parameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Parameter", "Classes-Kernel-Parameter", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.PrimitiveType 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("PrimitiveType", "Classes-Kernel-PrimitiveType", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Property", "Classes-Kernel-Property", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.RedefinableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("RedefinableElement", "Classes-Kernel-RedefinableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Relationship 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Relationship", "Classes-Kernel-Relationship", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Slot 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Slot", "Classes-Kernel-Slot", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.StructuralFeature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("StructuralFeature", "Classes-Kernel-StructuralFeature", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.Type 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("Type", "Classes-Kernel-Type", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.TypedElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("TypedElement", "Classes-Kernel-TypedElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.ValueSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.Kernel").getDelegate();       
    	clss  = factory.createClass("ValueSpecification", "Classes-Kernel-ValueSpecification", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.Kernel", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-PowerTypes";   
                      
        // UML.Classes.PowerTypes.Classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.PowerTypes").getDelegate();       
    	clss  = factory.createClass("Classifier", "Classes-PowerTypes-Classifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Classes.PowerTypes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-PowerTypes";   
                      
        // UML.Classes.PowerTypes.Generalization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.PowerTypes").getDelegate();       
    	clss  = factory.createClass("Generalization", "Classes-PowerTypes-Generalization", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.PowerTypes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Classes-PowerTypes";   
                      
        // UML.Classes.PowerTypes.GeneralizationSet 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Classes.PowerTypes").getDelegate();       
    	clss  = factory.createClass("GeneralizationSet", "Classes-PowerTypes-GeneralizationSet", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Classes.PowerTypes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // UML.CommonBehaviors.BasicBehaviors.Behavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.BasicBehaviors").getDelegate();       
    	clss  = factory.createClass("Behavior", "CommonBehaviors-BasicBehaviors-Behavior", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.CommonBehaviors.BasicBehaviors", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // UML.CommonBehaviors.BasicBehaviors.BehavioralFeature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.BasicBehaviors").getDelegate();       
    	clss  = factory.createClass("BehavioralFeature", "CommonBehaviors-BasicBehaviors-BehavioralFeature", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.CommonBehaviors.BasicBehaviors", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // UML.CommonBehaviors.BasicBehaviors.BehavioredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.BasicBehaviors").getDelegate();       
    	clss  = factory.createClass("BehavioredClassifier", "CommonBehaviors-BasicBehaviors-BehavioredClassifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.CommonBehaviors.BasicBehaviors", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // UML.CommonBehaviors.BasicBehaviors.FunctionBehavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.BasicBehaviors").getDelegate();       
    	clss  = factory.createClass("FunctionBehavior", "CommonBehaviors-BasicBehaviors-FunctionBehavior", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.BasicBehaviors", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // UML.CommonBehaviors.BasicBehaviors.OpaqueBehavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.BasicBehaviors").getDelegate();       
    	clss  = factory.createClass("OpaqueBehavior", "CommonBehaviors-BasicBehaviors-OpaqueBehavior", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.BasicBehaviors", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // UML.CommonBehaviors.BasicBehaviors.OpaqueExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.BasicBehaviors").getDelegate();       
    	clss  = factory.createClass("OpaqueExpression", "CommonBehaviors-BasicBehaviors-OpaqueExpression", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.BasicBehaviors", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.AnyReceiveEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("AnyReceiveEvent", "CommonBehaviors-Communications-AnyReceiveEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.BehavioralFeature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("BehavioralFeature", "CommonBehaviors-Communications-BehavioralFeature", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.CallEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("CallEvent", "CommonBehaviors-Communications-CallEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.ChangeEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("ChangeEvent", "CommonBehaviors-Communications-ChangeEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.Class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("Class", "CommonBehaviors-Communications-Class", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.Event 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("Event", "CommonBehaviors-Communications-Event", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.Interface 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("Interface", "CommonBehaviors-Communications-Interface", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.MessageEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("MessageEvent", "CommonBehaviors-Communications-MessageEvent", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.Operation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("Operation", "CommonBehaviors-Communications-Operation", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.Reception 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("Reception", "CommonBehaviors-Communications-Reception", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.Signal 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("Signal", "CommonBehaviors-Communications-Signal", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.SignalEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("SignalEvent", "CommonBehaviors-Communications-SignalEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.Trigger 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.Communications").getDelegate();       
    	clss  = factory.createClass("Trigger", "CommonBehaviors-Communications-Trigger", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.Duration 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("Duration", "CommonBehaviors-SimpleTime-Duration", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.DurationConstraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("DurationConstraint", "CommonBehaviors-SimpleTime-DurationConstraint", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.DurationInterval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("DurationInterval", "CommonBehaviors-SimpleTime-DurationInterval", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.DurationObservation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("DurationObservation", "CommonBehaviors-SimpleTime-DurationObservation", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.Interval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("Interval", "CommonBehaviors-SimpleTime-Interval", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.IntervalConstraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("IntervalConstraint", "CommonBehaviors-SimpleTime-IntervalConstraint", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.Observation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("Observation", "CommonBehaviors-SimpleTime-Observation", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.TimeConstraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("TimeConstraint", "CommonBehaviors-SimpleTime-TimeConstraint", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.TimeEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("TimeEvent", "CommonBehaviors-SimpleTime-TimeEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.TimeExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("TimeExpression", "CommonBehaviors-SimpleTime-TimeExpression", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.TimeInterval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("TimeInterval", "CommonBehaviors-SimpleTime-TimeInterval", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.TimeObservation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CommonBehaviors.SimpleTime").getDelegate();       
    	clss  = factory.createClass("TimeObservation", "CommonBehaviors-SimpleTime-TimeObservation", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // UML.Components.BasicComponents.Component 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Components.BasicComponents").getDelegate();       
    	clss  = factory.createClass("Component", "Components-BasicComponents-Component", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Components.BasicComponents", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // UML.Components.BasicComponents.ComponentRealization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Components.BasicComponents").getDelegate();       
    	clss  = factory.createClass("ComponentRealization", "Components-BasicComponents-ComponentRealization", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Components.BasicComponents", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // UML.Components.BasicComponents.ConnectableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Components.BasicComponents").getDelegate();       
    	clss  = factory.createClass("ConnectableElement", "Components-BasicComponents-ConnectableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Components.BasicComponents", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // UML.Components.BasicComponents.Connector 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Components.BasicComponents").getDelegate();       
    	clss  = factory.createClass("Connector", "Components-BasicComponents-Connector", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Components.BasicComponents", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // UML.Components.BasicComponents.ConnectorEnd 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Components.BasicComponents").getDelegate();       
    	clss  = factory.createClass("ConnectorEnd", "Components-BasicComponents-ConnectorEnd", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Components.BasicComponents", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Components-PackagingComponents";   
                      
        // UML.Components.PackagingComponents.Component 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Components.PackagingComponents").getDelegate();       
    	clss  = factory.createClass("Component", "Components-PackagingComponents-Component", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Components.PackagingComponents", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // UML.CompositeStructures.Collaborations.Classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.Collaborations").getDelegate();       
    	clss  = factory.createClass("Classifier", "CompositeStructures-Collaborations-Classifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.CompositeStructures.Collaborations", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // UML.CompositeStructures.Collaborations.Collaboration 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.Collaborations").getDelegate();       
    	clss  = factory.createClass("Collaboration", "CompositeStructures-Collaborations-Collaboration", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CompositeStructures.Collaborations", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // UML.CompositeStructures.Collaborations.CollaborationUse 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.Collaborations").getDelegate();       
    	clss  = factory.createClass("CollaborationUse", "CompositeStructures-Collaborations-CollaborationUse", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CompositeStructures.Collaborations", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // UML.CompositeStructures.Collaborations.Parameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.Collaborations").getDelegate();       
    	clss  = factory.createClass("Parameter", "CompositeStructures-Collaborations-Parameter", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CompositeStructures.Collaborations", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // UML.CompositeStructures.InternalStructures.Class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.InternalStructures").getDelegate();       
    	clss  = factory.createClass("Class", "CompositeStructures-InternalStructures-Class", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CompositeStructures.InternalStructures", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // UML.CompositeStructures.InternalStructures.Classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.InternalStructures").getDelegate();       
    	clss  = factory.createClass("Classifier", "CompositeStructures-InternalStructures-Classifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.CompositeStructures.InternalStructures", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // UML.CompositeStructures.InternalStructures.ConnectableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.InternalStructures").getDelegate();       
    	clss  = factory.createClass("ConnectableElement", "CompositeStructures-InternalStructures-ConnectableElement", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.CompositeStructures.InternalStructures", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // UML.CompositeStructures.InternalStructures.Connector 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.InternalStructures").getDelegate();       
    	clss  = factory.createClass("Connector", "CompositeStructures-InternalStructures-Connector", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CompositeStructures.InternalStructures", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // UML.CompositeStructures.InternalStructures.ConnectorEnd 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.InternalStructures").getDelegate();       
    	clss  = factory.createClass("ConnectorEnd", "CompositeStructures-InternalStructures-ConnectorEnd", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CompositeStructures.InternalStructures", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // UML.CompositeStructures.InternalStructures.Feature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.InternalStructures").getDelegate();       
    	clss  = factory.createClass("Feature", "CompositeStructures-InternalStructures-Feature", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.CompositeStructures.InternalStructures", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // UML.CompositeStructures.InternalStructures.Property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.InternalStructures").getDelegate();       
    	clss  = factory.createClass("Property", "CompositeStructures-InternalStructures-Property", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CompositeStructures.InternalStructures", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // UML.CompositeStructures.InternalStructures.StructuredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.InternalStructures").getDelegate();       
    	clss  = factory.createClass("StructuredClassifier", "CompositeStructures-InternalStructures-StructuredClassifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.CompositeStructures.InternalStructures", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InvocationActions";   
                      
        // UML.CompositeStructures.InvocationActions.InvocationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.InvocationActions").getDelegate();       
    	clss  = factory.createClass("InvocationAction", "CompositeStructures-InvocationActions-InvocationAction", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.CompositeStructures.InvocationActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InvocationActions";   
                      
        // UML.CompositeStructures.InvocationActions.Trigger 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.InvocationActions").getDelegate();       
    	clss  = factory.createClass("Trigger", "CompositeStructures-InvocationActions-Trigger", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.CompositeStructures.InvocationActions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";   
                      
        // UML.CompositeStructures.Ports.ConnectorEnd 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.Ports").getDelegate();       
    	clss  = factory.createClass("ConnectorEnd", "CompositeStructures-Ports-ConnectorEnd", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CompositeStructures.Ports", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";   
                      
        // UML.CompositeStructures.Ports.EncapsulatedClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.Ports").getDelegate();       
    	clss  = factory.createClass("EncapsulatedClassifier", "CompositeStructures-Ports-EncapsulatedClassifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.CompositeStructures.Ports", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";   
                      
        // UML.CompositeStructures.Ports.Port 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.Ports").getDelegate();       
    	clss  = factory.createClass("Port", "CompositeStructures-Ports-Port", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CompositeStructures.Ports", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-StructuredActivities";   
                      
        // UML.CompositeStructures.StructuredActivities.Variable 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.StructuredActivities").getDelegate();       
    	clss  = factory.createClass("Variable", "CompositeStructures-StructuredActivities-Variable", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CompositeStructures.StructuredActivities", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-StructuredClasses";   
                      
        // UML.CompositeStructures.StructuredClasses.Class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.CompositeStructures.StructuredClasses").getDelegate();       
    	clss  = factory.createClass("Class", "CompositeStructures-StructuredClasses-Class", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.CompositeStructures.StructuredClasses", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Artifacts";   
                      
        // UML.Deployments.Artifacts.Artifact 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Deployments.Artifacts").getDelegate();       
    	clss  = factory.createClass("Artifact", "Deployments-Artifacts-Artifact", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Deployments.Artifacts", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Artifacts";   
                      
        // UML.Deployments.Artifacts.Manifestation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Deployments.Artifacts").getDelegate();       
    	clss  = factory.createClass("Manifestation", "Deployments-Artifacts-Manifestation", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Deployments.Artifacts", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-ComponentDeployments";   
                      
        // UML.Deployments.ComponentDeployments.Deployment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Deployments.ComponentDeployments").getDelegate();       
    	clss  = factory.createClass("Deployment", "Deployments-ComponentDeployments-Deployment", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Deployments.ComponentDeployments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-ComponentDeployments";   
                      
        // UML.Deployments.ComponentDeployments.DeploymentSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Deployments.ComponentDeployments").getDelegate();       
    	clss  = factory.createClass("DeploymentSpecification", "Deployments-ComponentDeployments-DeploymentSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Deployments.ComponentDeployments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // UML.Deployments.Nodes.Artifact 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("Artifact", "Deployments-Nodes-Artifact", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // UML.Deployments.Nodes.CommunicationPath 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("CommunicationPath", "Deployments-Nodes-CommunicationPath", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // UML.Deployments.Nodes.DeployedArtifact 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("DeployedArtifact", "Deployments-Nodes-DeployedArtifact", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // UML.Deployments.Nodes.Deployment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("Deployment", "Deployments-Nodes-Deployment", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // UML.Deployments.Nodes.DeploymentTarget 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("DeploymentTarget", "Deployments-Nodes-DeploymentTarget", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // UML.Deployments.Nodes.Device 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("Device", "Deployments-Nodes-Device", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // UML.Deployments.Nodes.ExecutionEnvironment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("ExecutionEnvironment", "Deployments-Nodes-ExecutionEnvironment", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // UML.Deployments.Nodes.InstanceSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("InstanceSpecification", "Deployments-Nodes-InstanceSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // UML.Deployments.Nodes.Node 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("Node", "Deployments-Nodes-Node", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";   
                      
        // UML.Deployments.Nodes.Property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Deployments.Nodes").getDelegate();       
    	clss  = factory.createClass("Property", "Deployments-Nodes-Property", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Deployments.Nodes", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // UML.Interactions.BasicInteractions.ActionExecutionSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("ActionExecutionSpecification", "Interactions-BasicInteractions-ActionExecutionSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // UML.Interactions.BasicInteractions.BehaviorExecutionSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("BehaviorExecutionSpecification", "Interactions-BasicInteractions-BehaviorExecutionSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // UML.Interactions.BasicInteractions.DestructionOccurrenceSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("DestructionOccurrenceSpecification", "Interactions-BasicInteractions-DestructionOccurrenceSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // UML.Interactions.BasicInteractions.ExecutionOccurrenceSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("ExecutionOccurrenceSpecification", "Interactions-BasicInteractions-ExecutionOccurrenceSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // UML.Interactions.BasicInteractions.ExecutionSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("ExecutionSpecification", "Interactions-BasicInteractions-ExecutionSpecification", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // UML.Interactions.BasicInteractions.GeneralOrdering 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("GeneralOrdering", "Interactions-BasicInteractions-GeneralOrdering", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // UML.Interactions.BasicInteractions.Interaction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("Interaction", "Interactions-BasicInteractions-Interaction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // UML.Interactions.BasicInteractions.InteractionFragment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("InteractionFragment", "Interactions-BasicInteractions-InteractionFragment", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // UML.Interactions.BasicInteractions.Lifeline 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("Lifeline", "Interactions-BasicInteractions-Lifeline", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // UML.Interactions.BasicInteractions.Message 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("Message", "Interactions-BasicInteractions-Message", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // UML.Interactions.BasicInteractions.MessageEnd 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("MessageEnd", "Interactions-BasicInteractions-MessageEnd", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // UML.Interactions.BasicInteractions.MessageOccurrenceSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("MessageOccurrenceSpecification", "Interactions-BasicInteractions-MessageOccurrenceSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // UML.Interactions.BasicInteractions.OccurrenceSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("OccurrenceSpecification", "Interactions-BasicInteractions-OccurrenceSpecification", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";   
                      
        // UML.Interactions.BasicInteractions.StateInvariant 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.BasicInteractions").getDelegate();       
    	clss  = factory.createClass("StateInvariant", "Interactions-BasicInteractions-StateInvariant", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // UML.Interactions.Fragments.CombinedFragment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("CombinedFragment", "Interactions-Fragments-CombinedFragment", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // UML.Interactions.Fragments.ConsiderIgnoreFragment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("ConsiderIgnoreFragment", "Interactions-Fragments-ConsiderIgnoreFragment", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // UML.Interactions.Fragments.Continuation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("Continuation", "Interactions-Fragments-Continuation", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // UML.Interactions.Fragments.Gate 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("Gate", "Interactions-Fragments-Gate", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // UML.Interactions.Fragments.Interaction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("Interaction", "Interactions-Fragments-Interaction", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // UML.Interactions.Fragments.InteractionConstraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("InteractionConstraint", "Interactions-Fragments-InteractionConstraint", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // UML.Interactions.Fragments.InteractionFragment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("InteractionFragment", "Interactions-Fragments-InteractionFragment", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // UML.Interactions.Fragments.InteractionOperand 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("InteractionOperand", "Interactions-Fragments-InteractionOperand", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // UML.Interactions.Fragments.InteractionUse 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("InteractionUse", "Interactions-Fragments-InteractionUse", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // UML.Interactions.Fragments.Lifeline 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("Lifeline", "Interactions-Fragments-Lifeline", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";   
                      
        // UML.Interactions.Fragments.PartDecomposition 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.Interactions.Fragments").getDelegate();       
    	clss  = factory.createClass("PartDecomposition", "Interactions-Fragments-PartDecomposition", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.Interactions.Fragments", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // UML.StateMachines.BehaviorStateMachines.ConnectionPointReference 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("ConnectionPointReference", "StateMachines-BehaviorStateMachines-ConnectionPointReference", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // UML.StateMachines.BehaviorStateMachines.FinalState 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("FinalState", "StateMachines-BehaviorStateMachines-FinalState", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // UML.StateMachines.BehaviorStateMachines.Pseudostate 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("Pseudostate", "StateMachines-BehaviorStateMachines-Pseudostate", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // UML.StateMachines.BehaviorStateMachines.Region 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("Region", "StateMachines-BehaviorStateMachines-Region", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // UML.StateMachines.BehaviorStateMachines.State 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("State", "StateMachines-BehaviorStateMachines-State", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // UML.StateMachines.BehaviorStateMachines.StateMachine 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("StateMachine", "StateMachines-BehaviorStateMachines-StateMachine", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // UML.StateMachines.BehaviorStateMachines.TimeEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("TimeEvent", "StateMachines-BehaviorStateMachines-TimeEvent", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // UML.StateMachines.BehaviorStateMachines.Transition 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("Transition", "StateMachines-BehaviorStateMachines-Transition", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";   
                      
        // UML.StateMachines.BehaviorStateMachines.Vertex 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.StateMachines.BehaviorStateMachines").getDelegate();       
    	clss  = factory.createClass("Vertex", "StateMachines-BehaviorStateMachines-Vertex", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";   
                      
        // UML.StateMachines.ProtocolStateMachines.Interface 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.StateMachines.ProtocolStateMachines").getDelegate();       
    	clss  = factory.createClass("Interface", "StateMachines-ProtocolStateMachines-Interface", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.StateMachines.ProtocolStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";   
                      
        // UML.StateMachines.ProtocolStateMachines.Port 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.StateMachines.ProtocolStateMachines").getDelegate();       
    	clss  = factory.createClass("Port", "StateMachines-ProtocolStateMachines-Port", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.StateMachines.ProtocolStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";   
                      
        // UML.StateMachines.ProtocolStateMachines.ProtocolConformance 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.StateMachines.ProtocolStateMachines").getDelegate();       
    	clss  = factory.createClass("ProtocolConformance", "StateMachines-ProtocolStateMachines-ProtocolConformance", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.StateMachines.ProtocolStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";   
                      
        // UML.StateMachines.ProtocolStateMachines.ProtocolStateMachine 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.StateMachines.ProtocolStateMachines").getDelegate();       
    	clss  = factory.createClass("ProtocolStateMachine", "StateMachines-ProtocolStateMachines-ProtocolStateMachine", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.StateMachines.ProtocolStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";   
                      
        // UML.StateMachines.ProtocolStateMachines.ProtocolTransition 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.StateMachines.ProtocolStateMachines").getDelegate();       
    	clss  = factory.createClass("ProtocolTransition", "StateMachines-ProtocolStateMachines-ProtocolTransition", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.StateMachines.ProtocolStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";   
                      
        // UML.StateMachines.ProtocolStateMachines.Region 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.StateMachines.ProtocolStateMachines").getDelegate();       
    	clss  = factory.createClass("Region", "StateMachines-ProtocolStateMachines-Region", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.StateMachines.ProtocolStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";   
                      
        // UML.StateMachines.ProtocolStateMachines.State 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.StateMachines.ProtocolStateMachines").getDelegate();       
    	clss  = factory.createClass("State", "StateMachines-ProtocolStateMachines-State", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.StateMachines.ProtocolStateMachines", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "UseCases";   
                      
        // UML.UseCases.Actor 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.UseCases").getDelegate();       
    	clss  = factory.createClass("Actor", "UseCases-Actor", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.UseCases", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "UseCases";   
                      
        // UML.UseCases.Classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.UseCases").getDelegate();       
    	clss  = factory.createClass("Classifier", "UseCases-Classifier", pkg);
    	clss.isAbstract = true;
    	((Classifier)clss).isAbstract = true;
    	mapping.mapClass(clss, "UML.UseCases", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "UseCases";   
                      
        // UML.UseCases.Extend 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.UseCases").getDelegate();       
    	clss  = factory.createClass("Extend", "UseCases-Extend", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.UseCases", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "UseCases";   
                      
        // UML.UseCases.ExtensionPoint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.UseCases").getDelegate();       
    	clss  = factory.createClass("ExtensionPoint", "UseCases-ExtensionPoint", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.UseCases", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "UseCases";   
                      
        // UML.UseCases.Include 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.UseCases").getDelegate();       
    	clss  = factory.createClass("Include", "UseCases-Include", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.UseCases", this); 
                                                      
        packageId = this.artifact.getUrn() + "#" + "UseCases";   
                      
        // UML.UseCases.UseCase 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
        //pkg = model.getPackageByQualifiedName("UML.UseCases").getDelegate();       
    	clss  = factory.createClass("UseCase", "UseCases-UseCase", pkg);
    	clss.isAbstract = false;
    	((Classifier)clss).isAbstract = false;
    	mapping.mapClass(clss, "UML.UseCases", this); 
    
    }   

    private void constructEnumerations()
    {
        Enumeration enumeration = null;
        EnumerationLiteral literal = null;
                                                      
        // ObjectNodeOrderingKind
    	enumeration  = factory.createEnumeration("ObjectNodeOrderingKind", "Activities-CompleteActivities-ObjectNodeOrderingKind");
    	mapping.mapEnumeration(enumeration, "UML.Activities.CompleteActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "unordered",
            "Activities-CompleteActivities-ObjectNodeOrderingKind-unordered");
    	mapping.mapEnumerationLiteral(literal, "UML.Activities.CompleteActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "ordered",
            "Activities-CompleteActivities-ObjectNodeOrderingKind-ordered");
    	mapping.mapEnumerationLiteral(literal, "UML.Activities.CompleteActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "LIFO",
            "Activities-CompleteActivities-ObjectNodeOrderingKind-LIFO");
    	mapping.mapEnumerationLiteral(literal, "UML.Activities.CompleteActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "FIFO",
            "Activities-CompleteActivities-ObjectNodeOrderingKind-FIFO");
    	mapping.mapEnumerationLiteral(literal, "UML.Activities.CompleteActivities", this); 
                                                          
        // ParameterEffectKind
    	enumeration  = factory.createEnumeration("ParameterEffectKind", "Activities-CompleteActivities-ParameterEffectKind");
    	mapping.mapEnumeration(enumeration, "UML.Activities.CompleteActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "create",
            "Activities-CompleteActivities-ParameterEffectKind-create");
    	mapping.mapEnumerationLiteral(literal, "UML.Activities.CompleteActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "read",
            "Activities-CompleteActivities-ParameterEffectKind-read");
    	mapping.mapEnumerationLiteral(literal, "UML.Activities.CompleteActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "update",
            "Activities-CompleteActivities-ParameterEffectKind-update");
    	mapping.mapEnumerationLiteral(literal, "UML.Activities.CompleteActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "delete",
            "Activities-CompleteActivities-ParameterEffectKind-delete");
    	mapping.mapEnumerationLiteral(literal, "UML.Activities.CompleteActivities", this); 
                                                          
        // ExpansionKind
    	enumeration  = factory.createEnumeration("ExpansionKind", "Activities-ExtraStructuredActivities-ExpansionKind");
    	mapping.mapEnumeration(enumeration, "UML.Activities.ExtraStructuredActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "parallel",
            "Activities-ExtraStructuredActivities-ExpansionKind-parallel");
    	mapping.mapEnumerationLiteral(literal, "UML.Activities.ExtraStructuredActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "iterative",
            "Activities-ExtraStructuredActivities-ExpansionKind-iterative");
    	mapping.mapEnumerationLiteral(literal, "UML.Activities.ExtraStructuredActivities", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "stream",
            "Activities-ExtraStructuredActivities-ExpansionKind-stream");
    	mapping.mapEnumerationLiteral(literal, "UML.Activities.ExtraStructuredActivities", this); 
                                                          
        // AggregationKind
    	enumeration  = factory.createEnumeration("AggregationKind", "Classes-Kernel-AggregationKind");
    	mapping.mapEnumeration(enumeration, "UML.Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "none",
            "Classes-Kernel-AggregationKind-none");
    	mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "shared",
            "Classes-Kernel-AggregationKind-shared");
    	mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "composite",
            "Classes-Kernel-AggregationKind-composite");
    	mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this); 
                                                          
        // ParameterDirectionKind
    	enumeration  = factory.createEnumeration("ParameterDirectionKind", "Classes-Kernel-ParameterDirectionKind");
    	mapping.mapEnumeration(enumeration, "UML.Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "in",
            "Classes-Kernel-ParameterDirectionKind-in");
    	mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "inout",
            "Classes-Kernel-ParameterDirectionKind-inout");
    	mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "out",
            "Classes-Kernel-ParameterDirectionKind-out");
    	mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "return",
            "Classes-Kernel-ParameterDirectionKind-return");
    	mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this); 
                                                          
        // VisibilityKind
    	enumeration  = factory.createEnumeration("VisibilityKind", "Classes-Kernel-VisibilityKind");
    	mapping.mapEnumeration(enumeration, "UML.Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "public",
            "Classes-Kernel-VisibilityKind-public");
    	mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "private",
            "Classes-Kernel-VisibilityKind-private");
    	mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "protected",
            "Classes-Kernel-VisibilityKind-protected");
    	mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "package",
            "Classes-Kernel-VisibilityKind-package");
    	mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this); 
                                                          
        // CallConcurrencyKind
    	enumeration  = factory.createEnumeration("CallConcurrencyKind", "CommonBehaviors-Communications-CallConcurrencyKind");
    	mapping.mapEnumeration(enumeration, "UML.CommonBehaviors.Communications", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "sequential",
            "CommonBehaviors-Communications-CallConcurrencyKind-sequential");
    	mapping.mapEnumerationLiteral(literal, "UML.CommonBehaviors.Communications", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "guarded",
            "CommonBehaviors-Communications-CallConcurrencyKind-guarded");
    	mapping.mapEnumerationLiteral(literal, "UML.CommonBehaviors.Communications", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "concurrent",
            "CommonBehaviors-Communications-CallConcurrencyKind-concurrent");
    	mapping.mapEnumerationLiteral(literal, "UML.CommonBehaviors.Communications", this); 
                                                          
        // ConnectorKind
    	enumeration  = factory.createEnumeration("ConnectorKind", "Components-BasicComponents-ConnectorKind");
    	mapping.mapEnumeration(enumeration, "UML.Components.BasicComponents", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "assembly",
            "Components-BasicComponents-ConnectorKind-assembly");
    	mapping.mapEnumerationLiteral(literal, "UML.Components.BasicComponents", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "delegation",
            "Components-BasicComponents-ConnectorKind-delegation");
    	mapping.mapEnumerationLiteral(literal, "UML.Components.BasicComponents", this); 
                                                          
        // MessageKind
    	enumeration  = factory.createEnumeration("MessageKind", "Interactions-BasicInteractions-MessageKind");
    	mapping.mapEnumeration(enumeration, "UML.Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "complete",
            "Interactions-BasicInteractions-MessageKind-complete");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "lost",
            "Interactions-BasicInteractions-MessageKind-lost");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "found",
            "Interactions-BasicInteractions-MessageKind-found");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "unknown",
            "Interactions-BasicInteractions-MessageKind-unknown");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this); 
                                                          
        // MessageSort
    	enumeration  = factory.createEnumeration("MessageSort", "Interactions-BasicInteractions-MessageSort");
    	mapping.mapEnumeration(enumeration, "UML.Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "synchCall",
            "Interactions-BasicInteractions-MessageSort-synchCall");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "asynchCall",
            "Interactions-BasicInteractions-MessageSort-asynchCall");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "asynchSignal",
            "Interactions-BasicInteractions-MessageSort-asynchSignal");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "createMessage",
            "Interactions-BasicInteractions-MessageSort-createMessage");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "deleteMessage",
            "Interactions-BasicInteractions-MessageSort-deleteMessage");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "reply",
            "Interactions-BasicInteractions-MessageSort-reply");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this); 
                                                          
        // InteractionOperatorKind
    	enumeration  = factory.createEnumeration("InteractionOperatorKind", "Interactions-Fragments-InteractionOperatorKind");
    	mapping.mapEnumeration(enumeration, "UML.Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "seq",
            "Interactions-Fragments-InteractionOperatorKind-seq");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "alt",
            "Interactions-Fragments-InteractionOperatorKind-alt");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "opt",
            "Interactions-Fragments-InteractionOperatorKind-opt");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "break",
            "Interactions-Fragments-InteractionOperatorKind-break");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "par",
            "Interactions-Fragments-InteractionOperatorKind-par");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "strict",
            "Interactions-Fragments-InteractionOperatorKind-strict");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "loop",
            "Interactions-Fragments-InteractionOperatorKind-loop");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "critical",
            "Interactions-Fragments-InteractionOperatorKind-critical");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "neg",
            "Interactions-Fragments-InteractionOperatorKind-neg");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "assert",
            "Interactions-Fragments-InteractionOperatorKind-assert");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "ignore",
            "Interactions-Fragments-InteractionOperatorKind-ignore");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "consider",
            "Interactions-Fragments-InteractionOperatorKind-consider");
    	mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this); 
                                                          
        // PseudostateKind
    	enumeration  = factory.createEnumeration("PseudostateKind", "StateMachines-BehaviorStateMachines-PseudostateKind");
    	mapping.mapEnumeration(enumeration, "UML.StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "initial",
            "StateMachines-BehaviorStateMachines-PseudostateKind-initial");
    	mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "deepHistory",
            "StateMachines-BehaviorStateMachines-PseudostateKind-deepHistory");
    	mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "shallowHistory",
            "StateMachines-BehaviorStateMachines-PseudostateKind-shallowHistory");
    	mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "join",
            "StateMachines-BehaviorStateMachines-PseudostateKind-join");
    	mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "fork",
            "StateMachines-BehaviorStateMachines-PseudostateKind-fork");
    	mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "junction",
            "StateMachines-BehaviorStateMachines-PseudostateKind-junction");
    	mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "choice",
            "StateMachines-BehaviorStateMachines-PseudostateKind-choice");
    	mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "entryPoint",
            "StateMachines-BehaviorStateMachines-PseudostateKind-entryPoint");
    	mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "exitPoint",
            "StateMachines-BehaviorStateMachines-PseudostateKind-exitPoint");
    	mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "terminate",
            "StateMachines-BehaviorStateMachines-PseudostateKind-terminate");
    	mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this); 
                                                          
        // TransitionKind
    	enumeration  = factory.createEnumeration("TransitionKind", "StateMachines-BehaviorStateMachines-TransitionKind");
    	mapping.mapEnumeration(enumeration, "UML.StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "internal",
            "StateMachines-BehaviorStateMachines-TransitionKind-internal");
    	mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "local",
            "StateMachines-BehaviorStateMachines-TransitionKind-local");
    	mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this); 
        
        literal = factory.createEnumerationLiteral(enumeration, 
            "external",
            "StateMachines-BehaviorStateMachines-TransitionKind-external");
    	mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this); 
        
    }   

    private void constructProperties()
    {
        Class_ clss = null;
        Property prop = null;
        
    
        // Action
    	clss  = (Class_)model.getElementById("Actions-BasicActions-Action").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "context", 
    	    "Actions-BasicActions-Action-context",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "input", 
    	    "Actions-BasicActions-Action-input",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "output", 
    	    "Actions-BasicActions-Action-output",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // CallAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-CallAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isSynchronous", 
    	    "Actions-BasicActions-CallAction-isSynchronous",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(true),
    	   "",
    	   "Actions-BasicActions-CallAction-isSynchronous-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-BasicActions-CallAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // CallBehaviorAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-CallBehaviorAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "behavior", 
    	    "Actions-BasicActions-CallBehaviorAction-behavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // CallOperationAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-CallOperationAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "operation", 
    	    "Actions-BasicActions-CallOperationAction-operation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "target", 
    	    "Actions-BasicActions-CallOperationAction-target",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InputPin
    	clss  = (Class_)model.getElementById("Actions-BasicActions-InputPin").getDelegate();
    	
        // InvocationAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-InvocationAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "argument", 
    	    "Actions-BasicActions-InvocationAction-argument",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // MultiplicityElement
    	clss  = (Class_)model.getElementById("Actions-BasicActions-MultiplicityElement").getDelegate();
    	
        // OpaqueAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-OpaqueAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "body", 
    	    "Actions-BasicActions-OpaqueAction-body",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inputValue", 
    	    "Actions-BasicActions-OpaqueAction-inputValue",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "language", 
    	    "Actions-BasicActions-OpaqueAction-language",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "outputValue", 
    	    "Actions-BasicActions-OpaqueAction-outputValue",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // OutputPin
    	clss  = (Class_)model.getElementById("Actions-BasicActions-OutputPin").getDelegate();
    	
        // Pin
    	clss  = (Class_)model.getElementById("Actions-BasicActions-Pin").getDelegate();
    	
        // SendSignalAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-SendSignalAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "signal", 
    	    "Actions-BasicActions-SendSignalAction-signal",
    	    "CommonBehaviors-Communications-Signal",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "target", 
    	    "Actions-BasicActions-SendSignalAction-target",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ValuePin
    	clss  = (Class_)model.getElementById("Actions-BasicActions-ValuePin").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Actions-BasicActions-ValuePin-value",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // AcceptCallAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-AcceptCallAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "returnInformation", 
    	    "Actions-CompleteActions-AcceptCallAction-returnInformation",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // AcceptEventAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-AcceptEventAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isUnmarshall", 
    	    "Actions-CompleteActions-AcceptEventAction-isUnmarshall",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Actions-CompleteActions-AcceptEventAction-isUnmarshall-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-CompleteActions-AcceptEventAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "trigger", 
    	    "Actions-CompleteActions-AcceptEventAction-trigger",
    	    "CommonBehaviors-Communications-Trigger",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // CreateLinkObjectAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-CreateLinkObjectAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-CompleteActions-CreateLinkObjectAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LinkEndData
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-LinkEndData").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "qualifier", 
    	    "Actions-CompleteActions-LinkEndData-qualifier",
    	    "Actions-CompleteActions-QualifierValue",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // QualifierValue
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-QualifierValue").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "qualifier", 
    	    "Actions-CompleteActions-QualifierValue-qualifier",
    	    "Classes-AssociationClasses-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Actions-CompleteActions-QualifierValue-value",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReadExtentAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReadExtentAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "classifier", 
    	    "Actions-CompleteActions-ReadExtentAction-classifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-CompleteActions-ReadExtentAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReadIsClassifiedObjectAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReadIsClassifiedObjectAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "classifier", 
    	    "Actions-CompleteActions-ReadIsClassifiedObjectAction-classifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isDirect", 
    	    "Actions-CompleteActions-ReadIsClassifiedObjectAction-isDirect",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Actions-CompleteActions-ReadIsClassifiedObjectAction-isDirect-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-CompleteActions-ReadIsClassifiedObjectAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-CompleteActions-ReadIsClassifiedObjectAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReadLinkObjectEndAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReadLinkObjectEndAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "end", 
    	    "Actions-CompleteActions-ReadLinkObjectEndAction-end",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-CompleteActions-ReadLinkObjectEndAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-CompleteActions-ReadLinkObjectEndAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReadLinkObjectEndQualifierAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReadLinkObjectEndQualifierAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "qualifier", 
    	    "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-qualifier",
    	    "Classes-AssociationClasses-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReclassifyObjectAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReclassifyObjectAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isReplaceAll", 
    	    "Actions-CompleteActions-ReclassifyObjectAction-isReplaceAll",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Actions-CompleteActions-ReclassifyObjectAction-isReplaceAll-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "newClassifier", 
    	    "Actions-CompleteActions-ReclassifyObjectAction-newClassifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-CompleteActions-ReclassifyObjectAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "oldClassifier", 
    	    "Actions-CompleteActions-ReclassifyObjectAction-oldClassifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReduceAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReduceAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "collection", 
    	    "Actions-CompleteActions-ReduceAction-collection",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isOrdered", 
    	    "Actions-CompleteActions-ReduceAction-isOrdered",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Actions-CompleteActions-ReduceAction-isOrdered-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "reducer", 
    	    "Actions-CompleteActions-ReduceAction-reducer",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-CompleteActions-ReduceAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReplyAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReplyAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "replyToCall", 
    	    "Actions-CompleteActions-ReplyAction-replyToCall",
    	    "CommonBehaviors-Communications-Trigger",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "replyValue", 
    	    "Actions-CompleteActions-ReplyAction-replyValue",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "returnInformation", 
    	    "Actions-CompleteActions-ReplyAction-returnInformation",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StartClassifierBehaviorAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-StartClassifierBehaviorAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-CompleteActions-StartClassifierBehaviorAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StartObjectBehaviorAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-StartObjectBehaviorAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-CompleteActions-StartObjectBehaviorAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // UnmarshallAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-UnmarshallAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-CompleteActions-UnmarshallAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-CompleteActions-UnmarshallAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "unmarshallType", 
    	    "Actions-CompleteActions-UnmarshallAction-unmarshallType",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // AddStructuralFeatureValueAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-AddStructuralFeatureValueAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "insertAt", 
    	    "Actions-IntermediateActions-AddStructuralFeatureValueAction-insertAt",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isReplaceAll", 
    	    "Actions-IntermediateActions-AddStructuralFeatureValueAction-isReplaceAll",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Actions-IntermediateActions-AddStructuralFeatureValueAction-isReplaceAll-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	
        // BroadcastSignalAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-BroadcastSignalAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "signal", 
    	    "Actions-IntermediateActions-BroadcastSignalAction-signal",
    	    "CommonBehaviors-Communications-Signal",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ClearAssociationAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ClearAssociationAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "association", 
    	    "Actions-IntermediateActions-ClearAssociationAction-association",
    	    "Classes-Kernel-Association",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-IntermediateActions-ClearAssociationAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ClearStructuralFeatureAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ClearStructuralFeatureAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-IntermediateActions-ClearStructuralFeatureAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // CreateLinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-CreateLinkAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "endData", 
    	    "Actions-IntermediateActions-CreateLinkAction-endData",
    	    "Actions-IntermediateActions-LinkEndCreationData",
    	    "Actions-IntermediateActions-LinkAction-endData",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "2");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // CreateObjectAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-CreateObjectAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "classifier", 
    	    "Actions-IntermediateActions-CreateObjectAction-classifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-IntermediateActions-CreateObjectAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DestroyLinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-DestroyLinkAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "endData", 
    	    "Actions-IntermediateActions-DestroyLinkAction-endData",
    	    "Actions-IntermediateActions-LinkEndDestructionData",
    	    "Actions-IntermediateActions-LinkAction-endData",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "2");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DestroyObjectAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-DestroyObjectAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isDestroyLinks", 
    	    "Actions-IntermediateActions-DestroyObjectAction-isDestroyLinks",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Actions-IntermediateActions-DestroyObjectAction-isDestroyLinks-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isDestroyOwnedObjects", 
    	    "Actions-IntermediateActions-DestroyObjectAction-isDestroyOwnedObjects",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Actions-IntermediateActions-DestroyObjectAction-isDestroyOwnedObjects-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "target", 
    	    "Actions-IntermediateActions-DestroyObjectAction-target",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-LinkAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "endData", 
    	    "Actions-IntermediateActions-LinkAction-endData",
    	    "Actions-IntermediateActions-LinkEndData",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "2");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inputValue", 
    	    "Actions-IntermediateActions-LinkAction-inputValue",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LinkEndCreationData
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-LinkEndCreationData").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "insertAt", 
    	    "Actions-IntermediateActions-LinkEndCreationData-insertAt",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isReplaceAll", 
    	    "Actions-IntermediateActions-LinkEndCreationData-isReplaceAll",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Actions-IntermediateActions-LinkEndCreationData-isReplaceAll-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	
        // LinkEndData
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-LinkEndData").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "end", 
    	    "Actions-IntermediateActions-LinkEndData-end",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Actions-IntermediateActions-LinkEndData-value",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LinkEndDestructionData
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-LinkEndDestructionData").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "destroyAt", 
    	    "Actions-IntermediateActions-LinkEndDestructionData-destroyAt",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isDestroyDuplicates", 
    	    "Actions-IntermediateActions-LinkEndDestructionData-isDestroyDuplicates",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Actions-IntermediateActions-LinkEndDestructionData-isDestroyDuplicates-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	
        // ReadLinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ReadLinkAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-IntermediateActions-ReadLinkAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReadSelfAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ReadSelfAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-IntermediateActions-ReadSelfAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReadStructuralFeatureAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ReadStructuralFeatureAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-IntermediateActions-ReadStructuralFeatureAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // RemoveStructuralFeatureValueAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-RemoveStructuralFeatureValueAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isRemoveDuplicates", 
    	    "Actions-IntermediateActions-RemoveStructuralFeatureValueAction-isRemoveDuplicates",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Actions-IntermediateActions-RemoveStructuralFeatureValueAction-isRemoveDuplicates-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "removeAt", 
    	    "Actions-IntermediateActions-RemoveStructuralFeatureValueAction-removeAt",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // SendObjectAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-SendObjectAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "request", 
    	    "Actions-IntermediateActions-SendObjectAction-request",
    	    "Actions-BasicActions-InputPin",
    	    "Actions-BasicActions-InvocationAction-argument",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "target", 
    	    "Actions-IntermediateActions-SendObjectAction-target",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StructuralFeatureAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-StructuralFeatureAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "object", 
    	    "Actions-IntermediateActions-StructuralFeatureAction-object",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "structuralFeature", 
    	    "Actions-IntermediateActions-StructuralFeatureAction-structuralFeature",
    	    "Classes-Kernel-StructuralFeature",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TestIdentityAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-TestIdentityAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "first", 
    	    "Actions-IntermediateActions-TestIdentityAction-first",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-IntermediateActions-TestIdentityAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "second", 
    	    "Actions-IntermediateActions-TestIdentityAction-second",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ValueSpecificationAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ValueSpecificationAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-IntermediateActions-ValueSpecificationAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Actions-IntermediateActions-ValueSpecificationAction-value",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // WriteLinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-WriteLinkAction").getDelegate();
    	
        // WriteStructuralFeatureAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-WriteStructuralFeatureAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-IntermediateActions-WriteStructuralFeatureAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Actions-IntermediateActions-WriteStructuralFeatureAction-value",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActionInputPin
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-ActionInputPin").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "fromAction", 
    	    "Actions-StructuredActions-ActionInputPin-fromAction",
    	    "Actions-BasicActions-Action",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // AddVariableValueAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-AddVariableValueAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "insertAt", 
    	    "Actions-StructuredActions-AddVariableValueAction-insertAt",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isReplaceAll", 
    	    "Actions-StructuredActions-AddVariableValueAction-isReplaceAll",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Actions-StructuredActions-AddVariableValueAction-isReplaceAll-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	
        // ClearVariableAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-ClearVariableAction").getDelegate();
    	
        // RaiseExceptionAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-RaiseExceptionAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "exception", 
    	    "Actions-StructuredActions-RaiseExceptionAction-exception",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ReadVariableAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-ReadVariableAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Actions-StructuredActions-ReadVariableAction-result",
    	    "Actions-BasicActions-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // RemoveVariableValueAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-RemoveVariableValueAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isRemoveDuplicates", 
    	    "Actions-StructuredActions-RemoveVariableValueAction-isRemoveDuplicates",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Actions-StructuredActions-RemoveVariableValueAction-isRemoveDuplicates-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "removeAt", 
    	    "Actions-StructuredActions-RemoveVariableValueAction-removeAt",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // VariableAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-VariableAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "variable", 
    	    "Actions-StructuredActions-VariableAction-variable",
    	    "Activities-StructuredActivities-Variable",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // WriteVariableAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-WriteVariableAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Actions-StructuredActions-WriteVariableAction-value",
    	    "Actions-BasicActions-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-Activity").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "edge", 
    	    "Activities-BasicActivities-Activity-edge",
    	    "Activities-BasicActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isReadOnly", 
    	    "Activities-BasicActivities-Activity-isReadOnly",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Activities-BasicActivities-Activity-isReadOnly-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	
        // ActivityEdge
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityEdge").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "activity", 
    	    "Activities-BasicActivities-ActivityEdge-activity",
    	    "Activities-BasicActivities-Activity",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inGroup", 
    	    "Activities-BasicActivities-ActivityEdge-inGroup",
    	    "Activities-BasicActivities-ActivityGroup",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedEdge", 
    	    "Activities-BasicActivities-ActivityEdge-redefinedEdge",
    	    "Activities-BasicActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "source", 
    	    "Activities-BasicActivities-ActivityEdge-source",
    	    "Activities-BasicActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "target", 
    	    "Activities-BasicActivities-ActivityEdge-target",
    	    "Activities-BasicActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityFinalNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityFinalNode").getDelegate();
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityGroup").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "containedEdge", 
    	    "Activities-BasicActivities-ActivityGroup-containedEdge",
    	    "Activities-BasicActivities-ActivityEdge",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "incoming", 
    	    "Activities-BasicActivities-ActivityNode-incoming",
    	    "Activities-BasicActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "outgoing", 
    	    "Activities-BasicActivities-ActivityNode-outgoing",
    	    "Activities-BasicActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedNode", 
    	    "Activities-BasicActivities-ActivityNode-redefinedNode",
    	    "Activities-BasicActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityParameterNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityParameterNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "parameter", 
    	    "Activities-BasicActivities-ActivityParameterNode-parameter",
    	    "Classes-Kernel-Parameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ControlFlow
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ControlFlow").getDelegate();
    	
        // ControlNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ControlNode").getDelegate();
    	
        // InitialNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-InitialNode").getDelegate();
    	
        // ObjectFlow
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ObjectFlow").getDelegate();
    	
        // ObjectNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ObjectNode").getDelegate();
    	
        // Pin
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-Pin").getDelegate();
    	
        // ValuePin
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ValuePin").getDelegate();
    	
        // Action
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Action").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "localPostcondition", 
    	    "Activities-CompleteActivities-Action-localPostcondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "localPrecondition", 
    	    "Activities-CompleteActivities-Action-localPrecondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Activity").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isSingleExecution", 
    	    "Activities-CompleteActivities-Activity-isSingleExecution",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Activities-CompleteActivities-Activity-isSingleExecution-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	
        // ActivityEdge
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ActivityEdge").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "interrupts", 
    	    "Activities-CompleteActivities-ActivityEdge-interrupts",
    	    "Activities-CompleteActivities-InterruptibleActivityRegion",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "weight", 
    	    "Activities-CompleteActivities-ActivityEdge-weight",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ActivityGroup").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "containedNode", 
    	    "Activities-CompleteActivities-ActivityGroup-containedNode",
    	    "Activities-CompleteActivities-ActivityNode",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ActivityNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "inGroup", 
    	    "Activities-CompleteActivities-ActivityNode-inGroup",
    	    "Activities-CompleteActivities-ActivityGroup",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inInterruptibleRegion", 
    	    "Activities-CompleteActivities-ActivityNode-inInterruptibleRegion",
    	    "Activities-CompleteActivities-InterruptibleActivityRegion",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Behavior
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Behavior").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedParameterSet", 
    	    "Activities-CompleteActivities-Behavior-ownedParameterSet",
    	    "Activities-CompleteActivities-ParameterSet",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // BehavioralFeature
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-BehavioralFeature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedParameterSet", 
    	    "Activities-CompleteActivities-BehavioralFeature-ownedParameterSet",
    	    "Activities-CompleteActivities-ParameterSet",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DataStoreNode
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-DataStoreNode").getDelegate();
    	
        // InterruptibleActivityRegion
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-InterruptibleActivityRegion").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "interruptingEdge", 
    	    "Activities-CompleteActivities-InterruptibleActivityRegion-interruptingEdge",
    	    "Activities-CompleteActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "node", 
    	    "Activities-CompleteActivities-InterruptibleActivityRegion-node",
    	    "Activities-CompleteActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // JoinNode
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-JoinNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isCombineDuplicate", 
    	    "Activities-CompleteActivities-JoinNode-isCombineDuplicate",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(true),
    	   "",
    	   "Activities-CompleteActivities-JoinNode-isCombineDuplicate-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "joinSpec", 
    	    "Activities-CompleteActivities-JoinNode-joinSpec",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ObjectFlow
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ObjectFlow").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isMulticast", 
    	    "Activities-CompleteActivities-ObjectFlow-isMulticast",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Activities-CompleteActivities-ObjectFlow-isMulticast-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isMultireceive", 
    	    "Activities-CompleteActivities-ObjectFlow-isMultireceive",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Activities-CompleteActivities-ObjectFlow-isMultireceive-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "selection", 
    	    "Activities-CompleteActivities-ObjectFlow-selection",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "transformation", 
    	    "Activities-CompleteActivities-ObjectFlow-transformation",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ObjectNode
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ObjectNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "inState", 
    	    "Activities-CompleteActivities-ObjectNode-inState",
    	    "StateMachines-BehaviorStateMachines-State",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isControlType", 
    	    "Activities-CompleteActivities-ObjectNode-isControlType",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Activities-CompleteActivities-ObjectNode-isControlType-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "ordering", 
    	    "Activities-CompleteActivities-ObjectNode-ordering",
    	    "Activities-CompleteActivities-ObjectNodeOrderingKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String(""),
    	   "Activities-CompleteActivities-ObjectNodeOrderingKind-FIFO",
    	   "Activities-CompleteActivities-ObjectNode-ordering-_defaultValue",  
    	   "uml:InstanceValue",  
    	   "Activities-CompleteActivities-ObjectNodeOrderingKind");
    	    	
    	prop = factory.createProperty(clss, "selection", 
    	    "Activities-CompleteActivities-ObjectNode-selection",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "upperBound", 
    	    "Activities-CompleteActivities-ObjectNode-upperBound",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Parameter
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Parameter").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "effect", 
    	    "Activities-CompleteActivities-Parameter-effect",
    	    "Activities-CompleteActivities-ParameterEffectKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isException", 
    	    "Activities-CompleteActivities-Parameter-isException",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Activities-CompleteActivities-Parameter-isException-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isStream", 
    	    "Activities-CompleteActivities-Parameter-isStream",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Activities-CompleteActivities-Parameter-isStream-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "parameterSet", 
    	    "Activities-CompleteActivities-Parameter-parameterSet",
    	    "Activities-CompleteActivities-ParameterSet",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ParameterSet
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ParameterSet").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "condition", 
    	    "Activities-CompleteActivities-ParameterSet-condition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "parameter", 
    	    "Activities-CompleteActivities-ParameterSet-parameter",
    	    "Activities-CompleteActivities-Parameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Pin
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Pin").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isControl", 
    	    "Activities-CompleteActivities-Pin-isControl",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Activities-CompleteActivities-Pin-isControl-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	
        // Action
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-Action").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "input", 
    	    "Activities-CompleteStructuredActivities-Action-input",
    	    "Activities-CompleteStructuredActivities-InputPin",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "output", 
    	    "Activities-CompleteStructuredActivities-Action-output",
    	    "Activities-CompleteStructuredActivities-OutputPin",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityEdge
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-ActivityEdge").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "inGroup", 
    	    "Activities-CompleteStructuredActivities-ActivityEdge-inGroup",
    	    "Activities-CompleteStructuredActivities-ActivityGroup",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inStructuredNode", 
    	    "Activities-CompleteStructuredActivities-ActivityEdge-inStructuredNode",
    	    "Activities-CompleteStructuredActivities-StructuredActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-ActivityGroup").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "containedEdge", 
    	    "Activities-CompleteStructuredActivities-ActivityGroup-containedEdge",
    	    "Activities-CompleteStructuredActivities-ActivityEdge",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Clause
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-Clause").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "bodyOutput", 
    	    "Activities-CompleteStructuredActivities-Clause-bodyOutput",
    	    "Activities-CompleteStructuredActivities-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConditionalNode
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-ConditionalNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Activities-CompleteStructuredActivities-ConditionalNode-result",
    	    "Activities-CompleteStructuredActivities-OutputPin",
    	    "Activities-CompleteStructuredActivities-StructuredActivityNode-structuredNodeOutput",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InputPin
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-InputPin").getDelegate();
    	
        // LoopNode
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-LoopNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "bodyOutput", 
    	    "Activities-CompleteStructuredActivities-LoopNode-bodyOutput",
    	    "Activities-CompleteStructuredActivities-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "loopVariable", 
    	    "Activities-CompleteStructuredActivities-LoopNode-loopVariable",
    	    "Activities-CompleteStructuredActivities-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "loopVariableInput", 
    	    "Activities-CompleteStructuredActivities-LoopNode-loopVariableInput",
    	    "Activities-CompleteStructuredActivities-InputPin",
    	    "Activities-CompleteStructuredActivities-StructuredActivityNode-structuredNodeInput",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "Activities-CompleteStructuredActivities-LoopNode-result",
    	    "Activities-CompleteStructuredActivities-OutputPin",
    	    "Activities-CompleteStructuredActivities-StructuredActivityNode-structuredNodeOutput",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // OutputPin
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-OutputPin").getDelegate();
    	
        // StructuredActivityNode
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-StructuredActivityNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "edge", 
    	    "Activities-CompleteStructuredActivities-StructuredActivityNode-edge",
    	    "Activities-CompleteStructuredActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "mustIsolate", 
    	    "Activities-CompleteStructuredActivities-StructuredActivityNode-mustIsolate",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Activities-CompleteStructuredActivities-StructuredActivityNode-mustIsolate-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "structuredNodeInput", 
    	    "Activities-CompleteStructuredActivities-StructuredActivityNode-structuredNodeInput",
    	    "Activities-CompleteStructuredActivities-InputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "structuredNodeOutput", 
    	    "Activities-CompleteStructuredActivities-StructuredActivityNode-structuredNodeOutput",
    	    "Activities-CompleteStructuredActivities-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ExceptionHandler
    	clss  = (Class_)model.getElementById("Activities-ExtraStructuredActivities-ExceptionHandler").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "exceptionInput", 
    	    "Activities-ExtraStructuredActivities-ExceptionHandler-exceptionInput",
    	    "Activities-BasicActivities-ObjectNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "exceptionType", 
    	    "Activities-ExtraStructuredActivities-ExceptionHandler-exceptionType",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "handlerBody", 
    	    "Activities-ExtraStructuredActivities-ExceptionHandler-handlerBody",
    	    "Activities-ExtraStructuredActivities-ExecutableNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "protectedNode", 
    	    "Activities-ExtraStructuredActivities-ExceptionHandler-protectedNode",
    	    "Activities-ExtraStructuredActivities-ExecutableNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ExecutableNode
    	clss  = (Class_)model.getElementById("Activities-ExtraStructuredActivities-ExecutableNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "handler", 
    	    "Activities-ExtraStructuredActivities-ExecutableNode-handler",
    	    "Activities-ExtraStructuredActivities-ExceptionHandler",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ExpansionNode
    	clss  = (Class_)model.getElementById("Activities-ExtraStructuredActivities-ExpansionNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "regionAsInput", 
    	    "Activities-ExtraStructuredActivities-ExpansionNode-regionAsInput",
    	    "Activities-ExtraStructuredActivities-ExpansionRegion",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "regionAsOutput", 
    	    "Activities-ExtraStructuredActivities-ExpansionNode-regionAsOutput",
    	    "Activities-ExtraStructuredActivities-ExpansionRegion",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ExpansionRegion
    	clss  = (Class_)model.getElementById("Activities-ExtraStructuredActivities-ExpansionRegion").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "inputElement", 
    	    "Activities-ExtraStructuredActivities-ExpansionRegion-inputElement",
    	    "Activities-ExtraStructuredActivities-ExpansionNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "mode", 
    	    "Activities-ExtraStructuredActivities-ExpansionRegion-mode",
    	    "Activities-ExtraStructuredActivities-ExpansionKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String(""),
    	   "Activities-ExtraStructuredActivities-ExpansionKind-iterative",
    	   "Activities-ExtraStructuredActivities-ExpansionRegion-mode-_defaultValue",  
    	   "uml:InstanceValue",  
    	   "Activities-ExtraStructuredActivities-ExpansionKind");
    	    	
    	prop = factory.createProperty(clss, "outputElement", 
    	    "Activities-ExtraStructuredActivities-ExpansionRegion-outputElement",
    	    "Activities-ExtraStructuredActivities-ExpansionNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Action
    	clss  = (Class_)model.getElementById("Activities-FundamentalActivities-Action").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isLocallyReentrant", 
    	    "Activities-FundamentalActivities-Action-isLocallyReentrant",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Activities-FundamentalActivities-Action-isLocallyReentrant-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-FundamentalActivities-Activity").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "group", 
    	    "Activities-FundamentalActivities-Activity-group",
    	    "Activities-FundamentalActivities-ActivityGroup",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "node", 
    	    "Activities-FundamentalActivities-Activity-node",
    	    "Activities-FundamentalActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-FundamentalActivities-ActivityGroup").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "containedNode", 
    	    "Activities-FundamentalActivities-ActivityGroup-containedNode",
    	    "Activities-FundamentalActivities-ActivityNode",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inActivity", 
    	    "Activities-FundamentalActivities-ActivityGroup-inActivity",
    	    "Activities-FundamentalActivities-Activity",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "subgroup", 
    	    "Activities-FundamentalActivities-ActivityGroup-subgroup",
    	    "Activities-FundamentalActivities-ActivityGroup",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "superGroup", 
    	    "Activities-FundamentalActivities-ActivityGroup-superGroup",
    	    "Activities-FundamentalActivities-ActivityGroup",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-FundamentalActivities-ActivityNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "activity", 
    	    "Activities-FundamentalActivities-ActivityNode-activity",
    	    "Activities-FundamentalActivities-Activity",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inGroup", 
    	    "Activities-FundamentalActivities-ActivityNode-inGroup",
    	    "Activities-FundamentalActivities-ActivityGroup",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-Activity").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "group", 
    	    "Activities-IntermediateActivities-Activity-group",
    	    "Activities-IntermediateActivities-ActivityGroup",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "partition", 
    	    "Activities-IntermediateActivities-Activity-partition",
    	    "Activities-IntermediateActivities-ActivityPartition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityEdge
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityEdge").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "guard", 
    	    "Activities-IntermediateActivities-ActivityEdge-guard",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inGroup", 
    	    "Activities-IntermediateActivities-ActivityEdge-inGroup",
    	    "Activities-IntermediateActivities-ActivityGroup",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inPartition", 
    	    "Activities-IntermediateActivities-ActivityEdge-inPartition",
    	    "Activities-IntermediateActivities-ActivityPartition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityFinalNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityFinalNode").getDelegate();
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityGroup").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "containedEdge", 
    	    "Activities-IntermediateActivities-ActivityGroup-containedEdge",
    	    "Activities-IntermediateActivities-ActivityEdge",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "containedNode", 
    	    "Activities-IntermediateActivities-ActivityGroup-containedNode",
    	    "Activities-IntermediateActivities-ActivityNode",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inActivity", 
    	    "Activities-IntermediateActivities-ActivityGroup-inActivity",
    	    "Activities-IntermediateActivities-Activity",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "subgroup", 
    	    "Activities-IntermediateActivities-ActivityGroup-subgroup",
    	    "Activities-IntermediateActivities-ActivityGroup",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "superGroup", 
    	    "Activities-IntermediateActivities-ActivityGroup-superGroup",
    	    "Activities-IntermediateActivities-ActivityGroup",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "inGroup", 
    	    "Activities-IntermediateActivities-ActivityNode-inGroup",
    	    "Activities-IntermediateActivities-ActivityGroup",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inPartition", 
    	    "Activities-IntermediateActivities-ActivityNode-inPartition",
    	    "Activities-IntermediateActivities-ActivityPartition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityPartition
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityPartition").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "edge", 
    	    "Activities-IntermediateActivities-ActivityPartition-edge",
    	    "Activities-IntermediateActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isDimension", 
    	    "Activities-IntermediateActivities-ActivityPartition-isDimension",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Activities-IntermediateActivities-ActivityPartition-isDimension-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isExternal", 
    	    "Activities-IntermediateActivities-ActivityPartition-isExternal",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Activities-IntermediateActivities-ActivityPartition-isExternal-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "node", 
    	    "Activities-IntermediateActivities-ActivityPartition-node",
    	    "Activities-IntermediateActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "represents", 
    	    "Activities-IntermediateActivities-ActivityPartition-represents",
    	    "Classes-Kernel-Element",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "subpartition", 
    	    "Activities-IntermediateActivities-ActivityPartition-subpartition",
    	    "Activities-IntermediateActivities-ActivityPartition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "superPartition", 
    	    "Activities-IntermediateActivities-ActivityPartition-superPartition",
    	    "Activities-IntermediateActivities-ActivityPartition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // CentralBufferNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-CentralBufferNode").getDelegate();
    	
        // DecisionNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-DecisionNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "decisionInput", 
    	    "Activities-IntermediateActivities-DecisionNode-decisionInput",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "decisionInputFlow", 
    	    "Activities-IntermediateActivities-DecisionNode-decisionInputFlow",
    	    "Activities-BasicActivities-ObjectFlow",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // FinalNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-FinalNode").getDelegate();
    	
        // FlowFinalNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-FlowFinalNode").getDelegate();
    	
        // ForkNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ForkNode").getDelegate();
    	
        // JoinNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-JoinNode").getDelegate();
    	
        // MergeNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-MergeNode").getDelegate();
    	
        // Action
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-Action").getDelegate();
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-Activity").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "group", 
    	    "Activities-StructuredActivities-Activity-group",
    	    "Activities-StructuredActivities-ActivityGroup",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "node", 
    	    "Activities-StructuredActivities-Activity-node",
    	    "Activities-StructuredActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "structuredNode", 
    	    "Activities-StructuredActivities-Activity-structuredNode",
    	    "Activities-StructuredActivities-StructuredActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "variable", 
    	    "Activities-StructuredActivities-Activity-variable",
    	    "Activities-StructuredActivities-Variable",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-ActivityGroup").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "containedNode", 
    	    "Activities-StructuredActivities-ActivityGroup-containedNode",
    	    "Activities-StructuredActivities-ActivityNode",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inActivity", 
    	    "Activities-StructuredActivities-ActivityGroup-inActivity",
    	    "Activities-StructuredActivities-Activity",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-ActivityNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "activity", 
    	    "Activities-StructuredActivities-ActivityNode-activity",
    	    "Activities-StructuredActivities-Activity",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inGroup", 
    	    "Activities-StructuredActivities-ActivityNode-inGroup",
    	    "Activities-StructuredActivities-ActivityGroup",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inStructuredNode", 
    	    "Activities-StructuredActivities-ActivityNode-inStructuredNode",
    	    "Activities-StructuredActivities-StructuredActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Clause
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-Clause").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "body", 
    	    "Activities-StructuredActivities-Clause-body",
    	    "Activities-StructuredActivities-ExecutableNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "decider", 
    	    "Activities-StructuredActivities-Clause-decider",
    	    "Activities-StructuredActivities-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "predecessorClause", 
    	    "Activities-StructuredActivities-Clause-predecessorClause",
    	    "Activities-StructuredActivities-Clause",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "successorClause", 
    	    "Activities-StructuredActivities-Clause-successorClause",
    	    "Activities-StructuredActivities-Clause",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "test", 
    	    "Activities-StructuredActivities-Clause-test",
    	    "Activities-StructuredActivities-ExecutableNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConditionalNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-ConditionalNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "clause", 
    	    "Activities-StructuredActivities-ConditionalNode-clause",
    	    "Activities-StructuredActivities-Clause",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isAssured", 
    	    "Activities-StructuredActivities-ConditionalNode-isAssured",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Activities-StructuredActivities-ConditionalNode-isAssured-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isDeterminate", 
    	    "Activities-StructuredActivities-ConditionalNode-isDeterminate",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Activities-StructuredActivities-ConditionalNode-isDeterminate-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	
        // ExecutableNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-ExecutableNode").getDelegate();
    	
        // LoopNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-LoopNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "bodyPart", 
    	    "Activities-StructuredActivities-LoopNode-bodyPart",
    	    "Activities-StructuredActivities-ExecutableNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "decider", 
    	    "Activities-StructuredActivities-LoopNode-decider",
    	    "Activities-StructuredActivities-OutputPin",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isTestedFirst", 
    	    "Activities-StructuredActivities-LoopNode-isTestedFirst",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Activities-StructuredActivities-LoopNode-isTestedFirst-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "setupPart", 
    	    "Activities-StructuredActivities-LoopNode-setupPart",
    	    "Activities-StructuredActivities-ExecutableNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "test", 
    	    "Activities-StructuredActivities-LoopNode-test",
    	    "Activities-StructuredActivities-ExecutableNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // OutputPin
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-OutputPin").getDelegate();
    	
        // SequenceNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-SequenceNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "executableNode", 
    	    "Activities-StructuredActivities-SequenceNode-executableNode",
    	    "Activities-StructuredActivities-ExecutableNode",
    	    "Activities-StructuredActivities-StructuredActivityNode-node",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StructuredActivityNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-StructuredActivityNode").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "activity", 
    	    "Activities-StructuredActivities-StructuredActivityNode-activity",
    	    "Activities-StructuredActivities-Activity",
    	    "Activities-StructuredActivities-ActivityGroup-inActivity Activities-StructuredActivities-ActivityNode-activity",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "node", 
    	    "Activities-StructuredActivities-StructuredActivityNode-node",
    	    "Activities-StructuredActivities-ActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "variable", 
    	    "Activities-StructuredActivities-StructuredActivityNode-variable",
    	    "Activities-StructuredActivities-Variable",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Variable
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-Variable").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "activityScope", 
    	    "Activities-StructuredActivities-Variable-activityScope",
    	    "Activities-StructuredActivities-Activity",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "scope", 
    	    "Activities-StructuredActivities-Variable-scope",
    	    "Activities-StructuredActivities-StructuredActivityNode",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InformationFlow
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-InformationFlows-InformationFlow").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "conveyed", 
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow-conveyed",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "informationSource", 
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow-informationSource",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "informationTarget", 
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow-informationTarget",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "realization", 
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow-realization",
    	    "Classes-Kernel-Relationship",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "realizingActivityEdge", 
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingActivityEdge",
    	    "Activities-BasicActivities-ActivityEdge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "realizingConnector", 
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingConnector",
    	    "CompositeStructures-InternalStructures-Connector",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "realizingMessage", 
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingMessage",
    	    "Interactions-BasicInteractions-Message",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InformationItem
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-InformationFlows-InformationItem").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "represented", 
    	    "AuxiliaryConstructs-InformationFlows-InformationItem-represented",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Model
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Models-Model").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "viewpoint", 
    	    "AuxiliaryConstructs-Models-Model-viewpoint",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ExtensionEnd
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Profiles-ExtensionEnd").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "lower", 
    	    "AuxiliaryConstructs-Profiles-ExtensionEnd-lower",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Integer",
    	    "",    	    
    		false, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Classifier
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-Classifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedTemplateSignature", 
    	    "AuxiliaryConstructs-Templates-Classifier-ownedTemplateSignature",
    	    "AuxiliaryConstructs-Templates-RedefinableTemplateSignature",
    	    "AuxiliaryConstructs-Templates-TemplateableElement-ownedTemplateSignature",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "templateParameter", 
    	    "AuxiliaryConstructs-Templates-Classifier-templateParameter",
    	    "AuxiliaryConstructs-Templates-ClassifierTemplateParameter",
    	    "AuxiliaryConstructs-Templates-ParameterableElement-templateParameter",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ClassifierTemplateParameter
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ClassifierTemplateParameter").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "allowSubstitutable", 
    	    "AuxiliaryConstructs-Templates-ClassifierTemplateParameter-allowSubstitutable",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(true),
    	   "",
    	   "AuxiliaryConstructs-Templates-ClassifierTemplateParameter-allowSubstitutable-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "constrainingClassifier", 
    	    "AuxiliaryConstructs-Templates-ClassifierTemplateParameter-constrainingClassifier",
    	    "AuxiliaryConstructs-Templates-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "parameteredElement", 
    	    "AuxiliaryConstructs-Templates-ClassifierTemplateParameter-parameteredElement",
    	    "AuxiliaryConstructs-Templates-Classifier",
    	    "AuxiliaryConstructs-Templates-TemplateParameter-parameteredElement",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConnectableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ConnectableElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "templateParameter", 
    	    "AuxiliaryConstructs-Templates-ConnectableElement-templateParameter",
    	    "AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter",
    	    "AuxiliaryConstructs-Templates-ParameterableElement-templateParameter",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConnectableElementTemplateParameter
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "parameteredElement", 
    	    "AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter-parameteredElement",
    	    "AuxiliaryConstructs-Templates-ConnectableElement",
    	    "AuxiliaryConstructs-Templates-TemplateParameter-parameteredElement",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // NamedElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-NamedElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "nameExpression", 
    	    "AuxiliaryConstructs-Templates-NamedElement-nameExpression",
    	    "AuxiliaryConstructs-Templates-StringExpression",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Operation
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-Operation").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "templateParameter", 
    	    "AuxiliaryConstructs-Templates-Operation-templateParameter",
    	    "AuxiliaryConstructs-Templates-OperationTemplateParameter",
    	    "AuxiliaryConstructs-Templates-ParameterableElement-templateParameter",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // OperationTemplateParameter
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-OperationTemplateParameter").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "parameteredElement", 
    	    "AuxiliaryConstructs-Templates-OperationTemplateParameter-parameteredElement",
    	    "AuxiliaryConstructs-Templates-Operation",
    	    "AuxiliaryConstructs-Templates-TemplateParameter-parameteredElement",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Package
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-Package").getDelegate();
    	
        // PackageableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-PackageableElement").getDelegate();
    	
        // ParameterableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ParameterableElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "owningTemplateParameter", 
    	    "AuxiliaryConstructs-Templates-ParameterableElement-owningTemplateParameter",
    	    "AuxiliaryConstructs-Templates-TemplateParameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "templateParameter", 
    	    "AuxiliaryConstructs-Templates-ParameterableElement-templateParameter",
    	    "AuxiliaryConstructs-Templates-TemplateParameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Property
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-Property").getDelegate();
    	
        // RedefinableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-RedefinableElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "redefinitionContext", 
    	    "AuxiliaryConstructs-Templates-RedefinableElement-redefinitionContext",
    	    "AuxiliaryConstructs-Templates-Classifier",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // RedefinableTemplateSignature
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-RedefinableTemplateSignature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "classifier", 
    	    "AuxiliaryConstructs-Templates-RedefinableTemplateSignature-classifier",
    	    "AuxiliaryConstructs-Templates-Classifier",
    	    "AuxiliaryConstructs-Templates-TemplateSignature-template",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "extendedSignature", 
    	    "AuxiliaryConstructs-Templates-RedefinableTemplateSignature-extendedSignature",
    	    "AuxiliaryConstructs-Templates-RedefinableTemplateSignature",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inheritedParameter", 
    	    "AuxiliaryConstructs-Templates-RedefinableTemplateSignature-inheritedParameter",
    	    "AuxiliaryConstructs-Templates-TemplateParameter",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StringExpression
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-StringExpression").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "owningExpression", 
    	    "AuxiliaryConstructs-Templates-StringExpression-owningExpression",
    	    "AuxiliaryConstructs-Templates-StringExpression",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "subExpression", 
    	    "AuxiliaryConstructs-Templates-StringExpression-subExpression",
    	    "AuxiliaryConstructs-Templates-StringExpression",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TemplateBinding
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateBinding").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "boundElement", 
    	    "AuxiliaryConstructs-Templates-TemplateBinding-boundElement",
    	    "AuxiliaryConstructs-Templates-TemplateableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "parameterSubstitution", 
    	    "AuxiliaryConstructs-Templates-TemplateBinding-parameterSubstitution",
    	    "AuxiliaryConstructs-Templates-TemplateParameterSubstitution",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "signature", 
    	    "AuxiliaryConstructs-Templates-TemplateBinding-signature",
    	    "AuxiliaryConstructs-Templates-TemplateSignature",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TemplateParameter
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateParameter").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "default", 
    	    "AuxiliaryConstructs-Templates-TemplateParameter-default",
    	    "AuxiliaryConstructs-Templates-ParameterableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedDefault", 
    	    "AuxiliaryConstructs-Templates-TemplateParameter-ownedDefault",
    	    "AuxiliaryConstructs-Templates-ParameterableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedParameteredElement", 
    	    "AuxiliaryConstructs-Templates-TemplateParameter-ownedParameteredElement",
    	    "AuxiliaryConstructs-Templates-ParameterableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "parameteredElement", 
    	    "AuxiliaryConstructs-Templates-TemplateParameter-parameteredElement",
    	    "AuxiliaryConstructs-Templates-ParameterableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "signature", 
    	    "AuxiliaryConstructs-Templates-TemplateParameter-signature",
    	    "AuxiliaryConstructs-Templates-TemplateSignature",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TemplateParameterSubstitution
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateParameterSubstitution").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "actual", 
    	    "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-actual",
    	    "AuxiliaryConstructs-Templates-ParameterableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "formal", 
    	    "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-formal",
    	    "AuxiliaryConstructs-Templates-TemplateParameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedActual", 
    	    "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-ownedActual",
    	    "AuxiliaryConstructs-Templates-ParameterableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "templateBinding", 
    	    "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-templateBinding",
    	    "AuxiliaryConstructs-Templates-TemplateBinding",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TemplateSignature
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateSignature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedParameter", 
    	    "AuxiliaryConstructs-Templates-TemplateSignature-ownedParameter",
    	    "AuxiliaryConstructs-Templates-TemplateParameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "parameter", 
    	    "AuxiliaryConstructs-Templates-TemplateSignature-parameter",
    	    "AuxiliaryConstructs-Templates-TemplateParameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "template", 
    	    "AuxiliaryConstructs-Templates-TemplateSignature-template",
    	    "AuxiliaryConstructs-Templates-TemplateableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TemplateableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateableElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedTemplateSignature", 
    	    "AuxiliaryConstructs-Templates-TemplateableElement-ownedTemplateSignature",
    	    "AuxiliaryConstructs-Templates-TemplateSignature",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "templateBinding", 
    	    "AuxiliaryConstructs-Templates-TemplateableElement-templateBinding",
    	    "AuxiliaryConstructs-Templates-TemplateBinding",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ValueSpecification
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ValueSpecification").getDelegate();
    	
        // AssociationClass
    	clss  = (Class_)model.getElementById("Classes-AssociationClasses-AssociationClass").getDelegate();
    	
        // Property
    	clss  = (Class_)model.getElementById("Classes-AssociationClasses-Property").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "associationEnd", 
    	    "Classes-AssociationClasses-Property-associationEnd",
    	    "Classes-AssociationClasses-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "qualifier", 
    	    "Classes-AssociationClasses-Property-qualifier",
    	    "Classes-AssociationClasses-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Abstraction
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Abstraction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "mapping", 
    	    "Classes-Dependencies-Abstraction-mapping",
    	    "Classes-Kernel-OpaqueExpression",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Classifier
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Classifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "substitution", 
    	    "Classes-Dependencies-Classifier-substitution",
    	    "Classes-Dependencies-Substitution",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Dependency
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Dependency").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "client", 
    	    "Classes-Dependencies-Dependency-client",
    	    "Classes-Dependencies-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "supplier", 
    	    "Classes-Dependencies-Dependency-supplier",
    	    "Classes-Dependencies-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // NamedElement
    	clss  = (Class_)model.getElementById("Classes-Dependencies-NamedElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "clientDependency", 
    	    "Classes-Dependencies-NamedElement-clientDependency",
    	    "Classes-Dependencies-Dependency",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "namespace", 
    	    "Classes-Dependencies-NamedElement-namespace",
    	    "Classes-Dependencies-Namespace",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Namespace
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Namespace").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedMember", 
    	    "Classes-Dependencies-Namespace-ownedMember",
    	    "Classes-Dependencies-NamedElement",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // PackageableElement
    	clss  = (Class_)model.getElementById("Classes-Dependencies-PackageableElement").getDelegate();
    	
        // Realization
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Realization").getDelegate();
    	
        // Substitution
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Substitution").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "contract", 
    	    "Classes-Dependencies-Substitution-contract",
    	    "Classes-Dependencies-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "substitutingClassifier", 
    	    "Classes-Dependencies-Substitution-substitutingClassifier",
    	    "Classes-Dependencies-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Usage
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Usage").getDelegate();
    	
        // BehavioredClassifier
    	clss  = (Class_)model.getElementById("Classes-Interfaces-BehavioredClassifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "interfaceRealization", 
    	    "Classes-Interfaces-BehavioredClassifier-interfaceRealization",
    	    "Classes-Interfaces-InterfaceRealization",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Classifier
    	clss  = (Class_)model.getElementById("Classes-Interfaces-Classifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "attribute", 
    	    "Classes-Interfaces-Classifier-attribute",
    	    "Classes-Interfaces-Property",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Interface
    	clss  = (Class_)model.getElementById("Classes-Interfaces-Interface").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "nestedClassifier", 
    	    "Classes-Interfaces-Interface-nestedClassifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedAttribute", 
    	    "Classes-Interfaces-Interface-ownedAttribute",
    	    "Classes-Interfaces-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedOperation", 
    	    "Classes-Interfaces-Interface-ownedOperation",
    	    "Classes-Interfaces-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedInterface", 
    	    "Classes-Interfaces-Interface-redefinedInterface",
    	    "Classes-Interfaces-Interface",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InterfaceRealization
    	clss  = (Class_)model.getElementById("Classes-Interfaces-InterfaceRealization").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "contract", 
    	    "Classes-Interfaces-InterfaceRealization-contract",
    	    "Classes-Interfaces-Interface",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "implementingClassifier", 
    	    "Classes-Interfaces-InterfaceRealization-implementingClassifier",
    	    "Classes-Interfaces-BehavioredClassifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Operation
    	clss  = (Class_)model.getElementById("Classes-Interfaces-Operation").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "interface", 
    	    "Classes-Interfaces-Operation-interface",
    	    "Classes-Interfaces-Interface",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Property
    	clss  = (Class_)model.getElementById("Classes-Interfaces-Property").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "interface", 
    	    "Classes-Interfaces-Property-interface",
    	    "Classes-Interfaces-Interface",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Association
    	clss  = (Class_)model.getElementById("Classes-Kernel-Association").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "endType", 
    	    "Classes-Kernel-Association-endType",
    	    "Classes-Kernel-Type",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isDerived", 
    	    "Classes-Kernel-Association-isDerived",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-Kernel-Association-isDerived-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "memberEnd", 
    	    "Classes-Kernel-Association-memberEnd",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "2");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "navigableOwnedEnd", 
    	    "Classes-Kernel-Association-navigableOwnedEnd",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedEnd", 
    	    "Classes-Kernel-Association-ownedEnd",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // BehavioralFeature
    	clss  = (Class_)model.getElementById("Classes-Kernel-BehavioralFeature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedParameter", 
    	    "Classes-Kernel-BehavioralFeature-ownedParameter",
    	    "Classes-Kernel-Parameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "raisedException", 
    	    "Classes-Kernel-BehavioralFeature-raisedException",
    	    "Classes-Kernel-Type",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Class
    	clss  = (Class_)model.getElementById("Classes-Kernel-Class").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isAbstract", 
    	    "Classes-Kernel-Class-isAbstract",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "Classes-Kernel-Classifier-isAbstract",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-Kernel-Class-isAbstract-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "nestedClassifier", 
    	    "Classes-Kernel-Class-nestedClassifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedAttribute", 
    	    "Classes-Kernel-Class-ownedAttribute",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedOperation", 
    	    "Classes-Kernel-Class-ownedOperation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "superClass", 
    	    "Classes-Kernel-Class-superClass",
    	    "Classes-Kernel-Class",
    	    "Classes-Kernel-Classifier-general",    	    
    		false, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Classifier
    	clss  = (Class_)model.getElementById("Classes-Kernel-Classifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "attribute", 
    	    "Classes-Kernel-Classifier-attribute",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "feature", 
    	    "Classes-Kernel-Classifier-feature",
    	    "Classes-Kernel-Feature",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "general", 
    	    "Classes-Kernel-Classifier-general",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "generalization", 
    	    "Classes-Kernel-Classifier-generalization",
    	    "Classes-Kernel-Generalization",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "inheritedMember", 
    	    "Classes-Kernel-Classifier-inheritedMember",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isAbstract", 
    	    "Classes-Kernel-Classifier-isAbstract",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-Kernel-Classifier-isAbstract-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isFinalSpecialization", 
    	    "Classes-Kernel-Classifier-isFinalSpecialization",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-Kernel-Classifier-isFinalSpecialization-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "redefinedClassifier", 
    	    "Classes-Kernel-Classifier-redefinedClassifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Comment
    	clss  = (Class_)model.getElementById("Classes-Kernel-Comment").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "annotatedElement", 
    	    "Classes-Kernel-Comment-annotatedElement",
    	    "Classes-Kernel-Element",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "body", 
    	    "Classes-Kernel-Comment-body",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Constraint
    	clss  = (Class_)model.getElementById("Classes-Kernel-Constraint").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "constrainedElement", 
    	    "Classes-Kernel-Constraint-constrainedElement",
    	    "Classes-Kernel-Element",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "context", 
    	    "Classes-Kernel-Constraint-context",
    	    "Classes-Kernel-Namespace",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "specification", 
    	    "Classes-Kernel-Constraint-specification",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DataType
    	clss  = (Class_)model.getElementById("Classes-Kernel-DataType").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedAttribute", 
    	    "Classes-Kernel-DataType-ownedAttribute",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedOperation", 
    	    "Classes-Kernel-DataType-ownedOperation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DirectedRelationship
    	clss  = (Class_)model.getElementById("Classes-Kernel-DirectedRelationship").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "source", 
    	    "Classes-Kernel-DirectedRelationship-source",
    	    "Classes-Kernel-Element",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "target", 
    	    "Classes-Kernel-DirectedRelationship-target",
    	    "Classes-Kernel-Element",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Element
    	clss  = (Class_)model.getElementById("Classes-Kernel-Element").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedComment", 
    	    "Classes-Kernel-Element-ownedComment",
    	    "Classes-Kernel-Comment",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedElement", 
    	    "Classes-Kernel-Element-ownedElement",
    	    "Classes-Kernel-Element",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "owner", 
    	    "Classes-Kernel-Element-owner",
    	    "Classes-Kernel-Element",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ElementImport
    	clss  = (Class_)model.getElementById("Classes-Kernel-ElementImport").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "alias", 
    	    "Classes-Kernel-ElementImport-alias",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "importedElement", 
    	    "Classes-Kernel-ElementImport-importedElement",
    	    "Classes-Kernel-PackageableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "importingNamespace", 
    	    "Classes-Kernel-ElementImport-importingNamespace",
    	    "Classes-Kernel-Namespace",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "visibility", 
    	    "Classes-Kernel-ElementImport-visibility",
    	    "Classes-Kernel-VisibilityKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String(""),
    	   "Classes-Kernel-VisibilityKind-public",
    	   "Classes-Kernel-ElementImport-visibility-_defaultValue",  
    	   "uml:InstanceValue",  
    	   "Classes-Kernel-VisibilityKind");
    	
        // Enumeration
    	clss  = (Class_)model.getElementById("Classes-Kernel-Enumeration").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedLiteral", 
    	    "Classes-Kernel-Enumeration-ownedLiteral",
    	    "Classes-Kernel-EnumerationLiteral",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // EnumerationLiteral
    	clss  = (Class_)model.getElementById("Classes-Kernel-EnumerationLiteral").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "classifier", 
    	    "Classes-Kernel-EnumerationLiteral-classifier",
    	    "Classes-Kernel-Enumeration",
    	    "Classes-Kernel-InstanceSpecification-classifier",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "enumeration", 
    	    "Classes-Kernel-EnumerationLiteral-enumeration",
    	    "Classes-Kernel-Enumeration",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Expression
    	clss  = (Class_)model.getElementById("Classes-Kernel-Expression").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "operand", 
    	    "Classes-Kernel-Expression-operand",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "symbol", 
    	    "Classes-Kernel-Expression-symbol",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Feature
    	clss  = (Class_)model.getElementById("Classes-Kernel-Feature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "featuringClassifier", 
    	    "Classes-Kernel-Feature-featuringClassifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isStatic", 
    	    "Classes-Kernel-Feature-isStatic",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-Kernel-Feature-isStatic-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	
        // Generalization
    	clss  = (Class_)model.getElementById("Classes-Kernel-Generalization").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "general", 
    	    "Classes-Kernel-Generalization-general",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isSubstitutable", 
    	    "Classes-Kernel-Generalization-isSubstitutable",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(true),
    	   "",
    	   "Classes-Kernel-Generalization-isSubstitutable-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "specific", 
    	    "Classes-Kernel-Generalization-specific",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InstanceSpecification
    	clss  = (Class_)model.getElementById("Classes-Kernel-InstanceSpecification").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "classifier", 
    	    "Classes-Kernel-InstanceSpecification-classifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "slot", 
    	    "Classes-Kernel-InstanceSpecification-slot",
    	    "Classes-Kernel-Slot",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "specification", 
    	    "Classes-Kernel-InstanceSpecification-specification",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InstanceValue
    	clss  = (Class_)model.getElementById("Classes-Kernel-InstanceValue").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "instance", 
    	    "Classes-Kernel-InstanceValue-instance",
    	    "Classes-Kernel-InstanceSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LiteralBoolean
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralBoolean").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Classes-Kernel-LiteralBoolean-value",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-Kernel-LiteralBoolean-value-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	
        // LiteralInteger
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralInteger").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Classes-Kernel-LiteralInteger-value",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Integer",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Integer(0)
                ,
    	   "",
    	   "Classes-Kernel-LiteralInteger-value-_defaultValue",  
    	   "uml:LiteralInteger",  
    	   "");
    	
        // LiteralNull
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralNull").getDelegate();
    	
        // LiteralReal
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralReal").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Classes-Kernel-LiteralReal-value",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Real",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LiteralSpecification
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralSpecification").getDelegate();
    	
        // LiteralString
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralString").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Classes-Kernel-LiteralString-value",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // LiteralUnlimitedNatural
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralUnlimitedNatural").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Classes-Kernel-LiteralUnlimitedNatural-value",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#UnlimitedNatural",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String(""),
    	   "",
    	   "Classes-Kernel-LiteralUnlimitedNatural-value-_defaultValue",  
    	   "uml:LiteralUnlimitedNatural",  
    	   "");
    	
        // MultiplicityElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-MultiplicityElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isOrdered", 
    	    "Classes-Kernel-MultiplicityElement-isOrdered",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-Kernel-MultiplicityElement-isOrdered-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isUnique", 
    	    "Classes-Kernel-MultiplicityElement-isUnique",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(true),
    	   "",
    	   "Classes-Kernel-MultiplicityElement-isUnique-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "lower", 
    	    "Classes-Kernel-MultiplicityElement-lower",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Integer",
    	    "",    	    
    		false, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Integer(1)
                ,
    	   "",
    	   "Classes-Kernel-MultiplicityElement-lower-_defaultValue",  
    	   "uml:LiteralInteger",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "lowerValue", 
    	    "Classes-Kernel-MultiplicityElement-lowerValue",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "upper", 
    	    "Classes-Kernel-MultiplicityElement-upper",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#UnlimitedNatural",
    	    "",    	    
    		false, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("1"),
    	   "",
    	   "Classes-Kernel-MultiplicityElement-upper-_defaultValue",  
    	   "uml:LiteralUnlimitedNatural",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "upperValue", 
    	    "Classes-Kernel-MultiplicityElement-upperValue",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // NamedElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-NamedElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "name", 
    	    "Classes-Kernel-NamedElement-name",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "namespace", 
    	    "Classes-Kernel-NamedElement-namespace",
    	    "Classes-Kernel-Namespace",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "qualifiedName", 
    	    "Classes-Kernel-NamedElement-qualifiedName",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "visibility", 
    	    "Classes-Kernel-NamedElement-visibility",
    	    "Classes-Kernel-VisibilityKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Namespace
    	clss  = (Class_)model.getElementById("Classes-Kernel-Namespace").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "elementImport", 
    	    "Classes-Kernel-Namespace-elementImport",
    	    "Classes-Kernel-ElementImport",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "importedMember", 
    	    "Classes-Kernel-Namespace-importedMember",
    	    "Classes-Kernel-PackageableElement",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "member", 
    	    "Classes-Kernel-Namespace-member",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedMember", 
    	    "Classes-Kernel-Namespace-ownedMember",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedRule", 
    	    "Classes-Kernel-Namespace-ownedRule",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "packageImport", 
    	    "Classes-Kernel-Namespace-packageImport",
    	    "Classes-Kernel-PackageImport",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // OpaqueExpression
    	clss  = (Class_)model.getElementById("Classes-Kernel-OpaqueExpression").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "body", 
    	    "Classes-Kernel-OpaqueExpression-body",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "language", 
    	    "Classes-Kernel-OpaqueExpression-language",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Operation
    	clss  = (Class_)model.getElementById("Classes-Kernel-Operation").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "bodyCondition", 
    	    "Classes-Kernel-Operation-bodyCondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "class", 
    	    "Classes-Kernel-Operation-class",
    	    "Classes-Kernel-Class",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "datatype", 
    	    "Classes-Kernel-Operation-datatype",
    	    "Classes-Kernel-DataType",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isOrdered", 
    	    "Classes-Kernel-Operation-isOrdered",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-Kernel-Operation-isOrdered-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isQuery", 
    	    "Classes-Kernel-Operation-isQuery",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-Kernel-Operation-isQuery-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isUnique", 
    	    "Classes-Kernel-Operation-isUnique",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(true),
    	   "",
    	   "Classes-Kernel-Operation-isUnique-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "lower", 
    	    "Classes-Kernel-Operation-lower",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Integer",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Integer(1)
                ,
    	   "",
    	   "Classes-Kernel-Operation-lower-_defaultValue",  
    	   "uml:LiteralInteger",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "ownedParameter", 
    	    "Classes-Kernel-Operation-ownedParameter",
    	    "Classes-Kernel-Parameter",
    	    "Classes-Kernel-BehavioralFeature-ownedParameter",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "postcondition", 
    	    "Classes-Kernel-Operation-postcondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "precondition", 
    	    "Classes-Kernel-Operation-precondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "raisedException", 
    	    "Classes-Kernel-Operation-raisedException",
    	    "Classes-Kernel-Type",
    	    "Classes-Kernel-BehavioralFeature-raisedException",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedOperation", 
    	    "Classes-Kernel-Operation-redefinedOperation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "type", 
    	    "Classes-Kernel-Operation-type",
    	    "Classes-Kernel-Type",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "upper", 
    	    "Classes-Kernel-Operation-upper",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#UnlimitedNatural",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String("1"),
    	   "",
    	   "Classes-Kernel-Operation-upper-_defaultValue",  
    	   "uml:LiteralUnlimitedNatural",  
    	   "");
    	
        // Package
    	clss  = (Class_)model.getElementById("Classes-Kernel-Package").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "URI", 
    	    "Classes-Kernel-Package-URI",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "nestedPackage", 
    	    "Classes-Kernel-Package-nestedPackage",
    	    "Classes-Kernel-Package",
    	    "",    	    
    		false, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "nestingPackage", 
    	    "Classes-Kernel-Package-nestingPackage",
    	    "Classes-Kernel-Package",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedType", 
    	    "Classes-Kernel-Package-ownedType",
    	    "Classes-Kernel-Type",
    	    "",    	    
    		false, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "packageMerge", 
    	    "Classes-Kernel-Package-packageMerge",
    	    "Classes-Kernel-PackageMerge",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "packagedElement", 
    	    "Classes-Kernel-Package-packagedElement",
    	    "Classes-Kernel-PackageableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // PackageImport
    	clss  = (Class_)model.getElementById("Classes-Kernel-PackageImport").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "importedPackage", 
    	    "Classes-Kernel-PackageImport-importedPackage",
    	    "Classes-Kernel-Package",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "importingNamespace", 
    	    "Classes-Kernel-PackageImport-importingNamespace",
    	    "Classes-Kernel-Namespace",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "visibility", 
    	    "Classes-Kernel-PackageImport-visibility",
    	    "Classes-Kernel-VisibilityKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String(""),
    	   "Classes-Kernel-VisibilityKind-public",
    	   "Classes-Kernel-PackageImport-visibility-_defaultValue",  
    	   "uml:InstanceValue",  
    	   "Classes-Kernel-VisibilityKind");
    	
        // PackageMerge
    	clss  = (Class_)model.getElementById("Classes-Kernel-PackageMerge").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "mergedPackage", 
    	    "Classes-Kernel-PackageMerge-mergedPackage",
    	    "Classes-Kernel-Package",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "receivingPackage", 
    	    "Classes-Kernel-PackageMerge-receivingPackage",
    	    "Classes-Kernel-Package",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // PackageableElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-PackageableElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "visibility", 
    	    "Classes-Kernel-PackageableElement-visibility",
    	    "Classes-Kernel-VisibilityKind",
    	    "Classes-Kernel-NamedElement-visibility",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String(""),
    	   "Classes-Kernel-VisibilityKind-public",
    	   "Classes-Kernel-PackageableElement-visibility-_defaultValue",  
    	   "uml:InstanceValue",  
    	   "Classes-Kernel-VisibilityKind");
    	
        // Parameter
    	clss  = (Class_)model.getElementById("Classes-Kernel-Parameter").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "default", 
    	    "Classes-Kernel-Parameter-default",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "defaultValue", 
    	    "Classes-Kernel-Parameter-defaultValue",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "direction", 
    	    "Classes-Kernel-Parameter-direction",
    	    "Classes-Kernel-ParameterDirectionKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String(""),
    	   "Classes-Kernel-ParameterDirectionKind-in",
    	   "Classes-Kernel-Parameter-direction-_defaultValue",  
    	   "uml:InstanceValue",  
    	   "Classes-Kernel-ParameterDirectionKind");
    	    	
    	prop = factory.createProperty(clss, "operation", 
    	    "Classes-Kernel-Parameter-operation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // PrimitiveType
    	clss  = (Class_)model.getElementById("Classes-Kernel-PrimitiveType").getDelegate();
    	
        // Property
    	clss  = (Class_)model.getElementById("Classes-Kernel-Property").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "aggregation", 
    	    "Classes-Kernel-Property-aggregation",
    	    "Classes-Kernel-AggregationKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String(""),
    	   "Classes-Kernel-AggregationKind-none",
    	   "Classes-Kernel-Property-aggregation-_defaultValue",  
    	   "uml:InstanceValue",  
    	   "Classes-Kernel-AggregationKind");
    	    	
    	prop = factory.createProperty(clss, "association", 
    	    "Classes-Kernel-Property-association",
    	    "Classes-Kernel-Association",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "class", 
    	    "Classes-Kernel-Property-class",
    	    "Classes-Kernel-Class",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "datatype", 
    	    "Classes-Kernel-Property-datatype",
    	    "Classes-Kernel-DataType",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "default", 
    	    "Classes-Kernel-Property-default",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "defaultValue", 
    	    "Classes-Kernel-Property-defaultValue",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isComposite", 
    	    "Classes-Kernel-Property-isComposite",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, true, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isDerived", 
    	    "Classes-Kernel-Property-isDerived",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-Kernel-Property-isDerived-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isDerivedUnion", 
    	    "Classes-Kernel-Property-isDerivedUnion",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-Kernel-Property-isDerivedUnion-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isID", 
    	    "Classes-Kernel-Property-isID",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-Kernel-Property-isID-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isReadOnly", 
    	    "Classes-Kernel-Property-isReadOnly",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "Classes-Kernel-StructuralFeature-isReadOnly",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-Kernel-Property-isReadOnly-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "opposite", 
    	    "Classes-Kernel-Property-opposite",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "owningAssociation", 
    	    "Classes-Kernel-Property-owningAssociation",
    	    "Classes-Kernel-Association",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedProperty", 
    	    "Classes-Kernel-Property-redefinedProperty",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "subsettedProperty", 
    	    "Classes-Kernel-Property-subsettedProperty",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // RedefinableElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-RedefinableElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isLeaf", 
    	    "Classes-Kernel-RedefinableElement-isLeaf",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-Kernel-RedefinableElement-isLeaf-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "redefinedElement", 
    	    "Classes-Kernel-RedefinableElement-redefinedElement",
    	    "Classes-Kernel-RedefinableElement",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinitionContext", 
    	    "Classes-Kernel-RedefinableElement-redefinitionContext",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Relationship
    	clss  = (Class_)model.getElementById("Classes-Kernel-Relationship").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "relatedElement", 
    	    "Classes-Kernel-Relationship-relatedElement",
    	    "Classes-Kernel-Element",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Slot
    	clss  = (Class_)model.getElementById("Classes-Kernel-Slot").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "definingFeature", 
    	    "Classes-Kernel-Slot-definingFeature",
    	    "Classes-Kernel-StructuralFeature",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "owningInstance", 
    	    "Classes-Kernel-Slot-owningInstance",
    	    "Classes-Kernel-InstanceSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "value", 
    	    "Classes-Kernel-Slot-value",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StructuralFeature
    	clss  = (Class_)model.getElementById("Classes-Kernel-StructuralFeature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isReadOnly", 
    	    "Classes-Kernel-StructuralFeature-isReadOnly",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-Kernel-StructuralFeature-isReadOnly-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	
        // Type
    	clss  = (Class_)model.getElementById("Classes-Kernel-Type").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "package", 
    	    "Classes-Kernel-Type-package",
    	    "Classes-Kernel-Package",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TypedElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-TypedElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "type", 
    	    "Classes-Kernel-TypedElement-type",
    	    "Classes-Kernel-Type",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ValueSpecification
    	clss  = (Class_)model.getElementById("Classes-Kernel-ValueSpecification").getDelegate();
    	
        // Classifier
    	clss  = (Class_)model.getElementById("Classes-PowerTypes-Classifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "powertypeExtent", 
    	    "Classes-PowerTypes-Classifier-powertypeExtent",
    	    "Classes-PowerTypes-GeneralizationSet",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Generalization
    	clss  = (Class_)model.getElementById("Classes-PowerTypes-Generalization").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "generalizationSet", 
    	    "Classes-PowerTypes-Generalization-generalizationSet",
    	    "Classes-PowerTypes-GeneralizationSet",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // GeneralizationSet
    	clss  = (Class_)model.getElementById("Classes-PowerTypes-GeneralizationSet").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "generalization", 
    	    "Classes-PowerTypes-GeneralizationSet-generalization",
    	    "Classes-PowerTypes-Generalization",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isCovering", 
    	    "Classes-PowerTypes-GeneralizationSet-isCovering",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-PowerTypes-GeneralizationSet-isCovering-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isDisjoint", 
    	    "Classes-PowerTypes-GeneralizationSet-isDisjoint",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "Classes-PowerTypes-GeneralizationSet-isDisjoint-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "powertype", 
    	    "Classes-PowerTypes-GeneralizationSet-powertype",
    	    "Classes-PowerTypes-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Behavior
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-Behavior").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "context", 
    	    "CommonBehaviors-BasicBehaviors-Behavior-context",
    	    "CommonBehaviors-BasicBehaviors-BehavioredClassifier",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isReentrant", 
    	    "CommonBehaviors-BasicBehaviors-Behavior-isReentrant",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(true),
    	   "",
    	   "CommonBehaviors-BasicBehaviors-Behavior-isReentrant-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "ownedParameter", 
    	    "CommonBehaviors-BasicBehaviors-Behavior-ownedParameter",
    	    "Classes-Kernel-Parameter",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "postcondition", 
    	    "CommonBehaviors-BasicBehaviors-Behavior-postcondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "precondition", 
    	    "CommonBehaviors-BasicBehaviors-Behavior-precondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedBehavior", 
    	    "CommonBehaviors-BasicBehaviors-Behavior-redefinedBehavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "specification", 
    	    "CommonBehaviors-BasicBehaviors-Behavior-specification",
    	    "CommonBehaviors-BasicBehaviors-BehavioralFeature",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // BehavioralFeature
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-BehavioralFeature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isAbstract", 
    	    "CommonBehaviors-BasicBehaviors-BehavioralFeature-isAbstract",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "CommonBehaviors-BasicBehaviors-BehavioralFeature-isAbstract-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "method", 
    	    "CommonBehaviors-BasicBehaviors-BehavioralFeature-method",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // BehavioredClassifier
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-BehavioredClassifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "classifierBehavior", 
    	    "CommonBehaviors-BasicBehaviors-BehavioredClassifier-classifierBehavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedBehavior", 
    	    "CommonBehaviors-BasicBehaviors-BehavioredClassifier-ownedBehavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // FunctionBehavior
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-FunctionBehavior").getDelegate();
    	
        // OpaqueBehavior
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-OpaqueBehavior").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "body", 
    	    "CommonBehaviors-BasicBehaviors-OpaqueBehavior-body",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "language", 
    	    "CommonBehaviors-BasicBehaviors-OpaqueBehavior-language",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // OpaqueExpression
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-OpaqueExpression").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "behavior", 
    	    "CommonBehaviors-BasicBehaviors-OpaqueExpression-behavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "result", 
    	    "CommonBehaviors-BasicBehaviors-OpaqueExpression-result",
    	    "Classes-Kernel-Parameter",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // AnyReceiveEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-AnyReceiveEvent").getDelegate();
    	
        // BehavioralFeature
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-BehavioralFeature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "concurrency", 
    	    "CommonBehaviors-Communications-BehavioralFeature-concurrency",
    	    "CommonBehaviors-Communications-CallConcurrencyKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String(""),
    	   "CommonBehaviors-Communications-CallConcurrencyKind-sequential",
    	   "CommonBehaviors-Communications-BehavioralFeature-concurrency-_defaultValue",  
    	   "uml:InstanceValue",  
    	   "CommonBehaviors-Communications-CallConcurrencyKind");
    	
        // CallEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-CallEvent").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "operation", 
    	    "CommonBehaviors-Communications-CallEvent-operation",
    	    "CommonBehaviors-Communications-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ChangeEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-ChangeEvent").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "changeExpression", 
    	    "CommonBehaviors-Communications-ChangeEvent-changeExpression",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Class
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Class").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isActive", 
    	    "CommonBehaviors-Communications-Class-isActive",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "CommonBehaviors-Communications-Class-isActive-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "ownedReception", 
    	    "CommonBehaviors-Communications-Class-ownedReception",
    	    "CommonBehaviors-Communications-Reception",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Event
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Event").getDelegate();
    	
        // Interface
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Interface").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedReception", 
    	    "CommonBehaviors-Communications-Interface-ownedReception",
    	    "CommonBehaviors-Communications-Reception",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // MessageEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-MessageEvent").getDelegate();
    	
        // Operation
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Operation").getDelegate();
    	
        // Reception
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Reception").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "signal", 
    	    "CommonBehaviors-Communications-Reception-signal",
    	    "CommonBehaviors-Communications-Signal",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Signal
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Signal").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedAttribute", 
    	    "CommonBehaviors-Communications-Signal-ownedAttribute",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // SignalEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-SignalEvent").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "signal", 
    	    "CommonBehaviors-Communications-SignalEvent-signal",
    	    "CommonBehaviors-Communications-Signal",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Trigger
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Trigger").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "event", 
    	    "CommonBehaviors-Communications-Trigger-event",
    	    "CommonBehaviors-Communications-Event",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Duration
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-Duration").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "expr", 
    	    "CommonBehaviors-SimpleTime-Duration-expr",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "observation", 
    	    "CommonBehaviors-SimpleTime-Duration-observation",
    	    "CommonBehaviors-SimpleTime-Observation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DurationConstraint
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-DurationConstraint").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "firstEvent", 
    	    "CommonBehaviors-SimpleTime-DurationConstraint-firstEvent",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "2");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "specification", 
    	    "CommonBehaviors-SimpleTime-DurationConstraint-specification",
    	    "CommonBehaviors-SimpleTime-DurationInterval",
    	    "CommonBehaviors-SimpleTime-IntervalConstraint-specification",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DurationInterval
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-DurationInterval").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "max", 
    	    "CommonBehaviors-SimpleTime-DurationInterval-max",
    	    "CommonBehaviors-SimpleTime-Duration",
    	    "CommonBehaviors-SimpleTime-Interval-max",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "min", 
    	    "CommonBehaviors-SimpleTime-DurationInterval-min",
    	    "CommonBehaviors-SimpleTime-Duration",
    	    "CommonBehaviors-SimpleTime-Interval-min",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DurationObservation
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-DurationObservation").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "event", 
    	    "CommonBehaviors-SimpleTime-DurationObservation-event",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "2");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "firstEvent", 
    	    "CommonBehaviors-SimpleTime-DurationObservation-firstEvent",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "2");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Interval
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-Interval").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "max", 
    	    "CommonBehaviors-SimpleTime-Interval-max",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "min", 
    	    "CommonBehaviors-SimpleTime-Interval-min",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // IntervalConstraint
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-IntervalConstraint").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "specification", 
    	    "CommonBehaviors-SimpleTime-IntervalConstraint-specification",
    	    "CommonBehaviors-SimpleTime-Interval",
    	    "Classes-Kernel-Constraint-specification",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Observation
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-Observation").getDelegate();
    	
        // TimeConstraint
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeConstraint").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "firstEvent", 
    	    "CommonBehaviors-SimpleTime-TimeConstraint-firstEvent",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(true),
    	   "",
    	   "CommonBehaviors-SimpleTime-TimeConstraint-firstEvent-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "specification", 
    	    "CommonBehaviors-SimpleTime-TimeConstraint-specification",
    	    "CommonBehaviors-SimpleTime-TimeInterval",
    	    "CommonBehaviors-SimpleTime-IntervalConstraint-specification",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TimeEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeEvent").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isRelative", 
    	    "CommonBehaviors-SimpleTime-TimeEvent-isRelative",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "CommonBehaviors-SimpleTime-TimeEvent-isRelative-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "when", 
    	    "CommonBehaviors-SimpleTime-TimeEvent-when",
    	    "CommonBehaviors-SimpleTime-TimeExpression",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TimeExpression
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeExpression").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "expr", 
    	    "CommonBehaviors-SimpleTime-TimeExpression-expr",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "observation", 
    	    "CommonBehaviors-SimpleTime-TimeExpression-observation",
    	    "CommonBehaviors-SimpleTime-Observation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TimeInterval
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeInterval").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "max", 
    	    "CommonBehaviors-SimpleTime-TimeInterval-max",
    	    "CommonBehaviors-SimpleTime-TimeExpression",
    	    "CommonBehaviors-SimpleTime-Interval-max",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "min", 
    	    "CommonBehaviors-SimpleTime-TimeInterval-min",
    	    "CommonBehaviors-SimpleTime-TimeExpression",
    	    "CommonBehaviors-SimpleTime-Interval-min",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TimeObservation
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeObservation").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "event", 
    	    "CommonBehaviors-SimpleTime-TimeObservation-event",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "firstEvent", 
    	    "CommonBehaviors-SimpleTime-TimeObservation-firstEvent",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(true),
    	   "",
    	   "CommonBehaviors-SimpleTime-TimeObservation-firstEvent-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	
        // Component
    	clss  = (Class_)model.getElementById("Components-BasicComponents-Component").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isIndirectlyInstantiated", 
    	    "Components-BasicComponents-Component-isIndirectlyInstantiated",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(true),
    	   "",
    	   "Components-BasicComponents-Component-isIndirectlyInstantiated-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "provided", 
    	    "Components-BasicComponents-Component-provided",
    	    "Classes-Interfaces-Interface",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "realization", 
    	    "Components-BasicComponents-Component-realization",
    	    "Components-BasicComponents-ComponentRealization",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "required", 
    	    "Components-BasicComponents-Component-required",
    	    "Classes-Interfaces-Interface",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ComponentRealization
    	clss  = (Class_)model.getElementById("Components-BasicComponents-ComponentRealization").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "abstraction", 
    	    "Components-BasicComponents-ComponentRealization-abstraction",
    	    "Components-BasicComponents-Component",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "realizingClassifier", 
    	    "Components-BasicComponents-ComponentRealization-realizingClassifier",
    	    "Classes-Dependencies-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConnectableElement
    	clss  = (Class_)model.getElementById("Components-BasicComponents-ConnectableElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "end", 
    	    "Components-BasicComponents-ConnectableElement-end",
    	    "Components-BasicComponents-ConnectorEnd",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Connector
    	clss  = (Class_)model.getElementById("Components-BasicComponents-Connector").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "contract", 
    	    "Components-BasicComponents-Connector-contract",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "end", 
    	    "Components-BasicComponents-Connector-end",
    	    "Components-BasicComponents-ConnectorEnd",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "2");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "kind", 
    	    "Components-BasicComponents-Connector-kind",
    	    "Components-BasicComponents-ConnectorKind",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConnectorEnd
    	clss  = (Class_)model.getElementById("Components-BasicComponents-ConnectorEnd").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "partWithPort", 
    	    "Components-BasicComponents-ConnectorEnd-partWithPort",
    	    "CompositeStructures-InternalStructures-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "role", 
    	    "Components-BasicComponents-ConnectorEnd-role",
    	    "Components-BasicComponents-ConnectableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Component
    	clss  = (Class_)model.getElementById("Components-PackagingComponents-Component").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "packagedElement", 
    	    "Components-PackagingComponents-Component-packagedElement",
    	    "Classes-Kernel-PackageableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Classifier
    	clss  = (Class_)model.getElementById("CompositeStructures-Collaborations-Classifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "collaborationUse", 
    	    "CompositeStructures-Collaborations-Classifier-collaborationUse",
    	    "CompositeStructures-Collaborations-CollaborationUse",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "representation", 
    	    "CompositeStructures-Collaborations-Classifier-representation",
    	    "CompositeStructures-Collaborations-CollaborationUse",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Collaboration
    	clss  = (Class_)model.getElementById("CompositeStructures-Collaborations-Collaboration").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "collaborationRole", 
    	    "CompositeStructures-Collaborations-Collaboration-collaborationRole",
    	    "CompositeStructures-InternalStructures-ConnectableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // CollaborationUse
    	clss  = (Class_)model.getElementById("CompositeStructures-Collaborations-CollaborationUse").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "roleBinding", 
    	    "CompositeStructures-Collaborations-CollaborationUse-roleBinding",
    	    "Classes-Dependencies-Dependency",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "type", 
    	    "CompositeStructures-Collaborations-CollaborationUse-type",
    	    "CompositeStructures-Collaborations-Collaboration",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Parameter
    	clss  = (Class_)model.getElementById("CompositeStructures-Collaborations-Parameter").getDelegate();
    	
        // Class
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-Class").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedAttribute", 
    	    "CompositeStructures-InternalStructures-Class-ownedAttribute",
    	    "CompositeStructures-InternalStructures-Property",
    	    "CompositeStructures-InternalStructures-StructuredClassifier-ownedAttribute",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Classifier
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-Classifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "attribute", 
    	    "CompositeStructures-InternalStructures-Classifier-attribute",
    	    "CompositeStructures-InternalStructures-Property",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "feature", 
    	    "CompositeStructures-InternalStructures-Classifier-feature",
    	    "CompositeStructures-InternalStructures-Feature",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConnectableElement
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-ConnectableElement").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "end", 
    	    "CompositeStructures-InternalStructures-ConnectableElement-end",
    	    "CompositeStructures-InternalStructures-ConnectorEnd",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Connector
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-Connector").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "end", 
    	    "CompositeStructures-InternalStructures-Connector-end",
    	    "CompositeStructures-InternalStructures-ConnectorEnd",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "2");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedConnector", 
    	    "CompositeStructures-InternalStructures-Connector-redefinedConnector",
    	    "CompositeStructures-InternalStructures-Connector",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "type", 
    	    "CompositeStructures-InternalStructures-Connector-type",
    	    "Classes-Kernel-Association",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConnectorEnd
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-ConnectorEnd").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "definingEnd", 
    	    "CompositeStructures-InternalStructures-ConnectorEnd-definingEnd",
    	    "CompositeStructures-InternalStructures-Property",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "role", 
    	    "CompositeStructures-InternalStructures-ConnectorEnd-role",
    	    "CompositeStructures-InternalStructures-ConnectableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Feature
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-Feature").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "featuringClassifier", 
    	    "CompositeStructures-InternalStructures-Feature-featuringClassifier",
    	    "CompositeStructures-InternalStructures-Classifier",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Property
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-Property").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "class", 
    	    "CompositeStructures-InternalStructures-Property-class",
    	    "CompositeStructures-InternalStructures-Class",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StructuredClassifier
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-StructuredClassifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedAttribute", 
    	    "CompositeStructures-InternalStructures-StructuredClassifier-ownedAttribute",
    	    "CompositeStructures-InternalStructures-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedConnector", 
    	    "CompositeStructures-InternalStructures-StructuredClassifier-ownedConnector",
    	    "CompositeStructures-InternalStructures-Connector",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "part", 
    	    "CompositeStructures-InternalStructures-StructuredClassifier-part",
    	    "CompositeStructures-InternalStructures-Property",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "role", 
    	    "CompositeStructures-InternalStructures-StructuredClassifier-role",
    	    "CompositeStructures-InternalStructures-ConnectableElement",
    	    "",    	    
    		true, true, true);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InvocationAction
    	clss  = (Class_)model.getElementById("CompositeStructures-InvocationActions-InvocationAction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "onPort", 
    	    "CompositeStructures-InvocationActions-InvocationAction-onPort",
    	    "CompositeStructures-Ports-Port",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Trigger
    	clss  = (Class_)model.getElementById("CompositeStructures-InvocationActions-Trigger").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "port", 
    	    "CompositeStructures-InvocationActions-Trigger-port",
    	    "CompositeStructures-Ports-Port",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConnectorEnd
    	clss  = (Class_)model.getElementById("CompositeStructures-Ports-ConnectorEnd").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "partWithPort", 
    	    "CompositeStructures-Ports-ConnectorEnd-partWithPort",
    	    "CompositeStructures-InternalStructures-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // EncapsulatedClassifier
    	clss  = (Class_)model.getElementById("CompositeStructures-Ports-EncapsulatedClassifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedPort", 
    	    "CompositeStructures-Ports-EncapsulatedClassifier-ownedPort",
    	    "CompositeStructures-Ports-Port",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Port
    	clss  = (Class_)model.getElementById("CompositeStructures-Ports-Port").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "isBehavior", 
    	    "CompositeStructures-Ports-Port-isBehavior",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "CompositeStructures-Ports-Port-isBehavior-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isConjugated", 
    	    "CompositeStructures-Ports-Port-isConjugated",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "CompositeStructures-Ports-Port-isConjugated-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isService", 
    	    "CompositeStructures-Ports-Port-isService",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(true),
    	   "",
    	   "CompositeStructures-Ports-Port-isService-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "provided", 
    	    "CompositeStructures-Ports-Port-provided",
    	    "Classes-Interfaces-Interface",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinedPort", 
    	    "CompositeStructures-Ports-Port-redefinedPort",
    	    "CompositeStructures-Ports-Port",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "required", 
    	    "CompositeStructures-Ports-Port-required",
    	    "Classes-Interfaces-Interface",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Variable
    	clss  = (Class_)model.getElementById("CompositeStructures-StructuredActivities-Variable").getDelegate();
    	
        // Class
    	clss  = (Class_)model.getElementById("CompositeStructures-StructuredClasses-Class").getDelegate();
    	
        // Artifact
    	clss  = (Class_)model.getElementById("Deployments-Artifacts-Artifact").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "fileName", 
    	    "Deployments-Artifacts-Artifact-fileName",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "manifestation", 
    	    "Deployments-Artifacts-Artifact-manifestation",
    	    "Deployments-Artifacts-Manifestation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "nestedArtifact", 
    	    "Deployments-Artifacts-Artifact-nestedArtifact",
    	    "Deployments-Artifacts-Artifact",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedAttribute", 
    	    "Deployments-Artifacts-Artifact-ownedAttribute",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "ownedOperation", 
    	    "Deployments-Artifacts-Artifact-ownedOperation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Manifestation
    	clss  = (Class_)model.getElementById("Deployments-Artifacts-Manifestation").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "utilizedElement", 
    	    "Deployments-Artifacts-Manifestation-utilizedElement",
    	    "Classes-Dependencies-PackageableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Deployment
    	clss  = (Class_)model.getElementById("Deployments-ComponentDeployments-Deployment").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "configuration", 
    	    "Deployments-ComponentDeployments-Deployment-configuration",
    	    "Deployments-ComponentDeployments-DeploymentSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DeploymentSpecification
    	clss  = (Class_)model.getElementById("Deployments-ComponentDeployments-DeploymentSpecification").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "deployment", 
    	    "Deployments-ComponentDeployments-DeploymentSpecification-deployment",
    	    "Deployments-ComponentDeployments-Deployment",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "deploymentLocation", 
    	    "Deployments-ComponentDeployments-DeploymentSpecification-deploymentLocation",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "executionLocation", 
    	    "Deployments-ComponentDeployments-DeploymentSpecification-executionLocation",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Artifact
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Artifact").getDelegate();
    	
        // CommunicationPath
    	clss  = (Class_)model.getElementById("Deployments-Nodes-CommunicationPath").getDelegate();
    	
        // DeployedArtifact
    	clss  = (Class_)model.getElementById("Deployments-Nodes-DeployedArtifact").getDelegate();
    	
        // Deployment
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Deployment").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "deployedArtifact", 
    	    "Deployments-Nodes-Deployment-deployedArtifact",
    	    "Deployments-Nodes-DeployedArtifact",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "location", 
    	    "Deployments-Nodes-Deployment-location",
    	    "Deployments-Nodes-DeploymentTarget",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DeploymentTarget
    	clss  = (Class_)model.getElementById("Deployments-Nodes-DeploymentTarget").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "deployedElement", 
    	    "Deployments-Nodes-DeploymentTarget-deployedElement",
    	    "Classes-Kernel-PackageableElement",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "deployment", 
    	    "Deployments-Nodes-DeploymentTarget-deployment",
    	    "Deployments-Nodes-Deployment",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Device
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Device").getDelegate();
    	
        // ExecutionEnvironment
    	clss  = (Class_)model.getElementById("Deployments-Nodes-ExecutionEnvironment").getDelegate();
    	
        // InstanceSpecification
    	clss  = (Class_)model.getElementById("Deployments-Nodes-InstanceSpecification").getDelegate();
    	
        // Node
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Node").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "nestedNode", 
    	    "Deployments-Nodes-Node-nestedNode",
    	    "Deployments-Nodes-Node",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Property
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Property").getDelegate();
    	
        // ActionExecutionSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ActionExecutionSpecification").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "action", 
    	    "Interactions-BasicInteractions-ActionExecutionSpecification-action",
    	    "Actions-BasicActions-Action",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // BehaviorExecutionSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-BehaviorExecutionSpecification").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "behavior", 
    	    "Interactions-BasicInteractions-BehaviorExecutionSpecification-behavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // DestructionOccurrenceSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-DestructionOccurrenceSpecification").getDelegate();
    	
        // ExecutionOccurrenceSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ExecutionOccurrenceSpecification").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "execution", 
    	    "Interactions-BasicInteractions-ExecutionOccurrenceSpecification-execution",
    	    "Interactions-BasicInteractions-ExecutionSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ExecutionSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ExecutionSpecification").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "finish", 
    	    "Interactions-BasicInteractions-ExecutionSpecification-finish",
    	    "Interactions-BasicInteractions-OccurrenceSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "start", 
    	    "Interactions-BasicInteractions-ExecutionSpecification-start",
    	    "Interactions-BasicInteractions-OccurrenceSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // GeneralOrdering
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-GeneralOrdering").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "after", 
    	    "Interactions-BasicInteractions-GeneralOrdering-after",
    	    "Interactions-BasicInteractions-OccurrenceSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "before", 
    	    "Interactions-BasicInteractions-GeneralOrdering-before",
    	    "Interactions-BasicInteractions-OccurrenceSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Interaction
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-Interaction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "action", 
    	    "Interactions-BasicInteractions-Interaction-action",
    	    "Actions-BasicActions-Action",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "fragment", 
    	    "Interactions-BasicInteractions-Interaction-fragment",
    	    "Interactions-BasicInteractions-InteractionFragment",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "lifeline", 
    	    "Interactions-BasicInteractions-Interaction-lifeline",
    	    "Interactions-BasicInteractions-Lifeline",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "message", 
    	    "Interactions-BasicInteractions-Interaction-message",
    	    "Interactions-BasicInteractions-Message",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InteractionFragment
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-InteractionFragment").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "covered", 
    	    "Interactions-BasicInteractions-InteractionFragment-covered",
    	    "Interactions-BasicInteractions-Lifeline",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "enclosingInteraction", 
    	    "Interactions-BasicInteractions-InteractionFragment-enclosingInteraction",
    	    "Interactions-BasicInteractions-Interaction",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "generalOrdering", 
    	    "Interactions-BasicInteractions-InteractionFragment-generalOrdering",
    	    "Interactions-BasicInteractions-GeneralOrdering",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Lifeline
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-Lifeline").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "coveredBy", 
    	    "Interactions-BasicInteractions-Lifeline-coveredBy",
    	    "Interactions-BasicInteractions-InteractionFragment",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "interaction", 
    	    "Interactions-BasicInteractions-Lifeline-interaction",
    	    "Interactions-BasicInteractions-Interaction",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "represents", 
    	    "Interactions-BasicInteractions-Lifeline-represents",
    	    "CompositeStructures-InternalStructures-ConnectableElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "selector", 
    	    "Interactions-BasicInteractions-Lifeline-selector",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Message
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-Message").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "argument", 
    	    "Interactions-BasicInteractions-Message-argument",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "connector", 
    	    "Interactions-BasicInteractions-Message-connector",
    	    "CompositeStructures-InternalStructures-Connector",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "interaction", 
    	    "Interactions-BasicInteractions-Message-interaction",
    	    "Interactions-BasicInteractions-Interaction",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "messageKind", 
    	    "Interactions-BasicInteractions-Message-messageKind",
    	    "Interactions-BasicInteractions-MessageKind",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String(""),
    	   "Interactions-BasicInteractions-MessageKind-unknown",
    	   "Interactions-BasicInteractions-Message-messageKind-_defaultValue",  
    	   "uml:InstanceValue",  
    	   "Interactions-BasicInteractions-MessageKind");
    	    	
    	prop = factory.createProperty(clss, "messageSort", 
    	    "Interactions-BasicInteractions-Message-messageSort",
    	    "Interactions-BasicInteractions-MessageSort",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String(""),
    	   "Interactions-BasicInteractions-MessageSort-synchCall",
    	   "Interactions-BasicInteractions-Message-messageSort-_defaultValue",  
    	   "uml:InstanceValue",  
    	   "Interactions-BasicInteractions-MessageSort");
    	    	
    	prop = factory.createProperty(clss, "receiveEvent", 
    	    "Interactions-BasicInteractions-Message-receiveEvent",
    	    "Interactions-BasicInteractions-MessageEnd",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "sendEvent", 
    	    "Interactions-BasicInteractions-Message-sendEvent",
    	    "Interactions-BasicInteractions-MessageEnd",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "signature", 
    	    "Interactions-BasicInteractions-Message-signature",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // MessageEnd
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-MessageEnd").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "message", 
    	    "Interactions-BasicInteractions-MessageEnd-message",
    	    "Interactions-BasicInteractions-Message",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // MessageOccurrenceSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-MessageOccurrenceSpecification").getDelegate();
    	
        // OccurrenceSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-OccurrenceSpecification").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "covered", 
    	    "Interactions-BasicInteractions-OccurrenceSpecification-covered",
    	    "Interactions-BasicInteractions-Lifeline",
    	    "Interactions-BasicInteractions-InteractionFragment-covered",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "toAfter", 
    	    "Interactions-BasicInteractions-OccurrenceSpecification-toAfter",
    	    "Interactions-BasicInteractions-GeneralOrdering",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "toBefore", 
    	    "Interactions-BasicInteractions-OccurrenceSpecification-toBefore",
    	    "Interactions-BasicInteractions-GeneralOrdering",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StateInvariant
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-StateInvariant").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "covered", 
    	    "Interactions-BasicInteractions-StateInvariant-covered",
    	    "Interactions-BasicInteractions-Lifeline",
    	    "Interactions-BasicInteractions-InteractionFragment-covered",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "invariant", 
    	    "Interactions-BasicInteractions-StateInvariant-invariant",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // CombinedFragment
    	clss  = (Class_)model.getElementById("Interactions-Fragments-CombinedFragment").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "cfragmentGate", 
    	    "Interactions-Fragments-CombinedFragment-cfragmentGate",
    	    "Interactions-Fragments-Gate",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "interactionOperator", 
    	    "Interactions-Fragments-CombinedFragment-interactionOperator",
    	    "Interactions-Fragments-InteractionOperatorKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String(""),
    	   "Interactions-Fragments-InteractionOperatorKind-seq",
    	   "Interactions-Fragments-CombinedFragment-interactionOperator-_defaultValue",  
    	   "uml:InstanceValue",  
    	   "Interactions-Fragments-InteractionOperatorKind");
    	    	
    	prop = factory.createProperty(clss, "operand", 
    	    "Interactions-Fragments-CombinedFragment-operand",
    	    "Interactions-Fragments-InteractionOperand",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ConsiderIgnoreFragment
    	clss  = (Class_)model.getElementById("Interactions-Fragments-ConsiderIgnoreFragment").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "message", 
    	    "Interactions-Fragments-ConsiderIgnoreFragment-message",
    	    "Classes-Kernel-NamedElement",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Continuation
    	clss  = (Class_)model.getElementById("Interactions-Fragments-Continuation").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "setting", 
    	    "Interactions-Fragments-Continuation-setting",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(true),
    	   "",
    	   "Interactions-Fragments-Continuation-setting-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	
        // Gate
    	clss  = (Class_)model.getElementById("Interactions-Fragments-Gate").getDelegate();
    	
        // Interaction
    	clss  = (Class_)model.getElementById("Interactions-Fragments-Interaction").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "formalGate", 
    	    "Interactions-Fragments-Interaction-formalGate",
    	    "Interactions-Fragments-Gate",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InteractionConstraint
    	clss  = (Class_)model.getElementById("Interactions-Fragments-InteractionConstraint").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "maxint", 
    	    "Interactions-Fragments-InteractionConstraint-maxint",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "minint", 
    	    "Interactions-Fragments-InteractionConstraint-minint",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InteractionFragment
    	clss  = (Class_)model.getElementById("Interactions-Fragments-InteractionFragment").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "enclosingOperand", 
    	    "Interactions-Fragments-InteractionFragment-enclosingOperand",
    	    "Interactions-Fragments-InteractionOperand",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InteractionOperand
    	clss  = (Class_)model.getElementById("Interactions-Fragments-InteractionOperand").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "fragment", 
    	    "Interactions-Fragments-InteractionOperand-fragment",
    	    "Interactions-Fragments-InteractionFragment",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "guard", 
    	    "Interactions-Fragments-InteractionOperand-guard",
    	    "Interactions-Fragments-InteractionConstraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // InteractionUse
    	clss  = (Class_)model.getElementById("Interactions-Fragments-InteractionUse").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "actualGate", 
    	    "Interactions-Fragments-InteractionUse-actualGate",
    	    "Interactions-Fragments-Gate",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "argument", 
    	    "Interactions-Fragments-InteractionUse-argument",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "refersTo", 
    	    "Interactions-Fragments-InteractionUse-refersTo",
    	    "Interactions-Fragments-Interaction",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "returnValue", 
    	    "Interactions-Fragments-InteractionUse-returnValue",
    	    "Classes-Kernel-ValueSpecification",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "returnValueRecipient", 
    	    "Interactions-Fragments-InteractionUse-returnValueRecipient",
    	    "Classes-Kernel-Property",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Lifeline
    	clss  = (Class_)model.getElementById("Interactions-Fragments-Lifeline").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "decomposedAs", 
    	    "Interactions-Fragments-Lifeline-decomposedAs",
    	    "Interactions-Fragments-PartDecomposition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // PartDecomposition
    	clss  = (Class_)model.getElementById("Interactions-Fragments-PartDecomposition").getDelegate();
    	
        // ConnectionPointReference
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-ConnectionPointReference").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "entry", 
    	    "StateMachines-BehaviorStateMachines-ConnectionPointReference-entry",
    	    "StateMachines-BehaviorStateMachines-Pseudostate",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "exit", 
    	    "StateMachines-BehaviorStateMachines-ConnectionPointReference-exit",
    	    "StateMachines-BehaviorStateMachines-Pseudostate",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "state", 
    	    "StateMachines-BehaviorStateMachines-ConnectionPointReference-state",
    	    "StateMachines-BehaviorStateMachines-State",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // FinalState
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-FinalState").getDelegate();
    	
        // Pseudostate
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-Pseudostate").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "kind", 
    	    "StateMachines-BehaviorStateMachines-Pseudostate-kind",
    	    "StateMachines-BehaviorStateMachines-PseudostateKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String(""),
    	   "StateMachines-BehaviorStateMachines-PseudostateKind-initial",
    	   "StateMachines-BehaviorStateMachines-Pseudostate-kind-_defaultValue",  
    	   "uml:InstanceValue",  
    	   "StateMachines-BehaviorStateMachines-PseudostateKind");
    	    	
    	prop = factory.createProperty(clss, "state", 
    	    "StateMachines-BehaviorStateMachines-Pseudostate-state",
    	    "StateMachines-BehaviorStateMachines-State",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "stateMachine", 
    	    "StateMachines-BehaviorStateMachines-Pseudostate-stateMachine",
    	    "StateMachines-BehaviorStateMachines-StateMachine",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Region
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-Region").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "extendedRegion", 
    	    "StateMachines-BehaviorStateMachines-Region-extendedRegion",
    	    "StateMachines-BehaviorStateMachines-Region",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinitionContext", 
    	    "StateMachines-BehaviorStateMachines-Region-redefinitionContext",
    	    "Classes-Kernel-Classifier",
    	    "Classes-Kernel-RedefinableElement-redefinitionContext",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "state", 
    	    "StateMachines-BehaviorStateMachines-Region-state",
    	    "StateMachines-BehaviorStateMachines-State",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "stateMachine", 
    	    "StateMachines-BehaviorStateMachines-Region-stateMachine",
    	    "StateMachines-BehaviorStateMachines-StateMachine",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "subvertex", 
    	    "StateMachines-BehaviorStateMachines-Region-subvertex",
    	    "StateMachines-BehaviorStateMachines-Vertex",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "transition", 
    	    "StateMachines-BehaviorStateMachines-Region-transition",
    	    "StateMachines-BehaviorStateMachines-Transition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // State
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-State").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "connection", 
    	    "StateMachines-BehaviorStateMachines-State-connection",
    	    "StateMachines-BehaviorStateMachines-ConnectionPointReference",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "connectionPoint", 
    	    "StateMachines-BehaviorStateMachines-State-connectionPoint",
    	    "StateMachines-BehaviorStateMachines-Pseudostate",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "deferrableTrigger", 
    	    "StateMachines-BehaviorStateMachines-State-deferrableTrigger",
    	    "CommonBehaviors-Communications-Trigger",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "doActivity", 
    	    "StateMachines-BehaviorStateMachines-State-doActivity",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "entry", 
    	    "StateMachines-BehaviorStateMachines-State-entry",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "exit", 
    	    "StateMachines-BehaviorStateMachines-State-exit",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "isComposite", 
    	    "StateMachines-BehaviorStateMachines-State-isComposite",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "StateMachines-BehaviorStateMachines-State-isComposite-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isOrthogonal", 
    	    "StateMachines-BehaviorStateMachines-State-isOrthogonal",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "StateMachines-BehaviorStateMachines-State-isOrthogonal-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isSimple", 
    	    "StateMachines-BehaviorStateMachines-State-isSimple",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(true),
    	   "",
    	   "StateMachines-BehaviorStateMachines-State-isSimple-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "isSubmachineState", 
    	    "StateMachines-BehaviorStateMachines-State-isSubmachineState",
    	    "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new Boolean(false),
    	   "",
    	   "StateMachines-BehaviorStateMachines-State-isSubmachineState-_defaultValue",  
    	   "uml:LiteralBoolean",  
    	   "");
    	    	
    	prop = factory.createProperty(clss, "redefinedState", 
    	    "StateMachines-BehaviorStateMachines-State-redefinedState",
    	    "StateMachines-BehaviorStateMachines-State",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinitionContext", 
    	    "StateMachines-BehaviorStateMachines-State-redefinitionContext",
    	    "Classes-Kernel-Classifier",
    	    "Classes-Kernel-RedefinableElement-redefinitionContext",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "region", 
    	    "StateMachines-BehaviorStateMachines-State-region",
    	    "StateMachines-BehaviorStateMachines-Region",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "stateInvariant", 
    	    "StateMachines-BehaviorStateMachines-State-stateInvariant",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "submachine", 
    	    "StateMachines-BehaviorStateMachines-State-submachine",
    	    "StateMachines-BehaviorStateMachines-StateMachine",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // StateMachine
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-StateMachine").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "connectionPoint", 
    	    "StateMachines-BehaviorStateMachines-StateMachine-connectionPoint",
    	    "StateMachines-BehaviorStateMachines-Pseudostate",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "extendedStateMachine", 
    	    "StateMachines-BehaviorStateMachines-StateMachine-extendedStateMachine",
    	    "StateMachines-BehaviorStateMachines-StateMachine",
    	    "CommonBehaviors-BasicBehaviors-Behavior-redefinedBehavior",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "region", 
    	    "StateMachines-BehaviorStateMachines-StateMachine-region",
    	    "StateMachines-BehaviorStateMachines-Region",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "submachineState", 
    	    "StateMachines-BehaviorStateMachines-StateMachine-submachineState",
    	    "StateMachines-BehaviorStateMachines-State",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // TimeEvent
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-TimeEvent").getDelegate();
    	
        // Transition
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-Transition").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "container", 
    	    "StateMachines-BehaviorStateMachines-Transition-container",
    	    "StateMachines-BehaviorStateMachines-Region",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "effect", 
    	    "StateMachines-BehaviorStateMachines-Transition-effect",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "guard", 
    	    "StateMachines-BehaviorStateMachines-Transition-guard",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "kind", 
    	    "StateMachines-BehaviorStateMachines-Transition-kind",
    	    "StateMachines-BehaviorStateMachines-TransitionKind",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
     	factory.createDefault(prop,
    	   new String(""),
    	   "StateMachines-BehaviorStateMachines-TransitionKind-external",
    	   "StateMachines-BehaviorStateMachines-Transition-kind-_defaultValue",  
    	   "uml:InstanceValue",  
    	   "StateMachines-BehaviorStateMachines-TransitionKind");
    	    	
    	prop = factory.createProperty(clss, "redefinedTransition", 
    	    "StateMachines-BehaviorStateMachines-Transition-redefinedTransition",
    	    "StateMachines-BehaviorStateMachines-Transition",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "redefinitionContext", 
    	    "StateMachines-BehaviorStateMachines-Transition-redefinitionContext",
    	    "Classes-Kernel-Classifier",
    	    "Classes-Kernel-RedefinableElement-redefinitionContext",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "source", 
    	    "StateMachines-BehaviorStateMachines-Transition-source",
    	    "StateMachines-BehaviorStateMachines-Vertex",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "target", 
    	    "StateMachines-BehaviorStateMachines-Transition-target",
    	    "StateMachines-BehaviorStateMachines-Vertex",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "trigger", 
    	    "StateMachines-BehaviorStateMachines-Transition-trigger",
    	    "CommonBehaviors-Communications-Trigger",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Vertex
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-Vertex").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "container", 
    	    "StateMachines-BehaviorStateMachines-Vertex-container",
    	    "StateMachines-BehaviorStateMachines-Region",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "incoming", 
    	    "StateMachines-BehaviorStateMachines-Vertex-incoming",
    	    "StateMachines-BehaviorStateMachines-Transition",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "outgoing", 
    	    "StateMachines-BehaviorStateMachines-Vertex-outgoing",
    	    "StateMachines-BehaviorStateMachines-Transition",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Interface
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-Interface").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "protocol", 
    	    "StateMachines-ProtocolStateMachines-Interface-protocol",
    	    "StateMachines-ProtocolStateMachines-ProtocolStateMachine",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Port
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-Port").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "protocol", 
    	    "StateMachines-ProtocolStateMachines-Port-protocol",
    	    "StateMachines-ProtocolStateMachines-ProtocolStateMachine",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ProtocolConformance
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-ProtocolConformance").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "generalMachine", 
    	    "StateMachines-ProtocolStateMachines-ProtocolConformance-generalMachine",
    	    "StateMachines-ProtocolStateMachines-ProtocolStateMachine",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "specificMachine", 
    	    "StateMachines-ProtocolStateMachines-ProtocolConformance-specificMachine",
    	    "StateMachines-ProtocolStateMachines-ProtocolStateMachine",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ProtocolStateMachine
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-ProtocolStateMachine").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "conformance", 
    	    "StateMachines-ProtocolStateMachines-ProtocolStateMachine-conformance",
    	    "StateMachines-ProtocolStateMachines-ProtocolConformance",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ProtocolTransition
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-ProtocolTransition").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "postCondition", 
    	    "StateMachines-ProtocolStateMachines-ProtocolTransition-postCondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "preCondition", 
    	    "StateMachines-ProtocolStateMachines-ProtocolTransition-preCondition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "referred", 
    	    "StateMachines-ProtocolStateMachines-ProtocolTransition-referred",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    		true, true, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Region
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-Region").getDelegate();
    	
        // State
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-State").getDelegate();
    	
        // Actor
    	clss  = (Class_)model.getElementById("UseCases-Actor").getDelegate();
    	
        // Classifier
    	clss  = (Class_)model.getElementById("UseCases-Classifier").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "ownedUseCase", 
    	    "UseCases-Classifier-ownedUseCase",
    	    "UseCases-UseCase",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "useCase", 
    	    "UseCases-Classifier-useCase",
    	    "UseCases-UseCase",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Extend
    	clss  = (Class_)model.getElementById("UseCases-Extend").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "condition", 
    	    "UseCases-Extend-condition",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "extendedCase", 
    	    "UseCases-Extend-extendedCase",
    	    "UseCases-UseCase",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "extension", 
    	    "UseCases-Extend-extension",
    	    "UseCases-UseCase",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "extensionLocation", 
    	    "UseCases-Extend-extensionLocation",
    	    "UseCases-ExtensionPoint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // ExtensionPoint
    	clss  = (Class_)model.getElementById("UseCases-ExtensionPoint").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "useCase", 
    	    "UseCases-ExtensionPoint-useCase",
    	    "UseCases-UseCase",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // Include
    	clss  = (Class_)model.getElementById("UseCases-Include").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "addition", 
    	    "UseCases-Include-addition",
    	    "UseCases-UseCase",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "includingCase", 
    	    "UseCases-Include-includingCase",
    	    "UseCases-UseCase",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
        // UseCase
    	clss  = (Class_)model.getElementById("UseCases-UseCase").getDelegate();
    	    	
    	prop = factory.createProperty(clss, "extend", 
    	    "UseCases-UseCase-extend",
    	    "UseCases-Extend",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "extensionPoint", 
    	    "UseCases-UseCase-extensionPoint",
    	    "UseCases-ExtensionPoint",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "include", 
    	    "UseCases-UseCase-include",
    	    "UseCases-Include",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	    	
    	prop = factory.createProperty(clss, "subject", 
    	    "UseCases-UseCase-subject",
    	    "UseCases-Classifier",
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(clss, prop, this);    
     	
    	
    }
    
    private void constructGeneralizations()
    {
        Class_ clss = null;
        
    
        // Action
    	clss  = (Class_)model.getElementById("Actions-BasicActions-Action").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // CallAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-CallAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-InvocationAction");
    	
        // CallBehaviorAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-CallBehaviorAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-CallAction");
    	
        // CallOperationAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-CallOperationAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-CallAction");
    	
        // InputPin
    	clss  = (Class_)model.getElementById("Actions-BasicActions-InputPin").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Pin");
    	
        // InvocationAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-InvocationAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // MultiplicityElement
    	clss  = (Class_)model.getElementById("Actions-BasicActions-MultiplicityElement").getDelegate();
    	
        // OpaqueAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-OpaqueAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // OutputPin
    	clss  = (Class_)model.getElementById("Actions-BasicActions-OutputPin").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Pin");
    	
        // Pin
    	clss  = (Class_)model.getElementById("Actions-BasicActions-Pin").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-MultiplicityElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
        // SendSignalAction
    	clss  = (Class_)model.getElementById("Actions-BasicActions-SendSignalAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-InvocationAction");
    	
        // ValuePin
    	clss  = (Class_)model.getElementById("Actions-BasicActions-ValuePin").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-InputPin");
    	
        // AcceptCallAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-AcceptCallAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-CompleteActions-AcceptEventAction");
    	
        // AcceptEventAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-AcceptEventAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // CreateLinkObjectAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-CreateLinkObjectAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-CreateLinkAction");
    	
        // LinkEndData
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-LinkEndData").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // QualifierValue
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-QualifierValue").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // ReadExtentAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReadExtentAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ReadIsClassifiedObjectAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReadIsClassifiedObjectAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ReadLinkObjectEndAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReadLinkObjectEndAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ReadLinkObjectEndQualifierAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReadLinkObjectEndQualifierAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ReclassifyObjectAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReclassifyObjectAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ReduceAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReduceAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ReplyAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-ReplyAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // StartClassifierBehaviorAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-StartClassifierBehaviorAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // StartObjectBehaviorAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-StartObjectBehaviorAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-CallAction");
    	
        // UnmarshallAction
    	clss  = (Class_)model.getElementById("Actions-CompleteActions-UnmarshallAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // AddStructuralFeatureValueAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-AddStructuralFeatureValueAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-WriteStructuralFeatureAction");
    	
        // BroadcastSignalAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-BroadcastSignalAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-InvocationAction");
    	
        // ClearAssociationAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ClearAssociationAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ClearStructuralFeatureAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ClearStructuralFeatureAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-StructuralFeatureAction");
    	
        // CreateLinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-CreateLinkAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-WriteLinkAction");
    	
        // CreateObjectAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-CreateObjectAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // DestroyLinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-DestroyLinkAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-WriteLinkAction");
    	
        // DestroyObjectAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-DestroyObjectAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // LinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-LinkAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // LinkEndCreationData
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-LinkEndCreationData").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-LinkEndData");
    	
        // LinkEndData
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-LinkEndData").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // LinkEndDestructionData
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-LinkEndDestructionData").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-LinkEndData");
    	
        // ReadLinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ReadLinkAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-LinkAction");
    	
        // ReadSelfAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ReadSelfAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ReadStructuralFeatureAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ReadStructuralFeatureAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-StructuralFeatureAction");
    	
        // RemoveStructuralFeatureValueAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-RemoveStructuralFeatureValueAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-WriteStructuralFeatureAction");
    	
        // SendObjectAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-SendObjectAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-InvocationAction");
    	
        // StructuralFeatureAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-StructuralFeatureAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // TestIdentityAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-TestIdentityAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ValueSpecificationAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-ValueSpecificationAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // WriteLinkAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-WriteLinkAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-LinkAction");
    	
        // WriteStructuralFeatureAction
    	clss  = (Class_)model.getElementById("Actions-IntermediateActions-WriteStructuralFeatureAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-IntermediateActions-StructuralFeatureAction");
    	
        // ActionInputPin
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-ActionInputPin").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-InputPin");
    	
        // AddVariableValueAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-AddVariableValueAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-StructuredActions-WriteVariableAction");
    	
        // ClearVariableAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-ClearVariableAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-StructuredActions-VariableAction");
    	
        // RaiseExceptionAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-RaiseExceptionAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // ReadVariableAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-ReadVariableAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-StructuredActions-VariableAction");
    	
        // RemoveVariableValueAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-RemoveVariableValueAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-StructuredActions-WriteVariableAction");
    	
        // VariableAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-VariableAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-BasicActions-Action");
    	
        // WriteVariableAction
    	clss  = (Class_)model.getElementById("Actions-StructuredActions-WriteVariableAction").getDelegate();
    	
    	factory.createGeneralization(clss, "Actions-StructuredActions-VariableAction");
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-Activity").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
    	
        // ActivityEdge
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityEdge").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // ActivityFinalNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityFinalNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityGroup").getDelegate();
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // ActivityParameterNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ActivityParameterNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ObjectNode");
    	
        // ControlFlow
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ControlFlow").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ActivityEdge");
    	
        // ControlNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ControlNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ActivityNode");
    	
        // InitialNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-InitialNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
    	
        // ObjectFlow
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ObjectFlow").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ActivityEdge");
    	
        // ObjectNode
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ObjectNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ActivityNode");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
        // Pin
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-Pin").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ObjectNode");
    	
        // ValuePin
    	clss  = (Class_)model.getElementById("Activities-BasicActivities-ValuePin").getDelegate();
    	
        // Action
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Action").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Activity").getDelegate();
    	
        // ActivityEdge
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ActivityEdge").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ActivityGroup").getDelegate();
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ActivityNode").getDelegate();
    	
        // Behavior
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Behavior").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Class");
    	
        // BehavioralFeature
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-BehavioralFeature").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Feature");
    	
        // DataStoreNode
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-DataStoreNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-IntermediateActivities-CentralBufferNode");
    	
        // InterruptibleActivityRegion
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-InterruptibleActivityRegion").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-CompleteActivities-ActivityGroup");
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ActivityGroup");
    	
        // JoinNode
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-JoinNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
    	
        // ObjectFlow
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ObjectFlow").getDelegate();
    	
        // ObjectNode
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ObjectNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
        // Parameter
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Parameter").getDelegate();
    	
        // ParameterSet
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-ParameterSet").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Pin
    	clss  = (Class_)model.getElementById("Activities-CompleteActivities-Pin").getDelegate();
    	
        // Action
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-Action").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // ActivityEdge
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-ActivityEdge").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-ActivityGroup").getDelegate();
    	
        // Clause
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-Clause").getDelegate();
    	
        // ConditionalNode
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-ConditionalNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-CompleteStructuredActivities-StructuredActivityNode");
    	
        // InputPin
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-InputPin").getDelegate();
    	
        // LoopNode
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-LoopNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-CompleteStructuredActivities-StructuredActivityNode");
    	
        // OutputPin
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-OutputPin").getDelegate();
    	
        // StructuredActivityNode
    	clss  = (Class_)model.getElementById("Activities-CompleteStructuredActivities-StructuredActivityNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-CompleteStructuredActivities-Action");
    	
    	factory.createGeneralization(clss, "Activities-CompleteStructuredActivities-ActivityGroup");
    	
        // ExceptionHandler
    	clss  = (Class_)model.getElementById("Activities-ExtraStructuredActivities-ExceptionHandler").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // ExecutableNode
    	clss  = (Class_)model.getElementById("Activities-ExtraStructuredActivities-ExecutableNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-ActivityNode");
    	
        // ExpansionNode
    	clss  = (Class_)model.getElementById("Activities-ExtraStructuredActivities-ExpansionNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ObjectNode");
    	
        // ExpansionRegion
    	clss  = (Class_)model.getElementById("Activities-ExtraStructuredActivities-ExpansionRegion").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-StructuredActivityNode");
    	
        // Action
    	clss  = (Class_)model.getElementById("Activities-FundamentalActivities-Action").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-FundamentalActivities-ActivityNode");
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-FundamentalActivities-Activity").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-FundamentalActivities-ActivityGroup").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-FundamentalActivities-ActivityNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-Activity").getDelegate();
    	
        // ActivityEdge
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityEdge").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // ActivityFinalNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityFinalNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-IntermediateActivities-FinalNode");
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityGroup").getDelegate();
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // ActivityPartition
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ActivityPartition").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-IntermediateActivities-ActivityGroup");
    	
        // CentralBufferNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-CentralBufferNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ObjectNode");
    	
        // DecisionNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-DecisionNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
    	
        // FinalNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-FinalNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
    	
        // FlowFinalNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-FlowFinalNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-IntermediateActivities-FinalNode");
    	
        // ForkNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-ForkNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
    	
        // JoinNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-JoinNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
    	
        // MergeNode
    	clss  = (Class_)model.getElementById("Activities-IntermediateActivities-MergeNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
    	
        // Action
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-Action").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-ExecutableNode");
    	
        // Activity
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-Activity").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
    	
        // ActivityGroup
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-ActivityGroup").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // ActivityNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-ActivityNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // Clause
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-Clause").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // ConditionalNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-ConditionalNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-StructuredActivityNode");
    	
        // ExecutableNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-ExecutableNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-ActivityNode");
    	
        // LoopNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-LoopNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-StructuredActivityNode");
    	
        // OutputPin
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-OutputPin").getDelegate();
    	
        // SequenceNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-SequenceNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-StructuredActivityNode");
    	
        // StructuredActivityNode
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-StructuredActivityNode").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-ExecutableNode");
    	
    	factory.createGeneralization(clss, "Activities-StructuredActivities-ActivityGroup");
    	
        // Variable
    	clss  = (Class_)model.getElementById("Activities-StructuredActivities-Variable").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-MultiplicityElement");
    	
        // InformationFlow
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-InformationFlows-InformationFlow").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
        // InformationItem
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-InformationFlows-InformationItem").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // Model
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Models-Model").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Package");
    	
        // ExtensionEnd
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Profiles-ExtensionEnd").getDelegate();
    	
        // Classifier
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-Classifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateableElement");
    	
        // ClassifierTemplateParameter
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ClassifierTemplateParameter").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateParameter");
    	
        // ConnectableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ConnectableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
    	
        // ConnectableElementTemplateParameter
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateParameter");
    	
        // NamedElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-NamedElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // Operation
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-Operation").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateableElement");
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
    	
        // OperationTemplateParameter
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-OperationTemplateParameter").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateParameter");
    	
        // Package
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-Package").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateableElement");
    	
        // PackageableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-PackageableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
    	
        // ParameterableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ParameterableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // Property
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-Property").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
    	
        // RedefinableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-RedefinableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // RedefinableTemplateSignature
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-RedefinableTemplateSignature").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-RedefinableElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateSignature");
    	
        // StringExpression
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-StringExpression").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateableElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Expression");
    	
        // TemplateBinding
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateBinding").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
        // TemplateParameter
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateParameter").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // TemplateParameterSubstitution
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateParameterSubstitution").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // TemplateSignature
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateSignature").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // TemplateableElement
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-TemplateableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // ValueSpecification
    	clss  = (Class_)model.getElementById("AuxiliaryConstructs-Templates-ValueSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
    	
        // AssociationClass
    	clss  = (Class_)model.getElementById("Classes-AssociationClasses-AssociationClass").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Association");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Class");
    	
        // Property
    	clss  = (Class_)model.getElementById("Classes-AssociationClasses-Property").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-StructuralFeature");
    	
        // Abstraction
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Abstraction").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Dependency");
    	
        // Classifier
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Classifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Namespace");
    	
        // Dependency
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Dependency").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-PackageableElement");
    	
        // NamedElement
    	clss  = (Class_)model.getElementById("Classes-Dependencies-NamedElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // Namespace
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Namespace").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
    	
        // PackageableElement
    	clss  = (Class_)model.getElementById("Classes-Dependencies-PackageableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
    	
        // Realization
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Realization").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Abstraction");
    	
        // Substitution
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Substitution").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Realization");
    	
        // Usage
    	clss  = (Class_)model.getElementById("Classes-Dependencies-Usage").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Dependency");
    	
        // BehavioredClassifier
    	clss  = (Class_)model.getElementById("Classes-Interfaces-BehavioredClassifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // Classifier
    	clss  = (Class_)model.getElementById("Classes-Interfaces-Classifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Namespace");
    	
        // Interface
    	clss  = (Class_)model.getElementById("Classes-Interfaces-Interface").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Interfaces-Classifier");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // InterfaceRealization
    	clss  = (Class_)model.getElementById("Classes-Interfaces-InterfaceRealization").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Realization");
    	
        // Operation
    	clss  = (Class_)model.getElementById("Classes-Interfaces-Operation").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-BehavioralFeature");
    	
        // Property
    	clss  = (Class_)model.getElementById("Classes-Interfaces-Property").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-StructuralFeature");
    	
        // Association
    	clss  = (Class_)model.getElementById("Classes-Kernel-Association").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Relationship");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // BehavioralFeature
    	clss  = (Class_)model.getElementById("Classes-Kernel-BehavioralFeature").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Feature");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // Class
    	clss  = (Class_)model.getElementById("Classes-Kernel-Class").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // Classifier
    	clss  = (Class_)model.getElementById("Classes-Kernel-Classifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Type");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // Comment
    	clss  = (Class_)model.getElementById("Classes-Kernel-Comment").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // Constraint
    	clss  = (Class_)model.getElementById("Classes-Kernel-Constraint").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
        // DataType
    	clss  = (Class_)model.getElementById("Classes-Kernel-DataType").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // DirectedRelationship
    	clss  = (Class_)model.getElementById("Classes-Kernel-DirectedRelationship").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Relationship");
    	
        // Element
    	clss  = (Class_)model.getElementById("Classes-Kernel-Element").getDelegate();
    	
        // ElementImport
    	clss  = (Class_)model.getElementById("Classes-Kernel-ElementImport").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
        // Enumeration
    	clss  = (Class_)model.getElementById("Classes-Kernel-Enumeration").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DataType");
    	
        // EnumerationLiteral
    	clss  = (Class_)model.getElementById("Classes-Kernel-EnumerationLiteral").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-InstanceSpecification");
    	
        // Expression
    	clss  = (Class_)model.getElementById("Classes-Kernel-Expression").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
    	
        // Feature
    	clss  = (Class_)model.getElementById("Classes-Kernel-Feature").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // Generalization
    	clss  = (Class_)model.getElementById("Classes-Kernel-Generalization").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
        // InstanceSpecification
    	clss  = (Class_)model.getElementById("Classes-Kernel-InstanceSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
        // InstanceValue
    	clss  = (Class_)model.getElementById("Classes-Kernel-InstanceValue").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
    	
        // LiteralBoolean
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralBoolean").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
    	
        // LiteralInteger
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralInteger").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
    	
        // LiteralNull
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralNull").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
    	
        // LiteralReal
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralReal").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
    	
        // LiteralSpecification
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
    	
        // LiteralString
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralString").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
    	
        // LiteralUnlimitedNatural
    	clss  = (Class_)model.getElementById("Classes-Kernel-LiteralUnlimitedNatural").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
    	
        // MultiplicityElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-MultiplicityElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // NamedElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-NamedElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // Namespace
    	clss  = (Class_)model.getElementById("Classes-Kernel-Namespace").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // OpaqueExpression
    	clss  = (Class_)model.getElementById("Classes-Kernel-OpaqueExpression").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
    	
        // Operation
    	clss  = (Class_)model.getElementById("Classes-Kernel-Operation").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-BehavioralFeature");
    	
        // Package
    	clss  = (Class_)model.getElementById("Classes-Kernel-Package").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
        // PackageImport
    	clss  = (Class_)model.getElementById("Classes-Kernel-PackageImport").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
        // PackageMerge
    	clss  = (Class_)model.getElementById("Classes-Kernel-PackageMerge").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
        // PackageableElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-PackageableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Parameter
    	clss  = (Class_)model.getElementById("Classes-Kernel-Parameter").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-MultiplicityElement");
    	
        // PrimitiveType
    	clss  = (Class_)model.getElementById("Classes-Kernel-PrimitiveType").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DataType");
    	
        // Property
    	clss  = (Class_)model.getElementById("Classes-Kernel-Property").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-StructuralFeature");
    	
        // RedefinableElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-RedefinableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Relationship
    	clss  = (Class_)model.getElementById("Classes-Kernel-Relationship").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // Slot
    	clss  = (Class_)model.getElementById("Classes-Kernel-Slot").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Element");
    	
        // StructuralFeature
    	clss  = (Class_)model.getElementById("Classes-Kernel-StructuralFeature").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Feature");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-MultiplicityElement");
    	
        // Type
    	clss  = (Class_)model.getElementById("Classes-Kernel-Type").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
        // TypedElement
    	clss  = (Class_)model.getElementById("Classes-Kernel-TypedElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // ValueSpecification
    	clss  = (Class_)model.getElementById("Classes-Kernel-ValueSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
        // Classifier
    	clss  = (Class_)model.getElementById("Classes-PowerTypes-Classifier").getDelegate();
    	
        // Generalization
    	clss  = (Class_)model.getElementById("Classes-PowerTypes-Generalization").getDelegate();
    	
        // GeneralizationSet
    	clss  = (Class_)model.getElementById("Classes-PowerTypes-GeneralizationSet").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
        // Behavior
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-Behavior").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Class");
    	
        // BehavioralFeature
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-BehavioralFeature").getDelegate();
    	
        // BehavioredClassifier
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-BehavioredClassifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // FunctionBehavior
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-FunctionBehavior").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-OpaqueBehavior");
    	
        // OpaqueBehavior
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-OpaqueBehavior").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
    	
        // OpaqueExpression
    	clss  = (Class_)model.getElementById("CommonBehaviors-BasicBehaviors-OpaqueExpression").getDelegate();
    	
        // AnyReceiveEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-AnyReceiveEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-MessageEvent");
    	
        // BehavioralFeature
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-BehavioralFeature").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Feature");
    	
        // CallEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-CallEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-MessageEvent");
    	
        // ChangeEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-ChangeEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-Event");
    	
        // Class
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Class").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-BehavioredClassifier");
    	
        // Event
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Event").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
        // Interface
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Interface").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // MessageEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-MessageEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-Event");
    	
        // Operation
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Operation").getDelegate();
    	
        // Reception
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Reception").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-BehavioralFeature");
    	
        // Signal
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Signal").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // SignalEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-SignalEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-MessageEvent");
    	
        // Trigger
    	clss  = (Class_)model.getElementById("CommonBehaviors-Communications-Trigger").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Duration
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-Duration").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
    	
        // DurationConstraint
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-DurationConstraint").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-IntervalConstraint");
    	
        // DurationInterval
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-DurationInterval").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-Interval");
    	
        // DurationObservation
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-DurationObservation").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-Observation");
    	
        // Interval
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-Interval").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
    	
        // IntervalConstraint
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-IntervalConstraint").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Constraint");
    	
        // Observation
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-Observation").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
    	
        // TimeConstraint
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeConstraint").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-IntervalConstraint");
    	
        // TimeEvent
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeEvent").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-Communications-Event");
    	
        // TimeExpression
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeExpression").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
    	
        // TimeInterval
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeInterval").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-Interval");
    	
        // TimeObservation
    	clss  = (Class_)model.getElementById("CommonBehaviors-SimpleTime-TimeObservation").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-Observation");
    	
        // Component
    	clss  = (Class_)model.getElementById("Components-BasicComponents-Component").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Class");
    	
    	factory.createGeneralization(clss, "CompositeStructures-StructuredClasses-Class");
    	
        // ComponentRealization
    	clss  = (Class_)model.getElementById("Components-BasicComponents-ComponentRealization").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Realization");
    	
        // ConnectableElement
    	clss  = (Class_)model.getElementById("Components-BasicComponents-ConnectableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
        // Connector
    	clss  = (Class_)model.getElementById("Components-BasicComponents-Connector").getDelegate();
    	
        // ConnectorEnd
    	clss  = (Class_)model.getElementById("Components-BasicComponents-ConnectorEnd").getDelegate();
    	
        // Component
    	clss  = (Class_)model.getElementById("Components-PackagingComponents-Component").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-StructuredClasses-Class");
    	
        // Classifier
    	clss  = (Class_)model.getElementById("CompositeStructures-Collaborations-Classifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // Collaboration
    	clss  = (Class_)model.getElementById("CompositeStructures-Collaborations-Collaboration").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-InternalStructures-StructuredClassifier");
    	
    	factory.createGeneralization(clss, "CompositeStructures-Collaborations-Classifier");
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-BehavioredClassifier");
    	
        // CollaborationUse
    	clss  = (Class_)model.getElementById("CompositeStructures-Collaborations-CollaborationUse").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Parameter
    	clss  = (Class_)model.getElementById("CompositeStructures-Collaborations-Parameter").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-InternalStructures-ConnectableElement");
    	
        // Class
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-Class").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-InternalStructures-StructuredClassifier");
    	
        // Classifier
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-Classifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // ConnectableElement
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-ConnectableElement").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
    	
        // Connector
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-Connector").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Feature");
    	
    	factory.createGeneralization(clss, "CompositeStructures-InternalStructures-Feature");
    	
        // ConnectorEnd
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-ConnectorEnd").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-MultiplicityElement");
    	
        // Feature
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-Feature").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // Property
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-Property").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-StructuralFeature");
    	
    	factory.createGeneralization(clss, "CompositeStructures-InternalStructures-ConnectableElement");
    	
        // StructuredClassifier
    	clss  = (Class_)model.getElementById("CompositeStructures-InternalStructures-StructuredClassifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
    	factory.createGeneralization(clss, "CompositeStructures-InternalStructures-Classifier");
    	
        // InvocationAction
    	clss  = (Class_)model.getElementById("CompositeStructures-InvocationActions-InvocationAction").getDelegate();
    	
        // Trigger
    	clss  = (Class_)model.getElementById("CompositeStructures-InvocationActions-Trigger").getDelegate();
    	
        // ConnectorEnd
    	clss  = (Class_)model.getElementById("CompositeStructures-Ports-ConnectorEnd").getDelegate();
    	
        // EncapsulatedClassifier
    	clss  = (Class_)model.getElementById("CompositeStructures-Ports-EncapsulatedClassifier").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-InternalStructures-StructuredClassifier");
    	
        // Port
    	clss  = (Class_)model.getElementById("CompositeStructures-Ports-Port").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-InternalStructures-Property");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Property");
    	
        // Variable
    	clss  = (Class_)model.getElementById("CompositeStructures-StructuredActivities-Variable").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-InternalStructures-ConnectableElement");
    	
        // Class
    	clss  = (Class_)model.getElementById("CompositeStructures-StructuredClasses-Class").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-Ports-EncapsulatedClassifier");
    	
        // Artifact
    	clss  = (Class_)model.getElementById("Deployments-Artifacts-Artifact").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
    	
        // Manifestation
    	clss  = (Class_)model.getElementById("Deployments-Artifacts-Manifestation").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Abstraction");
    	
        // Deployment
    	clss  = (Class_)model.getElementById("Deployments-ComponentDeployments-Deployment").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Dependency");
    	
        // DeploymentSpecification
    	clss  = (Class_)model.getElementById("Deployments-ComponentDeployments-DeploymentSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Deployments-Nodes-Artifact");
    	
        // Artifact
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Artifact").getDelegate();
    	
    	factory.createGeneralization(clss, "Deployments-Nodes-DeployedArtifact");
    	
        // CommunicationPath
    	clss  = (Class_)model.getElementById("Deployments-Nodes-CommunicationPath").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Association");
    	
        // DeployedArtifact
    	clss  = (Class_)model.getElementById("Deployments-Nodes-DeployedArtifact").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
    	
        // Deployment
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Deployment").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-Dependency");
    	
        // DeploymentTarget
    	clss  = (Class_)model.getElementById("Deployments-Nodes-DeploymentTarget").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
    	
        // Device
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Device").getDelegate();
    	
    	factory.createGeneralization(clss, "Deployments-Nodes-Node");
    	
        // ExecutionEnvironment
    	clss  = (Class_)model.getElementById("Deployments-Nodes-ExecutionEnvironment").getDelegate();
    	
    	factory.createGeneralization(clss, "Deployments-Nodes-Node");
    	
        // InstanceSpecification
    	clss  = (Class_)model.getElementById("Deployments-Nodes-InstanceSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Deployments-Nodes-DeployedArtifact");
    	
    	factory.createGeneralization(clss, "Deployments-Nodes-DeploymentTarget");
    	
        // Node
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Node").getDelegate();
    	
    	factory.createGeneralization(clss, "CompositeStructures-StructuredClasses-Class");
    	
    	factory.createGeneralization(clss, "Deployments-Nodes-DeploymentTarget");
    	
        // Property
    	clss  = (Class_)model.getElementById("Deployments-Nodes-Property").getDelegate();
    	
    	factory.createGeneralization(clss, "Deployments-Nodes-DeploymentTarget");
    	
        // ActionExecutionSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ActionExecutionSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-ExecutionSpecification");
    	
        // BehaviorExecutionSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-BehaviorExecutionSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-ExecutionSpecification");
    	
        // DestructionOccurrenceSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-DestructionOccurrenceSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-MessageOccurrenceSpecification");
    	
        // ExecutionOccurrenceSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ExecutionOccurrenceSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-OccurrenceSpecification");
    	
        // ExecutionSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-ExecutionSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-InteractionFragment");
    	
        // GeneralOrdering
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-GeneralOrdering").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Interaction
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-Interaction").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-InteractionFragment");
    	
        // InteractionFragment
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-InteractionFragment").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Lifeline
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-Lifeline").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Message
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-Message").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // MessageEnd
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-MessageEnd").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // MessageOccurrenceSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-MessageOccurrenceSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-OccurrenceSpecification");
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-MessageEnd");
    	
        // OccurrenceSpecification
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-OccurrenceSpecification").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-InteractionFragment");
    	
        // StateInvariant
    	clss  = (Class_)model.getElementById("Interactions-BasicInteractions-StateInvariant").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-InteractionFragment");
    	
        // CombinedFragment
    	clss  = (Class_)model.getElementById("Interactions-Fragments-CombinedFragment").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-Fragments-InteractionFragment");
    	
        // ConsiderIgnoreFragment
    	clss  = (Class_)model.getElementById("Interactions-Fragments-ConsiderIgnoreFragment").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-Fragments-CombinedFragment");
    	
        // Continuation
    	clss  = (Class_)model.getElementById("Interactions-Fragments-Continuation").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-Fragments-InteractionFragment");
    	
        // Gate
    	clss  = (Class_)model.getElementById("Interactions-Fragments-Gate").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-BasicInteractions-MessageEnd");
    	
        // Interaction
    	clss  = (Class_)model.getElementById("Interactions-Fragments-Interaction").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
    	
        // InteractionConstraint
    	clss  = (Class_)model.getElementById("Interactions-Fragments-InteractionConstraint").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Constraint");
    	
        // InteractionFragment
    	clss  = (Class_)model.getElementById("Interactions-Fragments-InteractionFragment").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // InteractionOperand
    	clss  = (Class_)model.getElementById("Interactions-Fragments-InteractionOperand").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
    	factory.createGeneralization(clss, "Interactions-Fragments-InteractionFragment");
    	
        // InteractionUse
    	clss  = (Class_)model.getElementById("Interactions-Fragments-InteractionUse").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-Fragments-InteractionFragment");
    	
        // Lifeline
    	clss  = (Class_)model.getElementById("Interactions-Fragments-Lifeline").getDelegate();
    	
        // PartDecomposition
    	clss  = (Class_)model.getElementById("Interactions-Fragments-PartDecomposition").getDelegate();
    	
    	factory.createGeneralization(clss, "Interactions-Fragments-InteractionUse");
    	
        // ConnectionPointReference
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-ConnectionPointReference").getDelegate();
    	
    	factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-Vertex");
    	
        // FinalState
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-FinalState").getDelegate();
    	
    	factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-State");
    	
        // Pseudostate
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-Pseudostate").getDelegate();
    	
    	factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-Vertex");
    	
        // Region
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-Region").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // State
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-State").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
    	factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-Vertex");
    	
        // StateMachine
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-StateMachine").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
    	
        // TimeEvent
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-TimeEvent").getDelegate();
    	
        // Transition
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-Transition").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // Vertex
    	clss  = (Class_)model.getElementById("StateMachines-BehaviorStateMachines-Vertex").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // Interface
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-Interface").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Classifier");
    	
        // Port
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-Port").getDelegate();
    	
        // ProtocolConformance
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-ProtocolConformance").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
        // ProtocolStateMachine
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-ProtocolStateMachine").getDelegate();
    	
    	factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-StateMachine");
    	
        // ProtocolTransition
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-ProtocolTransition").getDelegate();
    	
    	factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-Transition");
    	
        // Region
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-Region").getDelegate();
    	
        // State
    	clss  = (Class_)model.getElementById("StateMachines-ProtocolStateMachines-State").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // Actor
    	clss  = (Class_)model.getElementById("UseCases-Actor").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-BehavioredClassifier");
    	
        // Classifier
    	clss  = (Class_)model.getElementById("UseCases-Classifier").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-Namespace");
    	
        // Extend
    	clss  = (Class_)model.getElementById("UseCases-Extend").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
        // ExtensionPoint
    	clss  = (Class_)model.getElementById("UseCases-ExtensionPoint").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
    	
        // Include
    	clss  = (Class_)model.getElementById("UseCases-Include").getDelegate();
    	
    	factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
    	
    	factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
    	
        // UseCase
    	clss  = (Class_)model.getElementById("UseCases-UseCase").getDelegate();
    	
    	factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-BehavioredClassifier");
    	
    }

    private void constructAssociations()
    {
        Package pkg = null;
        String packageId = null;
        Association assoc = null;
        Property prop = null;
        
                                                      
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.A_argument_invocationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_argument_invocationAction", "Actions-BasicActions-A_argument_invocationAction");
        mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "invocationAction", 
    	    "Actions-BasicActions-A_argument_invocationAction-invocationAction",
    	    "Actions-BasicActions-InvocationAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-BasicActions-InvocationAction-argument Actions-BasicActions-A_argument_invocationAction-invocationAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.A_behavior_callBehaviorAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_behavior_callBehaviorAction", "Actions-BasicActions-A_behavior_callBehaviorAction");
        mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "callBehaviorAction", 
    	    "Actions-BasicActions-A_behavior_callBehaviorAction-callBehaviorAction",
    	    "Actions-BasicActions-CallBehaviorAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-BasicActions-CallBehaviorAction-behavior Actions-BasicActions-A_behavior_callBehaviorAction-callBehaviorAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.A_context_action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_context_action", "Actions-BasicActions-A_context_action");
        mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "action", 
    	    "Actions-BasicActions-A_context_action-action",
    	    "Actions-BasicActions-Action",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-BasicActions-Action-context Actions-BasicActions-A_context_action-action");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.A_inputValue_opaqueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_inputValue_opaqueAction", "Actions-BasicActions-A_inputValue_opaqueAction");
        mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "opaqueAction", 
    	    "Actions-BasicActions-A_inputValue_opaqueAction-opaqueAction",
    	    "Actions-BasicActions-OpaqueAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-BasicActions-OpaqueAction-inputValue Actions-BasicActions-A_inputValue_opaqueAction-opaqueAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.A_input_action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_input_action", "Actions-BasicActions-A_input_action");
        mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "action", 
    	    "Actions-BasicActions-A_input_action-action",
    	    "Actions-BasicActions-Action",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-BasicActions-Action-input Actions-BasicActions-A_input_action-action");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.A_operation_callOperationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_operation_callOperationAction", "Actions-BasicActions-A_operation_callOperationAction");
        mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "callOperationAction", 
    	    "Actions-BasicActions-A_operation_callOperationAction-callOperationAction",
    	    "Actions-BasicActions-CallOperationAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-BasicActions-CallOperationAction-operation Actions-BasicActions-A_operation_callOperationAction-callOperationAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.A_outputValue_opaqueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_outputValue_opaqueAction", "Actions-BasicActions-A_outputValue_opaqueAction");
        mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "opaqueAction", 
    	    "Actions-BasicActions-A_outputValue_opaqueAction-opaqueAction",
    	    "Actions-BasicActions-OpaqueAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-BasicActions-OpaqueAction-outputValue Actions-BasicActions-A_outputValue_opaqueAction-opaqueAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.A_output_action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_output_action", "Actions-BasicActions-A_output_action");
        mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "action", 
    	    "Actions-BasicActions-A_output_action-action",
    	    "Actions-BasicActions-Action",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-BasicActions-Action-output Actions-BasicActions-A_output_action-action");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.A_result_callAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_callAction", "Actions-BasicActions-A_result_callAction");
        mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "callAction", 
    	    "Actions-BasicActions-A_result_callAction-callAction",
    	    "Actions-BasicActions-CallAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-BasicActions-CallAction-result Actions-BasicActions-A_result_callAction-callAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.A_signal_sendSignalAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_signal_sendSignalAction", "Actions-BasicActions-A_signal_sendSignalAction");
        mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "sendSignalAction", 
    	    "Actions-BasicActions-A_signal_sendSignalAction-sendSignalAction",
    	    "Actions-BasicActions-SendSignalAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-BasicActions-SendSignalAction-signal Actions-BasicActions-A_signal_sendSignalAction-sendSignalAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.A_target_callOperationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_target_callOperationAction", "Actions-BasicActions-A_target_callOperationAction");
        mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "callOperationAction", 
    	    "Actions-BasicActions-A_target_callOperationAction-callOperationAction",
    	    "Actions-BasicActions-CallOperationAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-BasicActions-CallOperationAction-target Actions-BasicActions-A_target_callOperationAction-callOperationAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.A_target_sendSignalAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_target_sendSignalAction", "Actions-BasicActions-A_target_sendSignalAction");
        mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "sendSignalAction", 
    	    "Actions-BasicActions-A_target_sendSignalAction-sendSignalAction",
    	    "Actions-BasicActions-SendSignalAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-BasicActions-SendSignalAction-target Actions-BasicActions-A_target_sendSignalAction-sendSignalAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";   
                      
        // UML.Actions.BasicActions.A_value_valuePin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_value_valuePin", "Actions-BasicActions-A_value_valuePin");
        mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "valuePin", 
    	    "Actions-BasicActions-A_value_valuePin-valuePin",
    	    "Actions-BasicActions-ValuePin",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-BasicActions-ValuePin-value Actions-BasicActions-A_value_valuePin-valuePin");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_classifier_readExtentAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_classifier_readExtentAction", "Actions-CompleteActions-A_classifier_readExtentAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readExtentAction", 
    	    "Actions-CompleteActions-A_classifier_readExtentAction-readExtentAction",
    	    "Actions-CompleteActions-ReadExtentAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadExtentAction-classifier Actions-CompleteActions-A_classifier_readExtentAction-readExtentAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_classifier_readIsClassifiedObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_classifier_readIsClassifiedObjectAction", "Actions-CompleteActions-A_classifier_readIsClassifiedObjectAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readIsClassifiedObjectAction", 
    	    "Actions-CompleteActions-A_classifier_readIsClassifiedObjectAction-readIsClassifiedObjectAction",
    	    "Actions-CompleteActions-ReadIsClassifiedObjectAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadIsClassifiedObjectAction-classifier Actions-CompleteActions-A_classifier_readIsClassifiedObjectAction-readIsClassifiedObjectAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_collection_reduceAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_collection_reduceAction", "Actions-CompleteActions-A_collection_reduceAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "reduceAction", 
    	    "Actions-CompleteActions-A_collection_reduceAction-reduceAction",
    	    "Actions-CompleteActions-ReduceAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReduceAction-collection Actions-CompleteActions-A_collection_reduceAction-reduceAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_end_readLinkObjectEndAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_end_readLinkObjectEndAction", "Actions-CompleteActions-A_end_readLinkObjectEndAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readLinkObjectEndAction", 
    	    "Actions-CompleteActions-A_end_readLinkObjectEndAction-readLinkObjectEndAction",
    	    "Actions-CompleteActions-ReadLinkObjectEndAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndAction-end Actions-CompleteActions-A_end_readLinkObjectEndAction-readLinkObjectEndAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_newClassifier_reclassifyObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_newClassifier_reclassifyObjectAction", "Actions-CompleteActions-A_newClassifier_reclassifyObjectAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "reclassifyObjectAction", 
    	    "Actions-CompleteActions-A_newClassifier_reclassifyObjectAction-reclassifyObjectAction",
    	    "Actions-CompleteActions-ReclassifyObjectAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReclassifyObjectAction-newClassifier Actions-CompleteActions-A_newClassifier_reclassifyObjectAction-reclassifyObjectAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_object_readIsClassifiedObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_readIsClassifiedObjectAction", "Actions-CompleteActions-A_object_readIsClassifiedObjectAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readIsClassifiedObjectAction", 
    	    "Actions-CompleteActions-A_object_readIsClassifiedObjectAction-readIsClassifiedObjectAction",
    	    "Actions-CompleteActions-ReadIsClassifiedObjectAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadIsClassifiedObjectAction-object Actions-CompleteActions-A_object_readIsClassifiedObjectAction-readIsClassifiedObjectAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_object_readLinkObjectEndAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_readLinkObjectEndAction", "Actions-CompleteActions-A_object_readLinkObjectEndAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readLinkObjectEndAction", 
    	    "Actions-CompleteActions-A_object_readLinkObjectEndAction-readLinkObjectEndAction",
    	    "Actions-CompleteActions-ReadLinkObjectEndAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndAction-object Actions-CompleteActions-A_object_readLinkObjectEndAction-readLinkObjectEndAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_object_readLinkObjectEndQualifierAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_readLinkObjectEndQualifierAction", "Actions-CompleteActions-A_object_readLinkObjectEndQualifierAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readLinkObjectEndQualifierAction", 
    	    "Actions-CompleteActions-A_object_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction",
    	    "Actions-CompleteActions-ReadLinkObjectEndQualifierAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-object Actions-CompleteActions-A_object_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_object_reclassifyObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_reclassifyObjectAction", "Actions-CompleteActions-A_object_reclassifyObjectAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "reclassifyObjectAction", 
    	    "Actions-CompleteActions-A_object_reclassifyObjectAction-reclassifyObjectAction",
    	    "Actions-CompleteActions-ReclassifyObjectAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReclassifyObjectAction-object Actions-CompleteActions-A_object_reclassifyObjectAction-reclassifyObjectAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_object_startClassifierBehaviorAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_startClassifierBehaviorAction", "Actions-CompleteActions-A_object_startClassifierBehaviorAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "startClassifierBehaviorAction", 
    	    "Actions-CompleteActions-A_object_startClassifierBehaviorAction-startClassifierBehaviorAction",
    	    "Actions-CompleteActions-StartClassifierBehaviorAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-StartClassifierBehaviorAction-object Actions-CompleteActions-A_object_startClassifierBehaviorAction-startClassifierBehaviorAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_object_startObjectBehaviorAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_startObjectBehaviorAction", "Actions-CompleteActions-A_object_startObjectBehaviorAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "startObjectBehaviorAction", 
    	    "Actions-CompleteActions-A_object_startObjectBehaviorAction-startObjectBehaviorAction",
    	    "Actions-CompleteActions-StartObjectBehaviorAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-StartObjectBehaviorAction-object Actions-CompleteActions-A_object_startObjectBehaviorAction-startObjectBehaviorAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_object_unmarshallAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_unmarshallAction", "Actions-CompleteActions-A_object_unmarshallAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "unmarshallAction", 
    	    "Actions-CompleteActions-A_object_unmarshallAction-unmarshallAction",
    	    "Actions-CompleteActions-UnmarshallAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-UnmarshallAction-object Actions-CompleteActions-A_object_unmarshallAction-unmarshallAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_oldClassifier_reclassifyObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_oldClassifier_reclassifyObjectAction", "Actions-CompleteActions-A_oldClassifier_reclassifyObjectAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "reclassifyObjectAction", 
    	    "Actions-CompleteActions-A_oldClassifier_reclassifyObjectAction-reclassifyObjectAction",
    	    "Actions-CompleteActions-ReclassifyObjectAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReclassifyObjectAction-oldClassifier Actions-CompleteActions-A_oldClassifier_reclassifyObjectAction-reclassifyObjectAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_qualifier_linkEndData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_qualifier_linkEndData", "Actions-CompleteActions-A_qualifier_linkEndData");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "linkEndData", 
    	    "Actions-CompleteActions-A_qualifier_linkEndData-linkEndData",
    	    "Actions-CompleteActions-LinkEndData",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-LinkEndData-qualifier Actions-CompleteActions-A_qualifier_linkEndData-linkEndData");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_qualifier_qualifierValue 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_qualifier_qualifierValue", "Actions-CompleteActions-A_qualifier_qualifierValue");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "qualifierValue", 
    	    "Actions-CompleteActions-A_qualifier_qualifierValue-qualifierValue",
    	    "Actions-CompleteActions-QualifierValue",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-QualifierValue-qualifier Actions-CompleteActions-A_qualifier_qualifierValue-qualifierValue");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_qualifier_readLinkObjectEndQualifierAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_qualifier_readLinkObjectEndQualifierAction", "Actions-CompleteActions-A_qualifier_readLinkObjectEndQualifierAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readLinkObjectEndQualifierAction", 
    	    "Actions-CompleteActions-A_qualifier_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction",
    	    "Actions-CompleteActions-ReadLinkObjectEndQualifierAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-qualifier Actions-CompleteActions-A_qualifier_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_reducer_reduceAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_reducer_reduceAction", "Actions-CompleteActions-A_reducer_reduceAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "reduceAction", 
    	    "Actions-CompleteActions-A_reducer_reduceAction-reduceAction",
    	    "Actions-CompleteActions-ReduceAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReduceAction-reducer Actions-CompleteActions-A_reducer_reduceAction-reduceAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_replyToCall_replyAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_replyToCall_replyAction", "Actions-CompleteActions-A_replyToCall_replyAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "replyAction", 
    	    "Actions-CompleteActions-A_replyToCall_replyAction-replyAction",
    	    "Actions-CompleteActions-ReplyAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReplyAction-replyToCall Actions-CompleteActions-A_replyToCall_replyAction-replyAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_replyValue_replyAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_replyValue_replyAction", "Actions-CompleteActions-A_replyValue_replyAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "replyAction", 
    	    "Actions-CompleteActions-A_replyValue_replyAction-replyAction",
    	    "Actions-CompleteActions-ReplyAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReplyAction-replyValue Actions-CompleteActions-A_replyValue_replyAction-replyAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_result_acceptEventAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_acceptEventAction", "Actions-CompleteActions-A_result_acceptEventAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "acceptEventAction", 
    	    "Actions-CompleteActions-A_result_acceptEventAction-acceptEventAction",
    	    "Actions-CompleteActions-AcceptEventAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-AcceptEventAction-result Actions-CompleteActions-A_result_acceptEventAction-acceptEventAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_result_createLinkObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_createLinkObjectAction", "Actions-CompleteActions-A_result_createLinkObjectAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "createLinkObjectAction", 
    	    "Actions-CompleteActions-A_result_createLinkObjectAction-createLinkObjectAction",
    	    "Actions-CompleteActions-CreateLinkObjectAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-CreateLinkObjectAction-result Actions-CompleteActions-A_result_createLinkObjectAction-createLinkObjectAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_result_readExtentAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_readExtentAction", "Actions-CompleteActions-A_result_readExtentAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readExtentAction", 
    	    "Actions-CompleteActions-A_result_readExtentAction-readExtentAction",
    	    "Actions-CompleteActions-ReadExtentAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadExtentAction-result Actions-CompleteActions-A_result_readExtentAction-readExtentAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_result_readIsClassifiedObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_readIsClassifiedObjectAction", "Actions-CompleteActions-A_result_readIsClassifiedObjectAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readIsClassifiedObjectAction", 
    	    "Actions-CompleteActions-A_result_readIsClassifiedObjectAction-readIsClassifiedObjectAction",
    	    "Actions-CompleteActions-ReadIsClassifiedObjectAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadIsClassifiedObjectAction-result Actions-CompleteActions-A_result_readIsClassifiedObjectAction-readIsClassifiedObjectAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_result_readLinkObjectEndAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_readLinkObjectEndAction", "Actions-CompleteActions-A_result_readLinkObjectEndAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readLinkObjectEndAction", 
    	    "Actions-CompleteActions-A_result_readLinkObjectEndAction-readLinkObjectEndAction",
    	    "Actions-CompleteActions-ReadLinkObjectEndAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndAction-result Actions-CompleteActions-A_result_readLinkObjectEndAction-readLinkObjectEndAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_result_readLinkObjectEndQualifierAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_readLinkObjectEndQualifierAction", "Actions-CompleteActions-A_result_readLinkObjectEndQualifierAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readLinkObjectEndQualifierAction", 
    	    "Actions-CompleteActions-A_result_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction",
    	    "Actions-CompleteActions-ReadLinkObjectEndQualifierAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-result Actions-CompleteActions-A_result_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_result_reduceAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_reduceAction", "Actions-CompleteActions-A_result_reduceAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "reduceAction", 
    	    "Actions-CompleteActions-A_result_reduceAction-reduceAction",
    	    "Actions-CompleteActions-ReduceAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReduceAction-result Actions-CompleteActions-A_result_reduceAction-reduceAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_result_unmarshallAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_unmarshallAction", "Actions-CompleteActions-A_result_unmarshallAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "unmarshallAction", 
    	    "Actions-CompleteActions-A_result_unmarshallAction-unmarshallAction",
    	    "Actions-CompleteActions-UnmarshallAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-UnmarshallAction-result Actions-CompleteActions-A_result_unmarshallAction-unmarshallAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_returnInformation_acceptCallAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_returnInformation_acceptCallAction", "Actions-CompleteActions-A_returnInformation_acceptCallAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "acceptCallAction", 
    	    "Actions-CompleteActions-A_returnInformation_acceptCallAction-acceptCallAction",
    	    "Actions-CompleteActions-AcceptCallAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-AcceptCallAction-returnInformation Actions-CompleteActions-A_returnInformation_acceptCallAction-acceptCallAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_returnInformation_replyAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_returnInformation_replyAction", "Actions-CompleteActions-A_returnInformation_replyAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "replyAction", 
    	    "Actions-CompleteActions-A_returnInformation_replyAction-replyAction",
    	    "Actions-CompleteActions-ReplyAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReplyAction-returnInformation Actions-CompleteActions-A_returnInformation_replyAction-replyAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_trigger_acceptEventAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_trigger_acceptEventAction", "Actions-CompleteActions-A_trigger_acceptEventAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "acceptEventAction", 
    	    "Actions-CompleteActions-A_trigger_acceptEventAction-acceptEventAction",
    	    "Actions-CompleteActions-AcceptEventAction",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-AcceptEventAction-trigger Actions-CompleteActions-A_trigger_acceptEventAction-acceptEventAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_unmarshallType_unmarshallAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_unmarshallType_unmarshallAction", "Actions-CompleteActions-A_unmarshallType_unmarshallAction");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "unmarshallAction", 
    	    "Actions-CompleteActions-A_unmarshallType_unmarshallAction-unmarshallAction",
    	    "Actions-CompleteActions-UnmarshallAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-UnmarshallAction-unmarshallType Actions-CompleteActions-A_unmarshallType_unmarshallAction-unmarshallAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";   
                      
        // UML.Actions.CompleteActions.A_value_qualifierValue 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_value_qualifierValue", "Actions-CompleteActions-A_value_qualifierValue");
        mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "qualifierValue", 
    	    "Actions-CompleteActions-A_value_qualifierValue-qualifierValue",
    	    "Actions-CompleteActions-QualifierValue",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-CompleteActions-QualifierValue-value Actions-CompleteActions-A_value_qualifierValue-qualifierValue");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_association_clearAssociationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_association_clearAssociationAction", "Actions-IntermediateActions-A_association_clearAssociationAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "clearAssociationAction", 
    	    "Actions-IntermediateActions-A_association_clearAssociationAction-clearAssociationAction",
    	    "Actions-IntermediateActions-ClearAssociationAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ClearAssociationAction-association Actions-IntermediateActions-A_association_clearAssociationAction-clearAssociationAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_classifier_createObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_classifier_createObjectAction", "Actions-IntermediateActions-A_classifier_createObjectAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "createObjectAction", 
    	    "Actions-IntermediateActions-A_classifier_createObjectAction-createObjectAction",
    	    "Actions-IntermediateActions-CreateObjectAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-CreateObjectAction-classifier Actions-IntermediateActions-A_classifier_createObjectAction-createObjectAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_destroyAt_linkEndDestructionData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_destroyAt_linkEndDestructionData", "Actions-IntermediateActions-A_destroyAt_linkEndDestructionData");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "linkEndDestructionData", 
    	    "Actions-IntermediateActions-A_destroyAt_linkEndDestructionData-linkEndDestructionData",
    	    "Actions-IntermediateActions-LinkEndDestructionData",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkEndDestructionData-destroyAt Actions-IntermediateActions-A_destroyAt_linkEndDestructionData-linkEndDestructionData");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_endData_createLinkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_endData_createLinkAction", "Actions-IntermediateActions-A_endData_createLinkAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "createLinkAction", 
    	    "Actions-IntermediateActions-A_endData_createLinkAction-createLinkAction",
    	    "Actions-IntermediateActions-CreateLinkAction",
    	    "",    	    
    	    "Actions-IntermediateActions-A_endData_linkAction-linkAction",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-CreateLinkAction-endData Actions-IntermediateActions-A_endData_createLinkAction-createLinkAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_endData_destroyLinkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_endData_destroyLinkAction", "Actions-IntermediateActions-A_endData_destroyLinkAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "destroyLinkAction", 
    	    "Actions-IntermediateActions-A_endData_destroyLinkAction-destroyLinkAction",
    	    "Actions-IntermediateActions-DestroyLinkAction",
    	    "",    	    
    	    "Actions-IntermediateActions-A_endData_linkAction-linkAction",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-DestroyLinkAction-endData Actions-IntermediateActions-A_endData_destroyLinkAction-destroyLinkAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_endData_linkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_endData_linkAction", "Actions-IntermediateActions-A_endData_linkAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "linkAction", 
    	    "Actions-IntermediateActions-A_endData_linkAction-linkAction",
    	    "Actions-IntermediateActions-LinkAction",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkAction-endData Actions-IntermediateActions-A_endData_linkAction-linkAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_end_linkEndData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_end_linkEndData", "Actions-IntermediateActions-A_end_linkEndData");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "linkEndData", 
    	    "Actions-IntermediateActions-A_end_linkEndData-linkEndData",
    	    "Actions-IntermediateActions-LinkEndData",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkEndData-end Actions-IntermediateActions-A_end_linkEndData-linkEndData");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_first_testIdentityAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_first_testIdentityAction", "Actions-IntermediateActions-A_first_testIdentityAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "testIdentityAction", 
    	    "Actions-IntermediateActions-A_first_testIdentityAction-testIdentityAction",
    	    "Actions-IntermediateActions-TestIdentityAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-TestIdentityAction-first Actions-IntermediateActions-A_first_testIdentityAction-testIdentityAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_inputValue_linkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_inputValue_linkAction", "Actions-IntermediateActions-A_inputValue_linkAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "linkAction", 
    	    "Actions-IntermediateActions-A_inputValue_linkAction-linkAction",
    	    "Actions-IntermediateActions-LinkAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkAction-inputValue Actions-IntermediateActions-A_inputValue_linkAction-linkAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_insertAt_addStructuralFeatureValueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_insertAt_addStructuralFeatureValueAction", "Actions-IntermediateActions-A_insertAt_addStructuralFeatureValueAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "addStructuralFeatureValueAction", 
    	    "Actions-IntermediateActions-A_insertAt_addStructuralFeatureValueAction-addStructuralFeatureValueAction",
    	    "Actions-IntermediateActions-AddStructuralFeatureValueAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-AddStructuralFeatureValueAction-insertAt Actions-IntermediateActions-A_insertAt_addStructuralFeatureValueAction-addStructuralFeatureValueAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_insertAt_linkEndCreationData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_insertAt_linkEndCreationData", "Actions-IntermediateActions-A_insertAt_linkEndCreationData");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "linkEndCreationData", 
    	    "Actions-IntermediateActions-A_insertAt_linkEndCreationData-linkEndCreationData",
    	    "Actions-IntermediateActions-LinkEndCreationData",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkEndCreationData-insertAt Actions-IntermediateActions-A_insertAt_linkEndCreationData-linkEndCreationData");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_object_clearAssociationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_clearAssociationAction", "Actions-IntermediateActions-A_object_clearAssociationAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "clearAssociationAction", 
    	    "Actions-IntermediateActions-A_object_clearAssociationAction-clearAssociationAction",
    	    "Actions-IntermediateActions-ClearAssociationAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ClearAssociationAction-object Actions-IntermediateActions-A_object_clearAssociationAction-clearAssociationAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_object_structuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_object_structuralFeatureAction", "Actions-IntermediateActions-A_object_structuralFeatureAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "structuralFeatureAction", 
    	    "Actions-IntermediateActions-A_object_structuralFeatureAction-structuralFeatureAction",
    	    "Actions-IntermediateActions-StructuralFeatureAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-StructuralFeatureAction-object Actions-IntermediateActions-A_object_structuralFeatureAction-structuralFeatureAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_removeAt_removeStructuralFeatureValueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_removeAt_removeStructuralFeatureValueAction", "Actions-IntermediateActions-A_removeAt_removeStructuralFeatureValueAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "removeStructuralFeatureValueAction", 
    	    "Actions-IntermediateActions-A_removeAt_removeStructuralFeatureValueAction-removeStructuralFeatureValueAction",
    	    "Actions-IntermediateActions-RemoveStructuralFeatureValueAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-RemoveStructuralFeatureValueAction-removeAt Actions-IntermediateActions-A_removeAt_removeStructuralFeatureValueAction-removeStructuralFeatureValueAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_request_sendObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_request_sendObjectAction", "Actions-IntermediateActions-A_request_sendObjectAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "sendObjectAction", 
    	    "Actions-IntermediateActions-A_request_sendObjectAction-sendObjectAction",
    	    "Actions-IntermediateActions-SendObjectAction",
    	    "",    	    
    	    "Actions-BasicActions-A_argument_invocationAction-invocationAction",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-SendObjectAction-request Actions-IntermediateActions-A_request_sendObjectAction-sendObjectAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_result_clearStructuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_clearStructuralFeatureAction", "Actions-IntermediateActions-A_result_clearStructuralFeatureAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "clearStructuralFeatureAction", 
    	    "Actions-IntermediateActions-A_result_clearStructuralFeatureAction-clearStructuralFeatureAction",
    	    "Actions-IntermediateActions-ClearStructuralFeatureAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ClearStructuralFeatureAction-result Actions-IntermediateActions-A_result_clearStructuralFeatureAction-clearStructuralFeatureAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_result_createObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_createObjectAction", "Actions-IntermediateActions-A_result_createObjectAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "createObjectAction", 
    	    "Actions-IntermediateActions-A_result_createObjectAction-createObjectAction",
    	    "Actions-IntermediateActions-CreateObjectAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-CreateObjectAction-result Actions-IntermediateActions-A_result_createObjectAction-createObjectAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_result_readLinkAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_readLinkAction", "Actions-IntermediateActions-A_result_readLinkAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readLinkAction", 
    	    "Actions-IntermediateActions-A_result_readLinkAction-readLinkAction",
    	    "Actions-IntermediateActions-ReadLinkAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ReadLinkAction-result Actions-IntermediateActions-A_result_readLinkAction-readLinkAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_result_readSelfAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_readSelfAction", "Actions-IntermediateActions-A_result_readSelfAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readSelfAction", 
    	    "Actions-IntermediateActions-A_result_readSelfAction-readSelfAction",
    	    "Actions-IntermediateActions-ReadSelfAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ReadSelfAction-result Actions-IntermediateActions-A_result_readSelfAction-readSelfAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_result_readStructuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_readStructuralFeatureAction", "Actions-IntermediateActions-A_result_readStructuralFeatureAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readStructuralFeatureAction", 
    	    "Actions-IntermediateActions-A_result_readStructuralFeatureAction-readStructuralFeatureAction",
    	    "Actions-IntermediateActions-ReadStructuralFeatureAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ReadStructuralFeatureAction-result Actions-IntermediateActions-A_result_readStructuralFeatureAction-readStructuralFeatureAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_result_testIdentityAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_testIdentityAction", "Actions-IntermediateActions-A_result_testIdentityAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "testIdentityAction", 
    	    "Actions-IntermediateActions-A_result_testIdentityAction-testIdentityAction",
    	    "Actions-IntermediateActions-TestIdentityAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-TestIdentityAction-result Actions-IntermediateActions-A_result_testIdentityAction-testIdentityAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_result_valueSpecificationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_valueSpecificationAction", "Actions-IntermediateActions-A_result_valueSpecificationAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "valueSpecificationAction", 
    	    "Actions-IntermediateActions-A_result_valueSpecificationAction-valueSpecificationAction",
    	    "Actions-IntermediateActions-ValueSpecificationAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ValueSpecificationAction-result Actions-IntermediateActions-A_result_valueSpecificationAction-valueSpecificationAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_result_writeStructuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_writeStructuralFeatureAction", "Actions-IntermediateActions-A_result_writeStructuralFeatureAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "writeStructuralFeatureAction", 
    	    "Actions-IntermediateActions-A_result_writeStructuralFeatureAction-writeStructuralFeatureAction",
    	    "Actions-IntermediateActions-WriteStructuralFeatureAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-WriteStructuralFeatureAction-result Actions-IntermediateActions-A_result_writeStructuralFeatureAction-writeStructuralFeatureAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_second_testIdentityAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_second_testIdentityAction", "Actions-IntermediateActions-A_second_testIdentityAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "testIdentityAction", 
    	    "Actions-IntermediateActions-A_second_testIdentityAction-testIdentityAction",
    	    "Actions-IntermediateActions-TestIdentityAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-TestIdentityAction-second Actions-IntermediateActions-A_second_testIdentityAction-testIdentityAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_signal_broadcastSignalAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_signal_broadcastSignalAction", "Actions-IntermediateActions-A_signal_broadcastSignalAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "broadcastSignalAction", 
    	    "Actions-IntermediateActions-A_signal_broadcastSignalAction-broadcastSignalAction",
    	    "Actions-IntermediateActions-BroadcastSignalAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-BroadcastSignalAction-signal Actions-IntermediateActions-A_signal_broadcastSignalAction-broadcastSignalAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_structuralFeature_structuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_structuralFeature_structuralFeatureAction", "Actions-IntermediateActions-A_structuralFeature_structuralFeatureAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "structuralFeatureAction", 
    	    "Actions-IntermediateActions-A_structuralFeature_structuralFeatureAction-structuralFeatureAction",
    	    "Actions-IntermediateActions-StructuralFeatureAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-StructuralFeatureAction-structuralFeature Actions-IntermediateActions-A_structuralFeature_structuralFeatureAction-structuralFeatureAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_target_destroyObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_target_destroyObjectAction", "Actions-IntermediateActions-A_target_destroyObjectAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "destroyObjectAction", 
    	    "Actions-IntermediateActions-A_target_destroyObjectAction-destroyObjectAction",
    	    "Actions-IntermediateActions-DestroyObjectAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-DestroyObjectAction-target Actions-IntermediateActions-A_target_destroyObjectAction-destroyObjectAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_target_sendObjectAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_target_sendObjectAction", "Actions-IntermediateActions-A_target_sendObjectAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "sendObjectAction", 
    	    "Actions-IntermediateActions-A_target_sendObjectAction-sendObjectAction",
    	    "Actions-IntermediateActions-SendObjectAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-SendObjectAction-target Actions-IntermediateActions-A_target_sendObjectAction-sendObjectAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_value_linkEndData 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_value_linkEndData", "Actions-IntermediateActions-A_value_linkEndData");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "linkEndData", 
    	    "Actions-IntermediateActions-A_value_linkEndData-linkEndData",
    	    "Actions-IntermediateActions-LinkEndData",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkEndData-value Actions-IntermediateActions-A_value_linkEndData-linkEndData");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_value_valueSpecificationAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_value_valueSpecificationAction", "Actions-IntermediateActions-A_value_valueSpecificationAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "valueSpecificationAction", 
    	    "Actions-IntermediateActions-A_value_valueSpecificationAction-valueSpecificationAction",
    	    "Actions-IntermediateActions-ValueSpecificationAction",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ValueSpecificationAction-value Actions-IntermediateActions-A_value_valueSpecificationAction-valueSpecificationAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";   
                      
        // UML.Actions.IntermediateActions.A_value_writeStructuralFeatureAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_value_writeStructuralFeatureAction", "Actions-IntermediateActions-A_value_writeStructuralFeatureAction");
        mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "writeStructuralFeatureAction", 
    	    "Actions-IntermediateActions-A_value_writeStructuralFeatureAction-writeStructuralFeatureAction",
    	    "Actions-IntermediateActions-WriteStructuralFeatureAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-IntermediateActions-WriteStructuralFeatureAction-value Actions-IntermediateActions-A_value_writeStructuralFeatureAction-writeStructuralFeatureAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // UML.Actions.StructuredActions.A_exception_raiseExceptionAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_exception_raiseExceptionAction", "Actions-StructuredActions-A_exception_raiseExceptionAction");
        mapping.mapAssociation(assoc, "UML.Actions.StructuredActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "raiseExceptionAction", 
    	    "Actions-StructuredActions-A_exception_raiseExceptionAction-raiseExceptionAction",
    	    "Actions-StructuredActions-RaiseExceptionAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-StructuredActions-RaiseExceptionAction-exception Actions-StructuredActions-A_exception_raiseExceptionAction-raiseExceptionAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // UML.Actions.StructuredActions.A_fromAction_actionInputPin 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_fromAction_actionInputPin", "Actions-StructuredActions-A_fromAction_actionInputPin");
        mapping.mapAssociation(assoc, "UML.Actions.StructuredActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "actionInputPin", 
    	    "Actions-StructuredActions-A_fromAction_actionInputPin-actionInputPin",
    	    "Actions-StructuredActions-ActionInputPin",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-StructuredActions-ActionInputPin-fromAction Actions-StructuredActions-A_fromAction_actionInputPin-actionInputPin");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // UML.Actions.StructuredActions.A_insertAt_addVariableValueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_insertAt_addVariableValueAction", "Actions-StructuredActions-A_insertAt_addVariableValueAction");
        mapping.mapAssociation(assoc, "UML.Actions.StructuredActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "addVariableValueAction", 
    	    "Actions-StructuredActions-A_insertAt_addVariableValueAction-addVariableValueAction",
    	    "Actions-StructuredActions-AddVariableValueAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-StructuredActions-AddVariableValueAction-insertAt Actions-StructuredActions-A_insertAt_addVariableValueAction-addVariableValueAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // UML.Actions.StructuredActions.A_removeAt_removeVariableValueAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_removeAt_removeVariableValueAction", "Actions-StructuredActions-A_removeAt_removeVariableValueAction");
        mapping.mapAssociation(assoc, "UML.Actions.StructuredActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "removeVariableValueAction", 
    	    "Actions-StructuredActions-A_removeAt_removeVariableValueAction-removeVariableValueAction",
    	    "Actions-StructuredActions-RemoveVariableValueAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-StructuredActions-RemoveVariableValueAction-removeAt Actions-StructuredActions-A_removeAt_removeVariableValueAction-removeVariableValueAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // UML.Actions.StructuredActions.A_result_readVariableAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_readVariableAction", "Actions-StructuredActions-A_result_readVariableAction");
        mapping.mapAssociation(assoc, "UML.Actions.StructuredActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "readVariableAction", 
    	    "Actions-StructuredActions-A_result_readVariableAction-readVariableAction",
    	    "Actions-StructuredActions-ReadVariableAction",
    	    "Actions-BasicActions-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-StructuredActions-ReadVariableAction-result Actions-StructuredActions-A_result_readVariableAction-readVariableAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // UML.Actions.StructuredActions.A_value_writeVariableAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_value_writeVariableAction", "Actions-StructuredActions-A_value_writeVariableAction");
        mapping.mapAssociation(assoc, "UML.Actions.StructuredActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "writeVariableAction", 
    	    "Actions-StructuredActions-A_value_writeVariableAction-writeVariableAction",
    	    "Actions-StructuredActions-WriteVariableAction",
    	    "Actions-BasicActions-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-StructuredActions-WriteVariableAction-value Actions-StructuredActions-A_value_writeVariableAction-writeVariableAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";   
                      
        // UML.Actions.StructuredActions.A_variable_variableAction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_variable_variableAction", "Actions-StructuredActions-A_variable_variableAction");
        mapping.mapAssociation(assoc, "UML.Actions.StructuredActions", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "variableAction", 
    	    "Actions-StructuredActions-A_variable_variableAction-variableAction",
    	    "Actions-StructuredActions-VariableAction",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Actions-StructuredActions-VariableAction-variable Actions-StructuredActions-A_variable_variableAction-variableAction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.A_containedEdge_inGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_containedEdge_inGroup", "Activities-BasicActivities-A_containedEdge_inGroup");
        mapping.mapAssociation(assoc, "UML.Activities.BasicActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityGroup-containedEdge Activities-BasicActivities-ActivityEdge-inGroup");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.A_edge_activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_edge_activity", "Activities-BasicActivities-A_edge_activity");
        mapping.mapAssociation(assoc, "UML.Activities.BasicActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-BasicActivities-Activity-edge Activities-BasicActivities-ActivityEdge-activity");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.A_incoming_target_node 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_incoming_target_node", "Activities-BasicActivities-A_incoming_target_node");
        mapping.mapAssociation(assoc, "UML.Activities.BasicActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityNode-incoming Activities-BasicActivities-ActivityEdge-target");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.A_outgoing_source_node 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_outgoing_source_node", "Activities-BasicActivities-A_outgoing_source_node");
        mapping.mapAssociation(assoc, "UML.Activities.BasicActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityNode-outgoing Activities-BasicActivities-ActivityEdge-source");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.A_parameter_activityParameterNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_parameter_activityParameterNode", "Activities-BasicActivities-A_parameter_activityParameterNode");
        mapping.mapAssociation(assoc, "UML.Activities.BasicActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "activityParameterNode", 
    	    "Activities-BasicActivities-A_parameter_activityParameterNode-activityParameterNode",
    	    "Activities-BasicActivities-ActivityParameterNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityParameterNode-parameter Activities-BasicActivities-A_parameter_activityParameterNode-activityParameterNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.A_redefinedEdge_activityEdge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedEdge_activityEdge", "Activities-BasicActivities-A_redefinedEdge_activityEdge");
        mapping.mapAssociation(assoc, "UML.Activities.BasicActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "activityEdge", 
    	    "Activities-BasicActivities-A_redefinedEdge_activityEdge-activityEdge",
    	    "Activities-BasicActivities-ActivityEdge",
    	    "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityEdge-redefinedEdge Activities-BasicActivities-A_redefinedEdge_activityEdge-activityEdge");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";   
                      
        // UML.Activities.BasicActivities.A_redefinedNode_activityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedNode_activityNode", "Activities-BasicActivities-A_redefinedNode_activityNode");
        mapping.mapAssociation(assoc, "UML.Activities.BasicActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "activityNode", 
    	    "Activities-BasicActivities-A_redefinedNode_activityNode-activityNode",
    	    "Activities-BasicActivities-ActivityNode",
    	    "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityNode-redefinedNode Activities-BasicActivities-A_redefinedNode_activityNode-activityNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.A_condition_parameterSet 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_condition_parameterSet", "Activities-CompleteActivities-A_condition_parameterSet");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "parameterSet", 
    	    "Activities-CompleteActivities-A_condition_parameterSet-parameterSet",
    	    "Activities-CompleteActivities-ParameterSet",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ParameterSet-condition Activities-CompleteActivities-A_condition_parameterSet-parameterSet");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.A_containedNode_inGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_containedNode_inGroup", "Activities-CompleteActivities-A_containedNode_inGroup");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ActivityGroup-containedNode Activities-CompleteActivities-ActivityNode-inGroup");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.A_inInterruptibleRegion_node 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_inInterruptibleRegion_node", "Activities-CompleteActivities-A_inInterruptibleRegion_node");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ActivityNode-inInterruptibleRegion Activities-CompleteActivities-InterruptibleActivityRegion-node");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.A_inState_objectNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_inState_objectNode", "Activities-CompleteActivities-A_inState_objectNode");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "objectNode", 
    	    "Activities-CompleteActivities-A_inState_objectNode-objectNode",
    	    "Activities-CompleteActivities-ObjectNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ObjectNode-inState Activities-CompleteActivities-A_inState_objectNode-objectNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.A_interruptingEdge_interrupts 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_interruptingEdge_interrupts", "Activities-CompleteActivities-A_interruptingEdge_interrupts");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-InterruptibleActivityRegion-interruptingEdge Activities-CompleteActivities-ActivityEdge-interrupts");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.A_joinSpec_joinNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_joinSpec_joinNode", "Activities-CompleteActivities-A_joinSpec_joinNode");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "joinNode", 
    	    "Activities-CompleteActivities-A_joinSpec_joinNode-joinNode",
    	    "Activities-CompleteActivities-JoinNode",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-JoinNode-joinSpec Activities-CompleteActivities-A_joinSpec_joinNode-joinNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.A_localPostcondition_action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_localPostcondition_action", "Activities-CompleteActivities-A_localPostcondition_action");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "action", 
    	    "Activities-CompleteActivities-A_localPostcondition_action-action",
    	    "Activities-CompleteActivities-Action",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-Action-localPostcondition Activities-CompleteActivities-A_localPostcondition_action-action");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.A_localPrecondition_action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_localPrecondition_action", "Activities-CompleteActivities-A_localPrecondition_action");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "action", 
    	    "Activities-CompleteActivities-A_localPrecondition_action-action",
    	    "Activities-CompleteActivities-Action",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-Action-localPrecondition Activities-CompleteActivities-A_localPrecondition_action-action");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.A_ownedParameterSet_behavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedParameterSet_behavior", "Activities-CompleteActivities-A_ownedParameterSet_behavior");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavior", 
    	    "Activities-CompleteActivities-A_ownedParameterSet_behavior-behavior",
    	    "Activities-CompleteActivities-Behavior",
    	    "Classes-Kernel-NamedElement-namespace",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-Behavior-ownedParameterSet Activities-CompleteActivities-A_ownedParameterSet_behavior-behavior");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.A_ownedParameterSet_behavioralFeature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedParameterSet_behavioralFeature", "Activities-CompleteActivities-A_ownedParameterSet_behavioralFeature");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavioralFeature", 
    	    "Activities-CompleteActivities-A_ownedParameterSet_behavioralFeature-behavioralFeature",
    	    "Activities-CompleteActivities-BehavioralFeature",
    	    "Classes-Kernel-NamedElement-namespace",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-BehavioralFeature-ownedParameterSet Activities-CompleteActivities-A_ownedParameterSet_behavioralFeature-behavioralFeature");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.A_parameterSet_parameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_parameterSet_parameter", "Activities-CompleteActivities-A_parameterSet_parameter");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-Parameter-parameterSet Activities-CompleteActivities-ParameterSet-parameter");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.A_selection_objectFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_selection_objectFlow", "Activities-CompleteActivities-A_selection_objectFlow");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "objectFlow", 
    	    "Activities-CompleteActivities-A_selection_objectFlow-objectFlow",
    	    "Activities-CompleteActivities-ObjectFlow",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ObjectFlow-selection Activities-CompleteActivities-A_selection_objectFlow-objectFlow");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.A_selection_objectNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_selection_objectNode", "Activities-CompleteActivities-A_selection_objectNode");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "objectNode", 
    	    "Activities-CompleteActivities-A_selection_objectNode-objectNode",
    	    "Activities-CompleteActivities-ObjectNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ObjectNode-selection Activities-CompleteActivities-A_selection_objectNode-objectNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.A_transformation_objectFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_transformation_objectFlow", "Activities-CompleteActivities-A_transformation_objectFlow");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "objectFlow", 
    	    "Activities-CompleteActivities-A_transformation_objectFlow-objectFlow",
    	    "Activities-CompleteActivities-ObjectFlow",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ObjectFlow-transformation Activities-CompleteActivities-A_transformation_objectFlow-objectFlow");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.A_upperBound_objectNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_upperBound_objectNode", "Activities-CompleteActivities-A_upperBound_objectNode");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "objectNode", 
    	    "Activities-CompleteActivities-A_upperBound_objectNode-objectNode",
    	    "Activities-CompleteActivities-ObjectNode",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ObjectNode-upperBound Activities-CompleteActivities-A_upperBound_objectNode-objectNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";   
                      
        // UML.Activities.CompleteActivities.A_weight_activityEdge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_weight_activityEdge", "Activities-CompleteActivities-A_weight_activityEdge");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "activityEdge", 
    	    "Activities-CompleteActivities-A_weight_activityEdge-activityEdge",
    	    "Activities-CompleteActivities-ActivityEdge",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ActivityEdge-weight Activities-CompleteActivities-A_weight_activityEdge-activityEdge");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.A_bodyOutput_clause 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_bodyOutput_clause", "Activities-CompleteStructuredActivities-A_bodyOutput_clause");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "clause", 
    	    "Activities-CompleteStructuredActivities-A_bodyOutput_clause-clause",
    	    "Activities-CompleteStructuredActivities-Clause",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-Clause-bodyOutput Activities-CompleteStructuredActivities-A_bodyOutput_clause-clause");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.A_bodyOutput_loopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_bodyOutput_loopNode", "Activities-CompleteStructuredActivities-A_bodyOutput_loopNode");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "loopNode", 
    	    "Activities-CompleteStructuredActivities-A_bodyOutput_loopNode-loopNode",
    	    "Activities-CompleteStructuredActivities-LoopNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-LoopNode-bodyOutput Activities-CompleteStructuredActivities-A_bodyOutput_loopNode-loopNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.A_containedEdge_inGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_containedEdge_inGroup", "Activities-CompleteStructuredActivities-A_containedEdge_inGroup");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-ActivityGroup-containedEdge Activities-CompleteStructuredActivities-ActivityEdge-inGroup");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.A_edge_inStructuredNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_edge_inStructuredNode", "Activities-CompleteStructuredActivities-A_edge_inStructuredNode");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-StructuredActivityNode-edge Activities-CompleteStructuredActivities-ActivityEdge-inStructuredNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.A_input_action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_input_action", "Activities-CompleteStructuredActivities-A_input_action");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "action", 
    	    "Activities-CompleteStructuredActivities-A_input_action-action",
    	    "Activities-CompleteStructuredActivities-Action",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-Action-input Activities-CompleteStructuredActivities-A_input_action-action");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.A_loopVariableInput_loopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_loopVariableInput_loopNode", "Activities-CompleteStructuredActivities-A_loopVariableInput_loopNode");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "loopNode", 
    	    "Activities-CompleteStructuredActivities-A_loopVariableInput_loopNode-loopNode",
    	    "Activities-CompleteStructuredActivities-LoopNode",
    	    "Activities-CompleteStructuredActivities-A_structuredNodeInput_structuredActivityNode-structuredActivityNode",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-LoopNode-loopVariableInput Activities-CompleteStructuredActivities-A_loopVariableInput_loopNode-loopNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.A_loopVariable_loopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_loopVariable_loopNode", "Activities-CompleteStructuredActivities-A_loopVariable_loopNode");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "loopNode", 
    	    "Activities-CompleteStructuredActivities-A_loopVariable_loopNode-loopNode",
    	    "Activities-CompleteStructuredActivities-LoopNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-LoopNode-loopVariable Activities-CompleteStructuredActivities-A_loopVariable_loopNode-loopNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.A_output_action 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_output_action", "Activities-CompleteStructuredActivities-A_output_action");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "action", 
    	    "Activities-CompleteStructuredActivities-A_output_action-action",
    	    "Activities-CompleteStructuredActivities-Action",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-Action-output Activities-CompleteStructuredActivities-A_output_action-action");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.A_result_conditionalNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_conditionalNode", "Activities-CompleteStructuredActivities-A_result_conditionalNode");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "conditionalNode", 
    	    "Activities-CompleteStructuredActivities-A_result_conditionalNode-conditionalNode",
    	    "Activities-CompleteStructuredActivities-ConditionalNode",
    	    "Activities-CompleteStructuredActivities-A_structuredNodeOutput_structuredActivityNode-structuredActivityNode",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-ConditionalNode-result Activities-CompleteStructuredActivities-A_result_conditionalNode-conditionalNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.A_result_loopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_loopNode", "Activities-CompleteStructuredActivities-A_result_loopNode");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "loopNode", 
    	    "Activities-CompleteStructuredActivities-A_result_loopNode-loopNode",
    	    "Activities-CompleteStructuredActivities-LoopNode",
    	    "Activities-CompleteStructuredActivities-A_structuredNodeOutput_structuredActivityNode-structuredActivityNode",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-LoopNode-result Activities-CompleteStructuredActivities-A_result_loopNode-loopNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.A_structuredNodeInput_structuredActivityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_structuredNodeInput_structuredActivityNode", "Activities-CompleteStructuredActivities-A_structuredNodeInput_structuredActivityNode");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "structuredActivityNode", 
    	    "Activities-CompleteStructuredActivities-A_structuredNodeInput_structuredActivityNode-structuredActivityNode",
    	    "Activities-CompleteStructuredActivities-StructuredActivityNode",
    	    "Activities-CompleteStructuredActivities-A_input_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-StructuredActivityNode-structuredNodeInput Activities-CompleteStructuredActivities-A_structuredNodeInput_structuredActivityNode-structuredActivityNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";   
                      
        // UML.Activities.CompleteStructuredActivities.A_structuredNodeOutput_structuredActivityNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_structuredNodeOutput_structuredActivityNode", "Activities-CompleteStructuredActivities-A_structuredNodeOutput_structuredActivityNode");
        mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "structuredActivityNode", 
    	    "Activities-CompleteStructuredActivities-A_structuredNodeOutput_structuredActivityNode-structuredActivityNode",
    	    "Activities-CompleteStructuredActivities-StructuredActivityNode",
    	    "Activities-CompleteStructuredActivities-A_output_action-action",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-StructuredActivityNode-structuredNodeOutput Activities-CompleteStructuredActivities-A_structuredNodeOutput_structuredActivityNode-structuredActivityNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // UML.Activities.ExtraStructuredActivities.A_exceptionInput_exceptionHandler 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_exceptionInput_exceptionHandler", "Activities-ExtraStructuredActivities-A_exceptionInput_exceptionHandler");
        mapping.mapAssociation(assoc, "UML.Activities.ExtraStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "exceptionHandler", 
    	    "Activities-ExtraStructuredActivities-A_exceptionInput_exceptionHandler-exceptionHandler",
    	    "Activities-ExtraStructuredActivities-ExceptionHandler",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExceptionHandler-exceptionInput Activities-ExtraStructuredActivities-A_exceptionInput_exceptionHandler-exceptionHandler");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // UML.Activities.ExtraStructuredActivities.A_exceptionType_exceptionHandler 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_exceptionType_exceptionHandler", "Activities-ExtraStructuredActivities-A_exceptionType_exceptionHandler");
        mapping.mapAssociation(assoc, "UML.Activities.ExtraStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "exceptionHandler", 
    	    "Activities-ExtraStructuredActivities-A_exceptionType_exceptionHandler-exceptionHandler",
    	    "Activities-ExtraStructuredActivities-ExceptionHandler",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExceptionHandler-exceptionType Activities-ExtraStructuredActivities-A_exceptionType_exceptionHandler-exceptionHandler");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // UML.Activities.ExtraStructuredActivities.A_handlerBody_exceptionHandler 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_handlerBody_exceptionHandler", "Activities-ExtraStructuredActivities-A_handlerBody_exceptionHandler");
        mapping.mapAssociation(assoc, "UML.Activities.ExtraStructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "exceptionHandler", 
    	    "Activities-ExtraStructuredActivities-A_handlerBody_exceptionHandler-exceptionHandler",
    	    "Activities-ExtraStructuredActivities-ExceptionHandler",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExceptionHandler-handlerBody Activities-ExtraStructuredActivities-A_handlerBody_exceptionHandler-exceptionHandler");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // UML.Activities.ExtraStructuredActivities.A_handler_protectedNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_handler_protectedNode", "Activities-ExtraStructuredActivities-A_handler_protectedNode");
        mapping.mapAssociation(assoc, "UML.Activities.ExtraStructuredActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExecutableNode-handler Activities-ExtraStructuredActivities-ExceptionHandler-protectedNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // UML.Activities.ExtraStructuredActivities.A_inputElement_regionAsInput 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_inputElement_regionAsInput", "Activities-ExtraStructuredActivities-A_inputElement_regionAsInput");
        mapping.mapAssociation(assoc, "UML.Activities.ExtraStructuredActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExpansionRegion-inputElement Activities-ExtraStructuredActivities-ExpansionNode-regionAsInput");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";   
                      
        // UML.Activities.ExtraStructuredActivities.A_outputElement_regionAsOutput 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_outputElement_regionAsOutput", "Activities-ExtraStructuredActivities-A_outputElement_regionAsOutput");
        mapping.mapAssociation(assoc, "UML.Activities.ExtraStructuredActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExpansionRegion-outputElement Activities-ExtraStructuredActivities-ExpansionNode-regionAsOutput");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";   
                      
        // UML.Activities.FundamentalActivities.A_containedNode_inGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_containedNode_inGroup", "Activities-FundamentalActivities-A_containedNode_inGroup");
        mapping.mapAssociation(assoc, "UML.Activities.FundamentalActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-FundamentalActivities-ActivityGroup-containedNode Activities-FundamentalActivities-ActivityNode-inGroup");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";   
                      
        // UML.Activities.FundamentalActivities.A_group_inActivity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_group_inActivity", "Activities-FundamentalActivities-A_group_inActivity");
        mapping.mapAssociation(assoc, "UML.Activities.FundamentalActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-FundamentalActivities-Activity-group Activities-FundamentalActivities-ActivityGroup-inActivity");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";   
                      
        // UML.Activities.FundamentalActivities.A_node_activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_node_activity", "Activities-FundamentalActivities-A_node_activity");
        mapping.mapAssociation(assoc, "UML.Activities.FundamentalActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-FundamentalActivities-Activity-node Activities-FundamentalActivities-ActivityNode-activity");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";   
                      
        // UML.Activities.FundamentalActivities.A_subgroup_superGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_subgroup_superGroup", "Activities-FundamentalActivities-A_subgroup_superGroup");
        mapping.mapAssociation(assoc, "UML.Activities.FundamentalActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-FundamentalActivities-ActivityGroup-subgroup Activities-FundamentalActivities-ActivityGroup-superGroup");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.A_containedEdge_inGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_containedEdge_inGroup", "Activities-IntermediateActivities-A_containedEdge_inGroup");
        mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityGroup-containedEdge Activities-IntermediateActivities-ActivityEdge-inGroup");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.A_containedNode_inGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_containedNode_inGroup", "Activities-IntermediateActivities-A_containedNode_inGroup");
        mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityGroup-containedNode Activities-IntermediateActivities-ActivityNode-inGroup");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.A_decisionInputFlow_decisionNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_decisionInputFlow_decisionNode", "Activities-IntermediateActivities-A_decisionInputFlow_decisionNode");
        mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "decisionNode", 
    	    "Activities-IntermediateActivities-A_decisionInputFlow_decisionNode-decisionNode",
    	    "Activities-IntermediateActivities-DecisionNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-DecisionNode-decisionInputFlow Activities-IntermediateActivities-A_decisionInputFlow_decisionNode-decisionNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.A_decisionInput_decisionNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_decisionInput_decisionNode", "Activities-IntermediateActivities-A_decisionInput_decisionNode");
        mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "decisionNode", 
    	    "Activities-IntermediateActivities-A_decisionInput_decisionNode-decisionNode",
    	    "Activities-IntermediateActivities-DecisionNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-DecisionNode-decisionInput Activities-IntermediateActivities-A_decisionInput_decisionNode-decisionNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.A_edge_inPartition 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_edge_inPartition", "Activities-IntermediateActivities-A_edge_inPartition");
        mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityPartition-edge Activities-IntermediateActivities-ActivityEdge-inPartition");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.A_group_inActivity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_group_inActivity", "Activities-IntermediateActivities-A_group_inActivity");
        mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-Activity-group Activities-IntermediateActivities-ActivityGroup-inActivity");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.A_guard_activityEdge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_guard_activityEdge", "Activities-IntermediateActivities-A_guard_activityEdge");
        mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "activityEdge", 
    	    "Activities-IntermediateActivities-A_guard_activityEdge-activityEdge",
    	    "Activities-IntermediateActivities-ActivityEdge",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityEdge-guard Activities-IntermediateActivities-A_guard_activityEdge-activityEdge");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.A_inPartition_node 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_inPartition_node", "Activities-IntermediateActivities-A_inPartition_node");
        mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityNode-inPartition Activities-IntermediateActivities-ActivityPartition-node");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.A_partition_activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_partition_activity", "Activities-IntermediateActivities-A_partition_activity");
        mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "activity", 
    	    "Activities-IntermediateActivities-A_partition_activity-activity",
    	    "Activities-IntermediateActivities-Activity",
    	    "Activities-IntermediateActivities-ActivityGroup-inActivity",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-Activity-partition Activities-IntermediateActivities-A_partition_activity-activity");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.A_represents_activityPartition 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_represents_activityPartition", "Activities-IntermediateActivities-A_represents_activityPartition");
        mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "activityPartition", 
    	    "Activities-IntermediateActivities-A_represents_activityPartition-activityPartition",
    	    "Activities-IntermediateActivities-ActivityPartition",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityPartition-represents Activities-IntermediateActivities-A_represents_activityPartition-activityPartition");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.A_subgroup_superGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_subgroup_superGroup", "Activities-IntermediateActivities-A_subgroup_superGroup");
        mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityGroup-subgroup Activities-IntermediateActivities-ActivityGroup-superGroup");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";   
                      
        // UML.Activities.IntermediateActivities.A_subpartition_superPartition 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_subpartition_superPartition", "Activities-IntermediateActivities-A_subpartition_superPartition");
        mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityPartition-subpartition Activities-IntermediateActivities-ActivityPartition-superPartition");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_bodyPart_loopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_bodyPart_loopNode", "Activities-StructuredActivities-A_bodyPart_loopNode");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "loopNode", 
    	    "Activities-StructuredActivities-A_bodyPart_loopNode-loopNode",
    	    "Activities-StructuredActivities-LoopNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-LoopNode-bodyPart Activities-StructuredActivities-A_bodyPart_loopNode-loopNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_body_clause 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_body_clause", "Activities-StructuredActivities-A_body_clause");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "clause", 
    	    "Activities-StructuredActivities-A_body_clause-clause",
    	    "Activities-StructuredActivities-Clause",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Clause-body Activities-StructuredActivities-A_body_clause-clause");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_clause_conditionalNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_clause_conditionalNode", "Activities-StructuredActivities-A_clause_conditionalNode");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "conditionalNode", 
    	    "Activities-StructuredActivities-A_clause_conditionalNode-conditionalNode",
    	    "Activities-StructuredActivities-ConditionalNode",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-ConditionalNode-clause Activities-StructuredActivities-A_clause_conditionalNode-conditionalNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_containedNode_inGroup 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_containedNode_inGroup", "Activities-StructuredActivities-A_containedNode_inGroup");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-ActivityGroup-containedNode Activities-StructuredActivities-ActivityNode-inGroup");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_decider_clause 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_decider_clause", "Activities-StructuredActivities-A_decider_clause");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "clause", 
    	    "Activities-StructuredActivities-A_decider_clause-clause",
    	    "Activities-StructuredActivities-Clause",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Clause-decider Activities-StructuredActivities-A_decider_clause-clause");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_decider_loopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_decider_loopNode", "Activities-StructuredActivities-A_decider_loopNode");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "loopNode", 
    	    "Activities-StructuredActivities-A_decider_loopNode-loopNode",
    	    "Activities-StructuredActivities-LoopNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-LoopNode-decider Activities-StructuredActivities-A_decider_loopNode-loopNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_executableNode_sequenceNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_executableNode_sequenceNode", "Activities-StructuredActivities-A_executableNode_sequenceNode");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "sequenceNode", 
    	    "Activities-StructuredActivities-A_executableNode_sequenceNode-sequenceNode",
    	    "Activities-StructuredActivities-SequenceNode",
    	    "Activities-StructuredActivities-ActivityNode-inStructuredNode",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-SequenceNode-executableNode Activities-StructuredActivities-A_executableNode_sequenceNode-sequenceNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_group_inActivity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_group_inActivity", "Activities-StructuredActivities-A_group_inActivity");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Activity-group Activities-StructuredActivities-ActivityGroup-inActivity");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_node_activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_node_activity", "Activities-StructuredActivities-A_node_activity");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Activity-node Activities-StructuredActivities-ActivityNode-activity");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_node_inStructuredNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_node_inStructuredNode", "Activities-StructuredActivities-A_node_inStructuredNode");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-StructuredActivityNode-node Activities-StructuredActivities-ActivityNode-inStructuredNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_predecessorClause_successorClause 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_predecessorClause_successorClause", "Activities-StructuredActivities-A_predecessorClause_successorClause");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Clause-predecessorClause Activities-StructuredActivities-Clause-successorClause");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_setupPart_loopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_setupPart_loopNode", "Activities-StructuredActivities-A_setupPart_loopNode");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "loopNode", 
    	    "Activities-StructuredActivities-A_setupPart_loopNode-loopNode",
    	    "Activities-StructuredActivities-LoopNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-LoopNode-setupPart Activities-StructuredActivities-A_setupPart_loopNode-loopNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_structuredNode_activity 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_structuredNode_activity", "Activities-StructuredActivities-A_structuredNode_activity");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Activity-structuredNode Activities-StructuredActivities-StructuredActivityNode-activity");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_test_clause 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_test_clause", "Activities-StructuredActivities-A_test_clause");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "clause", 
    	    "Activities-StructuredActivities-A_test_clause-clause",
    	    "Activities-StructuredActivities-Clause",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Clause-test Activities-StructuredActivities-A_test_clause-clause");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_test_loopNode 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_test_loopNode", "Activities-StructuredActivities-A_test_loopNode");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "loopNode", 
    	    "Activities-StructuredActivities-A_test_loopNode-loopNode",
    	    "Activities-StructuredActivities-LoopNode",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-LoopNode-test Activities-StructuredActivities-A_test_loopNode-loopNode");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_variable_activityScope 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_variable_activityScope", "Activities-StructuredActivities-A_variable_activityScope");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Activity-variable Activities-StructuredActivities-Variable-activityScope");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";   
                      
        // UML.Activities.StructuredActivities.A_variable_scope 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_variable_scope", "Activities-StructuredActivities-A_variable_scope");
        mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Activities-StructuredActivities-StructuredActivityNode-variable Activities-StructuredActivities-Variable-scope");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // UML.AuxiliaryConstructs.InformationFlows.A_conveyed_informationFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_conveyed_informationFlow", "AuxiliaryConstructs-InformationFlows-A_conveyed_informationFlow");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.InformationFlows", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "informationFlow", 
    	    "AuxiliaryConstructs-InformationFlows-A_conveyed_informationFlow-informationFlow",
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-conveyed AuxiliaryConstructs-InformationFlows-A_conveyed_informationFlow-informationFlow");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // UML.AuxiliaryConstructs.InformationFlows.A_informationSource_informationFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_informationSource_informationFlow", "AuxiliaryConstructs-InformationFlows-A_informationSource_informationFlow");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.InformationFlows", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "informationFlow", 
    	    "AuxiliaryConstructs-InformationFlows-A_informationSource_informationFlow-informationFlow",
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow",
    	    "Classes-Kernel-A_source_directedRelationship-directedRelationship",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-informationSource AuxiliaryConstructs-InformationFlows-A_informationSource_informationFlow-informationFlow");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // UML.AuxiliaryConstructs.InformationFlows.A_informationTarget_informationFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_informationTarget_informationFlow", "AuxiliaryConstructs-InformationFlows-A_informationTarget_informationFlow");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.InformationFlows", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "informationFlow", 
    	    "AuxiliaryConstructs-InformationFlows-A_informationTarget_informationFlow-informationFlow",
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow",
    	    "Classes-Kernel-A_target_directedRelationship-directedRelationship",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-informationTarget AuxiliaryConstructs-InformationFlows-A_informationTarget_informationFlow-informationFlow");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // UML.AuxiliaryConstructs.InformationFlows.A_realization_abstraction_flow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_realization_abstraction_flow", "AuxiliaryConstructs-InformationFlows-A_realization_abstraction_flow");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.InformationFlows", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "abstraction", 
    	    "AuxiliaryConstructs-InformationFlows-A_realization_abstraction_flow-abstraction",
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-realization AuxiliaryConstructs-InformationFlows-A_realization_abstraction_flow-abstraction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // UML.AuxiliaryConstructs.InformationFlows.A_realizingActivityEdge_informationFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_realizingActivityEdge_informationFlow", "AuxiliaryConstructs-InformationFlows-A_realizingActivityEdge_informationFlow");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.InformationFlows", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "informationFlow", 
    	    "AuxiliaryConstructs-InformationFlows-A_realizingActivityEdge_informationFlow-informationFlow",
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingActivityEdge AuxiliaryConstructs-InformationFlows-A_realizingActivityEdge_informationFlow-informationFlow");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // UML.AuxiliaryConstructs.InformationFlows.A_realizingConnector_informationFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_realizingConnector_informationFlow", "AuxiliaryConstructs-InformationFlows-A_realizingConnector_informationFlow");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.InformationFlows", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "informationFlow", 
    	    "AuxiliaryConstructs-InformationFlows-A_realizingConnector_informationFlow-informationFlow",
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingConnector AuxiliaryConstructs-InformationFlows-A_realizingConnector_informationFlow-informationFlow");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // UML.AuxiliaryConstructs.InformationFlows.A_realizingMessage_informationFlow 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_realizingMessage_informationFlow", "AuxiliaryConstructs-InformationFlows-A_realizingMessage_informationFlow");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.InformationFlows", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "informationFlow", 
    	    "AuxiliaryConstructs-InformationFlows-A_realizingMessage_informationFlow-informationFlow",
    	    "AuxiliaryConstructs-InformationFlows-InformationFlow",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingMessage AuxiliaryConstructs-InformationFlows-A_realizingMessage_informationFlow-informationFlow");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";   
                      
        // UML.AuxiliaryConstructs.InformationFlows.A_represented_representation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_represented_representation", "AuxiliaryConstructs-InformationFlows-A_represented_representation");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.InformationFlows", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "representation", 
    	    "AuxiliaryConstructs-InformationFlows-A_represented_representation-representation",
    	    "AuxiliaryConstructs-InformationFlows-InformationItem",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationItem-represented AuxiliaryConstructs-InformationFlows-A_represented_representation-representation");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_actual_templateParameterSubstitution 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_actual_templateParameterSubstitution", "AuxiliaryConstructs-Templates-A_actual_templateParameterSubstitution");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "templateParameterSubstitution", 
    	    "AuxiliaryConstructs-Templates-A_actual_templateParameterSubstitution-templateParameterSubstitution",
    	    "AuxiliaryConstructs-Templates-TemplateParameterSubstitution",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-actual AuxiliaryConstructs-Templates-A_actual_templateParameterSubstitution-templateParameterSubstitution");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_classifier_templateParameter_parameteredElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_classifier_templateParameter_parameteredElement", "AuxiliaryConstructs-Templates-A_classifier_templateParameter_parameteredElement");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-Classifier-templateParameter AuxiliaryConstructs-Templates-ClassifierTemplateParameter-parameteredElement");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_connectableElement_templateParameter_parameteredElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_connectableElement_templateParameter_parameteredElement", "AuxiliaryConstructs-Templates-A_connectableElement_templateParameter_parameteredElement");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-ConnectableElement-templateParameter AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter-parameteredElement");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_constrainingClassifier_classifierTemplateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_constrainingClassifier_classifierTemplateParameter", "AuxiliaryConstructs-Templates-A_constrainingClassifier_classifierTemplateParameter");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifierTemplateParameter", 
    	    "AuxiliaryConstructs-Templates-A_constrainingClassifier_classifierTemplateParameter-classifierTemplateParameter",
    	    "AuxiliaryConstructs-Templates-ClassifierTemplateParameter",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-ClassifierTemplateParameter-constrainingClassifier AuxiliaryConstructs-Templates-A_constrainingClassifier_classifierTemplateParameter-classifierTemplateParameter");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_default_templateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_default_templateParameter", "AuxiliaryConstructs-Templates-A_default_templateParameter");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "templateParameter", 
    	    "AuxiliaryConstructs-Templates-A_default_templateParameter-templateParameter",
    	    "AuxiliaryConstructs-Templates-TemplateParameter",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameter-default AuxiliaryConstructs-Templates-A_default_templateParameter-templateParameter");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_extendedSignature_redefinableTemplateSignature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_extendedSignature_redefinableTemplateSignature", "AuxiliaryConstructs-Templates-A_extendedSignature_redefinableTemplateSignature");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "redefinableTemplateSignature", 
    	    "AuxiliaryConstructs-Templates-A_extendedSignature_redefinableTemplateSignature-redefinableTemplateSignature",
    	    "AuxiliaryConstructs-Templates-RedefinableTemplateSignature",
    	    "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-RedefinableTemplateSignature-extendedSignature AuxiliaryConstructs-Templates-A_extendedSignature_redefinableTemplateSignature-redefinableTemplateSignature");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_formal_templateParameterSubstitution 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_formal_templateParameterSubstitution", "AuxiliaryConstructs-Templates-A_formal_templateParameterSubstitution");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "templateParameterSubstitution", 
    	    "AuxiliaryConstructs-Templates-A_formal_templateParameterSubstitution-templateParameterSubstitution",
    	    "AuxiliaryConstructs-Templates-TemplateParameterSubstitution",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-formal AuxiliaryConstructs-Templates-A_formal_templateParameterSubstitution-templateParameterSubstitution");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_inheritedParameter_redefinableTemplateSignature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_inheritedParameter_redefinableTemplateSignature", "AuxiliaryConstructs-Templates-A_inheritedParameter_redefinableTemplateSignature");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "redefinableTemplateSignature", 
    	    "AuxiliaryConstructs-Templates-A_inheritedParameter_redefinableTemplateSignature-redefinableTemplateSignature",
    	    "AuxiliaryConstructs-Templates-RedefinableTemplateSignature",
    	    "AuxiliaryConstructs-Templates-A_parameter_templateSignature-templateSignature",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-RedefinableTemplateSignature-inheritedParameter AuxiliaryConstructs-Templates-A_inheritedParameter_redefinableTemplateSignature-redefinableTemplateSignature");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_nameExpression_namedElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_nameExpression_namedElement", "AuxiliaryConstructs-Templates-A_nameExpression_namedElement");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "namedElement", 
    	    "AuxiliaryConstructs-Templates-A_nameExpression_namedElement-namedElement",
    	    "AuxiliaryConstructs-Templates-NamedElement",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-NamedElement-nameExpression AuxiliaryConstructs-Templates-A_nameExpression_namedElement-namedElement");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_operation_templateParameter_parameteredElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_operation_templateParameter_parameteredElement", "AuxiliaryConstructs-Templates-A_operation_templateParameter_parameteredElement");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-Operation-templateParameter AuxiliaryConstructs-Templates-OperationTemplateParameter-parameteredElement");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_ownedActual_templateParameterSubstitution 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedActual_templateParameterSubstitution", "AuxiliaryConstructs-Templates-A_ownedActual_templateParameterSubstitution");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "templateParameterSubstitution", 
    	    "AuxiliaryConstructs-Templates-A_ownedActual_templateParameterSubstitution-templateParameterSubstitution",
    	    "AuxiliaryConstructs-Templates-TemplateParameterSubstitution",
    	    "Classes-Kernel-Element-owner",    	    
    	    "AuxiliaryConstructs-Templates-A_actual_templateParameterSubstitution-templateParameterSubstitution",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-ownedActual AuxiliaryConstructs-Templates-A_ownedActual_templateParameterSubstitution-templateParameterSubstitution");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_ownedDefault_templateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedDefault_templateParameter", "AuxiliaryConstructs-Templates-A_ownedDefault_templateParameter");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "templateParameter", 
    	    "AuxiliaryConstructs-Templates-A_ownedDefault_templateParameter-templateParameter",
    	    "AuxiliaryConstructs-Templates-TemplateParameter",
    	    "Classes-Kernel-Element-owner",    	    
    	    "AuxiliaryConstructs-Templates-A_default_templateParameter-templateParameter",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameter-ownedDefault AuxiliaryConstructs-Templates-A_ownedDefault_templateParameter-templateParameter");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_ownedParameter_signature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedParameter_signature", "AuxiliaryConstructs-Templates-A_ownedParameter_signature");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateSignature-ownedParameter AuxiliaryConstructs-Templates-TemplateParameter-signature");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_ownedParameteredElement_owningTemplateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedParameteredElement_owningTemplateParameter", "AuxiliaryConstructs-Templates-A_ownedParameteredElement_owningTemplateParameter");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameter-ownedParameteredElement AuxiliaryConstructs-Templates-ParameterableElement-owningTemplateParameter");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_ownedTemplateSignature_classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedTemplateSignature_classifier", "AuxiliaryConstructs-Templates-A_ownedTemplateSignature_classifier");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-Classifier-ownedTemplateSignature AuxiliaryConstructs-Templates-RedefinableTemplateSignature-classifier");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_ownedTemplateSignature_template 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedTemplateSignature_template", "AuxiliaryConstructs-Templates-A_ownedTemplateSignature_template");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateableElement-ownedTemplateSignature AuxiliaryConstructs-Templates-TemplateSignature-template");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_parameterSubstitution_templateBinding 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_parameterSubstitution_templateBinding", "AuxiliaryConstructs-Templates-A_parameterSubstitution_templateBinding");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateBinding-parameterSubstitution AuxiliaryConstructs-Templates-TemplateParameterSubstitution-templateBinding");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_parameter_templateSignature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_parameter_templateSignature", "AuxiliaryConstructs-Templates-A_parameter_templateSignature");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "templateSignature", 
    	    "AuxiliaryConstructs-Templates-A_parameter_templateSignature-templateSignature",
    	    "AuxiliaryConstructs-Templates-TemplateSignature",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateSignature-parameter AuxiliaryConstructs-Templates-A_parameter_templateSignature-templateSignature");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_parameteredElement_templateParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_parameteredElement_templateParameter", "AuxiliaryConstructs-Templates-A_parameteredElement_templateParameter");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameter-parameteredElement AuxiliaryConstructs-Templates-ParameterableElement-templateParameter");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_redefinitionContext_redefinableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinitionContext_redefinableElement", "AuxiliaryConstructs-Templates-A_redefinitionContext_redefinableElement");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "redefinableElement", 
    	    "AuxiliaryConstructs-Templates-A_redefinitionContext_redefinableElement-redefinableElement",
    	    "AuxiliaryConstructs-Templates-RedefinableElement",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-RedefinableElement-redefinitionContext AuxiliaryConstructs-Templates-A_redefinitionContext_redefinableElement-redefinableElement");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_signature_templateBinding 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_signature_templateBinding", "AuxiliaryConstructs-Templates-A_signature_templateBinding");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "templateBinding", 
    	    "AuxiliaryConstructs-Templates-A_signature_templateBinding-templateBinding",
    	    "AuxiliaryConstructs-Templates-TemplateBinding",
    	    "Classes-Kernel-A_target_directedRelationship-directedRelationship",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateBinding-signature AuxiliaryConstructs-Templates-A_signature_templateBinding-templateBinding");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_subExpression_owningExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_subExpression_owningExpression", "AuxiliaryConstructs-Templates-A_subExpression_owningExpression");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-StringExpression-subExpression AuxiliaryConstructs-Templates-StringExpression-owningExpression");
                                                              
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";   
                      
        // UML.AuxiliaryConstructs.Templates.A_templateBinding_boundElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_templateBinding_boundElement", "AuxiliaryConstructs-Templates-A_templateBinding_boundElement");
        mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateableElement-templateBinding AuxiliaryConstructs-Templates-TemplateBinding-boundElement");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-AssociationClasses";   
                      
        // UML.Classes.AssociationClasses.A_qualifier_associationEnd 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_qualifier_associationEnd", "Classes-AssociationClasses-A_qualifier_associationEnd");
        mapping.mapAssociation(assoc, "UML.Classes.AssociationClasses", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-AssociationClasses-Property-qualifier Classes-AssociationClasses-Property-associationEnd");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // UML.Classes.Dependencies.A_clientDependency_client 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_clientDependency_client", "Classes-Dependencies-A_clientDependency_client");
        mapping.mapAssociation(assoc, "UML.Classes.Dependencies", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Dependencies-NamedElement-clientDependency Classes-Dependencies-Dependency-client");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // UML.Classes.Dependencies.A_contract_substitution 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_contract_substitution", "Classes-Dependencies-A_contract_substitution");
        mapping.mapAssociation(assoc, "UML.Classes.Dependencies", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "substitution", 
    	    "Classes-Dependencies-A_contract_substitution-substitution",
    	    "Classes-Dependencies-Substitution",
    	    "Classes-Dependencies-A_supplier_supplierDependency-supplierDependency",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Dependencies-Substitution-contract Classes-Dependencies-A_contract_substitution-substitution");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // UML.Classes.Dependencies.A_mapping_abstraction 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_mapping_abstraction", "Classes-Dependencies-A_mapping_abstraction");
        mapping.mapAssociation(assoc, "UML.Classes.Dependencies", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "abstraction", 
    	    "Classes-Dependencies-A_mapping_abstraction-abstraction",
    	    "Classes-Dependencies-Abstraction",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Dependencies-Abstraction-mapping Classes-Dependencies-A_mapping_abstraction-abstraction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // UML.Classes.Dependencies.A_ownedMember_namespace 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedMember_namespace", "Classes-Dependencies-A_ownedMember_namespace");
        mapping.mapAssociation(assoc, "UML.Classes.Dependencies", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Dependencies-Namespace-ownedMember Classes-Dependencies-NamedElement-namespace");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // UML.Classes.Dependencies.A_substitution_substitutingClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_substitution_substitutingClassifier", "Classes-Dependencies-A_substitution_substitutingClassifier");
        mapping.mapAssociation(assoc, "UML.Classes.Dependencies", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Dependencies-Classifier-substitution Classes-Dependencies-Substitution-substitutingClassifier");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";   
                      
        // UML.Classes.Dependencies.A_supplier_supplierDependency 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_supplier_supplierDependency", "Classes-Dependencies-A_supplier_supplierDependency");
        mapping.mapAssociation(assoc, "UML.Classes.Dependencies", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "supplierDependency", 
    	    "Classes-Dependencies-A_supplier_supplierDependency-supplierDependency",
    	    "Classes-Dependencies-Dependency",
    	    "Classes-Kernel-A_target_directedRelationship-directedRelationship",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Dependencies-Dependency-supplier Classes-Dependencies-A_supplier_supplierDependency-supplierDependency");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // UML.Classes.Interfaces.A_attribute_classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_attribute_classifier", "Classes-Interfaces-A_attribute_classifier");
        mapping.mapAssociation(assoc, "UML.Classes.Interfaces", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifier", 
    	    "Classes-Interfaces-A_attribute_classifier-classifier",
    	    "Classes-Interfaces-Classifier",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Interfaces-Classifier-attribute Classes-Interfaces-A_attribute_classifier-classifier");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // UML.Classes.Interfaces.A_contract_interfaceRealization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_contract_interfaceRealization", "Classes-Interfaces-A_contract_interfaceRealization");
        mapping.mapAssociation(assoc, "UML.Classes.Interfaces", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "interfaceRealization", 
    	    "Classes-Interfaces-A_contract_interfaceRealization-interfaceRealization",
    	    "Classes-Interfaces-InterfaceRealization",
    	    "Classes-Dependencies-A_supplier_supplierDependency-supplierDependency",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Interfaces-InterfaceRealization-contract Classes-Interfaces-A_contract_interfaceRealization-interfaceRealization");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // UML.Classes.Interfaces.A_interfaceRealization_implementingClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_interfaceRealization_implementingClassifier", "Classes-Interfaces-A_interfaceRealization_implementingClassifier");
        mapping.mapAssociation(assoc, "UML.Classes.Interfaces", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Interfaces-BehavioredClassifier-interfaceRealization Classes-Interfaces-InterfaceRealization-implementingClassifier");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // UML.Classes.Interfaces.A_nestedClassifier_interface 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_nestedClassifier_interface", "Classes-Interfaces-A_nestedClassifier_interface");
        mapping.mapAssociation(assoc, "UML.Classes.Interfaces", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "interface", 
    	    "Classes-Interfaces-A_nestedClassifier_interface-interface",
    	    "Classes-Interfaces-Interface",
    	    "Classes-Kernel-NamedElement-namespace Classes-Kernel-RedefinableElement-redefinitionContext",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Interfaces-Interface-nestedClassifier Classes-Interfaces-A_nestedClassifier_interface-interface");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // UML.Classes.Interfaces.A_ownedAttribute_interface 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedAttribute_interface", "Classes-Interfaces-A_ownedAttribute_interface");
        mapping.mapAssociation(assoc, "UML.Classes.Interfaces", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Interfaces-Interface-ownedAttribute Classes-Interfaces-Property-interface");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // UML.Classes.Interfaces.A_ownedOperation_interface 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedOperation_interface", "Classes-Interfaces-A_ownedOperation_interface");
        mapping.mapAssociation(assoc, "UML.Classes.Interfaces", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Interfaces-Interface-ownedOperation Classes-Interfaces-Operation-interface");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";   
                      
        // UML.Classes.Interfaces.A_redefinedInterface_interface 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedInterface_interface", "Classes-Interfaces-A_redefinedInterface_interface");
        mapping.mapAssociation(assoc, "UML.Classes.Interfaces", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "interface", 
    	    "Classes-Interfaces-A_redefinedInterface_interface-interface",
    	    "Classes-Interfaces-Interface",
    	    "Classes-Kernel-A_redefinedClassifier_classifier-classifier",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Interfaces-Interface-redefinedInterface Classes-Interfaces-A_redefinedInterface_interface-interface");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_annotatedElement_comment 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_annotatedElement_comment", "Classes-Kernel-A_annotatedElement_comment");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "comment", 
    	    "Classes-Kernel-A_annotatedElement_comment-comment",
    	    "Classes-Kernel-Comment",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Comment-annotatedElement Classes-Kernel-A_annotatedElement_comment-comment");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_attribute_classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_attribute_classifier", "Classes-Kernel-A_attribute_classifier");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifier", 
    	    "Classes-Kernel-A_attribute_classifier-classifier",
    	    "Classes-Kernel-Classifier",
    	    "Classes-Kernel-Feature-featuringClassifier Classes-Kernel-RedefinableElement-redefinitionContext",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-attribute Classes-Kernel-A_attribute_classifier-classifier");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_bodyCondition_bodyContext 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_bodyCondition_bodyContext", "Classes-Kernel-A_bodyCondition_bodyContext");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "bodyContext", 
    	    "Classes-Kernel-A_bodyCondition_bodyContext-bodyContext",
    	    "Classes-Kernel-Operation",
    	    "Classes-Kernel-Constraint-context",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-bodyCondition Classes-Kernel-A_bodyCondition_bodyContext-bodyContext");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_classifier_enumerationLiteral 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_classifier_enumerationLiteral", "Classes-Kernel-A_classifier_enumerationLiteral");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "enumerationLiteral", 
    	    "Classes-Kernel-A_classifier_enumerationLiteral-enumerationLiteral",
    	    "Classes-Kernel-EnumerationLiteral",
    	    "",    	    
    	    "Classes-Kernel-A_classifier_instanceSpecification-instanceSpecification",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-EnumerationLiteral-classifier Classes-Kernel-A_classifier_enumerationLiteral-enumerationLiteral");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_classifier_instanceSpecification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_classifier_instanceSpecification", "Classes-Kernel-A_classifier_instanceSpecification");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "instanceSpecification", 
    	    "Classes-Kernel-A_classifier_instanceSpecification-instanceSpecification",
    	    "Classes-Kernel-InstanceSpecification",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-InstanceSpecification-classifier Classes-Kernel-A_classifier_instanceSpecification-instanceSpecification");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_constrainedElement_constraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_constrainedElement_constraint", "Classes-Kernel-A_constrainedElement_constraint");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "constraint", 
    	    "Classes-Kernel-A_constrainedElement_constraint-constraint",
    	    "Classes-Kernel-Constraint",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Constraint-constrainedElement Classes-Kernel-A_constrainedElement_constraint-constraint");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_defaultValue_owningParameter 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_defaultValue_owningParameter", "Classes-Kernel-A_defaultValue_owningParameter");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningParameter", 
    	    "Classes-Kernel-A_defaultValue_owningParameter-owningParameter",
    	    "Classes-Kernel-Parameter",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Parameter-defaultValue Classes-Kernel-A_defaultValue_owningParameter-owningParameter");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_defaultValue_owningProperty 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_defaultValue_owningProperty", "Classes-Kernel-A_defaultValue_owningProperty");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningProperty", 
    	    "Classes-Kernel-A_defaultValue_owningProperty-owningProperty",
    	    "Classes-Kernel-Property",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Property-defaultValue Classes-Kernel-A_defaultValue_owningProperty-owningProperty");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_definingFeature_slot 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_definingFeature_slot", "Classes-Kernel-A_definingFeature_slot");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "slot", 
    	    "Classes-Kernel-A_definingFeature_slot-slot",
    	    "Classes-Kernel-Slot",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Slot-definingFeature Classes-Kernel-A_definingFeature_slot-slot");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_elementImport_importingNamespace 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_elementImport_importingNamespace", "Classes-Kernel-A_elementImport_importingNamespace");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-elementImport Classes-Kernel-ElementImport-importingNamespace");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_endType_association 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_endType_association", "Classes-Kernel-A_endType_association");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "association", 
    	    "Classes-Kernel-A_endType_association-association",
    	    "Classes-Kernel-Association",
    	    "Classes-Kernel-A_relatedElement_relationship-relationship",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Association-endType Classes-Kernel-A_endType_association-association");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_feature_featuringClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_feature_featuringClassifier", "Classes-Kernel-A_feature_featuringClassifier");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-feature Classes-Kernel-Feature-featuringClassifier");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_general_classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_general_classifier", "Classes-Kernel-A_general_classifier");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifier", 
    	    "Classes-Kernel-A_general_classifier-classifier",
    	    "Classes-Kernel-Classifier",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-general Classes-Kernel-A_general_classifier-classifier");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_general_generalization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_general_generalization", "Classes-Kernel-A_general_generalization");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "generalization", 
    	    "Classes-Kernel-A_general_generalization-generalization",
    	    "Classes-Kernel-Generalization",
    	    "Classes-Kernel-A_target_directedRelationship-directedRelationship",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Generalization-general Classes-Kernel-A_general_generalization-generalization");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_generalization_specific 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_generalization_specific", "Classes-Kernel-A_generalization_specific");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-generalization Classes-Kernel-Generalization-specific");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_importedElement_elementImport 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_importedElement_elementImport", "Classes-Kernel-A_importedElement_elementImport");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "elementImport", 
    	    "Classes-Kernel-A_importedElement_elementImport-elementImport",
    	    "Classes-Kernel-ElementImport",
    	    "Classes-Kernel-A_target_directedRelationship-directedRelationship",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-ElementImport-importedElement Classes-Kernel-A_importedElement_elementImport-elementImport");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_importedMember_namespace 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_importedMember_namespace", "Classes-Kernel-A_importedMember_namespace");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "namespace", 
    	    "Classes-Kernel-A_importedMember_namespace-namespace",
    	    "Classes-Kernel-Namespace",
    	    "Classes-Kernel-A_member_memberNamespace-memberNamespace",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-importedMember Classes-Kernel-A_importedMember_namespace-namespace");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_importedPackage_packageImport 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_importedPackage_packageImport", "Classes-Kernel-A_importedPackage_packageImport");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "packageImport", 
    	    "Classes-Kernel-A_importedPackage_packageImport-packageImport",
    	    "Classes-Kernel-PackageImport",
    	    "Classes-Kernel-A_target_directedRelationship-directedRelationship",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-PackageImport-importedPackage Classes-Kernel-A_importedPackage_packageImport-packageImport");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_inheritedMember_classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_inheritedMember_classifier", "Classes-Kernel-A_inheritedMember_classifier");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifier", 
    	    "Classes-Kernel-A_inheritedMember_classifier-classifier",
    	    "Classes-Kernel-Classifier",
    	    "Classes-Kernel-A_member_memberNamespace-memberNamespace",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-inheritedMember Classes-Kernel-A_inheritedMember_classifier-classifier");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_instance_instanceValue 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_instance_instanceValue", "Classes-Kernel-A_instance_instanceValue");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "instanceValue", 
    	    "Classes-Kernel-A_instance_instanceValue-instanceValue",
    	    "Classes-Kernel-InstanceValue",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-InstanceValue-instance Classes-Kernel-A_instance_instanceValue-instanceValue");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_lowerValue_owningLower 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_lowerValue_owningLower", "Classes-Kernel-A_lowerValue_owningLower");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningLower", 
    	    "Classes-Kernel-A_lowerValue_owningLower-owningLower",
    	    "Classes-Kernel-MultiplicityElement",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-MultiplicityElement-lowerValue Classes-Kernel-A_lowerValue_owningLower-owningLower");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_memberEnd_association 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_memberEnd_association", "Classes-Kernel-A_memberEnd_association");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Association-memberEnd Classes-Kernel-Property-association");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_member_memberNamespace 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_member_memberNamespace", "Classes-Kernel-A_member_memberNamespace");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "memberNamespace", 
    	    "Classes-Kernel-A_member_memberNamespace-memberNamespace",
    	    "Classes-Kernel-Namespace",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-member Classes-Kernel-A_member_memberNamespace-memberNamespace");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_mergedPackage_packageMerge 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_mergedPackage_packageMerge", "Classes-Kernel-A_mergedPackage_packageMerge");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "packageMerge", 
    	    "Classes-Kernel-A_mergedPackage_packageMerge-packageMerge",
    	    "Classes-Kernel-PackageMerge",
    	    "Classes-Kernel-A_target_directedRelationship-directedRelationship",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-PackageMerge-mergedPackage Classes-Kernel-A_mergedPackage_packageMerge-packageMerge");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_navigableOwnedEnd_association 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_navigableOwnedEnd_association", "Classes-Kernel-A_navigableOwnedEnd_association");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "association", 
    	    "Classes-Kernel-A_navigableOwnedEnd_association-association",
    	    "Classes-Kernel-Association",
    	    "Classes-Kernel-Property-owningAssociation",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Association-navigableOwnedEnd Classes-Kernel-A_navigableOwnedEnd_association-association");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_nestedClassifier_class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_nestedClassifier_class", "Classes-Kernel-A_nestedClassifier_class");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "class", 
    	    "Classes-Kernel-A_nestedClassifier_class-class",
    	    "Classes-Kernel-Class",
    	    "Classes-Kernel-NamedElement-namespace Classes-Kernel-RedefinableElement-redefinitionContext",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Class-nestedClassifier Classes-Kernel-A_nestedClassifier_class-class");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_nestedPackage_nestingPackage 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_nestedPackage_nestingPackage", "Classes-Kernel-A_nestedPackage_nestingPackage");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Package-nestedPackage Classes-Kernel-Package-nestingPackage");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_operand_expression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_operand_expression", "Classes-Kernel-A_operand_expression");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "expression", 
    	    "Classes-Kernel-A_operand_expression-expression",
    	    "Classes-Kernel-Expression",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Expression-operand Classes-Kernel-A_operand_expression-expression");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_opposite_property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_opposite_property", "Classes-Kernel-A_opposite_property");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "property", 
    	    "Classes-Kernel-A_opposite_property-property",
    	    "Classes-Kernel-Property",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Property-opposite Classes-Kernel-A_opposite_property-property");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_ownedAttribute_class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedAttribute_class", "Classes-Kernel-A_ownedAttribute_class");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Class-ownedAttribute Classes-Kernel-Property-class");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_ownedAttribute_datatype 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedAttribute_datatype", "Classes-Kernel-A_ownedAttribute_datatype");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-DataType-ownedAttribute Classes-Kernel-Property-datatype");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_ownedComment_owningElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedComment_owningElement", "Classes-Kernel-A_ownedComment_owningElement");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningElement", 
    	    "Classes-Kernel-A_ownedComment_owningElement-owningElement",
    	    "Classes-Kernel-Element",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Element-ownedComment Classes-Kernel-A_ownedComment_owningElement-owningElement");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_ownedElement_owner 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedElement_owner", "Classes-Kernel-A_ownedElement_owner");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Element-ownedElement Classes-Kernel-Element-owner");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_ownedEnd_owningAssociation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedEnd_owningAssociation", "Classes-Kernel-A_ownedEnd_owningAssociation");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Association-ownedEnd Classes-Kernel-Property-owningAssociation");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_ownedLiteral_enumeration 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedLiteral_enumeration", "Classes-Kernel-A_ownedLiteral_enumeration");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Enumeration-ownedLiteral Classes-Kernel-EnumerationLiteral-enumeration");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_ownedMember_namespace 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedMember_namespace", "Classes-Kernel-A_ownedMember_namespace");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-ownedMember Classes-Kernel-NamedElement-namespace");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_ownedOperation_class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedOperation_class", "Classes-Kernel-A_ownedOperation_class");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Class-ownedOperation Classes-Kernel-Operation-class");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_ownedOperation_datatype 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedOperation_datatype", "Classes-Kernel-A_ownedOperation_datatype");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-DataType-ownedOperation Classes-Kernel-Operation-datatype");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_ownedParameter_operation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedParameter_operation", "Classes-Kernel-A_ownedParameter_operation");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-ownedParameter Classes-Kernel-Parameter-operation");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_ownedParameter_ownerFormalParam 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedParameter_ownerFormalParam", "Classes-Kernel-A_ownedParameter_ownerFormalParam");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "ownerFormalParam", 
    	    "Classes-Kernel-A_ownedParameter_ownerFormalParam-ownerFormalParam",
    	    "Classes-Kernel-BehavioralFeature",
    	    "Classes-Kernel-NamedElement-namespace",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-BehavioralFeature-ownedParameter Classes-Kernel-A_ownedParameter_ownerFormalParam-ownerFormalParam");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_ownedRule_context 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedRule_context", "Classes-Kernel-A_ownedRule_context");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-ownedRule Classes-Kernel-Constraint-context");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_ownedType_package 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedType_package", "Classes-Kernel-A_ownedType_package");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Package-ownedType Classes-Kernel-Type-package");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_packageImport_importingNamespace 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_packageImport_importingNamespace", "Classes-Kernel-A_packageImport_importingNamespace");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-packageImport Classes-Kernel-PackageImport-importingNamespace");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_packageMerge_receivingPackage 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_packageMerge_receivingPackage", "Classes-Kernel-A_packageMerge_receivingPackage");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Package-packageMerge Classes-Kernel-PackageMerge-receivingPackage");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_packagedElement_owningPackage 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_packagedElement_owningPackage", "Classes-Kernel-A_packagedElement_owningPackage");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningPackage", 
    	    "Classes-Kernel-A_packagedElement_owningPackage-owningPackage",
    	    "Classes-Kernel-Package",
    	    "Classes-Kernel-NamedElement-namespace",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Package-packagedElement Classes-Kernel-A_packagedElement_owningPackage-owningPackage");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_postcondition_postContext 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_postcondition_postContext", "Classes-Kernel-A_postcondition_postContext");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "postContext", 
    	    "Classes-Kernel-A_postcondition_postContext-postContext",
    	    "Classes-Kernel-Operation",
    	    "Classes-Kernel-Constraint-context",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-postcondition Classes-Kernel-A_postcondition_postContext-postContext");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_precondition_preContext 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_precondition_preContext", "Classes-Kernel-A_precondition_preContext");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "preContext", 
    	    "Classes-Kernel-A_precondition_preContext-preContext",
    	    "Classes-Kernel-Operation",
    	    "Classes-Kernel-Constraint-context",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-precondition Classes-Kernel-A_precondition_preContext-preContext");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_raisedException_behavioralFeature 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_raisedException_behavioralFeature", "Classes-Kernel-A_raisedException_behavioralFeature");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavioralFeature", 
    	    "Classes-Kernel-A_raisedException_behavioralFeature-behavioralFeature",
    	    "Classes-Kernel-BehavioralFeature",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-BehavioralFeature-raisedException Classes-Kernel-A_raisedException_behavioralFeature-behavioralFeature");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_raisedException_operation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_raisedException_operation", "Classes-Kernel-A_raisedException_operation");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "operation", 
    	    "Classes-Kernel-A_raisedException_operation-operation",
    	    "Classes-Kernel-Operation",
    	    "Classes-Kernel-A_raisedException_behavioralFeature-behavioralFeature",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-raisedException Classes-Kernel-A_raisedException_operation-operation");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_redefinedClassifier_classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedClassifier_classifier", "Classes-Kernel-A_redefinedClassifier_classifier");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifier", 
    	    "Classes-Kernel-A_redefinedClassifier_classifier-classifier",
    	    "Classes-Kernel-Classifier",
    	    "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-redefinedClassifier Classes-Kernel-A_redefinedClassifier_classifier-classifier");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_redefinedElement_redefinableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedElement_redefinableElement", "Classes-Kernel-A_redefinedElement_redefinableElement");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "redefinableElement", 
    	    "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement",
    	    "Classes-Kernel-RedefinableElement",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-RedefinableElement-redefinedElement Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_redefinedOperation_operation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedOperation_operation", "Classes-Kernel-A_redefinedOperation_operation");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "operation", 
    	    "Classes-Kernel-A_redefinedOperation_operation-operation",
    	    "Classes-Kernel-Operation",
    	    "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-redefinedOperation Classes-Kernel-A_redefinedOperation_operation-operation");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_redefinedProperty_property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedProperty_property", "Classes-Kernel-A_redefinedProperty_property");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "property", 
    	    "Classes-Kernel-A_redefinedProperty_property-property",
    	    "Classes-Kernel-Property",
    	    "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Property-redefinedProperty Classes-Kernel-A_redefinedProperty_property-property");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_redefinitionContext_redefinableElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinitionContext_redefinableElement", "Classes-Kernel-A_redefinitionContext_redefinableElement");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "redefinableElement", 
    	    "Classes-Kernel-A_redefinitionContext_redefinableElement-redefinableElement",
    	    "Classes-Kernel-RedefinableElement",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-RedefinableElement-redefinitionContext Classes-Kernel-A_redefinitionContext_redefinableElement-redefinableElement");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_relatedElement_relationship 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_relatedElement_relationship", "Classes-Kernel-A_relatedElement_relationship");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "relationship", 
    	    "Classes-Kernel-A_relatedElement_relationship-relationship",
    	    "Classes-Kernel-Relationship",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Relationship-relatedElement Classes-Kernel-A_relatedElement_relationship-relationship");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_slot_owningInstance 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_slot_owningInstance", "Classes-Kernel-A_slot_owningInstance");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-InstanceSpecification-slot Classes-Kernel-Slot-owningInstance");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_source_directedRelationship 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_source_directedRelationship", "Classes-Kernel-A_source_directedRelationship");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "directedRelationship", 
    	    "Classes-Kernel-A_source_directedRelationship-directedRelationship",
    	    "Classes-Kernel-DirectedRelationship",
    	    "Classes-Kernel-A_relatedElement_relationship-relationship",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-DirectedRelationship-source Classes-Kernel-A_source_directedRelationship-directedRelationship");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_specification_owningConstraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_specification_owningConstraint", "Classes-Kernel-A_specification_owningConstraint");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningConstraint", 
    	    "Classes-Kernel-A_specification_owningConstraint-owningConstraint",
    	    "Classes-Kernel-Constraint",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Constraint-specification Classes-Kernel-A_specification_owningConstraint-owningConstraint");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_specification_owningInstanceSpec 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_specification_owningInstanceSpec", "Classes-Kernel-A_specification_owningInstanceSpec");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningInstanceSpec", 
    	    "Classes-Kernel-A_specification_owningInstanceSpec-owningInstanceSpec",
    	    "Classes-Kernel-InstanceSpecification",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-InstanceSpecification-specification Classes-Kernel-A_specification_owningInstanceSpec-owningInstanceSpec");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_subsettedProperty_property 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_subsettedProperty_property", "Classes-Kernel-A_subsettedProperty_property");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "property", 
    	    "Classes-Kernel-A_subsettedProperty_property-property",
    	    "Classes-Kernel-Property",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Property-subsettedProperty Classes-Kernel-A_subsettedProperty_property-property");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_superClass_class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_superClass_class", "Classes-Kernel-A_superClass_class");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "class", 
    	    "Classes-Kernel-A_superClass_class-class",
    	    "Classes-Kernel-Class",
    	    "Classes-Kernel-A_general_classifier-classifier",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Class-superClass Classes-Kernel-A_superClass_class-class");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_target_directedRelationship 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_target_directedRelationship", "Classes-Kernel-A_target_directedRelationship");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "directedRelationship", 
    	    "Classes-Kernel-A_target_directedRelationship-directedRelationship",
    	    "Classes-Kernel-DirectedRelationship",
    	    "Classes-Kernel-A_relatedElement_relationship-relationship",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-DirectedRelationship-target Classes-Kernel-A_target_directedRelationship-directedRelationship");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_type_operation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_type_operation", "Classes-Kernel-A_type_operation");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "operation", 
    	    "Classes-Kernel-A_type_operation-operation",
    	    "Classes-Kernel-Operation",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-type Classes-Kernel-A_type_operation-operation");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_type_typedElement 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_type_typedElement", "Classes-Kernel-A_type_typedElement");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "typedElement", 
    	    "Classes-Kernel-A_type_typedElement-typedElement",
    	    "Classes-Kernel-TypedElement",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-TypedElement-type Classes-Kernel-A_type_typedElement-typedElement");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_upperValue_owningUpper 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_upperValue_owningUpper", "Classes-Kernel-A_upperValue_owningUpper");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningUpper", 
    	    "Classes-Kernel-A_upperValue_owningUpper-owningUpper",
    	    "Classes-Kernel-MultiplicityElement",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-MultiplicityElement-upperValue Classes-Kernel-A_upperValue_owningUpper-owningUpper");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";   
                      
        // UML.Classes.Kernel.A_value_owningSlot 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_value_owningSlot", "Classes-Kernel-A_value_owningSlot");
        mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningSlot", 
    	    "Classes-Kernel-A_value_owningSlot-owningSlot",
    	    "Classes-Kernel-Slot",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Classes-Kernel-Slot-value Classes-Kernel-A_value_owningSlot-owningSlot");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-PowerTypes";   
                      
        // UML.Classes.PowerTypes.A_generalizationSet_generalization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_generalizationSet_generalization", "Classes-PowerTypes-A_generalizationSet_generalization");
        mapping.mapAssociation(assoc, "UML.Classes.PowerTypes", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-PowerTypes-Generalization-generalizationSet Classes-PowerTypes-GeneralizationSet-generalization");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Classes-PowerTypes";   
                      
        // UML.Classes.PowerTypes.A_powertypeExtent_powertype 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_powertypeExtent_powertype", "Classes-PowerTypes-A_powertypeExtent_powertype");
        mapping.mapAssociation(assoc, "UML.Classes.PowerTypes", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Classes-PowerTypes-Classifier-powertypeExtent Classes-PowerTypes-GeneralizationSet-powertype");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // UML.CommonBehaviors.BasicBehaviors.A_behavior_opaqueExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_behavior_opaqueExpression", "CommonBehaviors-BasicBehaviors-A_behavior_opaqueExpression");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "opaqueExpression", 
    	    "CommonBehaviors-BasicBehaviors-A_behavior_opaqueExpression-opaqueExpression",
    	    "CommonBehaviors-BasicBehaviors-OpaqueExpression",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-OpaqueExpression-behavior CommonBehaviors-BasicBehaviors-A_behavior_opaqueExpression-opaqueExpression");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // UML.CommonBehaviors.BasicBehaviors.A_classifierBehavior_behavioredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_classifierBehavior_behavioredClassifier", "CommonBehaviors-BasicBehaviors-A_classifierBehavior_behavioredClassifier");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavioredClassifier", 
    	    "CommonBehaviors-BasicBehaviors-A_classifierBehavior_behavioredClassifier-behavioredClassifier",
    	    "CommonBehaviors-BasicBehaviors-BehavioredClassifier",
    	    "",    	    
    	    "CommonBehaviors-BasicBehaviors-A_ownedBehavior_behavioredClassifier-behavioredClassifier",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-BehavioredClassifier-classifierBehavior CommonBehaviors-BasicBehaviors-A_classifierBehavior_behavioredClassifier-behavioredClassifier");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // UML.CommonBehaviors.BasicBehaviors.A_context_behavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_context_behavior", "CommonBehaviors-BasicBehaviors-A_context_behavior");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavior", 
    	    "CommonBehaviors-BasicBehaviors-A_context_behavior-behavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "Classes-Kernel-A_redefinitionContext_redefinableElement-redefinableElement",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-Behavior-context CommonBehaviors-BasicBehaviors-A_context_behavior-behavior");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // UML.CommonBehaviors.BasicBehaviors.A_method_specification 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_method_specification", "CommonBehaviors-BasicBehaviors-A_method_specification");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-BehavioralFeature-method CommonBehaviors-BasicBehaviors-Behavior-specification");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // UML.CommonBehaviors.BasicBehaviors.A_ownedBehavior_behavioredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedBehavior_behavioredClassifier", "CommonBehaviors-BasicBehaviors-A_ownedBehavior_behavioredClassifier");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavioredClassifier", 
    	    "CommonBehaviors-BasicBehaviors-A_ownedBehavior_behavioredClassifier-behavioredClassifier",
    	    "CommonBehaviors-BasicBehaviors-BehavioredClassifier",
    	    "Classes-Kernel-NamedElement-namespace",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-BehavioredClassifier-ownedBehavior CommonBehaviors-BasicBehaviors-A_ownedBehavior_behavioredClassifier-behavioredClassifier");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // UML.CommonBehaviors.BasicBehaviors.A_ownedParameter_behavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedParameter_behavior", "CommonBehaviors-BasicBehaviors-A_ownedParameter_behavior");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavior", 
    	    "CommonBehaviors-BasicBehaviors-A_ownedParameter_behavior-behavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "Classes-Kernel-NamedElement-namespace",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-Behavior-ownedParameter CommonBehaviors-BasicBehaviors-A_ownedParameter_behavior-behavior");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // UML.CommonBehaviors.BasicBehaviors.A_postcondition_behavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_postcondition_behavior", "CommonBehaviors-BasicBehaviors-A_postcondition_behavior");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavior", 
    	    "CommonBehaviors-BasicBehaviors-A_postcondition_behavior-behavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "Classes-Kernel-Constraint-context",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-Behavior-postcondition CommonBehaviors-BasicBehaviors-A_postcondition_behavior-behavior");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // UML.CommonBehaviors.BasicBehaviors.A_precondition_behavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_precondition_behavior", "CommonBehaviors-BasicBehaviors-A_precondition_behavior");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavior", 
    	    "CommonBehaviors-BasicBehaviors-A_precondition_behavior-behavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "Classes-Kernel-Constraint-context",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-Behavior-precondition CommonBehaviors-BasicBehaviors-A_precondition_behavior-behavior");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // UML.CommonBehaviors.BasicBehaviors.A_redefinedBehavior_behavior 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_redefinedBehavior_behavior", "CommonBehaviors-BasicBehaviors-A_redefinedBehavior_behavior");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "behavior", 
    	    "CommonBehaviors-BasicBehaviors-A_redefinedBehavior_behavior-behavior",
    	    "CommonBehaviors-BasicBehaviors-Behavior",
    	    "Classes-Kernel-A_redefinedClassifier_classifier-classifier",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-Behavior-redefinedBehavior CommonBehaviors-BasicBehaviors-A_redefinedBehavior_behavior-behavior");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";   
                      
        // UML.CommonBehaviors.BasicBehaviors.A_result_opaqueExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_result_opaqueExpression", "CommonBehaviors-BasicBehaviors-A_result_opaqueExpression");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "opaqueExpression", 
    	    "CommonBehaviors-BasicBehaviors-A_result_opaqueExpression-opaqueExpression",
    	    "CommonBehaviors-BasicBehaviors-OpaqueExpression",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-OpaqueExpression-result CommonBehaviors-BasicBehaviors-A_result_opaqueExpression-opaqueExpression");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.A_changeExpression_changeEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_changeExpression_changeEvent", "CommonBehaviors-Communications-A_changeExpression_changeEvent");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "changeEvent", 
    	    "CommonBehaviors-Communications-A_changeExpression_changeEvent-changeEvent",
    	    "CommonBehaviors-Communications-ChangeEvent",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-ChangeEvent-changeExpression CommonBehaviors-Communications-A_changeExpression_changeEvent-changeEvent");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.A_event_trigger 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_event_trigger", "CommonBehaviors-Communications-A_event_trigger");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "trigger", 
    	    "CommonBehaviors-Communications-A_event_trigger-trigger",
    	    "CommonBehaviors-Communications-Trigger",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-Trigger-event CommonBehaviors-Communications-A_event_trigger-trigger");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.A_operation_callEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_operation_callEvent", "CommonBehaviors-Communications-A_operation_callEvent");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "callEvent", 
    	    "CommonBehaviors-Communications-A_operation_callEvent-callEvent",
    	    "CommonBehaviors-Communications-CallEvent",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-CallEvent-operation CommonBehaviors-Communications-A_operation_callEvent-callEvent");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.A_ownedAttribute_owningSignal 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedAttribute_owningSignal", "CommonBehaviors-Communications-A_ownedAttribute_owningSignal");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "owningSignal", 
    	    "CommonBehaviors-Communications-A_ownedAttribute_owningSignal-owningSignal",
    	    "CommonBehaviors-Communications-Signal",
    	    "Classes-Kernel-NamedElement-namespace Classes-Kernel-A_attribute_classifier-classifier",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-Signal-ownedAttribute CommonBehaviors-Communications-A_ownedAttribute_owningSignal-owningSignal");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.A_ownedReception_class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedReception_class", "CommonBehaviors-Communications-A_ownedReception_class");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "class", 
    	    "CommonBehaviors-Communications-A_ownedReception_class-class",
    	    "CommonBehaviors-Communications-Class",
    	    "Classes-Kernel-NamedElement-namespace Classes-Kernel-Feature-featuringClassifier",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-Class-ownedReception CommonBehaviors-Communications-A_ownedReception_class-class");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.A_ownedReception_interface 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedReception_interface", "CommonBehaviors-Communications-A_ownedReception_interface");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "interface", 
    	    "CommonBehaviors-Communications-A_ownedReception_interface-interface",
    	    "CommonBehaviors-Communications-Interface",
    	    "Classes-Kernel-NamedElement-namespace Classes-Kernel-Feature-featuringClassifier",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-Interface-ownedReception CommonBehaviors-Communications-A_ownedReception_interface-interface");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.A_signal_reception 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_signal_reception", "CommonBehaviors-Communications-A_signal_reception");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "reception", 
    	    "CommonBehaviors-Communications-A_signal_reception-reception",
    	    "CommonBehaviors-Communications-Reception",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-Reception-signal CommonBehaviors-Communications-A_signal_reception-reception");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";   
                      
        // UML.CommonBehaviors.Communications.A_signal_signalEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_signal_signalEvent", "CommonBehaviors-Communications-A_signal_signalEvent");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.Communications", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "signalEvent", 
    	    "CommonBehaviors-Communications-A_signal_signalEvent-signalEvent",
    	    "CommonBehaviors-Communications-SignalEvent",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-SignalEvent-signal CommonBehaviors-Communications-A_signal_signalEvent-signalEvent");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.A_event_durationObservation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_event_durationObservation", "CommonBehaviors-SimpleTime-A_event_durationObservation");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "durationObservation", 
    	    "CommonBehaviors-SimpleTime-A_event_durationObservation-durationObservation",
    	    "CommonBehaviors-SimpleTime-DurationObservation",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-DurationObservation-event CommonBehaviors-SimpleTime-A_event_durationObservation-durationObservation");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.A_event_timeObservation 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_event_timeObservation", "CommonBehaviors-SimpleTime-A_event_timeObservation");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "timeObservation", 
    	    "CommonBehaviors-SimpleTime-A_event_timeObservation-timeObservation",
    	    "CommonBehaviors-SimpleTime-TimeObservation",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeObservation-event CommonBehaviors-SimpleTime-A_event_timeObservation-timeObservation");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.A_expr_duration 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_expr_duration", "CommonBehaviors-SimpleTime-A_expr_duration");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "duration", 
    	    "CommonBehaviors-SimpleTime-A_expr_duration-duration",
    	    "CommonBehaviors-SimpleTime-Duration",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-Duration-expr CommonBehaviors-SimpleTime-A_expr_duration-duration");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.A_expr_timeExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_expr_timeExpression", "CommonBehaviors-SimpleTime-A_expr_timeExpression");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "timeExpression", 
    	    "CommonBehaviors-SimpleTime-A_expr_timeExpression-timeExpression",
    	    "CommonBehaviors-SimpleTime-TimeExpression",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeExpression-expr CommonBehaviors-SimpleTime-A_expr_timeExpression-timeExpression");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.A_max_durationInterval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_max_durationInterval", "CommonBehaviors-SimpleTime-A_max_durationInterval");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "durationInterval", 
    	    "CommonBehaviors-SimpleTime-A_max_durationInterval-durationInterval",
    	    "CommonBehaviors-SimpleTime-DurationInterval",
    	    "",    	    
    	    "CommonBehaviors-SimpleTime-A_max_interval-interval",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-DurationInterval-max CommonBehaviors-SimpleTime-A_max_durationInterval-durationInterval");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.A_max_interval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_max_interval", "CommonBehaviors-SimpleTime-A_max_interval");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "interval", 
    	    "CommonBehaviors-SimpleTime-A_max_interval-interval",
    	    "CommonBehaviors-SimpleTime-Interval",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-Interval-max CommonBehaviors-SimpleTime-A_max_interval-interval");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.A_max_timeInterval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_max_timeInterval", "CommonBehaviors-SimpleTime-A_max_timeInterval");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "timeInterval", 
    	    "CommonBehaviors-SimpleTime-A_max_timeInterval-timeInterval",
    	    "CommonBehaviors-SimpleTime-TimeInterval",
    	    "",    	    
    	    "CommonBehaviors-SimpleTime-A_max_interval-interval",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeInterval-max CommonBehaviors-SimpleTime-A_max_timeInterval-timeInterval");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.A_min_durationInterval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_min_durationInterval", "CommonBehaviors-SimpleTime-A_min_durationInterval");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "durationInterval", 
    	    "CommonBehaviors-SimpleTime-A_min_durationInterval-durationInterval",
    	    "CommonBehaviors-SimpleTime-DurationInterval",
    	    "",    	    
    	    "CommonBehaviors-SimpleTime-A_min_interval-interval",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-DurationInterval-min CommonBehaviors-SimpleTime-A_min_durationInterval-durationInterval");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.A_min_interval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_min_interval", "CommonBehaviors-SimpleTime-A_min_interval");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "interval", 
    	    "CommonBehaviors-SimpleTime-A_min_interval-interval",
    	    "CommonBehaviors-SimpleTime-Interval",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-Interval-min CommonBehaviors-SimpleTime-A_min_interval-interval");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.A_min_timeInterval 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_min_timeInterval", "CommonBehaviors-SimpleTime-A_min_timeInterval");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "timeInterval", 
    	    "CommonBehaviors-SimpleTime-A_min_timeInterval-timeInterval",
    	    "CommonBehaviors-SimpleTime-TimeInterval",
    	    "",    	    
    	    "CommonBehaviors-SimpleTime-A_min_interval-interval",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeInterval-min CommonBehaviors-SimpleTime-A_min_timeInterval-timeInterval");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.A_observation_duration 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_observation_duration", "CommonBehaviors-SimpleTime-A_observation_duration");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "duration", 
    	    "CommonBehaviors-SimpleTime-A_observation_duration-duration",
    	    "CommonBehaviors-SimpleTime-Duration",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-Duration-observation CommonBehaviors-SimpleTime-A_observation_duration-duration");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.A_observation_timeExpression 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_observation_timeExpression", "CommonBehaviors-SimpleTime-A_observation_timeExpression");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "timeExpression", 
    	    "CommonBehaviors-SimpleTime-A_observation_timeExpression-timeExpression",
    	    "CommonBehaviors-SimpleTime-TimeExpression",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeExpression-observation CommonBehaviors-SimpleTime-A_observation_timeExpression-timeExpression");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.A_specification_durationConstraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_specification_durationConstraint", "CommonBehaviors-SimpleTime-A_specification_durationConstraint");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "durationConstraint", 
    	    "CommonBehaviors-SimpleTime-A_specification_durationConstraint-durationConstraint",
    	    "CommonBehaviors-SimpleTime-DurationConstraint",
    	    "",    	    
    	    "CommonBehaviors-SimpleTime-A_specification_intervalConstraint-intervalConstraint",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-DurationConstraint-specification CommonBehaviors-SimpleTime-A_specification_durationConstraint-durationConstraint");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.A_specification_intervalConstraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_specification_intervalConstraint", "CommonBehaviors-SimpleTime-A_specification_intervalConstraint");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "intervalConstraint", 
    	    "CommonBehaviors-SimpleTime-A_specification_intervalConstraint-intervalConstraint",
    	    "CommonBehaviors-SimpleTime-IntervalConstraint",
    	    "",    	    
    	    "Classes-Kernel-A_specification_owningConstraint-owningConstraint",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-IntervalConstraint-specification CommonBehaviors-SimpleTime-A_specification_intervalConstraint-intervalConstraint");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.A_specification_timeConstraint 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_specification_timeConstraint", "CommonBehaviors-SimpleTime-A_specification_timeConstraint");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "timeConstraint", 
    	    "CommonBehaviors-SimpleTime-A_specification_timeConstraint-timeConstraint",
    	    "CommonBehaviors-SimpleTime-TimeConstraint",
    	    "",    	    
    	    "CommonBehaviors-SimpleTime-A_specification_intervalConstraint-intervalConstraint",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeConstraint-specification CommonBehaviors-SimpleTime-A_specification_timeConstraint-timeConstraint");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";   
                      
        // UML.CommonBehaviors.SimpleTime.A_when_timeEvent 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_when_timeEvent", "CommonBehaviors-SimpleTime-A_when_timeEvent");
        mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "timeEvent", 
    	    "CommonBehaviors-SimpleTime-A_when_timeEvent-timeEvent",
    	    "CommonBehaviors-SimpleTime-TimeEvent",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeEvent-when CommonBehaviors-SimpleTime-A_when_timeEvent-timeEvent");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // UML.Components.BasicComponents.A_contract_connector 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_contract_connector", "Components-BasicComponents-A_contract_connector");
        mapping.mapAssociation(assoc, "UML.Components.BasicComponents", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "connector", 
    	    "Components-BasicComponents-A_contract_connector-connector",
    	    "Components-BasicComponents-Connector",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Components-BasicComponents-Connector-contract Components-BasicComponents-A_contract_connector-connector");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // UML.Components.BasicComponents.A_end_connector 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_end_connector", "Components-BasicComponents-A_end_connector");
        mapping.mapAssociation(assoc, "UML.Components.BasicComponents", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "connector", 
    	    "Components-BasicComponents-A_end_connector-connector",
    	    "Components-BasicComponents-Connector",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Components-BasicComponents-Connector-end Components-BasicComponents-A_end_connector-connector");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // UML.Components.BasicComponents.A_end_role 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_end_role", "Components-BasicComponents-A_end_role");
        mapping.mapAssociation(assoc, "UML.Components.BasicComponents", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Components-BasicComponents-ConnectableElement-end Components-BasicComponents-ConnectorEnd-role");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // UML.Components.BasicComponents.A_partWithPort_connectorEnd 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_partWithPort_connectorEnd", "Components-BasicComponents-A_partWithPort_connectorEnd");
        mapping.mapAssociation(assoc, "UML.Components.BasicComponents", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "connectorEnd", 
    	    "Components-BasicComponents-A_partWithPort_connectorEnd-connectorEnd",
    	    "Components-BasicComponents-ConnectorEnd",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Components-BasicComponents-ConnectorEnd-partWithPort Components-BasicComponents-A_partWithPort_connectorEnd-connectorEnd");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // UML.Components.BasicComponents.A_provided_component 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_provided_component", "Components-BasicComponents-A_provided_component");
        mapping.mapAssociation(assoc, "UML.Components.BasicComponents", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "component", 
    	    "Components-BasicComponents-A_provided_component-component",
    	    "Components-BasicComponents-Component",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Components-BasicComponents-Component-provided Components-BasicComponents-A_provided_component-component");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // UML.Components.BasicComponents.A_realization_abstraction_component 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_realization_abstraction_component", "Components-BasicComponents-A_realization_abstraction_component");
        mapping.mapAssociation(assoc, "UML.Components.BasicComponents", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "Components-BasicComponents-Component-realization Components-BasicComponents-ComponentRealization-abstraction");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // UML.Components.BasicComponents.A_realizingClassifier_componentRealization 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_realizingClassifier_componentRealization", "Components-BasicComponents-A_realizingClassifier_componentRealization");
        mapping.mapAssociation(assoc, "UML.Components.BasicComponents", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "componentRealization", 
    	    "Components-BasicComponents-A_realizingClassifier_componentRealization-componentRealization",
    	    "Components-BasicComponents-ComponentRealization",
    	    "Classes-Dependencies-NamedElement-clientDependency",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Components-BasicComponents-ComponentRealization-realizingClassifier Components-BasicComponents-A_realizingClassifier_componentRealization-componentRealization");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";   
                      
        // UML.Components.BasicComponents.A_required_component 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_required_component", "Components-BasicComponents-A_required_component");
        mapping.mapAssociation(assoc, "UML.Components.BasicComponents", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "component", 
    	    "Components-BasicComponents-A_required_component-component",
    	    "Components-BasicComponents-Component",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Components-BasicComponents-Component-required Components-BasicComponents-A_required_component-component");
                                                              
        packageId = this.artifact.getUrn() + "#" + "Components-PackagingComponents";   
                      
        // UML.Components.PackagingComponents.A_packagedElement_component 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_packagedElement_component", "Components-PackagingComponents-A_packagedElement_component");
        mapping.mapAssociation(assoc, "UML.Components.PackagingComponents", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "component", 
    	    "Components-PackagingComponents-A_packagedElement_component-component",
    	    "Components-PackagingComponents-Component",
    	    "Classes-Kernel-NamedElement-namespace",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "Components-PackagingComponents-Component-packagedElement Components-PackagingComponents-A_packagedElement_component-component");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // UML.CompositeStructures.Collaborations.A_collaborationRole_collaboration 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_collaborationRole_collaboration", "CompositeStructures-Collaborations-A_collaborationRole_collaboration");
        mapping.mapAssociation(assoc, "UML.CompositeStructures.Collaborations", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "collaboration", 
    	    "CompositeStructures-Collaborations-A_collaborationRole_collaboration-collaboration",
    	    "CompositeStructures-Collaborations-Collaboration",
    	    "CompositeStructures-InternalStructures-A_role_structuredClassifier-structuredClassifier",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CompositeStructures-Collaborations-Collaboration-collaborationRole CompositeStructures-Collaborations-A_collaborationRole_collaboration-collaboration");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // UML.CompositeStructures.Collaborations.A_collaborationUse_classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_collaborationUse_classifier", "CompositeStructures-Collaborations-A_collaborationUse_classifier");
        mapping.mapAssociation(assoc, "UML.CompositeStructures.Collaborations", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifier", 
    	    "CompositeStructures-Collaborations-A_collaborationUse_classifier-classifier",
    	    "CompositeStructures-Collaborations-Classifier",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CompositeStructures-Collaborations-Classifier-collaborationUse CompositeStructures-Collaborations-A_collaborationUse_classifier-classifier");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // UML.CompositeStructures.Collaborations.A_representation_classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_representation_classifier", "CompositeStructures-Collaborations-A_representation_classifier");
        mapping.mapAssociation(assoc, "UML.CompositeStructures.Collaborations", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifier", 
    	    "CompositeStructures-Collaborations-A_representation_classifier-classifier",
    	    "CompositeStructures-Collaborations-Classifier",
    	    "",    	    
    	    "CompositeStructures-Collaborations-A_collaborationUse_classifier-classifier",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CompositeStructures-Collaborations-Classifier-representation CompositeStructures-Collaborations-A_representation_classifier-classifier");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // UML.CompositeStructures.Collaborations.A_roleBinding_collaborationUse 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_roleBinding_collaborationUse", "CompositeStructures-Collaborations-A_roleBinding_collaborationUse");
        mapping.mapAssociation(assoc, "UML.CompositeStructures.Collaborations", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "collaborationUse", 
    	    "CompositeStructures-Collaborations-A_roleBinding_collaborationUse-collaborationUse",
    	    "CompositeStructures-Collaborations-CollaborationUse",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CompositeStructures-Collaborations-CollaborationUse-roleBinding CompositeStructures-Collaborations-A_roleBinding_collaborationUse-collaborationUse");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";   
                      
        // UML.CompositeStructures.Collaborations.A_type_collaborationUse 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_type_collaborationUse", "CompositeStructures-Collaborations-A_type_collaborationUse");
        mapping.mapAssociation(assoc, "UML.CompositeStructures.Collaborations", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "collaborationUse", 
    	    "CompositeStructures-Collaborations-A_type_collaborationUse-collaborationUse",
    	    "CompositeStructures-Collaborations-CollaborationUse",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CompositeStructures-Collaborations-CollaborationUse-type CompositeStructures-Collaborations-A_type_collaborationUse-collaborationUse");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // UML.CompositeStructures.InternalStructures.A_attribute_classifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_attribute_classifier", "CompositeStructures-InternalStructures-A_attribute_classifier");
        mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "classifier", 
    	    "CompositeStructures-InternalStructures-A_attribute_classifier-classifier",
    	    "CompositeStructures-InternalStructures-Classifier",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-Classifier-attribute CompositeStructures-InternalStructures-A_attribute_classifier-classifier");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // UML.CompositeStructures.InternalStructures.A_definingEnd_connectorEnd 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_definingEnd_connectorEnd", "CompositeStructures-InternalStructures-A_definingEnd_connectorEnd");
        mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "connectorEnd", 
    	    "CompositeStructures-InternalStructures-A_definingEnd_connectorEnd-connectorEnd",
    	    "CompositeStructures-InternalStructures-ConnectorEnd",
    	    "",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, true, "*");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-ConnectorEnd-definingEnd CompositeStructures-InternalStructures-A_definingEnd_connectorEnd-connectorEnd");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // UML.CompositeStructures.InternalStructures.A_end_connector 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_end_connector", "CompositeStructures-InternalStructures-A_end_connector");
        mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "connector", 
    	    "CompositeStructures-InternalStructures-A_end_connector-connector",
    	    "CompositeStructures-InternalStructures-Connector",
    	    "Classes-Kernel-Element-owner",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, false, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-Connector-end CompositeStructures-InternalStructures-A_end_connector-connector");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // UML.CompositeStructures.InternalStructures.A_end_role 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_end_role", "CompositeStructures-InternalStructures-A_end_role");
        mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-ConnectableElement-end CompositeStructures-InternalStructures-ConnectorEnd-role");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // UML.CompositeStructures.InternalStructures.A_feature_featuringClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_feature_featuringClassifier", "CompositeStructures-InternalStructures-A_feature_featuringClassifier");
        mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-Classifier-feature CompositeStructures-InternalStructures-Feature-featuringClassifier");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // UML.CompositeStructures.InternalStructures.A_ownedAttribute_class 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedAttribute_class", "CompositeStructures-InternalStructures-A_ownedAttribute_class");
        mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        // create owned ends
    	
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-Class-ownedAttribute CompositeStructures-InternalStructures-Property-class");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // UML.CompositeStructures.InternalStructures.A_ownedAttribute_structuredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedAttribute_structuredClassifier", "CompositeStructures-InternalStructures-A_ownedAttribute_structuredClassifier");
        mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "structuredClassifier", 
    	    "CompositeStructures-InternalStructures-A_ownedAttribute_structuredClassifier-structuredClassifier",
    	    "CompositeStructures-InternalStructures-StructuredClassifier",
    	    "Classes-Kernel-NamedElement-namespace CompositeStructures-InternalStructures-A_attribute_classifier-classifier",    	    
    	    "CompositeStructures-InternalStructures-A_role_structuredClassifier-structuredClassifier",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-StructuredClassifier-ownedAttribute CompositeStructures-InternalStructures-A_ownedAttribute_structuredClassifier-structuredClassifier");
                                                              
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";   
                      
        // UML.CompositeStructures.InternalStructures.A_ownedConnector_structuredClassifier 
        pkg = (Package)model.getElementById(packageId).getDelegate();       
     	assoc  = factory.createAssociation("A_ownedConnector_structuredClassifier", "CompositeStructures-InternalStructures-A_ownedConnector_structuredClassifier");
        mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        // create owned ends
    	    	
    	prop = factory.createProperty(assoc, "structuredClassifier", 
    	    "CompositeStructures-InternalStructures-A_ownedConnector_structuredClassifier-structuredClassifier",
    	    "CompositeStructures-InternalStructures-StructuredClassifier",
    	    "Classes-Kernel-NamedElement-namespace Classes-Kernel-Feature-featuringClassifier Classes-Kernel-RedefinableElement-redefinitionContext",    	    
    	    "",    	    
    		false, false, false);    	
        factory.createLowerValue(prop, true, "");
        factory.createUpperValue(prop, false, "");
    	mapping.mapProperty(assoc, prop, this);
    	
        factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-StructuredClassifier-ownedConnector CompositeStructures-InternalStructures-A_ownedConnector_structuredClassifier-structuredClassifier");
                                                              
        packageId = this.ar