/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.CommonBehaviors.Communications;

import UMLPrimitiveTypes.intList;
import fUML.Debug;
import fUML.Semantics.Classes.Kernel.Object_;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.ParameterValueList;
import fUML.Semantics.CommonBehaviors.Communications.ArrivalSignal;
import fUML.Semantics.CommonBehaviors.Communications.ClassifierBehaviorInvocationEventAccepter;
import fUML.Semantics.CommonBehaviors.Communications.ClassifierBehaviorInvocationEventAccepterList;
import fUML.Semantics.CommonBehaviors.Communications.EventAccepter;
import fUML.Semantics.CommonBehaviors.Communications.EventAccepterList;
import fUML.Semantics.CommonBehaviors.Communications.EventOccurrence;
import fUML.Semantics.CommonBehaviors.Communications.EventOccurrenceList;
import fUML.Semantics.CommonBehaviors.Communications.GetNextEventStrategy;
import fUML.Semantics.CommonBehaviors.Communications.InvocationEventOccurrence;
import fUML.Semantics.CommonBehaviors.Communications.ObjectActivation_Behavior;
import fUML.Semantics.Loci.LociL1.ChoiceStrategy;
import fUML.Syntax.Classes.Kernel.Class_;
import fUML.Syntax.Classes.Kernel.Class_List;
import fUML.Syntax.CommonBehaviors.BasicBehaviors.Behavior;
import org.modeldriven.fuml.FumlObject;

public class ObjectActivation
extends FumlObject {
    public ClassifierBehaviorInvocationEventAccepterList classifierBehaviorInvocations = new ClassifierBehaviorInvocationEventAccepterList();
    public EventAccepterList waitingEventAccepters = new EventAccepterList();
    public EventOccurrenceList eventPool = new EventOccurrenceList();
    public Object_ object = null;
    private ObjectActivation_Behavior behavior = new ObjectActivation_Behavior(this);

    public void stop() {
        ClassifierBehaviorInvocationEventAccepterList classifierBehaviorInvocations = this.classifierBehaviorInvocations;
        for (int i = 0; i < classifierBehaviorInvocations.size(); ++i) {
            ClassifierBehaviorInvocationEventAccepter classifierBehaviorInvocation = classifierBehaviorInvocations.getValue(i);
            classifierBehaviorInvocation.terminate();
        }
    }

    public void register(EventAccepter accepter) {
        Debug.println("[register] object = " + this.object);
        Debug.println("[register] accepter = " + accepter);
        this.waitingEventAccepters.addValue(accepter);
    }

    public void unregister(EventAccepter accepter) {
        Debug.println("[unregister] object = " + this.object);
        Debug.println("[unregister] accepter = " + accepter);
        boolean notFound = true;
        int i = 1;
        while (notFound & i <= this.waitingEventAccepters.size()) {
            if (this.waitingEventAccepters.getValue(i - 1) == accepter) {
                this.waitingEventAccepters.remove(i - 1);
                notFound = false;
            }
            ++i;
        }
    }

    public void dispatchNextEvent() {
        if (this.eventPool.size() > 0) {
            EventOccurrence eventOccurrence = this.getNextEvent();
            Debug.println("[dispatchNextEvent] eventOccurrence = " + eventOccurrence);
            intList matchingEventAccepterIndexes = new intList();
            EventAccepterList waitingEventAccepters = this.waitingEventAccepters;
            for (int i = 0; i < waitingEventAccepters.size(); ++i) {
                EventAccepter eventAccepter = waitingEventAccepters.getValue(i);
                if (!eventAccepter.match(eventOccurrence)) continue;
                matchingEventAccepterIndexes.addValue(i);
            }
            if (matchingEventAccepterIndexes.size() > 0) {
                int j = ((ChoiceStrategy)this.object.locus.factory.getStrategy("choice")).choose(matchingEventAccepterIndexes.size());
                int k = matchingEventAccepterIndexes.getValue(j - 1);
                EventAccepter selectedEventAccepter = this.waitingEventAccepters.getValue(k);
                this.waitingEventAccepters.removeValue(k);
                selectedEventAccepter.accept(eventOccurrence);
            }
        }
    }

    public EventOccurrence getNextEvent() {
        return ((GetNextEventStrategy)this.object.locus.factory.getStrategy("getNextEvent")).getNextEvent(this);
    }

    public void send(EventOccurrence eventOccurrence) {
        this.eventPool.addValue(eventOccurrence);
        this._send(new ArrivalSignal());
    }

    public void startBehavior(Class_ classifier, ParameterValueList inputs) {
        this._startObjectBehavior();
        if (classifier == null) {
            Debug.println("[startBehavior] Starting behavior for all classifiers...");
            Class_List types = this.object.types;
            for (Class_ type : types) {
                if (!(type instanceof Behavior | type.classifierBehavior != null)) continue;
                this.startBehavior(type, new ParameterValueList());
            }
        } else {
            Debug.println("[startBehavior] Starting behavior for " + classifier.name + "...");
            ObjectActivation._beginIsolation();
            boolean notYetStarted = true;
            int i = 1;
            while (notYetStarted & i <= this.classifierBehaviorInvocations.size()) {
                notYetStarted = this.classifierBehaviorInvocations.getValue((int)(i - 1)).classifier != classifier;
                ++i;
            }
            if (notYetStarted) {
                ClassifierBehaviorInvocationEventAccepter newInvocation = new ClassifierBehaviorInvocationEventAccepter();
                newInvocation.objectActivation = this;
                this.classifierBehaviorInvocations.addValue(newInvocation);
                newInvocation.invokeBehavior(classifier, inputs);
                InvocationEventOccurrence eventOccurrence = new InvocationEventOccurrence();
                eventOccurrence.execution = newInvocation.execution;
                this.eventPool.addValue(eventOccurrence);
                this._send(new ArrivalSignal());
            }
            ObjectActivation._endIsolation();
        }
    }

    public void _send(ArrivalSignal signal) {
        this.behavior._send(signal);
    }

    public void _startObjectBehavior() {
        this.behavior._startObjectBehavior();
    }

    public static void _endIsolation() {
        Debug.println("[_endIsolation] End isolation.");
    }

    public static void _beginIsolation() {
        Debug.println("[_beginIsolation] Begin isolation.");
    }
}

