/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Actions.BasicActions;

import fUML.Semantics.Actions.BasicActions.InvocationActionActivation;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.Execution;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.ExecutionList;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.ParameterValue;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.ParameterValueList;
import fUML.Syntax.Actions.BasicActions.CallAction;
import fUML.Syntax.Actions.BasicActions.InputPinList;
import fUML.Syntax.Actions.BasicActions.OutputPin;
import fUML.Syntax.Actions.BasicActions.OutputPinList;
import fUML.Syntax.Classes.Kernel.Parameter;
import fUML.Syntax.Classes.Kernel.ParameterDirectionKind;
import fUML.Syntax.Classes.Kernel.ParameterList;

public abstract class CallActionActivation
extends InvocationActionActivation {
    public ExecutionList callExecutions = new ExecutionList();

    @Override
    public void doAction() {
        Execution callExecution = this.getCallExecution();
        if (callExecution != null) {
            int i;
            this.callExecutions.addValue(callExecution);
            CallAction callAction = (CallAction)this.node;
            InputPinList argumentPins = callAction.argument;
            OutputPinList resultPins = callAction.result;
            ParameterList parameters = callExecution.getBehavior().ownedParameter;
            int pinNumber = 1;
            for (i = 1; i <= parameters.size(); ++i) {
                Parameter parameter = parameters.getValue(i - 1);
                if (!(parameter.direction == ParameterDirectionKind.in | parameter.direction == ParameterDirectionKind.inout)) continue;
                ParameterValue parameterValue = new ParameterValue();
                parameterValue.parameter = parameter;
                parameterValue.values = this.takeTokens(argumentPins.getValue(pinNumber - 1));
                callExecution.setParameterValue(parameterValue);
                ++pinNumber;
            }
            callExecution.execute();
            ParameterValueList outputParameterValues = callExecution.getOutputParameterValues();
            pinNumber = 1;
            for (i = 1; i <= parameters.size(); ++i) {
                Parameter parameter = parameters.getValue(i - 1);
                if (!(parameter.direction == ParameterDirectionKind.inout | parameter.direction == ParameterDirectionKind.out | parameter.direction == ParameterDirectionKind.return_)) continue;
                for (int j = 0; j < outputParameterValues.size(); ++j) {
                    ParameterValue outputParameterValue = outputParameterValues.getValue(j);
                    if (outputParameterValue.parameter != parameter) continue;
                    OutputPin resultPin = resultPins.getValue(pinNumber - 1);
                    this.putTokens(resultPin, outputParameterValue.values);
                }
                ++pinNumber;
            }
            callExecution.destroy();
            this.removeCallExecution(callExecution);
        }
    }

    public abstract Execution getCallExecution();

    @Override
    public void terminate() {
        for (int i = 0; i < this.callExecutions.size(); ++i) {
            Execution execution = this.callExecutions.getValue(i);
            execution.terminate();
        }
        super.terminate();
    }

    public void removeCallExecution(Execution execution) {
        boolean notFound = true;
        int i = 1;
        while (notFound & i <= this.callExecutions.size()) {
            if (this.callExecutions.getValue(i - 1) == execution) {
                this.callExecutions.removeValue(i - 1);
                notFound = false;
            }
            ++i;
        }
    }
}

