/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Actions.BasicActions;

import fUML.Debug;
import fUML.Semantics.Actions.BasicActions.PinActivation;
import fUML.Semantics.Actions.BasicActions.PinActivationList;
import fUML.Semantics.Activities.IntermediateActivities.ActivityEdgeInstance;
import fUML.Semantics.Activities.IntermediateActivities.ActivityEdgeInstanceList;
import fUML.Semantics.Activities.IntermediateActivities.ActivityNodeActivation;
import fUML.Semantics.Activities.IntermediateActivities.ActivityNodeActivationGroup;
import fUML.Semantics.Activities.IntermediateActivities.ControlToken;
import fUML.Semantics.Activities.IntermediateActivities.ForkNodeActivation;
import fUML.Semantics.Activities.IntermediateActivities.ObjectToken;
import fUML.Semantics.Activities.IntermediateActivities.Token;
import fUML.Semantics.Activities.IntermediateActivities.TokenList;
import fUML.Semantics.Classes.Kernel.BooleanValue;
import fUML.Semantics.Classes.Kernel.FeatureValueList;
import fUML.Semantics.Classes.Kernel.Link;
import fUML.Semantics.Classes.Kernel.Value;
import fUML.Semantics.Classes.Kernel.ValueList;
import fUML.Syntax.Actions.BasicActions.Action;
import fUML.Syntax.Actions.BasicActions.InputPin;
import fUML.Syntax.Actions.BasicActions.InputPinList;
import fUML.Syntax.Actions.BasicActions.OutputPin;
import fUML.Syntax.Actions.BasicActions.OutputPinList;
import fUML.Syntax.Actions.BasicActions.Pin;
import fUML.Syntax.Activities.IntermediateActivities.ActivityNode;
import fUML.Syntax.Activities.IntermediateActivities.ActivityNodeList;
import fUML.Syntax.Classes.Kernel.LiteralBoolean;

public abstract class ActionActivation
extends ActivityNodeActivation {
    public PinActivationList pinActivations = new PinActivationList();
    public boolean firing = false;

    @Override
    public void initialize(ActivityNode node, ActivityNodeActivationGroup group) {
        super.initialize(node, group);
        this.firing = false;
    }

    @Override
    public void run() {
        super.run();
        if (this.outgoingEdges.size() > 0) {
            this.outgoingEdges.getValue((int)0).target.run();
        }
        this.firing = false;
    }

    @Override
    public TokenList takeOfferedTokens() {
        this.firing = !((Action)this.node).isLocallyReentrant;
        TokenList offeredTokens = new TokenList();
        ActivityEdgeInstanceList incomingEdges = this.incomingEdges;
        for (int i = 0; i < incomingEdges.size(); ++i) {
            ActivityEdgeInstance incomingEdge = incomingEdges.getValue(i);
            TokenList tokens = incomingEdge.takeOfferedTokens();
            for (int j = 0; j < tokens.size(); ++j) {
                Token token = tokens.getValue(j);
                token.withdraw();
                offeredTokens.addValue(token);
            }
        }
        Action action = (Action)this.node;
        InputPinList inputPins = action.input;
        for (InputPin pin : inputPins) {
            PinActivation pinActivation = this.getPinActivation(pin);
            TokenList tokens = pinActivation.takeOfferedTokens();
            pinActivation.fire(tokens);
            for (int j = 0; j < tokens.size(); ++j) {
                Token token = tokens.getValue(j);
                offeredTokens.addValue(token);
            }
        }
        return offeredTokens;
    }

    @Override
    public void fire(TokenList incomingTokens) {
        do {
            Debug.println("[fire] Action " + this.node.name + "...");
            Debug.println("[event] Fire activity=" + this.getActivityExecution().getBehavior().name + " action=" + this.node.name);
            this.doAction();
        } while ((incomingTokens = this.completeAction()).size() > 0);
    }

    @Override
    public void terminate() {
        super.terminate();
        if (this.outgoingEdges.size() > 0) {
            this.outgoingEdges.getValue((int)0).target.terminate();
        }
    }

    public TokenList completeAction() {
        this.sendOffers();
        Debug.println("[fire] Checking if " + this.node.name + " should fire again...");
        ActionActivation._beginIsolation();
        TokenList incomingTokens = new TokenList();
        this.firing = false;
        if (this.isReady()) {
            incomingTokens = this.takeOfferedTokens();
            this.firing = this.isFiring() & incomingTokens.size() > 0;
        }
        ActionActivation._endIsolation();
        return incomingTokens;
    }

    @Override
    public boolean isReady() {
        boolean ready = super.isReady() & (((Action)this.node).isLocallyReentrant | !this.isFiring());
        int i = 1;
        while (ready & i <= this.incomingEdges.size()) {
            ready = this.incomingEdges.getValue(i - 1).hasOffer();
            ++i;
        }
        InputPinList inputPins = ((Action)this.node).input;
        int j = 1;
        while (ready & j <= inputPins.size()) {
            ready = this.getPinActivation(inputPins.getValue(j - 1)).isReady();
            ++j;
        }
        return ready;
    }

    public boolean isFiring() {
        return this.firing;
    }

    public abstract void doAction();

    public void sendOffers() {
        Action action = (Action)this.node;
        OutputPinList outputPins = action.output;
        for (OutputPin outputPin : outputPins) {
            PinActivation pinActivation = this.getPinActivation(outputPin);
            pinActivation.sendUnofferedTokens();
        }
        if (this.outgoingEdges.size() > 0) {
            TokenList tokens = new TokenList();
            tokens.addValue(new ControlToken());
            this.addTokens(tokens);
            this.outgoingEdges.getValue(0).sendOffer(tokens);
        }
    }

    @Override
    public void createNodeActivations() {
        int i;
        int i2;
        Action action = (Action)this.node;
        ActivityNodeList inputPinNodes = new ActivityNodeList();
        InputPinList inputPins = action.input;
        for (i2 = 0; i2 < inputPins.size(); ++i2) {
            InputPin inputPin = inputPins.getValue(i2);
            inputPinNodes.addValue(inputPin);
        }
        this.group.createNodeActivations(inputPinNodes);
        for (i2 = 0; i2 < inputPinNodes.size(); ++i2) {
            ActivityNode node = inputPinNodes.getValue(i2);
            this.addPinActivation((PinActivation)this.group.getNodeActivation(node));
        }
        ActivityNodeList outputPinNodes = new ActivityNodeList();
        OutputPinList outputPins = action.output;
        for (i = 0; i < outputPins.size(); ++i) {
            OutputPin outputPin = outputPins.getValue(i);
            outputPinNodes.addValue(outputPin);
        }
        this.group.createNodeActivations(outputPinNodes);
        for (i = 0; i < outputPinNodes.size(); ++i) {
            ActivityNode node = outputPinNodes.getValue(i);
            this.addPinActivation((PinActivation)this.group.getNodeActivation(node));
        }
    }

    @Override
    public void addOutgoingEdge(ActivityEdgeInstance edge) {
        ActivityNodeActivation forkNodeActivation;
        if (this.outgoingEdges.size() == 0) {
            forkNodeActivation = new ForkNodeActivation();
            forkNodeActivation.running = false;
            ActivityEdgeInstance newEdge = new ActivityEdgeInstance();
            super.addOutgoingEdge(newEdge);
            forkNodeActivation.addIncomingEdge(newEdge);
        } else {
            forkNodeActivation = this.outgoingEdges.getValue((int)0).target;
        }
        forkNodeActivation.addOutgoingEdge(edge);
    }

    public void addPinActivation(PinActivation pinActivation) {
        this.pinActivations.addValue(pinActivation);
        pinActivation.actionActivation = this;
    }

    public PinActivation getPinActivation(Pin pin) {
        PinActivation pinActivation = null;
        int i = 1;
        while (pinActivation == null & i <= this.pinActivations.size()) {
            PinActivation thisPinActivation = this.pinActivations.getValue(i - 1);
            if (thisPinActivation.node == pin) {
                pinActivation = thisPinActivation;
            }
            ++i;
        }
        return pinActivation;
    }

    public void putToken(OutputPin pin, Value value) {
        Debug.println("[putToken] node = " + this.node.name);
        ObjectToken token = new ObjectToken();
        token.value = value;
        PinActivation pinActivation = this.getPinActivation(pin);
        pinActivation.addToken(token);
    }

    public void putTokens(OutputPin pin, ValueList values) {
        for (int i = 0; i < values.size(); ++i) {
            Value value = values.getValue(i);
            this.putToken(pin, value);
        }
    }

    public ValueList getTokens(InputPin pin) {
        Debug.println("[getTokens] node = " + this.node.name + ", pin = " + pin.name);
        PinActivation pinActivation = this.getPinActivation(pin);
        TokenList tokens = pinActivation.getUnofferedTokens();
        ValueList values = new ValueList();
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.getValue(i);
            Value value = ((ObjectToken)token).value;
            if (value == null) continue;
            values.addValue(value);
        }
        return values;
    }

    public ValueList takeTokens(InputPin pin) {
        Debug.println("[takeTokens] node = " + this.node.name + ", pin = " + pin.name);
        PinActivation pinActivation = this.getPinActivation(pin);
        TokenList tokens = pinActivation.takeUnofferedTokens();
        ValueList values = new ValueList();
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.getValue(i);
            Value value = ((ObjectToken)token).value;
            if (value == null) continue;
            values.addValue(value);
        }
        return values;
    }

    @Override
    public boolean isSourceFor(ActivityEdgeInstance edgeInstance) {
        boolean isSource = false;
        if (this.outgoingEdges.size() > 0) {
            isSource = this.outgoingEdges.getValue((int)0).target.isSourceFor(edgeInstance);
        }
        return isSource;
    }

    public boolean valueParticipatesInLink(Value value, Link link) {
        FeatureValueList linkFeatureValues = link.getFeatureValues();
        boolean participates = false;
        int i = 1;
        while (!participates & i <= linkFeatureValues.size()) {
            participates = linkFeatureValues.getValue((int)(i - 1)).values.getValue(0).equals(value);
            ++i;
        }
        return participates;
    }

    public BooleanValue makeBooleanValue(boolean value) {
        LiteralBoolean booleanLiteral = new LiteralBoolean();
        booleanLiteral.value = value;
        return (BooleanValue)this.getExecutionLocus().executor.evaluate(booleanLiteral);
    }
}

