/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Loci.LociL1;

import fUML.Debug;
import fUML.Semantics.Classes.Kernel.Evaluation;
import fUML.Semantics.Classes.Kernel.Object_;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.Execution;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.OpaqueBehaviorExecution;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.OpaqueBehaviorExecutionList;
import fUML.Semantics.Loci.LociL1.Locus;
import fUML.Semantics.Loci.LociL1.SemanticStrategy;
import fUML.Semantics.Loci.LociL1.SemanticStrategyList;
import fUML.Semantics.Loci.LociL1.SemanticVisitor;
import fUML.Syntax.Classes.Kernel.Element;
import fUML.Syntax.Classes.Kernel.PrimitiveType;
import fUML.Syntax.Classes.Kernel.PrimitiveTypeList;
import fUML.Syntax.Classes.Kernel.ValueSpecification;
import fUML.Syntax.CommonBehaviors.BasicBehaviors.Behavior;
import fUML.Syntax.CommonBehaviors.BasicBehaviors.OpaqueBehavior;
import org.modeldriven.fuml.FumlObject;

public abstract class ExecutionFactory
extends FumlObject {
    public Locus locus = null;
    public OpaqueBehaviorExecutionList primitiveBehaviorPrototypes = new OpaqueBehaviorExecutionList();
    public PrimitiveTypeList builtInTypes = new PrimitiveTypeList();
    public SemanticStrategyList strategies = new SemanticStrategyList();

    public Execution createExecution(Behavior behavior, Object_ context) {
        Execution execution;
        if (behavior instanceof OpaqueBehavior) {
            execution = this.instantiateOpaqueBehaviorExecution((OpaqueBehavior)behavior);
        } else {
            execution = (Execution)this.instantiateVisitor(behavior);
            execution.types.addValue(behavior);
            execution.createFeatureValues();
        }
        this.locus.add(execution);
        execution.context = context == null ? execution : context;
        return execution;
    }

    public Evaluation createEvaluation(ValueSpecification specification) {
        Evaluation evaluation = (Evaluation)this.instantiateVisitor(specification);
        evaluation.specification = specification;
        evaluation.locus = this.locus;
        return evaluation;
    }

    public abstract SemanticVisitor instantiateVisitor(Element var1);

    public OpaqueBehaviorExecution instantiateOpaqueBehaviorExecution(OpaqueBehavior behavior) {
        OpaqueBehaviorExecution execution = null;
        int i = 1;
        while (execution == null & i <= this.primitiveBehaviorPrototypes.size()) {
            OpaqueBehaviorExecution prototype = this.primitiveBehaviorPrototypes.getValue(i - 1);
            if (prototype.getBehavior() == behavior) {
                execution = (OpaqueBehaviorExecution)prototype.copy();
            }
            ++i;
        }
        Debug.println(execution == null, "[instantiateOpaqueExecution] No prototype execution found for " + behavior.name + ".");
        return execution;
    }

    public void addPrimitiveBehaviorPrototype(OpaqueBehaviorExecution execution) {
        this.primitiveBehaviorPrototypes.addValue(execution);
    }

    public void addBuiltInType(PrimitiveType type) {
        this.builtInTypes.addValue(type);
    }

    public PrimitiveType getBuiltInType(String name) {
        PrimitiveType type = null;
        int i = 1;
        while (type == null & i <= this.builtInTypes.size()) {
            PrimitiveType primitiveType = this.builtInTypes.getValue(i - 1);
            if (primitiveType.name.equals(name)) {
                type = primitiveType;
            }
            ++i;
        }
        return type;
    }

    public void setStrategy(SemanticStrategy strategy) {
        int i = this.getStrategyIndex(strategy.getName());
        if (i <= this.strategies.size()) {
            this.strategies.removeValue(i - 1);
        }
        this.strategies.addValue(strategy);
    }

    public SemanticStrategy getStrategy(String name) {
        int i = this.getStrategyIndex(name);
        SemanticStrategy strategy = null;
        if (i <= this.strategies.size()) {
            strategy = this.strategies.getValue(i - 1);
        }
        return strategy;
    }

    public int getStrategyIndex(String name) {
        SemanticStrategyList strategies = this.strategies;
        int i = 1;
        boolean unmatched = true;
        while (unmatched & i <= strategies.size()) {
            if (strategies.getValue(i - 1).getName().equals(name)) {
                unmatched = false;
                continue;
            }
            ++i;
        }
        return i;
    }
}

