/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.xmi;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.xmi.XmiNode;
import org.modeldriven.fuml.xmi.XmiReference;

public class XmiMappedReference
implements XmiReference {
    private static Log log = LogFactory.getLog(XmiMappedReference.class);
    private XmiNode node;
    private String name;
    private List<String> ids = new ArrayList<String>();
    protected Classifier classifier;

    private XmiMappedReference() {
    }

    public XmiMappedReference(XmiNode node, String name, String[] values, Classifier classifier) {
        this.node = node;
        this.name = name;
        this.classifier = classifier;
        this.construct(values);
        if (log.isDebugEnabled()) {
            log.debug((Object)("created " + this.node.getLocalName() + " (" + this.node.getXmiId() + ")"));
        }
    }

    @Override
    public Classifier getClassifier() {
        return this.classifier;
    }

    private void construct(String[] values) {
        int i = 0;
        while (i < values.length) {
            this.ids.add(values[i]);
            ++i;
        }
    }

    @Override
    public String getLocalName() {
        return this.name;
    }

    @Override
    public int getLineNumber() {
        return this.node.getLineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.node.getColumnNumber();
    }

    @Override
    public int getReferenceCount() {
        return this.ids.size();
    }

    @Override
    public Iterator<String> getXmiIds() {
        return this.ids.iterator();
    }

    @Override
    public XmiNode getXmiNode() {
        return this.node;
    }
}

