/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.xmi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.assembly.AssemblyAdapter;
import org.modeldriven.fuml.assembly.AssemblyException;
import org.modeldriven.fuml.common.reflect.ReflectionUtils;
import org.modeldriven.fuml.config.FumlConfiguration;
import org.modeldriven.fuml.config.ImportAdapter;
import org.modeldriven.fuml.repository.Class_;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.repository.Property;
import org.modeldriven.fuml.xmi.ModelSupport;
import org.modeldriven.fuml.xmi.XmiNode;
import org.modeldriven.fuml.xmi.XmiReference;
import org.modeldriven.fuml.xmi.stream.StreamNode;

public abstract class AbstractXmiNodeVisitor {
    private static Log log = LogFactory.getLog(AbstractXmiNodeVisitor.class);
    protected XmiNode xmiRoot;
    protected ModelSupport modelSupport;
    protected Map<XmiNode, Classifier> classifierMap = new HashMap<XmiNode, Classifier>();
    protected Map<String, XmiNode> nodeMap = new HashMap<String, XmiNode>();
    protected List<XmiReference> references = new ArrayList<XmiReference>();

    protected AbstractXmiNodeVisitor() {
        this.modelSupport = new ModelSupport();
    }

    protected AbstractXmiNodeVisitor(XmiNode root) {
        this();
        this.xmiRoot = root;
    }

    protected Classifier findClassifier(XmiNode target, XmiNode source) {
        Class_ sourceClassifier;
        Classifier classifier = this.modelSupport.findClassifier(target);
        if (classifier == null && source != null && (sourceClassifier = (Class_)this.classifierMap.get(source)) != null) {
            classifier = this.modelSupport.findClassifier(target, sourceClassifier);
        }
        return classifier;
    }

    protected Classifier findClassifierFromImportAdapter(XmiNode target) {
        Classifier classifier = null;
        ImportAdapter importAdapter = FumlConfiguration.getInstance().findImportAdapter(target.getLocalName());
        if (importAdapter != null) {
            AssemblyAdapter adapter = null;
            try {
                adapter = (AssemblyAdapter)ReflectionUtils.instanceForName(importAdapter.getAdapterClassName());
            }
            catch (Exception e) {
                throw new AssemblyException(e);
            }
            classifier = adapter.getClassifier((StreamNode)target);
        }
        return classifier;
    }

    protected boolean isNotReferenceElement(XmiNode node, Classifier classifier, boolean hasAttributes) {
        return this.modelSupport.isNotReferenceElement(node, classifier, hasAttributes);
    }

    protected boolean isInternalReferenceElement(XmiNode node, Classifier classifier, boolean hasAttributes) {
        return this.modelSupport.isInternalReferenceElement(node, classifier, hasAttributes);
    }

    protected boolean isExternalReferenceElement(XmiNode node, Classifier classifier, boolean hasAttributes) {
        return this.modelSupport.isExternalReferenceElement(node, classifier, hasAttributes);
    }

    protected boolean isAbstract(Classifier classifier) {
        return classifier.isAbstract();
    }

    protected boolean isReferenceAttribute(Property property) {
        return this.modelSupport.isReferenceAttribute(property);
    }

    @Deprecated
    protected Attribute findAttribute(StreamNode node, String localName) {
        QName name = new QName(localName);
        return node.getStartElementEvent().asStartElement().getAttributeByName(name);
    }
}

