/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.xmi;

import fUML.Syntax.Classes.Kernel.Enumeration;
import fUML.Syntax.Classes.Kernel.PrimitiveType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.repository.Class_;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.repository.Property;
import org.modeldriven.fuml.repository.Repository;
import org.modeldriven.fuml.xmi.XmiException;
import org.modeldriven.fuml.xmi.XmiNode;
import org.modeldriven.fuml.xmi.stream.StreamNode;

public class ModelSupport {
    private static Log log = LogFactory.getLog(ModelSupport.class);

    public Classifier findClassifier(XmiNode target) {
        String name = target.getXmiType();
        if (name == null || name.trim().length() == 0) {
            name = target.getLocalName();
        }
        return this.findClassifierByNamespace(target, name);
    }

    public Classifier findClassifier(XmiNode target, Class_ sourceClassifier) {
        Classifier result = null;
        String xmiType = target.getXmiType();
        if (xmiType != null && xmiType.length() > 0) {
            result = this.findClassifierByNamespace(target, xmiType);
        } else {
            Classifier type;
            Property property = sourceClassifier.findProperty(target.getLocalName());
            if (property != null && (type = property.getType()) != null) {
                String name = type.getName();
                result = Repository.INSTANCE.getClassifier(name);
                if ((name.equals("Type") || name.equals("Classifier")) && !this.isInternalReferenceElement((StreamNode)target, result, false) && !this.isExternalReferenceElement((StreamNode)target, result, false)) {
                    result = Repository.INSTANCE.getClassifier("PrimitiveType");
                }
            }
        }
        return result;
    }

    private Classifier findClassifierByNamespace(XmiNode target, String name) {
        String qualifiedName;
        Classifier result;
        String uri = target.getNamespaceURI();
        if (uri == null || uri.length() == 0) {
            throw new XmiException("no namespace URI found for '" + name + "'");
        }
        if (target.getPrefix() != null) {
            uri = target.getNamespaceURI();
        }
        if ((result = Repository.INSTANCE.findClassifier(qualifiedName = String.valueOf(uri) + "#" + name)) == null) {
            qualifiedName = String.valueOf(Repository.INSTANCE.getDefaultUMLNamespaceURI()) + "#" + name;
            result = Repository.INSTANCE.findClassifier(qualifiedName);
        }
        return result;
    }

    public boolean isNotReferenceElement(XmiNode node, Classifier classifier, boolean hasAttributes) {
        Class<?> class_ = classifier.getDelegate().getClass();
        if (PrimitiveType.class.isAssignableFrom(class_) || Enumeration.class.isAssignableFrom(class_)) {
            if (node.getNodes() != null && node.getNodes().size() > 0) {
                log.warn((Object)("found child nodes(s) under primitive type or enumertion, " + classifier.getName()));
            }
            if (hasAttributes) {
                log.warn((Object)("found attribute(s) for primitive type or enumeration, " + classifier.getName()));
            }
            return true;
        }
        return false;
    }

    public boolean isInternalReferenceElement(XmiNode node, Classifier classifier, boolean hasAttributes) {
        if (!this.isNotReferenceElement(node, classifier, hasAttributes)) {
            if (node.hasCharacters()) {
                if (hasAttributes) {
                    log.warn((Object)("found attribute(s) for characters node of type, " + classifier.getName()));
                }
            } else {
                StreamNode eventNode = (StreamNode)node;
                QName idref = new QName(eventNode.getContext().getXmiNamespace().getNamespaceURI(), "idref");
                if (node.hasAttribute(idref)) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isExternalReferenceElement(XmiNode node, Classifier classifier, boolean hasAttributes) {
        QName href;
        boolean result = false;
        if (!this.isNotReferenceElement(node, classifier, hasAttributes) && node.hasAttribute(href = new QName("href"))) {
            String hrefValue = node.getAttributeValue(href);
            if (hrefValue == null) {
                return true;
            }
            int idx = hrefValue.lastIndexOf("#");
            String suffix = hrefValue.substring(idx + 1);
            return !suffix.equals("Integer") && !suffix.equals("Real") && !suffix.equals("String") && !suffix.equals("Boolean") && !suffix.equals("UnlimitedNatural");
        }
        return result;
    }

    public boolean isReferenceAttribute(Property property) {
        Classifier typeClassifier = property.getType();
        return !PrimitiveType.class.isAssignableFrom(typeClassifier.getDelegate().getClass()) && !Enumeration.class.isAssignableFrom(typeClassifier.getDelegate().getClass());
    }
}

