/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.repository.model;

import fUML.Syntax.Classes.Kernel.Package;
import fUML.Syntax.Classes.Kernel.PrimitiveType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.repository.Repository;
import org.modeldriven.fuml.repository.RepositoryArtifact;
import org.modeldriven.fuml.repository.RepositoryMapping;
import org.modeldriven.fuml.repository.config.Artifact;
import org.modeldriven.fuml.repository.model.ModelAssembler;
import org.modeldriven.fuml.repository.model.ModelFactory;

public class PrimitiveTypesAssembler
extends ModelAssembler
implements RepositoryArtifact {
    private static Log log = LogFactory.getLog(PrimitiveTypesAssembler.class);
    private ModelFactory factory;

    public PrimitiveTypesAssembler(Artifact artifact, RepositoryMapping mapping, Repository model) {
        super(artifact, mapping, model);
        this.factory = new ModelFactory(mapping, model);
        this.construct();
    }

    private void construct() {
        log.info((Object)"initializing...");
        this.constructPackages();
        this.constructPrimitiveTypes();
        this.constructEnumerations();
        this.constructClasses();
        this.constructProperties();
        this.constructGeneralizations();
        this.constructAssociations();
    }

    @Override
    public String getURN() {
        return this.artifact.getUrn();
    }

    @Override
    public String getNamespaceURI() {
        return this.artifact.getNamespaceURI();
    }

    private void constructPackages() {
        Package pkg = null;
        pkg = this.factory.createPackage("PrimitiveTypes", "PrimitiveTypes", "PrimitiveTypes", this);
        this.mapping.mapPackage(pkg, null, this);
    }

    private void constructPrimitiveTypes() {
        Package pkg = null;
        String packageId = null;
        PrimitiveType type = null;
        packageId = this.artifact.getUrn() + "#" + "PrimitiveTypes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        type = this.factory.createPrimitiveType("Boolean", "Boolean", pkg);
        this.mapping.mapPrimitiveType(type, "PrimitiveTypes", this);
        packageId = this.artifact.getUrn() + "#" + "PrimitiveTypes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        type = this.factory.createPrimitiveType("Integer", "Integer", pkg);
        this.mapping.mapPrimitiveType(type, "PrimitiveTypes", this);
        packageId = this.artifact.getUrn() + "#" + "PrimitiveTypes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        type = this.factory.createPrimitiveType("Real", "Real", pkg);
        this.mapping.mapPrimitiveType(type, "PrimitiveTypes", this);
        packageId = this.artifact.getUrn() + "#" + "PrimitiveTypes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        type = this.factory.createPrimitiveType("String", "String", pkg);
        this.mapping.mapPrimitiveType(type, "PrimitiveTypes", this);
        packageId = this.artifact.getUrn() + "#" + "PrimitiveTypes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        type = this.factory.createPrimitiveType("UnlimitedNatural", "UnlimitedNatural", pkg);
        this.mapping.mapPrimitiveType(type, "PrimitiveTypes", this);
    }

    private void constructClasses() {
        Object pkg = null;
        Object packageId = null;
        Object clss = null;
    }

    private void constructEnumerations() {
        Object enumeration = null;
        Object literal = null;
    }

    private void constructProperties() {
        Object clss = null;
        Object prop = null;
    }

    private void constructGeneralizations() {
        Object clss = null;
    }

    private void constructAssociations() {
        Object pkg = null;
        Object packageId = null;
        Object assoc = null;
        Object prop = null;
    }
}

