/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.library.channel;

import UMLPrimitiveTypes.UnlimitedNatural;
import fUML.Semantics.Classes.Kernel.BooleanValue;
import fUML.Semantics.Classes.Kernel.IntegerValue;
import fUML.Semantics.Classes.Kernel.StringValue;
import fUML.Semantics.Classes.Kernel.UnlimitedNaturalValue;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.ParameterValue;
import org.modeldriven.fuml.library.channel.OutputChannelObject;
import org.modeldriven.fuml.library.common.Status;
import org.modeldriven.fuml.library.libraryclass.OperationExecution;

public abstract class TextOutputChannelObject
extends OutputChannelObject {
    public abstract void writeString(String var1, Status var2);

    public abstract void writeNewLine(Status var1);

    public void writeLine(String value, Status errorStatus) {
        this.writeString(value, errorStatus);
        this.writeNewLine(errorStatus);
    }

    public void writeInteger(int value, Status errorStatus) {
        this.writeString(Integer.toString(value), errorStatus);
    }

    public void writeBoolean(boolean value, Status errorStatus) {
        this.writeString(Boolean.toString(value), errorStatus);
    }

    public void writeUnlimitedNatural(UnlimitedNatural value, Status errorStatus) {
        int naturalValue = value.naturalValue;
        if (naturalValue < 0) {
            this.writeString("*", errorStatus);
        } else {
            this.writeString(Integer.toString(naturalValue), errorStatus);
        }
    }

    @Override
    public void execute(OperationExecution execution) {
        String name = execution.getOperationName();
        ParameterValue parameterValue = execution.getParameterValue("value");
        Status status = new Status(this.locus, "TextOutputChannel");
        if (name.equals("writeNewLine")) {
            this.writeNewLine(status);
            this.updateStatus(execution, status);
        } else if (name.equals("writeString")) {
            this.writeString(((StringValue)parameterValue.values.getValue((int)0)).value, status);
            this.updateStatus(execution, status);
        } else if (name.equals("writeLine")) {
            this.writeLine(((StringValue)parameterValue.values.getValue((int)0)).value, status);
            this.updateStatus(execution, status);
        } else if (name.equals("writeInteger")) {
            this.writeInteger(((IntegerValue)parameterValue.values.getValue((int)0)).value, status);
            this.updateStatus(execution, status);
        } else if (name.equals("writeBoolean")) {
            this.writeBoolean(((BooleanValue)parameterValue.values.getValue((int)0)).value, status);
            this.updateStatus(execution, status);
        } else if (name.equals("writeUnlimitedNatural")) {
            this.writeUnlimitedNatural(((UnlimitedNaturalValue)parameterValue.values.getValue((int)0)).value, status);
            this.updateStatus(execution, status);
        } else {
            super.execute(execution);
        }
    }
}

