/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.assembly;

import UMLPrimitiveTypes.UnlimitedNatural;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.OpaqueBehaviorExecution;
import fUML.Syntax.Classes.Kernel.Comment;
import fUML.Syntax.Classes.Kernel.DataType;
import fUML.Syntax.Classes.Kernel.Element;
import fUML.Syntax.Classes.Kernel.Enumeration;
import fUML.Syntax.Classes.Kernel.Generalization;
import fUML.Syntax.Classes.Kernel.Package;
import fUML.Syntax.Classes.Kernel.PrimitiveType;
import fUML.Syntax.Classes.Kernel.Type;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.events.Attribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.FumlObject;
import org.modeldriven.fuml.assembly.Assembler;
import org.modeldriven.fuml.assembly.AssemblerNode;
import org.modeldriven.fuml.assembly.AssemblyAdapter;
import org.modeldriven.fuml.assembly.AssemblyException;
import org.modeldriven.fuml.common.lang.JavaKeyWords;
import org.modeldriven.fuml.common.reflect.ReflectionUtils;
import org.modeldriven.fuml.config.FumlConfiguration;
import org.modeldriven.fuml.config.ImportAdapter;
import org.modeldriven.fuml.config.ImportAdapterType;
import org.modeldriven.fuml.config.NamespaceDomain;
import org.modeldriven.fuml.config.NamespaceMapping;
import org.modeldriven.fuml.config.ReferenceMappingType;
import org.modeldriven.fuml.config.ValidationExemption;
import org.modeldriven.fuml.config.ValidationExemptionType;
import org.modeldriven.fuml.environment.Environment;
import org.modeldriven.fuml.library.Library;
import org.modeldriven.fuml.library.libraryclass.ImplementationObject;
import org.modeldriven.fuml.repository.Class_;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.repository.Property;
import org.modeldriven.fuml.repository.Repository;
import org.modeldriven.fuml.xmi.ModelSupport;
import org.modeldriven.fuml.xmi.XmiExternalReferenceElement;
import org.modeldriven.fuml.xmi.XmiIdentity;
import org.modeldriven.fuml.xmi.XmiMappedReference;
import org.modeldriven.fuml.xmi.XmiNode;
import org.modeldriven.fuml.xmi.XmiReference;
import org.modeldriven.fuml.xmi.XmiReferenceAttribute;
import org.modeldriven.fuml.xmi.stream.StreamNode;
import org.modeldriven.fuml.xmi.validation.ErrorCode;
import org.modeldriven.fuml.xmi.validation.ErrorSeverity;
import org.modeldriven.fuml.xmi.validation.ValidationError;
import org.modeldriven.fuml.xmi.validation.ValidationException;

public class ElementAssembler
extends AssemblerNode
implements XmiIdentity,
Assembler {
    private static Log log = LogFactory.getLog(ElementAssembler.class);
    private Repository metadata = Repository.INSTANCE;
    private List<XmiReference> references;
    private Map<String, ElementAssembler> assemblerMap;
    private ModelSupport modelSupport;
    private boolean assembleExternalReferences = true;
    private ElementAssembler parentAssembler;
    private List<Generalization> deferredGeneralizations;
    private XmiNode source;
    private XmiNode parent;
    private Attribute xmiId;
    private Attribute xmiHref;
    private String xmiNamespace;
    private Class_ prototype;
    private Element target;
    private Comment targetComment;

    private ElementAssembler() {
    }

    public ElementAssembler(XmiNode source, XmiNode parent, Class_ prototype, Map<String, ElementAssembler> assemblerMap) {
        super(source);
        this.source = source;
        this.parent = parent;
        this.prototype = prototype;
        this.assemblerMap = assemblerMap;
        this.modelSupport = new ModelSupport();
        StreamNode eventNode = (StreamNode)this.source;
        QName idName = new QName(eventNode.getContext().getXmiNamespace().getNamespaceURI(), "id");
        this.xmiId = eventNode.getAttribute(idName);
        QName hrefName = new QName("href");
        this.xmiHref = eventNode.getStartElementEvent().asStartElement().getAttributeByName(hrefName);
        this.xmiNamespace = eventNode.getNamespaceURI();
        if (this.xmiNamespace == null) {
            throw new AssemblyException("could not find namespace for node '" + eventNode.getLocalName() + "'");
        }
    }

    public ElementAssembler getParentAssembler() {
        return this.parentAssembler;
    }

    public void setParentAssembler(ElementAssembler parentAssembler) {
        this.parentAssembler = parentAssembler;
    }

    public List<Generalization> getDeferredGeneralizations() {
        return this.deferredGeneralizations;
    }

    public void addDeferredGeneralization(Generalization generalization) {
        ElementAssembler parent = this.getParentAssembler();
        if (parent == null) {
            if (this.deferredGeneralizations == null) {
                this.deferredGeneralizations = new ArrayList<Generalization>();
            }
            this.deferredGeneralizations.add(generalization);
        } else {
            parent.addDeferredGeneralization(generalization);
        }
    }

    @Override
    public void assembleElementClass() {
        block33: {
            try {
                String packageName = this.metadata.getJavaPackageNameForClass(this.prototype);
                String instancecClassName = this.prototype.getDelegate().name;
                if ("Class".equals(instancecClassName)) {
                    instancecClassName = String.valueOf(instancecClassName) + "_";
                }
                String qualifiedName = String.valueOf(packageName) + "." + instancecClassName;
                FumlObject object = null;
                ImportAdapter importAdapter = FumlConfiguration.getInstance().findImportAdapter(instancecClassName);
                if (importAdapter == null || importAdapter.getType().ordinal() != ImportAdapterType.ASSEMBLY.ordinal()) {
                    object = (FumlObject)ReflectionUtils.instanceForName(qualifiedName);
                } else {
                    AssemblyAdapter adapter = (AssemblyAdapter)ReflectionUtils.instanceForName(importAdapter.getAdapterClassName());
                    object = adapter.assembleElement((StreamNode)this.source);
                }
                if (this.xmiId != null) {
                    object.setXmiId(this.xmiId.getValue());
                } else {
                    object.setXmiId(UUID.randomUUID().toString());
                }
                if (this.xmiHref != null) {
                    object.setHref(this.xmiHref.getValue());
                }
                if (this.xmiId == null && this.xmiHref == null) {
                    log.warn((Object)("found (" + object.getClass().getName() + ") element with no xmi:id or href"));
                }
                object.setXmiNamespace(this.xmiNamespace);
                if (object instanceof Element) {
                    if (object instanceof PrimitiveType && object.getHref() != null) {
                        int idx = object.getHref().lastIndexOf("#");
                        String suffix = object.getHref().substring(idx + 1);
                        if (suffix.equals("Integer")) {
                            this.target = Environment.getInstance().getInteger();
                        } else if (suffix.equals("String")) {
                            this.target = Environment.getInstance().getString();
                        } else if (suffix.equals("Boolean")) {
                            this.target = Environment.getInstance().getBoolean();
                        } else if (suffix.equals("Real")) {
                            this.target = Environment.getInstance().getReal();
                        } else if (suffix.equals("UnlimitedNatural")) {
                            this.target = Environment.getInstance().getUnlimitedNatural();
                        } else {
                            throw new AssemblyException("unknown type, " + object.getHref());
                        }
                        if (this.target == null) {
                            throw new AssemblyException("could not determine target object for prototype, " + this.prototype.getXmiNamespace() + "#" + this.prototype.getName());
                        }
                    } else {
                        this.target = (Element)object;
                        if (this.target == null) {
                            throw new AssemblyException("could not determine target object for prototype, " + this.prototype.getXmiNamespace() + "#" + this.prototype.getName());
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("constructing class " + this.target.getClass().getName()));
                        }
                    }
                    break block33;
                }
                if (object instanceof Comment) {
                    this.targetComment = (Comment)object;
                    if (this.targetComment == null) {
                        throw new AssemblyException("could not determine target object for prototype, " + this.prototype.getXmiNamespace() + "#" + this.prototype.getName());
                    }
                    break block33;
                }
                throw new AssemblyException("unknown instance, " + object.getClass().getName());
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AssemblyException(e);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AssemblyException(e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.getCause().getMessage(), e.getCause());
                throw new AssemblyException(e.getCause());
            }
            catch (IllegalAccessException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AssemblyException(e);
            }
            catch (InstantiationException e) {
                if (e.getCause() != null) {
                    log.error((Object)e.getCause().getMessage(), e.getCause());
                } else {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
                throw new AssemblyException(e);
            }
        }
    }

    public void registerElement() {
        try {
            Object object;
            if (!(this.target instanceof Type)) {
                return;
            }
            Type targetType = (Type)this.target;
            ElementAssembler assembler = this;
            String qualifiedPackageName = "";
            Package parentPackage = null;
            if (assembler.getParentAssembler() != null && assembler.getParentAssembler().getTarget() instanceof Package) {
                parentPackage = (Package)assembler.getParentAssembler().getTarget();
            }
            int i = 0;
            while ((assembler = assembler.getParentAssembler()) != null) {
                if (!(assembler.getTarget() instanceof Package)) break;
                Package pckg = (Package)assembler.getTarget();
                String name = pckg.name;
                qualifiedPackageName = i > 0 ? String.valueOf(name) + "." + qualifiedPackageName : name;
                ++i;
            }
            String libraryObjectClassName = null;
            libraryObjectClassName = qualifiedPackageName != null && qualifiedPackageName.trim().length() > 0 ? String.valueOf(qualifiedPackageName) + "." + targetType.name : targetType.name;
            targetType.qualifiedName = libraryObjectClassName;
            if (parentPackage != null) {
                targetType.package_ = parentPackage;
            }
            if (!(targetType instanceof fUML.Syntax.Classes.Kernel.Class_)) {
                return;
            }
            fUML.Syntax.Classes.Kernel.Class_ targetClass = (fUML.Syntax.Classes.Kernel.Class_)targetType;
            String implObjectClassName = FumlConfiguration.getInstance().findExecutionClassName(libraryObjectClassName);
            if (implObjectClassName == null) {
                return;
            }
            Classifier implClassifier = this.metadata.getClassifierByQualifiedName(implObjectClassName);
            if (implClassifier == null && log.isDebugEnabled()) {
                log.debug((Object)("(expected) no classifier found for mapped library class '" + implObjectClassName + "' for library class, " + libraryObjectClassName));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("mapped " + targetType.name + " to " + implObjectClassName));
            }
            if ((object = ReflectionUtils.instanceForName(implObjectClassName)) instanceof ImplementationObject) {
                ImplementationObject execution = (ImplementationObject)object;
                execution.types.add(targetClass);
                log.info((Object)("adding to locus: " + execution.getClass().getName()));
                Environment.getInstance().locus.add(execution);
            } else if (object instanceof OpaqueBehaviorExecution) {
                OpaqueBehaviorExecution execution = (OpaqueBehaviorExecution)object;
                execution.types.add(targetClass);
                Environment.getInstance().locus.factory.addPrimitiveBehaviorPrototype(execution);
            } else {
                log.warn((Object)("unknown instance, " + object.getClass().getName()));
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AssemblyException(e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AssemblyException(e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getCause().getMessage(), e.getCause());
            throw new AssemblyException(e.getCause());
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AssemblyException(e);
        }
        catch (InstantiationException e) {
            if (e.getCause() != null) {
                log.error((Object)e.getCause().getMessage(), e.getCause());
            } else {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            throw new AssemblyException(e);
        }
    }

    @Override
    public void associateElement(ElementAssembler other) {
        block17: {
            try {
                Property property = other.getPrototype().findProperty(this.getSource().getLocalName());
                if (property == null) {
                    return;
                }
                if ("generalization".equals(this.source.getLocalName())) {
                    this.addDeferredGeneralization((Generalization)this.getTargetObject());
                    return;
                }
                if (!property.isSingular()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("linking collection property: " + other.getPrototype().getName() + "." + this.getSource().getLocalName() + " with: " + this.getPrototype().getName()));
                    }
                    try {
                        String methodName = "add" + this.getSource().getLocalName().substring(0, 1).toUpperCase() + this.getSource().getLocalName().substring(1);
                        Method adder = ReflectionUtils.getMethod(other.getTargetClass(), methodName, this.getTargetClass());
                        Object[] args = new Object[]{this.getTargetObject()};
                        adder.invoke((Object)other.getTarget(), args);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            Field field = other.getTargetClass().getField(this.getSource().getLocalName());
                            Object list = field.get(other.getTargetObject());
                            Method adder = ReflectionUtils.getMethod(list.getClass(), "add", this.getTargetClass());
                            Object[] args = new Object[]{this.getTargetObject()};
                            adder.invoke(list, args);
                            break block17;
                        }
                        catch (NoSuchFieldException e2) {
                            log.warn((Object)("no 'add' or 'List.add' method found for property, " + other.getPrototype().getName() + "." + this.getSource().getLocalName()));
                        }
                    }
                    break block17;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("linking singular property: " + other.getPrototype().getName() + "." + this.getSource().getLocalName() + " with: " + this.getPrototype().getName()));
                }
                try {
                    String methodName = "set" + this.getSource().getLocalName().substring(0, 1).toUpperCase() + this.getSource().getLocalName().substring(1);
                    Method setter = ReflectionUtils.getMethod(other.getTargetClass(), methodName, this.getTargetClass());
                    Object[] args = new Object[]{this.getTargetObject()};
                    setter.invoke((Object)other.getTarget(), args);
                }
                catch (NoSuchMethodException e) {
                    try {
                        Field field = other.getTargetClass().getField(this.getSource().getLocalName());
                        field.set(other.getTargetObject(), this.getTargetObject());
                    }
                    catch (NoSuchFieldException e2) {
                        log.warn((Object)("no 'set' method or public field found for property, " + other.getPrototype().getName() + "." + this.getSource().getLocalName()));
                    }
                }
            }
            catch (NoSuchMethodException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AssemblyException(e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)e.getCause().getMessage(), e.getCause());
                throw new AssemblyException(e.getCause());
            }
            catch (IllegalAccessException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AssemblyException(e);
            }
        }
    }

    public void associateDeferredGeneralizations() {
        List<Generalization> deferredGeneralizations = this.getDeferredGeneralizations();
        if (deferredGeneralizations != null) {
            while (!deferredGeneralizations.isEmpty()) {
                int i = 0;
                while (i < deferredGeneralizations.size()) {
                    Generalization deferredGeneralization = deferredGeneralizations.get(i);
                    for (Generalization generalization : deferredGeneralizations) {
                        if (generalization.specific != deferredGeneralization.general) continue;
                        ++i;
                    }
                    deferredGeneralization.specific.addGeneralization(deferredGeneralization);
                    deferredGeneralizations.remove(deferredGeneralization);
                }
            }
        }
    }

    @Override
    public void assembleFeatures() {
        try {
            String defaultValue;
            NamespaceDomain domain = null;
            StreamNode eventNode = (StreamNode)this.source;
            Location loc = eventNode.getLocation();
            if (log.isDebugEnabled()) {
                log.debug((Object)("element line/column: " + loc.getLineNumber() + ":" + loc.getColumnNumber()));
            }
            Iterator<Attribute> attributes = eventNode.getAttributes();
            while (attributes != null && attributes.hasNext()) {
                Attribute xmlAttrib = attributes.next();
                QName name = xmlAttrib.getName();
                String prefix = name.getPrefix();
                if (prefix != null && prefix.length() > 0 || "href".equals(name.getLocalPart())) continue;
                Property property = this.prototype.findProperty(name.getLocalPart());
                if (property == null) {
                    ValidationExemption exemption;
                    if (domain == null) {
                        domain = FumlConfiguration.getInstance().findNamespaceDomain(this.source.getNamespaceURI());
                    }
                    if ((exemption = FumlConfiguration.getInstance().findValidationExemptionByProperty(ValidationExemptionType.UNDEFINED_PROPERTY, this.prototype, name.getLocalPart(), this.source.getNamespaceURI(), domain)) == null) {
                        throw new ValidationException(new ValidationError(eventNode, name.getLocalPart(), ErrorCode.UNDEFINED_PROPERTY, ErrorSeverity.FATAL));
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("undefined property exemption found within domain '" + exemption.getDomain().toString() + "' for property '" + this.prototype.getName() + "." + name.getLocalPart() + "' - ignoring error"));
                    continue;
                }
                Classifier type = property.getType();
                if (this.modelSupport.isReferenceAttribute(property)) {
                    XmiReferenceAttribute reference = new XmiReferenceAttribute(this.source, xmlAttrib, this.getPrototype());
                    this.addReference(reference);
                    continue;
                }
                String value = xmlAttrib.getValue();
                if ((value == null || value.length() == 0) && (defaultValue = property.findPropertyDefault()) != null) {
                    value = defaultValue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("using default '" + String.valueOf(value) + "' for enumeration feature <" + type.getName() + "> " + this.getPrototype().getName() + "." + property.getName()));
                    }
                }
                this.assembleNonReferenceFeature(property, value, type);
            }
            List<Property> properties = this.prototype.getNamedProperties();
            for (Property property : properties) {
                ValidationExemption exemption;
                QName name = new QName(property.getName());
                String value = eventNode.getAttributeValue(name);
                if (value != null && value.trim().length() > 0) continue;
                XmiNode childNode = eventNode.findChildByName(property.getName());
                if (childNode != null) {
                    if (this.modelSupport.isReferenceAttribute(property)) continue;
                    this.assembleNonReferenceFeature(property, childNode.getData(), property.getType());
                    continue;
                }
                defaultValue = property.findPropertyDefault();
                if (defaultValue != null) {
                    Classifier type = property.getType();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("using default: '" + String.valueOf(defaultValue) + "' for enumeration feature <" + type.getName() + "> " + this.getPrototype().getName() + "." + property.getName()));
                    }
                    this.assembleNonReferenceFeature(property, defaultValue, type);
                    continue;
                }
                if (!property.isRequired()) continue;
                if (this.modelSupport.isReferenceAttribute(property) && FumlConfiguration.getInstance().hasReferenceMapping(this.prototype, property)) {
                    ReferenceMappingType mappingType = FumlConfiguration.getInstance().getReferenceMappingType(this.prototype, property);
                    if (mappingType == ReferenceMappingType.PARENT) {
                        if (this.parent != null && this.parent.getXmiId() != null && this.parent.getXmiId().length() > 0) {
                            XmiMappedReference reference = new XmiMappedReference(this.source, property.getName(), new String[]{this.parent.getXmiId()}, this.prototype);
                            this.addReference(reference);
                            continue;
                        }
                        log.warn((Object)("no parent XMI id found, ignoring mapping for, " + this.prototype.getName() + "." + property.getName()));
                    } else {
                        log.warn((Object)("unrecognized mapping type, " + mappingType.value() + " ignoring mapping for, " + this.prototype.getName() + "." + property.getName()));
                    }
                }
                if (property.isDerived()) continue;
                if (domain == null) {
                    domain = FumlConfiguration.getInstance().findNamespaceDomain(this.source.getNamespaceURI());
                }
                if ((exemption = FumlConfiguration.getInstance().findValidationExemptionByProperty(ValidationExemptionType.REQUIRED_PROPERTY, this.prototype, name.getLocalPart(), this.source.getNamespaceURI(), domain)) == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("throwing " + ErrorCode.PROPERTY_REQUIRED.toString() + " error for " + this.prototype.getName() + "." + property.getName()));
                    }
                    throw new ValidationException(new ValidationError(eventNode, property.getName(), ErrorCode.PROPERTY_REQUIRED, ErrorSeverity.FATAL));
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("required property exemption found within domain '" + exemption.getDomain().toString() + "' for property '" + this.prototype.getName() + "." + name.getLocalPart() + "' - ignoring error"));
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AssemblyException(e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AssemblyException(e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getCause().getMessage(), e.getCause());
            throw new AssemblyException(e.getCause());
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AssemblyException(e);
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AssemblyException(e);
        }
        catch (NoSuchFieldException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AssemblyException(e);
        }
    }

    @Override
    public void assembleReferenceFeatures() {
        try {
            if (this.references == null) {
                return;
            }
            for (XmiReference reference : this.references) {
                this.assembleReferenceFeature(reference);
            }
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AssemblyException(e);
        }
        catch (NoSuchMethodException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AssemblyException(e);
        }
        catch (InvocationTargetException e) {
            log.error((Object)e.getCause().getMessage(), e.getCause());
            throw new AssemblyException(e.getCause());
        }
        catch (IllegalAccessException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AssemblyException(e);
        }
        catch (InstantiationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AssemblyException(e);
        }
        catch (NoSuchFieldException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AssemblyException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assembleNonReferenceFeature(Property property, String stringValue, Classifier type) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        if (type.getDelegate() instanceof Enumeration) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("assembling enum feature <" + type.getName() + "> " + this.getPrototype().getName() + "." + property.getName() + " = " + stringValue));
            }
            Object value = this.toEnumerationValue(stringValue, type);
            this.assembleEnumerationFeature(property, value, type);
            return;
        }
        if (type.getDelegate() instanceof DataType) {
            Class javaType = this.toPrimitiveJavaClass((DataType)type.getDelegate());
            Object value = this.toPrimitiveJavaValue(stringValue, (DataType)type.getDelegate(), javaType);
            if (log.isDebugEnabled()) {
                log.debug((Object)("assembling primitive feature <" + javaType.getName() + "> " + this.getPrototype().getName() + "." + property.getName() + " = " + stringValue));
            }
            if (property.isSingular()) {
                this.assembleSingularPrimitiveFeature(property, value, javaType);
                return;
            } else {
                this.assembleCollectionPrimitiveFeature(property, value, javaType);
            }
            return;
        }
        if (!(type.getDelegate() instanceof fUML.Syntax.Classes.Kernel.Class_)) throw new AssemblyException("unexpected instance, " + type.getClass().getName());
        if (!UnlimitedNatural.class.getSimpleName().equals(type.getName())) throw new AssemblyException("unexpected Class_, " + type.getName());
        UnlimitedNatural value = new UnlimitedNatural();
        if ("*".equals(stringValue)) {
            value.naturalValue = -1;
        } else {
            try {
                value.naturalValue = Integer.parseInt(stringValue);
            }
            catch (NumberFormatException e) {
                throw new AssemblyException(e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("assembling primitive feature <" + UnlimitedNatural.class.getSimpleName() + "> " + this.getPrototype().getName() + "." + property.getName() + " = " + stringValue));
        }
        if (property.isSingular()) {
            this.assembleSingularPrimitiveFeature(property, value, UnlimitedNatural.class);
            return;
        } else {
            this.assembleCollectionPrimitiveFeature(property, value, UnlimitedNatural.class);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void assembleReferenceFeature(XmiReference reference) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        String packageName;
        String qualifiedName;
        Class<?> fClass_;
        StreamNode eventNode = (StreamNode)this.getSource();
        Property property = this.prototype.getProperty(reference.getLocalName());
        Classifier type = property.getType();
        if (type.getDelegate() instanceof Enumeration || type.getDelegate() instanceof DataType) {
            return;
        }
        String instancecClassName = type.getName();
        if ("Class".equals(instancecClassName)) {
            instancecClassName = String.valueOf(instancecClassName) + "_";
        }
        if (!Element.class.isAssignableFrom(fClass_ = Class.forName(qualifiedName = String.valueOf(packageName = this.metadata.getJavaPackageNameForClass(type)) + "." + instancecClassName))) {
            log.warn((Object)("ignoring non-element feature <" + type.getName() + "> " + this.getPrototype().getName() + "." + property.getName()));
            return;
        }
        if (property.isSingular()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("assembling singular reference feature <" + type.getName() + "> " + this.getPrototype().getName() + "." + property.getName()));
            }
            if (reference.getReferenceCount() != 1) {
                log.warn((Object)("expected single reference, not " + String.valueOf(reference.getReferenceCount())));
            }
            String id = reference.getXmiIds().next();
            if (reference instanceof XmiExternalReferenceElement) {
                Element referent;
                if (!this.assembleExternalReferences) return;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("assembling singular external reference feature <" + type.getName() + "> " + this.getPrototype().getName() + "." + property.getName()));
                }
                if ((referent = this.resolveExternalReference(eventNode, reference, id)) == null) return;
                this.assembleSingularReferenceFeature(referent, property, type);
                return;
            } else {
                Element target = null;
                ElementAssembler referencedAssembler = this.assemblerMap.get(id);
                target = referencedAssembler != null ? referencedAssembler.getTarget() : Environment.getInstance().findElementById(id);
                if (target == null) throw new ValidationException(new ValidationError(reference, id, ErrorCode.INVALID_REFERENCE, ErrorSeverity.FATAL));
                this.assembleSingularReferenceFeature(target, property, type);
            }
            return;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("assembling collection reference feature <" + type.getName() + "> " + this.getPrototype().getName() + "." + property.getName()));
            }
            Iterator<String> iter = reference.getXmiIds();
            while (iter.hasNext()) {
                String id = iter.next();
                if (reference instanceof XmiExternalReferenceElement) {
                    Element referent;
                    if (!this.assembleExternalReferences || (referent = this.resolveExternalReference(eventNode, reference, id)) == null) continue;
                    this.assembleCollectionReferenceFeature(referent, property, type);
                    continue;
                }
                FumlObject target = null;
                ElementAssembler referencedAssembler = this.assemblerMap.get(id);
                target = referencedAssembler != null ? referencedAssembler.getTargetObject() : Environment.getInstance().findElementById(id);
                if (target == null) throw new ValidationException(new ValidationError(reference, id, ErrorCode.INVALID_REFERENCE, ErrorSeverity.FATAL));
                this.assembleCollectionReferenceFeature(target, property, type);
            }
        }
    }

    private Element resolveExternalReference(StreamNode eventNode, XmiReference reference, String id) {
        org.modeldriven.fuml.repository.Element elem;
        Element referent;
        NamespaceDomain domain = null;
        if (id == null) {
            throw new ValidationException(new ValidationError(reference, "", ErrorCode.INVALID_EXTERNAL_REFERENCE, ErrorSeverity.FATAL));
        }
        String mappedId = id;
        if (mappedId.toUpperCase().startsWith("PATHMAP:")) {
            int idx = id.lastIndexOf("#");
            String pathmap = id.substring(0, idx);
            NamespaceMapping mapping = FumlConfiguration.getInstance().findPathmap(pathmap);
            if (mapping == null) {
                throw new ValidationException(new ValidationError(reference, mappedId, ErrorCode.INVALID_EXTERNAL_REFERENCE, ErrorSeverity.FATAL));
            }
            mappedId = String.valueOf(mapping.getTarget()) + id.substring(idx);
            if (log.isDebugEnabled()) {
                log.debug((Object)("resolved external pathmap reference '" + id + "' to '" + mappedId + "'"));
            }
        }
        if ((referent = Library.getInstance().lookup(mappedId)) == null && (elem = Repository.INSTANCE.findElementByQualifiedName(mappedId)) != null) {
            referent = elem.getDelegate();
        }
        if (referent == null) {
            ValidationExemption exemption;
            if (domain == null) {
                domain = FumlConfiguration.getInstance().findNamespaceDomain(eventNode.getNamespaceURI());
            }
            if ((exemption = FumlConfiguration.getInstance().findValidationExemptionByReference(ValidationExemptionType.EXTERNAL_REFERENCE, reference.getClassifier(), id, eventNode.getNamespaceURI(), domain)) == null) {
                exemption = FumlConfiguration.getInstance().findValidationExemptionByReference(ValidationExemptionType.EXTERNAL_REFERENCE, reference.getClassifier(), mappedId, eventNode.getNamespaceURI(), domain);
            }
            if (exemption == null) {
                throw new ValidationException(new ValidationError(reference, mappedId, ErrorCode.INVALID_EXTERNAL_REFERENCE, ErrorSeverity.FATAL));
            }
        }
        return referent;
    }

    private void assembleEnumerationFeature(Property property, Object value, Classifier type) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        try {
            Class[] types = new Class[]{value.getClass()};
            String methodName = "set" + property.getName().substring(0, 1).toUpperCase() + property.getName().substring(1);
            Method setter = this.getTarget().getClass().getMethod(methodName, types);
            Object[] args = new Object[]{value};
            setter.invoke((Object)this.getTarget(), args);
        }
        catch (NoSuchMethodException e) {
            try {
                Field field = this.getTargetClass().getField(property.getName());
                field.set(this.getTargetObject(), value);
            }
            catch (NoSuchFieldException e2) {
                String msg = "no fUML (" + this.getTargetObject().getClass().getName() + ") setter method or public field found for enumeration feature " + "<" + type.getName() + "> " + this.getPrototype().getName() + "." + property.getName();
                log.warn((Object)msg);
            }
        }
    }

    private void assembleSingularPrimitiveFeature(Property property, Object value, Class javaType) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        String methodName = "set" + property.getName().substring(0, 1).toUpperCase() + property.getName().substring(1);
        Object[] args = new Object[]{value};
        try {
            Method setter = this.getTargetClass().getMethod(methodName, javaType);
            setter.invoke((Object)this.getTargetObject(), args);
        }
        catch (NoSuchMethodException e) {
            try {
                FumlObject targetObject = this.getTargetObject();
                Class<?> targetClass = targetObject.getClass();
                Field field = targetClass.getField(property.getName());
                field.set(targetObject, value);
            }
            catch (NoSuchFieldException e2) {
                String msg = "no fUML (" + this.getTargetObject().getClass().getName() + ") setter method named '" + methodName + "' or public field found for primitive feature " + "<" + javaType.getName() + "> " + this.getPrototype().getName() + "." + property.getName();
                log.warn((Object)msg);
            }
        }
    }

    private void assembleCollectionPrimitiveFeature(Property property, Object value, Class javaType) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        String methodName = "add" + property.getName().substring(0, 1).toUpperCase() + property.getName().substring(1);
        try {
            Object[] args = new Object[]{value};
            Method adder = this.getTargetClass().getMethod(methodName, javaType);
            adder.invoke((Object)this.getTargetObject(), args);
        }
        catch (NoSuchMethodException e) {
            try {
                Field field = this.getTargetClass().getField(property.getName());
                Object list = field.get(this.getTargetObject());
                Method adder = ReflectionUtils.getMethod(list.getClass(), "add", value.getClass());
                Object[] args = new Object[]{value};
                adder.invoke(list, args);
            }
            catch (NoSuchMethodException e2) {
                String msg = "no fUML (" + this.getTargetObject().getClass().getName() + ") add method or public field found for primitive collection property " + "<" + javaType.getName() + "> " + this.getPrototype().getName() + "." + property.getName();
                log.warn((Object)msg);
            }
            catch (NoSuchFieldException e2) {
                String msg = "no fUML (" + this.getTargetObject().getClass().getName() + ") add method or public field found for primitive collection property " + "<" + javaType.getName() + "> " + this.getPrototype().getName() + "." + property.getName();
                log.warn((Object)msg);
            }
        }
    }

    private void assembleSingularReferenceFeature(FumlObject target, Property property, Classifier type) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        try {
            String methodName = "set" + property.getName().substring(0, 1).toUpperCase() + property.getName().substring(1);
            Method setter = ReflectionUtils.getMethod(this.getTarget().getClass(), methodName, target.getClass());
            Object[] args = new Object[]{target};
            setter.invoke((Object)this.getTarget(), args);
        }
        catch (NoSuchMethodException e) {
            try {
                Field field = this.getTargetClass().getField(property.getName());
                field.set(this.getTargetObject(), target);
            }
            catch (NoSuchFieldException e2) {
                String msg = "no fUML (" + this.getTargetObject().getClass().getName() + ") setter method or public field found for singular property " + "<" + type.getName() + "> " + this.getPrototype().getName() + "." + property.getName();
                log.warn((Object)msg);
            }
        }
    }

    private void assembleCollectionReferenceFeature(FumlObject target, Property property, Classifier type) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException, NoSuchFieldException {
        try {
            String methodName = "add" + property.getName().substring(0, 1).toUpperCase() + property.getName().substring(1);
            Method adder = ReflectionUtils.getMethod(this.getTargetObject().getClass(), methodName, target.getClass());
            Object[] args = new Object[]{target};
            adder.invoke((Object)this.getTarget(), args);
        }
        catch (NoSuchMethodException e) {
            try {
                Field field = this.getTargetClass().getField(property.getName());
                Object list = field.get(this.getTargetObject());
                Method adder = ReflectionUtils.findMethod(list.getClass(), "add", target.getClass());
                Object[] args = new Object[]{target};
                adder.invoke(list, args);
            }
            catch (NoSuchMethodException e2) {
                String msg = "no fUML (" + this.getTargetObject().getClass().getName() + ") add method or public field found for collection property " + "<" + type.getName() + "> " + this.getPrototype().getName() + "." + property.getName();
                log.warn((Object)msg);
            }
        }
    }

    private Class toPrimitiveJavaClass(DataType dataType) {
        if (PrimitiveType.class.isAssignableFrom(dataType.getClass())) {
            if (dataType.name != null && dataType.name.trim().length() > 0) {
                if (String.class.getSimpleName().equals(dataType.name)) {
                    return String.class;
                }
                if (Integer.class.getSimpleName().equals(dataType.name)) {
                    return Integer.TYPE;
                }
                if (Boolean.class.getSimpleName().equals(dataType.name)) {
                    return Boolean.TYPE;
                }
                if (UnlimitedNatural.class.getSimpleName().equals(dataType.name)) {
                    return Integer.TYPE;
                }
                if ("Real".equals(dataType.name)) {
                    return Float.TYPE;
                }
                throw new AssemblyException("unknown dataType (" + dataType.getClass().getName() + ") name: '" + dataType.name + "'");
            }
            if (dataType.getHref() != null) {
                if (dataType.getHref().endsWith(String.class.getSimpleName())) {
                    return String.class;
                }
                if (dataType.getHref().endsWith(Integer.class.getSimpleName())) {
                    return Integer.TYPE;
                }
                if (dataType.getHref().endsWith(Boolean.class.getSimpleName())) {
                    return Boolean.TYPE;
                }
                if (dataType.getHref().endsWith(UnlimitedNatural.class.getSimpleName())) {
                    return Integer.TYPE;
                }
                if (dataType.getHref().endsWith("Real")) {
                    return Integer.TYPE;
                }
                throw new AssemblyException("unknown dataType (" + dataType.getClass().getName() + ") href: '" + dataType.getHref() + "'");
            }
            throw new AssemblyException("expected name or href for primitive type, " + dataType.getClass().getName());
        }
        throw new AssemblyException("expected primitive type not (" + dataType.getClass().getName() + ") name: '" + dataType.name + "'");
    }

    private Object toPrimitiveJavaValue(String value, DataType dataType, Class javaType) {
        if (javaType.equals(String.class)) {
            return value;
        }
        if (javaType.equals(Integer.class)) {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                if (value == null || value.length() == 0) {
                    return new Integer(0);
                }
                if (UnlimitedNatural.class.getSimpleName().equals(dataType.name) && "*".equals(value)) {
                    return new Integer(-1);
                }
                throw e;
            }
        }
        if (javaType.equals(Integer.TYPE)) {
            try {
                return (int)Integer.valueOf(value);
            }
            catch (NumberFormatException e) {
                if (value == null || value.length() == 0) {
                    return 0;
                }
                if (UnlimitedNatural.class.getSimpleName().equals(dataType.name) && "*".equals(value)) {
                    return -1;
                }
                throw e;
            }
        }
        if (javaType.equals(Boolean.class)) {
            return Boolean.valueOf(value);
        }
        if (javaType.equals(Boolean.TYPE)) {
            return (boolean)Boolean.valueOf(value);
        }
        if (javaType.equals(Float.TYPE)) {
            return Float.valueOf(Float.valueOf(value).floatValue());
        }
        return value;
    }

    private Object toEnumerationValue(String value, Classifier type) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException, InstantiationException {
        String pkg = this.metadata.getJavaPackageNameForClass(type);
        String qualifiedName = String.valueOf(pkg) + "." + type.getName();
        Class<?> enumClass = Class.forName(qualifiedName);
        if (!enumClass.isEnum()) {
            throw new AssemblyException("expected class as enum, " + enumClass.getName());
        }
        Method valueOf = enumClass.getMethod("valueOf", String.class);
        if (JavaKeyWords.getInstance().isKeyWord(value)) {
            value = String.valueOf(value) + "_";
        }
        Object enumValue = valueOf.invoke(enumClass, value);
        return enumValue;
    }

    @Override
    public String getXmiId() {
        return this.getTargetObject().getXmiId();
    }

    public Element getTarget() {
        return this.target;
    }

    public FumlObject getTargetObject() {
        if (this.target != null) {
            return this.target;
        }
        return this.targetComment;
    }

    public Class getTargetClass() {
        if (this.target != null) {
            return this.target.getClass();
        }
        return this.targetComment.getClass();
    }

    public Comment getTargetComment() {
        return this.targetComment;
    }

    public Class_ getPrototype() {
        return this.prototype;
    }

    public XmiNode getSource() {
        return this.source;
    }

    public XmiNode getParent() {
        return this.parent;
    }

    public void addReference(XmiReference ref) {
        if (this.references == null) {
            this.references = new ArrayList<XmiReference>();
        }
        this.references.add(ref);
    }

    public boolean isAssembleExternalReferences() {
        return this.assembleExternalReferences;
    }

    public void setAssembleExternalReferences(boolean assembleExternalReferences) {
        this.assembleExternalReferences = assembleExternalReferences;
    }
}

