/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Classes.Kernel;

import fUML.Semantics.Classes.Kernel.PrimitiveValue;
import fUML.Semantics.Classes.Kernel.Value;
import fUML.Syntax.Classes.Kernel.LiteralInteger;
import fUML.Syntax.Classes.Kernel.ValueSpecification;

public class IntegerValue
extends PrimitiveValue {
    public int value = 0;

    @Override
    public ValueSpecification specify() {
        LiteralInteger literal = new LiteralInteger();
        literal.type = this.type;
        literal.value = this.value;
        return literal;
    }

    @Override
    public boolean equals(Value otherValue) {
        boolean isEqual = false;
        if (otherValue instanceof IntegerValue) {
            isEqual = ((IntegerValue)otherValue).value == this.value;
        }
        return isEqual;
    }

    @Override
    public Value copy() {
        IntegerValue newValue = (IntegerValue)super.copy();
        newValue.value = this.value;
        return newValue;
    }

    @Override
    protected Value new_() {
        return new IntegerValue();
    }

    @Override
    public String toString() {
        String stringValue = "";
        if (this.value == 0) {
            stringValue = "0";
        } else {
            int positiveValue = this.value;
            if (positiveValue < 0) {
                positiveValue = -positiveValue;
            }
            do {
                int digit;
                if ((digit = positiveValue % 10) == 0) {
                    stringValue = "0" + stringValue;
                    continue;
                }
                if (digit == 1) {
                    stringValue = "1" + stringValue;
                    continue;
                }
                if (digit == 2) {
                    stringValue = "2" + stringValue;
                    continue;
                }
                if (digit == 3) {
                    stringValue = "3" + stringValue;
                    continue;
                }
                if (digit == 4) {
                    stringValue = "4" + stringValue;
                    continue;
                }
                if (digit == 5) {
                    stringValue = "5" + stringValue;
                    continue;
                }
                if (digit == 6) {
                    stringValue = "6" + stringValue;
                    continue;
                }
                if (digit == 7) {
                    stringValue = "7" + stringValue;
                    continue;
                }
                if (digit == 8) {
                    stringValue = "8" + stringValue;
                    continue;
                }
                if (digit != 9) continue;
                stringValue = "9" + stringValue;
            } while ((positiveValue /= 10) > 0);
            if (this.value < 0) {
                stringValue = "-" + stringValue;
            }
        }
        return stringValue;
    }
}

