/*
 * Initial version copyright 2008 Lockheed Martin Corporation, except
 * as stated in the file entitled Licensing-Information.
 *
 * Modifications:
 * Copyright 2009 Data Access Technologies, Inc.
 * Copyright 2013 Ivar Jacobson International SA
 *
 * Licensed under the Academic Free License version 3.0
 * (http://www.opensource.org/licenses/afl-3.0.php), except as stated
 * in the file entitled Licensing-Information.
 *
 * Contributors:
 *   MDS - initial API and implementation
 *   IJI
 *
 */
package org.modeldriven.fuml.test.load.profile;

import org.modeldriven.fuml.repository.ext.Stereotype;

import fUML.Syntax.Classes.Kernel.Enumeration;
import fUML.Syntax.Classes.Kernel.Property;

/**
 * 
 * This stereotype constrains a UML property by means of a given UML
 * enumeration. It enables use of UML Enumerations which are <b>part</b> of the
 * UML model when specifying a constraint on class properties. UML Enumerations
 * used with this stereotype must be tagged with the Enumeration stereotype.
 * 
 */
public class EnumerationConstraint extends Stereotype {

	/**
	 * The UML enumeration class with which to restrict a UML property. UML
	 * Enumerations used with this stereotype must be tagged with the
	 * SDOEnumeration stereotype.
	 */
	public static final String VALUE = "value";
	public static final String BASE__PROPERTY = "base_Property";

	/**
	 * The UML enumeration class with which to restrict a UML property. UML
	 * Enumerations used with this stereotype must be tagged with the
	 * SDOEnumeration stereotype.
	 */
	private Enumeration value;
	private Property base_Property;

	public Enumeration getValue() {
		return this.value;
	}

	public void setValue(Enumeration value) {
		this.value = value;
	}

	public Property getBase_Property() {
		return this.base_Property;
	}

	public void setBase_Property(Property value) {
		this.base_Property = value;
	}
}
