/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.library;

import fUML.Syntax.Classes.Kernel.NamedElement;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.config.FumlConfiguration;
import org.modeldriven.fuml.config.LibraryConfiguration;
import org.modeldriven.fuml.config.LibraryImport;
import org.modeldriven.fuml.io.ArtifactLoader;
import org.modeldriven.fuml.io.ResourceArtifact;
import org.modeldriven.fuml.library.LibraryException;
import org.modeldriven.fuml.repository.Element;
import org.modeldriven.fuml.repository.Repository;

public class Library {
    private static Log log = LogFactory.getLog(Library.class);
    private static Library instance = null;
    private LibraryConfiguration config;

    private Library() {
    }

    public static Library getInstance() throws LibraryException {
        if (instance == null) {
            Library.initializeInstance();
        }
        return instance;
    }

    private static synchronized void initializeInstance() {
        if (instance == null) {
            instance = new Library();
            instance.initialize();
        }
    }

    private void initialize() {
        log.info((Object)"initializing...");
        this.config = FumlConfiguration.getInstance().getConfig().getLibraryConfiguration();
        if (this.config != null && this.config.getLibraryImport() != null) {
            Iterator<LibraryImport> libraryImports = this.config.getLibraryImport().iterator();
            while (libraryImports.hasNext()) {
                this.load(libraryImports.next());
            }
        }
    }

    private void load(LibraryImport libraryImport) {
        log.info((Object)("loading library artifact, " + libraryImport.getName()));
        InputStream stream = Library.class.getResourceAsStream(libraryImport.getName());
        if (stream == null) {
            throw new LibraryException("cannot find resource '" + libraryImport.getName() + "'");
        }
        ResourceArtifact artifact = new ResourceArtifact(libraryImport.getName(), libraryImport.getUrn(), stream);
        ArtifactLoader reader = new ArtifactLoader();
        reader.read(artifact);
        log.info((Object)("completed library artifact, " + libraryImport.getName()));
    }

    public NamedElement lookup(String id) {
        Element elem = Repository.INSTANCE.findElementById(id);
        if (elem != null) {
            return (NamedElement)elem.getDelegate();
        }
        return null;
    }
}

