/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Actions.CompleteActions;

import fUML.Debug;
import fUML.Semantics.Actions.BasicActions.ActionActivation;
import fUML.Semantics.Actions.CompleteActions.AcceptEventActionEventAccepter;
import fUML.Semantics.Activities.IntermediateActivities.ActivityNodeActivationGroup;
import fUML.Semantics.Activities.IntermediateActivities.TokenList;
import fUML.Semantics.Classes.Kernel.FeatureValue;
import fUML.Semantics.Classes.Kernel.FeatureValueList;
import fUML.Semantics.Classes.Kernel.ValueList;
import fUML.Semantics.CommonBehaviors.Communications.SignalInstance;
import fUML.Syntax.Actions.BasicActions.OutputPin;
import fUML.Syntax.Actions.BasicActions.OutputPinList;
import fUML.Syntax.Actions.CompleteActions.AcceptEventAction;
import fUML.Syntax.Activities.IntermediateActivities.ActivityNode;
import fUML.Syntax.CommonBehaviors.Communications.Signal;
import fUML.Syntax.CommonBehaviors.Communications.SignalEvent;
import fUML.Syntax.CommonBehaviors.Communications.TriggerList;

public class AcceptEventActionActivation
extends ActionActivation {
    public AcceptEventActionEventAccepter eventAccepter = null;
    public Boolean waiting = false;

    @Override
    public void initialize(ActivityNode node, ActivityNodeActivationGroup group) {
        super.initialize(node, group);
        this.waiting = false;
    }

    @Override
    public void run() {
        super.run();
        this.eventAccepter = new AcceptEventActionEventAccepter();
        this.eventAccepter.actionActivation = this;
        this.waiting = false;
    }

    @Override
    public void fire(TokenList incomingTokens) {
        Debug.println("[fire] Action " + this.node.name + "...");
        this.getExecutionContext().register(this.eventAccepter);
        this.waiting = true;
        this.firing = false;
        this.suspend();
    }

    @Override
    public boolean isReady() {
        boolean ready = this.waiting != false ? false : super.isReady();
        return ready;
    }

    @Override
    public void doAction() {
    }

    public void accept(SignalInstance signalInstance) {
        AcceptEventAction action = (AcceptEventAction)this.node;
        OutputPinList resultPins = action.result;
        Debug.println("[accept] action = " + action.name + ", signalinstance = " + signalInstance);
        if (this.running) {
            if (!action.isUnmarshall) {
                ValueList result = new ValueList();
                result.addValue(signalInstance);
                if (resultPins.size() > 0) {
                    this.putTokens(resultPins.getValue(0), result);
                }
            } else {
                FeatureValueList featureValues = signalInstance.getMemberValues();
                int i = 0;
                while (i < featureValues.size()) {
                    FeatureValue featureValue = featureValues.getValue(i);
                    OutputPin resultPin = resultPins.getValue(i);
                    this.putTokens(resultPin, featureValue.values);
                    ++i;
                }
            }
            this.sendOffers();
            this.waiting = false;
            Debug.println("[fire] Checking if " + this.node.name + " should fire again...");
            this.receiveOffer();
            this.resume();
        }
    }

    public boolean match(SignalInstance signalInstance) {
        AcceptEventAction action = (AcceptEventAction)this.node;
        TriggerList triggers = action.trigger;
        Signal signal = signalInstance.type;
        boolean matches = false;
        int i = 1;
        while (!matches & i <= triggers.size()) {
            Signal triggerSignal = ((SignalEvent)triggers.getValue((int)(i - 1)).event).signal;
            matches = triggerSignal == signal ? true : this.checkAllParents(signal, triggerSignal);
            ++i;
        }
        return matches;
    }

    @Override
    public void terminate() {
        super.terminate();
        if (this.waiting.booleanValue()) {
            this.getExecutionContext().unregister(this.eventAccepter);
            this.waiting = false;
        }
    }
}

