/*
 * Decompiled with CFR 0.152.
 */
package fUML.Test;

import fUML.Debug;
import fUML.Semantics.Classes.Kernel.BooleanValue;
import fUML.Semantics.Classes.Kernel.EnumerationValue;
import fUML.Semantics.Classes.Kernel.IntegerValue;
import fUML.Semantics.Classes.Kernel.Reference;
import fUML.Semantics.Classes.Kernel.StringValue;
import fUML.Semantics.Classes.Kernel.StructuredValue;
import fUML.Semantics.Classes.Kernel.Value;
import fUML.Semantics.Classes.Kernel.ValueList;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.Execution;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.ParameterValue;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.ParameterValueList;
import fUML.Syntax.Classes.Kernel.Classifier;
import fUML.Syntax.Classes.Kernel.ClassifierList;
import fUML.Syntax.Classes.Kernel.Enumeration;
import fUML.Syntax.Classes.Kernel.NamedElement;
import fUML.Syntax.Classes.Kernel.Property;
import fUML.Syntax.Classes.Kernel.PropertyList;
import fUML.Test.Test;
import fUML.Test.TestEnvironment;
import fUML.Test.Variable;

public class VariableUtility
extends Test {
    public VariableUtility(TestEnvironment environment) {
        this.environment = environment;
    }

    public void setValue(String variable, boolean value) {
        BooleanValue newValue = new BooleanValue();
        newValue.type = this.environment.primitiveTypes.Boolean;
        newValue.value = value;
        this.environment.setVariable(variable, newValue);
    }

    public void setValue(String variable, int value) {
        IntegerValue newValue = new IntegerValue();
        newValue.type = this.environment.primitiveTypes.Integer;
        newValue.value = value;
        this.environment.setVariable(variable, newValue);
    }

    public void setValue(String variable, String value) {
        StringValue newValue = new StringValue();
        newValue.type = this.environment.primitiveTypes.String;
        newValue.value = value;
        this.environment.setVariable(variable, newValue);
    }

    public void clearValue(String variable) {
        this.environment.setVariable(variable, null);
    }

    public void copyValue(String target, String source) {
        Variable sourceVariable = this.environment.getVariable(source);
        if (sourceVariable == null) {
            Debug.println("[copyValue] Variable " + source + " not found.");
            return;
        }
        this.environment.setVariable(target, sourceVariable.value.copy());
    }

    public void setEnumerationValue(String variable, String typeName, String literalName) {
        NamedElement element = this.environment.getElement(typeName);
        if (element == null) {
            Debug.println("[createEnumerationValue] " + typeName + " not found.");
        } else if (!(element instanceof Enumeration)) {
            Debug.println("[createEnumerationValue] " + typeName + " is not an enumeration.");
        } else {
            Enumeration enumeration = (Enumeration)element;
            for (int i = 0; i < enumeration.ownedLiteral.size(); ++i) {
                if (!enumeration.ownedLiteral.getValue((int)i).name.equals(literalName)) continue;
                EnumerationValue newValue = new EnumerationValue();
                newValue.type = enumeration;
                newValue.literal = enumeration.ownedLiteral.getValue(i);
                this.environment.setVariable(variable, newValue);
                return;
            }
            Debug.println("[createEnumerationValue] " + literalName + " is not an owned literal of " + typeName + ".");
        }
    }

    public void setDefaultValue(String variable, String typeName) {
        Classifier type = this.environment.getType(typeName);
        if (type == null) {
            Debug.println("[setDefaultValue] " + typeName + " not found or not a classifier.");
            return;
        }
        Value value = this.environment.makeValue(type);
        this.environment.setVariable(variable, value);
        Debug.println(value.toString());
    }

    public void printVariables() {
        Debug.println("");
        Debug.println(this.environment.variables.size() + " variable(s)");
        Debug.println("----------");
        for (int i = 0; i < this.environment.variables.size(); ++i) {
            Variable variable = this.environment.variables.getValue(i);
            this.printVariable(variable.name);
        }
        Debug.println("");
    }

    public void printVariable(String variableName) {
        Variable variable = this.environment.getVariable(variableName);
        if (variable == null) {
            Debug.println("[printVariable] " + variableName + "does not exist.");
            return;
        }
        Debug.println(variableName + " = " + variable.value);
    }

    public void copyToAttribute(String target, String attributeName, String source) {
        Variable sourceVariable = this.environment.getVariable(source);
        if (sourceVariable == null) {
            Debug.println("[copyToAttribute] " + source + " does not exist.");
            return;
        }
        this.setAttributeValue(target, attributeName, sourceVariable.value.copy());
    }

    public void setAttributeValue(String target, String attributeName, Value sourceValue) {
        Variable targetVariable = this.environment.getVariable(target);
        if (targetVariable == null) {
            Debug.println("[setAttribute] " + target + " does not exist.");
            return;
        }
        Value value = targetVariable.value;
        if (!(value instanceof StructuredValue)) {
            Debug.println("[setAttribute] " + target + "does not hold a structured value.");
            return;
        }
        StructuredValue targetValue = (StructuredValue)value;
        ClassifierList types = targetValue.getTypes();
        Property attribute = null;
        block0: for (int i = 0; i < types.size(); ++i) {
            PropertyList attributes = types.getValue((int)i).attribute;
            for (int j = 0; j < attributes.size(); ++j) {
                if (!attributes.getValue((int)j).name.equals(attributeName)) continue;
                attribute = attributes.getValue(j);
                continue block0;
            }
        }
        if (attribute == null) {
            Debug.println("[setAttribute] " + attributeName + " not found.");
            return;
        }
        ValueList values = new ValueList();
        values.addValue(sourceValue);
        targetValue.setFeatureValue(attribute, values, 0);
    }

    public void setAttributeValue(String target, String attributeName, int value) {
        IntegerValue integerValue = new IntegerValue();
        integerValue.value = value;
        this.setAttributeValue(target, attributeName, integerValue);
    }

    public void setAttributeValue(String target, String attributeName, boolean value) {
        BooleanValue booleanValue = new BooleanValue();
        booleanValue.value = value;
        this.setAttributeValue(target, attributeName, booleanValue);
    }

    public void setAttributeValue(String target, String attributeName, String value) {
        StringValue stringValue = new StringValue();
        stringValue.value = value;
        this.setAttributeValue(target, attributeName, stringValue);
    }

    public void run(String variableName) {
        Variable variable = this.environment.getVariable(variableName);
        if (variable == null || variable.value == null || !(variable.value instanceof Reference) || !(((Reference)variable.value).referent instanceof Execution)) {
            Debug.println("[run] " + variableName + " not found or does not have an execution as its value.");
            return;
        }
        Execution execution = (Execution)((Reference)variable.value).referent;
        Debug.println("[run] Executing " + variableName + "...");
        execution.execute();
        ParameterValueList outputParameterValues = execution.getOutputParameterValues();
        for (int i = 0; i < outputParameterValues.size(); ++i) {
            ParameterValue outputParameterValue = outputParameterValues.getValue(i);
            Debug.println("[run] Output parameter " + outputParameterValue.parameter.name + " has " + outputParameterValue.values.size() + " value(s):");
            for (int j = 0; j < outputParameterValue.values.size(); ++j) {
                Debug.println("[run] value [" + j + "] = " + outputParameterValue.values.getValue(j));
            }
        }
        Debug.println("");
    }
}

