/*
 * Decompiled with CFR 0.152.
 */
package fUML.Library.ChannelImplementation;

import UMLPrimitiveTypes.UnlimitedNatural;
import fUML.Library.ChannelImplementation.OutputChannelObject;
import fUML.Library.LibraryClassImplementation.OperationExecution;
import fUML.Semantics.Classes.Kernel.BooleanValue;
import fUML.Semantics.Classes.Kernel.IntegerValue;
import fUML.Semantics.Classes.Kernel.StringValue;
import fUML.Semantics.Classes.Kernel.UnlimitedNaturalValue;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.ParameterValue;

public abstract class TextOutputChannelObject
extends OutputChannelObject {
    public abstract void writeString(String var1);

    public abstract void writeNewLine();

    public void writeLine(String value) {
        this.writeString(value);
        this.writeNewLine();
    }

    public void writeInteger(int value) {
        this.writeString(Integer.toString(value));
    }

    public void writeBoolean(boolean value) {
        this.writeString(Boolean.toString(value));
    }

    public void writeUnlimitedNatural(UnlimitedNatural value) {
        int naturalValue = value.naturalValue;
        if (naturalValue < 0) {
            this.writeString("*");
        } else {
            this.writeString(Integer.toString(naturalValue));
        }
    }

    @Override
    public void execute(OperationExecution execution) {
        String name = execution.getOperationName();
        ParameterValue parameterValue = execution.getParameterValue("value");
        if (name.equals("writeNewLine")) {
            this.writeNewLine();
        } else if (name.equals("writeString")) {
            this.writeString(((StringValue)parameterValue.values.getValue((int)0)).value);
        } else if (name.equals("writeLine")) {
            this.writeLine(((StringValue)parameterValue.values.getValue((int)0)).value);
        } else if (name.equals("writeInteger")) {
            this.writeInteger(((IntegerValue)parameterValue.values.getValue((int)0)).value);
        } else if (name.equals("writeBoolean")) {
            this.writeBoolean(((BooleanValue)parameterValue.values.getValue((int)0)).value);
        } else if (name.equals("writeUnlimitedNatural")) {
            this.writeUnlimitedNatural(((UnlimitedNaturalValue)parameterValue.values.getValue((int)0)).value);
        } else {
            super.execute(execution);
        }
    }
}

