/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Activities.IntermediateActivities;

import fUML.Debug;
import fUML.Semantics.Actions.BasicActions.ActionActivation;
import fUML.Semantics.Activities.CompleteStructuredActivities.StructuredActivityNodeActivation;
import fUML.Semantics.Activities.IntermediateActivities.ActivityEdgeInstance;
import fUML.Semantics.Activities.IntermediateActivities.ActivityEdgeInstanceList;
import fUML.Semantics.Activities.IntermediateActivities.ActivityExecution;
import fUML.Semantics.Activities.IntermediateActivities.ActivityNodeActivation;
import fUML.Semantics.Activities.IntermediateActivities.ActivityNodeActivationList;
import fUML.Semantics.Activities.IntermediateActivities.ActivityParameterNodeActivation;
import fUML.Semantics.Activities.IntermediateActivities.ActivityParameterNodeActivationList;
import fUML.Semantics.Activities.IntermediateActivities.ControlNodeActivation;
import fUML.Syntax.Actions.BasicActions.Action;
import fUML.Syntax.Actions.BasicActions.InputPin;
import fUML.Syntax.Actions.BasicActions.InputPinList;
import fUML.Syntax.Actions.BasicActions.Pin;
import fUML.Syntax.Activities.IntermediateActivities.ActivityEdge;
import fUML.Syntax.Activities.IntermediateActivities.ActivityEdgeList;
import fUML.Syntax.Activities.IntermediateActivities.ActivityNode;
import fUML.Syntax.Activities.IntermediateActivities.ActivityNodeList;
import org.modeldriven.fuml.FumlObject;

public class ActivityNodeActivationGroup
extends FumlObject {
    public ActivityEdgeInstanceList edgeInstances = new ActivityEdgeInstanceList();
    public ActivityNodeActivationList nodeActivations = new ActivityNodeActivationList();
    public ActivityExecution activityExecution = null;
    public StructuredActivityNodeActivation containingNodeActivation = null;
    public ActivityNodeActivationList suspendedActivations = new ActivityNodeActivationList();

    public void run(ActivityNodeActivationList activations) {
        for (int i = 0; i < activations.size(); ++i) {
            ActivityNodeActivation activation = activations.getValue(i);
            activation.run();
        }
        Debug.println("[run] Checking for enabled nodes...");
        ActivityNodeActivationList enabledActivations = new ActivityNodeActivationList();
        for (int i = 0; i < activations.size(); ++i) {
            ActivityNodeActivation activation = activations.getValue(i);
            Debug.println("[run] Checking node " + activation.node.name + "...");
            if (!(activation instanceof ActionActivation | activation instanceof ControlNodeActivation | activation instanceof ActivityParameterNodeActivation)) continue;
            boolean isEnabled = this.checkIncomingEdges(activation.incomingEdges, activations);
            if (isEnabled & activation instanceof ActionActivation) {
                InputPinList inputPins = ((Action)activation.node).input;
                int j = 1;
                while (j <= inputPins.size() & isEnabled) {
                    InputPin inputPin = inputPins.getValue(j - 1);
                    ActivityEdgeInstanceList inputEdges = ((ActionActivation)activation).getPinActivation((Pin)inputPin).incomingEdges;
                    isEnabled = this.checkIncomingEdges(inputEdges, activations);
                    ++j;
                }
            }
            if (!isEnabled) continue;
            Debug.println("[run] Node " + activation.node.name + " is enabled.");
            enabledActivations.addValue(activation);
        }
        for (ActivityNodeActivation activation : enabledActivations) {
            Debug.println("[run] Sending offer to node " + activation.node.name + ".");
            activation.receiveOffer();
        }
    }

    public boolean checkIncomingEdges(ActivityEdgeInstanceList incomingEdges, ActivityNodeActivationList activations) {
        int j = 1;
        boolean notFound = true;
        while (j <= incomingEdges.size() & notFound) {
            int k = 1;
            while (k <= activations.size() & notFound) {
                if (activations.getValue(k - 1).isSourceFor(incomingEdges.getValue(j - 1))) {
                    notFound = false;
                }
                ++k;
            }
            ++j;
        }
        return notFound;
    }

    public void runNodes(ActivityNodeList nodes) {
        ActivityNodeActivationList nodeActivations = new ActivityNodeActivationList();
        for (int i = 0; i < nodes.size(); ++i) {
            ActivityNode node = nodes.getValue(i);
            ActivityNodeActivation nodeActivation = this.getNodeActivation(node);
            if (nodeActivation == null) continue;
            nodeActivations.addValue(nodeActivation);
        }
        this.run(nodeActivations);
    }

    public void activate(ActivityNodeList nodes, ActivityEdgeList edges) {
        this.createNodeActivations(nodes);
        this.createEdgeInstances(edges);
        this.run(this.nodeActivations);
    }

    public void terminateAll() {
        Debug.println("[terminateAll] Terminating activation group for " + (this.activityExecution != null ? "activity " + this.activityExecution.getTypes().getValue((int)0).name : (this.containingNodeActivation != null ? "node " + this.containingNodeActivation.node.name : "expansion region")) + ".");
        ActivityNodeActivationList nodeActivations = this.nodeActivations;
        for (int i = 0; i < nodeActivations.size(); ++i) {
            ActivityNodeActivation nodeActivation = nodeActivations.getValue(i);
            nodeActivation.terminate();
        }
        this.suspendedActivations.clear();
    }

    public void createNodeActivations(ActivityNodeList nodes) {
        for (int i = 0; i < nodes.size(); ++i) {
            ActivityNode node = nodes.getValue(i);
            Debug.println("[createNodeActivations] Creating a node activation for " + node.name + "...");
            this.createNodeActivation(node);
        }
    }

    public ActivityNodeActivation createNodeActivation(ActivityNode node) {
        ActivityNodeActivation activation = (ActivityNodeActivation)this.getActivityExecution().locus.factory.instantiateVisitor(node);
        activation.initialize(node, this);
        this.nodeActivations.addValue(activation);
        activation.createNodeActivations();
        return activation;
    }

    public ActivityNodeActivation getNodeActivation(ActivityNode node) {
        ActivityNodeActivation activation = null;
        if (this.containingNodeActivation != null && node instanceof Pin) {
            activation = this.containingNodeActivation.getPinActivation((Pin)node);
        }
        if (activation == null) {
            int i = 1;
            while (activation == null & i <= this.nodeActivations.size()) {
                activation = this.nodeActivations.getValue(i - 1).getNodeActivation(node);
                ++i;
            }
        }
        return activation;
    }

    public void createEdgeInstances(ActivityEdgeList edges) {
        for (int i = 0; i < edges.size(); ++i) {
            ActivityEdge edge = edges.getValue(i);
            Debug.println("[createEdgeInstances] Creating an edge instance from " + edge.source.name + " to " + edge.target.name + ".");
            ActivityEdgeInstance edgeInstance = new ActivityEdgeInstance();
            edgeInstance.edge = edge;
            edgeInstance.group = this;
            this.edgeInstances.addValue(edgeInstance);
            this.getNodeActivation(edge.source).addOutgoingEdge(edgeInstance);
            this.getNodeActivation(edge.target).addIncomingEdge(edgeInstance);
        }
        ActivityNodeActivationList nodeActivations = this.nodeActivations;
        for (int i = 0; i < nodeActivations.size(); ++i) {
            ActivityNodeActivation nodeActivation = nodeActivations.getValue(i);
            nodeActivation.createEdgeInstances();
        }
    }

    public ActivityExecution getActivityExecution() {
        ActivityExecution activityExecution = this.activityExecution;
        if (activityExecution == null) {
            activityExecution = this.containingNodeActivation.group.getActivityExecution();
        }
        return activityExecution;
    }

    public ActivityParameterNodeActivationList getOutputParameterNodeActivations() {
        ActivityParameterNodeActivationList parameterNodeActivations = new ActivityParameterNodeActivationList();
        ActivityNodeActivationList nodeActivations = this.nodeActivations;
        for (int i = 0; i < nodeActivations.size(); ++i) {
            ActivityNodeActivation activation = nodeActivations.getValue(i);
            if (!(activation instanceof ActivityParameterNodeActivation) || activation.incomingEdges.size() <= 0) continue;
            parameterNodeActivations.addValue((ActivityParameterNodeActivation)activation);
        }
        return parameterNodeActivations;
    }

    public boolean hasSourceFor(ActivityEdgeInstance edgeInstance) {
        boolean hasSource = false;
        ActivityNodeActivationList activations = this.nodeActivations;
        int i = 1;
        while (!hasSource & i <= activations.size()) {
            hasSource = activations.getValue(i - 1).isSourceFor(edgeInstance);
            ++i;
        }
        return hasSource;
    }

    public boolean isSuspended() {
        return this.suspendedActivations.size() > 0;
    }

    public void suspend(ActivityNodeActivation activation) {
        StructuredActivityNodeActivation containingNodeActivation;
        Debug.println("[suspend] node=" + (activation.node == null ? "null" : activation.node.name));
        if (!this.isSuspended() && (containingNodeActivation = this.containingNodeActivation) != null) {
            containingNodeActivation.suspend();
        }
        this.suspendedActivations.addValue(activation);
    }

    public void resume(ActivityNodeActivation activation) {
        StructuredActivityNodeActivation containingNodeActivation;
        Debug.println("[resume] node=" + (activation.node == null ? "null" : activation.node.name));
        boolean found = false;
        int i = 1;
        while (!found & i <= this.suspendedActivations.size()) {
            if (this.suspendedActivations.get(i - 1) == activation) {
                this.suspendedActivations.removeValue(i - 1);
                found = true;
            }
            ++i;
        }
        if (!this.isSuspended() && (containingNodeActivation = this.containingNodeActivation) != null) {
            containingNodeActivation.resume();
        }
    }
}

