/*
 * Decompiled with CFR 0.152.
 */
package fUML.Test;

import UMLPrimitiveTypes.UnlimitedNatural;
import fUML.Debug;
import fUML.Library.ChannelImplementation.StandardOutputChannelObject;
import fUML.Library.IntegerFunctions;
import fUML.Library.PipeImplementation.PipeInputChannelObject;
import fUML.Library.PipeImplementation.PipeOutputChannelObject;
import fUML.Library.PrimitiveTypes;
import fUML.Library.StandardIOClasses;
import fUML.Library.SystemIO;
import fUML.Semantics.Classes.Kernel.BooleanValue;
import fUML.Semantics.Classes.Kernel.DataValue;
import fUML.Semantics.Classes.Kernel.EnumerationValue;
import fUML.Semantics.Classes.Kernel.ExtensionalValueList;
import fUML.Semantics.Classes.Kernel.FeatureValueList;
import fUML.Semantics.Classes.Kernel.IntegerValue;
import fUML.Semantics.Classes.Kernel.PrimitiveValue;
import fUML.Semantics.Classes.Kernel.RedefinitionBasedDispatchStrategy;
import fUML.Semantics.Classes.Kernel.Reference;
import fUML.Semantics.Classes.Kernel.StringValue;
import fUML.Semantics.Classes.Kernel.StructuredValue;
import fUML.Semantics.Classes.Kernel.UnlimitedNaturalValue;
import fUML.Semantics.Classes.Kernel.Value;
import fUML.Semantics.Classes.Kernel.ValueList;
import fUML.Semantics.CommonBehaviors.Communications.FIFOGetNextEventStrategy;
import fUML.Semantics.CommonBehaviors.Communications.SignalInstance;
import fUML.Semantics.Loci.LociL1.Executor;
import fUML.Semantics.Loci.LociL1.FirstChoiceStrategy;
import fUML.Semantics.Loci.LociL1.Locus;
import fUML.Semantics.Loci.LociL3.ExecutionFactoryL3;
import fUML.Syntax.Classes.Kernel.Class_;
import fUML.Syntax.Classes.Kernel.Classifier;
import fUML.Syntax.Classes.Kernel.DataType;
import fUML.Syntax.Classes.Kernel.Enumeration;
import fUML.Syntax.Classes.Kernel.NamedElement;
import fUML.Syntax.Classes.Kernel.NamedElementList;
import fUML.Syntax.Classes.Kernel.PrimitiveType;
import fUML.Syntax.Classes.Kernel.StructuralFeature;
import fUML.Syntax.CommonBehaviors.Communications.Signal;
import fUML.Test.Variable;
import fUML.Test.VariableList;
import org.modeldriven.fuml.FumlObject;

public class TestEnvironment
extends FumlObject {
    public VariableList variables;
    public PrimitiveTypes primitiveTypes;
    public NamedElementList elements;
    public Locus locus;
    public IntegerFunctions integerFunctions;
    public SystemIO systemIO;
    public StandardIOClasses standardIO;

    public TestEnvironment() {
        block2: {
            this.variables = new VariableList();
            this.primitiveTypes = null;
            this.elements = new NamedElementList();
            this.locus = null;
            this.integerFunctions = null;
            this.systemIO = null;
            this.standardIO = null;
            try {
                this.locus = new Locus();
                this.locus.setFactory(new ExecutionFactoryL3());
                this.locus.setExecutor(new Executor());
                this.locus.factory.setStrategy(new RedefinitionBasedDispatchStrategy());
                this.locus.factory.setStrategy(new FIFOGetNextEventStrategy());
                this.locus.factory.setStrategy(new FirstChoiceStrategy());
                this.primitiveTypes = new PrimitiveTypes(this.locus.factory);
                this.addElement(this.primitiveTypes.Boolean);
                this.addElement(this.primitiveTypes.Integer);
                this.addElement(this.primitiveTypes.String);
                this.addElement(this.primitiveTypes.UnlimitedNatural);
                this.integerFunctions = new IntegerFunctions(this.primitiveTypes.Integer, this.primitiveTypes.Boolean, this.locus.factory);
                this.addElement(this.integerFunctions.integerPlus);
                this.addElement(this.integerFunctions.integerMinus);
                this.addElement(this.integerFunctions.integerTimes);
                this.addElement(this.integerFunctions.integerDivide);
                this.addElement(this.integerFunctions.integerNegate);
                this.addElement(this.integerFunctions.integerGreater);
                this.systemIO = new SystemIO(this.locus.factory);
                this.addElement(this.systemIO.WriteLine);
                this.standardIO = new StandardIOClasses(this.primitiveTypes);
                this.addElement(this.standardIO.Channel);
                this.addElement(this.standardIO.OutputChannel);
                this.addElement(this.standardIO.TextOutputChannel);
                this.addElement(this.standardIO.StandardOutputChannel);
                StandardOutputChannelObject standardOutputChannel = new StandardOutputChannelObject();
                standardOutputChannel.types.addValue(this.standardIO.StandardOutputChannel);
                standardOutputChannel.open();
                this.locus.add(standardOutputChannel);
                PipeInputChannelObject pipeInputChannel = new PipeInputChannelObject("PipedInput");
                pipeInputChannel.types.addValue(this.standardIO.InputChannel);
                pipeInputChannel.open();
                this.locus.add(pipeInputChannel);
                PipeOutputChannelObject pipeOutputChannel = new PipeOutputChannelObject("PipedOutput", pipeInputChannel);
                pipeOutputChannel.types.addValue(this.standardIO.OutputChannel);
                pipeOutputChannel.open();
                this.locus.add(pipeOutputChannel);
            }
            catch (Throwable e) {
                Debug.println("[TestEnvironment] Terminated due to " + e.getClass().getName() + "...");
                StackTraceElement[] stackTrace = e.getStackTrace();
                if (stackTrace.length <= 0) break block2;
                Debug.println(stackTrace[0] + ".");
            }
        }
    }

    public PrimitiveValue makePrimitiveValue(Classifier classifier) {
        PrimitiveType type = (PrimitiveType)classifier;
        PrimitiveValue primitiveValue = null;
        if (type == this.primitiveTypes.Boolean) {
            primitiveValue = new BooleanValue();
        } else if (type == this.primitiveTypes.Integer) {
            primitiveValue = new IntegerValue();
        } else if (type == this.primitiveTypes.String) {
            primitiveValue = new StringValue();
        } else if (type == this.primitiveTypes.UnlimitedNatural) {
            primitiveValue = new UnlimitedNaturalValue();
            ((UnlimitedNaturalValue)primitiveValue).value = new UnlimitedNatural();
        }
        if (primitiveValue != null) {
            primitiveValue.type = type;
        } else {
            Debug.println("[makePrimitiveValue] " + type.name + " not understood.");
        }
        return primitiveValue;
    }

    public EnumerationValue makeEnumerationValue(Classifier classifier) {
        Enumeration type = (Enumeration)classifier;
        EnumerationValue enumerationValue = new EnumerationValue();
        enumerationValue.type = type;
        enumerationValue.literal = type.ownedLiteral.getValue(0);
        return enumerationValue;
    }

    public StructuredValue makeStructuredValue(Classifier classifier) {
        StructuredValue structuredValue = null;
        Object attributes = null;
        if (classifier instanceof DataType) {
            structuredValue = new DataValue();
            ((DataValue)structuredValue).type = (DataType)classifier;
            structuredValue.createFeatureValues();
        } else if (classifier instanceof Class_) {
            structuredValue = new Reference();
            ((Reference)structuredValue).referent = this.locus.instantiate((Class_)classifier);
        } else if (classifier instanceof Signal) {
            structuredValue = new SignalInstance();
            ((SignalInstance)structuredValue).type = (Signal)classifier;
            structuredValue.createFeatureValues();
        }
        FeatureValueList featureValues = structuredValue.getFeatureValues();
        int i = 0;
        while (i < featureValues.size()) {
            StructuralFeature feature = featureValues.getValue((int)i).feature;
            ValueList valueList = new ValueList();
            valueList.addValue(this.makeValue((Classifier)feature.typedElement.type));
            structuredValue.setFeatureValue(feature, valueList, 0);
            ++i;
        }
        return structuredValue;
    }

    public Value makeValue(Classifier type) {
        if (type == null) {
            return this.makePrimitiveValue(this.primitiveTypes.String);
        }
        if (type instanceof PrimitiveType) {
            return this.makePrimitiveValue(type);
        }
        if (type instanceof Enumeration) {
            return this.makeEnumerationValue(type);
        }
        return this.makeStructuredValue(type);
    }

    public void addElement(NamedElement element) {
        if (this.getElement(element.name) == null) {
            this.elements.addValue(element);
        } else {
            Debug.println("[addElement] There is already an element named " + element.name + ".");
        }
    }

    public NamedElement getElement(String name) {
        int i = 0;
        while (i < this.elements.size()) {
            if (this.elements.getValue((int)i).name.equals(name)) {
                return this.elements.getValue(i);
            }
            ++i;
        }
        return null;
    }

    public void removeElement(NamedElement element) {
        int i = 0;
        while (i < this.elements.size()) {
            if (this.elements.getValue(i) == element) {
                this.elements.remove(i);
                return;
            }
            ++i;
        }
    }

    public void setVariable(String name, Value value) {
        Variable variable = this.getVariable(name);
        if (variable == null) {
            variable = new Variable();
            variable.name = name;
            this.variables.addValue(variable);
        }
        variable.value = value;
    }

    public Variable getVariable(String name) {
        int i = 0;
        while (i < this.variables.size()) {
            if (this.variables.getValue((int)i).name.equals(name)) {
                return this.variables.getValue(i);
            }
            ++i;
        }
        return null;
    }

    public Classifier getType(String typeName) {
        NamedElement element = this.getElement(typeName);
        if (element == null || !(element instanceof Classifier)) {
            return null;
        }
        return (Classifier)element;
    }

    public void printElements() {
        Debug.println("");
        Debug.println(String.valueOf(this.elements.size()) + " element(s)");
        Debug.println("---------");
        int i = 0;
        while (i < this.elements.size()) {
            Debug.println(String.valueOf(this.elements.getValue((int)i).name) + ": " + this.elements.getValue(i).getClass().getName());
            ++i;
        }
    }

    public void printExtent(String classifierName) {
        NamedElement element = this.getElement(classifierName);
        if (element == null) {
            Debug.println("[printExtent] " + classifierName + " not found.");
            return;
        }
        if (!(element instanceof Classifier)) {
            Debug.println("[printExtent] " + classifierName + " is not a classifier.");
            return;
        }
        ExtensionalValueList extent = this.locus.getExtent((Classifier)element);
        Debug.println("");
        Debug.println(String.valueOf(classifierName) + " has " + extent.size() + " instance(s):");
        int i = 0;
        while (i < extent.size()) {
            Debug.println("[" + i + "] " + extent.getValue(i));
            ++i;
        }
    }

    public void removeElement(String elementName) {
        NamedElement element = this.getElement(elementName);
        if (element != null) {
            this.removeElement(element);
        } else {
            Debug.println("[removeElement] " + elementName + " does not exist.");
        }
    }
}

