/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Activities.ExtraStructuredActivities;

import fUML.Debug;
import fUML.Semantics.Actions.BasicActions.ActionActivation;
import fUML.Semantics.Actions.BasicActions.OutputPinActivation;
import fUML.Semantics.Actions.BasicActions.OutputPinActivationList;
import fUML.Semantics.Activities.ExtraStructuredActivities.ExpansionActivationGroup;
import fUML.Semantics.Activities.ExtraStructuredActivities.ExpansionActivationGroupList;
import fUML.Semantics.Activities.ExtraStructuredActivities.ExpansionNodeActivation;
import fUML.Semantics.Activities.ExtraStructuredActivities.TokenSet;
import fUML.Semantics.Activities.ExtraStructuredActivities.TokenSetList;
import fUML.Semantics.Activities.IntermediateActivities.ActivityNodeActivationGroup;
import fUML.Semantics.Activities.IntermediateActivities.TokenList;
import fUML.Syntax.Actions.BasicActions.InputPin;
import fUML.Syntax.Actions.BasicActions.InputPinList;
import fUML.Syntax.Activities.CompleteStructuredActivities.StructuredActivityNode;
import fUML.Syntax.Activities.ExtraStructuredActivities.ExpansionKind;
import fUML.Syntax.Activities.ExtraStructuredActivities.ExpansionNode;
import fUML.Syntax.Activities.ExtraStructuredActivities.ExpansionNodeList;
import fUML.Syntax.Activities.ExtraStructuredActivities.ExpansionRegion;

public class ExpansionRegionActivation
extends ActionActivation {
    public ExpansionActivationGroupList activationGroups = new ExpansionActivationGroupList();
    public TokenSetList inputTokens = new TokenSetList();
    public TokenSetList inputExpansionTokens = new TokenSetList();
    public int next = 0;

    @Override
    public TokenList takeOfferedTokens() {
        super.takeOfferedTokens();
        ExpansionRegion region = (ExpansionRegion)this.node;
        InputPinList inputPins = region.input;
        ExpansionNodeList inputElements = region.inputElement;
        this.inputTokens.clear();
        this.inputExpansionTokens.clear();
        int i = 0;
        while (i < inputPins.size()) {
            InputPin inputPin = inputPins.getValue(i);
            TokenSet tokenSet = new TokenSet();
            tokenSet.tokens = this.getPinActivation(inputPin).takeTokens();
            this.inputTokens.addValue(tokenSet);
            ++i;
        }
        int n = this.numberOfValues();
        int i2 = 0;
        while (i2 < inputElements.size()) {
            ExpansionNode inputElement = inputElements.getValue(i2);
            ExpansionNodeActivation expansionNodeActivation = this.getExpansionNodeActivation(inputElement);
            expansionNodeActivation.fire(expansionNodeActivation.takeOfferedTokens());
            TokenList tokens = expansionNodeActivation.takeTokens();
            TokenSet tokenSet = new TokenSet();
            int j = 1;
            while (j <= n) {
                tokenSet.tokens.add(tokens.getValue(j - 1));
                ++j;
            }
            this.inputExpansionTokens.addValue(tokenSet);
            ++i2;
        }
        return new TokenList();
    }

    @Override
    public void doAction() {
        if (((StructuredActivityNode)this.node).mustIsolate) {
            ExpansionRegionActivation._beginIsolation();
            this.doStructuredActivity();
            ExpansionRegionActivation._endIsolation();
        } else {
            this.doStructuredActivity();
        }
    }

    public void doStructuredActivity() {
        ExpansionRegion region = (ExpansionRegion)this.node;
        InputPinList inputPins = region.input;
        ExpansionNodeList inputElements = region.inputElement;
        ExpansionNodeList outputElements = region.outputElement;
        this.activationGroups.clear();
        int n = this.inputExpansionTokens.getValue((int)0).tokens.size();
        int k = 1;
        while (k <= n) {
            ExpansionActivationGroup activationGroup = new ExpansionActivationGroup();
            activationGroup.regionActivation = this;
            activationGroup.index = k;
            int j = 1;
            while (j <= inputPins.size()) {
                OutputPinActivation regionInput = new OutputPinActivation();
                regionInput.run();
                activationGroup.regionInputs.addValue(regionInput);
                ++j;
            }
            j = 1;
            while (j <= inputElements.size()) {
                OutputPinActivation groupInput = new OutputPinActivation();
                groupInput.run();
                activationGroup.groupInputs.addValue(groupInput);
                ++j;
            }
            j = 1;
            while (j <= outputElements.size()) {
                OutputPinActivation groupOutput = new OutputPinActivation();
                groupOutput.run();
                activationGroup.groupOutputs.addValue(groupOutput);
                ++j;
            }
            activationGroup.createNodeActivations(region.node);
            activationGroup.createEdgeInstances(region.edge);
            this.activationGroups.addValue(activationGroup);
            ++k;
        }
        if (region.mode == ExpansionKind.iterative) {
            Debug.println("[doStructuredActivity] Expansion mode = iterative");
            this.next = 1;
            this.runIterative();
        } else if (region.mode == ExpansionKind.parallel) {
            Debug.println("[doStructuredActivity] Expansion mode = parallel");
            this.runParallel();
        }
        this.doOutput();
    }

    public void runIterative() {
        ExpansionActivationGroupList activationGroups = this.activationGroups;
        while (this.next <= activationGroups.size() & !this.isSuspended()) {
            ExpansionActivationGroup activationGroup = activationGroups.getValue(this.next - 1);
            this.runGroup(activationGroup);
            ++this.next;
        }
    }

    public void runParallel() {
        ExpansionActivationGroupList activationGroups = this.activationGroups;
        for (ExpansionActivationGroup activationGroup : activationGroups) {
            this.runGroup(activationGroup);
        }
    }

    public void doOutput() {
        ExpansionRegion region = (ExpansionRegion)this.node;
        ExpansionNodeList outputElements = region.outputElement;
        Debug.println("[doOutput] Expansion region " + region.name + " is " + (this.isSuspended() ? "suspended." : "completed."));
        if (!this.isSuspended()) {
            int i = 0;
            while (i < this.activationGroups.size()) {
                ExpansionActivationGroup activationGroup = this.activationGroups.getValue(i);
                OutputPinActivationList groupOutputs = activationGroup.groupOutputs;
                int j = 0;
                while (j < groupOutputs.size()) {
                    OutputPinActivation groupOutput = groupOutputs.getValue(j);
                    ExpansionNode outputElement = outputElements.getValue(j);
                    this.getExpansionNodeActivation(outputElement).addTokens(groupOutput.takeTokens());
                    ++j;
                }
                ++i;
            }
        }
    }

    @Override
    public void terminate() {
        ExpansionActivationGroupList activationGroups = this.activationGroups;
        int i = 0;
        while (i < activationGroups.size()) {
            ExpansionActivationGroup activationGroup = this.activationGroups.getValue(i);
            OutputPinActivationList groupOutputs = activationGroup.groupOutputs;
            ExpansionRegionActivation._beginIsolation();
            int j = 0;
            while (j < groupOutputs.size()) {
                OutputPinActivation groupOutput = groupOutputs.getValue(j);
                groupOutput.fire(groupOutput.takeOfferedTokens());
                ++j;
            }
            activationGroup.terminateAll();
            ExpansionRegionActivation._endIsolation();
            ++i;
        }
        super.terminate();
    }

    @Override
    public void sendOffers() {
        ExpansionRegion region = (ExpansionRegion)this.node;
        ExpansionNodeList outputElements = region.outputElement;
        for (ExpansionNode outputElement : outputElements) {
            this.getExpansionNodeActivation(outputElement).sendUnofferedTokens();
        }
        super.sendOffers();
    }

    public void runGroup(ExpansionActivationGroup activationGroup) {
        if (this.isRunning()) {
            Debug.println("[runGroup] groupInput[0] = " + this.inputExpansionTokens.getValue((int)0).tokens.getValue(activationGroup.index - 1).getValue());
            TokenSetList inputTokens = this.inputTokens;
            int j = 0;
            while (j < inputTokens.size()) {
                TokenSet tokenSet = inputTokens.getValue(j);
                OutputPinActivation regionInput = activationGroup.regionInputs.getValue(j);
                regionInput.clearTokens();
                regionInput.addTokens(tokenSet.tokens);
                regionInput.sendUnofferedTokens();
                ++j;
            }
            TokenSetList inputExpansionTokens = this.inputExpansionTokens;
            int j2 = 0;
            while (j2 < inputExpansionTokens.size()) {
                TokenSet tokenSet = inputExpansionTokens.getValue(j2);
                OutputPinActivation groupInput = activationGroup.groupInputs.getValue(j2);
                groupInput.clearTokens();
                if (tokenSet.tokens.size() >= activationGroup.index) {
                    groupInput.addToken(tokenSet.tokens.getValue(activationGroup.index - 1));
                }
                groupInput.sendUnofferedTokens();
                ++j2;
            }
            activationGroup.run(activationGroup.nodeActivations);
            this.terminateGroup(activationGroup);
        }
    }

    public void terminateGroup(ExpansionActivationGroup activationGroup) {
        if (this.isRunning() & !this.isSuspended()) {
            OutputPinActivationList groupOutputs = activationGroup.groupOutputs;
            int i = 0;
            while (i < groupOutputs.size()) {
                OutputPinActivation groupOutput = groupOutputs.getValue(i);
                groupOutput.fire(groupOutput.takeOfferedTokens());
                ++i;
            }
            activationGroup.terminateAll();
        }
    }

    public ExpansionNodeActivation getExpansionNodeActivation(ExpansionNode node) {
        return (ExpansionNodeActivation)this.group.getNodeActivation(node);
    }

    public int numberOfValues() {
        ExpansionRegion region = (ExpansionRegion)this.node;
        ExpansionNodeList inputElements = region.inputElement;
        int n = this.getExpansionNodeActivation(inputElements.getValue(0)).countOfferedValues();
        int i = 2;
        while (i <= inputElements.size()) {
            int count = this.getExpansionNodeActivation(inputElements.getValue(i - 1)).countOfferedValues();
            if (count < n) {
                n = count;
            }
            ++i;
        }
        return n;
    }

    public boolean isSuspended() {
        boolean suspended = false;
        int i = 1;
        while (i <= this.activationGroups.size() & !suspended) {
            ActivityNodeActivationGroup group = (ActivityNodeActivationGroup)this.activationGroups.get(i - 1);
            suspended = group.isSuspended();
            ++i;
        }
        return suspended;
    }

    public void resume(ExpansionActivationGroup activationGroup) {
        ExpansionRegion region = (ExpansionRegion)this.node;
        this.resume();
        this.terminateGroup(activationGroup);
        if (region.mode == ExpansionKind.iterative) {
            this.runIterative();
        }
        this.doOutput();
    }
}

