/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.xmi.validation;

import java.text.MessageFormat;
import java.util.Locale;
import org.modeldriven.fuml.xmi.XmiNode;
import org.modeldriven.fuml.xmi.XmiReference;
import org.modeldriven.fuml.xmi.validation.ErrorCategory;
import org.modeldriven.fuml.xmi.validation.ErrorCode;
import org.modeldriven.fuml.xmi.validation.ErrorSeverity;
import org.modeldriven.fuml.xmi.validation.ValidationProperties;

public class ValidationError {
    private static final String DELIM = ".";
    private static final String LOCATION = "LOCATION";
    private ErrorSeverity severity;
    private ErrorCode code;
    private XmiNode node;
    private XmiReference reference;
    private String id;
    private String propertyName = "unknown";

    public ValidationError(XmiNode node, ErrorCode code, ErrorSeverity severity) {
        this.node = node;
        this.code = code;
        this.severity = severity;
    }

    public ValidationError(XmiNode node, String propertyName, ErrorCode code, ErrorSeverity severity) {
        this.node = node;
        this.propertyName = propertyName;
        this.code = code;
        this.severity = severity;
    }

    public ValidationError(XmiReference reference, String id, ErrorCode code, ErrorSeverity severity) {
        this.reference = reference;
        this.id = id;
        this.code = code;
        this.severity = severity;
    }

    public ErrorSeverity getSeverity() {
        return this.severity;
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public String getCodeText() {
        String value = this.code.value();
        String text = ValidationProperties.instance().getProperty(value, value);
        return text;
    }

    public String getLocationText() {
        String text = ValidationProperties.instance().getProperty(String.valueOf(this.getClass().getSimpleName()) + DELIM + LOCATION);
        if (this.node != null) {
            Object[] params = new Object[]{this.node.getLineNumber(), this.node.getColumnNumber()};
            return this.substituteParams(text, params);
        }
        Object[] params = new Object[]{this.reference.getLineNumber(), this.reference.getColumnNumber()};
        return this.substituteParams(text, params);
    }

    public ErrorCategory getCategory() {
        return this.code.getCategory();
    }

    public String getCategoryText() {
        String value = this.getCategory().value();
        String text = ValidationProperties.instance().getProperty(value, value);
        return text;
    }

    public String getText() {
        String value = this.code.value();
        String text = ValidationProperties.instance().getProperty(String.valueOf(ErrorCode.class.getSimpleName()) + DELIM + value, value);
        if (this.code.ordinal() == ErrorCode.UNDEFINED_CLASS.ordinal() || this.code.ordinal() == ErrorCode.ABSTRACT_CLASS_INSTANTIATION.ordinal()) {
            Object[] params = new Object[]{this.getLocationText(), this.node.getLocalName()};
            text = this.substituteParams(text, params);
        } else if (this.code.ordinal() == ErrorCode.UNDEFINED_PROPERTY.ordinal() || this.code.ordinal() == ErrorCode.PROPERTY_REQUIRED.ordinal() || this.code.ordinal() == ErrorCode.DERIVED_PROPERTY_INSTANTIATION.ordinal()) {
            Object[] params = new Object[]{this.getLocationText(), this.node.getLocalName(), this.propertyName};
            text = this.substituteParams(text, params);
        } else if (this.code.ordinal() == ErrorCode.DUPLICATE_REFERENCE.ordinal()) {
            Object[] params = new Object[]{this.getLocationText(), this.node.getLocalName(), this.node.getXmiId()};
            text = this.substituteParams(text, params);
        } else if (this.code.ordinal() == ErrorCode.INVALID_REFERENCE.ordinal() || this.code.ordinal() == ErrorCode.INVALID_EXTERNAL_REFERENCE.ordinal()) {
            if (this.reference != null) {
                Object[] params = new Object[]{this.getLocationText(), this.reference.getLocalName(), this.id};
                text = this.substituteParams(text, params);
            }
        } else {
            Object[] params = new Object[]{this.getLocationText(), this.node.getLocalName()};
            text = this.substituteParams(text, params);
        }
        return text;
    }

    private String substituteParams(String msgtext, Object[] params) {
        return this.substituteParams(null, msgtext, params);
    }

    private String substituteParams(Locale locale, String msgtext, Object[] params) {
        String localizedStr = null;
        if (params == null || msgtext == null) {
            return msgtext;
        }
        MessageFormat mf = new MessageFormat(msgtext);
        if (locale != null) {
            mf.setLocale(locale);
            localizedStr = mf.format(params);
        } else {
            localizedStr = mf.format(params);
        }
        return localizedStr;
    }

    public String toString() {
        return this.getText();
    }
}

