/*
 * Decompiled with CFR 0.152.
 */
package fUML.Test;

import fUML.Debug;
import fUML.Syntax.Classes.Kernel.AggregationKind;
import fUML.Syntax.Classes.Kernel.Association;
import fUML.Syntax.Classes.Kernel.Class_;
import fUML.Syntax.Classes.Kernel.Classifier;
import fUML.Syntax.Classes.Kernel.DataType;
import fUML.Syntax.Classes.Kernel.Enumeration;
import fUML.Syntax.Classes.Kernel.EnumerationLiteral;
import fUML.Syntax.Classes.Kernel.Generalization;
import fUML.Syntax.Classes.Kernel.NamedElement;
import fUML.Syntax.Classes.Kernel.Operation;
import fUML.Syntax.Classes.Kernel.Property;
import fUML.Syntax.CommonBehaviors.BasicBehaviors.Behavior;
import fUML.Syntax.CommonBehaviors.Communications.Signal;
import fUML.Test.Test;
import fUML.Test.TestEnvironment;

public class ClassifierFactory
extends Test {
    public ClassifierFactory(TestEnvironment environment) {
        this.environment = environment;
    }

    public void createEnumerationType(String typeName, int numberOfLiterals) {
        Enumeration type = new Enumeration();
        type.setName(typeName);
        int i = 0;
        while (i < numberOfLiterals) {
            EnumerationLiteral literal = new EnumerationLiteral();
            literal.setName(String.valueOf(typeName) + "_" + String.valueOf(i));
            type.addOwnedLiteral(literal);
            ++i;
        }
        this.environment.addElement(type);
    }

    public void createDataType(String name) {
        DataType dataType = new DataType();
        dataType.setName(name);
        this.environment.addElement(dataType);
    }

    public void createClass(String name) {
        Class_ class_ = new Class_();
        class_.setName(name);
        this.environment.addElement(class_);
    }

    public void createSignal(String name) {
        Signal signal = new Signal();
        signal.setName(name);
        this.environment.addElement(signal);
    }

    public void createAssociation(String name) {
        Association association = new Association();
        association.setName(name);
        this.environment.addElement(association);
    }

    public void addAttribute(String classifierName, String attributeName, String attributeTypeName, boolean isComposite) {
        Classifier type = this.environment.getType(classifierName);
        if (type == null) {
            Debug.println("[addAttribute] " + classifierName + " not found or not a classifier.");
            return;
        }
        Classifier attributeType = this.environment.getType(attributeTypeName);
        if (attributeType == null) {
            Debug.println("[addAttribute] " + attributeTypeName + " not found or not a classifier.");
            return;
        }
        Property attribute = new Property();
        attribute.setName(attributeName);
        attribute.setType(attributeType);
        attribute.setIsOrdered(false);
        attribute.setIsUnique(true);
        attribute.setLower(1);
        attribute.setUpper(1);
        if (isComposite) {
            attribute.setAggregation(AggregationKind.composite);
        } else {
            attribute.setAggregation(AggregationKind.none);
        }
        if (type instanceof DataType) {
            ((DataType)type).addOwnedAttribute(attribute);
        } else if (type instanceof Class_) {
            ((Class_)type).addOwnedAttribute(attribute);
        } else if (type instanceof Signal) {
            ((Signal)type).addOwnedAttribute(attribute);
        }
    }

    public void addEnd(String associationName, String endName, String endTypeName, boolean isComposite) {
        Classifier type = this.environment.getType(associationName);
        if (type == null || !(type instanceof Association)) {
            Debug.println("[addEnd] " + associationName + " not found or not an association.");
            return;
        }
        Association association = (Association)type;
        Classifier endType = this.environment.getType(endTypeName);
        if (endType == null) {
            Debug.println("[addEnd] " + endTypeName + " not found or not a classifier.");
            return;
        }
        Property end = new Property();
        end.setName(endName);
        end.setType(endType);
        end.setIsOrdered(false);
        end.setIsUnique(true);
        end.setLower(1);
        end.setUpper(1);
        if (isComposite) {
            end.setAggregation(AggregationKind.composite);
        } else {
            end.setAggregation(AggregationKind.none);
        }
        association.addOwnedEnd(end);
    }

    public void addClassifierBehavior(String className, String behaviorName) {
        NamedElement element = this.environment.getElement(className);
        if (element == null || !(element instanceof Class_)) {
            Debug.println("[addClassifierBehavior] " + className + " not found or not a class.");
            return;
        }
        Class_ classifier = (Class_)element;
        element = this.environment.getElement(behaviorName);
        if (element == null || !(element instanceof Behavior)) {
            Debug.println("[addClassifierBehavior] " + behaviorName + " not found or not a behavior.");
            return;
        }
        Behavior behavior = (Behavior)element;
        this.environment.removeElement(element);
        classifier.addOwnedBehavior(behavior);
        classifier.setClassifierBehavior(behavior);
    }

    public void addOperation(String className, String baseClassName, String operationName, String methodName) {
        NamedElement element = this.environment.getElement(className);
        if (element == null || !(element instanceof Class_)) {
            Debug.println("[addOperation] " + className + " not found or not a class.");
            return;
        }
        Class_ classifier = (Class_)element;
        Operation operation = new Operation();
        operation.setName(operationName);
        if (!baseClassName.equals("")) {
            element = this.environment.getElement(baseClassName);
            if (element == null || !(element instanceof Class_)) {
                Debug.println("[addOperation] " + baseClassName + " not found or not a class.");
                return;
            }
            Class_ baseClass = (Class_)element;
            Operation redefinedOperation = this.getOperation(baseClass, operationName);
            if (redefinedOperation == null) {
                Debug.println("[addOperation] " + operationName + " is not an operation of " + baseClassName + ".");
                return;
            }
            operation.addRedefinedOperation(redefinedOperation);
        }
        if (methodName.equals("")) {
            operation.setIsAbstract(true);
        } else {
            element = this.environment.getElement(methodName);
            if (element == null || !(element instanceof Behavior)) {
                Debug.println("[addOperation] " + methodName + " not found or not a behavior.");
                return;
            }
            Behavior behavior = (Behavior)element;
            this.environment.removeElement(element);
            classifier.addOwnedBehavior(behavior);
            operation.addMethod(behavior);
        }
        classifier.addOwnedOperation(operation);
    }

    public void addGeneralization(String subtypeName, String supertypeName) {
        Classifier subtype = this.environment.getType(subtypeName);
        if (subtype == null) {
            Debug.println("[addGeneralization] " + subtypeName + " not found or not a classifier.");
            return;
        }
        Classifier supertype = this.environment.getType(supertypeName);
        if (supertype == null) {
            Debug.println("[addGeneralization] " + supertypeName + " not found or not a classifier.");
            return;
        }
        Generalization generalization = new Generalization();
        generalization.setGeneral(supertype);
        subtype.addGeneralization(generalization);
    }

    protected Operation getOperation(Class_ class_, String operationName) {
        int i = 0;
        while (i < class_.member.size()) {
            NamedElement member = class_.member.getValue(i);
            if (member.name.equals(operationName)) {
                if (!(member instanceof Operation)) {
                    return null;
                }
                return (Operation)member;
            }
            ++i;
        }
        return null;
    }
}

