/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Activities.IntermediateActivities;

import fUML.Debug;
import fUML.Semantics.Activities.IntermediateActivities.ActivityEdgeInstance;
import fUML.Semantics.Activities.IntermediateActivities.ActivityEdgeInstanceList;
import fUML.Semantics.Activities.IntermediateActivities.ActivityExecution;
import fUML.Semantics.Activities.IntermediateActivities.ActivityNodeActivationGroup;
import fUML.Semantics.Activities.IntermediateActivities.Token;
import fUML.Semantics.Activities.IntermediateActivities.TokenList;
import fUML.Semantics.Classes.Kernel.Object_;
import fUML.Semantics.Loci.LociL1.Locus;
import fUML.Semantics.Loci.LociL1.SemanticVisitor;
import fUML.Syntax.Activities.IntermediateActivities.ActivityNode;

public abstract class ActivityNodeActivation
extends SemanticVisitor {
    public ActivityNodeActivationGroup group = null;
    public ActivityNode node = null;
    public ActivityEdgeInstanceList incomingEdges = new ActivityEdgeInstanceList();
    public ActivityEdgeInstanceList outgoingEdges = new ActivityEdgeInstanceList();
    public boolean running = false;
    public TokenList heldTokens = new TokenList();

    public void initialize(ActivityNode node, ActivityNodeActivationGroup group) {
        this.node = node;
        this.group = group;
        this.running = false;
    }

    public void run() {
        if (this.node != null) {
            Debug.println("[run] node = " + this.node.name);
        } else {
            Debug.println("[run] Anonymous activation of type " + this.getClass().getName());
        }
        this.running = true;
    }

    public void receiveOffer() {
        Debug.println("[receiveOffer] " + (this.node == null ? "..." : "node = " + this.node.name));
        ActivityNodeActivation._beginIsolation();
        boolean ready = this.isReady();
        TokenList tokens = new TokenList();
        if (ready) {
            Debug.println("[receiveOffer] Firing.");
            tokens = this.takeOfferedTokens();
        }
        ActivityNodeActivation._endIsolation();
        if (ready) {
            this.fire(tokens);
        }
    }

    public TokenList takeOfferedTokens() {
        TokenList allTokens = new TokenList();
        ActivityEdgeInstanceList incomingEdges = this.incomingEdges;
        int i = 0;
        while (i < incomingEdges.size()) {
            ActivityEdgeInstance incomingEdge = incomingEdges.getValue(i);
            TokenList tokens = incomingEdge.takeOfferedTokens();
            int j = 0;
            while (j < tokens.size()) {
                Token token = tokens.getValue(j);
                allTokens.addValue(token);
                ++j;
            }
            ++i;
        }
        return allTokens;
    }

    public abstract void fire(TokenList var1);

    public void sendOffers(TokenList tokens) {
        if (tokens.size() > 0) {
            ActivityEdgeInstanceList outgoingEdges = this.outgoingEdges;
            for (ActivityEdgeInstance outgoingEdge : outgoingEdges) {
                outgoingEdge.sendOffer(tokens);
            }
        }
    }

    public void terminate() {
        if (this.running) {
            if (this.node != null) {
                Debug.println("[terminate] node = " + this.node.name);
            } else {
                Debug.println("[terminate] Anonymous activation of type " + this.getClass().getName());
            }
        }
        this.running = false;
    }

    public boolean isReady() {
        return this.isRunning();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void addOutgoingEdge(ActivityEdgeInstance edge) {
        edge.source = this;
        this.outgoingEdges.addValue(edge);
    }

    public void addIncomingEdge(ActivityEdgeInstance edge) {
        edge.target = this;
        this.incomingEdges.addValue(edge);
    }

    public void createNodeActivations() {
    }

    public void createEdgeInstances() {
    }

    public boolean isSourceFor(ActivityEdgeInstance edgeInstance) {
        return edgeInstance.source == this;
    }

    public ActivityExecution getActivityExecution() {
        return this.group.getActivityExecution();
    }

    public Object_ getExecutionContext() {
        return this.getActivityExecution().context;
    }

    public Locus getExecutionLocus() {
        return this.getActivityExecution().locus;
    }

    public ActivityNodeActivation getNodeActivation(ActivityNode node) {
        ActivityNodeActivation activation = null;
        if (node == this.node) {
            activation = this;
        }
        return activation;
    }

    public void addToken(Token token) {
        if (this.node == null) {
            Debug.println("[addToken] ...");
        } else {
            Debug.println("[addToken] node = " + this.node.name);
        }
        Token transferredToken = token.transfer(this);
        this.heldTokens.addValue(transferredToken);
    }

    public int removeToken(Token token) {
        boolean notFound = true;
        int i = 1;
        while (notFound & i <= this.heldTokens.size()) {
            if (this.heldTokens.getValue(i - 1) == token) {
                if (this.node == null) {
                    Debug.println("[removeToken] ...");
                } else {
                    Debug.println("[removeToken] node = " + this.node.name);
                }
                this.heldTokens.remove(i - 1);
                notFound = false;
            }
            ++i;
        }
        i = notFound ? 0 : --i;
        return i;
    }

    public void addTokens(TokenList tokens) {
        int i = 0;
        while (i < tokens.size()) {
            Token token = tokens.getValue(i);
            this.addToken(token);
            ++i;
        }
    }

    public TokenList takeTokens() {
        TokenList tokens = this.getTokens();
        this.clearTokens();
        return tokens;
    }

    public void clearTokens() {
        while (this.heldTokens.size() > 0) {
            this.heldTokens.getValue(0).withdraw();
        }
    }

    public TokenList getTokens() {
        TokenList tokens = new TokenList();
        TokenList heldTokens = this.heldTokens;
        int i = 0;
        while (i < heldTokens.size()) {
            Token heldToken = heldTokens.getValue(i);
            tokens.addValue(heldToken);
            ++i;
        }
        return tokens;
    }

    public void suspend() {
        this.group.suspend(this);
    }

    public void resume() {
        this.group.resume(this);
    }
}

