/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Activities.CompleteStructuredActivities;

import fUML.Semantics.Actions.BasicActions.ActionActivation;
import fUML.Semantics.Actions.BasicActions.PinActivation;
import fUML.Semantics.Activities.IntermediateActivities.ActivityEdgeInstance;
import fUML.Semantics.Activities.IntermediateActivities.ActivityNodeActivation;
import fUML.Semantics.Activities.IntermediateActivities.ActivityNodeActivationGroup;
import fUML.Semantics.Activities.IntermediateActivities.ObjectToken;
import fUML.Semantics.Activities.IntermediateActivities.Token;
import fUML.Semantics.Activities.IntermediateActivities.TokenList;
import fUML.Semantics.Classes.Kernel.Value;
import fUML.Semantics.Classes.Kernel.ValueList;
import fUML.Syntax.Actions.BasicActions.Action;
import fUML.Syntax.Actions.BasicActions.InputPin;
import fUML.Syntax.Actions.BasicActions.InputPinList;
import fUML.Syntax.Actions.BasicActions.OutputPin;
import fUML.Syntax.Actions.BasicActions.OutputPinList;
import fUML.Syntax.Activities.CompleteStructuredActivities.ExecutableNode;
import fUML.Syntax.Activities.CompleteStructuredActivities.ExecutableNodeList;
import fUML.Syntax.Activities.CompleteStructuredActivities.StructuredActivityNode;
import fUML.Syntax.Activities.IntermediateActivities.ActivityNode;
import fUML.Syntax.Activities.IntermediateActivities.ActivityNodeList;

public class StructuredActivityNodeActivation
extends ActionActivation {
    public ActivityNodeActivationGroup activationGroup = null;

    @Override
    public void doAction() {
        if (((StructuredActivityNode)this.node).mustIsolate) {
            StructuredActivityNodeActivation._beginIsolation();
            this.doStructuredActivity();
            StructuredActivityNodeActivation._endIsolation();
        } else {
            this.doStructuredActivity();
        }
    }

    public void doStructuredActivity() {
        Action action = (Action)this.node;
        InputPinList inputPins = action.input;
        for (InputPin inputPin : inputPins) {
            PinActivation pinActivation = this.getPinActivation(inputPin);
            pinActivation.sendUnofferedTokens();
        }
        this.activationGroup.run(this.activationGroup.nodeActivations);
    }

    @Override
    public void terminate() {
        this.terminateAll();
        super.terminate();
    }

    @Override
    public ActivityNodeActivation getNodeActivation(ActivityNode node) {
        ActivityNodeActivation thisActivation = super.getNodeActivation(node);
        ActivityNodeActivation activation = null;
        if (thisActivation != null) {
            activation = thisActivation;
        } else if (this.activationGroup != null) {
            activation = this.activationGroup.getNodeActivation(node);
        }
        return activation;
    }

    public ActivityNodeList makeActivityNodeList(ExecutableNodeList nodes) {
        ActivityNodeList activityNodes = new ActivityNodeList();
        int i = 0;
        while (i < nodes.size()) {
            ExecutableNode node = nodes.getValue(i);
            activityNodes.addValue(node);
            if (node instanceof Action) {
                Action action = (Action)node;
                InputPinList inputPins = action.input;
                int j = 0;
                while (j < inputPins.size()) {
                    InputPin inputPin = inputPins.getValue(j);
                    activityNodes.addValue(inputPin);
                    ++j;
                }
                OutputPinList outputPins = action.output;
                int j2 = 0;
                while (j2 < outputPins.size()) {
                    OutputPin outputPin = outputPins.getValue(j2);
                    activityNodes.addValue(outputPin);
                    ++j2;
                }
            }
            ++i;
        }
        return activityNodes;
    }

    public ValueList getPinValues(OutputPin pin) {
        PinActivation pinActivation = (PinActivation)this.activationGroup.getNodeActivation(pin);
        TokenList tokens = pinActivation.getTokens();
        ValueList values = new ValueList();
        int i = 0;
        while (i < tokens.size()) {
            Token token = tokens.getValue(i);
            Value value = ((ObjectToken)token).value;
            if (value != null) {
                values.addValue(value);
            }
            ++i;
        }
        return values;
    }

    public void putPinValues(OutputPin pin, ValueList values) {
        PinActivation pinActivation = (PinActivation)this.activationGroup.getNodeActivation(pin);
        int i = 0;
        while (i < values.size()) {
            Value value = values.getValue(i);
            ObjectToken token = new ObjectToken();
            token.value = value;
            pinActivation.addToken(token);
            ++i;
        }
    }

    @Override
    public void createNodeActivations() {
        super.createNodeActivations();
        this.activationGroup = new ActivityNodeActivationGroup();
        this.activationGroup.containingNodeActivation = this;
        this.activationGroup.createNodeActivations(((StructuredActivityNode)this.node).node);
    }

    @Override
    public void createEdgeInstances() {
        this.activationGroup.createEdgeInstances(((StructuredActivityNode)this.node).edge);
    }

    @Override
    public boolean isSourceFor(ActivityEdgeInstance edgeInstance) {
        boolean isSource = super.isSourceFor(edgeInstance);
        if (!isSource) {
            isSource = this.activationGroup.hasSourceFor(edgeInstance);
        }
        return isSource;
    }

    public void terminateAll() {
        this.activationGroup.terminateAll();
    }

    public boolean isSuspended() {
        return this.activationGroup.isSuspended();
    }

    @Override
    public TokenList completeAction() {
        TokenList incomingTokens = new TokenList();
        if (!this.isSuspended()) {
            incomingTokens = super.completeAction();
        }
        return incomingTokens;
    }

    @Override
    public void resume() {
        TokenList incomingTokens = super.completeAction();
        if (incomingTokens.size() > 0) {
            this.fire(incomingTokens);
        }
        if (!this.isSuspended()) {
            super.resume();
        }
    }
}

