/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.repository.model;

import fUML.Syntax.Classes.Kernel.Association;
import fUML.Syntax.Classes.Kernel.Class_;
import fUML.Syntax.Classes.Kernel.Enumeration;
import fUML.Syntax.Classes.Kernel.EnumerationLiteral;
import fUML.Syntax.Classes.Kernel.Package;
import fUML.Syntax.Classes.Kernel.Property;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.repository.Repository;
import org.modeldriven.fuml.repository.RepositoryArtifact;
import org.modeldriven.fuml.repository.RepositoryMapping;
import org.modeldriven.fuml.repository.config.Artifact;
import org.modeldriven.fuml.repository.model.ModelAssembler;
import org.modeldriven.fuml.repository.model.ModelFactory;

public class SuperstructureAssembler
extends ModelAssembler
implements RepositoryArtifact {
    private static Log log = LogFactory.getLog(SuperstructureAssembler.class);
    private ModelFactory factory;

    public SuperstructureAssembler(Artifact artifact, RepositoryMapping mapping, Repository model) {
        super(artifact, mapping, model);
        this.factory = new ModelFactory(mapping, model);
        this.construct();
    }

    private void construct() {
        log.info((Object)"initializing...");
        this.constructPackages();
        this.constructPrimitiveTypes();
        this.constructEnumerations();
        this.constructClasses();
        this.constructProperties();
        this.constructGeneralizations();
        this.constructAssociations();
    }

    @Override
    public String getURN() {
        return this.artifact.getUrn();
    }

    @Override
    public String getNamespaceURI() {
        return this.artifact.getNamespaceURI();
    }

    private void constructPackages() {
        Package pkg = null;
        pkg = this.factory.createPackage("UML", "UML", "UML", this);
        this.mapping.mapPackage(pkg, null, this);
        pkg = this.factory.createPackage("Actions", "UML.Actions", "Actions", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("BasicActions", "UML.Actions.BasicActions", "Actions-BasicActions", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Actions", this);
        pkg = this.factory.createPackage("CompleteActions", "UML.Actions.CompleteActions", "Actions-CompleteActions", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Actions", this);
        this.mapping.mapPackageMerge(pkg, "Actions-IntermediateActions");
        this.mapping.mapPackageMerge(pkg, "Actions-StructuredActions");
        pkg = this.factory.createPackage("IntermediateActions", "UML.Actions.IntermediateActions", "Actions-IntermediateActions", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Actions", this);
        this.mapping.mapPackageMerge(pkg, "CommonBehaviors-BasicBehaviors");
        pkg = this.factory.createPackage("StructuredActions", "UML.Actions.StructuredActions", "Actions-StructuredActions", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Actions", this);
        pkg = this.factory.createPackage("Activities", "UML.Activities", "Activities", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("BasicActivities", "UML.Activities.BasicActivities", "Activities-BasicActivities", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Activities", this);
        this.mapping.mapPackageMerge(pkg, "CommonBehaviors-BasicBehaviors");
        this.mapping.mapPackageMerge(pkg, "Activities-FundamentalActivities");
        pkg = this.factory.createPackage("CompleteActivities", "UML.Activities.CompleteActivities", "Activities-CompleteActivities", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Activities", this);
        this.mapping.mapPackageMerge(pkg, "Activities-IntermediateActivities");
        pkg = this.factory.createPackage("CompleteStructuredActivities", "UML.Activities.CompleteStructuredActivities", "Activities-CompleteStructuredActivities", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Activities", this);
        this.mapping.mapPackageMerge(pkg, "Activities-BasicActivities");
        this.mapping.mapPackageMerge(pkg, "Activities-StructuredActivities");
        pkg = this.factory.createPackage("ExtraStructuredActivities", "UML.Activities.ExtraStructuredActivities", "Activities-ExtraStructuredActivities", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Activities", this);
        this.mapping.mapPackageMerge(pkg, "Activities-StructuredActivities");
        pkg = this.factory.createPackage("FundamentalActivities", "UML.Activities.FundamentalActivities", "Activities-FundamentalActivities", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Activities", this);
        this.mapping.mapPackageMerge(pkg, "Actions-BasicActions");
        this.mapping.mapPackageMerge(pkg, "CommonBehaviors-BasicBehaviors");
        pkg = this.factory.createPackage("IntermediateActivities", "UML.Activities.IntermediateActivities", "Activities-IntermediateActivities", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Activities", this);
        this.mapping.mapPackageMerge(pkg, "Activities-BasicActivities");
        pkg = this.factory.createPackage("StructuredActivities", "UML.Activities.StructuredActivities", "Activities-StructuredActivities", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Activities", this);
        this.mapping.mapPackageMerge(pkg, "Activities-FundamentalActivities");
        pkg = this.factory.createPackage("AuxiliaryConstructs", "UML.AuxiliaryConstructs", "AuxiliaryConstructs", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("InformationFlows", "UML.AuxiliaryConstructs.InformationFlows", "AuxiliaryConstructs-InformationFlows", pkg, this);
        this.mapping.mapPackage(pkg, "UML.AuxiliaryConstructs", this);
        this.mapping.mapPackageMerge(pkg, "Classes-Kernel");
        pkg = this.factory.createPackage("Models", "UML.AuxiliaryConstructs.Models", "AuxiliaryConstructs-Models", pkg, this);
        this.mapping.mapPackage(pkg, "UML.AuxiliaryConstructs", this);
        this.mapping.mapPackageMerge(pkg, "Classes-Kernel");
        pkg = this.factory.createPackage("Profiles", "UML.AuxiliaryConstructs.Profiles", "AuxiliaryConstructs-Profiles", pkg, this);
        this.mapping.mapPackage(pkg, "UML.AuxiliaryConstructs", this);
        this.mapping.mapPackageMerge(pkg, "http://www.omg.org/spec/UML/20110701/Infrastructure.xmi#Profiles");
        pkg = this.factory.createPackage("Templates", "UML.AuxiliaryConstructs.Templates", "AuxiliaryConstructs-Templates", pkg, this);
        this.mapping.mapPackage(pkg, "UML.AuxiliaryConstructs", this);
        this.mapping.mapPackageMerge(pkg, "CompositeStructures-InternalStructures");
        pkg = this.factory.createPackage("Classes", "UML.Classes", "Classes", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("AssociationClasses", "UML.Classes.AssociationClasses", "Classes-AssociationClasses", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Classes", this);
        this.mapping.mapPackageMerge(pkg, "Classes-Kernel");
        pkg = this.factory.createPackage("Dependencies", "UML.Classes.Dependencies", "Classes-Dependencies", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Classes", this);
        this.mapping.mapPackageMerge(pkg, "Classes-Kernel");
        pkg = this.factory.createPackage("Interfaces", "UML.Classes.Interfaces", "Classes-Interfaces", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Classes", this);
        this.mapping.mapPackageMerge(pkg, "Classes-Dependencies");
        pkg = this.factory.createPackage("Kernel", "UML.Classes.Kernel", "Classes-Kernel", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Classes", this);
        this.mapping.mapPackageMerge(pkg, "http://www.omg.org/spec/UML/20110701/Infrastructure.xmi#Core-Constructs");
        pkg = this.factory.createPackage("PowerTypes", "UML.Classes.PowerTypes", "Classes-PowerTypes", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Classes", this);
        this.mapping.mapPackageMerge(pkg, "Classes-Kernel");
        pkg = this.factory.createPackage("CommonBehaviors", "UML.CommonBehaviors", "CommonBehaviors", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("BasicBehaviors", "UML.CommonBehaviors.BasicBehaviors", "CommonBehaviors-BasicBehaviors", pkg, this);
        this.mapping.mapPackage(pkg, "UML.CommonBehaviors", this);
        this.mapping.mapPackageMerge(pkg, "Classes-Kernel");
        pkg = this.factory.createPackage("Communications", "UML.CommonBehaviors.Communications", "CommonBehaviors-Communications", pkg, this);
        this.mapping.mapPackage(pkg, "UML.CommonBehaviors", this);
        this.mapping.mapPackageMerge(pkg, "Classes-Interfaces");
        pkg = this.factory.createPackage("SimpleTime", "UML.CommonBehaviors.SimpleTime", "CommonBehaviors-SimpleTime", pkg, this);
        this.mapping.mapPackage(pkg, "UML.CommonBehaviors", this);
        this.mapping.mapPackageMerge(pkg, "Actions-IntermediateActions");
        pkg = this.factory.createPackage("Components", "UML.Components", "Components", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("BasicComponents", "UML.Components.BasicComponents", "Components-BasicComponents", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Components", this);
        this.mapping.mapPackageMerge(pkg, "Classes-Dependencies");
        this.mapping.mapPackageMerge(pkg, "CompositeStructures-StructuredClasses");
        pkg = this.factory.createPackage("PackagingComponents", "UML.Components.PackagingComponents", "Components-PackagingComponents", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Components", this);
        this.mapping.mapPackageMerge(pkg, "Components-BasicComponents");
        pkg = this.factory.createPackage("CompositeStructures", "UML.CompositeStructures", "CompositeStructures", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("Collaborations", "UML.CompositeStructures.Collaborations", "CompositeStructures-Collaborations", pkg, this);
        this.mapping.mapPackage(pkg, "UML.CompositeStructures", this);
        this.mapping.mapPackageMerge(pkg, "CompositeStructures-InternalStructures");
        pkg = this.factory.createPackage("InternalStructures", "UML.CompositeStructures.InternalStructures", "CompositeStructures-InternalStructures", pkg, this);
        this.mapping.mapPackage(pkg, "UML.CompositeStructures", this);
        this.mapping.mapPackageMerge(pkg, "Classes-Interfaces");
        pkg = this.factory.createPackage("InvocationActions", "UML.CompositeStructures.InvocationActions", "CompositeStructures-InvocationActions", pkg, this);
        this.mapping.mapPackage(pkg, "UML.CompositeStructures", this);
        this.mapping.mapPackageMerge(pkg, "Actions-BasicActions");
        this.mapping.mapPackageMerge(pkg, "CompositeStructures-Ports");
        pkg = this.factory.createPackage("Ports", "UML.CompositeStructures.Ports", "CompositeStructures-Ports", pkg, this);
        this.mapping.mapPackage(pkg, "UML.CompositeStructures", this);
        this.mapping.mapPackageMerge(pkg, "CommonBehaviors-Communications");
        this.mapping.mapPackageMerge(pkg, "CompositeStructures-InternalStructures");
        pkg = this.factory.createPackage("StructuredActivities", "UML.CompositeStructures.StructuredActivities", "CompositeStructures-StructuredActivities", pkg, this);
        this.mapping.mapPackage(pkg, "UML.CompositeStructures", this);
        this.mapping.mapPackageMerge(pkg, "Activities-StructuredActivities");
        this.mapping.mapPackageMerge(pkg, "CompositeStructures-InternalStructures");
        pkg = this.factory.createPackage("StructuredClasses", "UML.CompositeStructures.StructuredClasses", "CompositeStructures-StructuredClasses", pkg, this);
        this.mapping.mapPackage(pkg, "UML.CompositeStructures", this);
        this.mapping.mapPackageMerge(pkg, "CompositeStructures-Ports");
        pkg = this.factory.createPackage("Deployments", "UML.Deployments", "Deployments", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("Artifacts", "UML.Deployments.Artifacts", "Deployments-Artifacts", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Deployments", this);
        pkg = this.factory.createPackage("ComponentDeployments", "UML.Deployments.ComponentDeployments", "Deployments-ComponentDeployments", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Deployments", this);
        this.mapping.mapPackageMerge(pkg, "Deployments-Nodes");
        pkg = this.factory.createPackage("Nodes", "UML.Deployments.Nodes", "Deployments-Nodes", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Deployments", this);
        this.mapping.mapPackageMerge(pkg, "Deployments-Artifacts");
        this.mapping.mapPackageMerge(pkg, "CompositeStructures-StructuredClasses");
        pkg = this.factory.createPackage("Interactions", "UML.Interactions", "Interactions", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("BasicInteractions", "UML.Interactions.BasicInteractions", "Interactions-BasicInteractions", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Interactions", this);
        this.mapping.mapPackageMerge(pkg, "CommonBehaviors-BasicBehaviors");
        this.mapping.mapPackageMerge(pkg, "CompositeStructures-InternalStructures");
        pkg = this.factory.createPackage("Fragments", "UML.Interactions.Fragments", "Interactions-Fragments", pkg, this);
        this.mapping.mapPackage(pkg, "UML.Interactions", this);
        this.mapping.mapPackageMerge(pkg, "Interactions-BasicInteractions");
        pkg = this.factory.createPackage("StateMachines", "UML.StateMachines", "StateMachines", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        pkg = this.factory.createPackage("BehaviorStateMachines", "UML.StateMachines.BehaviorStateMachines", "StateMachines-BehaviorStateMachines", pkg, this);
        this.mapping.mapPackage(pkg, "UML.StateMachines", this);
        this.mapping.mapPackageMerge(pkg, "CommonBehaviors-Communications");
        pkg = this.factory.createPackage("ProtocolStateMachines", "UML.StateMachines.ProtocolStateMachines", "StateMachines-ProtocolStateMachines", pkg, this);
        this.mapping.mapPackage(pkg, "UML.StateMachines", this);
        this.mapping.mapPackageMerge(pkg, "StateMachines-BehaviorStateMachines");
        this.mapping.mapPackageMerge(pkg, "Classes-Interfaces");
        this.mapping.mapPackageMerge(pkg, "CompositeStructures-Ports");
        pkg = this.factory.createPackage("UseCases", "UML.UseCases", "UseCases", pkg, this);
        this.mapping.mapPackage(pkg, "UML", this);
        this.mapping.mapPackageMerge(pkg, "CommonBehaviors-BasicBehaviors");
    }

    private void constructPrimitiveTypes() {
        Object pkg = null;
        Object packageId = null;
        Object type = null;
    }

    private void constructClasses() {
        Package pkg = null;
        String packageId = null;
        Class_ clss = null;
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Action", "Actions-BasicActions-Action", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions.BasicActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CallAction", "Actions-BasicActions-CallAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions.BasicActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CallBehaviorAction", "Actions-BasicActions-CallBehaviorAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.BasicActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CallOperationAction", "Actions-BasicActions-CallOperationAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.BasicActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InputPin", "Actions-BasicActions-InputPin", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.BasicActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InvocationAction", "Actions-BasicActions-InvocationAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions.BasicActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("MultiplicityElement", "Actions-BasicActions-MultiplicityElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions.BasicActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OpaqueAction", "Actions-BasicActions-OpaqueAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.BasicActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OutputPin", "Actions-BasicActions-OutputPin", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.BasicActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Pin", "Actions-BasicActions-Pin", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions.BasicActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("SendSignalAction", "Actions-BasicActions-SendSignalAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.BasicActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ValuePin", "Actions-BasicActions-ValuePin", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.BasicActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("AcceptCallAction", "Actions-CompleteActions-AcceptCallAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.CompleteActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("AcceptEventAction", "Actions-CompleteActions-AcceptEventAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.CompleteActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CreateLinkObjectAction", "Actions-CompleteActions-CreateLinkObjectAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.CompleteActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LinkEndData", "Actions-CompleteActions-LinkEndData", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.CompleteActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("QualifierValue", "Actions-CompleteActions-QualifierValue", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.CompleteActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReadExtentAction", "Actions-CompleteActions-ReadExtentAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.CompleteActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReadIsClassifiedObjectAction", "Actions-CompleteActions-ReadIsClassifiedObjectAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.CompleteActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReadLinkObjectEndAction", "Actions-CompleteActions-ReadLinkObjectEndAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.CompleteActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReadLinkObjectEndQualifierAction", "Actions-CompleteActions-ReadLinkObjectEndQualifierAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.CompleteActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReclassifyObjectAction", "Actions-CompleteActions-ReclassifyObjectAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.CompleteActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReduceAction", "Actions-CompleteActions-ReduceAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.CompleteActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReplyAction", "Actions-CompleteActions-ReplyAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.CompleteActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StartClassifierBehaviorAction", "Actions-CompleteActions-StartClassifierBehaviorAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.CompleteActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StartObjectBehaviorAction", "Actions-CompleteActions-StartObjectBehaviorAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.CompleteActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("UnmarshallAction", "Actions-CompleteActions-UnmarshallAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.CompleteActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("AddStructuralFeatureValueAction", "Actions-IntermediateActions-AddStructuralFeatureValueAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("BroadcastSignalAction", "Actions-IntermediateActions-BroadcastSignalAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ClearAssociationAction", "Actions-IntermediateActions-ClearAssociationAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ClearStructuralFeatureAction", "Actions-IntermediateActions-ClearStructuralFeatureAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CreateLinkAction", "Actions-IntermediateActions-CreateLinkAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CreateObjectAction", "Actions-IntermediateActions-CreateObjectAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DestroyLinkAction", "Actions-IntermediateActions-DestroyLinkAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DestroyObjectAction", "Actions-IntermediateActions-DestroyObjectAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LinkAction", "Actions-IntermediateActions-LinkAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LinkEndCreationData", "Actions-IntermediateActions-LinkEndCreationData", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LinkEndData", "Actions-IntermediateActions-LinkEndData", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LinkEndDestructionData", "Actions-IntermediateActions-LinkEndDestructionData", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReadLinkAction", "Actions-IntermediateActions-ReadLinkAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReadSelfAction", "Actions-IntermediateActions-ReadSelfAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReadStructuralFeatureAction", "Actions-IntermediateActions-ReadStructuralFeatureAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("RemoveStructuralFeatureValueAction", "Actions-IntermediateActions-RemoveStructuralFeatureValueAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("SendObjectAction", "Actions-IntermediateActions-SendObjectAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StructuralFeatureAction", "Actions-IntermediateActions-StructuralFeatureAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TestIdentityAction", "Actions-IntermediateActions-TestIdentityAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ValueSpecificationAction", "Actions-IntermediateActions-ValueSpecificationAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("WriteLinkAction", "Actions-IntermediateActions-WriteLinkAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("WriteStructuralFeatureAction", "Actions-IntermediateActions-WriteStructuralFeatureAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions.IntermediateActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActionInputPin", "Actions-StructuredActions-ActionInputPin", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.StructuredActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("AddVariableValueAction", "Actions-StructuredActions-AddVariableValueAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.StructuredActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ClearVariableAction", "Actions-StructuredActions-ClearVariableAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.StructuredActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("RaiseExceptionAction", "Actions-StructuredActions-RaiseExceptionAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.StructuredActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ReadVariableAction", "Actions-StructuredActions-ReadVariableAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.StructuredActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("RemoveVariableValueAction", "Actions-StructuredActions-RemoveVariableValueAction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Actions.StructuredActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("VariableAction", "Actions-StructuredActions-VariableAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions.StructuredActions", this);
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("WriteVariableAction", "Actions-StructuredActions-WriteVariableAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Actions.StructuredActions", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Activity", "Activities-BasicActivities-Activity", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.BasicActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityEdge", "Activities-BasicActivities-ActivityEdge", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.BasicActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityFinalNode", "Activities-BasicActivities-ActivityFinalNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.BasicActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityGroup", "Activities-BasicActivities-ActivityGroup", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.BasicActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityNode", "Activities-BasicActivities-ActivityNode", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.BasicActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityParameterNode", "Activities-BasicActivities-ActivityParameterNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.BasicActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ControlFlow", "Activities-BasicActivities-ControlFlow", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.BasicActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ControlNode", "Activities-BasicActivities-ControlNode", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.BasicActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InitialNode", "Activities-BasicActivities-InitialNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.BasicActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ObjectFlow", "Activities-BasicActivities-ObjectFlow", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.BasicActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ObjectNode", "Activities-BasicActivities-ObjectNode", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.BasicActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Pin", "Activities-BasicActivities-Pin", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.BasicActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ValuePin", "Activities-BasicActivities-ValuePin", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.BasicActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Action", "Activities-CompleteActivities-Action", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.CompleteActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Activity", "Activities-CompleteActivities-Activity", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.CompleteActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityEdge", "Activities-CompleteActivities-ActivityEdge", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.CompleteActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityGroup", "Activities-CompleteActivities-ActivityGroup", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.CompleteActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityNode", "Activities-CompleteActivities-ActivityNode", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.CompleteActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Behavior", "Activities-CompleteActivities-Behavior", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.CompleteActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("BehavioralFeature", "Activities-CompleteActivities-BehavioralFeature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.CompleteActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DataStoreNode", "Activities-CompleteActivities-DataStoreNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.CompleteActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InterruptibleActivityRegion", "Activities-CompleteActivities-InterruptibleActivityRegion", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.CompleteActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("JoinNode", "Activities-CompleteActivities-JoinNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.CompleteActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ObjectFlow", "Activities-CompleteActivities-ObjectFlow", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.CompleteActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ObjectNode", "Activities-CompleteActivities-ObjectNode", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.CompleteActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Parameter", "Activities-CompleteActivities-Parameter", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.CompleteActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ParameterSet", "Activities-CompleteActivities-ParameterSet", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.CompleteActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Pin", "Activities-CompleteActivities-Pin", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.CompleteActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Action", "Activities-CompleteStructuredActivities-Action", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityEdge", "Activities-CompleteStructuredActivities-ActivityEdge", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityGroup", "Activities-CompleteStructuredActivities-ActivityGroup", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Clause", "Activities-CompleteStructuredActivities-Clause", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConditionalNode", "Activities-CompleteStructuredActivities-ConditionalNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InputPin", "Activities-CompleteStructuredActivities-InputPin", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LoopNode", "Activities-CompleteStructuredActivities-LoopNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OutputPin", "Activities-CompleteStructuredActivities-OutputPin", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StructuredActivityNode", "Activities-CompleteStructuredActivities-StructuredActivityNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.CompleteStructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExceptionHandler", "Activities-ExtraStructuredActivities-ExceptionHandler", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.ExtraStructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExecutableNode", "Activities-ExtraStructuredActivities-ExecutableNode", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.ExtraStructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExpansionNode", "Activities-ExtraStructuredActivities-ExpansionNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.ExtraStructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExpansionRegion", "Activities-ExtraStructuredActivities-ExpansionRegion", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.ExtraStructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Action", "Activities-FundamentalActivities-Action", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.FundamentalActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Activity", "Activities-FundamentalActivities-Activity", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.FundamentalActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityGroup", "Activities-FundamentalActivities-ActivityGroup", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.FundamentalActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityNode", "Activities-FundamentalActivities-ActivityNode", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.FundamentalActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Activity", "Activities-IntermediateActivities-Activity", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityEdge", "Activities-IntermediateActivities-ActivityEdge", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityFinalNode", "Activities-IntermediateActivities-ActivityFinalNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityGroup", "Activities-IntermediateActivities-ActivityGroup", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityNode", "Activities-IntermediateActivities-ActivityNode", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityPartition", "Activities-IntermediateActivities-ActivityPartition", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CentralBufferNode", "Activities-IntermediateActivities-CentralBufferNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DecisionNode", "Activities-IntermediateActivities-DecisionNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("FinalNode", "Activities-IntermediateActivities-FinalNode", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("FlowFinalNode", "Activities-IntermediateActivities-FlowFinalNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ForkNode", "Activities-IntermediateActivities-ForkNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("JoinNode", "Activities-IntermediateActivities-JoinNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("MergeNode", "Activities-IntermediateActivities-MergeNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.IntermediateActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Action", "Activities-StructuredActivities-Action", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.StructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Activity", "Activities-StructuredActivities-Activity", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.StructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityGroup", "Activities-StructuredActivities-ActivityGroup", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.StructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActivityNode", "Activities-StructuredActivities-ActivityNode", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.StructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Clause", "Activities-StructuredActivities-Clause", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.StructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConditionalNode", "Activities-StructuredActivities-ConditionalNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.StructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExecutableNode", "Activities-StructuredActivities-ExecutableNode", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Activities.StructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LoopNode", "Activities-StructuredActivities-LoopNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.StructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OutputPin", "Activities-StructuredActivities-OutputPin", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.StructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("SequenceNode", "Activities-StructuredActivities-SequenceNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.StructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StructuredActivityNode", "Activities-StructuredActivities-StructuredActivityNode", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.StructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Variable", "Activities-StructuredActivities-Variable", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Activities.StructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InformationFlow", "AuxiliaryConstructs-InformationFlows-InformationFlow", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.InformationFlows", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InformationItem", "AuxiliaryConstructs-InformationFlows-InformationItem", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.InformationFlows", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Models";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Model", "AuxiliaryConstructs-Models-Model", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Models", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExtensionEnd", "AuxiliaryConstructs-Profiles-ExtensionEnd", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Profiles", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Classifier", "AuxiliaryConstructs-Templates-Classifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ClassifierTemplateParameter", "AuxiliaryConstructs-Templates-ClassifierTemplateParameter", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConnectableElement", "AuxiliaryConstructs-Templates-ConnectableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConnectableElementTemplateParameter", "AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("NamedElement", "AuxiliaryConstructs-Templates-NamedElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Operation", "AuxiliaryConstructs-Templates-Operation", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OperationTemplateParameter", "AuxiliaryConstructs-Templates-OperationTemplateParameter", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Package", "AuxiliaryConstructs-Templates-Package", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PackageableElement", "AuxiliaryConstructs-Templates-PackageableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ParameterableElement", "AuxiliaryConstructs-Templates-ParameterableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Property", "AuxiliaryConstructs-Templates-Property", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("RedefinableElement", "AuxiliaryConstructs-Templates-RedefinableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("RedefinableTemplateSignature", "AuxiliaryConstructs-Templates-RedefinableTemplateSignature", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StringExpression", "AuxiliaryConstructs-Templates-StringExpression", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TemplateBinding", "AuxiliaryConstructs-Templates-TemplateBinding", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TemplateParameter", "AuxiliaryConstructs-Templates-TemplateParameter", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TemplateParameterSubstitution", "AuxiliaryConstructs-Templates-TemplateParameterSubstitution", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TemplateSignature", "AuxiliaryConstructs-Templates-TemplateSignature", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TemplateableElement", "AuxiliaryConstructs-Templates-TemplateableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ValueSpecification", "AuxiliaryConstructs-Templates-ValueSpecification", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.AuxiliaryConstructs.Templates", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-AssociationClasses";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("AssociationClass", "Classes-AssociationClasses-AssociationClass", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.AssociationClasses", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-AssociationClasses";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Property", "Classes-AssociationClasses-Property", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.AssociationClasses", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Abstraction", "Classes-Dependencies-Abstraction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Dependencies", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Classifier", "Classes-Dependencies-Classifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Dependencies", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Dependency", "Classes-Dependencies-Dependency", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Dependencies", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("NamedElement", "Classes-Dependencies-NamedElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Dependencies", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Namespace", "Classes-Dependencies-Namespace", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Dependencies", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PackageableElement", "Classes-Dependencies-PackageableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Dependencies", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Realization", "Classes-Dependencies-Realization", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Dependencies", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Substitution", "Classes-Dependencies-Substitution", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Dependencies", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Usage", "Classes-Dependencies-Usage", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Dependencies", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("BehavioredClassifier", "Classes-Interfaces-BehavioredClassifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Interfaces", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Classifier", "Classes-Interfaces-Classifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Interfaces", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Interface", "Classes-Interfaces-Interface", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Interfaces", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InterfaceRealization", "Classes-Interfaces-InterfaceRealization", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Interfaces", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Operation", "Classes-Interfaces-Operation", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Interfaces", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Property", "Classes-Interfaces-Property", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Interfaces", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Association", "Classes-Kernel-Association", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("BehavioralFeature", "Classes-Kernel-BehavioralFeature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Class", "Classes-Kernel-Class", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Classifier", "Classes-Kernel-Classifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Comment", "Classes-Kernel-Comment", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Constraint", "Classes-Kernel-Constraint", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DataType", "Classes-Kernel-DataType", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DirectedRelationship", "Classes-Kernel-DirectedRelationship", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Element", "Classes-Kernel-Element", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ElementImport", "Classes-Kernel-ElementImport", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Enumeration", "Classes-Kernel-Enumeration", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("EnumerationLiteral", "Classes-Kernel-EnumerationLiteral", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Expression", "Classes-Kernel-Expression", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Feature", "Classes-Kernel-Feature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Generalization", "Classes-Kernel-Generalization", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InstanceSpecification", "Classes-Kernel-InstanceSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InstanceValue", "Classes-Kernel-InstanceValue", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralBoolean", "Classes-Kernel-LiteralBoolean", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralInteger", "Classes-Kernel-LiteralInteger", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralNull", "Classes-Kernel-LiteralNull", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralReal", "Classes-Kernel-LiteralReal", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralSpecification", "Classes-Kernel-LiteralSpecification", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralString", "Classes-Kernel-LiteralString", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralUnlimitedNatural", "Classes-Kernel-LiteralUnlimitedNatural", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("MultiplicityElement", "Classes-Kernel-MultiplicityElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("NamedElement", "Classes-Kernel-NamedElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Namespace", "Classes-Kernel-Namespace", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OpaqueExpression", "Classes-Kernel-OpaqueExpression", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Operation", "Classes-Kernel-Operation", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Package", "Classes-Kernel-Package", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PackageImport", "Classes-Kernel-PackageImport", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PackageMerge", "Classes-Kernel-PackageMerge", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PackageableElement", "Classes-Kernel-PackageableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Parameter", "Classes-Kernel-Parameter", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PrimitiveType", "Classes-Kernel-PrimitiveType", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Property", "Classes-Kernel-Property", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("RedefinableElement", "Classes-Kernel-RedefinableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Relationship", "Classes-Kernel-Relationship", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Slot", "Classes-Kernel-Slot", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StructuralFeature", "Classes-Kernel-StructuralFeature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Type", "Classes-Kernel-Type", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TypedElement", "Classes-Kernel-TypedElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ValueSpecification", "Classes-Kernel-ValueSpecification", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.Kernel", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-PowerTypes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Classifier", "Classes-PowerTypes-Classifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Classes.PowerTypes", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-PowerTypes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Generalization", "Classes-PowerTypes-Generalization", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.PowerTypes", this);
        packageId = this.artifact.getUrn() + "#" + "Classes-PowerTypes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("GeneralizationSet", "Classes-PowerTypes-GeneralizationSet", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Classes.PowerTypes", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Behavior", "CommonBehaviors-BasicBehaviors-Behavior", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.BasicBehaviors", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("BehavioralFeature", "CommonBehaviors-BasicBehaviors-BehavioralFeature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.BasicBehaviors", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("BehavioredClassifier", "CommonBehaviors-BasicBehaviors-BehavioredClassifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.BasicBehaviors", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("FunctionBehavior", "CommonBehaviors-BasicBehaviors-FunctionBehavior", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.BasicBehaviors", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OpaqueBehavior", "CommonBehaviors-BasicBehaviors-OpaqueBehavior", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.BasicBehaviors", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OpaqueExpression", "CommonBehaviors-BasicBehaviors-OpaqueExpression", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.BasicBehaviors", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("AnyReceiveEvent", "CommonBehaviors-Communications-AnyReceiveEvent", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("BehavioralFeature", "CommonBehaviors-Communications-BehavioralFeature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CallEvent", "CommonBehaviors-Communications-CallEvent", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ChangeEvent", "CommonBehaviors-Communications-ChangeEvent", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Class", "CommonBehaviors-Communications-Class", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Event", "CommonBehaviors-Communications-Event", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Interface", "CommonBehaviors-Communications-Interface", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("MessageEvent", "CommonBehaviors-Communications-MessageEvent", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Operation", "CommonBehaviors-Communications-Operation", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Reception", "CommonBehaviors-Communications-Reception", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Signal", "CommonBehaviors-Communications-Signal", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("SignalEvent", "CommonBehaviors-Communications-SignalEvent", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Trigger", "CommonBehaviors-Communications-Trigger", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.Communications", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Duration", "CommonBehaviors-SimpleTime-Duration", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DurationConstraint", "CommonBehaviors-SimpleTime-DurationConstraint", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DurationInterval", "CommonBehaviors-SimpleTime-DurationInterval", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DurationObservation", "CommonBehaviors-SimpleTime-DurationObservation", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Interval", "CommonBehaviors-SimpleTime-Interval", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("IntervalConstraint", "CommonBehaviors-SimpleTime-IntervalConstraint", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Observation", "CommonBehaviors-SimpleTime-Observation", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TimeConstraint", "CommonBehaviors-SimpleTime-TimeConstraint", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TimeEvent", "CommonBehaviors-SimpleTime-TimeEvent", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TimeExpression", "CommonBehaviors-SimpleTime-TimeExpression", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TimeInterval", "CommonBehaviors-SimpleTime-TimeInterval", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this);
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TimeObservation", "CommonBehaviors-SimpleTime-TimeObservation", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CommonBehaviors.SimpleTime", this);
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Component", "Components-BasicComponents-Component", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Components.BasicComponents", this);
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ComponentRealization", "Components-BasicComponents-ComponentRealization", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Components.BasicComponents", this);
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConnectableElement", "Components-BasicComponents-ConnectableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Components.BasicComponents", this);
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Connector", "Components-BasicComponents-Connector", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Components.BasicComponents", this);
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConnectorEnd", "Components-BasicComponents-ConnectorEnd", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Components.BasicComponents", this);
        packageId = this.artifact.getUrn() + "#" + "Components-PackagingComponents";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Component", "Components-PackagingComponents-Component", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Components.PackagingComponents", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Classifier", "CompositeStructures-Collaborations-Classifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CompositeStructures.Collaborations", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Collaboration", "CompositeStructures-Collaborations-Collaboration", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CompositeStructures.Collaborations", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CollaborationUse", "CompositeStructures-Collaborations-CollaborationUse", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CompositeStructures.Collaborations", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Parameter", "CompositeStructures-Collaborations-Parameter", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CompositeStructures.Collaborations", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Class", "CompositeStructures-InternalStructures-Class", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CompositeStructures.InternalStructures", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Classifier", "CompositeStructures-InternalStructures-Classifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CompositeStructures.InternalStructures", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConnectableElement", "CompositeStructures-InternalStructures-ConnectableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CompositeStructures.InternalStructures", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Connector", "CompositeStructures-InternalStructures-Connector", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CompositeStructures.InternalStructures", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConnectorEnd", "CompositeStructures-InternalStructures-ConnectorEnd", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CompositeStructures.InternalStructures", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Feature", "CompositeStructures-InternalStructures-Feature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CompositeStructures.InternalStructures", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Property", "CompositeStructures-InternalStructures-Property", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CompositeStructures.InternalStructures", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StructuredClassifier", "CompositeStructures-InternalStructures-StructuredClassifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CompositeStructures.InternalStructures", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InvocationActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InvocationAction", "CompositeStructures-InvocationActions-InvocationAction", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CompositeStructures.InvocationActions", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InvocationActions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Trigger", "CompositeStructures-InvocationActions-Trigger", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CompositeStructures.InvocationActions", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConnectorEnd", "CompositeStructures-Ports-ConnectorEnd", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CompositeStructures.Ports", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("EncapsulatedClassifier", "CompositeStructures-Ports-EncapsulatedClassifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.CompositeStructures.Ports", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Port", "CompositeStructures-Ports-Port", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CompositeStructures.Ports", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-StructuredActivities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Variable", "CompositeStructures-StructuredActivities-Variable", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CompositeStructures.StructuredActivities", this);
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-StructuredClasses";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Class", "CompositeStructures-StructuredClasses-Class", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.CompositeStructures.StructuredClasses", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments-Artifacts";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Artifact", "Deployments-Artifacts-Artifact", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments.Artifacts", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments-Artifacts";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Manifestation", "Deployments-Artifacts-Manifestation", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments.Artifacts", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments-ComponentDeployments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Deployment", "Deployments-ComponentDeployments-Deployment", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments.ComponentDeployments", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments-ComponentDeployments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DeploymentSpecification", "Deployments-ComponentDeployments-DeploymentSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments.ComponentDeployments", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Artifact", "Deployments-Nodes-Artifact", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments.Nodes", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CommunicationPath", "Deployments-Nodes-CommunicationPath", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments.Nodes", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DeployedArtifact", "Deployments-Nodes-DeployedArtifact", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Deployments.Nodes", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Deployment", "Deployments-Nodes-Deployment", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments.Nodes", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DeploymentTarget", "Deployments-Nodes-DeploymentTarget", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Deployments.Nodes", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Device", "Deployments-Nodes-Device", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments.Nodes", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExecutionEnvironment", "Deployments-Nodes-ExecutionEnvironment", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments.Nodes", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InstanceSpecification", "Deployments-Nodes-InstanceSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments.Nodes", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Node", "Deployments-Nodes-Node", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments.Nodes", this);
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Property", "Deployments-Nodes-Property", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Deployments.Nodes", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ActionExecutionSpecification", "Interactions-BasicInteractions-ActionExecutionSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("BehaviorExecutionSpecification", "Interactions-BasicInteractions-BehaviorExecutionSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DestructionOccurrenceSpecification", "Interactions-BasicInteractions-DestructionOccurrenceSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExecutionOccurrenceSpecification", "Interactions-BasicInteractions-ExecutionOccurrenceSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExecutionSpecification", "Interactions-BasicInteractions-ExecutionSpecification", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("GeneralOrdering", "Interactions-BasicInteractions-GeneralOrdering", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Interaction", "Interactions-BasicInteractions-Interaction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InteractionFragment", "Interactions-BasicInteractions-InteractionFragment", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Lifeline", "Interactions-BasicInteractions-Lifeline", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Message", "Interactions-BasicInteractions-Message", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("MessageEnd", "Interactions-BasicInteractions-MessageEnd", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("MessageOccurrenceSpecification", "Interactions-BasicInteractions-MessageOccurrenceSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OccurrenceSpecification", "Interactions-BasicInteractions-OccurrenceSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StateInvariant", "Interactions-BasicInteractions-StateInvariant", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.BasicInteractions", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("CombinedFragment", "Interactions-Fragments-CombinedFragment", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.Fragments", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConsiderIgnoreFragment", "Interactions-Fragments-ConsiderIgnoreFragment", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.Fragments", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Continuation", "Interactions-Fragments-Continuation", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.Fragments", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Gate", "Interactions-Fragments-Gate", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.Fragments", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Interaction", "Interactions-Fragments-Interaction", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.Fragments", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InteractionConstraint", "Interactions-Fragments-InteractionConstraint", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.Fragments", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InteractionFragment", "Interactions-Fragments-InteractionFragment", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.Interactions.Fragments", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InteractionOperand", "Interactions-Fragments-InteractionOperand", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.Fragments", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InteractionUse", "Interactions-Fragments-InteractionUse", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.Fragments", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Lifeline", "Interactions-Fragments-Lifeline", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.Fragments", this);
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PartDecomposition", "Interactions-Fragments-PartDecomposition", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.Interactions.Fragments", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ConnectionPointReference", "StateMachines-BehaviorStateMachines-ConnectionPointReference", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("FinalState", "StateMachines-BehaviorStateMachines-FinalState", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Pseudostate", "StateMachines-BehaviorStateMachines-Pseudostate", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Region", "StateMachines-BehaviorStateMachines-Region", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("State", "StateMachines-BehaviorStateMachines-State", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StateMachine", "StateMachines-BehaviorStateMachines-StateMachine", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TimeEvent", "StateMachines-BehaviorStateMachines-TimeEvent", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Transition", "StateMachines-BehaviorStateMachines-Transition", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Vertex", "StateMachines-BehaviorStateMachines-Vertex", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.StateMachines.BehaviorStateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Interface", "StateMachines-ProtocolStateMachines-Interface", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines.ProtocolStateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Port", "StateMachines-ProtocolStateMachines-Port", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines.ProtocolStateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ProtocolConformance", "StateMachines-ProtocolStateMachines-ProtocolConformance", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines.ProtocolStateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ProtocolStateMachine", "StateMachines-ProtocolStateMachines-ProtocolStateMachine", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines.ProtocolStateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ProtocolTransition", "StateMachines-ProtocolStateMachines-ProtocolTransition", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines.ProtocolStateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Region", "StateMachines-ProtocolStateMachines-Region", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines.ProtocolStateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("State", "StateMachines-ProtocolStateMachines-State", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.StateMachines.ProtocolStateMachines", this);
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Actor", "UseCases-Actor", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.UseCases", this);
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Classifier", "UseCases-Classifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "UML.UseCases", this);
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Extend", "UseCases-Extend", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.UseCases", this);
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExtensionPoint", "UseCases-ExtensionPoint", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.UseCases", this);
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Include", "UseCases-Include", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.UseCases", this);
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("UseCase", "UseCases-UseCase", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "UML.UseCases", this);
    }

    private void constructEnumerations() {
        Enumeration enumeration = null;
        EnumerationLiteral literal = null;
        enumeration = this.factory.createEnumeration("ObjectNodeOrderingKind", "Activities-CompleteActivities-ObjectNodeOrderingKind");
        this.mapping.mapEnumeration(enumeration, "UML.Activities.CompleteActivities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "unordered", "Activities-CompleteActivities-ObjectNodeOrderingKind-unordered");
        this.mapping.mapEnumerationLiteral(literal, "UML.Activities.CompleteActivities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "ordered", "Activities-CompleteActivities-ObjectNodeOrderingKind-ordered");
        this.mapping.mapEnumerationLiteral(literal, "UML.Activities.CompleteActivities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "LIFO", "Activities-CompleteActivities-ObjectNodeOrderingKind-LIFO");
        this.mapping.mapEnumerationLiteral(literal, "UML.Activities.CompleteActivities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "FIFO", "Activities-CompleteActivities-ObjectNodeOrderingKind-FIFO");
        this.mapping.mapEnumerationLiteral(literal, "UML.Activities.CompleteActivities", this);
        enumeration = this.factory.createEnumeration("ParameterEffectKind", "Activities-CompleteActivities-ParameterEffectKind");
        this.mapping.mapEnumeration(enumeration, "UML.Activities.CompleteActivities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "create", "Activities-CompleteActivities-ParameterEffectKind-create");
        this.mapping.mapEnumerationLiteral(literal, "UML.Activities.CompleteActivities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "read", "Activities-CompleteActivities-ParameterEffectKind-read");
        this.mapping.mapEnumerationLiteral(literal, "UML.Activities.CompleteActivities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "update", "Activities-CompleteActivities-ParameterEffectKind-update");
        this.mapping.mapEnumerationLiteral(literal, "UML.Activities.CompleteActivities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "delete", "Activities-CompleteActivities-ParameterEffectKind-delete");
        this.mapping.mapEnumerationLiteral(literal, "UML.Activities.CompleteActivities", this);
        enumeration = this.factory.createEnumeration("ExpansionKind", "Activities-ExtraStructuredActivities-ExpansionKind");
        this.mapping.mapEnumeration(enumeration, "UML.Activities.ExtraStructuredActivities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "parallel", "Activities-ExtraStructuredActivities-ExpansionKind-parallel");
        this.mapping.mapEnumerationLiteral(literal, "UML.Activities.ExtraStructuredActivities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "iterative", "Activities-ExtraStructuredActivities-ExpansionKind-iterative");
        this.mapping.mapEnumerationLiteral(literal, "UML.Activities.ExtraStructuredActivities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "stream", "Activities-ExtraStructuredActivities-ExpansionKind-stream");
        this.mapping.mapEnumerationLiteral(literal, "UML.Activities.ExtraStructuredActivities", this);
        enumeration = this.factory.createEnumeration("AggregationKind", "Classes-Kernel-AggregationKind");
        this.mapping.mapEnumeration(enumeration, "UML.Classes.Kernel", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "none", "Classes-Kernel-AggregationKind-none");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "shared", "Classes-Kernel-AggregationKind-shared");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "composite", "Classes-Kernel-AggregationKind-composite");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this);
        enumeration = this.factory.createEnumeration("ParameterDirectionKind", "Classes-Kernel-ParameterDirectionKind");
        this.mapping.mapEnumeration(enumeration, "UML.Classes.Kernel", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "in", "Classes-Kernel-ParameterDirectionKind-in");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "inout", "Classes-Kernel-ParameterDirectionKind-inout");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "out", "Classes-Kernel-ParameterDirectionKind-out");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "return", "Classes-Kernel-ParameterDirectionKind-return");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this);
        enumeration = this.factory.createEnumeration("VisibilityKind", "Classes-Kernel-VisibilityKind");
        this.mapping.mapEnumeration(enumeration, "UML.Classes.Kernel", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "public", "Classes-Kernel-VisibilityKind-public");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "private", "Classes-Kernel-VisibilityKind-private");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "protected", "Classes-Kernel-VisibilityKind-protected");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "package", "Classes-Kernel-VisibilityKind-package");
        this.mapping.mapEnumerationLiteral(literal, "UML.Classes.Kernel", this);
        enumeration = this.factory.createEnumeration("CallConcurrencyKind", "CommonBehaviors-Communications-CallConcurrencyKind");
        this.mapping.mapEnumeration(enumeration, "UML.CommonBehaviors.Communications", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "sequential", "CommonBehaviors-Communications-CallConcurrencyKind-sequential");
        this.mapping.mapEnumerationLiteral(literal, "UML.CommonBehaviors.Communications", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "guarded", "CommonBehaviors-Communications-CallConcurrencyKind-guarded");
        this.mapping.mapEnumerationLiteral(literal, "UML.CommonBehaviors.Communications", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "concurrent", "CommonBehaviors-Communications-CallConcurrencyKind-concurrent");
        this.mapping.mapEnumerationLiteral(literal, "UML.CommonBehaviors.Communications", this);
        enumeration = this.factory.createEnumeration("ConnectorKind", "Components-BasicComponents-ConnectorKind");
        this.mapping.mapEnumeration(enumeration, "UML.Components.BasicComponents", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "assembly", "Components-BasicComponents-ConnectorKind-assembly");
        this.mapping.mapEnumerationLiteral(literal, "UML.Components.BasicComponents", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "delegation", "Components-BasicComponents-ConnectorKind-delegation");
        this.mapping.mapEnumerationLiteral(literal, "UML.Components.BasicComponents", this);
        enumeration = this.factory.createEnumeration("MessageKind", "Interactions-BasicInteractions-MessageKind");
        this.mapping.mapEnumeration(enumeration, "UML.Interactions.BasicInteractions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "complete", "Interactions-BasicInteractions-MessageKind-complete");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "lost", "Interactions-BasicInteractions-MessageKind-lost");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "found", "Interactions-BasicInteractions-MessageKind-found");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "unknown", "Interactions-BasicInteractions-MessageKind-unknown");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this);
        enumeration = this.factory.createEnumeration("MessageSort", "Interactions-BasicInteractions-MessageSort");
        this.mapping.mapEnumeration(enumeration, "UML.Interactions.BasicInteractions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "synchCall", "Interactions-BasicInteractions-MessageSort-synchCall");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "asynchCall", "Interactions-BasicInteractions-MessageSort-asynchCall");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "asynchSignal", "Interactions-BasicInteractions-MessageSort-asynchSignal");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "createMessage", "Interactions-BasicInteractions-MessageSort-createMessage");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "deleteMessage", "Interactions-BasicInteractions-MessageSort-deleteMessage");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "reply", "Interactions-BasicInteractions-MessageSort-reply");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.BasicInteractions", this);
        enumeration = this.factory.createEnumeration("InteractionOperatorKind", "Interactions-Fragments-InteractionOperatorKind");
        this.mapping.mapEnumeration(enumeration, "UML.Interactions.Fragments", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "seq", "Interactions-Fragments-InteractionOperatorKind-seq");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "alt", "Interactions-Fragments-InteractionOperatorKind-alt");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "opt", "Interactions-Fragments-InteractionOperatorKind-opt");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "break", "Interactions-Fragments-InteractionOperatorKind-break");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "par", "Interactions-Fragments-InteractionOperatorKind-par");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "strict", "Interactions-Fragments-InteractionOperatorKind-strict");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "loop", "Interactions-Fragments-InteractionOperatorKind-loop");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "critical", "Interactions-Fragments-InteractionOperatorKind-critical");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "neg", "Interactions-Fragments-InteractionOperatorKind-neg");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "assert", "Interactions-Fragments-InteractionOperatorKind-assert");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "ignore", "Interactions-Fragments-InteractionOperatorKind-ignore");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "consider", "Interactions-Fragments-InteractionOperatorKind-consider");
        this.mapping.mapEnumerationLiteral(literal, "UML.Interactions.Fragments", this);
        enumeration = this.factory.createEnumeration("PseudostateKind", "StateMachines-BehaviorStateMachines-PseudostateKind");
        this.mapping.mapEnumeration(enumeration, "UML.StateMachines.BehaviorStateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "initial", "StateMachines-BehaviorStateMachines-PseudostateKind-initial");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "deepHistory", "StateMachines-BehaviorStateMachines-PseudostateKind-deepHistory");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "shallowHistory", "StateMachines-BehaviorStateMachines-PseudostateKind-shallowHistory");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "join", "StateMachines-BehaviorStateMachines-PseudostateKind-join");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "fork", "StateMachines-BehaviorStateMachines-PseudostateKind-fork");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "junction", "StateMachines-BehaviorStateMachines-PseudostateKind-junction");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "choice", "StateMachines-BehaviorStateMachines-PseudostateKind-choice");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "entryPoint", "StateMachines-BehaviorStateMachines-PseudostateKind-entryPoint");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "exitPoint", "StateMachines-BehaviorStateMachines-PseudostateKind-exitPoint");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "terminate", "StateMachines-BehaviorStateMachines-PseudostateKind-terminate");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this);
        enumeration = this.factory.createEnumeration("TransitionKind", "StateMachines-BehaviorStateMachines-TransitionKind");
        this.mapping.mapEnumeration(enumeration, "UML.StateMachines.BehaviorStateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "internal", "StateMachines-BehaviorStateMachines-TransitionKind-internal");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "local", "StateMachines-BehaviorStateMachines-TransitionKind-local");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "external", "StateMachines-BehaviorStateMachines-TransitionKind-external");
        this.mapping.mapEnumerationLiteral(literal, "UML.StateMachines.BehaviorStateMachines", this);
    }

    /*
     * Opcode count of 23895 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void constructProperties() {
        Class_ clss = null;
        Property prop = null;
        clss = (Class_)this.model.getElementById("Actions-BasicActions-Action").getDelegate();
        prop = this.factory.createProperty(clss, "context", "Actions-BasicActions-Action-context", "Classes-Kernel-Classifier", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "input", "Actions-BasicActions-Action-input", "Actions-BasicActions-InputPin", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "output", "Actions-BasicActions-Action-output", "Actions-BasicActions-OutputPin", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-BasicActions-CallAction").getDelegate();
        prop = this.factory.createProperty(clss, "isSynchronous", "Actions-BasicActions-CallAction-isSynchronous", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "Actions-BasicActions-CallAction-isSynchronous-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "result", "Actions-BasicActions-CallAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-BasicActions-CallBehaviorAction").getDelegate();
        prop = this.factory.createProperty(clss, "behavior", "Actions-BasicActions-CallBehaviorAction-behavior", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-BasicActions-CallOperationAction").getDelegate();
        prop = this.factory.createProperty(clss, "operation", "Actions-BasicActions-CallOperationAction-operation", "Classes-Kernel-Operation", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "target", "Actions-BasicActions-CallOperationAction-target", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-BasicActions-InputPin").getDelegate();
        clss = (Class_)this.model.getElementById("Actions-BasicActions-InvocationAction").getDelegate();
        prop = this.factory.createProperty(clss, "argument", "Actions-BasicActions-InvocationAction-argument", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-BasicActions-MultiplicityElement").getDelegate();
        clss = (Class_)this.model.getElementById("Actions-BasicActions-OpaqueAction").getDelegate();
        prop = this.factory.createProperty(clss, "body", "Actions-BasicActions-OpaqueAction-body", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inputValue", "Actions-BasicActions-OpaqueAction-inputValue", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "language", "Actions-BasicActions-OpaqueAction-language", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "outputValue", "Actions-BasicActions-OpaqueAction-outputValue", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-BasicActions-OutputPin").getDelegate();
        clss = (Class_)this.model.getElementById("Actions-BasicActions-Pin").getDelegate();
        clss = (Class_)this.model.getElementById("Actions-BasicActions-SendSignalAction").getDelegate();
        prop = this.factory.createProperty(clss, "signal", "Actions-BasicActions-SendSignalAction-signal", "CommonBehaviors-Communications-Signal", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "target", "Actions-BasicActions-SendSignalAction-target", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-BasicActions-ValuePin").getDelegate();
        prop = this.factory.createProperty(clss, "value", "Actions-BasicActions-ValuePin-value", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-AcceptCallAction").getDelegate();
        prop = this.factory.createProperty(clss, "returnInformation", "Actions-CompleteActions-AcceptCallAction-returnInformation", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-AcceptEventAction").getDelegate();
        prop = this.factory.createProperty(clss, "isUnmarshall", "Actions-CompleteActions-AcceptEventAction-isUnmarshall", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Actions-CompleteActions-AcceptEventAction-isUnmarshall-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "result", "Actions-CompleteActions-AcceptEventAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "trigger", "Actions-CompleteActions-AcceptEventAction-trigger", "CommonBehaviors-Communications-Trigger", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-CreateLinkObjectAction").getDelegate();
        prop = this.factory.createProperty(clss, "result", "Actions-CompleteActions-CreateLinkObjectAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-LinkEndData").getDelegate();
        prop = this.factory.createProperty(clss, "qualifier", "Actions-CompleteActions-LinkEndData-qualifier", "Actions-CompleteActions-QualifierValue", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-QualifierValue").getDelegate();
        prop = this.factory.createProperty(clss, "qualifier", "Actions-CompleteActions-QualifierValue-qualifier", "Classes-AssociationClasses-Property", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "value", "Actions-CompleteActions-QualifierValue-value", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-ReadExtentAction").getDelegate();
        prop = this.factory.createProperty(clss, "classifier", "Actions-CompleteActions-ReadExtentAction-classifier", "Classes-Kernel-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "Actions-CompleteActions-ReadExtentAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-ReadIsClassifiedObjectAction").getDelegate();
        prop = this.factory.createProperty(clss, "classifier", "Actions-CompleteActions-ReadIsClassifiedObjectAction-classifier", "Classes-Kernel-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isDirect", "Actions-CompleteActions-ReadIsClassifiedObjectAction-isDirect", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Actions-CompleteActions-ReadIsClassifiedObjectAction-isDirect-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "object", "Actions-CompleteActions-ReadIsClassifiedObjectAction-object", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "Actions-CompleteActions-ReadIsClassifiedObjectAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-ReadLinkObjectEndAction").getDelegate();
        prop = this.factory.createProperty(clss, "end", "Actions-CompleteActions-ReadLinkObjectEndAction-end", "Classes-Kernel-Property", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "object", "Actions-CompleteActions-ReadLinkObjectEndAction-object", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "Actions-CompleteActions-ReadLinkObjectEndAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-ReadLinkObjectEndQualifierAction").getDelegate();
        prop = this.factory.createProperty(clss, "object", "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-object", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "qualifier", "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-qualifier", "Classes-AssociationClasses-Property", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-ReclassifyObjectAction").getDelegate();
        prop = this.factory.createProperty(clss, "isReplaceAll", "Actions-CompleteActions-ReclassifyObjectAction-isReplaceAll", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Actions-CompleteActions-ReclassifyObjectAction-isReplaceAll-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "newClassifier", "Actions-CompleteActions-ReclassifyObjectAction-newClassifier", "Classes-Kernel-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "object", "Actions-CompleteActions-ReclassifyObjectAction-object", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "oldClassifier", "Actions-CompleteActions-ReclassifyObjectAction-oldClassifier", "Classes-Kernel-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-ReduceAction").getDelegate();
        prop = this.factory.createProperty(clss, "collection", "Actions-CompleteActions-ReduceAction-collection", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isOrdered", "Actions-CompleteActions-ReduceAction-isOrdered", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Actions-CompleteActions-ReduceAction-isOrdered-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "reducer", "Actions-CompleteActions-ReduceAction-reducer", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "Actions-CompleteActions-ReduceAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-ReplyAction").getDelegate();
        prop = this.factory.createProperty(clss, "replyToCall", "Actions-CompleteActions-ReplyAction-replyToCall", "CommonBehaviors-Communications-Trigger", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "replyValue", "Actions-CompleteActions-ReplyAction-replyValue", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "returnInformation", "Actions-CompleteActions-ReplyAction-returnInformation", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-StartClassifierBehaviorAction").getDelegate();
        prop = this.factory.createProperty(clss, "object", "Actions-CompleteActions-StartClassifierBehaviorAction-object", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-StartObjectBehaviorAction").getDelegate();
        prop = this.factory.createProperty(clss, "object", "Actions-CompleteActions-StartObjectBehaviorAction-object", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-UnmarshallAction").getDelegate();
        prop = this.factory.createProperty(clss, "object", "Actions-CompleteActions-UnmarshallAction-object", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "Actions-CompleteActions-UnmarshallAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "unmarshallType", "Actions-CompleteActions-UnmarshallAction-unmarshallType", "Classes-Kernel-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-AddStructuralFeatureValueAction").getDelegate();
        prop = this.factory.createProperty(clss, "insertAt", "Actions-IntermediateActions-AddStructuralFeatureValueAction-insertAt", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isReplaceAll", "Actions-IntermediateActions-AddStructuralFeatureValueAction-isReplaceAll", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Actions-IntermediateActions-AddStructuralFeatureValueAction-isReplaceAll-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-BroadcastSignalAction").getDelegate();
        prop = this.factory.createProperty(clss, "signal", "Actions-IntermediateActions-BroadcastSignalAction-signal", "CommonBehaviors-Communications-Signal", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-ClearAssociationAction").getDelegate();
        prop = this.factory.createProperty(clss, "association", "Actions-IntermediateActions-ClearAssociationAction-association", "Classes-Kernel-Association", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "object", "Actions-IntermediateActions-ClearAssociationAction-object", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-ClearStructuralFeatureAction").getDelegate();
        prop = this.factory.createProperty(clss, "result", "Actions-IntermediateActions-ClearStructuralFeatureAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-CreateLinkAction").getDelegate();
        prop = this.factory.createProperty(clss, "endData", "Actions-IntermediateActions-CreateLinkAction-endData", "Actions-IntermediateActions-LinkEndCreationData", "Actions-IntermediateActions-LinkAction-endData", false, false, false);
        this.factory.createLowerValue(prop, true, "2");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-CreateObjectAction").getDelegate();
        prop = this.factory.createProperty(clss, "classifier", "Actions-IntermediateActions-CreateObjectAction-classifier", "Classes-Kernel-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "Actions-IntermediateActions-CreateObjectAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-DestroyLinkAction").getDelegate();
        prop = this.factory.createProperty(clss, "endData", "Actions-IntermediateActions-DestroyLinkAction-endData", "Actions-IntermediateActions-LinkEndDestructionData", "Actions-IntermediateActions-LinkAction-endData", false, false, false);
        this.factory.createLowerValue(prop, true, "2");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-DestroyObjectAction").getDelegate();
        prop = this.factory.createProperty(clss, "isDestroyLinks", "Actions-IntermediateActions-DestroyObjectAction-isDestroyLinks", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Actions-IntermediateActions-DestroyObjectAction-isDestroyLinks-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isDestroyOwnedObjects", "Actions-IntermediateActions-DestroyObjectAction-isDestroyOwnedObjects", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Actions-IntermediateActions-DestroyObjectAction-isDestroyOwnedObjects-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "target", "Actions-IntermediateActions-DestroyObjectAction-target", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-LinkAction").getDelegate();
        prop = this.factory.createProperty(clss, "endData", "Actions-IntermediateActions-LinkAction-endData", "Actions-IntermediateActions-LinkEndData", "", false, false, false);
        this.factory.createLowerValue(prop, true, "2");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inputValue", "Actions-IntermediateActions-LinkAction-inputValue", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-LinkEndCreationData").getDelegate();
        prop = this.factory.createProperty(clss, "insertAt", "Actions-IntermediateActions-LinkEndCreationData-insertAt", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isReplaceAll", "Actions-IntermediateActions-LinkEndCreationData-isReplaceAll", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Actions-IntermediateActions-LinkEndCreationData-isReplaceAll-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-LinkEndData").getDelegate();
        prop = this.factory.createProperty(clss, "end", "Actions-IntermediateActions-LinkEndData-end", "Classes-Kernel-Property", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "value", "Actions-IntermediateActions-LinkEndData-value", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-LinkEndDestructionData").getDelegate();
        prop = this.factory.createProperty(clss, "destroyAt", "Actions-IntermediateActions-LinkEndDestructionData-destroyAt", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isDestroyDuplicates", "Actions-IntermediateActions-LinkEndDestructionData-isDestroyDuplicates", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Actions-IntermediateActions-LinkEndDestructionData-isDestroyDuplicates-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-ReadLinkAction").getDelegate();
        prop = this.factory.createProperty(clss, "result", "Actions-IntermediateActions-ReadLinkAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-ReadSelfAction").getDelegate();
        prop = this.factory.createProperty(clss, "result", "Actions-IntermediateActions-ReadSelfAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-ReadStructuralFeatureAction").getDelegate();
        prop = this.factory.createProperty(clss, "result", "Actions-IntermediateActions-ReadStructuralFeatureAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-RemoveStructuralFeatureValueAction").getDelegate();
        prop = this.factory.createProperty(clss, "isRemoveDuplicates", "Actions-IntermediateActions-RemoveStructuralFeatureValueAction-isRemoveDuplicates", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Actions-IntermediateActions-RemoveStructuralFeatureValueAction-isRemoveDuplicates-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "removeAt", "Actions-IntermediateActions-RemoveStructuralFeatureValueAction-removeAt", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-SendObjectAction").getDelegate();
        prop = this.factory.createProperty(clss, "request", "Actions-IntermediateActions-SendObjectAction-request", "Actions-BasicActions-InputPin", "Actions-BasicActions-InvocationAction-argument", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "target", "Actions-IntermediateActions-SendObjectAction-target", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-StructuralFeatureAction").getDelegate();
        prop = this.factory.createProperty(clss, "object", "Actions-IntermediateActions-StructuralFeatureAction-object", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "structuralFeature", "Actions-IntermediateActions-StructuralFeatureAction-structuralFeature", "Classes-Kernel-StructuralFeature", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-TestIdentityAction").getDelegate();
        prop = this.factory.createProperty(clss, "first", "Actions-IntermediateActions-TestIdentityAction-first", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "Actions-IntermediateActions-TestIdentityAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "second", "Actions-IntermediateActions-TestIdentityAction-second", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-ValueSpecificationAction").getDelegate();
        prop = this.factory.createProperty(clss, "result", "Actions-IntermediateActions-ValueSpecificationAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "value", "Actions-IntermediateActions-ValueSpecificationAction-value", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-WriteLinkAction").getDelegate();
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-WriteStructuralFeatureAction").getDelegate();
        prop = this.factory.createProperty(clss, "result", "Actions-IntermediateActions-WriteStructuralFeatureAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "value", "Actions-IntermediateActions-WriteStructuralFeatureAction-value", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-StructuredActions-ActionInputPin").getDelegate();
        prop = this.factory.createProperty(clss, "fromAction", "Actions-StructuredActions-ActionInputPin-fromAction", "Actions-BasicActions-Action", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-StructuredActions-AddVariableValueAction").getDelegate();
        prop = this.factory.createProperty(clss, "insertAt", "Actions-StructuredActions-AddVariableValueAction-insertAt", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isReplaceAll", "Actions-StructuredActions-AddVariableValueAction-isReplaceAll", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Actions-StructuredActions-AddVariableValueAction-isReplaceAll-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Actions-StructuredActions-ClearVariableAction").getDelegate();
        clss = (Class_)this.model.getElementById("Actions-StructuredActions-RaiseExceptionAction").getDelegate();
        prop = this.factory.createProperty(clss, "exception", "Actions-StructuredActions-RaiseExceptionAction-exception", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-StructuredActions-ReadVariableAction").getDelegate();
        prop = this.factory.createProperty(clss, "result", "Actions-StructuredActions-ReadVariableAction-result", "Actions-BasicActions-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-StructuredActions-RemoveVariableValueAction").getDelegate();
        prop = this.factory.createProperty(clss, "isRemoveDuplicates", "Actions-StructuredActions-RemoveVariableValueAction-isRemoveDuplicates", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Actions-StructuredActions-RemoveVariableValueAction-isRemoveDuplicates-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "removeAt", "Actions-StructuredActions-RemoveVariableValueAction-removeAt", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-StructuredActions-VariableAction").getDelegate();
        prop = this.factory.createProperty(clss, "variable", "Actions-StructuredActions-VariableAction-variable", "Activities-StructuredActivities-Variable", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Actions-StructuredActions-WriteVariableAction").getDelegate();
        prop = this.factory.createProperty(clss, "value", "Actions-StructuredActions-WriteVariableAction-value", "Actions-BasicActions-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-Activity").getDelegate();
        prop = this.factory.createProperty(clss, "edge", "Activities-BasicActivities-Activity-edge", "Activities-BasicActivities-ActivityEdge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isReadOnly", "Activities-BasicActivities-Activity-isReadOnly", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activities-BasicActivities-Activity-isReadOnly-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ActivityEdge").getDelegate();
        prop = this.factory.createProperty(clss, "activity", "Activities-BasicActivities-ActivityEdge-activity", "Activities-BasicActivities-Activity", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inGroup", "Activities-BasicActivities-ActivityEdge-inGroup", "Activities-BasicActivities-ActivityGroup", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedEdge", "Activities-BasicActivities-ActivityEdge-redefinedEdge", "Activities-BasicActivities-ActivityEdge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "source", "Activities-BasicActivities-ActivityEdge-source", "Activities-BasicActivities-ActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "target", "Activities-BasicActivities-ActivityEdge-target", "Activities-BasicActivities-ActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ActivityFinalNode").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ActivityGroup").getDelegate();
        prop = this.factory.createProperty(clss, "containedEdge", "Activities-BasicActivities-ActivityGroup-containedEdge", "Activities-BasicActivities-ActivityEdge", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ActivityNode").getDelegate();
        prop = this.factory.createProperty(clss, "incoming", "Activities-BasicActivities-ActivityNode-incoming", "Activities-BasicActivities-ActivityEdge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "outgoing", "Activities-BasicActivities-ActivityNode-outgoing", "Activities-BasicActivities-ActivityEdge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedNode", "Activities-BasicActivities-ActivityNode-redefinedNode", "Activities-BasicActivities-ActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ActivityParameterNode").getDelegate();
        prop = this.factory.createProperty(clss, "parameter", "Activities-BasicActivities-ActivityParameterNode-parameter", "Classes-Kernel-Parameter", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ControlFlow").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ControlNode").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-InitialNode").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ObjectFlow").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ObjectNode").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-Pin").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ValuePin").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-Action").getDelegate();
        prop = this.factory.createProperty(clss, "localPostcondition", "Activities-CompleteActivities-Action-localPostcondition", "Classes-Kernel-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "localPrecondition", "Activities-CompleteActivities-Action-localPrecondition", "Classes-Kernel-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-Activity").getDelegate();
        prop = this.factory.createProperty(clss, "isSingleExecution", "Activities-CompleteActivities-Activity-isSingleExecution", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activities-CompleteActivities-Activity-isSingleExecution-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-ActivityEdge").getDelegate();
        prop = this.factory.createProperty(clss, "interrupts", "Activities-CompleteActivities-ActivityEdge-interrupts", "Activities-CompleteActivities-InterruptibleActivityRegion", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "weight", "Activities-CompleteActivities-ActivityEdge-weight", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-ActivityGroup").getDelegate();
        prop = this.factory.createProperty(clss, "containedNode", "Activities-CompleteActivities-ActivityGroup-containedNode", "Activities-CompleteActivities-ActivityNode", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-ActivityNode").getDelegate();
        prop = this.factory.createProperty(clss, "inGroup", "Activities-CompleteActivities-ActivityNode-inGroup", "Activities-CompleteActivities-ActivityGroup", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inInterruptibleRegion", "Activities-CompleteActivities-ActivityNode-inInterruptibleRegion", "Activities-CompleteActivities-InterruptibleActivityRegion", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-Behavior").getDelegate();
        prop = this.factory.createProperty(clss, "ownedParameterSet", "Activities-CompleteActivities-Behavior-ownedParameterSet", "Activities-CompleteActivities-ParameterSet", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-BehavioralFeature").getDelegate();
        prop = this.factory.createProperty(clss, "ownedParameterSet", "Activities-CompleteActivities-BehavioralFeature-ownedParameterSet", "Activities-CompleteActivities-ParameterSet", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-DataStoreNode").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-InterruptibleActivityRegion").getDelegate();
        prop = this.factory.createProperty(clss, "interruptingEdge", "Activities-CompleteActivities-InterruptibleActivityRegion-interruptingEdge", "Activities-CompleteActivities-ActivityEdge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "node", "Activities-CompleteActivities-InterruptibleActivityRegion-node", "Activities-CompleteActivities-ActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-JoinNode").getDelegate();
        prop = this.factory.createProperty(clss, "isCombineDuplicate", "Activities-CompleteActivities-JoinNode-isCombineDuplicate", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "Activities-CompleteActivities-JoinNode-isCombineDuplicate-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "joinSpec", "Activities-CompleteActivities-JoinNode-joinSpec", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-ObjectFlow").getDelegate();
        prop = this.factory.createProperty(clss, "isMulticast", "Activities-CompleteActivities-ObjectFlow-isMulticast", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activities-CompleteActivities-ObjectFlow-isMulticast-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isMultireceive", "Activities-CompleteActivities-ObjectFlow-isMultireceive", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activities-CompleteActivities-ObjectFlow-isMultireceive-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "selection", "Activities-CompleteActivities-ObjectFlow-selection", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "transformation", "Activities-CompleteActivities-ObjectFlow-transformation", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-ObjectNode").getDelegate();
        prop = this.factory.createProperty(clss, "inState", "Activities-CompleteActivities-ObjectNode-inState", "StateMachines-BehaviorStateMachines-State", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isControlType", "Activities-CompleteActivities-ObjectNode-isControlType", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activities-CompleteActivities-ObjectNode-isControlType-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "ordering", "Activities-CompleteActivities-ObjectNode-ordering", "Activities-CompleteActivities-ObjectNodeOrderingKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "Activities-CompleteActivities-ObjectNodeOrderingKind-FIFO", "Activities-CompleteActivities-ObjectNode-ordering-_defaultValue", "uml:InstanceValue", "Activities-CompleteActivities-ObjectNodeOrderingKind");
        prop = this.factory.createProperty(clss, "selection", "Activities-CompleteActivities-ObjectNode-selection", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "upperBound", "Activities-CompleteActivities-ObjectNode-upperBound", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-Parameter").getDelegate();
        prop = this.factory.createProperty(clss, "effect", "Activities-CompleteActivities-Parameter-effect", "Activities-CompleteActivities-ParameterEffectKind", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isException", "Activities-CompleteActivities-Parameter-isException", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activities-CompleteActivities-Parameter-isException-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isStream", "Activities-CompleteActivities-Parameter-isStream", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activities-CompleteActivities-Parameter-isStream-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "parameterSet", "Activities-CompleteActivities-Parameter-parameterSet", "Activities-CompleteActivities-ParameterSet", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-ParameterSet").getDelegate();
        prop = this.factory.createProperty(clss, "condition", "Activities-CompleteActivities-ParameterSet-condition", "Classes-Kernel-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "parameter", "Activities-CompleteActivities-ParameterSet-parameter", "Activities-CompleteActivities-Parameter", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-Pin").getDelegate();
        prop = this.factory.createProperty(clss, "isControl", "Activities-CompleteActivities-Pin-isControl", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activities-CompleteActivities-Pin-isControl-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-Action").getDelegate();
        prop = this.factory.createProperty(clss, "input", "Activities-CompleteStructuredActivities-Action-input", "Activities-CompleteStructuredActivities-InputPin", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "output", "Activities-CompleteStructuredActivities-Action-output", "Activities-CompleteStructuredActivities-OutputPin", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-ActivityEdge").getDelegate();
        prop = this.factory.createProperty(clss, "inGroup", "Activities-CompleteStructuredActivities-ActivityEdge-inGroup", "Activities-CompleteStructuredActivities-ActivityGroup", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inStructuredNode", "Activities-CompleteStructuredActivities-ActivityEdge-inStructuredNode", "Activities-CompleteStructuredActivities-StructuredActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-ActivityGroup").getDelegate();
        prop = this.factory.createProperty(clss, "containedEdge", "Activities-CompleteStructuredActivities-ActivityGroup-containedEdge", "Activities-CompleteStructuredActivities-ActivityEdge", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-Clause").getDelegate();
        prop = this.factory.createProperty(clss, "bodyOutput", "Activities-CompleteStructuredActivities-Clause-bodyOutput", "Activities-CompleteStructuredActivities-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-ConditionalNode").getDelegate();
        prop = this.factory.createProperty(clss, "result", "Activities-CompleteStructuredActivities-ConditionalNode-result", "Activities-CompleteStructuredActivities-OutputPin", "Activities-CompleteStructuredActivities-StructuredActivityNode-structuredNodeOutput", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-InputPin").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-LoopNode").getDelegate();
        prop = this.factory.createProperty(clss, "bodyOutput", "Activities-CompleteStructuredActivities-LoopNode-bodyOutput", "Activities-CompleteStructuredActivities-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "loopVariable", "Activities-CompleteStructuredActivities-LoopNode-loopVariable", "Activities-CompleteStructuredActivities-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "loopVariableInput", "Activities-CompleteStructuredActivities-LoopNode-loopVariableInput", "Activities-CompleteStructuredActivities-InputPin", "Activities-CompleteStructuredActivities-StructuredActivityNode-structuredNodeInput", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "Activities-CompleteStructuredActivities-LoopNode-result", "Activities-CompleteStructuredActivities-OutputPin", "Activities-CompleteStructuredActivities-StructuredActivityNode-structuredNodeOutput", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-OutputPin").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-StructuredActivityNode").getDelegate();
        prop = this.factory.createProperty(clss, "edge", "Activities-CompleteStructuredActivities-StructuredActivityNode-edge", "Activities-CompleteStructuredActivities-ActivityEdge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "mustIsolate", "Activities-CompleteStructuredActivities-StructuredActivityNode-mustIsolate", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activities-CompleteStructuredActivities-StructuredActivityNode-mustIsolate-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "structuredNodeInput", "Activities-CompleteStructuredActivities-StructuredActivityNode-structuredNodeInput", "Activities-CompleteStructuredActivities-InputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "structuredNodeOutput", "Activities-CompleteStructuredActivities-StructuredActivityNode-structuredNodeOutput", "Activities-CompleteStructuredActivities-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-ExtraStructuredActivities-ExceptionHandler").getDelegate();
        prop = this.factory.createProperty(clss, "exceptionInput", "Activities-ExtraStructuredActivities-ExceptionHandler-exceptionInput", "Activities-BasicActivities-ObjectNode", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "exceptionType", "Activities-ExtraStructuredActivities-ExceptionHandler-exceptionType", "Classes-Kernel-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "handlerBody", "Activities-ExtraStructuredActivities-ExceptionHandler-handlerBody", "Activities-ExtraStructuredActivities-ExecutableNode", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "protectedNode", "Activities-ExtraStructuredActivities-ExceptionHandler-protectedNode", "Activities-ExtraStructuredActivities-ExecutableNode", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-ExtraStructuredActivities-ExecutableNode").getDelegate();
        prop = this.factory.createProperty(clss, "handler", "Activities-ExtraStructuredActivities-ExecutableNode-handler", "Activities-ExtraStructuredActivities-ExceptionHandler", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-ExtraStructuredActivities-ExpansionNode").getDelegate();
        prop = this.factory.createProperty(clss, "regionAsInput", "Activities-ExtraStructuredActivities-ExpansionNode-regionAsInput", "Activities-ExtraStructuredActivities-ExpansionRegion", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "regionAsOutput", "Activities-ExtraStructuredActivities-ExpansionNode-regionAsOutput", "Activities-ExtraStructuredActivities-ExpansionRegion", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-ExtraStructuredActivities-ExpansionRegion").getDelegate();
        prop = this.factory.createProperty(clss, "inputElement", "Activities-ExtraStructuredActivities-ExpansionRegion-inputElement", "Activities-ExtraStructuredActivities-ExpansionNode", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "mode", "Activities-ExtraStructuredActivities-ExpansionRegion-mode", "Activities-ExtraStructuredActivities-ExpansionKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "Activities-ExtraStructuredActivities-ExpansionKind-iterative", "Activities-ExtraStructuredActivities-ExpansionRegion-mode-_defaultValue", "uml:InstanceValue", "Activities-ExtraStructuredActivities-ExpansionKind");
        prop = this.factory.createProperty(clss, "outputElement", "Activities-ExtraStructuredActivities-ExpansionRegion-outputElement", "Activities-ExtraStructuredActivities-ExpansionNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-FundamentalActivities-Action").getDelegate();
        prop = this.factory.createProperty(clss, "isLocallyReentrant", "Activities-FundamentalActivities-Action-isLocallyReentrant", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activities-FundamentalActivities-Action-isLocallyReentrant-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Activities-FundamentalActivities-Activity").getDelegate();
        prop = this.factory.createProperty(clss, "group", "Activities-FundamentalActivities-Activity-group", "Activities-FundamentalActivities-ActivityGroup", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "node", "Activities-FundamentalActivities-Activity-node", "Activities-FundamentalActivities-ActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-FundamentalActivities-ActivityGroup").getDelegate();
        prop = this.factory.createProperty(clss, "containedNode", "Activities-FundamentalActivities-ActivityGroup-containedNode", "Activities-FundamentalActivities-ActivityNode", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inActivity", "Activities-FundamentalActivities-ActivityGroup-inActivity", "Activities-FundamentalActivities-Activity", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "subgroup", "Activities-FundamentalActivities-ActivityGroup-subgroup", "Activities-FundamentalActivities-ActivityGroup", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "superGroup", "Activities-FundamentalActivities-ActivityGroup-superGroup", "Activities-FundamentalActivities-ActivityGroup", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-FundamentalActivities-ActivityNode").getDelegate();
        prop = this.factory.createProperty(clss, "activity", "Activities-FundamentalActivities-ActivityNode-activity", "Activities-FundamentalActivities-Activity", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inGroup", "Activities-FundamentalActivities-ActivityNode-inGroup", "Activities-FundamentalActivities-ActivityGroup", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-Activity").getDelegate();
        prop = this.factory.createProperty(clss, "group", "Activities-IntermediateActivities-Activity-group", "Activities-IntermediateActivities-ActivityGroup", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "partition", "Activities-IntermediateActivities-Activity-partition", "Activities-IntermediateActivities-ActivityPartition", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-ActivityEdge").getDelegate();
        prop = this.factory.createProperty(clss, "guard", "Activities-IntermediateActivities-ActivityEdge-guard", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inGroup", "Activities-IntermediateActivities-ActivityEdge-inGroup", "Activities-IntermediateActivities-ActivityGroup", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inPartition", "Activities-IntermediateActivities-ActivityEdge-inPartition", "Activities-IntermediateActivities-ActivityPartition", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-ActivityFinalNode").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-ActivityGroup").getDelegate();
        prop = this.factory.createProperty(clss, "containedEdge", "Activities-IntermediateActivities-ActivityGroup-containedEdge", "Activities-IntermediateActivities-ActivityEdge", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "containedNode", "Activities-IntermediateActivities-ActivityGroup-containedNode", "Activities-IntermediateActivities-ActivityNode", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inActivity", "Activities-IntermediateActivities-ActivityGroup-inActivity", "Activities-IntermediateActivities-Activity", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "subgroup", "Activities-IntermediateActivities-ActivityGroup-subgroup", "Activities-IntermediateActivities-ActivityGroup", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "superGroup", "Activities-IntermediateActivities-ActivityGroup-superGroup", "Activities-IntermediateActivities-ActivityGroup", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-ActivityNode").getDelegate();
        prop = this.factory.createProperty(clss, "inGroup", "Activities-IntermediateActivities-ActivityNode-inGroup", "Activities-IntermediateActivities-ActivityGroup", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inPartition", "Activities-IntermediateActivities-ActivityNode-inPartition", "Activities-IntermediateActivities-ActivityPartition", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-ActivityPartition").getDelegate();
        prop = this.factory.createProperty(clss, "edge", "Activities-IntermediateActivities-ActivityPartition-edge", "Activities-IntermediateActivities-ActivityEdge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isDimension", "Activities-IntermediateActivities-ActivityPartition-isDimension", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activities-IntermediateActivities-ActivityPartition-isDimension-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isExternal", "Activities-IntermediateActivities-ActivityPartition-isExternal", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activities-IntermediateActivities-ActivityPartition-isExternal-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "node", "Activities-IntermediateActivities-ActivityPartition-node", "Activities-IntermediateActivities-ActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "represents", "Activities-IntermediateActivities-ActivityPartition-represents", "Classes-Kernel-Element", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "subpartition", "Activities-IntermediateActivities-ActivityPartition-subpartition", "Activities-IntermediateActivities-ActivityPartition", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "superPartition", "Activities-IntermediateActivities-ActivityPartition-superPartition", "Activities-IntermediateActivities-ActivityPartition", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-CentralBufferNode").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-DecisionNode").getDelegate();
        prop = this.factory.createProperty(clss, "decisionInput", "Activities-IntermediateActivities-DecisionNode-decisionInput", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "decisionInputFlow", "Activities-IntermediateActivities-DecisionNode-decisionInputFlow", "Activities-BasicActivities-ObjectFlow", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-FinalNode").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-FlowFinalNode").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-ForkNode").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-JoinNode").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-MergeNode").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-Action").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-Activity").getDelegate();
        prop = this.factory.createProperty(clss, "group", "Activities-StructuredActivities-Activity-group", "Activities-StructuredActivities-ActivityGroup", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "node", "Activities-StructuredActivities-Activity-node", "Activities-StructuredActivities-ActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "structuredNode", "Activities-StructuredActivities-Activity-structuredNode", "Activities-StructuredActivities-StructuredActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "variable", "Activities-StructuredActivities-Activity-variable", "Activities-StructuredActivities-Variable", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-ActivityGroup").getDelegate();
        prop = this.factory.createProperty(clss, "containedNode", "Activities-StructuredActivities-ActivityGroup-containedNode", "Activities-StructuredActivities-ActivityNode", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inActivity", "Activities-StructuredActivities-ActivityGroup-inActivity", "Activities-StructuredActivities-Activity", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-ActivityNode").getDelegate();
        prop = this.factory.createProperty(clss, "activity", "Activities-StructuredActivities-ActivityNode-activity", "Activities-StructuredActivities-Activity", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inGroup", "Activities-StructuredActivities-ActivityNode-inGroup", "Activities-StructuredActivities-ActivityGroup", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inStructuredNode", "Activities-StructuredActivities-ActivityNode-inStructuredNode", "Activities-StructuredActivities-StructuredActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-Clause").getDelegate();
        prop = this.factory.createProperty(clss, "body", "Activities-StructuredActivities-Clause-body", "Activities-StructuredActivities-ExecutableNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "decider", "Activities-StructuredActivities-Clause-decider", "Activities-StructuredActivities-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "predecessorClause", "Activities-StructuredActivities-Clause-predecessorClause", "Activities-StructuredActivities-Clause", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "successorClause", "Activities-StructuredActivities-Clause-successorClause", "Activities-StructuredActivities-Clause", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "test", "Activities-StructuredActivities-Clause-test", "Activities-StructuredActivities-ExecutableNode", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-ConditionalNode").getDelegate();
        prop = this.factory.createProperty(clss, "clause", "Activities-StructuredActivities-ConditionalNode-clause", "Activities-StructuredActivities-Clause", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isAssured", "Activities-StructuredActivities-ConditionalNode-isAssured", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activities-StructuredActivities-ConditionalNode-isAssured-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isDeterminate", "Activities-StructuredActivities-ConditionalNode-isDeterminate", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activities-StructuredActivities-ConditionalNode-isDeterminate-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-ExecutableNode").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-LoopNode").getDelegate();
        prop = this.factory.createProperty(clss, "bodyPart", "Activities-StructuredActivities-LoopNode-bodyPart", "Activities-StructuredActivities-ExecutableNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "decider", "Activities-StructuredActivities-LoopNode-decider", "Activities-StructuredActivities-OutputPin", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isTestedFirst", "Activities-StructuredActivities-LoopNode-isTestedFirst", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Activities-StructuredActivities-LoopNode-isTestedFirst-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "setupPart", "Activities-StructuredActivities-LoopNode-setupPart", "Activities-StructuredActivities-ExecutableNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "test", "Activities-StructuredActivities-LoopNode-test", "Activities-StructuredActivities-ExecutableNode", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-OutputPin").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-SequenceNode").getDelegate();
        prop = this.factory.createProperty(clss, "executableNode", "Activities-StructuredActivities-SequenceNode-executableNode", "Activities-StructuredActivities-ExecutableNode", "Activities-StructuredActivities-StructuredActivityNode-node", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-StructuredActivityNode").getDelegate();
        prop = this.factory.createProperty(clss, "activity", "Activities-StructuredActivities-StructuredActivityNode-activity", "Activities-StructuredActivities-Activity", "Activities-StructuredActivities-ActivityGroup-inActivity Activities-StructuredActivities-ActivityNode-activity", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "node", "Activities-StructuredActivities-StructuredActivityNode-node", "Activities-StructuredActivities-ActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "variable", "Activities-StructuredActivities-StructuredActivityNode-variable", "Activities-StructuredActivities-Variable", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-Variable").getDelegate();
        prop = this.factory.createProperty(clss, "activityScope", "Activities-StructuredActivities-Variable-activityScope", "Activities-StructuredActivities-Activity", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "scope", "Activities-StructuredActivities-Variable-scope", "Activities-StructuredActivities-StructuredActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-InformationFlows-InformationFlow").getDelegate();
        prop = this.factory.createProperty(clss, "conveyed", "AuxiliaryConstructs-InformationFlows-InformationFlow-conveyed", "Classes-Kernel-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "informationSource", "AuxiliaryConstructs-InformationFlows-InformationFlow-informationSource", "Classes-Kernel-NamedElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "informationTarget", "AuxiliaryConstructs-InformationFlows-InformationFlow-informationTarget", "Classes-Kernel-NamedElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "realization", "AuxiliaryConstructs-InformationFlows-InformationFlow-realization", "Classes-Kernel-Relationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "realizingActivityEdge", "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingActivityEdge", "Activities-BasicActivities-ActivityEdge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "realizingConnector", "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingConnector", "CompositeStructures-InternalStructures-Connector", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "realizingMessage", "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingMessage", "Interactions-BasicInteractions-Message", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-InformationFlows-InformationItem").getDelegate();
        prop = this.factory.createProperty(clss, "represented", "AuxiliaryConstructs-InformationFlows-InformationItem-represented", "Classes-Kernel-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Models-Model").getDelegate();
        prop = this.factory.createProperty(clss, "viewpoint", "AuxiliaryConstructs-Models-Model-viewpoint", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Profiles-ExtensionEnd").getDelegate();
        prop = this.factory.createProperty(clss, "lower", "AuxiliaryConstructs-Profiles-ExtensionEnd-lower", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Integer", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-Classifier").getDelegate();
        prop = this.factory.createProperty(clss, "ownedTemplateSignature", "AuxiliaryConstructs-Templates-Classifier-ownedTemplateSignature", "AuxiliaryConstructs-Templates-RedefinableTemplateSignature", "AuxiliaryConstructs-Templates-TemplateableElement-ownedTemplateSignature", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "templateParameter", "AuxiliaryConstructs-Templates-Classifier-templateParameter", "AuxiliaryConstructs-Templates-ClassifierTemplateParameter", "AuxiliaryConstructs-Templates-ParameterableElement-templateParameter", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-ClassifierTemplateParameter").getDelegate();
        prop = this.factory.createProperty(clss, "allowSubstitutable", "AuxiliaryConstructs-Templates-ClassifierTemplateParameter-allowSubstitutable", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "AuxiliaryConstructs-Templates-ClassifierTemplateParameter-allowSubstitutable-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "constrainingClassifier", "AuxiliaryConstructs-Templates-ClassifierTemplateParameter-constrainingClassifier", "AuxiliaryConstructs-Templates-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "parameteredElement", "AuxiliaryConstructs-Templates-ClassifierTemplateParameter-parameteredElement", "AuxiliaryConstructs-Templates-Classifier", "AuxiliaryConstructs-Templates-TemplateParameter-parameteredElement", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-ConnectableElement").getDelegate();
        prop = this.factory.createProperty(clss, "templateParameter", "AuxiliaryConstructs-Templates-ConnectableElement-templateParameter", "AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter", "AuxiliaryConstructs-Templates-ParameterableElement-templateParameter", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter").getDelegate();
        prop = this.factory.createProperty(clss, "parameteredElement", "AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter-parameteredElement", "AuxiliaryConstructs-Templates-ConnectableElement", "AuxiliaryConstructs-Templates-TemplateParameter-parameteredElement", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-NamedElement").getDelegate();
        prop = this.factory.createProperty(clss, "nameExpression", "AuxiliaryConstructs-Templates-NamedElement-nameExpression", "AuxiliaryConstructs-Templates-StringExpression", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-Operation").getDelegate();
        prop = this.factory.createProperty(clss, "templateParameter", "AuxiliaryConstructs-Templates-Operation-templateParameter", "AuxiliaryConstructs-Templates-OperationTemplateParameter", "AuxiliaryConstructs-Templates-ParameterableElement-templateParameter", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-OperationTemplateParameter").getDelegate();
        prop = this.factory.createProperty(clss, "parameteredElement", "AuxiliaryConstructs-Templates-OperationTemplateParameter-parameteredElement", "AuxiliaryConstructs-Templates-Operation", "AuxiliaryConstructs-Templates-TemplateParameter-parameteredElement", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-Package").getDelegate();
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-PackageableElement").getDelegate();
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-ParameterableElement").getDelegate();
        prop = this.factory.createProperty(clss, "owningTemplateParameter", "AuxiliaryConstructs-Templates-ParameterableElement-owningTemplateParameter", "AuxiliaryConstructs-Templates-TemplateParameter", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "templateParameter", "AuxiliaryConstructs-Templates-ParameterableElement-templateParameter", "AuxiliaryConstructs-Templates-TemplateParameter", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-Property").getDelegate();
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-RedefinableElement").getDelegate();
        prop = this.factory.createProperty(clss, "redefinitionContext", "AuxiliaryConstructs-Templates-RedefinableElement-redefinitionContext", "AuxiliaryConstructs-Templates-Classifier", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-RedefinableTemplateSignature").getDelegate();
        prop = this.factory.createProperty(clss, "classifier", "AuxiliaryConstructs-Templates-RedefinableTemplateSignature-classifier", "AuxiliaryConstructs-Templates-Classifier", "AuxiliaryConstructs-Templates-TemplateSignature-template", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "extendedSignature", "AuxiliaryConstructs-Templates-RedefinableTemplateSignature-extendedSignature", "AuxiliaryConstructs-Templates-RedefinableTemplateSignature", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inheritedParameter", "AuxiliaryConstructs-Templates-RedefinableTemplateSignature-inheritedParameter", "AuxiliaryConstructs-Templates-TemplateParameter", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-StringExpression").getDelegate();
        prop = this.factory.createProperty(clss, "owningExpression", "AuxiliaryConstructs-Templates-StringExpression-owningExpression", "AuxiliaryConstructs-Templates-StringExpression", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "subExpression", "AuxiliaryConstructs-Templates-StringExpression-subExpression", "AuxiliaryConstructs-Templates-StringExpression", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-TemplateBinding").getDelegate();
        prop = this.factory.createProperty(clss, "boundElement", "AuxiliaryConstructs-Templates-TemplateBinding-boundElement", "AuxiliaryConstructs-Templates-TemplateableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "parameterSubstitution", "AuxiliaryConstructs-Templates-TemplateBinding-parameterSubstitution", "AuxiliaryConstructs-Templates-TemplateParameterSubstitution", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "signature", "AuxiliaryConstructs-Templates-TemplateBinding-signature", "AuxiliaryConstructs-Templates-TemplateSignature", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-TemplateParameter").getDelegate();
        prop = this.factory.createProperty(clss, "default", "AuxiliaryConstructs-Templates-TemplateParameter-default", "AuxiliaryConstructs-Templates-ParameterableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedDefault", "AuxiliaryConstructs-Templates-TemplateParameter-ownedDefault", "AuxiliaryConstructs-Templates-ParameterableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedParameteredElement", "AuxiliaryConstructs-Templates-TemplateParameter-ownedParameteredElement", "AuxiliaryConstructs-Templates-ParameterableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "parameteredElement", "AuxiliaryConstructs-Templates-TemplateParameter-parameteredElement", "AuxiliaryConstructs-Templates-ParameterableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "signature", "AuxiliaryConstructs-Templates-TemplateParameter-signature", "AuxiliaryConstructs-Templates-TemplateSignature", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-TemplateParameterSubstitution").getDelegate();
        prop = this.factory.createProperty(clss, "actual", "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-actual", "AuxiliaryConstructs-Templates-ParameterableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "formal", "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-formal", "AuxiliaryConstructs-Templates-TemplateParameter", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedActual", "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-ownedActual", "AuxiliaryConstructs-Templates-ParameterableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "templateBinding", "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-templateBinding", "AuxiliaryConstructs-Templates-TemplateBinding", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-TemplateSignature").getDelegate();
        prop = this.factory.createProperty(clss, "ownedParameter", "AuxiliaryConstructs-Templates-TemplateSignature-ownedParameter", "AuxiliaryConstructs-Templates-TemplateParameter", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "parameter", "AuxiliaryConstructs-Templates-TemplateSignature-parameter", "AuxiliaryConstructs-Templates-TemplateParameter", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "template", "AuxiliaryConstructs-Templates-TemplateSignature-template", "AuxiliaryConstructs-Templates-TemplateableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-TemplateableElement").getDelegate();
        prop = this.factory.createProperty(clss, "ownedTemplateSignature", "AuxiliaryConstructs-Templates-TemplateableElement-ownedTemplateSignature", "AuxiliaryConstructs-Templates-TemplateSignature", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "templateBinding", "AuxiliaryConstructs-Templates-TemplateableElement-templateBinding", "AuxiliaryConstructs-Templates-TemplateBinding", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-ValueSpecification").getDelegate();
        clss = (Class_)this.model.getElementById("Classes-AssociationClasses-AssociationClass").getDelegate();
        clss = (Class_)this.model.getElementById("Classes-AssociationClasses-Property").getDelegate();
        prop = this.factory.createProperty(clss, "associationEnd", "Classes-AssociationClasses-Property-associationEnd", "Classes-AssociationClasses-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "qualifier", "Classes-AssociationClasses-Property-qualifier", "Classes-AssociationClasses-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Dependencies-Abstraction").getDelegate();
        prop = this.factory.createProperty(clss, "mapping", "Classes-Dependencies-Abstraction-mapping", "Classes-Kernel-OpaqueExpression", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Dependencies-Classifier").getDelegate();
        prop = this.factory.createProperty(clss, "substitution", "Classes-Dependencies-Classifier-substitution", "Classes-Dependencies-Substitution", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Dependencies-Dependency").getDelegate();
        prop = this.factory.createProperty(clss, "client", "Classes-Dependencies-Dependency-client", "Classes-Dependencies-NamedElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "supplier", "Classes-Dependencies-Dependency-supplier", "Classes-Dependencies-NamedElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Dependencies-NamedElement").getDelegate();
        prop = this.factory.createProperty(clss, "clientDependency", "Classes-Dependencies-NamedElement-clientDependency", "Classes-Dependencies-Dependency", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "namespace", "Classes-Dependencies-NamedElement-namespace", "Classes-Dependencies-Namespace", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Dependencies-Namespace").getDelegate();
        prop = this.factory.createProperty(clss, "ownedMember", "Classes-Dependencies-Namespace-ownedMember", "Classes-Dependencies-NamedElement", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Dependencies-PackageableElement").getDelegate();
        clss = (Class_)this.model.getElementById("Classes-Dependencies-Realization").getDelegate();
        clss = (Class_)this.model.getElementById("Classes-Dependencies-Substitution").getDelegate();
        prop = this.factory.createProperty(clss, "contract", "Classes-Dependencies-Substitution-contract", "Classes-Dependencies-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "substitutingClassifier", "Classes-Dependencies-Substitution-substitutingClassifier", "Classes-Dependencies-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Dependencies-Usage").getDelegate();
        clss = (Class_)this.model.getElementById("Classes-Interfaces-BehavioredClassifier").getDelegate();
        prop = this.factory.createProperty(clss, "interfaceRealization", "Classes-Interfaces-BehavioredClassifier-interfaceRealization", "Classes-Interfaces-InterfaceRealization", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Interfaces-Classifier").getDelegate();
        prop = this.factory.createProperty(clss, "attribute", "Classes-Interfaces-Classifier-attribute", "Classes-Interfaces-Property", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Interfaces-Interface").getDelegate();
        prop = this.factory.createProperty(clss, "nestedClassifier", "Classes-Interfaces-Interface-nestedClassifier", "Classes-Kernel-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedAttribute", "Classes-Interfaces-Interface-ownedAttribute", "Classes-Interfaces-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedOperation", "Classes-Interfaces-Interface-ownedOperation", "Classes-Interfaces-Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedInterface", "Classes-Interfaces-Interface-redefinedInterface", "Classes-Interfaces-Interface", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Interfaces-InterfaceRealization").getDelegate();
        prop = this.factory.createProperty(clss, "contract", "Classes-Interfaces-InterfaceRealization-contract", "Classes-Interfaces-Interface", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "implementingClassifier", "Classes-Interfaces-InterfaceRealization-implementingClassifier", "Classes-Interfaces-BehavioredClassifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Interfaces-Operation").getDelegate();
        prop = this.factory.createProperty(clss, "interface", "Classes-Interfaces-Operation-interface", "Classes-Interfaces-Interface", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Interfaces-Property").getDelegate();
        prop = this.factory.createProperty(clss, "interface", "Classes-Interfaces-Property-interface", "Classes-Interfaces-Interface", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-Association").getDelegate();
        prop = this.factory.createProperty(clss, "endType", "Classes-Kernel-Association-endType", "Classes-Kernel-Type", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isDerived", "Classes-Kernel-Association-isDerived", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-Kernel-Association-isDerived-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "memberEnd", "Classes-Kernel-Association-memberEnd", "Classes-Kernel-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "2");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "navigableOwnedEnd", "Classes-Kernel-Association-navigableOwnedEnd", "Classes-Kernel-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedEnd", "Classes-Kernel-Association-ownedEnd", "Classes-Kernel-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-BehavioralFeature").getDelegate();
        prop = this.factory.createProperty(clss, "ownedParameter", "Classes-Kernel-BehavioralFeature-ownedParameter", "Classes-Kernel-Parameter", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "raisedException", "Classes-Kernel-BehavioralFeature-raisedException", "Classes-Kernel-Type", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-Class").getDelegate();
        prop = this.factory.createProperty(clss, "isAbstract", "Classes-Kernel-Class-isAbstract", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "Classes-Kernel-Classifier-isAbstract", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-Kernel-Class-isAbstract-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "nestedClassifier", "Classes-Kernel-Class-nestedClassifier", "Classes-Kernel-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedAttribute", "Classes-Kernel-Class-ownedAttribute", "Classes-Kernel-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedOperation", "Classes-Kernel-Class-ownedOperation", "Classes-Kernel-Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "superClass", "Classes-Kernel-Class-superClass", "Classes-Kernel-Class", "Classes-Kernel-Classifier-general", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-Classifier").getDelegate();
        prop = this.factory.createProperty(clss, "attribute", "Classes-Kernel-Classifier-attribute", "Classes-Kernel-Property", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "feature", "Classes-Kernel-Classifier-feature", "Classes-Kernel-Feature", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "general", "Classes-Kernel-Classifier-general", "Classes-Kernel-Classifier", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "generalization", "Classes-Kernel-Classifier-generalization", "Classes-Kernel-Generalization", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inheritedMember", "Classes-Kernel-Classifier-inheritedMember", "Classes-Kernel-NamedElement", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isAbstract", "Classes-Kernel-Classifier-isAbstract", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-Kernel-Classifier-isAbstract-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isFinalSpecialization", "Classes-Kernel-Classifier-isFinalSpecialization", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-Kernel-Classifier-isFinalSpecialization-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "redefinedClassifier", "Classes-Kernel-Classifier-redefinedClassifier", "Classes-Kernel-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-Comment").getDelegate();
        prop = this.factory.createProperty(clss, "annotatedElement", "Classes-Kernel-Comment-annotatedElement", "Classes-Kernel-Element", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "body", "Classes-Kernel-Comment-body", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-Constraint").getDelegate();
        prop = this.factory.createProperty(clss, "constrainedElement", "Classes-Kernel-Constraint-constrainedElement", "Classes-Kernel-Element", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "context", "Classes-Kernel-Constraint-context", "Classes-Kernel-Namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "specification", "Classes-Kernel-Constraint-specification", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-DataType").getDelegate();
        prop = this.factory.createProperty(clss, "ownedAttribute", "Classes-Kernel-DataType-ownedAttribute", "Classes-Kernel-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedOperation", "Classes-Kernel-DataType-ownedOperation", "Classes-Kernel-Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-DirectedRelationship").getDelegate();
        prop = this.factory.createProperty(clss, "source", "Classes-Kernel-DirectedRelationship-source", "Classes-Kernel-Element", "", true, true, true);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "target", "Classes-Kernel-DirectedRelationship-target", "Classes-Kernel-Element", "", true, true, true);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-Element").getDelegate();
        prop = this.factory.createProperty(clss, "ownedComment", "Classes-Kernel-Element-ownedComment", "Classes-Kernel-Comment", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedElement", "Classes-Kernel-Element-ownedElement", "Classes-Kernel-Element", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "owner", "Classes-Kernel-Element-owner", "Classes-Kernel-Element", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-ElementImport").getDelegate();
        prop = this.factory.createProperty(clss, "alias", "Classes-Kernel-ElementImport-alias", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "importedElement", "Classes-Kernel-ElementImport-importedElement", "Classes-Kernel-PackageableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "importingNamespace", "Classes-Kernel-ElementImport-importingNamespace", "Classes-Kernel-Namespace", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "visibility", "Classes-Kernel-ElementImport-visibility", "Classes-Kernel-VisibilityKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "Classes-Kernel-VisibilityKind-public", "Classes-Kernel-ElementImport-visibility-_defaultValue", "uml:InstanceValue", "Classes-Kernel-VisibilityKind");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Enumeration").getDelegate();
        prop = this.factory.createProperty(clss, "ownedLiteral", "Classes-Kernel-Enumeration-ownedLiteral", "Classes-Kernel-EnumerationLiteral", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-EnumerationLiteral").getDelegate();
        prop = this.factory.createProperty(clss, "classifier", "Classes-Kernel-EnumerationLiteral-classifier", "Classes-Kernel-Enumeration", "Classes-Kernel-InstanceSpecification-classifier", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "enumeration", "Classes-Kernel-EnumerationLiteral-enumeration", "Classes-Kernel-Enumeration", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-Expression").getDelegate();
        prop = this.factory.createProperty(clss, "operand", "Classes-Kernel-Expression-operand", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "symbol", "Classes-Kernel-Expression-symbol", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-Feature").getDelegate();
        prop = this.factory.createProperty(clss, "featuringClassifier", "Classes-Kernel-Feature-featuringClassifier", "Classes-Kernel-Classifier", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isStatic", "Classes-Kernel-Feature-isStatic", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-Kernel-Feature-isStatic-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Generalization").getDelegate();
        prop = this.factory.createProperty(clss, "general", "Classes-Kernel-Generalization-general", "Classes-Kernel-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isSubstitutable", "Classes-Kernel-Generalization-isSubstitutable", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "Classes-Kernel-Generalization-isSubstitutable-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "specific", "Classes-Kernel-Generalization-specific", "Classes-Kernel-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-InstanceSpecification").getDelegate();
        prop = this.factory.createProperty(clss, "classifier", "Classes-Kernel-InstanceSpecification-classifier", "Classes-Kernel-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "slot", "Classes-Kernel-InstanceSpecification-slot", "Classes-Kernel-Slot", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "specification", "Classes-Kernel-InstanceSpecification-specification", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-InstanceValue").getDelegate();
        prop = this.factory.createProperty(clss, "instance", "Classes-Kernel-InstanceValue-instance", "Classes-Kernel-InstanceSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-LiteralBoolean").getDelegate();
        prop = this.factory.createProperty(clss, "value", "Classes-Kernel-LiteralBoolean-value", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-Kernel-LiteralBoolean-value-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Classes-Kernel-LiteralInteger").getDelegate();
        prop = this.factory.createProperty(clss, "value", "Classes-Kernel-LiteralInteger-value", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Integer", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Integer(0), "", "Classes-Kernel-LiteralInteger-value-_defaultValue", "uml:LiteralInteger", "");
        clss = (Class_)this.model.getElementById("Classes-Kernel-LiteralNull").getDelegate();
        clss = (Class_)this.model.getElementById("Classes-Kernel-LiteralReal").getDelegate();
        prop = this.factory.createProperty(clss, "value", "Classes-Kernel-LiteralReal-value", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Real", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-LiteralSpecification").getDelegate();
        clss = (Class_)this.model.getElementById("Classes-Kernel-LiteralString").getDelegate();
        prop = this.factory.createProperty(clss, "value", "Classes-Kernel-LiteralString-value", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-LiteralUnlimitedNatural").getDelegate();
        prop = this.factory.createProperty(clss, "value", "Classes-Kernel-LiteralUnlimitedNatural-value", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#UnlimitedNatural", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "", "Classes-Kernel-LiteralUnlimitedNatural-value-_defaultValue", "uml:LiteralUnlimitedNatural", "");
        clss = (Class_)this.model.getElementById("Classes-Kernel-MultiplicityElement").getDelegate();
        prop = this.factory.createProperty(clss, "isOrdered", "Classes-Kernel-MultiplicityElement-isOrdered", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-Kernel-MultiplicityElement-isOrdered-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isUnique", "Classes-Kernel-MultiplicityElement-isUnique", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "Classes-Kernel-MultiplicityElement-isUnique-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "lower", "Classes-Kernel-MultiplicityElement-lower", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Integer", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Integer(1), "", "Classes-Kernel-MultiplicityElement-lower-_defaultValue", "uml:LiteralInteger", "");
        prop = this.factory.createProperty(clss, "lowerValue", "Classes-Kernel-MultiplicityElement-lowerValue", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "upper", "Classes-Kernel-MultiplicityElement-upper", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#UnlimitedNatural", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String("1"), "", "Classes-Kernel-MultiplicityElement-upper-_defaultValue", "uml:LiteralUnlimitedNatural", "");
        prop = this.factory.createProperty(clss, "upperValue", "Classes-Kernel-MultiplicityElement-upperValue", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-NamedElement").getDelegate();
        prop = this.factory.createProperty(clss, "name", "Classes-Kernel-NamedElement-name", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "namespace", "Classes-Kernel-NamedElement-namespace", "Classes-Kernel-Namespace", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "qualifiedName", "Classes-Kernel-NamedElement-qualifiedName", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "visibility", "Classes-Kernel-NamedElement-visibility", "Classes-Kernel-VisibilityKind", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-Namespace").getDelegate();
        prop = this.factory.createProperty(clss, "elementImport", "Classes-Kernel-Namespace-elementImport", "Classes-Kernel-ElementImport", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "importedMember", "Classes-Kernel-Namespace-importedMember", "Classes-Kernel-PackageableElement", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "member", "Classes-Kernel-Namespace-member", "Classes-Kernel-NamedElement", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedMember", "Classes-Kernel-Namespace-ownedMember", "Classes-Kernel-NamedElement", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedRule", "Classes-Kernel-Namespace-ownedRule", "Classes-Kernel-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "packageImport", "Classes-Kernel-Namespace-packageImport", "Classes-Kernel-PackageImport", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-OpaqueExpression").getDelegate();
        prop = this.factory.createProperty(clss, "body", "Classes-Kernel-OpaqueExpression-body", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "language", "Classes-Kernel-OpaqueExpression-language", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-Operation").getDelegate();
        prop = this.factory.createProperty(clss, "bodyCondition", "Classes-Kernel-Operation-bodyCondition", "Classes-Kernel-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "class", "Classes-Kernel-Operation-class", "Classes-Kernel-Class", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "datatype", "Classes-Kernel-Operation-datatype", "Classes-Kernel-DataType", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isOrdered", "Classes-Kernel-Operation-isOrdered", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-Kernel-Operation-isOrdered-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isQuery", "Classes-Kernel-Operation-isQuery", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-Kernel-Operation-isQuery-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isUnique", "Classes-Kernel-Operation-isUnique", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "Classes-Kernel-Operation-isUnique-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "lower", "Classes-Kernel-Operation-lower", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Integer", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Integer(1), "", "Classes-Kernel-Operation-lower-_defaultValue", "uml:LiteralInteger", "");
        prop = this.factory.createProperty(clss, "ownedParameter", "Classes-Kernel-Operation-ownedParameter", "Classes-Kernel-Parameter", "Classes-Kernel-BehavioralFeature-ownedParameter", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "postcondition", "Classes-Kernel-Operation-postcondition", "Classes-Kernel-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "precondition", "Classes-Kernel-Operation-precondition", "Classes-Kernel-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "raisedException", "Classes-Kernel-Operation-raisedException", "Classes-Kernel-Type", "Classes-Kernel-BehavioralFeature-raisedException", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedOperation", "Classes-Kernel-Operation-redefinedOperation", "Classes-Kernel-Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "type", "Classes-Kernel-Operation-type", "Classes-Kernel-Type", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "upper", "Classes-Kernel-Operation-upper", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#UnlimitedNatural", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String("1"), "", "Classes-Kernel-Operation-upper-_defaultValue", "uml:LiteralUnlimitedNatural", "");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Package").getDelegate();
        prop = this.factory.createProperty(clss, "URI", "Classes-Kernel-Package-URI", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "nestedPackage", "Classes-Kernel-Package-nestedPackage", "Classes-Kernel-Package", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "nestingPackage", "Classes-Kernel-Package-nestingPackage", "Classes-Kernel-Package", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedType", "Classes-Kernel-Package-ownedType", "Classes-Kernel-Type", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "packageMerge", "Classes-Kernel-Package-packageMerge", "Classes-Kernel-PackageMerge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "packagedElement", "Classes-Kernel-Package-packagedElement", "Classes-Kernel-PackageableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-PackageImport").getDelegate();
        prop = this.factory.createProperty(clss, "importedPackage", "Classes-Kernel-PackageImport-importedPackage", "Classes-Kernel-Package", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "importingNamespace", "Classes-Kernel-PackageImport-importingNamespace", "Classes-Kernel-Namespace", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "visibility", "Classes-Kernel-PackageImport-visibility", "Classes-Kernel-VisibilityKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "Classes-Kernel-VisibilityKind-public", "Classes-Kernel-PackageImport-visibility-_defaultValue", "uml:InstanceValue", "Classes-Kernel-VisibilityKind");
        clss = (Class_)this.model.getElementById("Classes-Kernel-PackageMerge").getDelegate();
        prop = this.factory.createProperty(clss, "mergedPackage", "Classes-Kernel-PackageMerge-mergedPackage", "Classes-Kernel-Package", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "receivingPackage", "Classes-Kernel-PackageMerge-receivingPackage", "Classes-Kernel-Package", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-PackageableElement").getDelegate();
        prop = this.factory.createProperty(clss, "visibility", "Classes-Kernel-PackageableElement-visibility", "Classes-Kernel-VisibilityKind", "Classes-Kernel-NamedElement-visibility", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "Classes-Kernel-VisibilityKind-public", "Classes-Kernel-PackageableElement-visibility-_defaultValue", "uml:InstanceValue", "Classes-Kernel-VisibilityKind");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Parameter").getDelegate();
        prop = this.factory.createProperty(clss, "default", "Classes-Kernel-Parameter-default", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "defaultValue", "Classes-Kernel-Parameter-defaultValue", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "direction", "Classes-Kernel-Parameter-direction", "Classes-Kernel-ParameterDirectionKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "Classes-Kernel-ParameterDirectionKind-in", "Classes-Kernel-Parameter-direction-_defaultValue", "uml:InstanceValue", "Classes-Kernel-ParameterDirectionKind");
        prop = this.factory.createProperty(clss, "operation", "Classes-Kernel-Parameter-operation", "Classes-Kernel-Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-PrimitiveType").getDelegate();
        clss = (Class_)this.model.getElementById("Classes-Kernel-Property").getDelegate();
        prop = this.factory.createProperty(clss, "aggregation", "Classes-Kernel-Property-aggregation", "Classes-Kernel-AggregationKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "Classes-Kernel-AggregationKind-none", "Classes-Kernel-Property-aggregation-_defaultValue", "uml:InstanceValue", "Classes-Kernel-AggregationKind");
        prop = this.factory.createProperty(clss, "association", "Classes-Kernel-Property-association", "Classes-Kernel-Association", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "class", "Classes-Kernel-Property-class", "Classes-Kernel-Class", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "datatype", "Classes-Kernel-Property-datatype", "Classes-Kernel-DataType", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "default", "Classes-Kernel-Property-default", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "defaultValue", "Classes-Kernel-Property-defaultValue", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isComposite", "Classes-Kernel-Property-isComposite", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isDerived", "Classes-Kernel-Property-isDerived", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-Kernel-Property-isDerived-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isDerivedUnion", "Classes-Kernel-Property-isDerivedUnion", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-Kernel-Property-isDerivedUnion-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isID", "Classes-Kernel-Property-isID", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-Kernel-Property-isID-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isReadOnly", "Classes-Kernel-Property-isReadOnly", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "Classes-Kernel-StructuralFeature-isReadOnly", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-Kernel-Property-isReadOnly-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "opposite", "Classes-Kernel-Property-opposite", "Classes-Kernel-Property", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "owningAssociation", "Classes-Kernel-Property-owningAssociation", "Classes-Kernel-Association", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedProperty", "Classes-Kernel-Property-redefinedProperty", "Classes-Kernel-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "subsettedProperty", "Classes-Kernel-Property-subsettedProperty", "Classes-Kernel-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-RedefinableElement").getDelegate();
        prop = this.factory.createProperty(clss, "isLeaf", "Classes-Kernel-RedefinableElement-isLeaf", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-Kernel-RedefinableElement-isLeaf-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "redefinedElement", "Classes-Kernel-RedefinableElement-redefinedElement", "Classes-Kernel-RedefinableElement", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinitionContext", "Classes-Kernel-RedefinableElement-redefinitionContext", "Classes-Kernel-Classifier", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-Relationship").getDelegate();
        prop = this.factory.createProperty(clss, "relatedElement", "Classes-Kernel-Relationship-relatedElement", "Classes-Kernel-Element", "", true, true, true);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-Slot").getDelegate();
        prop = this.factory.createProperty(clss, "definingFeature", "Classes-Kernel-Slot-definingFeature", "Classes-Kernel-StructuralFeature", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "owningInstance", "Classes-Kernel-Slot-owningInstance", "Classes-Kernel-InstanceSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "value", "Classes-Kernel-Slot-value", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-StructuralFeature").getDelegate();
        prop = this.factory.createProperty(clss, "isReadOnly", "Classes-Kernel-StructuralFeature-isReadOnly", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-Kernel-StructuralFeature-isReadOnly-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Type").getDelegate();
        prop = this.factory.createProperty(clss, "package", "Classes-Kernel-Type-package", "Classes-Kernel-Package", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-TypedElement").getDelegate();
        prop = this.factory.createProperty(clss, "type", "Classes-Kernel-TypedElement-type", "Classes-Kernel-Type", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-Kernel-ValueSpecification").getDelegate();
        clss = (Class_)this.model.getElementById("Classes-PowerTypes-Classifier").getDelegate();
        prop = this.factory.createProperty(clss, "powertypeExtent", "Classes-PowerTypes-Classifier-powertypeExtent", "Classes-PowerTypes-GeneralizationSet", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-PowerTypes-Generalization").getDelegate();
        prop = this.factory.createProperty(clss, "generalizationSet", "Classes-PowerTypes-Generalization-generalizationSet", "Classes-PowerTypes-GeneralizationSet", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Classes-PowerTypes-GeneralizationSet").getDelegate();
        prop = this.factory.createProperty(clss, "generalization", "Classes-PowerTypes-GeneralizationSet-generalization", "Classes-PowerTypes-Generalization", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isCovering", "Classes-PowerTypes-GeneralizationSet-isCovering", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-PowerTypes-GeneralizationSet-isCovering-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isDisjoint", "Classes-PowerTypes-GeneralizationSet-isDisjoint", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Classes-PowerTypes-GeneralizationSet-isDisjoint-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "powertype", "Classes-PowerTypes-GeneralizationSet-powertype", "Classes-PowerTypes-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-BasicBehaviors-Behavior").getDelegate();
        prop = this.factory.createProperty(clss, "context", "CommonBehaviors-BasicBehaviors-Behavior-context", "CommonBehaviors-BasicBehaviors-BehavioredClassifier", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isReentrant", "CommonBehaviors-BasicBehaviors-Behavior-isReentrant", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "CommonBehaviors-BasicBehaviors-Behavior-isReentrant-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "ownedParameter", "CommonBehaviors-BasicBehaviors-Behavior-ownedParameter", "Classes-Kernel-Parameter", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "postcondition", "CommonBehaviors-BasicBehaviors-Behavior-postcondition", "Classes-Kernel-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "precondition", "CommonBehaviors-BasicBehaviors-Behavior-precondition", "Classes-Kernel-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedBehavior", "CommonBehaviors-BasicBehaviors-Behavior-redefinedBehavior", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "specification", "CommonBehaviors-BasicBehaviors-Behavior-specification", "CommonBehaviors-BasicBehaviors-BehavioralFeature", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-BasicBehaviors-BehavioralFeature").getDelegate();
        prop = this.factory.createProperty(clss, "isAbstract", "CommonBehaviors-BasicBehaviors-BehavioralFeature-isAbstract", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "CommonBehaviors-BasicBehaviors-BehavioralFeature-isAbstract-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "method", "CommonBehaviors-BasicBehaviors-BehavioralFeature-method", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-BasicBehaviors-BehavioredClassifier").getDelegate();
        prop = this.factory.createProperty(clss, "classifierBehavior", "CommonBehaviors-BasicBehaviors-BehavioredClassifier-classifierBehavior", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedBehavior", "CommonBehaviors-BasicBehaviors-BehavioredClassifier-ownedBehavior", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-BasicBehaviors-FunctionBehavior").getDelegate();
        clss = (Class_)this.model.getElementById("CommonBehaviors-BasicBehaviors-OpaqueBehavior").getDelegate();
        prop = this.factory.createProperty(clss, "body", "CommonBehaviors-BasicBehaviors-OpaqueBehavior-body", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "language", "CommonBehaviors-BasicBehaviors-OpaqueBehavior-language", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-BasicBehaviors-OpaqueExpression").getDelegate();
        prop = this.factory.createProperty(clss, "behavior", "CommonBehaviors-BasicBehaviors-OpaqueExpression-behavior", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "result", "CommonBehaviors-BasicBehaviors-OpaqueExpression-result", "Classes-Kernel-Parameter", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-AnyReceiveEvent").getDelegate();
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-BehavioralFeature").getDelegate();
        prop = this.factory.createProperty(clss, "concurrency", "CommonBehaviors-Communications-BehavioralFeature-concurrency", "CommonBehaviors-Communications-CallConcurrencyKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "CommonBehaviors-Communications-CallConcurrencyKind-sequential", "CommonBehaviors-Communications-BehavioralFeature-concurrency-_defaultValue", "uml:InstanceValue", "CommonBehaviors-Communications-CallConcurrencyKind");
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-CallEvent").getDelegate();
        prop = this.factory.createProperty(clss, "operation", "CommonBehaviors-Communications-CallEvent-operation", "CommonBehaviors-Communications-Operation", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-ChangeEvent").getDelegate();
        prop = this.factory.createProperty(clss, "changeExpression", "CommonBehaviors-Communications-ChangeEvent-changeExpression", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-Class").getDelegate();
        prop = this.factory.createProperty(clss, "isActive", "CommonBehaviors-Communications-Class-isActive", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "CommonBehaviors-Communications-Class-isActive-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "ownedReception", "CommonBehaviors-Communications-Class-ownedReception", "CommonBehaviors-Communications-Reception", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-Event").getDelegate();
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-Interface").getDelegate();
        prop = this.factory.createProperty(clss, "ownedReception", "CommonBehaviors-Communications-Interface-ownedReception", "CommonBehaviors-Communications-Reception", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-MessageEvent").getDelegate();
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-Operation").getDelegate();
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-Reception").getDelegate();
        prop = this.factory.createProperty(clss, "signal", "CommonBehaviors-Communications-Reception-signal", "CommonBehaviors-Communications-Signal", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-Signal").getDelegate();
        prop = this.factory.createProperty(clss, "ownedAttribute", "CommonBehaviors-Communications-Signal-ownedAttribute", "Classes-Kernel-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-SignalEvent").getDelegate();
        prop = this.factory.createProperty(clss, "signal", "CommonBehaviors-Communications-SignalEvent-signal", "CommonBehaviors-Communications-Signal", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-Trigger").getDelegate();
        prop = this.factory.createProperty(clss, "event", "CommonBehaviors-Communications-Trigger-event", "CommonBehaviors-Communications-Event", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-Duration").getDelegate();
        prop = this.factory.createProperty(clss, "expr", "CommonBehaviors-SimpleTime-Duration-expr", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "observation", "CommonBehaviors-SimpleTime-Duration-observation", "CommonBehaviors-SimpleTime-Observation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-DurationConstraint").getDelegate();
        prop = this.factory.createProperty(clss, "firstEvent", "CommonBehaviors-SimpleTime-DurationConstraint-firstEvent", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "2");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "specification", "CommonBehaviors-SimpleTime-DurationConstraint-specification", "CommonBehaviors-SimpleTime-DurationInterval", "CommonBehaviors-SimpleTime-IntervalConstraint-specification", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-DurationInterval").getDelegate();
        prop = this.factory.createProperty(clss, "max", "CommonBehaviors-SimpleTime-DurationInterval-max", "CommonBehaviors-SimpleTime-Duration", "CommonBehaviors-SimpleTime-Interval-max", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "min", "CommonBehaviors-SimpleTime-DurationInterval-min", "CommonBehaviors-SimpleTime-Duration", "CommonBehaviors-SimpleTime-Interval-min", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-DurationObservation").getDelegate();
        prop = this.factory.createProperty(clss, "event", "CommonBehaviors-SimpleTime-DurationObservation-event", "Classes-Kernel-NamedElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "2");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "firstEvent", "CommonBehaviors-SimpleTime-DurationObservation-firstEvent", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "2");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-Interval").getDelegate();
        prop = this.factory.createProperty(clss, "max", "CommonBehaviors-SimpleTime-Interval-max", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "min", "CommonBehaviors-SimpleTime-Interval-min", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-IntervalConstraint").getDelegate();
        prop = this.factory.createProperty(clss, "specification", "CommonBehaviors-SimpleTime-IntervalConstraint-specification", "CommonBehaviors-SimpleTime-Interval", "Classes-Kernel-Constraint-specification", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-Observation").getDelegate();
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-TimeConstraint").getDelegate();
        prop = this.factory.createProperty(clss, "firstEvent", "CommonBehaviors-SimpleTime-TimeConstraint-firstEvent", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "CommonBehaviors-SimpleTime-TimeConstraint-firstEvent-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "specification", "CommonBehaviors-SimpleTime-TimeConstraint-specification", "CommonBehaviors-SimpleTime-TimeInterval", "CommonBehaviors-SimpleTime-IntervalConstraint-specification", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-TimeEvent").getDelegate();
        prop = this.factory.createProperty(clss, "isRelative", "CommonBehaviors-SimpleTime-TimeEvent-isRelative", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "CommonBehaviors-SimpleTime-TimeEvent-isRelative-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "when", "CommonBehaviors-SimpleTime-TimeEvent-when", "CommonBehaviors-SimpleTime-TimeExpression", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-TimeExpression").getDelegate();
        prop = this.factory.createProperty(clss, "expr", "CommonBehaviors-SimpleTime-TimeExpression-expr", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "observation", "CommonBehaviors-SimpleTime-TimeExpression-observation", "CommonBehaviors-SimpleTime-Observation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-TimeInterval").getDelegate();
        prop = this.factory.createProperty(clss, "max", "CommonBehaviors-SimpleTime-TimeInterval-max", "CommonBehaviors-SimpleTime-TimeExpression", "CommonBehaviors-SimpleTime-Interval-max", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "min", "CommonBehaviors-SimpleTime-TimeInterval-min", "CommonBehaviors-SimpleTime-TimeExpression", "CommonBehaviors-SimpleTime-Interval-min", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-TimeObservation").getDelegate();
        prop = this.factory.createProperty(clss, "event", "CommonBehaviors-SimpleTime-TimeObservation-event", "Classes-Kernel-NamedElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "firstEvent", "CommonBehaviors-SimpleTime-TimeObservation-firstEvent", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "CommonBehaviors-SimpleTime-TimeObservation-firstEvent-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Components-BasicComponents-Component").getDelegate();
        prop = this.factory.createProperty(clss, "isIndirectlyInstantiated", "Components-BasicComponents-Component-isIndirectlyInstantiated", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "Components-BasicComponents-Component-isIndirectlyInstantiated-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "provided", "Components-BasicComponents-Component-provided", "Classes-Interfaces-Interface", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "realization", "Components-BasicComponents-Component-realization", "Components-BasicComponents-ComponentRealization", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "required", "Components-BasicComponents-Component-required", "Classes-Interfaces-Interface", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Components-BasicComponents-ComponentRealization").getDelegate();
        prop = this.factory.createProperty(clss, "abstraction", "Components-BasicComponents-ComponentRealization-abstraction", "Components-BasicComponents-Component", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "realizingClassifier", "Components-BasicComponents-ComponentRealization-realizingClassifier", "Classes-Dependencies-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Components-BasicComponents-ConnectableElement").getDelegate();
        prop = this.factory.createProperty(clss, "end", "Components-BasicComponents-ConnectableElement-end", "Components-BasicComponents-ConnectorEnd", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Components-BasicComponents-Connector").getDelegate();
        prop = this.factory.createProperty(clss, "contract", "Components-BasicComponents-Connector-contract", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "end", "Components-BasicComponents-Connector-end", "Components-BasicComponents-ConnectorEnd", "", false, false, false);
        this.factory.createLowerValue(prop, true, "2");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "kind", "Components-BasicComponents-Connector-kind", "Components-BasicComponents-ConnectorKind", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Components-BasicComponents-ConnectorEnd").getDelegate();
        prop = this.factory.createProperty(clss, "partWithPort", "Components-BasicComponents-ConnectorEnd-partWithPort", "CompositeStructures-InternalStructures-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "role", "Components-BasicComponents-ConnectorEnd-role", "Components-BasicComponents-ConnectableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Components-PackagingComponents-Component").getDelegate();
        prop = this.factory.createProperty(clss, "packagedElement", "Components-PackagingComponents-Component-packagedElement", "Classes-Kernel-PackageableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-Collaborations-Classifier").getDelegate();
        prop = this.factory.createProperty(clss, "collaborationUse", "CompositeStructures-Collaborations-Classifier-collaborationUse", "CompositeStructures-Collaborations-CollaborationUse", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "representation", "CompositeStructures-Collaborations-Classifier-representation", "CompositeStructures-Collaborations-CollaborationUse", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-Collaborations-Collaboration").getDelegate();
        prop = this.factory.createProperty(clss, "collaborationRole", "CompositeStructures-Collaborations-Collaboration-collaborationRole", "CompositeStructures-InternalStructures-ConnectableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-Collaborations-CollaborationUse").getDelegate();
        prop = this.factory.createProperty(clss, "roleBinding", "CompositeStructures-Collaborations-CollaborationUse-roleBinding", "Classes-Dependencies-Dependency", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "type", "CompositeStructures-Collaborations-CollaborationUse-type", "CompositeStructures-Collaborations-Collaboration", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-Collaborations-Parameter").getDelegate();
        clss = (Class_)this.model.getElementById("CompositeStructures-InternalStructures-Class").getDelegate();
        prop = this.factory.createProperty(clss, "ownedAttribute", "CompositeStructures-InternalStructures-Class-ownedAttribute", "CompositeStructures-InternalStructures-Property", "CompositeStructures-InternalStructures-StructuredClassifier-ownedAttribute", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-InternalStructures-Classifier").getDelegate();
        prop = this.factory.createProperty(clss, "attribute", "CompositeStructures-InternalStructures-Classifier-attribute", "CompositeStructures-InternalStructures-Property", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "feature", "CompositeStructures-InternalStructures-Classifier-feature", "CompositeStructures-InternalStructures-Feature", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-InternalStructures-ConnectableElement").getDelegate();
        prop = this.factory.createProperty(clss, "end", "CompositeStructures-InternalStructures-ConnectableElement-end", "CompositeStructures-InternalStructures-ConnectorEnd", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-InternalStructures-Connector").getDelegate();
        prop = this.factory.createProperty(clss, "end", "CompositeStructures-InternalStructures-Connector-end", "CompositeStructures-InternalStructures-ConnectorEnd", "", false, false, false);
        this.factory.createLowerValue(prop, true, "2");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedConnector", "CompositeStructures-InternalStructures-Connector-redefinedConnector", "CompositeStructures-InternalStructures-Connector", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "type", "CompositeStructures-InternalStructures-Connector-type", "Classes-Kernel-Association", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-InternalStructures-ConnectorEnd").getDelegate();
        prop = this.factory.createProperty(clss, "definingEnd", "CompositeStructures-InternalStructures-ConnectorEnd-definingEnd", "CompositeStructures-InternalStructures-Property", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "role", "CompositeStructures-InternalStructures-ConnectorEnd-role", "CompositeStructures-InternalStructures-ConnectableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-InternalStructures-Feature").getDelegate();
        prop = this.factory.createProperty(clss, "featuringClassifier", "CompositeStructures-InternalStructures-Feature-featuringClassifier", "CompositeStructures-InternalStructures-Classifier", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-InternalStructures-Property").getDelegate();
        prop = this.factory.createProperty(clss, "class", "CompositeStructures-InternalStructures-Property-class", "CompositeStructures-InternalStructures-Class", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-InternalStructures-StructuredClassifier").getDelegate();
        prop = this.factory.createProperty(clss, "ownedAttribute", "CompositeStructures-InternalStructures-StructuredClassifier-ownedAttribute", "CompositeStructures-InternalStructures-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedConnector", "CompositeStructures-InternalStructures-StructuredClassifier-ownedConnector", "CompositeStructures-InternalStructures-Connector", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "part", "CompositeStructures-InternalStructures-StructuredClassifier-part", "CompositeStructures-InternalStructures-Property", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "role", "CompositeStructures-InternalStructures-StructuredClassifier-role", "CompositeStructures-InternalStructures-ConnectableElement", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-InvocationActions-InvocationAction").getDelegate();
        prop = this.factory.createProperty(clss, "onPort", "CompositeStructures-InvocationActions-InvocationAction-onPort", "CompositeStructures-Ports-Port", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-InvocationActions-Trigger").getDelegate();
        prop = this.factory.createProperty(clss, "port", "CompositeStructures-InvocationActions-Trigger-port", "CompositeStructures-Ports-Port", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-Ports-ConnectorEnd").getDelegate();
        prop = this.factory.createProperty(clss, "partWithPort", "CompositeStructures-Ports-ConnectorEnd-partWithPort", "CompositeStructures-InternalStructures-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-Ports-EncapsulatedClassifier").getDelegate();
        prop = this.factory.createProperty(clss, "ownedPort", "CompositeStructures-Ports-EncapsulatedClassifier-ownedPort", "CompositeStructures-Ports-Port", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-Ports-Port").getDelegate();
        prop = this.factory.createProperty(clss, "isBehavior", "CompositeStructures-Ports-Port-isBehavior", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "CompositeStructures-Ports-Port-isBehavior-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isConjugated", "CompositeStructures-Ports-Port-isConjugated", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "CompositeStructures-Ports-Port-isConjugated-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isService", "CompositeStructures-Ports-Port-isService", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "CompositeStructures-Ports-Port-isService-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "provided", "CompositeStructures-Ports-Port-provided", "Classes-Interfaces-Interface", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedPort", "CompositeStructures-Ports-Port-redefinedPort", "CompositeStructures-Ports-Port", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "required", "CompositeStructures-Ports-Port-required", "Classes-Interfaces-Interface", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("CompositeStructures-StructuredActivities-Variable").getDelegate();
        clss = (Class_)this.model.getElementById("CompositeStructures-StructuredClasses-Class").getDelegate();
        clss = (Class_)this.model.getElementById("Deployments-Artifacts-Artifact").getDelegate();
        prop = this.factory.createProperty(clss, "fileName", "Deployments-Artifacts-Artifact-fileName", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "manifestation", "Deployments-Artifacts-Artifact-manifestation", "Deployments-Artifacts-Manifestation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "nestedArtifact", "Deployments-Artifacts-Artifact-nestedArtifact", "Deployments-Artifacts-Artifact", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedAttribute", "Deployments-Artifacts-Artifact-ownedAttribute", "Classes-Kernel-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedOperation", "Deployments-Artifacts-Artifact-ownedOperation", "Classes-Kernel-Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Deployments-Artifacts-Manifestation").getDelegate();
        prop = this.factory.createProperty(clss, "utilizedElement", "Deployments-Artifacts-Manifestation-utilizedElement", "Classes-Dependencies-PackageableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Deployments-ComponentDeployments-Deployment").getDelegate();
        prop = this.factory.createProperty(clss, "configuration", "Deployments-ComponentDeployments-Deployment-configuration", "Deployments-ComponentDeployments-DeploymentSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Deployments-ComponentDeployments-DeploymentSpecification").getDelegate();
        prop = this.factory.createProperty(clss, "deployment", "Deployments-ComponentDeployments-DeploymentSpecification-deployment", "Deployments-ComponentDeployments-Deployment", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "deploymentLocation", "Deployments-ComponentDeployments-DeploymentSpecification-deploymentLocation", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "executionLocation", "Deployments-ComponentDeployments-DeploymentSpecification-executionLocation", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Deployments-Nodes-Artifact").getDelegate();
        clss = (Class_)this.model.getElementById("Deployments-Nodes-CommunicationPath").getDelegate();
        clss = (Class_)this.model.getElementById("Deployments-Nodes-DeployedArtifact").getDelegate();
        clss = (Class_)this.model.getElementById("Deployments-Nodes-Deployment").getDelegate();
        prop = this.factory.createProperty(clss, "deployedArtifact", "Deployments-Nodes-Deployment-deployedArtifact", "Deployments-Nodes-DeployedArtifact", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "location", "Deployments-Nodes-Deployment-location", "Deployments-Nodes-DeploymentTarget", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Deployments-Nodes-DeploymentTarget").getDelegate();
        prop = this.factory.createProperty(clss, "deployedElement", "Deployments-Nodes-DeploymentTarget-deployedElement", "Classes-Kernel-PackageableElement", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "deployment", "Deployments-Nodes-DeploymentTarget-deployment", "Deployments-Nodes-Deployment", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Deployments-Nodes-Device").getDelegate();
        clss = (Class_)this.model.getElementById("Deployments-Nodes-ExecutionEnvironment").getDelegate();
        clss = (Class_)this.model.getElementById("Deployments-Nodes-InstanceSpecification").getDelegate();
        clss = (Class_)this.model.getElementById("Deployments-Nodes-Node").getDelegate();
        prop = this.factory.createProperty(clss, "nestedNode", "Deployments-Nodes-Node-nestedNode", "Deployments-Nodes-Node", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Deployments-Nodes-Property").getDelegate();
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-ActionExecutionSpecification").getDelegate();
        prop = this.factory.createProperty(clss, "action", "Interactions-BasicInteractions-ActionExecutionSpecification-action", "Actions-BasicActions-Action", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-BehaviorExecutionSpecification").getDelegate();
        prop = this.factory.createProperty(clss, "behavior", "Interactions-BasicInteractions-BehaviorExecutionSpecification-behavior", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-DestructionOccurrenceSpecification").getDelegate();
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-ExecutionOccurrenceSpecification").getDelegate();
        prop = this.factory.createProperty(clss, "execution", "Interactions-BasicInteractions-ExecutionOccurrenceSpecification-execution", "Interactions-BasicInteractions-ExecutionSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-ExecutionSpecification").getDelegate();
        prop = this.factory.createProperty(clss, "finish", "Interactions-BasicInteractions-ExecutionSpecification-finish", "Interactions-BasicInteractions-OccurrenceSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "start", "Interactions-BasicInteractions-ExecutionSpecification-start", "Interactions-BasicInteractions-OccurrenceSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-GeneralOrdering").getDelegate();
        prop = this.factory.createProperty(clss, "after", "Interactions-BasicInteractions-GeneralOrdering-after", "Interactions-BasicInteractions-OccurrenceSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "before", "Interactions-BasicInteractions-GeneralOrdering-before", "Interactions-BasicInteractions-OccurrenceSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-Interaction").getDelegate();
        prop = this.factory.createProperty(clss, "action", "Interactions-BasicInteractions-Interaction-action", "Actions-BasicActions-Action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "fragment", "Interactions-BasicInteractions-Interaction-fragment", "Interactions-BasicInteractions-InteractionFragment", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "lifeline", "Interactions-BasicInteractions-Interaction-lifeline", "Interactions-BasicInteractions-Lifeline", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "message", "Interactions-BasicInteractions-Interaction-message", "Interactions-BasicInteractions-Message", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-InteractionFragment").getDelegate();
        prop = this.factory.createProperty(clss, "covered", "Interactions-BasicInteractions-InteractionFragment-covered", "Interactions-BasicInteractions-Lifeline", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "enclosingInteraction", "Interactions-BasicInteractions-InteractionFragment-enclosingInteraction", "Interactions-BasicInteractions-Interaction", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "generalOrdering", "Interactions-BasicInteractions-InteractionFragment-generalOrdering", "Interactions-BasicInteractions-GeneralOrdering", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-Lifeline").getDelegate();
        prop = this.factory.createProperty(clss, "coveredBy", "Interactions-BasicInteractions-Lifeline-coveredBy", "Interactions-BasicInteractions-InteractionFragment", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "interaction", "Interactions-BasicInteractions-Lifeline-interaction", "Interactions-BasicInteractions-Interaction", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "represents", "Interactions-BasicInteractions-Lifeline-represents", "CompositeStructures-InternalStructures-ConnectableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "selector", "Interactions-BasicInteractions-Lifeline-selector", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-Message").getDelegate();
        prop = this.factory.createProperty(clss, "argument", "Interactions-BasicInteractions-Message-argument", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "connector", "Interactions-BasicInteractions-Message-connector", "CompositeStructures-InternalStructures-Connector", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "interaction", "Interactions-BasicInteractions-Message-interaction", "Interactions-BasicInteractions-Interaction", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "messageKind", "Interactions-BasicInteractions-Message-messageKind", "Interactions-BasicInteractions-MessageKind", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "Interactions-BasicInteractions-MessageKind-unknown", "Interactions-BasicInteractions-Message-messageKind-_defaultValue", "uml:InstanceValue", "Interactions-BasicInteractions-MessageKind");
        prop = this.factory.createProperty(clss, "messageSort", "Interactions-BasicInteractions-Message-messageSort", "Interactions-BasicInteractions-MessageSort", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "Interactions-BasicInteractions-MessageSort-synchCall", "Interactions-BasicInteractions-Message-messageSort-_defaultValue", "uml:InstanceValue", "Interactions-BasicInteractions-MessageSort");
        prop = this.factory.createProperty(clss, "receiveEvent", "Interactions-BasicInteractions-Message-receiveEvent", "Interactions-BasicInteractions-MessageEnd", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "sendEvent", "Interactions-BasicInteractions-Message-sendEvent", "Interactions-BasicInteractions-MessageEnd", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "signature", "Interactions-BasicInteractions-Message-signature", "Classes-Kernel-NamedElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-MessageEnd").getDelegate();
        prop = this.factory.createProperty(clss, "message", "Interactions-BasicInteractions-MessageEnd-message", "Interactions-BasicInteractions-Message", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-MessageOccurrenceSpecification").getDelegate();
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-OccurrenceSpecification").getDelegate();
        prop = this.factory.createProperty(clss, "covered", "Interactions-BasicInteractions-OccurrenceSpecification-covered", "Interactions-BasicInteractions-Lifeline", "Interactions-BasicInteractions-InteractionFragment-covered", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "toAfter", "Interactions-BasicInteractions-OccurrenceSpecification-toAfter", "Interactions-BasicInteractions-GeneralOrdering", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "toBefore", "Interactions-BasicInteractions-OccurrenceSpecification-toBefore", "Interactions-BasicInteractions-GeneralOrdering", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-StateInvariant").getDelegate();
        prop = this.factory.createProperty(clss, "covered", "Interactions-BasicInteractions-StateInvariant-covered", "Interactions-BasicInteractions-Lifeline", "Interactions-BasicInteractions-InteractionFragment-covered", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "invariant", "Interactions-BasicInteractions-StateInvariant-invariant", "Classes-Kernel-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-Fragments-CombinedFragment").getDelegate();
        prop = this.factory.createProperty(clss, "cfragmentGate", "Interactions-Fragments-CombinedFragment-cfragmentGate", "Interactions-Fragments-Gate", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "interactionOperator", "Interactions-Fragments-CombinedFragment-interactionOperator", "Interactions-Fragments-InteractionOperatorKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "Interactions-Fragments-InteractionOperatorKind-seq", "Interactions-Fragments-CombinedFragment-interactionOperator-_defaultValue", "uml:InstanceValue", "Interactions-Fragments-InteractionOperatorKind");
        prop = this.factory.createProperty(clss, "operand", "Interactions-Fragments-CombinedFragment-operand", "Interactions-Fragments-InteractionOperand", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-Fragments-ConsiderIgnoreFragment").getDelegate();
        prop = this.factory.createProperty(clss, "message", "Interactions-Fragments-ConsiderIgnoreFragment-message", "Classes-Kernel-NamedElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-Fragments-Continuation").getDelegate();
        prop = this.factory.createProperty(clss, "setting", "Interactions-Fragments-Continuation-setting", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "Interactions-Fragments-Continuation-setting-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Interactions-Fragments-Gate").getDelegate();
        clss = (Class_)this.model.getElementById("Interactions-Fragments-Interaction").getDelegate();
        prop = this.factory.createProperty(clss, "formalGate", "Interactions-Fragments-Interaction-formalGate", "Interactions-Fragments-Gate", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-Fragments-InteractionConstraint").getDelegate();
        prop = this.factory.createProperty(clss, "maxint", "Interactions-Fragments-InteractionConstraint-maxint", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "minint", "Interactions-Fragments-InteractionConstraint-minint", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-Fragments-InteractionFragment").getDelegate();
        prop = this.factory.createProperty(clss, "enclosingOperand", "Interactions-Fragments-InteractionFragment-enclosingOperand", "Interactions-Fragments-InteractionOperand", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-Fragments-InteractionOperand").getDelegate();
        prop = this.factory.createProperty(clss, "fragment", "Interactions-Fragments-InteractionOperand-fragment", "Interactions-Fragments-InteractionFragment", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "guard", "Interactions-Fragments-InteractionOperand-guard", "Interactions-Fragments-InteractionConstraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-Fragments-InteractionUse").getDelegate();
        prop = this.factory.createProperty(clss, "actualGate", "Interactions-Fragments-InteractionUse-actualGate", "Interactions-Fragments-Gate", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "argument", "Interactions-Fragments-InteractionUse-argument", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "refersTo", "Interactions-Fragments-InteractionUse-refersTo", "Interactions-Fragments-Interaction", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "returnValue", "Interactions-Fragments-InteractionUse-returnValue", "Classes-Kernel-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "returnValueRecipient", "Interactions-Fragments-InteractionUse-returnValueRecipient", "Classes-Kernel-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-Fragments-Lifeline").getDelegate();
        prop = this.factory.createProperty(clss, "decomposedAs", "Interactions-Fragments-Lifeline-decomposedAs", "Interactions-Fragments-PartDecomposition", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Interactions-Fragments-PartDecomposition").getDelegate();
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-ConnectionPointReference").getDelegate();
        prop = this.factory.createProperty(clss, "entry", "StateMachines-BehaviorStateMachines-ConnectionPointReference-entry", "StateMachines-BehaviorStateMachines-Pseudostate", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "exit", "StateMachines-BehaviorStateMachines-ConnectionPointReference-exit", "StateMachines-BehaviorStateMachines-Pseudostate", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "state", "StateMachines-BehaviorStateMachines-ConnectionPointReference-state", "StateMachines-BehaviorStateMachines-State", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-FinalState").getDelegate();
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-Pseudostate").getDelegate();
        prop = this.factory.createProperty(clss, "kind", "StateMachines-BehaviorStateMachines-Pseudostate-kind", "StateMachines-BehaviorStateMachines-PseudostateKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "StateMachines-BehaviorStateMachines-PseudostateKind-initial", "StateMachines-BehaviorStateMachines-Pseudostate-kind-_defaultValue", "uml:InstanceValue", "StateMachines-BehaviorStateMachines-PseudostateKind");
        prop = this.factory.createProperty(clss, "state", "StateMachines-BehaviorStateMachines-Pseudostate-state", "StateMachines-BehaviorStateMachines-State", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "stateMachine", "StateMachines-BehaviorStateMachines-Pseudostate-stateMachine", "StateMachines-BehaviorStateMachines-StateMachine", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-Region").getDelegate();
        prop = this.factory.createProperty(clss, "extendedRegion", "StateMachines-BehaviorStateMachines-Region-extendedRegion", "StateMachines-BehaviorStateMachines-Region", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinitionContext", "StateMachines-BehaviorStateMachines-Region-redefinitionContext", "Classes-Kernel-Classifier", "Classes-Kernel-RedefinableElement-redefinitionContext", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "state", "StateMachines-BehaviorStateMachines-Region-state", "StateMachines-BehaviorStateMachines-State", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "stateMachine", "StateMachines-BehaviorStateMachines-Region-stateMachine", "StateMachines-BehaviorStateMachines-StateMachine", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "subvertex", "StateMachines-BehaviorStateMachines-Region-subvertex", "StateMachines-BehaviorStateMachines-Vertex", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "transition", "StateMachines-BehaviorStateMachines-Region-transition", "StateMachines-BehaviorStateMachines-Transition", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-State").getDelegate();
        prop = this.factory.createProperty(clss, "connection", "StateMachines-BehaviorStateMachines-State-connection", "StateMachines-BehaviorStateMachines-ConnectionPointReference", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "connectionPoint", "StateMachines-BehaviorStateMachines-State-connectionPoint", "StateMachines-BehaviorStateMachines-Pseudostate", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "deferrableTrigger", "StateMachines-BehaviorStateMachines-State-deferrableTrigger", "CommonBehaviors-Communications-Trigger", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "doActivity", "StateMachines-BehaviorStateMachines-State-doActivity", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "entry", "StateMachines-BehaviorStateMachines-State-entry", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "exit", "StateMachines-BehaviorStateMachines-State-exit", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isComposite", "StateMachines-BehaviorStateMachines-State-isComposite", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "StateMachines-BehaviorStateMachines-State-isComposite-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isOrthogonal", "StateMachines-BehaviorStateMachines-State-isOrthogonal", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "StateMachines-BehaviorStateMachines-State-isOrthogonal-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isSimple", "StateMachines-BehaviorStateMachines-State-isSimple", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "StateMachines-BehaviorStateMachines-State-isSimple-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isSubmachineState", "StateMachines-BehaviorStateMachines-State-isSubmachineState", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "StateMachines-BehaviorStateMachines-State-isSubmachineState-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "redefinedState", "StateMachines-BehaviorStateMachines-State-redefinedState", "StateMachines-BehaviorStateMachines-State", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinitionContext", "StateMachines-BehaviorStateMachines-State-redefinitionContext", "Classes-Kernel-Classifier", "Classes-Kernel-RedefinableElement-redefinitionContext", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "region", "StateMachines-BehaviorStateMachines-State-region", "StateMachines-BehaviorStateMachines-Region", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "stateInvariant", "StateMachines-BehaviorStateMachines-State-stateInvariant", "Classes-Kernel-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "submachine", "StateMachines-BehaviorStateMachines-State-submachine", "StateMachines-BehaviorStateMachines-StateMachine", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-StateMachine").getDelegate();
        prop = this.factory.createProperty(clss, "connectionPoint", "StateMachines-BehaviorStateMachines-StateMachine-connectionPoint", "StateMachines-BehaviorStateMachines-Pseudostate", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "extendedStateMachine", "StateMachines-BehaviorStateMachines-StateMachine-extendedStateMachine", "StateMachines-BehaviorStateMachines-StateMachine", "CommonBehaviors-BasicBehaviors-Behavior-redefinedBehavior", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "region", "StateMachines-BehaviorStateMachines-StateMachine-region", "StateMachines-BehaviorStateMachines-Region", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "submachineState", "StateMachines-BehaviorStateMachines-StateMachine-submachineState", "StateMachines-BehaviorStateMachines-State", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-TimeEvent").getDelegate();
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-Transition").getDelegate();
        prop = this.factory.createProperty(clss, "container", "StateMachines-BehaviorStateMachines-Transition-container", "StateMachines-BehaviorStateMachines-Region", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "effect", "StateMachines-BehaviorStateMachines-Transition-effect", "CommonBehaviors-BasicBehaviors-Behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "guard", "StateMachines-BehaviorStateMachines-Transition-guard", "Classes-Kernel-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "kind", "StateMachines-BehaviorStateMachines-Transition-kind", "StateMachines-BehaviorStateMachines-TransitionKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "StateMachines-BehaviorStateMachines-TransitionKind-external", "StateMachines-BehaviorStateMachines-Transition-kind-_defaultValue", "uml:InstanceValue", "StateMachines-BehaviorStateMachines-TransitionKind");
        prop = this.factory.createProperty(clss, "redefinedTransition", "StateMachines-BehaviorStateMachines-Transition-redefinedTransition", "StateMachines-BehaviorStateMachines-Transition", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinitionContext", "StateMachines-BehaviorStateMachines-Transition-redefinitionContext", "Classes-Kernel-Classifier", "Classes-Kernel-RedefinableElement-redefinitionContext", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "source", "StateMachines-BehaviorStateMachines-Transition-source", "StateMachines-BehaviorStateMachines-Vertex", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "target", "StateMachines-BehaviorStateMachines-Transition-target", "StateMachines-BehaviorStateMachines-Vertex", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "trigger", "StateMachines-BehaviorStateMachines-Transition-trigger", "CommonBehaviors-Communications-Trigger", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-Vertex").getDelegate();
        prop = this.factory.createProperty(clss, "container", "StateMachines-BehaviorStateMachines-Vertex-container", "StateMachines-BehaviorStateMachines-Region", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "incoming", "StateMachines-BehaviorStateMachines-Vertex-incoming", "StateMachines-BehaviorStateMachines-Transition", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "outgoing", "StateMachines-BehaviorStateMachines-Vertex-outgoing", "StateMachines-BehaviorStateMachines-Transition", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StateMachines-ProtocolStateMachines-Interface").getDelegate();
        prop = this.factory.createProperty(clss, "protocol", "StateMachines-ProtocolStateMachines-Interface-protocol", "StateMachines-ProtocolStateMachines-ProtocolStateMachine", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StateMachines-ProtocolStateMachines-Port").getDelegate();
        prop = this.factory.createProperty(clss, "protocol", "StateMachines-ProtocolStateMachines-Port-protocol", "StateMachines-ProtocolStateMachines-ProtocolStateMachine", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StateMachines-ProtocolStateMachines-ProtocolConformance").getDelegate();
        prop = this.factory.createProperty(clss, "generalMachine", "StateMachines-ProtocolStateMachines-ProtocolConformance-generalMachine", "StateMachines-ProtocolStateMachines-ProtocolStateMachine", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "specificMachine", "StateMachines-ProtocolStateMachines-ProtocolConformance-specificMachine", "StateMachines-ProtocolStateMachines-ProtocolStateMachine", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StateMachines-ProtocolStateMachines-ProtocolStateMachine").getDelegate();
        prop = this.factory.createProperty(clss, "conformance", "StateMachines-ProtocolStateMachines-ProtocolStateMachine-conformance", "StateMachines-ProtocolStateMachines-ProtocolConformance", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StateMachines-ProtocolStateMachines-ProtocolTransition").getDelegate();
        prop = this.factory.createProperty(clss, "postCondition", "StateMachines-ProtocolStateMachines-ProtocolTransition-postCondition", "Classes-Kernel-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "preCondition", "StateMachines-ProtocolStateMachines-ProtocolTransition-preCondition", "Classes-Kernel-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "referred", "StateMachines-ProtocolStateMachines-ProtocolTransition-referred", "Classes-Kernel-Operation", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("StateMachines-ProtocolStateMachines-Region").getDelegate();
        clss = (Class_)this.model.getElementById("StateMachines-ProtocolStateMachines-State").getDelegate();
        clss = (Class_)this.model.getElementById("UseCases-Actor").getDelegate();
        clss = (Class_)this.model.getElementById("UseCases-Classifier").getDelegate();
        prop = this.factory.createProperty(clss, "ownedUseCase", "UseCases-Classifier-ownedUseCase", "UseCases-UseCase", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "useCase", "UseCases-Classifier-useCase", "UseCases-UseCase", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("UseCases-Extend").getDelegate();
        prop = this.factory.createProperty(clss, "condition", "UseCases-Extend-condition", "Classes-Kernel-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "extendedCase", "UseCases-Extend-extendedCase", "UseCases-UseCase", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "extension", "UseCases-Extend-extension", "UseCases-UseCase", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "extensionLocation", "UseCases-Extend-extensionLocation", "UseCases-ExtensionPoint", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("UseCases-ExtensionPoint").getDelegate();
        prop = this.factory.createProperty(clss, "useCase", "UseCases-ExtensionPoint-useCase", "UseCases-UseCase", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("UseCases-Include").getDelegate();
        prop = this.factory.createProperty(clss, "addition", "UseCases-Include-addition", "UseCases-UseCase", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "includingCase", "UseCases-Include-includingCase", "UseCases-UseCase", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("UseCases-UseCase").getDelegate();
        prop = this.factory.createProperty(clss, "extend", "UseCases-UseCase-extend", "UseCases-Extend", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "extensionPoint", "UseCases-UseCase-extensionPoint", "UseCases-ExtensionPoint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "include", "UseCases-UseCase-include", "UseCases-Include", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "subject", "UseCases-UseCase-subject", "UseCases-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
    }

    private void constructGeneralizations() {
        Class_ clss = null;
        clss = (Class_)this.model.getElementById("Actions-BasicActions-Action").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("Actions-BasicActions-CallAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-InvocationAction");
        clss = (Class_)this.model.getElementById("Actions-BasicActions-CallBehaviorAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-CallAction");
        clss = (Class_)this.model.getElementById("Actions-BasicActions-CallOperationAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-CallAction");
        clss = (Class_)this.model.getElementById("Actions-BasicActions-InputPin").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Pin");
        clss = (Class_)this.model.getElementById("Actions-BasicActions-InvocationAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-BasicActions-MultiplicityElement").getDelegate();
        clss = (Class_)this.model.getElementById("Actions-BasicActions-OpaqueAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-BasicActions-OutputPin").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Pin");
        clss = (Class_)this.model.getElementById("Actions-BasicActions-Pin").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-MultiplicityElement");
        this.factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
        clss = (Class_)this.model.getElementById("Actions-BasicActions-SendSignalAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-InvocationAction");
        clss = (Class_)this.model.getElementById("Actions-BasicActions-ValuePin").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-InputPin");
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-AcceptCallAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-CompleteActions-AcceptEventAction");
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-AcceptEventAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-CreateLinkObjectAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-IntermediateActions-CreateLinkAction");
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-LinkEndData").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-QualifierValue").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-ReadExtentAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-ReadIsClassifiedObjectAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-ReadLinkObjectEndAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-ReadLinkObjectEndQualifierAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-ReclassifyObjectAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-ReduceAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-ReplyAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-StartClassifierBehaviorAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-StartObjectBehaviorAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-CallAction");
        clss = (Class_)this.model.getElementById("Actions-CompleteActions-UnmarshallAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-AddStructuralFeatureValueAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-IntermediateActions-WriteStructuralFeatureAction");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-BroadcastSignalAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-InvocationAction");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-ClearAssociationAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-ClearStructuralFeatureAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-IntermediateActions-StructuralFeatureAction");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-CreateLinkAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-IntermediateActions-WriteLinkAction");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-CreateObjectAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-DestroyLinkAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-IntermediateActions-WriteLinkAction");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-DestroyObjectAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-LinkAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-LinkEndCreationData").getDelegate();
        this.factory.createGeneralization(clss, "Actions-IntermediateActions-LinkEndData");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-LinkEndData").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-LinkEndDestructionData").getDelegate();
        this.factory.createGeneralization(clss, "Actions-IntermediateActions-LinkEndData");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-ReadLinkAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-IntermediateActions-LinkAction");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-ReadSelfAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-ReadStructuralFeatureAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-IntermediateActions-StructuralFeatureAction");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-RemoveStructuralFeatureValueAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-IntermediateActions-WriteStructuralFeatureAction");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-SendObjectAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-InvocationAction");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-StructuralFeatureAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-TestIdentityAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-ValueSpecificationAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-WriteLinkAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-IntermediateActions-LinkAction");
        clss = (Class_)this.model.getElementById("Actions-IntermediateActions-WriteStructuralFeatureAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-IntermediateActions-StructuralFeatureAction");
        clss = (Class_)this.model.getElementById("Actions-StructuredActions-ActionInputPin").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-InputPin");
        clss = (Class_)this.model.getElementById("Actions-StructuredActions-AddVariableValueAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-StructuredActions-WriteVariableAction");
        clss = (Class_)this.model.getElementById("Actions-StructuredActions-ClearVariableAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-StructuredActions-VariableAction");
        clss = (Class_)this.model.getElementById("Actions-StructuredActions-RaiseExceptionAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-StructuredActions-ReadVariableAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-StructuredActions-VariableAction");
        clss = (Class_)this.model.getElementById("Actions-StructuredActions-RemoveVariableValueAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-StructuredActions-WriteVariableAction");
        clss = (Class_)this.model.getElementById("Actions-StructuredActions-VariableAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-BasicActions-Action");
        clss = (Class_)this.model.getElementById("Actions-StructuredActions-WriteVariableAction").getDelegate();
        this.factory.createGeneralization(clss, "Actions-StructuredActions-VariableAction");
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-Activity").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ActivityEdge").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ActivityFinalNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ActivityGroup").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ActivityNode").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ActivityParameterNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ObjectNode");
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ControlFlow").getDelegate();
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ActivityEdge");
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ControlNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ActivityNode");
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-InitialNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ObjectFlow").getDelegate();
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ActivityEdge");
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ObjectNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ActivityNode");
        this.factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-Pin").getDelegate();
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ObjectNode");
        clss = (Class_)this.model.getElementById("Activities-BasicActivities-ValuePin").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-Action").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-Activity").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-ActivityEdge").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-ActivityGroup").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-ActivityNode").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-Behavior").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Class");
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-BehavioralFeature").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Namespace");
        this.factory.createGeneralization(clss, "Classes-Kernel-Feature");
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-DataStoreNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-IntermediateActivities-CentralBufferNode");
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-InterruptibleActivityRegion").getDelegate();
        this.factory.createGeneralization(clss, "Activities-CompleteActivities-ActivityGroup");
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ActivityGroup");
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-JoinNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-ObjectFlow").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-ObjectNode").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-Parameter").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-ParameterSet").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("Activities-CompleteActivities-Pin").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-Action").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-ActivityEdge").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-ActivityGroup").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-Clause").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-ConditionalNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-CompleteStructuredActivities-StructuredActivityNode");
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-InputPin").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-LoopNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-CompleteStructuredActivities-StructuredActivityNode");
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-OutputPin").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-CompleteStructuredActivities-StructuredActivityNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-CompleteStructuredActivities-Action");
        this.factory.createGeneralization(clss, "Activities-CompleteStructuredActivities-ActivityGroup");
        clss = (Class_)this.model.getElementById("Activities-ExtraStructuredActivities-ExceptionHandler").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("Activities-ExtraStructuredActivities-ExecutableNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-StructuredActivities-ActivityNode");
        clss = (Class_)this.model.getElementById("Activities-ExtraStructuredActivities-ExpansionNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ObjectNode");
        clss = (Class_)this.model.getElementById("Activities-ExtraStructuredActivities-ExpansionRegion").getDelegate();
        this.factory.createGeneralization(clss, "Activities-StructuredActivities-StructuredActivityNode");
        clss = (Class_)this.model.getElementById("Activities-FundamentalActivities-Action").getDelegate();
        this.factory.createGeneralization(clss, "Activities-FundamentalActivities-ActivityNode");
        clss = (Class_)this.model.getElementById("Activities-FundamentalActivities-Activity").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
        clss = (Class_)this.model.getElementById("Activities-FundamentalActivities-ActivityGroup").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("Activities-FundamentalActivities-ActivityNode").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-Activity").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-ActivityEdge").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-ActivityFinalNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-IntermediateActivities-FinalNode");
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-ActivityGroup").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-ActivityNode").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-ActivityPartition").getDelegate();
        this.factory.createGeneralization(clss, "Activities-IntermediateActivities-ActivityGroup");
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-CentralBufferNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ObjectNode");
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-DecisionNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-FinalNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-FlowFinalNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-IntermediateActivities-FinalNode");
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-ForkNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-JoinNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
        clss = (Class_)this.model.getElementById("Activities-IntermediateActivities-MergeNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-BasicActivities-ControlNode");
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-Action").getDelegate();
        this.factory.createGeneralization(clss, "Activities-StructuredActivities-ExecutableNode");
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-Activity").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-ActivityGroup").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-ActivityNode").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-Clause").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-ConditionalNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-StructuredActivities-StructuredActivityNode");
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-ExecutableNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-StructuredActivities-ActivityNode");
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-LoopNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-StructuredActivities-StructuredActivityNode");
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-OutputPin").getDelegate();
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-SequenceNode").getDelegate();
        this.factory.createGeneralization(clss, "Activities-StructuredActivities-StructuredActivityNode");
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-StructuredActivityNode").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Namespace");
        this.factory.createGeneralization(clss, "Activities-StructuredActivities-ExecutableNode");
        this.factory.createGeneralization(clss, "Activities-StructuredActivities-ActivityGroup");
        clss = (Class_)this.model.getElementById("Activities-StructuredActivities-Variable").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
        this.factory.createGeneralization(clss, "Classes-Kernel-MultiplicityElement");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-InformationFlows-InformationFlow").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
        this.factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-InformationFlows-InformationItem").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Classifier");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Models-Model").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Package");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Profiles-ExtensionEnd").getDelegate();
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-Classifier").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Namespace");
        this.factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
        this.factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateableElement");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-ClassifierTemplateParameter").getDelegate();
        this.factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateParameter");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-ConnectableElement").getDelegate();
        this.factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter").getDelegate();
        this.factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateParameter");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-NamedElement").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-Operation").getDelegate();
        this.factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateableElement");
        this.factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-OperationTemplateParameter").getDelegate();
        this.factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateParameter");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-Package").getDelegate();
        this.factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateableElement");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-PackageableElement").getDelegate();
        this.factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-ParameterableElement").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-Property").getDelegate();
        this.factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-RedefinableElement").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-RedefinableTemplateSignature").getDelegate();
        this.factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-RedefinableElement");
        this.factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
        this.factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateSignature");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-StringExpression").getDelegate();
        this.factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-TemplateableElement");
        this.factory.createGeneralization(clss, "Classes-Kernel-Expression");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-TemplateBinding").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-TemplateParameter").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-TemplateParameterSubstitution").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-TemplateSignature").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-TemplateableElement").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("AuxiliaryConstructs-Templates-ValueSpecification").getDelegate();
        this.factory.createGeneralization(clss, "AuxiliaryConstructs-Templates-ParameterableElement");
        clss = (Class_)this.model.getElementById("Classes-AssociationClasses-AssociationClass").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Association");
        this.factory.createGeneralization(clss, "Classes-Kernel-Class");
        clss = (Class_)this.model.getElementById("Classes-AssociationClasses-Property").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-StructuralFeature");
        clss = (Class_)this.model.getElementById("Classes-Dependencies-Abstraction").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-Dependency");
        clss = (Class_)this.model.getElementById("Classes-Dependencies-Classifier").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-Namespace");
        clss = (Class_)this.model.getElementById("Classes-Dependencies-Dependency").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
        this.factory.createGeneralization(clss, "Classes-Dependencies-PackageableElement");
        clss = (Class_)this.model.getElementById("Classes-Dependencies-NamedElement").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("Classes-Dependencies-Namespace").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
        clss = (Class_)this.model.getElementById("Classes-Dependencies-PackageableElement").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
        clss = (Class_)this.model.getElementById("Classes-Dependencies-Realization").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-Abstraction");
        clss = (Class_)this.model.getElementById("Classes-Dependencies-Substitution").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-Realization");
        clss = (Class_)this.model.getElementById("Classes-Dependencies-Usage").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-Dependency");
        clss = (Class_)this.model.getElementById("Classes-Interfaces-BehavioredClassifier").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
        this.factory.createGeneralization(clss, "Classes-Kernel-Classifier");
        clss = (Class_)this.model.getElementById("Classes-Interfaces-Classifier").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-Namespace");
        clss = (Class_)this.model.getElementById("Classes-Interfaces-Interface").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Interfaces-Classifier");
        this.factory.createGeneralization(clss, "Classes-Kernel-Classifier");
        clss = (Class_)this.model.getElementById("Classes-Interfaces-InterfaceRealization").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-Realization");
        clss = (Class_)this.model.getElementById("Classes-Interfaces-Operation").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-BehavioralFeature");
        clss = (Class_)this.model.getElementById("Classes-Interfaces-Property").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-StructuralFeature");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Association").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Relationship");
        this.factory.createGeneralization(clss, "Classes-Kernel-Classifier");
        clss = (Class_)this.model.getElementById("Classes-Kernel-BehavioralFeature").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Feature");
        this.factory.createGeneralization(clss, "Classes-Kernel-Namespace");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Class").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Classifier");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Classifier").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Type");
        this.factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
        this.factory.createGeneralization(clss, "Classes-Kernel-Namespace");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Comment").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Constraint").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
        clss = (Class_)this.model.getElementById("Classes-Kernel-DataType").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Classifier");
        clss = (Class_)this.model.getElementById("Classes-Kernel-DirectedRelationship").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Relationship");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Element").getDelegate();
        clss = (Class_)this.model.getElementById("Classes-Kernel-ElementImport").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Enumeration").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-DataType");
        clss = (Class_)this.model.getElementById("Classes-Kernel-EnumerationLiteral").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-InstanceSpecification");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Expression").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Feature").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Generalization").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
        clss = (Class_)this.model.getElementById("Classes-Kernel-InstanceSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
        clss = (Class_)this.model.getElementById("Classes-Kernel-InstanceValue").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
        clss = (Class_)this.model.getElementById("Classes-Kernel-LiteralBoolean").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
        clss = (Class_)this.model.getElementById("Classes-Kernel-LiteralInteger").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
        clss = (Class_)this.model.getElementById("Classes-Kernel-LiteralNull").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
        clss = (Class_)this.model.getElementById("Classes-Kernel-LiteralReal").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
        clss = (Class_)this.model.getElementById("Classes-Kernel-LiteralSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
        clss = (Class_)this.model.getElementById("Classes-Kernel-LiteralString").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
        clss = (Class_)this.model.getElementById("Classes-Kernel-LiteralUnlimitedNatural").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-LiteralSpecification");
        clss = (Class_)this.model.getElementById("Classes-Kernel-MultiplicityElement").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("Classes-Kernel-NamedElement").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Namespace").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("Classes-Kernel-OpaqueExpression").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Operation").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-BehavioralFeature");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Package").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Namespace");
        this.factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
        clss = (Class_)this.model.getElementById("Classes-Kernel-PackageImport").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
        clss = (Class_)this.model.getElementById("Classes-Kernel-PackageMerge").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
        clss = (Class_)this.model.getElementById("Classes-Kernel-PackageableElement").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Parameter").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
        this.factory.createGeneralization(clss, "Classes-Kernel-MultiplicityElement");
        clss = (Class_)this.model.getElementById("Classes-Kernel-PrimitiveType").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-DataType");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Property").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-StructuralFeature");
        clss = (Class_)this.model.getElementById("Classes-Kernel-RedefinableElement").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Relationship").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Slot").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Element");
        clss = (Class_)this.model.getElementById("Classes-Kernel-StructuralFeature").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Feature");
        this.factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
        this.factory.createGeneralization(clss, "Classes-Kernel-MultiplicityElement");
        clss = (Class_)this.model.getElementById("Classes-Kernel-Type").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
        clss = (Class_)this.model.getElementById("Classes-Kernel-TypedElement").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("Classes-Kernel-ValueSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
        this.factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
        clss = (Class_)this.model.getElementById("Classes-PowerTypes-Classifier").getDelegate();
        clss = (Class_)this.model.getElementById("Classes-PowerTypes-Generalization").getDelegate();
        clss = (Class_)this.model.getElementById("Classes-PowerTypes-GeneralizationSet").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
        clss = (Class_)this.model.getElementById("CommonBehaviors-BasicBehaviors-Behavior").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Class");
        clss = (Class_)this.model.getElementById("CommonBehaviors-BasicBehaviors-BehavioralFeature").getDelegate();
        clss = (Class_)this.model.getElementById("CommonBehaviors-BasicBehaviors-BehavioredClassifier").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Classifier");
        clss = (Class_)this.model.getElementById("CommonBehaviors-BasicBehaviors-FunctionBehavior").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-OpaqueBehavior");
        clss = (Class_)this.model.getElementById("CommonBehaviors-BasicBehaviors-OpaqueBehavior").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
        clss = (Class_)this.model.getElementById("CommonBehaviors-BasicBehaviors-OpaqueExpression").getDelegate();
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-AnyReceiveEvent").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-Communications-MessageEvent");
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-BehavioralFeature").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Feature");
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-CallEvent").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-Communications-MessageEvent");
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-ChangeEvent").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-Communications-Event");
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-Class").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-BehavioredClassifier");
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-Event").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-Interface").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Classifier");
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-MessageEvent").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-Communications-Event");
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-Operation").getDelegate();
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-Reception").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-Communications-BehavioralFeature");
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-Signal").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Classifier");
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-SignalEvent").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-Communications-MessageEvent");
        clss = (Class_)this.model.getElementById("CommonBehaviors-Communications-Trigger").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-Duration").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-DurationConstraint").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-IntervalConstraint");
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-DurationInterval").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-Interval");
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-DurationObservation").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-Observation");
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-Interval").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-IntervalConstraint").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Constraint");
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-Observation").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-PackageableElement");
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-TimeConstraint").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-IntervalConstraint");
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-TimeEvent").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-Communications-Event");
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-TimeExpression").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-ValueSpecification");
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-TimeInterval").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-Interval");
        clss = (Class_)this.model.getElementById("CommonBehaviors-SimpleTime-TimeObservation").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-SimpleTime-Observation");
        clss = (Class_)this.model.getElementById("Components-BasicComponents-Component").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
        this.factory.createGeneralization(clss, "Classes-Kernel-Class");
        this.factory.createGeneralization(clss, "CompositeStructures-StructuredClasses-Class");
        clss = (Class_)this.model.getElementById("Components-BasicComponents-ComponentRealization").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-Realization");
        clss = (Class_)this.model.getElementById("Components-BasicComponents-ConnectableElement").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
        clss = (Class_)this.model.getElementById("Components-BasicComponents-Connector").getDelegate();
        clss = (Class_)this.model.getElementById("Components-BasicComponents-ConnectorEnd").getDelegate();
        clss = (Class_)this.model.getElementById("Components-PackagingComponents-Component").getDelegate();
        this.factory.createGeneralization(clss, "CompositeStructures-StructuredClasses-Class");
        clss = (Class_)this.model.getElementById("CompositeStructures-Collaborations-Classifier").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Namespace");
        clss = (Class_)this.model.getElementById("CompositeStructures-Collaborations-Collaboration").getDelegate();
        this.factory.createGeneralization(clss, "CompositeStructures-InternalStructures-StructuredClassifier");
        this.factory.createGeneralization(clss, "CompositeStructures-Collaborations-Classifier");
        this.factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-BehavioredClassifier");
        clss = (Class_)this.model.getElementById("CompositeStructures-Collaborations-CollaborationUse").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("CompositeStructures-Collaborations-Parameter").getDelegate();
        this.factory.createGeneralization(clss, "CompositeStructures-InternalStructures-ConnectableElement");
        clss = (Class_)this.model.getElementById("CompositeStructures-InternalStructures-Class").getDelegate();
        this.factory.createGeneralization(clss, "CompositeStructures-InternalStructures-StructuredClassifier");
        clss = (Class_)this.model.getElementById("CompositeStructures-InternalStructures-Classifier").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Namespace");
        clss = (Class_)this.model.getElementById("CompositeStructures-InternalStructures-ConnectableElement").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-TypedElement");
        clss = (Class_)this.model.getElementById("CompositeStructures-InternalStructures-Connector").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Feature");
        this.factory.createGeneralization(clss, "CompositeStructures-InternalStructures-Feature");
        clss = (Class_)this.model.getElementById("CompositeStructures-InternalStructures-ConnectorEnd").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-MultiplicityElement");
        clss = (Class_)this.model.getElementById("CompositeStructures-InternalStructures-Feature").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
        clss = (Class_)this.model.getElementById("CompositeStructures-InternalStructures-Property").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-StructuralFeature");
        this.factory.createGeneralization(clss, "CompositeStructures-InternalStructures-ConnectableElement");
        clss = (Class_)this.model.getElementById("CompositeStructures-InternalStructures-StructuredClassifier").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Classifier");
        this.factory.createGeneralization(clss, "CompositeStructures-InternalStructures-Classifier");
        clss = (Class_)this.model.getElementById("CompositeStructures-InvocationActions-InvocationAction").getDelegate();
        clss = (Class_)this.model.getElementById("CompositeStructures-InvocationActions-Trigger").getDelegate();
        clss = (Class_)this.model.getElementById("CompositeStructures-Ports-ConnectorEnd").getDelegate();
        clss = (Class_)this.model.getElementById("CompositeStructures-Ports-EncapsulatedClassifier").getDelegate();
        this.factory.createGeneralization(clss, "CompositeStructures-InternalStructures-StructuredClassifier");
        clss = (Class_)this.model.getElementById("CompositeStructures-Ports-Port").getDelegate();
        this.factory.createGeneralization(clss, "CompositeStructures-InternalStructures-Property");
        this.factory.createGeneralization(clss, "Classes-Kernel-Property");
        clss = (Class_)this.model.getElementById("CompositeStructures-StructuredActivities-Variable").getDelegate();
        this.factory.createGeneralization(clss, "CompositeStructures-InternalStructures-ConnectableElement");
        clss = (Class_)this.model.getElementById("CompositeStructures-StructuredClasses-Class").getDelegate();
        this.factory.createGeneralization(clss, "CompositeStructures-Ports-EncapsulatedClassifier");
        clss = (Class_)this.model.getElementById("Deployments-Artifacts-Artifact").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Classifier");
        this.factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
        clss = (Class_)this.model.getElementById("Deployments-Artifacts-Manifestation").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-Abstraction");
        clss = (Class_)this.model.getElementById("Deployments-ComponentDeployments-Deployment").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-Dependency");
        clss = (Class_)this.model.getElementById("Deployments-ComponentDeployments-DeploymentSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Deployments-Nodes-Artifact");
        clss = (Class_)this.model.getElementById("Deployments-Nodes-Artifact").getDelegate();
        this.factory.createGeneralization(clss, "Deployments-Nodes-DeployedArtifact");
        clss = (Class_)this.model.getElementById("Deployments-Nodes-CommunicationPath").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Association");
        clss = (Class_)this.model.getElementById("Deployments-Nodes-DeployedArtifact").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
        clss = (Class_)this.model.getElementById("Deployments-Nodes-Deployment").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-Dependency");
        clss = (Class_)this.model.getElementById("Deployments-Nodes-DeploymentTarget").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Dependencies-NamedElement");
        clss = (Class_)this.model.getElementById("Deployments-Nodes-Device").getDelegate();
        this.factory.createGeneralization(clss, "Deployments-Nodes-Node");
        clss = (Class_)this.model.getElementById("Deployments-Nodes-ExecutionEnvironment").getDelegate();
        this.factory.createGeneralization(clss, "Deployments-Nodes-Node");
        clss = (Class_)this.model.getElementById("Deployments-Nodes-InstanceSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Deployments-Nodes-DeployedArtifact");
        this.factory.createGeneralization(clss, "Deployments-Nodes-DeploymentTarget");
        clss = (Class_)this.model.getElementById("Deployments-Nodes-Node").getDelegate();
        this.factory.createGeneralization(clss, "CompositeStructures-StructuredClasses-Class");
        this.factory.createGeneralization(clss, "Deployments-Nodes-DeploymentTarget");
        clss = (Class_)this.model.getElementById("Deployments-Nodes-Property").getDelegate();
        this.factory.createGeneralization(clss, "Deployments-Nodes-DeploymentTarget");
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-ActionExecutionSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Interactions-BasicInteractions-ExecutionSpecification");
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-BehaviorExecutionSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Interactions-BasicInteractions-ExecutionSpecification");
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-DestructionOccurrenceSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Interactions-BasicInteractions-MessageOccurrenceSpecification");
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-ExecutionOccurrenceSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Interactions-BasicInteractions-OccurrenceSpecification");
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-ExecutionSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Interactions-BasicInteractions-InteractionFragment");
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-GeneralOrdering").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-Interaction").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
        this.factory.createGeneralization(clss, "Interactions-BasicInteractions-InteractionFragment");
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-InteractionFragment").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-Lifeline").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-Message").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-MessageEnd").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-MessageOccurrenceSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Interactions-BasicInteractions-OccurrenceSpecification");
        this.factory.createGeneralization(clss, "Interactions-BasicInteractions-MessageEnd");
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-OccurrenceSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Interactions-BasicInteractions-InteractionFragment");
        clss = (Class_)this.model.getElementById("Interactions-BasicInteractions-StateInvariant").getDelegate();
        this.factory.createGeneralization(clss, "Interactions-BasicInteractions-InteractionFragment");
        clss = (Class_)this.model.getElementById("Interactions-Fragments-CombinedFragment").getDelegate();
        this.factory.createGeneralization(clss, "Interactions-Fragments-InteractionFragment");
        clss = (Class_)this.model.getElementById("Interactions-Fragments-ConsiderIgnoreFragment").getDelegate();
        this.factory.createGeneralization(clss, "Interactions-Fragments-CombinedFragment");
        clss = (Class_)this.model.getElementById("Interactions-Fragments-Continuation").getDelegate();
        this.factory.createGeneralization(clss, "Interactions-Fragments-InteractionFragment");
        clss = (Class_)this.model.getElementById("Interactions-Fragments-Gate").getDelegate();
        this.factory.createGeneralization(clss, "Interactions-BasicInteractions-MessageEnd");
        clss = (Class_)this.model.getElementById("Interactions-Fragments-Interaction").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
        clss = (Class_)this.model.getElementById("Interactions-Fragments-InteractionConstraint").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Constraint");
        clss = (Class_)this.model.getElementById("Interactions-Fragments-InteractionFragment").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("Interactions-Fragments-InteractionOperand").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Namespace");
        this.factory.createGeneralization(clss, "Interactions-Fragments-InteractionFragment");
        clss = (Class_)this.model.getElementById("Interactions-Fragments-InteractionUse").getDelegate();
        this.factory.createGeneralization(clss, "Interactions-Fragments-InteractionFragment");
        clss = (Class_)this.model.getElementById("Interactions-Fragments-Lifeline").getDelegate();
        clss = (Class_)this.model.getElementById("Interactions-Fragments-PartDecomposition").getDelegate();
        this.factory.createGeneralization(clss, "Interactions-Fragments-InteractionUse");
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-ConnectionPointReference").getDelegate();
        this.factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-Vertex");
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-FinalState").getDelegate();
        this.factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-State");
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-Pseudostate").getDelegate();
        this.factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-Vertex");
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-Region").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
        this.factory.createGeneralization(clss, "Classes-Kernel-Namespace");
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-State").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
        this.factory.createGeneralization(clss, "Classes-Kernel-Namespace");
        this.factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-Vertex");
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-StateMachine").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-Behavior");
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-TimeEvent").getDelegate();
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-Transition").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Namespace");
        this.factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
        clss = (Class_)this.model.getElementById("StateMachines-BehaviorStateMachines-Vertex").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("StateMachines-ProtocolStateMachines-Interface").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Classifier");
        clss = (Class_)this.model.getElementById("StateMachines-ProtocolStateMachines-Port").getDelegate();
        clss = (Class_)this.model.getElementById("StateMachines-ProtocolStateMachines-ProtocolConformance").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
        clss = (Class_)this.model.getElementById("StateMachines-ProtocolStateMachines-ProtocolStateMachine").getDelegate();
        this.factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-StateMachine");
        clss = (Class_)this.model.getElementById("StateMachines-ProtocolStateMachines-ProtocolTransition").getDelegate();
        this.factory.createGeneralization(clss, "StateMachines-BehaviorStateMachines-Transition");
        clss = (Class_)this.model.getElementById("StateMachines-ProtocolStateMachines-Region").getDelegate();
        clss = (Class_)this.model.getElementById("StateMachines-ProtocolStateMachines-State").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Namespace");
        clss = (Class_)this.model.getElementById("UseCases-Actor").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-BehavioredClassifier");
        clss = (Class_)this.model.getElementById("UseCases-Classifier").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-Namespace");
        clss = (Class_)this.model.getElementById("UseCases-Extend").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        clss = (Class_)this.model.getElementById("UseCases-ExtensionPoint").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-RedefinableElement");
        clss = (Class_)this.model.getElementById("UseCases-Include").getDelegate();
        this.factory.createGeneralization(clss, "Classes-Kernel-NamedElement");
        this.factory.createGeneralization(clss, "Classes-Kernel-DirectedRelationship");
        clss = (Class_)this.model.getElementById("UseCases-UseCase").getDelegate();
        this.factory.createGeneralization(clss, "CommonBehaviors-BasicBehaviors-BehavioredClassifier");
    }

    /*
     * Opcode count of 27065 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private void constructAssociations() {
        String packageId = null;
        Association assoc = null;
        Property prop = null;
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        Package cfr_ignored_0 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_argument_invocationAction", "Actions-BasicActions-A_argument_invocationAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        prop = this.factory.createProperty(assoc, "invocationAction", "Actions-BasicActions-A_argument_invocationAction-invocationAction", "Actions-BasicActions-InvocationAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-BasicActions-InvocationAction-argument Actions-BasicActions-A_argument_invocationAction-invocationAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        Package cfr_ignored_1 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_behavior_callBehaviorAction", "Actions-BasicActions-A_behavior_callBehaviorAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        prop = this.factory.createProperty(assoc, "callBehaviorAction", "Actions-BasicActions-A_behavior_callBehaviorAction-callBehaviorAction", "Actions-BasicActions-CallBehaviorAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-BasicActions-CallBehaviorAction-behavior Actions-BasicActions-A_behavior_callBehaviorAction-callBehaviorAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        Package cfr_ignored_2 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_context_action", "Actions-BasicActions-A_context_action");
        this.mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        prop = this.factory.createProperty(assoc, "action", "Actions-BasicActions-A_context_action-action", "Actions-BasicActions-Action", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-BasicActions-Action-context Actions-BasicActions-A_context_action-action");
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        Package cfr_ignored_3 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inputValue_opaqueAction", "Actions-BasicActions-A_inputValue_opaqueAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        prop = this.factory.createProperty(assoc, "opaqueAction", "Actions-BasicActions-A_inputValue_opaqueAction-opaqueAction", "Actions-BasicActions-OpaqueAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-BasicActions-OpaqueAction-inputValue Actions-BasicActions-A_inputValue_opaqueAction-opaqueAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        Package cfr_ignored_4 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_input_action", "Actions-BasicActions-A_input_action");
        this.mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        prop = this.factory.createProperty(assoc, "action", "Actions-BasicActions-A_input_action-action", "Actions-BasicActions-Action", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-BasicActions-Action-input Actions-BasicActions-A_input_action-action");
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        Package cfr_ignored_5 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_operation_callOperationAction", "Actions-BasicActions-A_operation_callOperationAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        prop = this.factory.createProperty(assoc, "callOperationAction", "Actions-BasicActions-A_operation_callOperationAction-callOperationAction", "Actions-BasicActions-CallOperationAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-BasicActions-CallOperationAction-operation Actions-BasicActions-A_operation_callOperationAction-callOperationAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        Package cfr_ignored_6 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_outputValue_opaqueAction", "Actions-BasicActions-A_outputValue_opaqueAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        prop = this.factory.createProperty(assoc, "opaqueAction", "Actions-BasicActions-A_outputValue_opaqueAction-opaqueAction", "Actions-BasicActions-OpaqueAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-BasicActions-OpaqueAction-outputValue Actions-BasicActions-A_outputValue_opaqueAction-opaqueAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        Package cfr_ignored_7 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_output_action", "Actions-BasicActions-A_output_action");
        this.mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        prop = this.factory.createProperty(assoc, "action", "Actions-BasicActions-A_output_action-action", "Actions-BasicActions-Action", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-BasicActions-Action-output Actions-BasicActions-A_output_action-action");
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        Package cfr_ignored_8 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_callAction", "Actions-BasicActions-A_result_callAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        prop = this.factory.createProperty(assoc, "callAction", "Actions-BasicActions-A_result_callAction-callAction", "Actions-BasicActions-CallAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-BasicActions-CallAction-result Actions-BasicActions-A_result_callAction-callAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        Package cfr_ignored_9 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_signal_sendSignalAction", "Actions-BasicActions-A_signal_sendSignalAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        prop = this.factory.createProperty(assoc, "sendSignalAction", "Actions-BasicActions-A_signal_sendSignalAction-sendSignalAction", "Actions-BasicActions-SendSignalAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-BasicActions-SendSignalAction-signal Actions-BasicActions-A_signal_sendSignalAction-sendSignalAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        Package cfr_ignored_10 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_target_callOperationAction", "Actions-BasicActions-A_target_callOperationAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        prop = this.factory.createProperty(assoc, "callOperationAction", "Actions-BasicActions-A_target_callOperationAction-callOperationAction", "Actions-BasicActions-CallOperationAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-BasicActions-CallOperationAction-target Actions-BasicActions-A_target_callOperationAction-callOperationAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        Package cfr_ignored_11 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_target_sendSignalAction", "Actions-BasicActions-A_target_sendSignalAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        prop = this.factory.createProperty(assoc, "sendSignalAction", "Actions-BasicActions-A_target_sendSignalAction-sendSignalAction", "Actions-BasicActions-SendSignalAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-BasicActions-SendSignalAction-target Actions-BasicActions-A_target_sendSignalAction-sendSignalAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-BasicActions";
        Package cfr_ignored_12 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_value_valuePin", "Actions-BasicActions-A_value_valuePin");
        this.mapping.mapAssociation(assoc, "UML.Actions.BasicActions", this);
        prop = this.factory.createProperty(assoc, "valuePin", "Actions-BasicActions-A_value_valuePin-valuePin", "Actions-BasicActions-ValuePin", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-BasicActions-ValuePin-value Actions-BasicActions-A_value_valuePin-valuePin");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_13 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_classifier_readExtentAction", "Actions-CompleteActions-A_classifier_readExtentAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "readExtentAction", "Actions-CompleteActions-A_classifier_readExtentAction-readExtentAction", "Actions-CompleteActions-ReadExtentAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadExtentAction-classifier Actions-CompleteActions-A_classifier_readExtentAction-readExtentAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_14 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_classifier_readIsClassifiedObjectAction", "Actions-CompleteActions-A_classifier_readIsClassifiedObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "readIsClassifiedObjectAction", "Actions-CompleteActions-A_classifier_readIsClassifiedObjectAction-readIsClassifiedObjectAction", "Actions-CompleteActions-ReadIsClassifiedObjectAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadIsClassifiedObjectAction-classifier Actions-CompleteActions-A_classifier_readIsClassifiedObjectAction-readIsClassifiedObjectAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_15 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_collection_reduceAction", "Actions-CompleteActions-A_collection_reduceAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "reduceAction", "Actions-CompleteActions-A_collection_reduceAction-reduceAction", "Actions-CompleteActions-ReduceAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReduceAction-collection Actions-CompleteActions-A_collection_reduceAction-reduceAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_16 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_end_readLinkObjectEndAction", "Actions-CompleteActions-A_end_readLinkObjectEndAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "readLinkObjectEndAction", "Actions-CompleteActions-A_end_readLinkObjectEndAction-readLinkObjectEndAction", "Actions-CompleteActions-ReadLinkObjectEndAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndAction-end Actions-CompleteActions-A_end_readLinkObjectEndAction-readLinkObjectEndAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_17 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_newClassifier_reclassifyObjectAction", "Actions-CompleteActions-A_newClassifier_reclassifyObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "reclassifyObjectAction", "Actions-CompleteActions-A_newClassifier_reclassifyObjectAction-reclassifyObjectAction", "Actions-CompleteActions-ReclassifyObjectAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReclassifyObjectAction-newClassifier Actions-CompleteActions-A_newClassifier_reclassifyObjectAction-reclassifyObjectAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_18 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_readIsClassifiedObjectAction", "Actions-CompleteActions-A_object_readIsClassifiedObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "readIsClassifiedObjectAction", "Actions-CompleteActions-A_object_readIsClassifiedObjectAction-readIsClassifiedObjectAction", "Actions-CompleteActions-ReadIsClassifiedObjectAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadIsClassifiedObjectAction-object Actions-CompleteActions-A_object_readIsClassifiedObjectAction-readIsClassifiedObjectAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_19 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_readLinkObjectEndAction", "Actions-CompleteActions-A_object_readLinkObjectEndAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "readLinkObjectEndAction", "Actions-CompleteActions-A_object_readLinkObjectEndAction-readLinkObjectEndAction", "Actions-CompleteActions-ReadLinkObjectEndAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndAction-object Actions-CompleteActions-A_object_readLinkObjectEndAction-readLinkObjectEndAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_20 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_readLinkObjectEndQualifierAction", "Actions-CompleteActions-A_object_readLinkObjectEndQualifierAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "readLinkObjectEndQualifierAction", "Actions-CompleteActions-A_object_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction", "Actions-CompleteActions-ReadLinkObjectEndQualifierAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-object Actions-CompleteActions-A_object_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_21 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_reclassifyObjectAction", "Actions-CompleteActions-A_object_reclassifyObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "reclassifyObjectAction", "Actions-CompleteActions-A_object_reclassifyObjectAction-reclassifyObjectAction", "Actions-CompleteActions-ReclassifyObjectAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReclassifyObjectAction-object Actions-CompleteActions-A_object_reclassifyObjectAction-reclassifyObjectAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_22 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_startClassifierBehaviorAction", "Actions-CompleteActions-A_object_startClassifierBehaviorAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "startClassifierBehaviorAction", "Actions-CompleteActions-A_object_startClassifierBehaviorAction-startClassifierBehaviorAction", "Actions-CompleteActions-StartClassifierBehaviorAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-StartClassifierBehaviorAction-object Actions-CompleteActions-A_object_startClassifierBehaviorAction-startClassifierBehaviorAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_23 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_startObjectBehaviorAction", "Actions-CompleteActions-A_object_startObjectBehaviorAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "startObjectBehaviorAction", "Actions-CompleteActions-A_object_startObjectBehaviorAction-startObjectBehaviorAction", "Actions-CompleteActions-StartObjectBehaviorAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-StartObjectBehaviorAction-object Actions-CompleteActions-A_object_startObjectBehaviorAction-startObjectBehaviorAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_24 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_unmarshallAction", "Actions-CompleteActions-A_object_unmarshallAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "unmarshallAction", "Actions-CompleteActions-A_object_unmarshallAction-unmarshallAction", "Actions-CompleteActions-UnmarshallAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-UnmarshallAction-object Actions-CompleteActions-A_object_unmarshallAction-unmarshallAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_25 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_oldClassifier_reclassifyObjectAction", "Actions-CompleteActions-A_oldClassifier_reclassifyObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "reclassifyObjectAction", "Actions-CompleteActions-A_oldClassifier_reclassifyObjectAction-reclassifyObjectAction", "Actions-CompleteActions-ReclassifyObjectAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReclassifyObjectAction-oldClassifier Actions-CompleteActions-A_oldClassifier_reclassifyObjectAction-reclassifyObjectAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_26 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_qualifier_linkEndData", "Actions-CompleteActions-A_qualifier_linkEndData");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "linkEndData", "Actions-CompleteActions-A_qualifier_linkEndData-linkEndData", "Actions-CompleteActions-LinkEndData", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-LinkEndData-qualifier Actions-CompleteActions-A_qualifier_linkEndData-linkEndData");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_27 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_qualifier_qualifierValue", "Actions-CompleteActions-A_qualifier_qualifierValue");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "qualifierValue", "Actions-CompleteActions-A_qualifier_qualifierValue-qualifierValue", "Actions-CompleteActions-QualifierValue", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-QualifierValue-qualifier Actions-CompleteActions-A_qualifier_qualifierValue-qualifierValue");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_28 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_qualifier_readLinkObjectEndQualifierAction", "Actions-CompleteActions-A_qualifier_readLinkObjectEndQualifierAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "readLinkObjectEndQualifierAction", "Actions-CompleteActions-A_qualifier_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction", "Actions-CompleteActions-ReadLinkObjectEndQualifierAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-qualifier Actions-CompleteActions-A_qualifier_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_29 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_reducer_reduceAction", "Actions-CompleteActions-A_reducer_reduceAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "reduceAction", "Actions-CompleteActions-A_reducer_reduceAction-reduceAction", "Actions-CompleteActions-ReduceAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReduceAction-reducer Actions-CompleteActions-A_reducer_reduceAction-reduceAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_30 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_replyToCall_replyAction", "Actions-CompleteActions-A_replyToCall_replyAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "replyAction", "Actions-CompleteActions-A_replyToCall_replyAction-replyAction", "Actions-CompleteActions-ReplyAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReplyAction-replyToCall Actions-CompleteActions-A_replyToCall_replyAction-replyAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_31 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_replyValue_replyAction", "Actions-CompleteActions-A_replyValue_replyAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "replyAction", "Actions-CompleteActions-A_replyValue_replyAction-replyAction", "Actions-CompleteActions-ReplyAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReplyAction-replyValue Actions-CompleteActions-A_replyValue_replyAction-replyAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_32 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_acceptEventAction", "Actions-CompleteActions-A_result_acceptEventAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "acceptEventAction", "Actions-CompleteActions-A_result_acceptEventAction-acceptEventAction", "Actions-CompleteActions-AcceptEventAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-AcceptEventAction-result Actions-CompleteActions-A_result_acceptEventAction-acceptEventAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_33 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_createLinkObjectAction", "Actions-CompleteActions-A_result_createLinkObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "createLinkObjectAction", "Actions-CompleteActions-A_result_createLinkObjectAction-createLinkObjectAction", "Actions-CompleteActions-CreateLinkObjectAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-CreateLinkObjectAction-result Actions-CompleteActions-A_result_createLinkObjectAction-createLinkObjectAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_34 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_readExtentAction", "Actions-CompleteActions-A_result_readExtentAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "readExtentAction", "Actions-CompleteActions-A_result_readExtentAction-readExtentAction", "Actions-CompleteActions-ReadExtentAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadExtentAction-result Actions-CompleteActions-A_result_readExtentAction-readExtentAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_35 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_readIsClassifiedObjectAction", "Actions-CompleteActions-A_result_readIsClassifiedObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "readIsClassifiedObjectAction", "Actions-CompleteActions-A_result_readIsClassifiedObjectAction-readIsClassifiedObjectAction", "Actions-CompleteActions-ReadIsClassifiedObjectAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadIsClassifiedObjectAction-result Actions-CompleteActions-A_result_readIsClassifiedObjectAction-readIsClassifiedObjectAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_36 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_readLinkObjectEndAction", "Actions-CompleteActions-A_result_readLinkObjectEndAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "readLinkObjectEndAction", "Actions-CompleteActions-A_result_readLinkObjectEndAction-readLinkObjectEndAction", "Actions-CompleteActions-ReadLinkObjectEndAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndAction-result Actions-CompleteActions-A_result_readLinkObjectEndAction-readLinkObjectEndAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_37 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_readLinkObjectEndQualifierAction", "Actions-CompleteActions-A_result_readLinkObjectEndQualifierAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "readLinkObjectEndQualifierAction", "Actions-CompleteActions-A_result_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction", "Actions-CompleteActions-ReadLinkObjectEndQualifierAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReadLinkObjectEndQualifierAction-result Actions-CompleteActions-A_result_readLinkObjectEndQualifierAction-readLinkObjectEndQualifierAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_38 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_reduceAction", "Actions-CompleteActions-A_result_reduceAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "reduceAction", "Actions-CompleteActions-A_result_reduceAction-reduceAction", "Actions-CompleteActions-ReduceAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReduceAction-result Actions-CompleteActions-A_result_reduceAction-reduceAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_39 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_unmarshallAction", "Actions-CompleteActions-A_result_unmarshallAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "unmarshallAction", "Actions-CompleteActions-A_result_unmarshallAction-unmarshallAction", "Actions-CompleteActions-UnmarshallAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-UnmarshallAction-result Actions-CompleteActions-A_result_unmarshallAction-unmarshallAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_40 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_returnInformation_acceptCallAction", "Actions-CompleteActions-A_returnInformation_acceptCallAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "acceptCallAction", "Actions-CompleteActions-A_returnInformation_acceptCallAction-acceptCallAction", "Actions-CompleteActions-AcceptCallAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-AcceptCallAction-returnInformation Actions-CompleteActions-A_returnInformation_acceptCallAction-acceptCallAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_41 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_returnInformation_replyAction", "Actions-CompleteActions-A_returnInformation_replyAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "replyAction", "Actions-CompleteActions-A_returnInformation_replyAction-replyAction", "Actions-CompleteActions-ReplyAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-ReplyAction-returnInformation Actions-CompleteActions-A_returnInformation_replyAction-replyAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_42 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_trigger_acceptEventAction", "Actions-CompleteActions-A_trigger_acceptEventAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "acceptEventAction", "Actions-CompleteActions-A_trigger_acceptEventAction-acceptEventAction", "Actions-CompleteActions-AcceptEventAction", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-AcceptEventAction-trigger Actions-CompleteActions-A_trigger_acceptEventAction-acceptEventAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_43 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_unmarshallType_unmarshallAction", "Actions-CompleteActions-A_unmarshallType_unmarshallAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "unmarshallAction", "Actions-CompleteActions-A_unmarshallType_unmarshallAction-unmarshallAction", "Actions-CompleteActions-UnmarshallAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-UnmarshallAction-unmarshallType Actions-CompleteActions-A_unmarshallType_unmarshallAction-unmarshallAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-CompleteActions";
        Package cfr_ignored_44 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_value_qualifierValue", "Actions-CompleteActions-A_value_qualifierValue");
        this.mapping.mapAssociation(assoc, "UML.Actions.CompleteActions", this);
        prop = this.factory.createProperty(assoc, "qualifierValue", "Actions-CompleteActions-A_value_qualifierValue-qualifierValue", "Actions-CompleteActions-QualifierValue", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-CompleteActions-QualifierValue-value Actions-CompleteActions-A_value_qualifierValue-qualifierValue");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_45 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_association_clearAssociationAction", "Actions-IntermediateActions-A_association_clearAssociationAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "clearAssociationAction", "Actions-IntermediateActions-A_association_clearAssociationAction-clearAssociationAction", "Actions-IntermediateActions-ClearAssociationAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ClearAssociationAction-association Actions-IntermediateActions-A_association_clearAssociationAction-clearAssociationAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_46 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_classifier_createObjectAction", "Actions-IntermediateActions-A_classifier_createObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "createObjectAction", "Actions-IntermediateActions-A_classifier_createObjectAction-createObjectAction", "Actions-IntermediateActions-CreateObjectAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-CreateObjectAction-classifier Actions-IntermediateActions-A_classifier_createObjectAction-createObjectAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_47 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_destroyAt_linkEndDestructionData", "Actions-IntermediateActions-A_destroyAt_linkEndDestructionData");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "linkEndDestructionData", "Actions-IntermediateActions-A_destroyAt_linkEndDestructionData-linkEndDestructionData", "Actions-IntermediateActions-LinkEndDestructionData", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkEndDestructionData-destroyAt Actions-IntermediateActions-A_destroyAt_linkEndDestructionData-linkEndDestructionData");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_48 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_endData_createLinkAction", "Actions-IntermediateActions-A_endData_createLinkAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "createLinkAction", "Actions-IntermediateActions-A_endData_createLinkAction-createLinkAction", "Actions-IntermediateActions-CreateLinkAction", "", "Actions-IntermediateActions-A_endData_linkAction-linkAction", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-CreateLinkAction-endData Actions-IntermediateActions-A_endData_createLinkAction-createLinkAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_49 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_endData_destroyLinkAction", "Actions-IntermediateActions-A_endData_destroyLinkAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "destroyLinkAction", "Actions-IntermediateActions-A_endData_destroyLinkAction-destroyLinkAction", "Actions-IntermediateActions-DestroyLinkAction", "", "Actions-IntermediateActions-A_endData_linkAction-linkAction", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-DestroyLinkAction-endData Actions-IntermediateActions-A_endData_destroyLinkAction-destroyLinkAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_50 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_endData_linkAction", "Actions-IntermediateActions-A_endData_linkAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "linkAction", "Actions-IntermediateActions-A_endData_linkAction-linkAction", "Actions-IntermediateActions-LinkAction", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkAction-endData Actions-IntermediateActions-A_endData_linkAction-linkAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_51 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_end_linkEndData", "Actions-IntermediateActions-A_end_linkEndData");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "linkEndData", "Actions-IntermediateActions-A_end_linkEndData-linkEndData", "Actions-IntermediateActions-LinkEndData", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkEndData-end Actions-IntermediateActions-A_end_linkEndData-linkEndData");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_52 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_first_testIdentityAction", "Actions-IntermediateActions-A_first_testIdentityAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "testIdentityAction", "Actions-IntermediateActions-A_first_testIdentityAction-testIdentityAction", "Actions-IntermediateActions-TestIdentityAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-TestIdentityAction-first Actions-IntermediateActions-A_first_testIdentityAction-testIdentityAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_53 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inputValue_linkAction", "Actions-IntermediateActions-A_inputValue_linkAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "linkAction", "Actions-IntermediateActions-A_inputValue_linkAction-linkAction", "Actions-IntermediateActions-LinkAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkAction-inputValue Actions-IntermediateActions-A_inputValue_linkAction-linkAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_54 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_insertAt_addStructuralFeatureValueAction", "Actions-IntermediateActions-A_insertAt_addStructuralFeatureValueAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "addStructuralFeatureValueAction", "Actions-IntermediateActions-A_insertAt_addStructuralFeatureValueAction-addStructuralFeatureValueAction", "Actions-IntermediateActions-AddStructuralFeatureValueAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-AddStructuralFeatureValueAction-insertAt Actions-IntermediateActions-A_insertAt_addStructuralFeatureValueAction-addStructuralFeatureValueAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_55 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_insertAt_linkEndCreationData", "Actions-IntermediateActions-A_insertAt_linkEndCreationData");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "linkEndCreationData", "Actions-IntermediateActions-A_insertAt_linkEndCreationData-linkEndCreationData", "Actions-IntermediateActions-LinkEndCreationData", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkEndCreationData-insertAt Actions-IntermediateActions-A_insertAt_linkEndCreationData-linkEndCreationData");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_56 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_clearAssociationAction", "Actions-IntermediateActions-A_object_clearAssociationAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "clearAssociationAction", "Actions-IntermediateActions-A_object_clearAssociationAction-clearAssociationAction", "Actions-IntermediateActions-ClearAssociationAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ClearAssociationAction-object Actions-IntermediateActions-A_object_clearAssociationAction-clearAssociationAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_57 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_object_structuralFeatureAction", "Actions-IntermediateActions-A_object_structuralFeatureAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "structuralFeatureAction", "Actions-IntermediateActions-A_object_structuralFeatureAction-structuralFeatureAction", "Actions-IntermediateActions-StructuralFeatureAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-StructuralFeatureAction-object Actions-IntermediateActions-A_object_structuralFeatureAction-structuralFeatureAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_58 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_removeAt_removeStructuralFeatureValueAction", "Actions-IntermediateActions-A_removeAt_removeStructuralFeatureValueAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "removeStructuralFeatureValueAction", "Actions-IntermediateActions-A_removeAt_removeStructuralFeatureValueAction-removeStructuralFeatureValueAction", "Actions-IntermediateActions-RemoveStructuralFeatureValueAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-RemoveStructuralFeatureValueAction-removeAt Actions-IntermediateActions-A_removeAt_removeStructuralFeatureValueAction-removeStructuralFeatureValueAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_59 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_request_sendObjectAction", "Actions-IntermediateActions-A_request_sendObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "sendObjectAction", "Actions-IntermediateActions-A_request_sendObjectAction-sendObjectAction", "Actions-IntermediateActions-SendObjectAction", "", "Actions-BasicActions-A_argument_invocationAction-invocationAction", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-SendObjectAction-request Actions-IntermediateActions-A_request_sendObjectAction-sendObjectAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_60 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_clearStructuralFeatureAction", "Actions-IntermediateActions-A_result_clearStructuralFeatureAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "clearStructuralFeatureAction", "Actions-IntermediateActions-A_result_clearStructuralFeatureAction-clearStructuralFeatureAction", "Actions-IntermediateActions-ClearStructuralFeatureAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ClearStructuralFeatureAction-result Actions-IntermediateActions-A_result_clearStructuralFeatureAction-clearStructuralFeatureAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_61 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_createObjectAction", "Actions-IntermediateActions-A_result_createObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "createObjectAction", "Actions-IntermediateActions-A_result_createObjectAction-createObjectAction", "Actions-IntermediateActions-CreateObjectAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-CreateObjectAction-result Actions-IntermediateActions-A_result_createObjectAction-createObjectAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_62 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_readLinkAction", "Actions-IntermediateActions-A_result_readLinkAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "readLinkAction", "Actions-IntermediateActions-A_result_readLinkAction-readLinkAction", "Actions-IntermediateActions-ReadLinkAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ReadLinkAction-result Actions-IntermediateActions-A_result_readLinkAction-readLinkAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_63 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_readSelfAction", "Actions-IntermediateActions-A_result_readSelfAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "readSelfAction", "Actions-IntermediateActions-A_result_readSelfAction-readSelfAction", "Actions-IntermediateActions-ReadSelfAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ReadSelfAction-result Actions-IntermediateActions-A_result_readSelfAction-readSelfAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_64 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_readStructuralFeatureAction", "Actions-IntermediateActions-A_result_readStructuralFeatureAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "readStructuralFeatureAction", "Actions-IntermediateActions-A_result_readStructuralFeatureAction-readStructuralFeatureAction", "Actions-IntermediateActions-ReadStructuralFeatureAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ReadStructuralFeatureAction-result Actions-IntermediateActions-A_result_readStructuralFeatureAction-readStructuralFeatureAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_65 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_testIdentityAction", "Actions-IntermediateActions-A_result_testIdentityAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "testIdentityAction", "Actions-IntermediateActions-A_result_testIdentityAction-testIdentityAction", "Actions-IntermediateActions-TestIdentityAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-TestIdentityAction-result Actions-IntermediateActions-A_result_testIdentityAction-testIdentityAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_66 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_valueSpecificationAction", "Actions-IntermediateActions-A_result_valueSpecificationAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "valueSpecificationAction", "Actions-IntermediateActions-A_result_valueSpecificationAction-valueSpecificationAction", "Actions-IntermediateActions-ValueSpecificationAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ValueSpecificationAction-result Actions-IntermediateActions-A_result_valueSpecificationAction-valueSpecificationAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_67 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_writeStructuralFeatureAction", "Actions-IntermediateActions-A_result_writeStructuralFeatureAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "writeStructuralFeatureAction", "Actions-IntermediateActions-A_result_writeStructuralFeatureAction-writeStructuralFeatureAction", "Actions-IntermediateActions-WriteStructuralFeatureAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-WriteStructuralFeatureAction-result Actions-IntermediateActions-A_result_writeStructuralFeatureAction-writeStructuralFeatureAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_68 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_second_testIdentityAction", "Actions-IntermediateActions-A_second_testIdentityAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "testIdentityAction", "Actions-IntermediateActions-A_second_testIdentityAction-testIdentityAction", "Actions-IntermediateActions-TestIdentityAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-TestIdentityAction-second Actions-IntermediateActions-A_second_testIdentityAction-testIdentityAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_69 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_signal_broadcastSignalAction", "Actions-IntermediateActions-A_signal_broadcastSignalAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "broadcastSignalAction", "Actions-IntermediateActions-A_signal_broadcastSignalAction-broadcastSignalAction", "Actions-IntermediateActions-BroadcastSignalAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-BroadcastSignalAction-signal Actions-IntermediateActions-A_signal_broadcastSignalAction-broadcastSignalAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_70 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_structuralFeature_structuralFeatureAction", "Actions-IntermediateActions-A_structuralFeature_structuralFeatureAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "structuralFeatureAction", "Actions-IntermediateActions-A_structuralFeature_structuralFeatureAction-structuralFeatureAction", "Actions-IntermediateActions-StructuralFeatureAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-StructuralFeatureAction-structuralFeature Actions-IntermediateActions-A_structuralFeature_structuralFeatureAction-structuralFeatureAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_71 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_target_destroyObjectAction", "Actions-IntermediateActions-A_target_destroyObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "destroyObjectAction", "Actions-IntermediateActions-A_target_destroyObjectAction-destroyObjectAction", "Actions-IntermediateActions-DestroyObjectAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-DestroyObjectAction-target Actions-IntermediateActions-A_target_destroyObjectAction-destroyObjectAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_72 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_target_sendObjectAction", "Actions-IntermediateActions-A_target_sendObjectAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "sendObjectAction", "Actions-IntermediateActions-A_target_sendObjectAction-sendObjectAction", "Actions-IntermediateActions-SendObjectAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-SendObjectAction-target Actions-IntermediateActions-A_target_sendObjectAction-sendObjectAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_73 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_value_linkEndData", "Actions-IntermediateActions-A_value_linkEndData");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "linkEndData", "Actions-IntermediateActions-A_value_linkEndData-linkEndData", "Actions-IntermediateActions-LinkEndData", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-LinkEndData-value Actions-IntermediateActions-A_value_linkEndData-linkEndData");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_74 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_value_valueSpecificationAction", "Actions-IntermediateActions-A_value_valueSpecificationAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "valueSpecificationAction", "Actions-IntermediateActions-A_value_valueSpecificationAction-valueSpecificationAction", "Actions-IntermediateActions-ValueSpecificationAction", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-ValueSpecificationAction-value Actions-IntermediateActions-A_value_valueSpecificationAction-valueSpecificationAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-IntermediateActions";
        Package cfr_ignored_75 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_value_writeStructuralFeatureAction", "Actions-IntermediateActions-A_value_writeStructuralFeatureAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.IntermediateActions", this);
        prop = this.factory.createProperty(assoc, "writeStructuralFeatureAction", "Actions-IntermediateActions-A_value_writeStructuralFeatureAction-writeStructuralFeatureAction", "Actions-IntermediateActions-WriteStructuralFeatureAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-IntermediateActions-WriteStructuralFeatureAction-value Actions-IntermediateActions-A_value_writeStructuralFeatureAction-writeStructuralFeatureAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";
        Package cfr_ignored_76 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_exception_raiseExceptionAction", "Actions-StructuredActions-A_exception_raiseExceptionAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.StructuredActions", this);
        prop = this.factory.createProperty(assoc, "raiseExceptionAction", "Actions-StructuredActions-A_exception_raiseExceptionAction-raiseExceptionAction", "Actions-StructuredActions-RaiseExceptionAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-StructuredActions-RaiseExceptionAction-exception Actions-StructuredActions-A_exception_raiseExceptionAction-raiseExceptionAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";
        Package cfr_ignored_77 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_fromAction_actionInputPin", "Actions-StructuredActions-A_fromAction_actionInputPin");
        this.mapping.mapAssociation(assoc, "UML.Actions.StructuredActions", this);
        prop = this.factory.createProperty(assoc, "actionInputPin", "Actions-StructuredActions-A_fromAction_actionInputPin-actionInputPin", "Actions-StructuredActions-ActionInputPin", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-StructuredActions-ActionInputPin-fromAction Actions-StructuredActions-A_fromAction_actionInputPin-actionInputPin");
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";
        Package cfr_ignored_78 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_insertAt_addVariableValueAction", "Actions-StructuredActions-A_insertAt_addVariableValueAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.StructuredActions", this);
        prop = this.factory.createProperty(assoc, "addVariableValueAction", "Actions-StructuredActions-A_insertAt_addVariableValueAction-addVariableValueAction", "Actions-StructuredActions-AddVariableValueAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-StructuredActions-AddVariableValueAction-insertAt Actions-StructuredActions-A_insertAt_addVariableValueAction-addVariableValueAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";
        Package cfr_ignored_79 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_removeAt_removeVariableValueAction", "Actions-StructuredActions-A_removeAt_removeVariableValueAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.StructuredActions", this);
        prop = this.factory.createProperty(assoc, "removeVariableValueAction", "Actions-StructuredActions-A_removeAt_removeVariableValueAction-removeVariableValueAction", "Actions-StructuredActions-RemoveVariableValueAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-StructuredActions-RemoveVariableValueAction-removeAt Actions-StructuredActions-A_removeAt_removeVariableValueAction-removeVariableValueAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";
        Package cfr_ignored_80 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_readVariableAction", "Actions-StructuredActions-A_result_readVariableAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.StructuredActions", this);
        prop = this.factory.createProperty(assoc, "readVariableAction", "Actions-StructuredActions-A_result_readVariableAction-readVariableAction", "Actions-StructuredActions-ReadVariableAction", "Actions-BasicActions-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-StructuredActions-ReadVariableAction-result Actions-StructuredActions-A_result_readVariableAction-readVariableAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";
        Package cfr_ignored_81 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_value_writeVariableAction", "Actions-StructuredActions-A_value_writeVariableAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.StructuredActions", this);
        prop = this.factory.createProperty(assoc, "writeVariableAction", "Actions-StructuredActions-A_value_writeVariableAction-writeVariableAction", "Actions-StructuredActions-WriteVariableAction", "Actions-BasicActions-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-StructuredActions-WriteVariableAction-value Actions-StructuredActions-A_value_writeVariableAction-writeVariableAction");
        packageId = this.artifact.getUrn() + "#" + "Actions-StructuredActions";
        Package cfr_ignored_82 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_variable_variableAction", "Actions-StructuredActions-A_variable_variableAction");
        this.mapping.mapAssociation(assoc, "UML.Actions.StructuredActions", this);
        prop = this.factory.createProperty(assoc, "variableAction", "Actions-StructuredActions-A_variable_variableAction-variableAction", "Actions-StructuredActions-VariableAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Actions-StructuredActions-VariableAction-variable Actions-StructuredActions-A_variable_variableAction-variableAction");
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        Package cfr_ignored_83 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_containedEdge_inGroup", "Activities-BasicActivities-A_containedEdge_inGroup");
        this.mapping.mapAssociation(assoc, "UML.Activities.BasicActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityGroup-containedEdge Activities-BasicActivities-ActivityEdge-inGroup");
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        Package cfr_ignored_84 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_edge_activity", "Activities-BasicActivities-A_edge_activity");
        this.mapping.mapAssociation(assoc, "UML.Activities.BasicActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-BasicActivities-Activity-edge Activities-BasicActivities-ActivityEdge-activity");
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        Package cfr_ignored_85 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_incoming_target_node", "Activities-BasicActivities-A_incoming_target_node");
        this.mapping.mapAssociation(assoc, "UML.Activities.BasicActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityNode-incoming Activities-BasicActivities-ActivityEdge-target");
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        Package cfr_ignored_86 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_outgoing_source_node", "Activities-BasicActivities-A_outgoing_source_node");
        this.mapping.mapAssociation(assoc, "UML.Activities.BasicActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityNode-outgoing Activities-BasicActivities-ActivityEdge-source");
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        Package cfr_ignored_87 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_parameter_activityParameterNode", "Activities-BasicActivities-A_parameter_activityParameterNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.BasicActivities", this);
        prop = this.factory.createProperty(assoc, "activityParameterNode", "Activities-BasicActivities-A_parameter_activityParameterNode-activityParameterNode", "Activities-BasicActivities-ActivityParameterNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityParameterNode-parameter Activities-BasicActivities-A_parameter_activityParameterNode-activityParameterNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        Package cfr_ignored_88 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedEdge_activityEdge", "Activities-BasicActivities-A_redefinedEdge_activityEdge");
        this.mapping.mapAssociation(assoc, "UML.Activities.BasicActivities", this);
        prop = this.factory.createProperty(assoc, "activityEdge", "Activities-BasicActivities-A_redefinedEdge_activityEdge-activityEdge", "Activities-BasicActivities-ActivityEdge", "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityEdge-redefinedEdge Activities-BasicActivities-A_redefinedEdge_activityEdge-activityEdge");
        packageId = this.artifact.getUrn() + "#" + "Activities-BasicActivities";
        Package cfr_ignored_89 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedNode_activityNode", "Activities-BasicActivities-A_redefinedNode_activityNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.BasicActivities", this);
        prop = this.factory.createProperty(assoc, "activityNode", "Activities-BasicActivities-A_redefinedNode_activityNode-activityNode", "Activities-BasicActivities-ActivityNode", "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-BasicActivities-ActivityNode-redefinedNode Activities-BasicActivities-A_redefinedNode_activityNode-activityNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        Package cfr_ignored_90 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_condition_parameterSet", "Activities-CompleteActivities-A_condition_parameterSet");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        prop = this.factory.createProperty(assoc, "parameterSet", "Activities-CompleteActivities-A_condition_parameterSet-parameterSet", "Activities-CompleteActivities-ParameterSet", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ParameterSet-condition Activities-CompleteActivities-A_condition_parameterSet-parameterSet");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        Package cfr_ignored_91 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_containedNode_inGroup", "Activities-CompleteActivities-A_containedNode_inGroup");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ActivityGroup-containedNode Activities-CompleteActivities-ActivityNode-inGroup");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        Package cfr_ignored_92 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inInterruptibleRegion_node", "Activities-CompleteActivities-A_inInterruptibleRegion_node");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ActivityNode-inInterruptibleRegion Activities-CompleteActivities-InterruptibleActivityRegion-node");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        Package cfr_ignored_93 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inState_objectNode", "Activities-CompleteActivities-A_inState_objectNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        prop = this.factory.createProperty(assoc, "objectNode", "Activities-CompleteActivities-A_inState_objectNode-objectNode", "Activities-CompleteActivities-ObjectNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ObjectNode-inState Activities-CompleteActivities-A_inState_objectNode-objectNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        Package cfr_ignored_94 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_interruptingEdge_interrupts", "Activities-CompleteActivities-A_interruptingEdge_interrupts");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteActivities-InterruptibleActivityRegion-interruptingEdge Activities-CompleteActivities-ActivityEdge-interrupts");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        Package cfr_ignored_95 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_joinSpec_joinNode", "Activities-CompleteActivities-A_joinSpec_joinNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        prop = this.factory.createProperty(assoc, "joinNode", "Activities-CompleteActivities-A_joinSpec_joinNode-joinNode", "Activities-CompleteActivities-JoinNode", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteActivities-JoinNode-joinSpec Activities-CompleteActivities-A_joinSpec_joinNode-joinNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        Package cfr_ignored_96 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_localPostcondition_action", "Activities-CompleteActivities-A_localPostcondition_action");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        prop = this.factory.createProperty(assoc, "action", "Activities-CompleteActivities-A_localPostcondition_action-action", "Activities-CompleteActivities-Action", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteActivities-Action-localPostcondition Activities-CompleteActivities-A_localPostcondition_action-action");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        Package cfr_ignored_97 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_localPrecondition_action", "Activities-CompleteActivities-A_localPrecondition_action");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        prop = this.factory.createProperty(assoc, "action", "Activities-CompleteActivities-A_localPrecondition_action-action", "Activities-CompleteActivities-Action", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteActivities-Action-localPrecondition Activities-CompleteActivities-A_localPrecondition_action-action");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        Package cfr_ignored_98 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameterSet_behavior", "Activities-CompleteActivities-A_ownedParameterSet_behavior");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        prop = this.factory.createProperty(assoc, "behavior", "Activities-CompleteActivities-A_ownedParameterSet_behavior-behavior", "Activities-CompleteActivities-Behavior", "Classes-Kernel-NamedElement-namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteActivities-Behavior-ownedParameterSet Activities-CompleteActivities-A_ownedParameterSet_behavior-behavior");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        Package cfr_ignored_99 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameterSet_behavioralFeature", "Activities-CompleteActivities-A_ownedParameterSet_behavioralFeature");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        prop = this.factory.createProperty(assoc, "behavioralFeature", "Activities-CompleteActivities-A_ownedParameterSet_behavioralFeature-behavioralFeature", "Activities-CompleteActivities-BehavioralFeature", "Classes-Kernel-NamedElement-namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteActivities-BehavioralFeature-ownedParameterSet Activities-CompleteActivities-A_ownedParameterSet_behavioralFeature-behavioralFeature");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        Package cfr_ignored_100 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_parameterSet_parameter", "Activities-CompleteActivities-A_parameterSet_parameter");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteActivities-Parameter-parameterSet Activities-CompleteActivities-ParameterSet-parameter");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        Package cfr_ignored_101 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_selection_objectFlow", "Activities-CompleteActivities-A_selection_objectFlow");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        prop = this.factory.createProperty(assoc, "objectFlow", "Activities-CompleteActivities-A_selection_objectFlow-objectFlow", "Activities-CompleteActivities-ObjectFlow", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ObjectFlow-selection Activities-CompleteActivities-A_selection_objectFlow-objectFlow");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        Package cfr_ignored_102 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_selection_objectNode", "Activities-CompleteActivities-A_selection_objectNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        prop = this.factory.createProperty(assoc, "objectNode", "Activities-CompleteActivities-A_selection_objectNode-objectNode", "Activities-CompleteActivities-ObjectNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ObjectNode-selection Activities-CompleteActivities-A_selection_objectNode-objectNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        Package cfr_ignored_103 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_transformation_objectFlow", "Activities-CompleteActivities-A_transformation_objectFlow");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        prop = this.factory.createProperty(assoc, "objectFlow", "Activities-CompleteActivities-A_transformation_objectFlow-objectFlow", "Activities-CompleteActivities-ObjectFlow", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ObjectFlow-transformation Activities-CompleteActivities-A_transformation_objectFlow-objectFlow");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        Package cfr_ignored_104 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_upperBound_objectNode", "Activities-CompleteActivities-A_upperBound_objectNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        prop = this.factory.createProperty(assoc, "objectNode", "Activities-CompleteActivities-A_upperBound_objectNode-objectNode", "Activities-CompleteActivities-ObjectNode", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ObjectNode-upperBound Activities-CompleteActivities-A_upperBound_objectNode-objectNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteActivities";
        Package cfr_ignored_105 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_weight_activityEdge", "Activities-CompleteActivities-A_weight_activityEdge");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteActivities", this);
        prop = this.factory.createProperty(assoc, "activityEdge", "Activities-CompleteActivities-A_weight_activityEdge-activityEdge", "Activities-CompleteActivities-ActivityEdge", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteActivities-ActivityEdge-weight Activities-CompleteActivities-A_weight_activityEdge-activityEdge");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        Package cfr_ignored_106 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_bodyOutput_clause", "Activities-CompleteStructuredActivities-A_bodyOutput_clause");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        prop = this.factory.createProperty(assoc, "clause", "Activities-CompleteStructuredActivities-A_bodyOutput_clause-clause", "Activities-CompleteStructuredActivities-Clause", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-Clause-bodyOutput Activities-CompleteStructuredActivities-A_bodyOutput_clause-clause");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        Package cfr_ignored_107 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_bodyOutput_loopNode", "Activities-CompleteStructuredActivities-A_bodyOutput_loopNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        prop = this.factory.createProperty(assoc, "loopNode", "Activities-CompleteStructuredActivities-A_bodyOutput_loopNode-loopNode", "Activities-CompleteStructuredActivities-LoopNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-LoopNode-bodyOutput Activities-CompleteStructuredActivities-A_bodyOutput_loopNode-loopNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        Package cfr_ignored_108 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_containedEdge_inGroup", "Activities-CompleteStructuredActivities-A_containedEdge_inGroup");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-ActivityGroup-containedEdge Activities-CompleteStructuredActivities-ActivityEdge-inGroup");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        Package cfr_ignored_109 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_edge_inStructuredNode", "Activities-CompleteStructuredActivities-A_edge_inStructuredNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-StructuredActivityNode-edge Activities-CompleteStructuredActivities-ActivityEdge-inStructuredNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        Package cfr_ignored_110 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_input_action", "Activities-CompleteStructuredActivities-A_input_action");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        prop = this.factory.createProperty(assoc, "action", "Activities-CompleteStructuredActivities-A_input_action-action", "Activities-CompleteStructuredActivities-Action", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-Action-input Activities-CompleteStructuredActivities-A_input_action-action");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        Package cfr_ignored_111 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_loopVariableInput_loopNode", "Activities-CompleteStructuredActivities-A_loopVariableInput_loopNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        prop = this.factory.createProperty(assoc, "loopNode", "Activities-CompleteStructuredActivities-A_loopVariableInput_loopNode-loopNode", "Activities-CompleteStructuredActivities-LoopNode", "Activities-CompleteStructuredActivities-A_structuredNodeInput_structuredActivityNode-structuredActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-LoopNode-loopVariableInput Activities-CompleteStructuredActivities-A_loopVariableInput_loopNode-loopNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        Package cfr_ignored_112 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_loopVariable_loopNode", "Activities-CompleteStructuredActivities-A_loopVariable_loopNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        prop = this.factory.createProperty(assoc, "loopNode", "Activities-CompleteStructuredActivities-A_loopVariable_loopNode-loopNode", "Activities-CompleteStructuredActivities-LoopNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-LoopNode-loopVariable Activities-CompleteStructuredActivities-A_loopVariable_loopNode-loopNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        Package cfr_ignored_113 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_output_action", "Activities-CompleteStructuredActivities-A_output_action");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        prop = this.factory.createProperty(assoc, "action", "Activities-CompleteStructuredActivities-A_output_action-action", "Activities-CompleteStructuredActivities-Action", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-Action-output Activities-CompleteStructuredActivities-A_output_action-action");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        Package cfr_ignored_114 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_conditionalNode", "Activities-CompleteStructuredActivities-A_result_conditionalNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        prop = this.factory.createProperty(assoc, "conditionalNode", "Activities-CompleteStructuredActivities-A_result_conditionalNode-conditionalNode", "Activities-CompleteStructuredActivities-ConditionalNode", "Activities-CompleteStructuredActivities-A_structuredNodeOutput_structuredActivityNode-structuredActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-ConditionalNode-result Activities-CompleteStructuredActivities-A_result_conditionalNode-conditionalNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        Package cfr_ignored_115 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_loopNode", "Activities-CompleteStructuredActivities-A_result_loopNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        prop = this.factory.createProperty(assoc, "loopNode", "Activities-CompleteStructuredActivities-A_result_loopNode-loopNode", "Activities-CompleteStructuredActivities-LoopNode", "Activities-CompleteStructuredActivities-A_structuredNodeOutput_structuredActivityNode-structuredActivityNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-LoopNode-result Activities-CompleteStructuredActivities-A_result_loopNode-loopNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        Package cfr_ignored_116 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_structuredNodeInput_structuredActivityNode", "Activities-CompleteStructuredActivities-A_structuredNodeInput_structuredActivityNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        prop = this.factory.createProperty(assoc, "structuredActivityNode", "Activities-CompleteStructuredActivities-A_structuredNodeInput_structuredActivityNode-structuredActivityNode", "Activities-CompleteStructuredActivities-StructuredActivityNode", "Activities-CompleteStructuredActivities-A_input_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-StructuredActivityNode-structuredNodeInput Activities-CompleteStructuredActivities-A_structuredNodeInput_structuredActivityNode-structuredActivityNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-CompleteStructuredActivities";
        Package cfr_ignored_117 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_structuredNodeOutput_structuredActivityNode", "Activities-CompleteStructuredActivities-A_structuredNodeOutput_structuredActivityNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.CompleteStructuredActivities", this);
        prop = this.factory.createProperty(assoc, "structuredActivityNode", "Activities-CompleteStructuredActivities-A_structuredNodeOutput_structuredActivityNode-structuredActivityNode", "Activities-CompleteStructuredActivities-StructuredActivityNode", "Activities-CompleteStructuredActivities-A_output_action-action", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-CompleteStructuredActivities-StructuredActivityNode-structuredNodeOutput Activities-CompleteStructuredActivities-A_structuredNodeOutput_structuredActivityNode-structuredActivityNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";
        Package cfr_ignored_118 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_exceptionInput_exceptionHandler", "Activities-ExtraStructuredActivities-A_exceptionInput_exceptionHandler");
        this.mapping.mapAssociation(assoc, "UML.Activities.ExtraStructuredActivities", this);
        prop = this.factory.createProperty(assoc, "exceptionHandler", "Activities-ExtraStructuredActivities-A_exceptionInput_exceptionHandler-exceptionHandler", "Activities-ExtraStructuredActivities-ExceptionHandler", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExceptionHandler-exceptionInput Activities-ExtraStructuredActivities-A_exceptionInput_exceptionHandler-exceptionHandler");
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";
        Package cfr_ignored_119 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_exceptionType_exceptionHandler", "Activities-ExtraStructuredActivities-A_exceptionType_exceptionHandler");
        this.mapping.mapAssociation(assoc, "UML.Activities.ExtraStructuredActivities", this);
        prop = this.factory.createProperty(assoc, "exceptionHandler", "Activities-ExtraStructuredActivities-A_exceptionType_exceptionHandler-exceptionHandler", "Activities-ExtraStructuredActivities-ExceptionHandler", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExceptionHandler-exceptionType Activities-ExtraStructuredActivities-A_exceptionType_exceptionHandler-exceptionHandler");
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";
        Package cfr_ignored_120 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_handlerBody_exceptionHandler", "Activities-ExtraStructuredActivities-A_handlerBody_exceptionHandler");
        this.mapping.mapAssociation(assoc, "UML.Activities.ExtraStructuredActivities", this);
        prop = this.factory.createProperty(assoc, "exceptionHandler", "Activities-ExtraStructuredActivities-A_handlerBody_exceptionHandler-exceptionHandler", "Activities-ExtraStructuredActivities-ExceptionHandler", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExceptionHandler-handlerBody Activities-ExtraStructuredActivities-A_handlerBody_exceptionHandler-exceptionHandler");
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";
        Package cfr_ignored_121 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_handler_protectedNode", "Activities-ExtraStructuredActivities-A_handler_protectedNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.ExtraStructuredActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExecutableNode-handler Activities-ExtraStructuredActivities-ExceptionHandler-protectedNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";
        Package cfr_ignored_122 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inputElement_regionAsInput", "Activities-ExtraStructuredActivities-A_inputElement_regionAsInput");
        this.mapping.mapAssociation(assoc, "UML.Activities.ExtraStructuredActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExpansionRegion-inputElement Activities-ExtraStructuredActivities-ExpansionNode-regionAsInput");
        packageId = this.artifact.getUrn() + "#" + "Activities-ExtraStructuredActivities";
        Package cfr_ignored_123 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_outputElement_regionAsOutput", "Activities-ExtraStructuredActivities-A_outputElement_regionAsOutput");
        this.mapping.mapAssociation(assoc, "UML.Activities.ExtraStructuredActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-ExtraStructuredActivities-ExpansionRegion-outputElement Activities-ExtraStructuredActivities-ExpansionNode-regionAsOutput");
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";
        Package cfr_ignored_124 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_containedNode_inGroup", "Activities-FundamentalActivities-A_containedNode_inGroup");
        this.mapping.mapAssociation(assoc, "UML.Activities.FundamentalActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-FundamentalActivities-ActivityGroup-containedNode Activities-FundamentalActivities-ActivityNode-inGroup");
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";
        Package cfr_ignored_125 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_group_inActivity", "Activities-FundamentalActivities-A_group_inActivity");
        this.mapping.mapAssociation(assoc, "UML.Activities.FundamentalActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-FundamentalActivities-Activity-group Activities-FundamentalActivities-ActivityGroup-inActivity");
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";
        Package cfr_ignored_126 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_node_activity", "Activities-FundamentalActivities-A_node_activity");
        this.mapping.mapAssociation(assoc, "UML.Activities.FundamentalActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-FundamentalActivities-Activity-node Activities-FundamentalActivities-ActivityNode-activity");
        packageId = this.artifact.getUrn() + "#" + "Activities-FundamentalActivities";
        Package cfr_ignored_127 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_subgroup_superGroup", "Activities-FundamentalActivities-A_subgroup_superGroup");
        this.mapping.mapAssociation(assoc, "UML.Activities.FundamentalActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-FundamentalActivities-ActivityGroup-subgroup Activities-FundamentalActivities-ActivityGroup-superGroup");
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        Package cfr_ignored_128 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_containedEdge_inGroup", "Activities-IntermediateActivities-A_containedEdge_inGroup");
        this.mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityGroup-containedEdge Activities-IntermediateActivities-ActivityEdge-inGroup");
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        Package cfr_ignored_129 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_containedNode_inGroup", "Activities-IntermediateActivities-A_containedNode_inGroup");
        this.mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityGroup-containedNode Activities-IntermediateActivities-ActivityNode-inGroup");
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        Package cfr_ignored_130 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_decisionInputFlow_decisionNode", "Activities-IntermediateActivities-A_decisionInputFlow_decisionNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        prop = this.factory.createProperty(assoc, "decisionNode", "Activities-IntermediateActivities-A_decisionInputFlow_decisionNode-decisionNode", "Activities-IntermediateActivities-DecisionNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-DecisionNode-decisionInputFlow Activities-IntermediateActivities-A_decisionInputFlow_decisionNode-decisionNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        Package cfr_ignored_131 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_decisionInput_decisionNode", "Activities-IntermediateActivities-A_decisionInput_decisionNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        prop = this.factory.createProperty(assoc, "decisionNode", "Activities-IntermediateActivities-A_decisionInput_decisionNode-decisionNode", "Activities-IntermediateActivities-DecisionNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-DecisionNode-decisionInput Activities-IntermediateActivities-A_decisionInput_decisionNode-decisionNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        Package cfr_ignored_132 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_edge_inPartition", "Activities-IntermediateActivities-A_edge_inPartition");
        this.mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityPartition-edge Activities-IntermediateActivities-ActivityEdge-inPartition");
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        Package cfr_ignored_133 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_group_inActivity", "Activities-IntermediateActivities-A_group_inActivity");
        this.mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-Activity-group Activities-IntermediateActivities-ActivityGroup-inActivity");
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        Package cfr_ignored_134 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_guard_activityEdge", "Activities-IntermediateActivities-A_guard_activityEdge");
        this.mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        prop = this.factory.createProperty(assoc, "activityEdge", "Activities-IntermediateActivities-A_guard_activityEdge-activityEdge", "Activities-IntermediateActivities-ActivityEdge", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityEdge-guard Activities-IntermediateActivities-A_guard_activityEdge-activityEdge");
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        Package cfr_ignored_135 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inPartition_node", "Activities-IntermediateActivities-A_inPartition_node");
        this.mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityNode-inPartition Activities-IntermediateActivities-ActivityPartition-node");
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        Package cfr_ignored_136 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_partition_activity", "Activities-IntermediateActivities-A_partition_activity");
        this.mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        prop = this.factory.createProperty(assoc, "activity", "Activities-IntermediateActivities-A_partition_activity-activity", "Activities-IntermediateActivities-Activity", "Activities-IntermediateActivities-ActivityGroup-inActivity", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-Activity-partition Activities-IntermediateActivities-A_partition_activity-activity");
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        Package cfr_ignored_137 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_represents_activityPartition", "Activities-IntermediateActivities-A_represents_activityPartition");
        this.mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        prop = this.factory.createProperty(assoc, "activityPartition", "Activities-IntermediateActivities-A_represents_activityPartition-activityPartition", "Activities-IntermediateActivities-ActivityPartition", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityPartition-represents Activities-IntermediateActivities-A_represents_activityPartition-activityPartition");
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        Package cfr_ignored_138 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_subgroup_superGroup", "Activities-IntermediateActivities-A_subgroup_superGroup");
        this.mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityGroup-subgroup Activities-IntermediateActivities-ActivityGroup-superGroup");
        packageId = this.artifact.getUrn() + "#" + "Activities-IntermediateActivities";
        Package cfr_ignored_139 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_subpartition_superPartition", "Activities-IntermediateActivities-A_subpartition_superPartition");
        this.mapping.mapAssociation(assoc, "UML.Activities.IntermediateActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-IntermediateActivities-ActivityPartition-subpartition Activities-IntermediateActivities-ActivityPartition-superPartition");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_140 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_bodyPart_loopNode", "Activities-StructuredActivities-A_bodyPart_loopNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        prop = this.factory.createProperty(assoc, "loopNode", "Activities-StructuredActivities-A_bodyPart_loopNode-loopNode", "Activities-StructuredActivities-LoopNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-LoopNode-bodyPart Activities-StructuredActivities-A_bodyPart_loopNode-loopNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_141 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_body_clause", "Activities-StructuredActivities-A_body_clause");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        prop = this.factory.createProperty(assoc, "clause", "Activities-StructuredActivities-A_body_clause-clause", "Activities-StructuredActivities-Clause", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Clause-body Activities-StructuredActivities-A_body_clause-clause");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_142 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_clause_conditionalNode", "Activities-StructuredActivities-A_clause_conditionalNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        prop = this.factory.createProperty(assoc, "conditionalNode", "Activities-StructuredActivities-A_clause_conditionalNode-conditionalNode", "Activities-StructuredActivities-ConditionalNode", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-ConditionalNode-clause Activities-StructuredActivities-A_clause_conditionalNode-conditionalNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_143 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_containedNode_inGroup", "Activities-StructuredActivities-A_containedNode_inGroup");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-ActivityGroup-containedNode Activities-StructuredActivities-ActivityNode-inGroup");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_144 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_decider_clause", "Activities-StructuredActivities-A_decider_clause");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        prop = this.factory.createProperty(assoc, "clause", "Activities-StructuredActivities-A_decider_clause-clause", "Activities-StructuredActivities-Clause", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Clause-decider Activities-StructuredActivities-A_decider_clause-clause");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_145 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_decider_loopNode", "Activities-StructuredActivities-A_decider_loopNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        prop = this.factory.createProperty(assoc, "loopNode", "Activities-StructuredActivities-A_decider_loopNode-loopNode", "Activities-StructuredActivities-LoopNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-LoopNode-decider Activities-StructuredActivities-A_decider_loopNode-loopNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_146 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_executableNode_sequenceNode", "Activities-StructuredActivities-A_executableNode_sequenceNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        prop = this.factory.createProperty(assoc, "sequenceNode", "Activities-StructuredActivities-A_executableNode_sequenceNode-sequenceNode", "Activities-StructuredActivities-SequenceNode", "Activities-StructuredActivities-ActivityNode-inStructuredNode", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-SequenceNode-executableNode Activities-StructuredActivities-A_executableNode_sequenceNode-sequenceNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_147 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_group_inActivity", "Activities-StructuredActivities-A_group_inActivity");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Activity-group Activities-StructuredActivities-ActivityGroup-inActivity");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_148 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_node_activity", "Activities-StructuredActivities-A_node_activity");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Activity-node Activities-StructuredActivities-ActivityNode-activity");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_149 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_node_inStructuredNode", "Activities-StructuredActivities-A_node_inStructuredNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-StructuredActivityNode-node Activities-StructuredActivities-ActivityNode-inStructuredNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_150 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_predecessorClause_successorClause", "Activities-StructuredActivities-A_predecessorClause_successorClause");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Clause-predecessorClause Activities-StructuredActivities-Clause-successorClause");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_151 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_setupPart_loopNode", "Activities-StructuredActivities-A_setupPart_loopNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        prop = this.factory.createProperty(assoc, "loopNode", "Activities-StructuredActivities-A_setupPart_loopNode-loopNode", "Activities-StructuredActivities-LoopNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-LoopNode-setupPart Activities-StructuredActivities-A_setupPart_loopNode-loopNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_152 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_structuredNode_activity", "Activities-StructuredActivities-A_structuredNode_activity");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Activity-structuredNode Activities-StructuredActivities-StructuredActivityNode-activity");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_153 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_test_clause", "Activities-StructuredActivities-A_test_clause");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        prop = this.factory.createProperty(assoc, "clause", "Activities-StructuredActivities-A_test_clause-clause", "Activities-StructuredActivities-Clause", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Clause-test Activities-StructuredActivities-A_test_clause-clause");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_154 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_test_loopNode", "Activities-StructuredActivities-A_test_loopNode");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        prop = this.factory.createProperty(assoc, "loopNode", "Activities-StructuredActivities-A_test_loopNode-loopNode", "Activities-StructuredActivities-LoopNode", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-LoopNode-test Activities-StructuredActivities-A_test_loopNode-loopNode");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_155 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_variable_activityScope", "Activities-StructuredActivities-A_variable_activityScope");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-Activity-variable Activities-StructuredActivities-Variable-activityScope");
        packageId = this.artifact.getUrn() + "#" + "Activities-StructuredActivities";
        Package cfr_ignored_156 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_variable_scope", "Activities-StructuredActivities-A_variable_scope");
        this.mapping.mapAssociation(assoc, "UML.Activities.StructuredActivities", this);
        this.factory.createAssociationEnds(assoc, "Activities-StructuredActivities-StructuredActivityNode-variable Activities-StructuredActivities-Variable-scope");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";
        Package cfr_ignored_157 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_conveyed_informationFlow", "AuxiliaryConstructs-InformationFlows-A_conveyed_informationFlow");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.InformationFlows", this);
        prop = this.factory.createProperty(assoc, "informationFlow", "AuxiliaryConstructs-InformationFlows-A_conveyed_informationFlow-informationFlow", "AuxiliaryConstructs-InformationFlows-InformationFlow", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-conveyed AuxiliaryConstructs-InformationFlows-A_conveyed_informationFlow-informationFlow");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";
        Package cfr_ignored_158 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_informationSource_informationFlow", "AuxiliaryConstructs-InformationFlows-A_informationSource_informationFlow");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.InformationFlows", this);
        prop = this.factory.createProperty(assoc, "informationFlow", "AuxiliaryConstructs-InformationFlows-A_informationSource_informationFlow-informationFlow", "AuxiliaryConstructs-InformationFlows-InformationFlow", "Classes-Kernel-A_source_directedRelationship-directedRelationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-informationSource AuxiliaryConstructs-InformationFlows-A_informationSource_informationFlow-informationFlow");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";
        Package cfr_ignored_159 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_informationTarget_informationFlow", "AuxiliaryConstructs-InformationFlows-A_informationTarget_informationFlow");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.InformationFlows", this);
        prop = this.factory.createProperty(assoc, "informationFlow", "AuxiliaryConstructs-InformationFlows-A_informationTarget_informationFlow-informationFlow", "AuxiliaryConstructs-InformationFlows-InformationFlow", "Classes-Kernel-A_target_directedRelationship-directedRelationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-informationTarget AuxiliaryConstructs-InformationFlows-A_informationTarget_informationFlow-informationFlow");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";
        Package cfr_ignored_160 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_realization_abstraction_flow", "AuxiliaryConstructs-InformationFlows-A_realization_abstraction_flow");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.InformationFlows", this);
        prop = this.factory.createProperty(assoc, "abstraction", "AuxiliaryConstructs-InformationFlows-A_realization_abstraction_flow-abstraction", "AuxiliaryConstructs-InformationFlows-InformationFlow", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-realization AuxiliaryConstructs-InformationFlows-A_realization_abstraction_flow-abstraction");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";
        Package cfr_ignored_161 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_realizingActivityEdge_informationFlow", "AuxiliaryConstructs-InformationFlows-A_realizingActivityEdge_informationFlow");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.InformationFlows", this);
        prop = this.factory.createProperty(assoc, "informationFlow", "AuxiliaryConstructs-InformationFlows-A_realizingActivityEdge_informationFlow-informationFlow", "AuxiliaryConstructs-InformationFlows-InformationFlow", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingActivityEdge AuxiliaryConstructs-InformationFlows-A_realizingActivityEdge_informationFlow-informationFlow");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";
        Package cfr_ignored_162 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_realizingConnector_informationFlow", "AuxiliaryConstructs-InformationFlows-A_realizingConnector_informationFlow");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.InformationFlows", this);
        prop = this.factory.createProperty(assoc, "informationFlow", "AuxiliaryConstructs-InformationFlows-A_realizingConnector_informationFlow-informationFlow", "AuxiliaryConstructs-InformationFlows-InformationFlow", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingConnector AuxiliaryConstructs-InformationFlows-A_realizingConnector_informationFlow-informationFlow");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";
        Package cfr_ignored_163 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_realizingMessage_informationFlow", "AuxiliaryConstructs-InformationFlows-A_realizingMessage_informationFlow");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.InformationFlows", this);
        prop = this.factory.createProperty(assoc, "informationFlow", "AuxiliaryConstructs-InformationFlows-A_realizingMessage_informationFlow-informationFlow", "AuxiliaryConstructs-InformationFlows-InformationFlow", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationFlow-realizingMessage AuxiliaryConstructs-InformationFlows-A_realizingMessage_informationFlow-informationFlow");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-InformationFlows";
        Package cfr_ignored_164 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_represented_representation", "AuxiliaryConstructs-InformationFlows-A_represented_representation");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.InformationFlows", this);
        prop = this.factory.createProperty(assoc, "representation", "AuxiliaryConstructs-InformationFlows-A_represented_representation-representation", "AuxiliaryConstructs-InformationFlows-InformationItem", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-InformationFlows-InformationItem-represented AuxiliaryConstructs-InformationFlows-A_represented_representation-representation");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_165 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_actual_templateParameterSubstitution", "AuxiliaryConstructs-Templates-A_actual_templateParameterSubstitution");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        prop = this.factory.createProperty(assoc, "templateParameterSubstitution", "AuxiliaryConstructs-Templates-A_actual_templateParameterSubstitution-templateParameterSubstitution", "AuxiliaryConstructs-Templates-TemplateParameterSubstitution", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-actual AuxiliaryConstructs-Templates-A_actual_templateParameterSubstitution-templateParameterSubstitution");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_166 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_classifier_templateParameter_parameteredElement", "AuxiliaryConstructs-Templates-A_classifier_templateParameter_parameteredElement");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-Classifier-templateParameter AuxiliaryConstructs-Templates-ClassifierTemplateParameter-parameteredElement");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_167 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_connectableElement_templateParameter_parameteredElement", "AuxiliaryConstructs-Templates-A_connectableElement_templateParameter_parameteredElement");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-ConnectableElement-templateParameter AuxiliaryConstructs-Templates-ConnectableElementTemplateParameter-parameteredElement");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_168 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_constrainingClassifier_classifierTemplateParameter", "AuxiliaryConstructs-Templates-A_constrainingClassifier_classifierTemplateParameter");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        prop = this.factory.createProperty(assoc, "classifierTemplateParameter", "AuxiliaryConstructs-Templates-A_constrainingClassifier_classifierTemplateParameter-classifierTemplateParameter", "AuxiliaryConstructs-Templates-ClassifierTemplateParameter", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-ClassifierTemplateParameter-constrainingClassifier AuxiliaryConstructs-Templates-A_constrainingClassifier_classifierTemplateParameter-classifierTemplateParameter");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_169 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_default_templateParameter", "AuxiliaryConstructs-Templates-A_default_templateParameter");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        prop = this.factory.createProperty(assoc, "templateParameter", "AuxiliaryConstructs-Templates-A_default_templateParameter-templateParameter", "AuxiliaryConstructs-Templates-TemplateParameter", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameter-default AuxiliaryConstructs-Templates-A_default_templateParameter-templateParameter");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_170 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_extendedSignature_redefinableTemplateSignature", "AuxiliaryConstructs-Templates-A_extendedSignature_redefinableTemplateSignature");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        prop = this.factory.createProperty(assoc, "redefinableTemplateSignature", "AuxiliaryConstructs-Templates-A_extendedSignature_redefinableTemplateSignature-redefinableTemplateSignature", "AuxiliaryConstructs-Templates-RedefinableTemplateSignature", "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-RedefinableTemplateSignature-extendedSignature AuxiliaryConstructs-Templates-A_extendedSignature_redefinableTemplateSignature-redefinableTemplateSignature");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_171 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_formal_templateParameterSubstitution", "AuxiliaryConstructs-Templates-A_formal_templateParameterSubstitution");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        prop = this.factory.createProperty(assoc, "templateParameterSubstitution", "AuxiliaryConstructs-Templates-A_formal_templateParameterSubstitution-templateParameterSubstitution", "AuxiliaryConstructs-Templates-TemplateParameterSubstitution", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-formal AuxiliaryConstructs-Templates-A_formal_templateParameterSubstitution-templateParameterSubstitution");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_172 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inheritedParameter_redefinableTemplateSignature", "AuxiliaryConstructs-Templates-A_inheritedParameter_redefinableTemplateSignature");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        prop = this.factory.createProperty(assoc, "redefinableTemplateSignature", "AuxiliaryConstructs-Templates-A_inheritedParameter_redefinableTemplateSignature-redefinableTemplateSignature", "AuxiliaryConstructs-Templates-RedefinableTemplateSignature", "AuxiliaryConstructs-Templates-A_parameter_templateSignature-templateSignature", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-RedefinableTemplateSignature-inheritedParameter AuxiliaryConstructs-Templates-A_inheritedParameter_redefinableTemplateSignature-redefinableTemplateSignature");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_173 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_nameExpression_namedElement", "AuxiliaryConstructs-Templates-A_nameExpression_namedElement");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        prop = this.factory.createProperty(assoc, "namedElement", "AuxiliaryConstructs-Templates-A_nameExpression_namedElement-namedElement", "AuxiliaryConstructs-Templates-NamedElement", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-NamedElement-nameExpression AuxiliaryConstructs-Templates-A_nameExpression_namedElement-namedElement");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_174 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_operation_templateParameter_parameteredElement", "AuxiliaryConstructs-Templates-A_operation_templateParameter_parameteredElement");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-Operation-templateParameter AuxiliaryConstructs-Templates-OperationTemplateParameter-parameteredElement");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_175 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedActual_templateParameterSubstitution", "AuxiliaryConstructs-Templates-A_ownedActual_templateParameterSubstitution");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        prop = this.factory.createProperty(assoc, "templateParameterSubstitution", "AuxiliaryConstructs-Templates-A_ownedActual_templateParameterSubstitution-templateParameterSubstitution", "AuxiliaryConstructs-Templates-TemplateParameterSubstitution", "Classes-Kernel-Element-owner", "AuxiliaryConstructs-Templates-A_actual_templateParameterSubstitution-templateParameterSubstitution", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameterSubstitution-ownedActual AuxiliaryConstructs-Templates-A_ownedActual_templateParameterSubstitution-templateParameterSubstitution");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_176 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedDefault_templateParameter", "AuxiliaryConstructs-Templates-A_ownedDefault_templateParameter");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        prop = this.factory.createProperty(assoc, "templateParameter", "AuxiliaryConstructs-Templates-A_ownedDefault_templateParameter-templateParameter", "AuxiliaryConstructs-Templates-TemplateParameter", "Classes-Kernel-Element-owner", "AuxiliaryConstructs-Templates-A_default_templateParameter-templateParameter", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameter-ownedDefault AuxiliaryConstructs-Templates-A_ownedDefault_templateParameter-templateParameter");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_177 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameter_signature", "AuxiliaryConstructs-Templates-A_ownedParameter_signature");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateSignature-ownedParameter AuxiliaryConstructs-Templates-TemplateParameter-signature");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_178 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameteredElement_owningTemplateParameter", "AuxiliaryConstructs-Templates-A_ownedParameteredElement_owningTemplateParameter");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameter-ownedParameteredElement AuxiliaryConstructs-Templates-ParameterableElement-owningTemplateParameter");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_179 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedTemplateSignature_classifier", "AuxiliaryConstructs-Templates-A_ownedTemplateSignature_classifier");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-Classifier-ownedTemplateSignature AuxiliaryConstructs-Templates-RedefinableTemplateSignature-classifier");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_180 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedTemplateSignature_template", "AuxiliaryConstructs-Templates-A_ownedTemplateSignature_template");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateableElement-ownedTemplateSignature AuxiliaryConstructs-Templates-TemplateSignature-template");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_181 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_parameterSubstitution_templateBinding", "AuxiliaryConstructs-Templates-A_parameterSubstitution_templateBinding");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateBinding-parameterSubstitution AuxiliaryConstructs-Templates-TemplateParameterSubstitution-templateBinding");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_182 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_parameter_templateSignature", "AuxiliaryConstructs-Templates-A_parameter_templateSignature");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        prop = this.factory.createProperty(assoc, "templateSignature", "AuxiliaryConstructs-Templates-A_parameter_templateSignature-templateSignature", "AuxiliaryConstructs-Templates-TemplateSignature", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateSignature-parameter AuxiliaryConstructs-Templates-A_parameter_templateSignature-templateSignature");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_183 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_parameteredElement_templateParameter", "AuxiliaryConstructs-Templates-A_parameteredElement_templateParameter");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateParameter-parameteredElement AuxiliaryConstructs-Templates-ParameterableElement-templateParameter");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_184 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinitionContext_redefinableElement", "AuxiliaryConstructs-Templates-A_redefinitionContext_redefinableElement");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        prop = this.factory.createProperty(assoc, "redefinableElement", "AuxiliaryConstructs-Templates-A_redefinitionContext_redefinableElement-redefinableElement", "AuxiliaryConstructs-Templates-RedefinableElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-RedefinableElement-redefinitionContext AuxiliaryConstructs-Templates-A_redefinitionContext_redefinableElement-redefinableElement");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_185 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_signature_templateBinding", "AuxiliaryConstructs-Templates-A_signature_templateBinding");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        prop = this.factory.createProperty(assoc, "templateBinding", "AuxiliaryConstructs-Templates-A_signature_templateBinding-templateBinding", "AuxiliaryConstructs-Templates-TemplateBinding", "Classes-Kernel-A_target_directedRelationship-directedRelationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateBinding-signature AuxiliaryConstructs-Templates-A_signature_templateBinding-templateBinding");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_186 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_subExpression_owningExpression", "AuxiliaryConstructs-Templates-A_subExpression_owningExpression");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-StringExpression-subExpression AuxiliaryConstructs-Templates-StringExpression-owningExpression");
        packageId = this.artifact.getUrn() + "#" + "AuxiliaryConstructs-Templates";
        Package cfr_ignored_187 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_templateBinding_boundElement", "AuxiliaryConstructs-Templates-A_templateBinding_boundElement");
        this.mapping.mapAssociation(assoc, "UML.AuxiliaryConstructs.Templates", this);
        this.factory.createAssociationEnds(assoc, "AuxiliaryConstructs-Templates-TemplateableElement-templateBinding AuxiliaryConstructs-Templates-TemplateBinding-boundElement");
        packageId = this.artifact.getUrn() + "#" + "Classes-AssociationClasses";
        Package cfr_ignored_188 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_qualifier_associationEnd", "Classes-AssociationClasses-A_qualifier_associationEnd");
        this.mapping.mapAssociation(assoc, "UML.Classes.AssociationClasses", this);
        this.factory.createAssociationEnds(assoc, "Classes-AssociationClasses-Property-qualifier Classes-AssociationClasses-Property-associationEnd");
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";
        Package cfr_ignored_189 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_clientDependency_client", "Classes-Dependencies-A_clientDependency_client");
        this.mapping.mapAssociation(assoc, "UML.Classes.Dependencies", this);
        this.factory.createAssociationEnds(assoc, "Classes-Dependencies-NamedElement-clientDependency Classes-Dependencies-Dependency-client");
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";
        Package cfr_ignored_190 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_contract_substitution", "Classes-Dependencies-A_contract_substitution");
        this.mapping.mapAssociation(assoc, "UML.Classes.Dependencies", this);
        prop = this.factory.createProperty(assoc, "substitution", "Classes-Dependencies-A_contract_substitution-substitution", "Classes-Dependencies-Substitution", "Classes-Dependencies-A_supplier_supplierDependency-supplierDependency", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Dependencies-Substitution-contract Classes-Dependencies-A_contract_substitution-substitution");
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";
        Package cfr_ignored_191 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_mapping_abstraction", "Classes-Dependencies-A_mapping_abstraction");
        this.mapping.mapAssociation(assoc, "UML.Classes.Dependencies", this);
        prop = this.factory.createProperty(assoc, "abstraction", "Classes-Dependencies-A_mapping_abstraction-abstraction", "Classes-Dependencies-Abstraction", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Dependencies-Abstraction-mapping Classes-Dependencies-A_mapping_abstraction-abstraction");
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";
        Package cfr_ignored_192 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedMember_namespace", "Classes-Dependencies-A_ownedMember_namespace");
        this.mapping.mapAssociation(assoc, "UML.Classes.Dependencies", this);
        this.factory.createAssociationEnds(assoc, "Classes-Dependencies-Namespace-ownedMember Classes-Dependencies-NamedElement-namespace");
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";
        Package cfr_ignored_193 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_substitution_substitutingClassifier", "Classes-Dependencies-A_substitution_substitutingClassifier");
        this.mapping.mapAssociation(assoc, "UML.Classes.Dependencies", this);
        this.factory.createAssociationEnds(assoc, "Classes-Dependencies-Classifier-substitution Classes-Dependencies-Substitution-substitutingClassifier");
        packageId = this.artifact.getUrn() + "#" + "Classes-Dependencies";
        Package cfr_ignored_194 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_supplier_supplierDependency", "Classes-Dependencies-A_supplier_supplierDependency");
        this.mapping.mapAssociation(assoc, "UML.Classes.Dependencies", this);
        prop = this.factory.createProperty(assoc, "supplierDependency", "Classes-Dependencies-A_supplier_supplierDependency-supplierDependency", "Classes-Dependencies-Dependency", "Classes-Kernel-A_target_directedRelationship-directedRelationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Dependencies-Dependency-supplier Classes-Dependencies-A_supplier_supplierDependency-supplierDependency");
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";
        Package cfr_ignored_195 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_attribute_classifier", "Classes-Interfaces-A_attribute_classifier");
        this.mapping.mapAssociation(assoc, "UML.Classes.Interfaces", this);
        prop = this.factory.createProperty(assoc, "classifier", "Classes-Interfaces-A_attribute_classifier-classifier", "Classes-Interfaces-Classifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Interfaces-Classifier-attribute Classes-Interfaces-A_attribute_classifier-classifier");
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";
        Package cfr_ignored_196 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_contract_interfaceRealization", "Classes-Interfaces-A_contract_interfaceRealization");
        this.mapping.mapAssociation(assoc, "UML.Classes.Interfaces", this);
        prop = this.factory.createProperty(assoc, "interfaceRealization", "Classes-Interfaces-A_contract_interfaceRealization-interfaceRealization", "Classes-Interfaces-InterfaceRealization", "Classes-Dependencies-A_supplier_supplierDependency-supplierDependency", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Interfaces-InterfaceRealization-contract Classes-Interfaces-A_contract_interfaceRealization-interfaceRealization");
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";
        Package cfr_ignored_197 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_interfaceRealization_implementingClassifier", "Classes-Interfaces-A_interfaceRealization_implementingClassifier");
        this.mapping.mapAssociation(assoc, "UML.Classes.Interfaces", this);
        this.factory.createAssociationEnds(assoc, "Classes-Interfaces-BehavioredClassifier-interfaceRealization Classes-Interfaces-InterfaceRealization-implementingClassifier");
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";
        Package cfr_ignored_198 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_nestedClassifier_interface", "Classes-Interfaces-A_nestedClassifier_interface");
        this.mapping.mapAssociation(assoc, "UML.Classes.Interfaces", this);
        prop = this.factory.createProperty(assoc, "interface", "Classes-Interfaces-A_nestedClassifier_interface-interface", "Classes-Interfaces-Interface", "Classes-Kernel-NamedElement-namespace Classes-Kernel-RedefinableElement-redefinitionContext", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Interfaces-Interface-nestedClassifier Classes-Interfaces-A_nestedClassifier_interface-interface");
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";
        Package cfr_ignored_199 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedAttribute_interface", "Classes-Interfaces-A_ownedAttribute_interface");
        this.mapping.mapAssociation(assoc, "UML.Classes.Interfaces", this);
        this.factory.createAssociationEnds(assoc, "Classes-Interfaces-Interface-ownedAttribute Classes-Interfaces-Property-interface");
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";
        Package cfr_ignored_200 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedOperation_interface", "Classes-Interfaces-A_ownedOperation_interface");
        this.mapping.mapAssociation(assoc, "UML.Classes.Interfaces", this);
        this.factory.createAssociationEnds(assoc, "Classes-Interfaces-Interface-ownedOperation Classes-Interfaces-Operation-interface");
        packageId = this.artifact.getUrn() + "#" + "Classes-Interfaces";
        Package cfr_ignored_201 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedInterface_interface", "Classes-Interfaces-A_redefinedInterface_interface");
        this.mapping.mapAssociation(assoc, "UML.Classes.Interfaces", this);
        prop = this.factory.createProperty(assoc, "interface", "Classes-Interfaces-A_redefinedInterface_interface-interface", "Classes-Interfaces-Interface", "Classes-Kernel-A_redefinedClassifier_classifier-classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Interfaces-Interface-redefinedInterface Classes-Interfaces-A_redefinedInterface_interface-interface");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_202 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_annotatedElement_comment", "Classes-Kernel-A_annotatedElement_comment");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "comment", "Classes-Kernel-A_annotatedElement_comment-comment", "Classes-Kernel-Comment", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Comment-annotatedElement Classes-Kernel-A_annotatedElement_comment-comment");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_203 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_attribute_classifier", "Classes-Kernel-A_attribute_classifier");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "classifier", "Classes-Kernel-A_attribute_classifier-classifier", "Classes-Kernel-Classifier", "Classes-Kernel-Feature-featuringClassifier Classes-Kernel-RedefinableElement-redefinitionContext", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-attribute Classes-Kernel-A_attribute_classifier-classifier");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_204 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_bodyCondition_bodyContext", "Classes-Kernel-A_bodyCondition_bodyContext");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "bodyContext", "Classes-Kernel-A_bodyCondition_bodyContext-bodyContext", "Classes-Kernel-Operation", "Classes-Kernel-Constraint-context", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-bodyCondition Classes-Kernel-A_bodyCondition_bodyContext-bodyContext");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_205 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_classifier_enumerationLiteral", "Classes-Kernel-A_classifier_enumerationLiteral");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "enumerationLiteral", "Classes-Kernel-A_classifier_enumerationLiteral-enumerationLiteral", "Classes-Kernel-EnumerationLiteral", "", "Classes-Kernel-A_classifier_instanceSpecification-instanceSpecification", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-EnumerationLiteral-classifier Classes-Kernel-A_classifier_enumerationLiteral-enumerationLiteral");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_206 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_classifier_instanceSpecification", "Classes-Kernel-A_classifier_instanceSpecification");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "instanceSpecification", "Classes-Kernel-A_classifier_instanceSpecification-instanceSpecification", "Classes-Kernel-InstanceSpecification", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-InstanceSpecification-classifier Classes-Kernel-A_classifier_instanceSpecification-instanceSpecification");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_207 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_constrainedElement_constraint", "Classes-Kernel-A_constrainedElement_constraint");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "constraint", "Classes-Kernel-A_constrainedElement_constraint-constraint", "Classes-Kernel-Constraint", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Constraint-constrainedElement Classes-Kernel-A_constrainedElement_constraint-constraint");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_208 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_defaultValue_owningParameter", "Classes-Kernel-A_defaultValue_owningParameter");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "owningParameter", "Classes-Kernel-A_defaultValue_owningParameter-owningParameter", "Classes-Kernel-Parameter", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Parameter-defaultValue Classes-Kernel-A_defaultValue_owningParameter-owningParameter");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_209 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_defaultValue_owningProperty", "Classes-Kernel-A_defaultValue_owningProperty");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "owningProperty", "Classes-Kernel-A_defaultValue_owningProperty-owningProperty", "Classes-Kernel-Property", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Property-defaultValue Classes-Kernel-A_defaultValue_owningProperty-owningProperty");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_210 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_definingFeature_slot", "Classes-Kernel-A_definingFeature_slot");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "slot", "Classes-Kernel-A_definingFeature_slot-slot", "Classes-Kernel-Slot", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Slot-definingFeature Classes-Kernel-A_definingFeature_slot-slot");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_211 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_elementImport_importingNamespace", "Classes-Kernel-A_elementImport_importingNamespace");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-elementImport Classes-Kernel-ElementImport-importingNamespace");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_212 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_endType_association", "Classes-Kernel-A_endType_association");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "association", "Classes-Kernel-A_endType_association-association", "Classes-Kernel-Association", "Classes-Kernel-A_relatedElement_relationship-relationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Association-endType Classes-Kernel-A_endType_association-association");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_213 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_feature_featuringClassifier", "Classes-Kernel-A_feature_featuringClassifier");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-feature Classes-Kernel-Feature-featuringClassifier");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_214 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_general_classifier", "Classes-Kernel-A_general_classifier");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "classifier", "Classes-Kernel-A_general_classifier-classifier", "Classes-Kernel-Classifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-general Classes-Kernel-A_general_classifier-classifier");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_215 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_general_generalization", "Classes-Kernel-A_general_generalization");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "generalization", "Classes-Kernel-A_general_generalization-generalization", "Classes-Kernel-Generalization", "Classes-Kernel-A_target_directedRelationship-directedRelationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Generalization-general Classes-Kernel-A_general_generalization-generalization");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_216 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_generalization_specific", "Classes-Kernel-A_generalization_specific");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-generalization Classes-Kernel-Generalization-specific");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_217 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_importedElement_elementImport", "Classes-Kernel-A_importedElement_elementImport");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "elementImport", "Classes-Kernel-A_importedElement_elementImport-elementImport", "Classes-Kernel-ElementImport", "Classes-Kernel-A_target_directedRelationship-directedRelationship", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-ElementImport-importedElement Classes-Kernel-A_importedElement_elementImport-elementImport");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_218 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_importedMember_namespace", "Classes-Kernel-A_importedMember_namespace");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "namespace", "Classes-Kernel-A_importedMember_namespace-namespace", "Classes-Kernel-Namespace", "Classes-Kernel-A_member_memberNamespace-memberNamespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-importedMember Classes-Kernel-A_importedMember_namespace-namespace");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_219 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_importedPackage_packageImport", "Classes-Kernel-A_importedPackage_packageImport");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "packageImport", "Classes-Kernel-A_importedPackage_packageImport-packageImport", "Classes-Kernel-PackageImport", "Classes-Kernel-A_target_directedRelationship-directedRelationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-PackageImport-importedPackage Classes-Kernel-A_importedPackage_packageImport-packageImport");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_220 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inheritedMember_classifier", "Classes-Kernel-A_inheritedMember_classifier");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "classifier", "Classes-Kernel-A_inheritedMember_classifier-classifier", "Classes-Kernel-Classifier", "Classes-Kernel-A_member_memberNamespace-memberNamespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-inheritedMember Classes-Kernel-A_inheritedMember_classifier-classifier");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_221 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_instance_instanceValue", "Classes-Kernel-A_instance_instanceValue");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "instanceValue", "Classes-Kernel-A_instance_instanceValue-instanceValue", "Classes-Kernel-InstanceValue", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-InstanceValue-instance Classes-Kernel-A_instance_instanceValue-instanceValue");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_222 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_lowerValue_owningLower", "Classes-Kernel-A_lowerValue_owningLower");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "owningLower", "Classes-Kernel-A_lowerValue_owningLower-owningLower", "Classes-Kernel-MultiplicityElement", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-MultiplicityElement-lowerValue Classes-Kernel-A_lowerValue_owningLower-owningLower");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_223 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_memberEnd_association", "Classes-Kernel-A_memberEnd_association");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Association-memberEnd Classes-Kernel-Property-association");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_224 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_member_memberNamespace", "Classes-Kernel-A_member_memberNamespace");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "memberNamespace", "Classes-Kernel-A_member_memberNamespace-memberNamespace", "Classes-Kernel-Namespace", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-member Classes-Kernel-A_member_memberNamespace-memberNamespace");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_225 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_mergedPackage_packageMerge", "Classes-Kernel-A_mergedPackage_packageMerge");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "packageMerge", "Classes-Kernel-A_mergedPackage_packageMerge-packageMerge", "Classes-Kernel-PackageMerge", "Classes-Kernel-A_target_directedRelationship-directedRelationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-PackageMerge-mergedPackage Classes-Kernel-A_mergedPackage_packageMerge-packageMerge");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_226 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_navigableOwnedEnd_association", "Classes-Kernel-A_navigableOwnedEnd_association");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "association", "Classes-Kernel-A_navigableOwnedEnd_association-association", "Classes-Kernel-Association", "Classes-Kernel-Property-owningAssociation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Association-navigableOwnedEnd Classes-Kernel-A_navigableOwnedEnd_association-association");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_227 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_nestedClassifier_class", "Classes-Kernel-A_nestedClassifier_class");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "class", "Classes-Kernel-A_nestedClassifier_class-class", "Classes-Kernel-Class", "Classes-Kernel-NamedElement-namespace Classes-Kernel-RedefinableElement-redefinitionContext", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Class-nestedClassifier Classes-Kernel-A_nestedClassifier_class-class");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_228 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_nestedPackage_nestingPackage", "Classes-Kernel-A_nestedPackage_nestingPackage");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Package-nestedPackage Classes-Kernel-Package-nestingPackage");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_229 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_operand_expression", "Classes-Kernel-A_operand_expression");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "expression", "Classes-Kernel-A_operand_expression-expression", "Classes-Kernel-Expression", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Expression-operand Classes-Kernel-A_operand_expression-expression");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_230 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_opposite_property", "Classes-Kernel-A_opposite_property");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "property", "Classes-Kernel-A_opposite_property-property", "Classes-Kernel-Property", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Property-opposite Classes-Kernel-A_opposite_property-property");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_231 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedAttribute_class", "Classes-Kernel-A_ownedAttribute_class");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Class-ownedAttribute Classes-Kernel-Property-class");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_232 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedAttribute_datatype", "Classes-Kernel-A_ownedAttribute_datatype");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-DataType-ownedAttribute Classes-Kernel-Property-datatype");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_233 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedComment_owningElement", "Classes-Kernel-A_ownedComment_owningElement");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "owningElement", "Classes-Kernel-A_ownedComment_owningElement-owningElement", "Classes-Kernel-Element", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Element-ownedComment Classes-Kernel-A_ownedComment_owningElement-owningElement");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_234 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedElement_owner", "Classes-Kernel-A_ownedElement_owner");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Element-ownedElement Classes-Kernel-Element-owner");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_235 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedEnd_owningAssociation", "Classes-Kernel-A_ownedEnd_owningAssociation");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Association-ownedEnd Classes-Kernel-Property-owningAssociation");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_236 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedLiteral_enumeration", "Classes-Kernel-A_ownedLiteral_enumeration");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Enumeration-ownedLiteral Classes-Kernel-EnumerationLiteral-enumeration");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_237 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedMember_namespace", "Classes-Kernel-A_ownedMember_namespace");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-ownedMember Classes-Kernel-NamedElement-namespace");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_238 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedOperation_class", "Classes-Kernel-A_ownedOperation_class");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Class-ownedOperation Classes-Kernel-Operation-class");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_239 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedOperation_datatype", "Classes-Kernel-A_ownedOperation_datatype");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-DataType-ownedOperation Classes-Kernel-Operation-datatype");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_240 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameter_operation", "Classes-Kernel-A_ownedParameter_operation");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-ownedParameter Classes-Kernel-Parameter-operation");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_241 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameter_ownerFormalParam", "Classes-Kernel-A_ownedParameter_ownerFormalParam");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "ownerFormalParam", "Classes-Kernel-A_ownedParameter_ownerFormalParam-ownerFormalParam", "Classes-Kernel-BehavioralFeature", "Classes-Kernel-NamedElement-namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-BehavioralFeature-ownedParameter Classes-Kernel-A_ownedParameter_ownerFormalParam-ownerFormalParam");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_242 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedRule_context", "Classes-Kernel-A_ownedRule_context");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-ownedRule Classes-Kernel-Constraint-context");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_243 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedType_package", "Classes-Kernel-A_ownedType_package");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Package-ownedType Classes-Kernel-Type-package");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_244 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_packageImport_importingNamespace", "Classes-Kernel-A_packageImport_importingNamespace");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Namespace-packageImport Classes-Kernel-PackageImport-importingNamespace");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_245 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_packageMerge_receivingPackage", "Classes-Kernel-A_packageMerge_receivingPackage");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Package-packageMerge Classes-Kernel-PackageMerge-receivingPackage");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_246 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_packagedElement_owningPackage", "Classes-Kernel-A_packagedElement_owningPackage");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "owningPackage", "Classes-Kernel-A_packagedElement_owningPackage-owningPackage", "Classes-Kernel-Package", "Classes-Kernel-NamedElement-namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Package-packagedElement Classes-Kernel-A_packagedElement_owningPackage-owningPackage");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_247 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_postcondition_postContext", "Classes-Kernel-A_postcondition_postContext");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "postContext", "Classes-Kernel-A_postcondition_postContext-postContext", "Classes-Kernel-Operation", "Classes-Kernel-Constraint-context", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-postcondition Classes-Kernel-A_postcondition_postContext-postContext");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_248 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_precondition_preContext", "Classes-Kernel-A_precondition_preContext");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "preContext", "Classes-Kernel-A_precondition_preContext-preContext", "Classes-Kernel-Operation", "Classes-Kernel-Constraint-context", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-precondition Classes-Kernel-A_precondition_preContext-preContext");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_249 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_raisedException_behavioralFeature", "Classes-Kernel-A_raisedException_behavioralFeature");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "behavioralFeature", "Classes-Kernel-A_raisedException_behavioralFeature-behavioralFeature", "Classes-Kernel-BehavioralFeature", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-BehavioralFeature-raisedException Classes-Kernel-A_raisedException_behavioralFeature-behavioralFeature");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_250 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_raisedException_operation", "Classes-Kernel-A_raisedException_operation");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "operation", "Classes-Kernel-A_raisedException_operation-operation", "Classes-Kernel-Operation", "Classes-Kernel-A_raisedException_behavioralFeature-behavioralFeature", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-raisedException Classes-Kernel-A_raisedException_operation-operation");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_251 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedClassifier_classifier", "Classes-Kernel-A_redefinedClassifier_classifier");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "classifier", "Classes-Kernel-A_redefinedClassifier_classifier-classifier", "Classes-Kernel-Classifier", "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Classifier-redefinedClassifier Classes-Kernel-A_redefinedClassifier_classifier-classifier");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_252 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedElement_redefinableElement", "Classes-Kernel-A_redefinedElement_redefinableElement");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "redefinableElement", "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement", "Classes-Kernel-RedefinableElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-RedefinableElement-redefinedElement Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_253 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedOperation_operation", "Classes-Kernel-A_redefinedOperation_operation");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "operation", "Classes-Kernel-A_redefinedOperation_operation-operation", "Classes-Kernel-Operation", "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-redefinedOperation Classes-Kernel-A_redefinedOperation_operation-operation");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_254 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedProperty_property", "Classes-Kernel-A_redefinedProperty_property");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "property", "Classes-Kernel-A_redefinedProperty_property-property", "Classes-Kernel-Property", "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Property-redefinedProperty Classes-Kernel-A_redefinedProperty_property-property");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_255 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinitionContext_redefinableElement", "Classes-Kernel-A_redefinitionContext_redefinableElement");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "redefinableElement", "Classes-Kernel-A_redefinitionContext_redefinableElement-redefinableElement", "Classes-Kernel-RedefinableElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-RedefinableElement-redefinitionContext Classes-Kernel-A_redefinitionContext_redefinableElement-redefinableElement");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_256 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_relatedElement_relationship", "Classes-Kernel-A_relatedElement_relationship");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "relationship", "Classes-Kernel-A_relatedElement_relationship-relationship", "Classes-Kernel-Relationship", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Relationship-relatedElement Classes-Kernel-A_relatedElement_relationship-relationship");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_257 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_slot_owningInstance", "Classes-Kernel-A_slot_owningInstance");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-InstanceSpecification-slot Classes-Kernel-Slot-owningInstance");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_258 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_source_directedRelationship", "Classes-Kernel-A_source_directedRelationship");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "directedRelationship", "Classes-Kernel-A_source_directedRelationship-directedRelationship", "Classes-Kernel-DirectedRelationship", "Classes-Kernel-A_relatedElement_relationship-relationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-DirectedRelationship-source Classes-Kernel-A_source_directedRelationship-directedRelationship");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_259 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_specification_owningConstraint", "Classes-Kernel-A_specification_owningConstraint");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "owningConstraint", "Classes-Kernel-A_specification_owningConstraint-owningConstraint", "Classes-Kernel-Constraint", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Constraint-specification Classes-Kernel-A_specification_owningConstraint-owningConstraint");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_260 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_specification_owningInstanceSpec", "Classes-Kernel-A_specification_owningInstanceSpec");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "owningInstanceSpec", "Classes-Kernel-A_specification_owningInstanceSpec-owningInstanceSpec", "Classes-Kernel-InstanceSpecification", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-InstanceSpecification-specification Classes-Kernel-A_specification_owningInstanceSpec-owningInstanceSpec");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_261 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_subsettedProperty_property", "Classes-Kernel-A_subsettedProperty_property");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "property", "Classes-Kernel-A_subsettedProperty_property-property", "Classes-Kernel-Property", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Property-subsettedProperty Classes-Kernel-A_subsettedProperty_property-property");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_262 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_superClass_class", "Classes-Kernel-A_superClass_class");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "class", "Classes-Kernel-A_superClass_class-class", "Classes-Kernel-Class", "Classes-Kernel-A_general_classifier-classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Class-superClass Classes-Kernel-A_superClass_class-class");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_263 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_target_directedRelationship", "Classes-Kernel-A_target_directedRelationship");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "directedRelationship", "Classes-Kernel-A_target_directedRelationship-directedRelationship", "Classes-Kernel-DirectedRelationship", "Classes-Kernel-A_relatedElement_relationship-relationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-DirectedRelationship-target Classes-Kernel-A_target_directedRelationship-directedRelationship");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_264 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_type_operation", "Classes-Kernel-A_type_operation");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "operation", "Classes-Kernel-A_type_operation-operation", "Classes-Kernel-Operation", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Operation-type Classes-Kernel-A_type_operation-operation");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_265 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_type_typedElement", "Classes-Kernel-A_type_typedElement");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "typedElement", "Classes-Kernel-A_type_typedElement-typedElement", "Classes-Kernel-TypedElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-TypedElement-type Classes-Kernel-A_type_typedElement-typedElement");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_266 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_upperValue_owningUpper", "Classes-Kernel-A_upperValue_owningUpper");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "owningUpper", "Classes-Kernel-A_upperValue_owningUpper-owningUpper", "Classes-Kernel-MultiplicityElement", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-MultiplicityElement-upperValue Classes-Kernel-A_upperValue_owningUpper-owningUpper");
        packageId = this.artifact.getUrn() + "#" + "Classes-Kernel";
        Package cfr_ignored_267 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_value_owningSlot", "Classes-Kernel-A_value_owningSlot");
        this.mapping.mapAssociation(assoc, "UML.Classes.Kernel", this);
        prop = this.factory.createProperty(assoc, "owningSlot", "Classes-Kernel-A_value_owningSlot-owningSlot", "Classes-Kernel-Slot", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Classes-Kernel-Slot-value Classes-Kernel-A_value_owningSlot-owningSlot");
        packageId = this.artifact.getUrn() + "#" + "Classes-PowerTypes";
        Package cfr_ignored_268 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_generalizationSet_generalization", "Classes-PowerTypes-A_generalizationSet_generalization");
        this.mapping.mapAssociation(assoc, "UML.Classes.PowerTypes", this);
        this.factory.createAssociationEnds(assoc, "Classes-PowerTypes-Generalization-generalizationSet Classes-PowerTypes-GeneralizationSet-generalization");
        packageId = this.artifact.getUrn() + "#" + "Classes-PowerTypes";
        Package cfr_ignored_269 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_powertypeExtent_powertype", "Classes-PowerTypes-A_powertypeExtent_powertype");
        this.mapping.mapAssociation(assoc, "UML.Classes.PowerTypes", this);
        this.factory.createAssociationEnds(assoc, "Classes-PowerTypes-Classifier-powertypeExtent Classes-PowerTypes-GeneralizationSet-powertype");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";
        Package cfr_ignored_270 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_behavior_opaqueExpression", "CommonBehaviors-BasicBehaviors-A_behavior_opaqueExpression");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        prop = this.factory.createProperty(assoc, "opaqueExpression", "CommonBehaviors-BasicBehaviors-A_behavior_opaqueExpression-opaqueExpression", "CommonBehaviors-BasicBehaviors-OpaqueExpression", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-OpaqueExpression-behavior CommonBehaviors-BasicBehaviors-A_behavior_opaqueExpression-opaqueExpression");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";
        Package cfr_ignored_271 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_classifierBehavior_behavioredClassifier", "CommonBehaviors-BasicBehaviors-A_classifierBehavior_behavioredClassifier");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        prop = this.factory.createProperty(assoc, "behavioredClassifier", "CommonBehaviors-BasicBehaviors-A_classifierBehavior_behavioredClassifier-behavioredClassifier", "CommonBehaviors-BasicBehaviors-BehavioredClassifier", "", "CommonBehaviors-BasicBehaviors-A_ownedBehavior_behavioredClassifier-behavioredClassifier", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-BehavioredClassifier-classifierBehavior CommonBehaviors-BasicBehaviors-A_classifierBehavior_behavioredClassifier-behavioredClassifier");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";
        Package cfr_ignored_272 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_context_behavior", "CommonBehaviors-BasicBehaviors-A_context_behavior");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        prop = this.factory.createProperty(assoc, "behavior", "CommonBehaviors-BasicBehaviors-A_context_behavior-behavior", "CommonBehaviors-BasicBehaviors-Behavior", "Classes-Kernel-A_redefinitionContext_redefinableElement-redefinableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-Behavior-context CommonBehaviors-BasicBehaviors-A_context_behavior-behavior");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";
        Package cfr_ignored_273 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_method_specification", "CommonBehaviors-BasicBehaviors-A_method_specification");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-BehavioralFeature-method CommonBehaviors-BasicBehaviors-Behavior-specification");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";
        Package cfr_ignored_274 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedBehavior_behavioredClassifier", "CommonBehaviors-BasicBehaviors-A_ownedBehavior_behavioredClassifier");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        prop = this.factory.createProperty(assoc, "behavioredClassifier", "CommonBehaviors-BasicBehaviors-A_ownedBehavior_behavioredClassifier-behavioredClassifier", "CommonBehaviors-BasicBehaviors-BehavioredClassifier", "Classes-Kernel-NamedElement-namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-BehavioredClassifier-ownedBehavior CommonBehaviors-BasicBehaviors-A_ownedBehavior_behavioredClassifier-behavioredClassifier");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";
        Package cfr_ignored_275 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameter_behavior", "CommonBehaviors-BasicBehaviors-A_ownedParameter_behavior");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        prop = this.factory.createProperty(assoc, "behavior", "CommonBehaviors-BasicBehaviors-A_ownedParameter_behavior-behavior", "CommonBehaviors-BasicBehaviors-Behavior", "Classes-Kernel-NamedElement-namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-Behavior-ownedParameter CommonBehaviors-BasicBehaviors-A_ownedParameter_behavior-behavior");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";
        Package cfr_ignored_276 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_postcondition_behavior", "CommonBehaviors-BasicBehaviors-A_postcondition_behavior");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        prop = this.factory.createProperty(assoc, "behavior", "CommonBehaviors-BasicBehaviors-A_postcondition_behavior-behavior", "CommonBehaviors-BasicBehaviors-Behavior", "Classes-Kernel-Constraint-context", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-Behavior-postcondition CommonBehaviors-BasicBehaviors-A_postcondition_behavior-behavior");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";
        Package cfr_ignored_277 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_precondition_behavior", "CommonBehaviors-BasicBehaviors-A_precondition_behavior");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        prop = this.factory.createProperty(assoc, "behavior", "CommonBehaviors-BasicBehaviors-A_precondition_behavior-behavior", "CommonBehaviors-BasicBehaviors-Behavior", "Classes-Kernel-Constraint-context", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-Behavior-precondition CommonBehaviors-BasicBehaviors-A_precondition_behavior-behavior");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";
        Package cfr_ignored_278 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedBehavior_behavior", "CommonBehaviors-BasicBehaviors-A_redefinedBehavior_behavior");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        prop = this.factory.createProperty(assoc, "behavior", "CommonBehaviors-BasicBehaviors-A_redefinedBehavior_behavior-behavior", "CommonBehaviors-BasicBehaviors-Behavior", "Classes-Kernel-A_redefinedClassifier_classifier-classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-Behavior-redefinedBehavior CommonBehaviors-BasicBehaviors-A_redefinedBehavior_behavior-behavior");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-BasicBehaviors";
        Package cfr_ignored_279 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_result_opaqueExpression", "CommonBehaviors-BasicBehaviors-A_result_opaqueExpression");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.BasicBehaviors", this);
        prop = this.factory.createProperty(assoc, "opaqueExpression", "CommonBehaviors-BasicBehaviors-A_result_opaqueExpression-opaqueExpression", "CommonBehaviors-BasicBehaviors-OpaqueExpression", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-BasicBehaviors-OpaqueExpression-result CommonBehaviors-BasicBehaviors-A_result_opaqueExpression-opaqueExpression");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        Package cfr_ignored_280 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_changeExpression_changeEvent", "CommonBehaviors-Communications-A_changeExpression_changeEvent");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.Communications", this);
        prop = this.factory.createProperty(assoc, "changeEvent", "CommonBehaviors-Communications-A_changeExpression_changeEvent-changeEvent", "CommonBehaviors-Communications-ChangeEvent", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-ChangeEvent-changeExpression CommonBehaviors-Communications-A_changeExpression_changeEvent-changeEvent");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        Package cfr_ignored_281 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_event_trigger", "CommonBehaviors-Communications-A_event_trigger");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.Communications", this);
        prop = this.factory.createProperty(assoc, "trigger", "CommonBehaviors-Communications-A_event_trigger-trigger", "CommonBehaviors-Communications-Trigger", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-Trigger-event CommonBehaviors-Communications-A_event_trigger-trigger");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        Package cfr_ignored_282 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_operation_callEvent", "CommonBehaviors-Communications-A_operation_callEvent");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.Communications", this);
        prop = this.factory.createProperty(assoc, "callEvent", "CommonBehaviors-Communications-A_operation_callEvent-callEvent", "CommonBehaviors-Communications-CallEvent", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-CallEvent-operation CommonBehaviors-Communications-A_operation_callEvent-callEvent");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        Package cfr_ignored_283 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedAttribute_owningSignal", "CommonBehaviors-Communications-A_ownedAttribute_owningSignal");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.Communications", this);
        prop = this.factory.createProperty(assoc, "owningSignal", "CommonBehaviors-Communications-A_ownedAttribute_owningSignal-owningSignal", "CommonBehaviors-Communications-Signal", "Classes-Kernel-NamedElement-namespace Classes-Kernel-A_attribute_classifier-classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-Signal-ownedAttribute CommonBehaviors-Communications-A_ownedAttribute_owningSignal-owningSignal");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        Package cfr_ignored_284 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedReception_class", "CommonBehaviors-Communications-A_ownedReception_class");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.Communications", this);
        prop = this.factory.createProperty(assoc, "class", "CommonBehaviors-Communications-A_ownedReception_class-class", "CommonBehaviors-Communications-Class", "Classes-Kernel-NamedElement-namespace Classes-Kernel-Feature-featuringClassifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-Class-ownedReception CommonBehaviors-Communications-A_ownedReception_class-class");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        Package cfr_ignored_285 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedReception_interface", "CommonBehaviors-Communications-A_ownedReception_interface");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.Communications", this);
        prop = this.factory.createProperty(assoc, "interface", "CommonBehaviors-Communications-A_ownedReception_interface-interface", "CommonBehaviors-Communications-Interface", "Classes-Kernel-NamedElement-namespace Classes-Kernel-Feature-featuringClassifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-Interface-ownedReception CommonBehaviors-Communications-A_ownedReception_interface-interface");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        Package cfr_ignored_286 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_signal_reception", "CommonBehaviors-Communications-A_signal_reception");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.Communications", this);
        prop = this.factory.createProperty(assoc, "reception", "CommonBehaviors-Communications-A_signal_reception-reception", "CommonBehaviors-Communications-Reception", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-Reception-signal CommonBehaviors-Communications-A_signal_reception-reception");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-Communications";
        Package cfr_ignored_287 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_signal_signalEvent", "CommonBehaviors-Communications-A_signal_signalEvent");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.Communications", this);
        prop = this.factory.createProperty(assoc, "signalEvent", "CommonBehaviors-Communications-A_signal_signalEvent-signalEvent", "CommonBehaviors-Communications-SignalEvent", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-Communications-SignalEvent-signal CommonBehaviors-Communications-A_signal_signalEvent-signalEvent");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        Package cfr_ignored_288 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_event_durationObservation", "CommonBehaviors-SimpleTime-A_event_durationObservation");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        prop = this.factory.createProperty(assoc, "durationObservation", "CommonBehaviors-SimpleTime-A_event_durationObservation-durationObservation", "CommonBehaviors-SimpleTime-DurationObservation", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-DurationObservation-event CommonBehaviors-SimpleTime-A_event_durationObservation-durationObservation");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        Package cfr_ignored_289 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_event_timeObservation", "CommonBehaviors-SimpleTime-A_event_timeObservation");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        prop = this.factory.createProperty(assoc, "timeObservation", "CommonBehaviors-SimpleTime-A_event_timeObservation-timeObservation", "CommonBehaviors-SimpleTime-TimeObservation", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeObservation-event CommonBehaviors-SimpleTime-A_event_timeObservation-timeObservation");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        Package cfr_ignored_290 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_expr_duration", "CommonBehaviors-SimpleTime-A_expr_duration");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        prop = this.factory.createProperty(assoc, "duration", "CommonBehaviors-SimpleTime-A_expr_duration-duration", "CommonBehaviors-SimpleTime-Duration", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-Duration-expr CommonBehaviors-SimpleTime-A_expr_duration-duration");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        Package cfr_ignored_291 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_expr_timeExpression", "CommonBehaviors-SimpleTime-A_expr_timeExpression");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        prop = this.factory.createProperty(assoc, "timeExpression", "CommonBehaviors-SimpleTime-A_expr_timeExpression-timeExpression", "CommonBehaviors-SimpleTime-TimeExpression", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeExpression-expr CommonBehaviors-SimpleTime-A_expr_timeExpression-timeExpression");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        Package cfr_ignored_292 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_max_durationInterval", "CommonBehaviors-SimpleTime-A_max_durationInterval");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        prop = this.factory.createProperty(assoc, "durationInterval", "CommonBehaviors-SimpleTime-A_max_durationInterval-durationInterval", "CommonBehaviors-SimpleTime-DurationInterval", "", "CommonBehaviors-SimpleTime-A_max_interval-interval", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-DurationInterval-max CommonBehaviors-SimpleTime-A_max_durationInterval-durationInterval");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        Package cfr_ignored_293 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_max_interval", "CommonBehaviors-SimpleTime-A_max_interval");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        prop = this.factory.createProperty(assoc, "interval", "CommonBehaviors-SimpleTime-A_max_interval-interval", "CommonBehaviors-SimpleTime-Interval", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-Interval-max CommonBehaviors-SimpleTime-A_max_interval-interval");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        Package cfr_ignored_294 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_max_timeInterval", "CommonBehaviors-SimpleTime-A_max_timeInterval");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        prop = this.factory.createProperty(assoc, "timeInterval", "CommonBehaviors-SimpleTime-A_max_timeInterval-timeInterval", "CommonBehaviors-SimpleTime-TimeInterval", "", "CommonBehaviors-SimpleTime-A_max_interval-interval", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeInterval-max CommonBehaviors-SimpleTime-A_max_timeInterval-timeInterval");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        Package cfr_ignored_295 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_min_durationInterval", "CommonBehaviors-SimpleTime-A_min_durationInterval");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        prop = this.factory.createProperty(assoc, "durationInterval", "CommonBehaviors-SimpleTime-A_min_durationInterval-durationInterval", "CommonBehaviors-SimpleTime-DurationInterval", "", "CommonBehaviors-SimpleTime-A_min_interval-interval", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-DurationInterval-min CommonBehaviors-SimpleTime-A_min_durationInterval-durationInterval");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        Package cfr_ignored_296 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_min_interval", "CommonBehaviors-SimpleTime-A_min_interval");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        prop = this.factory.createProperty(assoc, "interval", "CommonBehaviors-SimpleTime-A_min_interval-interval", "CommonBehaviors-SimpleTime-Interval", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-Interval-min CommonBehaviors-SimpleTime-A_min_interval-interval");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        Package cfr_ignored_297 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_min_timeInterval", "CommonBehaviors-SimpleTime-A_min_timeInterval");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        prop = this.factory.createProperty(assoc, "timeInterval", "CommonBehaviors-SimpleTime-A_min_timeInterval-timeInterval", "CommonBehaviors-SimpleTime-TimeInterval", "", "CommonBehaviors-SimpleTime-A_min_interval-interval", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeInterval-min CommonBehaviors-SimpleTime-A_min_timeInterval-timeInterval");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        Package cfr_ignored_298 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_observation_duration", "CommonBehaviors-SimpleTime-A_observation_duration");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        prop = this.factory.createProperty(assoc, "duration", "CommonBehaviors-SimpleTime-A_observation_duration-duration", "CommonBehaviors-SimpleTime-Duration", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-Duration-observation CommonBehaviors-SimpleTime-A_observation_duration-duration");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        Package cfr_ignored_299 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_observation_timeExpression", "CommonBehaviors-SimpleTime-A_observation_timeExpression");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        prop = this.factory.createProperty(assoc, "timeExpression", "CommonBehaviors-SimpleTime-A_observation_timeExpression-timeExpression", "CommonBehaviors-SimpleTime-TimeExpression", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeExpression-observation CommonBehaviors-SimpleTime-A_observation_timeExpression-timeExpression");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        Package cfr_ignored_300 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_specification_durationConstraint", "CommonBehaviors-SimpleTime-A_specification_durationConstraint");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        prop = this.factory.createProperty(assoc, "durationConstraint", "CommonBehaviors-SimpleTime-A_specification_durationConstraint-durationConstraint", "CommonBehaviors-SimpleTime-DurationConstraint", "", "CommonBehaviors-SimpleTime-A_specification_intervalConstraint-intervalConstraint", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-DurationConstraint-specification CommonBehaviors-SimpleTime-A_specification_durationConstraint-durationConstraint");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        Package cfr_ignored_301 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_specification_intervalConstraint", "CommonBehaviors-SimpleTime-A_specification_intervalConstraint");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        prop = this.factory.createProperty(assoc, "intervalConstraint", "CommonBehaviors-SimpleTime-A_specification_intervalConstraint-intervalConstraint", "CommonBehaviors-SimpleTime-IntervalConstraint", "", "Classes-Kernel-A_specification_owningConstraint-owningConstraint", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-IntervalConstraint-specification CommonBehaviors-SimpleTime-A_specification_intervalConstraint-intervalConstraint");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        Package cfr_ignored_302 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_specification_timeConstraint", "CommonBehaviors-SimpleTime-A_specification_timeConstraint");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        prop = this.factory.createProperty(assoc, "timeConstraint", "CommonBehaviors-SimpleTime-A_specification_timeConstraint-timeConstraint", "CommonBehaviors-SimpleTime-TimeConstraint", "", "CommonBehaviors-SimpleTime-A_specification_intervalConstraint-intervalConstraint", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeConstraint-specification CommonBehaviors-SimpleTime-A_specification_timeConstraint-timeConstraint");
        packageId = this.artifact.getUrn() + "#" + "CommonBehaviors-SimpleTime";
        Package cfr_ignored_303 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_when_timeEvent", "CommonBehaviors-SimpleTime-A_when_timeEvent");
        this.mapping.mapAssociation(assoc, "UML.CommonBehaviors.SimpleTime", this);
        prop = this.factory.createProperty(assoc, "timeEvent", "CommonBehaviors-SimpleTime-A_when_timeEvent-timeEvent", "CommonBehaviors-SimpleTime-TimeEvent", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CommonBehaviors-SimpleTime-TimeEvent-when CommonBehaviors-SimpleTime-A_when_timeEvent-timeEvent");
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";
        Package cfr_ignored_304 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_contract_connector", "Components-BasicComponents-A_contract_connector");
        this.mapping.mapAssociation(assoc, "UML.Components.BasicComponents", this);
        prop = this.factory.createProperty(assoc, "connector", "Components-BasicComponents-A_contract_connector-connector", "Components-BasicComponents-Connector", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Components-BasicComponents-Connector-contract Components-BasicComponents-A_contract_connector-connector");
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";
        Package cfr_ignored_305 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_end_connector", "Components-BasicComponents-A_end_connector");
        this.mapping.mapAssociation(assoc, "UML.Components.BasicComponents", this);
        prop = this.factory.createProperty(assoc, "connector", "Components-BasicComponents-A_end_connector-connector", "Components-BasicComponents-Connector", "", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Components-BasicComponents-Connector-end Components-BasicComponents-A_end_connector-connector");
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";
        Package cfr_ignored_306 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_end_role", "Components-BasicComponents-A_end_role");
        this.mapping.mapAssociation(assoc, "UML.Components.BasicComponents", this);
        this.factory.createAssociationEnds(assoc, "Components-BasicComponents-ConnectableElement-end Components-BasicComponents-ConnectorEnd-role");
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";
        Package cfr_ignored_307 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_partWithPort_connectorEnd", "Components-BasicComponents-A_partWithPort_connectorEnd");
        this.mapping.mapAssociation(assoc, "UML.Components.BasicComponents", this);
        prop = this.factory.createProperty(assoc, "connectorEnd", "Components-BasicComponents-A_partWithPort_connectorEnd-connectorEnd", "Components-BasicComponents-ConnectorEnd", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Components-BasicComponents-ConnectorEnd-partWithPort Components-BasicComponents-A_partWithPort_connectorEnd-connectorEnd");
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";
        Package cfr_ignored_308 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_provided_component", "Components-BasicComponents-A_provided_component");
        this.mapping.mapAssociation(assoc, "UML.Components.BasicComponents", this);
        prop = this.factory.createProperty(assoc, "component", "Components-BasicComponents-A_provided_component-component", "Components-BasicComponents-Component", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Components-BasicComponents-Component-provided Components-BasicComponents-A_provided_component-component");
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";
        Package cfr_ignored_309 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_realization_abstraction_component", "Components-BasicComponents-A_realization_abstraction_component");
        this.mapping.mapAssociation(assoc, "UML.Components.BasicComponents", this);
        this.factory.createAssociationEnds(assoc, "Components-BasicComponents-Component-realization Components-BasicComponents-ComponentRealization-abstraction");
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";
        Package cfr_ignored_310 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_realizingClassifier_componentRealization", "Components-BasicComponents-A_realizingClassifier_componentRealization");
        this.mapping.mapAssociation(assoc, "UML.Components.BasicComponents", this);
        prop = this.factory.createProperty(assoc, "componentRealization", "Components-BasicComponents-A_realizingClassifier_componentRealization-componentRealization", "Components-BasicComponents-ComponentRealization", "Classes-Dependencies-NamedElement-clientDependency", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Components-BasicComponents-ComponentRealization-realizingClassifier Components-BasicComponents-A_realizingClassifier_componentRealization-componentRealization");
        packageId = this.artifact.getUrn() + "#" + "Components-BasicComponents";
        Package cfr_ignored_311 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_required_component", "Components-BasicComponents-A_required_component");
        this.mapping.mapAssociation(assoc, "UML.Components.BasicComponents", this);
        prop = this.factory.createProperty(assoc, "component", "Components-BasicComponents-A_required_component-component", "Components-BasicComponents-Component", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Components-BasicComponents-Component-required Components-BasicComponents-A_required_component-component");
        packageId = this.artifact.getUrn() + "#" + "Components-PackagingComponents";
        Package cfr_ignored_312 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_packagedElement_component", "Components-PackagingComponents-A_packagedElement_component");
        this.mapping.mapAssociation(assoc, "UML.Components.PackagingComponents", this);
        prop = this.factory.createProperty(assoc, "component", "Components-PackagingComponents-A_packagedElement_component-component", "Components-PackagingComponents-Component", "Classes-Kernel-NamedElement-namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Components-PackagingComponents-Component-packagedElement Components-PackagingComponents-A_packagedElement_component-component");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";
        Package cfr_ignored_313 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_collaborationRole_collaboration", "CompositeStructures-Collaborations-A_collaborationRole_collaboration");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.Collaborations", this);
        prop = this.factory.createProperty(assoc, "collaboration", "CompositeStructures-Collaborations-A_collaborationRole_collaboration-collaboration", "CompositeStructures-Collaborations-Collaboration", "CompositeStructures-InternalStructures-A_role_structuredClassifier-structuredClassifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-Collaborations-Collaboration-collaborationRole CompositeStructures-Collaborations-A_collaborationRole_collaboration-collaboration");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";
        Package cfr_ignored_314 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_collaborationUse_classifier", "CompositeStructures-Collaborations-A_collaborationUse_classifier");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.Collaborations", this);
        prop = this.factory.createProperty(assoc, "classifier", "CompositeStructures-Collaborations-A_collaborationUse_classifier-classifier", "CompositeStructures-Collaborations-Classifier", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-Collaborations-Classifier-collaborationUse CompositeStructures-Collaborations-A_collaborationUse_classifier-classifier");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";
        Package cfr_ignored_315 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_representation_classifier", "CompositeStructures-Collaborations-A_representation_classifier");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.Collaborations", this);
        prop = this.factory.createProperty(assoc, "classifier", "CompositeStructures-Collaborations-A_representation_classifier-classifier", "CompositeStructures-Collaborations-Classifier", "", "CompositeStructures-Collaborations-A_collaborationUse_classifier-classifier", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-Collaborations-Classifier-representation CompositeStructures-Collaborations-A_representation_classifier-classifier");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";
        Package cfr_ignored_316 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_roleBinding_collaborationUse", "CompositeStructures-Collaborations-A_roleBinding_collaborationUse");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.Collaborations", this);
        prop = this.factory.createProperty(assoc, "collaborationUse", "CompositeStructures-Collaborations-A_roleBinding_collaborationUse-collaborationUse", "CompositeStructures-Collaborations-CollaborationUse", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-Collaborations-CollaborationUse-roleBinding CompositeStructures-Collaborations-A_roleBinding_collaborationUse-collaborationUse");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Collaborations";
        Package cfr_ignored_317 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_type_collaborationUse", "CompositeStructures-Collaborations-A_type_collaborationUse");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.Collaborations", this);
        prop = this.factory.createProperty(assoc, "collaborationUse", "CompositeStructures-Collaborations-A_type_collaborationUse-collaborationUse", "CompositeStructures-Collaborations-CollaborationUse", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-Collaborations-CollaborationUse-type CompositeStructures-Collaborations-A_type_collaborationUse-collaborationUse");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        Package cfr_ignored_318 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_attribute_classifier", "CompositeStructures-InternalStructures-A_attribute_classifier");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        prop = this.factory.createProperty(assoc, "classifier", "CompositeStructures-InternalStructures-A_attribute_classifier-classifier", "CompositeStructures-InternalStructures-Classifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-Classifier-attribute CompositeStructures-InternalStructures-A_attribute_classifier-classifier");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        Package cfr_ignored_319 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_definingEnd_connectorEnd", "CompositeStructures-InternalStructures-A_definingEnd_connectorEnd");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        prop = this.factory.createProperty(assoc, "connectorEnd", "CompositeStructures-InternalStructures-A_definingEnd_connectorEnd-connectorEnd", "CompositeStructures-InternalStructures-ConnectorEnd", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-ConnectorEnd-definingEnd CompositeStructures-InternalStructures-A_definingEnd_connectorEnd-connectorEnd");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        Package cfr_ignored_320 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_end_connector", "CompositeStructures-InternalStructures-A_end_connector");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        prop = this.factory.createProperty(assoc, "connector", "CompositeStructures-InternalStructures-A_end_connector-connector", "CompositeStructures-InternalStructures-Connector", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-Connector-end CompositeStructures-InternalStructures-A_end_connector-connector");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        Package cfr_ignored_321 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_end_role", "CompositeStructures-InternalStructures-A_end_role");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-ConnectableElement-end CompositeStructures-InternalStructures-ConnectorEnd-role");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        Package cfr_ignored_322 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_feature_featuringClassifier", "CompositeStructures-InternalStructures-A_feature_featuringClassifier");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-Classifier-feature CompositeStructures-InternalStructures-Feature-featuringClassifier");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        Package cfr_ignored_323 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedAttribute_class", "CompositeStructures-InternalStructures-A_ownedAttribute_class");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-Class-ownedAttribute CompositeStructures-InternalStructures-Property-class");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        Package cfr_ignored_324 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedAttribute_structuredClassifier", "CompositeStructures-InternalStructures-A_ownedAttribute_structuredClassifier");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        prop = this.factory.createProperty(assoc, "structuredClassifier", "CompositeStructures-InternalStructures-A_ownedAttribute_structuredClassifier-structuredClassifier", "CompositeStructures-InternalStructures-StructuredClassifier", "Classes-Kernel-NamedElement-namespace CompositeStructures-InternalStructures-A_attribute_classifier-classifier", "CompositeStructures-InternalStructures-A_role_structuredClassifier-structuredClassifier", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-StructuredClassifier-ownedAttribute CompositeStructures-InternalStructures-A_ownedAttribute_structuredClassifier-structuredClassifier");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        Package cfr_ignored_325 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedConnector_structuredClassifier", "CompositeStructures-InternalStructures-A_ownedConnector_structuredClassifier");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        prop = this.factory.createProperty(assoc, "structuredClassifier", "CompositeStructures-InternalStructures-A_ownedConnector_structuredClassifier-structuredClassifier", "CompositeStructures-InternalStructures-StructuredClassifier", "Classes-Kernel-NamedElement-namespace Classes-Kernel-Feature-featuringClassifier Classes-Kernel-RedefinableElement-redefinitionContext", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-StructuredClassifier-ownedConnector CompositeStructures-InternalStructures-A_ownedConnector_structuredClassifier-structuredClassifier");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        Package cfr_ignored_326 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_part_structuredClassifier", "CompositeStructures-InternalStructures-A_part_structuredClassifier");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        prop = this.factory.createProperty(assoc, "structuredClassifier", "CompositeStructures-InternalStructures-A_part_structuredClassifier-structuredClassifier", "CompositeStructures-InternalStructures-StructuredClassifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-StructuredClassifier-part CompositeStructures-InternalStructures-A_part_structuredClassifier-structuredClassifier");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        Package cfr_ignored_327 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedConnector_connector", "CompositeStructures-InternalStructures-A_redefinedConnector_connector");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        prop = this.factory.createProperty(assoc, "connector", "CompositeStructures-InternalStructures-A_redefinedConnector_connector-connector", "CompositeStructures-InternalStructures-Connector", "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-Connector-redefinedConnector CompositeStructures-InternalStructures-A_redefinedConnector_connector-connector");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        Package cfr_ignored_328 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_role_structuredClassifier", "CompositeStructures-InternalStructures-A_role_structuredClassifier");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        prop = this.factory.createProperty(assoc, "structuredClassifier", "CompositeStructures-InternalStructures-A_role_structuredClassifier-structuredClassifier", "CompositeStructures-InternalStructures-StructuredClassifier", "Classes-Kernel-A_member_memberNamespace-memberNamespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-StructuredClassifier-role CompositeStructures-InternalStructures-A_role_structuredClassifier-structuredClassifier");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InternalStructures";
        Package cfr_ignored_329 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_type_connector", "CompositeStructures-InternalStructures-A_type_connector");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.InternalStructures", this);
        prop = this.factory.createProperty(assoc, "connector", "CompositeStructures-InternalStructures-A_type_connector-connector", "CompositeStructures-InternalStructures-Connector", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-InternalStructures-Connector-type CompositeStructures-InternalStructures-A_type_connector-connector");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InvocationActions";
        Package cfr_ignored_330 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_onPort_invocationAction", "CompositeStructures-InvocationActions-A_onPort_invocationAction");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.InvocationActions", this);
        prop = this.factory.createProperty(assoc, "invocationAction", "CompositeStructures-InvocationActions-A_onPort_invocationAction-invocationAction", "CompositeStructures-InvocationActions-InvocationAction", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-InvocationActions-InvocationAction-onPort CompositeStructures-InvocationActions-A_onPort_invocationAction-invocationAction");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-InvocationActions";
        Package cfr_ignored_331 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_port_trigger", "CompositeStructures-InvocationActions-A_port_trigger");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.InvocationActions", this);
        prop = this.factory.createProperty(assoc, "trigger", "CompositeStructures-InvocationActions-A_port_trigger-trigger", "CompositeStructures-InvocationActions-Trigger", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-InvocationActions-Trigger-port CompositeStructures-InvocationActions-A_port_trigger-trigger");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";
        Package cfr_ignored_332 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedPort_encapsulatedClassifier", "CompositeStructures-Ports-A_ownedPort_encapsulatedClassifier");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.Ports", this);
        prop = this.factory.createProperty(assoc, "encapsulatedClassifier", "CompositeStructures-Ports-A_ownedPort_encapsulatedClassifier-encapsulatedClassifier", "CompositeStructures-Ports-EncapsulatedClassifier", "CompositeStructures-InternalStructures-A_ownedAttribute_structuredClassifier-structuredClassifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-Ports-EncapsulatedClassifier-ownedPort CompositeStructures-Ports-A_ownedPort_encapsulatedClassifier-encapsulatedClassifier");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";
        Package cfr_ignored_333 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_partWithPort_connectorEnd", "CompositeStructures-Ports-A_partWithPort_connectorEnd");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.Ports", this);
        prop = this.factory.createProperty(assoc, "connectorEnd", "CompositeStructures-Ports-A_partWithPort_connectorEnd-connectorEnd", "CompositeStructures-Ports-ConnectorEnd", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-Ports-ConnectorEnd-partWithPort CompositeStructures-Ports-A_partWithPort_connectorEnd-connectorEnd");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";
        Package cfr_ignored_334 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_provided_port", "CompositeStructures-Ports-A_provided_port");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.Ports", this);
        prop = this.factory.createProperty(assoc, "port", "CompositeStructures-Ports-A_provided_port-port", "CompositeStructures-Ports-Port", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-Ports-Port-provided CompositeStructures-Ports-A_provided_port-port");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";
        Package cfr_ignored_335 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedPort_port", "CompositeStructures-Ports-A_redefinedPort_port");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.Ports", this);
        prop = this.factory.createProperty(assoc, "port", "CompositeStructures-Ports-A_redefinedPort_port-port", "CompositeStructures-Ports-Port", "Classes-Kernel-A_redefinedProperty_property-property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-Ports-Port-redefinedPort CompositeStructures-Ports-A_redefinedPort_port-port");
        packageId = this.artifact.getUrn() + "#" + "CompositeStructures-Ports";
        Package cfr_ignored_336 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_required_port", "CompositeStructures-Ports-A_required_port");
        this.mapping.mapAssociation(assoc, "UML.CompositeStructures.Ports", this);
        prop = this.factory.createProperty(assoc, "port", "CompositeStructures-Ports-A_required_port-port", "CompositeStructures-Ports-Port", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "CompositeStructures-Ports-Port-required CompositeStructures-Ports-A_required_port-port");
        packageId = this.artifact.getUrn() + "#" + "Deployments-Artifacts";
        Package cfr_ignored_337 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_manifestation_artifact", "Deployments-Artifacts-A_manifestation_artifact");
        this.mapping.mapAssociation(assoc, "UML.Deployments.Artifacts", this);
        prop = this.factory.createProperty(assoc, "artifact", "Deployments-Artifacts-A_manifestation_artifact-artifact", "Deployments-Artifacts-Artifact", "Classes-Kernel-Element-owner Classes-Dependencies-Dependency-client", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Deployments-Artifacts-Artifact-manifestation Deployments-Artifacts-A_manifestation_artifact-artifact");
        packageId = this.artifact.getUrn() + "#" + "Deployments-Artifacts";
        Package cfr_ignored_338 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_nestedArtifact_artifact", "Deployments-Artifacts-A_nestedArtifact_artifact");
        this.mapping.mapAssociation(assoc, "UML.Deployments.Artifacts", this);
        prop = this.factory.createProperty(assoc, "artifact", "Deployments-Artifacts-A_nestedArtifact_artifact-artifact", "Deployments-Artifacts-Artifact", "Classes-Kernel-NamedElement-namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Deployments-Artifacts-Artifact-nestedArtifact Deployments-Artifacts-A_nestedArtifact_artifact-artifact");
        packageId = this.artifact.getUrn() + "#" + "Deployments-Artifacts";
        Package cfr_ignored_339 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedAttribute_artifact", "Deployments-Artifacts-A_ownedAttribute_artifact");
        this.mapping.mapAssociation(assoc, "UML.Deployments.Artifacts", this);
        prop = this.factory.createProperty(assoc, "artifact", "Deployments-Artifacts-A_ownedAttribute_artifact-artifact", "Deployments-Artifacts-Artifact", "Classes-Kernel-NamedElement-namespace Classes-Kernel-A_attribute_classifier-classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Deployments-Artifacts-Artifact-ownedAttribute Deployments-Artifacts-A_ownedAttribute_artifact-artifact");
        packageId = this.artifact.getUrn() + "#" + "Deployments-Artifacts";
        Package cfr_ignored_340 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedOperation_artifact", "Deployments-Artifacts-A_ownedOperation_artifact");
        this.mapping.mapAssociation(assoc, "UML.Deployments.Artifacts", this);
        prop = this.factory.createProperty(assoc, "artifact", "Deployments-Artifacts-A_ownedOperation_artifact-artifact", "Deployments-Artifacts-Artifact", "Classes-Kernel-NamedElement-namespace Classes-Kernel-Feature-featuringClassifier Classes-Kernel-RedefinableElement-redefinitionContext", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Deployments-Artifacts-Artifact-ownedOperation Deployments-Artifacts-A_ownedOperation_artifact-artifact");
        packageId = this.artifact.getUrn() + "#" + "Deployments-Artifacts";
        Package cfr_ignored_341 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_utilizedElement_manifestation", "Deployments-Artifacts-A_utilizedElement_manifestation");
        this.mapping.mapAssociation(assoc, "UML.Deployments.Artifacts", this);
        prop = this.factory.createProperty(assoc, "manifestation", "Deployments-Artifacts-A_utilizedElement_manifestation-manifestation", "Deployments-Artifacts-Manifestation", "Classes-Dependencies-A_supplier_supplierDependency-supplierDependency", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Deployments-Artifacts-Manifestation-utilizedElement Deployments-Artifacts-A_utilizedElement_manifestation-manifestation");
        packageId = this.artifact.getUrn() + "#" + "Deployments-ComponentDeployments";
        Package cfr_ignored_342 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_configuration_deployment", "Deployments-ComponentDeployments-A_configuration_deployment");
        this.mapping.mapAssociation(assoc, "UML.Deployments.ComponentDeployments", this);
        this.factory.createAssociationEnds(assoc, "Deployments-ComponentDeployments-Deployment-configuration Deployments-ComponentDeployments-DeploymentSpecification-deployment");
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";
        Package cfr_ignored_343 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_deployedArtifact_deployment", "Deployments-Nodes-A_deployedArtifact_deployment");
        this.mapping.mapAssociation(assoc, "UML.Deployments.Nodes", this);
        prop = this.factory.createProperty(assoc, "deployment", "Deployments-Nodes-A_deployedArtifact_deployment-deployment", "Deployments-Nodes-Deployment", "Classes-Dependencies-A_supplier_supplierDependency-supplierDependency", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Deployments-Nodes-Deployment-deployedArtifact Deployments-Nodes-A_deployedArtifact_deployment-deployment");
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";
        Package cfr_ignored_344 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_deployedElement_deploymentTarget", "Deployments-Nodes-A_deployedElement_deploymentTarget");
        this.mapping.mapAssociation(assoc, "UML.Deployments.Nodes", this);
        prop = this.factory.createProperty(assoc, "deploymentTarget", "Deployments-Nodes-A_deployedElement_deploymentTarget-deploymentTarget", "Deployments-Nodes-DeploymentTarget", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Deployments-Nodes-DeploymentTarget-deployedElement Deployments-Nodes-A_deployedElement_deploymentTarget-deploymentTarget");
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";
        Package cfr_ignored_345 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_deployment_location", "Deployments-Nodes-A_deployment_location");
        this.mapping.mapAssociation(assoc, "UML.Deployments.Nodes", this);
        this.factory.createAssociationEnds(assoc, "Deployments-Nodes-DeploymentTarget-deployment Deployments-Nodes-Deployment-location");
        packageId = this.artifact.getUrn() + "#" + "Deployments-Nodes";
        Package cfr_ignored_346 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_nestedNode_node", "Deployments-Nodes-A_nestedNode_node");
        this.mapping.mapAssociation(assoc, "UML.Deployments.Nodes", this);
        prop = this.factory.createProperty(assoc, "node", "Deployments-Nodes-A_nestedNode_node-node", "Deployments-Nodes-Node", "Classes-Kernel-NamedElement-namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Deployments-Nodes-Node-nestedNode Deployments-Nodes-A_nestedNode_node-node");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_347 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_action_actionExecutionSpecification", "Interactions-BasicInteractions-A_action_actionExecutionSpecification");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "actionExecutionSpecification", "Interactions-BasicInteractions-A_action_actionExecutionSpecification-actionExecutionSpecification", "Interactions-BasicInteractions-ActionExecutionSpecification", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-ActionExecutionSpecification-action Interactions-BasicInteractions-A_action_actionExecutionSpecification-actionExecutionSpecification");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_348 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_action_interaction", "Interactions-BasicInteractions-A_action_interaction");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "interaction", "Interactions-BasicInteractions-A_action_interaction-interaction", "Interactions-BasicInteractions-Interaction", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Interaction-action Interactions-BasicInteractions-A_action_interaction-interaction");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_349 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_argument_message", "Interactions-BasicInteractions-A_argument_message");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "message", "Interactions-BasicInteractions-A_argument_message-message", "Interactions-BasicInteractions-Message", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Message-argument Interactions-BasicInteractions-A_argument_message-message");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_350 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_before_toAfter", "Interactions-BasicInteractions-A_before_toAfter");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-GeneralOrdering-before Interactions-BasicInteractions-OccurrenceSpecification-toAfter");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_351 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_behavior_behaviorExecutionSpecification", "Interactions-BasicInteractions-A_behavior_behaviorExecutionSpecification");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "behaviorExecutionSpecification", "Interactions-BasicInteractions-A_behavior_behaviorExecutionSpecification-behaviorExecutionSpecification", "Interactions-BasicInteractions-BehaviorExecutionSpecification", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-BehaviorExecutionSpecification-behavior Interactions-BasicInteractions-A_behavior_behaviorExecutionSpecification-behaviorExecutionSpecification");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_352 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_connector_message", "Interactions-BasicInteractions-A_connector_message");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "message", "Interactions-BasicInteractions-A_connector_message-message", "Interactions-BasicInteractions-Message", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Message-connector Interactions-BasicInteractions-A_connector_message-message");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_353 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_covered_coveredBy", "Interactions-BasicInteractions-A_covered_coveredBy");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-InteractionFragment-covered Interactions-BasicInteractions-Lifeline-coveredBy");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_354 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_covered_events", "Interactions-BasicInteractions-A_covered_events");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "events", "Interactions-BasicInteractions-A_covered_events-events", "Interactions-BasicInteractions-OccurrenceSpecification", "Interactions-BasicInteractions-Lifeline-coveredBy", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-OccurrenceSpecification-covered Interactions-BasicInteractions-A_covered_events-events");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_355 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_covered_stateInvariant", "Interactions-BasicInteractions-A_covered_stateInvariant");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "stateInvariant", "Interactions-BasicInteractions-A_covered_stateInvariant-stateInvariant", "Interactions-BasicInteractions-StateInvariant", "Interactions-BasicInteractions-Lifeline-coveredBy", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-StateInvariant-covered Interactions-BasicInteractions-A_covered_stateInvariant-stateInvariant");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_356 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_execution_executionOccurrenceSpecification", "Interactions-BasicInteractions-A_execution_executionOccurrenceSpecification");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "executionOccurrenceSpecification", "Interactions-BasicInteractions-A_execution_executionOccurrenceSpecification-executionOccurrenceSpecification", "Interactions-BasicInteractions-ExecutionOccurrenceSpecification", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "2");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-ExecutionOccurrenceSpecification-execution Interactions-BasicInteractions-A_execution_executionOccurrenceSpecification-executionOccurrenceSpecification");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_357 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_finish_executionSpecification", "Interactions-BasicInteractions-A_finish_executionSpecification");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "executionSpecification", "Interactions-BasicInteractions-A_finish_executionSpecification-executionSpecification", "Interactions-BasicInteractions-ExecutionSpecification", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-ExecutionSpecification-finish Interactions-BasicInteractions-A_finish_executionSpecification-executionSpecification");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_358 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_fragment_enclosingInteraction", "Interactions-BasicInteractions-A_fragment_enclosingInteraction");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Interaction-fragment Interactions-BasicInteractions-InteractionFragment-enclosingInteraction");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_359 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_generalOrdering_interactionFragment", "Interactions-BasicInteractions-A_generalOrdering_interactionFragment");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "interactionFragment", "Interactions-BasicInteractions-A_generalOrdering_interactionFragment-interactionFragment", "Interactions-BasicInteractions-InteractionFragment", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-InteractionFragment-generalOrdering Interactions-BasicInteractions-A_generalOrdering_interactionFragment-interactionFragment");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_360 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_invariant_stateInvariant", "Interactions-BasicInteractions-A_invariant_stateInvariant");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "stateInvariant", "Interactions-BasicInteractions-A_invariant_stateInvariant-stateInvariant", "Interactions-BasicInteractions-StateInvariant", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-StateInvariant-invariant Interactions-BasicInteractions-A_invariant_stateInvariant-stateInvariant");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_361 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_lifeline_interaction", "Interactions-BasicInteractions-A_lifeline_interaction");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Interaction-lifeline Interactions-BasicInteractions-Lifeline-interaction");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_362 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_message_interaction", "Interactions-BasicInteractions-A_message_interaction");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Interaction-message Interactions-BasicInteractions-Message-interaction");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_363 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_message_messageEnd", "Interactions-BasicInteractions-A_message_messageEnd");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "messageEnd", "Interactions-BasicInteractions-A_message_messageEnd-messageEnd", "Interactions-BasicInteractions-MessageEnd", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "2");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-MessageEnd-message Interactions-BasicInteractions-A_message_messageEnd-messageEnd");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_364 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_receiveEvent_endMessage", "Interactions-BasicInteractions-A_receiveEvent_endMessage");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "endMessage", "Interactions-BasicInteractions-A_receiveEvent_endMessage-endMessage", "Interactions-BasicInteractions-Message", "Interactions-BasicInteractions-MessageEnd-message", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Message-receiveEvent Interactions-BasicInteractions-A_receiveEvent_endMessage-endMessage");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_365 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_represents_lifeline", "Interactions-BasicInteractions-A_represents_lifeline");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "lifeline", "Interactions-BasicInteractions-A_represents_lifeline-lifeline", "Interactions-BasicInteractions-Lifeline", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Lifeline-represents Interactions-BasicInteractions-A_represents_lifeline-lifeline");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_366 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_selector_lifeline", "Interactions-BasicInteractions-A_selector_lifeline");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "lifeline", "Interactions-BasicInteractions-A_selector_lifeline-lifeline", "Interactions-BasicInteractions-Lifeline", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Lifeline-selector Interactions-BasicInteractions-A_selector_lifeline-lifeline");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_367 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_sendEvent_endMessage", "Interactions-BasicInteractions-A_sendEvent_endMessage");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "endMessage", "Interactions-BasicInteractions-A_sendEvent_endMessage-endMessage", "Interactions-BasicInteractions-Message", "Interactions-BasicInteractions-MessageEnd-message", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Message-sendEvent Interactions-BasicInteractions-A_sendEvent_endMessage-endMessage");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_368 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_signature_message", "Interactions-BasicInteractions-A_signature_message");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "message", "Interactions-BasicInteractions-A_signature_message-message", "Interactions-BasicInteractions-Message", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-Message-signature Interactions-BasicInteractions-A_signature_message-message");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_369 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_start_executionSpecification", "Interactions-BasicInteractions-A_start_executionSpecification");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        prop = this.factory.createProperty(assoc, "executionSpecification", "Interactions-BasicInteractions-A_start_executionSpecification-executionSpecification", "Interactions-BasicInteractions-ExecutionSpecification", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-ExecutionSpecification-start Interactions-BasicInteractions-A_start_executionSpecification-executionSpecification");
        packageId = this.artifact.getUrn() + "#" + "Interactions-BasicInteractions";
        Package cfr_ignored_370 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_toBefore_after", "Interactions-BasicInteractions-A_toBefore_after");
        this.mapping.mapAssociation(assoc, "UML.Interactions.BasicInteractions", this);
        this.factory.createAssociationEnds(assoc, "Interactions-BasicInteractions-OccurrenceSpecification-toBefore Interactions-BasicInteractions-GeneralOrdering-after");
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        Package cfr_ignored_371 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_actualGate_interactionUse", "Interactions-Fragments-A_actualGate_interactionUse");
        this.mapping.mapAssociation(assoc, "UML.Interactions.Fragments", this);
        prop = this.factory.createProperty(assoc, "interactionUse", "Interactions-Fragments-A_actualGate_interactionUse-interactionUse", "Interactions-Fragments-InteractionUse", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-Fragments-InteractionUse-actualGate Interactions-Fragments-A_actualGate_interactionUse-interactionUse");
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        Package cfr_ignored_372 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_argument_interactionUse", "Interactions-Fragments-A_argument_interactionUse");
        this.mapping.mapAssociation(assoc, "UML.Interactions.Fragments", this);
        prop = this.factory.createProperty(assoc, "interactionUse", "Interactions-Fragments-A_argument_interactionUse-interactionUse", "Interactions-Fragments-InteractionUse", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-Fragments-InteractionUse-argument Interactions-Fragments-A_argument_interactionUse-interactionUse");
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        Package cfr_ignored_373 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_cfragmentGate_combinedFragment", "Interactions-Fragments-A_cfragmentGate_combinedFragment");
        this.mapping.mapAssociation(assoc, "UML.Interactions.Fragments", this);
        prop = this.factory.createProperty(assoc, "combinedFragment", "Interactions-Fragments-A_cfragmentGate_combinedFragment-combinedFragment", "Interactions-Fragments-CombinedFragment", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-Fragments-CombinedFragment-cfragmentGate Interactions-Fragments-A_cfragmentGate_combinedFragment-combinedFragment");
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        Package cfr_ignored_374 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_decomposedAs_lifeline", "Interactions-Fragments-A_decomposedAs_lifeline");
        this.mapping.mapAssociation(assoc, "UML.Interactions.Fragments", this);
        prop = this.factory.createProperty(assoc, "lifeline", "Interactions-Fragments-A_decomposedAs_lifeline-lifeline", "Interactions-Fragments-Lifeline", "", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-Fragments-Lifeline-decomposedAs Interactions-Fragments-A_decomposedAs_lifeline-lifeline");
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        Package cfr_ignored_375 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_formalGate_interaction", "Interactions-Fragments-A_formalGate_interaction");
        this.mapping.mapAssociation(assoc, "UML.Interactions.Fragments", this);
        prop = this.factory.createProperty(assoc, "interaction", "Interactions-Fragments-A_formalGate_interaction-interaction", "Interactions-Fragments-Interaction", "Classes-Kernel-NamedElement-namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-Fragments-Interaction-formalGate Interactions-Fragments-A_formalGate_interaction-interaction");
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        Package cfr_ignored_376 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_fragment_enclosingOperand", "Interactions-Fragments-A_fragment_enclosingOperand");
        this.mapping.mapAssociation(assoc, "UML.Interactions.Fragments", this);
        this.factory.createAssociationEnds(assoc, "Interactions-Fragments-InteractionOperand-fragment Interactions-Fragments-InteractionFragment-enclosingOperand");
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        Package cfr_ignored_377 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_guard_interactionOperand", "Interactions-Fragments-A_guard_interactionOperand");
        this.mapping.mapAssociation(assoc, "UML.Interactions.Fragments", this);
        prop = this.factory.createProperty(assoc, "interactionOperand", "Interactions-Fragments-A_guard_interactionOperand-interactionOperand", "Interactions-Fragments-InteractionOperand", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-Fragments-InteractionOperand-guard Interactions-Fragments-A_guard_interactionOperand-interactionOperand");
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        Package cfr_ignored_378 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_maxint_interactionConstraint", "Interactions-Fragments-A_maxint_interactionConstraint");
        this.mapping.mapAssociation(assoc, "UML.Interactions.Fragments", this);
        prop = this.factory.createProperty(assoc, "interactionConstraint", "Interactions-Fragments-A_maxint_interactionConstraint-interactionConstraint", "Interactions-Fragments-InteractionConstraint", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-Fragments-InteractionConstraint-maxint Interactions-Fragments-A_maxint_interactionConstraint-interactionConstraint");
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        Package cfr_ignored_379 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_message_considerIgnoreFragment", "Interactions-Fragments-A_message_considerIgnoreFragment");
        this.mapping.mapAssociation(assoc, "UML.Interactions.Fragments", this);
        prop = this.factory.createProperty(assoc, "considerIgnoreFragment", "Interactions-Fragments-A_message_considerIgnoreFragment-considerIgnoreFragment", "Interactions-Fragments-ConsiderIgnoreFragment", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-Fragments-ConsiderIgnoreFragment-message Interactions-Fragments-A_message_considerIgnoreFragment-considerIgnoreFragment");
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        Package cfr_ignored_380 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_minint_interactionConstraint", "Interactions-Fragments-A_minint_interactionConstraint");
        this.mapping.mapAssociation(assoc, "UML.Interactions.Fragments", this);
        prop = this.factory.createProperty(assoc, "interactionConstraint", "Interactions-Fragments-A_minint_interactionConstraint-interactionConstraint", "Interactions-Fragments-InteractionConstraint", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-Fragments-InteractionConstraint-minint Interactions-Fragments-A_minint_interactionConstraint-interactionConstraint");
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        Package cfr_ignored_381 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_operand_combinedFragment", "Interactions-Fragments-A_operand_combinedFragment");
        this.mapping.mapAssociation(assoc, "UML.Interactions.Fragments", this);
        prop = this.factory.createProperty(assoc, "combinedFragment", "Interactions-Fragments-A_operand_combinedFragment-combinedFragment", "Interactions-Fragments-CombinedFragment", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-Fragments-CombinedFragment-operand Interactions-Fragments-A_operand_combinedFragment-combinedFragment");
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        Package cfr_ignored_382 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_refersTo_interactionUse", "Interactions-Fragments-A_refersTo_interactionUse");
        this.mapping.mapAssociation(assoc, "UML.Interactions.Fragments", this);
        prop = this.factory.createProperty(assoc, "interactionUse", "Interactions-Fragments-A_refersTo_interactionUse-interactionUse", "Interactions-Fragments-InteractionUse", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-Fragments-InteractionUse-refersTo Interactions-Fragments-A_refersTo_interactionUse-interactionUse");
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        Package cfr_ignored_383 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_returnValueRecipient_interactionUse", "Interactions-Fragments-A_returnValueRecipient_interactionUse");
        this.mapping.mapAssociation(assoc, "UML.Interactions.Fragments", this);
        prop = this.factory.createProperty(assoc, "interactionUse", "Interactions-Fragments-A_returnValueRecipient_interactionUse-interactionUse", "Interactions-Fragments-InteractionUse", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-Fragments-InteractionUse-returnValueRecipient Interactions-Fragments-A_returnValueRecipient_interactionUse-interactionUse");
        packageId = this.artifact.getUrn() + "#" + "Interactions-Fragments";
        Package cfr_ignored_384 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_returnValue_interactionUse", "Interactions-Fragments-A_returnValue_interactionUse");
        this.mapping.mapAssociation(assoc, "UML.Interactions.Fragments", this);
        prop = this.factory.createProperty(assoc, "interactionUse", "Interactions-Fragments-A_returnValue_interactionUse-interactionUse", "Interactions-Fragments-InteractionUse", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Interactions-Fragments-InteractionUse-returnValue Interactions-Fragments-A_returnValue_interactionUse-interactionUse");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_385 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_connectionPoint_state", "StateMachines-BehaviorStateMachines-A_connectionPoint_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-State-connectionPoint StateMachines-BehaviorStateMachines-Pseudostate-state");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_386 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_connectionPoint_stateMachine", "StateMachines-BehaviorStateMachines-A_connectionPoint_stateMachine");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-StateMachine-connectionPoint StateMachines-BehaviorStateMachines-Pseudostate-stateMachine");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_387 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_connection_state", "StateMachines-BehaviorStateMachines-A_connection_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-State-connection StateMachines-BehaviorStateMachines-ConnectionPointReference-state");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_388 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_deferrableTrigger_state", "StateMachines-BehaviorStateMachines-A_deferrableTrigger_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "state", "StateMachines-BehaviorStateMachines-A_deferrableTrigger_state-state", "StateMachines-BehaviorStateMachines-State", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-State-deferrableTrigger StateMachines-BehaviorStateMachines-A_deferrableTrigger_state-state");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_389 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_doActivity_state", "StateMachines-BehaviorStateMachines-A_doActivity_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "state", "StateMachines-BehaviorStateMachines-A_doActivity_state-state", "StateMachines-BehaviorStateMachines-State", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-State-doActivity StateMachines-BehaviorStateMachines-A_doActivity_state-state");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_390 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_effect_transition", "StateMachines-BehaviorStateMachines-A_effect_transition");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "transition", "StateMachines-BehaviorStateMachines-A_effect_transition-transition", "StateMachines-BehaviorStateMachines-Transition", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-Transition-effect StateMachines-BehaviorStateMachines-A_effect_transition-transition");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_391 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_entry_connectionPointReference", "StateMachines-BehaviorStateMachines-A_entry_connectionPointReference");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "connectionPointReference", "StateMachines-BehaviorStateMachines-A_entry_connectionPointReference-connectionPointReference", "StateMachines-BehaviorStateMachines-ConnectionPointReference", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-ConnectionPointReference-entry StateMachines-BehaviorStateMachines-A_entry_connectionPointReference-connectionPointReference");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_392 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_entry_state", "StateMachines-BehaviorStateMachines-A_entry_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "state", "StateMachines-BehaviorStateMachines-A_entry_state-state", "StateMachines-BehaviorStateMachines-State", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-State-entry StateMachines-BehaviorStateMachines-A_entry_state-state");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_393 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_exit_connectionPointReference", "StateMachines-BehaviorStateMachines-A_exit_connectionPointReference");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "connectionPointReference", "StateMachines-BehaviorStateMachines-A_exit_connectionPointReference-connectionPointReference", "StateMachines-BehaviorStateMachines-ConnectionPointReference", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-ConnectionPointReference-exit StateMachines-BehaviorStateMachines-A_exit_connectionPointReference-connectionPointReference");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_394 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_exit_state", "StateMachines-BehaviorStateMachines-A_exit_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "state", "StateMachines-BehaviorStateMachines-A_exit_state-state", "StateMachines-BehaviorStateMachines-State", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-State-exit StateMachines-BehaviorStateMachines-A_exit_state-state");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_395 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_extendedRegion_region", "StateMachines-BehaviorStateMachines-A_extendedRegion_region");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "region", "StateMachines-BehaviorStateMachines-A_extendedRegion_region-region", "StateMachines-BehaviorStateMachines-Region", "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-Region-extendedRegion StateMachines-BehaviorStateMachines-A_extendedRegion_region-region");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_396 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_extendedStateMachine_stateMachine", "StateMachines-BehaviorStateMachines-A_extendedStateMachine_stateMachine");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "stateMachine", "StateMachines-BehaviorStateMachines-A_extendedStateMachine_stateMachine-stateMachine", "StateMachines-BehaviorStateMachines-StateMachine", "CommonBehaviors-BasicBehaviors-A_redefinedBehavior_behavior-behavior", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-StateMachine-extendedStateMachine StateMachines-BehaviorStateMachines-A_extendedStateMachine_stateMachine-stateMachine");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_397 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_guard_transition", "StateMachines-BehaviorStateMachines-A_guard_transition");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "transition", "StateMachines-BehaviorStateMachines-A_guard_transition-transition", "StateMachines-BehaviorStateMachines-Transition", "Classes-Kernel-Constraint-context", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-Transition-guard StateMachines-BehaviorStateMachines-A_guard_transition-transition");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_398 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_incoming_target_vertex", "StateMachines-BehaviorStateMachines-A_incoming_target_vertex");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-Vertex-incoming StateMachines-BehaviorStateMachines-Transition-target");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_399 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_outgoing_source_vertex", "StateMachines-BehaviorStateMachines-A_outgoing_source_vertex");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-Vertex-outgoing StateMachines-BehaviorStateMachines-Transition-source");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_400 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedState_state", "StateMachines-BehaviorStateMachines-A_redefinedState_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "state", "StateMachines-BehaviorStateMachines-A_redefinedState_state-state", "StateMachines-BehaviorStateMachines-State", "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-State-redefinedState StateMachines-BehaviorStateMachines-A_redefinedState_state-state");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_401 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedTransition_transition", "StateMachines-BehaviorStateMachines-A_redefinedTransition_transition");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "transition", "StateMachines-BehaviorStateMachines-A_redefinedTransition_transition-transition", "StateMachines-BehaviorStateMachines-Transition", "Classes-Kernel-A_redefinedElement_redefinableElement-redefinableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-Transition-redefinedTransition StateMachines-BehaviorStateMachines-A_redefinedTransition_transition-transition");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_402 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinitionContext_region", "StateMachines-BehaviorStateMachines-A_redefinitionContext_region");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "region", "StateMachines-BehaviorStateMachines-A_redefinitionContext_region-region", "StateMachines-BehaviorStateMachines-Region", "", "Classes-Kernel-A_redefinitionContext_redefinableElement-redefinableElement", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-Region-redefinitionContext StateMachines-BehaviorStateMachines-A_redefinitionContext_region-region");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_403 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinitionContext_state", "StateMachines-BehaviorStateMachines-A_redefinitionContext_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "state", "StateMachines-BehaviorStateMachines-A_redefinitionContext_state-state", "StateMachines-BehaviorStateMachines-State", "", "Classes-Kernel-A_redefinitionContext_redefinableElement-redefinableElement", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-State-redefinitionContext StateMachines-BehaviorStateMachines-A_redefinitionContext_state-state");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_404 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinitionContext_transition", "StateMachines-BehaviorStateMachines-A_redefinitionContext_transition");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "transition", "StateMachines-BehaviorStateMachines-A_redefinitionContext_transition-transition", "StateMachines-BehaviorStateMachines-Transition", "", "Classes-Kernel-A_redefinitionContext_redefinableElement-redefinableElement", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-Transition-redefinitionContext StateMachines-BehaviorStateMachines-A_redefinitionContext_transition-transition");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_405 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_region_state", "StateMachines-BehaviorStateMachines-A_region_state");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-State-region StateMachines-BehaviorStateMachines-Region-state");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_406 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_region_stateMachine", "StateMachines-BehaviorStateMachines-A_region_stateMachine");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-StateMachine-region StateMachines-BehaviorStateMachines-Region-stateMachine");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_407 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_stateInvariant_owningState", "StateMachines-BehaviorStateMachines-A_stateInvariant_owningState");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "owningState", "StateMachines-BehaviorStateMachines-A_stateInvariant_owningState-owningState", "StateMachines-BehaviorStateMachines-State", "Classes-Kernel-Constraint-context", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-State-stateInvariant StateMachines-BehaviorStateMachines-A_stateInvariant_owningState-owningState");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_408 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_submachineState_submachine", "StateMachines-BehaviorStateMachines-A_submachineState_submachine");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-StateMachine-submachineState StateMachines-BehaviorStateMachines-State-submachine");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_409 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_subvertex_container", "StateMachines-BehaviorStateMachines-A_subvertex_container");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-Region-subvertex StateMachines-BehaviorStateMachines-Vertex-container");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_410 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_transition_container", "StateMachines-BehaviorStateMachines-A_transition_container");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-Region-transition StateMachines-BehaviorStateMachines-Transition-container");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-BehaviorStateMachines";
        Package cfr_ignored_411 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_trigger_transition", "StateMachines-BehaviorStateMachines-A_trigger_transition");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.BehaviorStateMachines", this);
        prop = this.factory.createProperty(assoc, "transition", "StateMachines-BehaviorStateMachines-A_trigger_transition-transition", "StateMachines-BehaviorStateMachines-Transition", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-BehaviorStateMachines-Transition-trigger StateMachines-BehaviorStateMachines-A_trigger_transition-transition");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";
        Package cfr_ignored_412 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_conformance_specificMachine", "StateMachines-ProtocolStateMachines-A_conformance_specificMachine");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.ProtocolStateMachines", this);
        this.factory.createAssociationEnds(assoc, "StateMachines-ProtocolStateMachines-ProtocolStateMachine-conformance StateMachines-ProtocolStateMachines-ProtocolConformance-specificMachine");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";
        Package cfr_ignored_413 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_generalMachine_protocolConformance", "StateMachines-ProtocolStateMachines-A_generalMachine_protocolConformance");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.ProtocolStateMachines", this);
        prop = this.factory.createProperty(assoc, "protocolConformance", "StateMachines-ProtocolStateMachines-A_generalMachine_protocolConformance-protocolConformance", "StateMachines-ProtocolStateMachines-ProtocolConformance", "Classes-Kernel-A_target_directedRelationship-directedRelationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-ProtocolStateMachines-ProtocolConformance-generalMachine StateMachines-ProtocolStateMachines-A_generalMachine_protocolConformance-protocolConformance");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";
        Package cfr_ignored_414 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_postCondition_owningTransition", "StateMachines-ProtocolStateMachines-A_postCondition_owningTransition");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.ProtocolStateMachines", this);
        prop = this.factory.createProperty(assoc, "owningTransition", "StateMachines-ProtocolStateMachines-A_postCondition_owningTransition-owningTransition", "StateMachines-ProtocolStateMachines-ProtocolTransition", "Classes-Kernel-Constraint-context", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-ProtocolStateMachines-ProtocolTransition-postCondition StateMachines-ProtocolStateMachines-A_postCondition_owningTransition-owningTransition");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";
        Package cfr_ignored_415 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_preCondition_protocolTransition", "StateMachines-ProtocolStateMachines-A_preCondition_protocolTransition");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.ProtocolStateMachines", this);
        prop = this.factory.createProperty(assoc, "protocolTransition", "StateMachines-ProtocolStateMachines-A_preCondition_protocolTransition-protocolTransition", "StateMachines-ProtocolStateMachines-ProtocolTransition", "", "StateMachines-BehaviorStateMachines-A_guard_transition-transition", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-ProtocolStateMachines-ProtocolTransition-preCondition StateMachines-ProtocolStateMachines-A_preCondition_protocolTransition-protocolTransition");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";
        Package cfr_ignored_416 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_protocol_interface", "StateMachines-ProtocolStateMachines-A_protocol_interface");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.ProtocolStateMachines", this);
        prop = this.factory.createProperty(assoc, "interface", "StateMachines-ProtocolStateMachines-A_protocol_interface-interface", "StateMachines-ProtocolStateMachines-Interface", "Classes-Kernel-NamedElement-namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-ProtocolStateMachines-Interface-protocol StateMachines-ProtocolStateMachines-A_protocol_interface-interface");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";
        Package cfr_ignored_417 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_protocol_port", "StateMachines-ProtocolStateMachines-A_protocol_port");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.ProtocolStateMachines", this);
        prop = this.factory.createProperty(assoc, "port", "StateMachines-ProtocolStateMachines-A_protocol_port-port", "StateMachines-ProtocolStateMachines-Port", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-ProtocolStateMachines-Port-protocol StateMachines-ProtocolStateMachines-A_protocol_port-port");
        packageId = this.artifact.getUrn() + "#" + "StateMachines-ProtocolStateMachines";
        Package cfr_ignored_418 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_referred_protocolTransition", "StateMachines-ProtocolStateMachines-A_referred_protocolTransition");
        this.mapping.mapAssociation(assoc, "UML.StateMachines.ProtocolStateMachines", this);
        prop = this.factory.createProperty(assoc, "protocolTransition", "StateMachines-ProtocolStateMachines-A_referred_protocolTransition-protocolTransition", "StateMachines-ProtocolStateMachines-ProtocolTransition", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "StateMachines-ProtocolStateMachines-ProtocolTransition-referred StateMachines-ProtocolStateMachines-A_referred_protocolTransition-protocolTransition");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_419 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_addition_include", "UseCases-A_addition_include");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        prop = this.factory.createProperty(assoc, "include", "UseCases-A_addition_include-include", "UseCases-Include", "Classes-Kernel-A_target_directedRelationship-directedRelationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "UseCases-Include-addition UseCases-A_addition_include-include");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_420 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_condition_extend", "UseCases-A_condition_extend");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        prop = this.factory.createProperty(assoc, "extend", "UseCases-A_condition_extend-extend", "UseCases-Extend", "Classes-Kernel-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "UseCases-Extend-condition UseCases-A_condition_extend-extend");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_421 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_extend_extension", "UseCases-A_extend_extension");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        this.factory.createAssociationEnds(assoc, "UseCases-UseCase-extend UseCases-Extend-extension");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_422 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_extendedCase_extend", "UseCases-A_extendedCase_extend");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        prop = this.factory.createProperty(assoc, "extend", "UseCases-A_extendedCase_extend-extend", "UseCases-Extend", "Classes-Kernel-A_target_directedRelationship-directedRelationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "UseCases-Extend-extendedCase UseCases-A_extendedCase_extend-extend");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_423 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_extensionLocation_extension", "UseCases-A_extensionLocation_extension");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        prop = this.factory.createProperty(assoc, "extension", "UseCases-A_extensionLocation_extension-extension", "UseCases-Extend", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "UseCases-Extend-extensionLocation UseCases-A_extensionLocation_extension-extension");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_424 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_extensionPoint_useCase", "UseCases-A_extensionPoint_useCase");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        this.factory.createAssociationEnds(assoc, "UseCases-UseCase-extensionPoint UseCases-ExtensionPoint-useCase");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_425 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_include_includingCase", "UseCases-A_include_includingCase");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        this.factory.createAssociationEnds(assoc, "UseCases-UseCase-include UseCases-Include-includingCase");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_426 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedUseCase_classifier", "UseCases-A_ownedUseCase_classifier");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        prop = this.factory.createProperty(assoc, "classifier", "UseCases-A_ownedUseCase_classifier-classifier", "UseCases-Classifier", "Classes-Kernel-NamedElement-namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "UseCases-Classifier-ownedUseCase UseCases-A_ownedUseCase_classifier-classifier");
        packageId = this.artifact.getUrn() + "#" + "UseCases";
        Package cfr_ignored_427 = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_subject_useCase", "UseCases-A_subject_useCase");
        this.mapping.mapAssociation(assoc, "UML.UseCases", this);
        this.factory.createAssociationEnds(assoc, "UseCases-UseCase-subject UseCases-Classifier-useCase");
    }
}

