/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Activities.CompleteStructuredActivities;

import fUML.Debug;
import fUML.Semantics.Activities.CompleteStructuredActivities.ClauseActivationList;
import fUML.Semantics.Activities.CompleteStructuredActivities.ConditionalNodeActivation;
import fUML.Semantics.Classes.Kernel.BooleanValue;
import fUML.Semantics.Classes.Kernel.ValueList;
import fUML.Syntax.Activities.CompleteStructuredActivities.Clause;
import fUML.Syntax.Activities.CompleteStructuredActivities.ClauseList;
import org.modeldriven.fuml.FumlObject;

public class ClauseActivation
extends FumlObject {
    public ConditionalNodeActivation conditionalNodeActivation = null;
    public Clause clause = null;

    public void receiveControl() {
        Debug.println("[receiveControl] clauseActivation = " + this);
        if (this.isReady()) {
            Debug.println("[receiveControl] Running test...");
            this.runTest();
            BooleanValue decision = this.getDecision();
            if (decision != null) {
                if (decision.value) {
                    Debug.println("[receiveControl] Test succeeded.");
                    this.selectBody();
                } else {
                    Debug.println("[receiveControl] Test failed.");
                    ClauseActivationList successors = this.getSuccessors();
                    for (ClauseActivation successor : successors) {
                        successor.receiveControl();
                    }
                }
            }
        }
    }

    public boolean isReady() {
        ClauseActivationList predecessors = this.getPredecessors();
        boolean ready = true;
        int i = 1;
        while (ready & i <= predecessors.size()) {
            ClauseActivation predecessor = predecessors.getValue(i - 1);
            BooleanValue decisionValue = predecessor.getDecision();
            ready = decisionValue == null ? false : !decisionValue.value;
            ++i;
        }
        return ready;
    }

    public void runTest() {
        this.conditionalNodeActivation.runTest(this.clause);
    }

    public void selectBody() {
        this.conditionalNodeActivation.selectBody(this.clause);
    }

    public BooleanValue getDecision() {
        ValueList deciderValues = this.conditionalNodeActivation.getPinValues(this.clause.decider);
        BooleanValue deciderValue = null;
        if (deciderValues.size() > 0) {
            deciderValue = (BooleanValue)deciderValues.getValue(0);
        }
        return deciderValue;
    }

    public ClauseActivationList getPredecessors() {
        ClauseActivationList predecessors = new ClauseActivationList();
        ClauseList predecessorClauses = this.clause.predecessorClause;
        for (int i = 0; i < predecessorClauses.size(); ++i) {
            Clause predecessorClause = predecessorClauses.getValue(i);
            predecessors.addValue(this.conditionalNodeActivation.getClauseActivation(predecessorClause));
        }
        return predecessors;
    }

    public ClauseActivationList getSuccessors() {
        ClauseActivationList successors = new ClauseActivationList();
        ClauseList successorClauses = this.clause.successorClause;
        for (int i = 0; i < successorClauses.size(); ++i) {
            Clause successorClause = successorClauses.getValue(i);
            successors.addValue(this.conditionalNodeActivation.getClauseActivation(successorClause));
        }
        return successors;
    }
}

