/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.repository.model;

import fUML.Syntax.Classes.Kernel.Association;
import fUML.Syntax.Classes.Kernel.Class_;
import fUML.Syntax.Classes.Kernel.Enumeration;
import fUML.Syntax.Classes.Kernel.EnumerationLiteral;
import fUML.Syntax.Classes.Kernel.Package;
import fUML.Syntax.Classes.Kernel.Property;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.repository.Repository;
import org.modeldriven.fuml.repository.RepositoryArtifact;
import org.modeldriven.fuml.repository.RepositoryMapping;
import org.modeldriven.fuml.repository.config.Artifact;
import org.modeldriven.fuml.repository.model.ModelAssembler;
import org.modeldriven.fuml.repository.model.ModelFactory;

public class InfrastructureAssembler
extends ModelAssembler
implements RepositoryArtifact {
    private static Log log = LogFactory.getLog(InfrastructureAssembler.class);
    private ModelFactory factory;

    public InfrastructureAssembler(Artifact artifact, RepositoryMapping mapping, Repository model) {
        super(artifact, mapping, model);
        this.factory = new ModelFactory(mapping, model);
        this.construct();
    }

    private void construct() {
        log.info((Object)"initializing...");
        this.constructPackages();
        this.constructPrimitiveTypes();
        this.constructEnumerations();
        this.constructClasses();
        this.constructProperties();
        this.constructGeneralizations();
        this.constructAssociations();
    }

    @Override
    public String getURN() {
        return this.artifact.getUrn();
    }

    @Override
    public String getNamespaceURI() {
        return this.artifact.getNamespaceURI();
    }

    private void constructPackages() {
        Package pkg = null;
        pkg = this.factory.createPackage("InfrastructureLibrary", "InfrastructureLibrary", "InfrastructureLibrary", this);
        this.mapping.mapPackage(pkg, null, this);
        pkg = this.factory.createPackage("Core", "InfrastructureLibrary.Core", "Core", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary", this);
        pkg = this.factory.createPackage("Abstractions", "InfrastructureLibrary.Core.Abstractions", "Core-Abstractions", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core", this);
        pkg = this.factory.createPackage("BehavioralFeatures", "InfrastructureLibrary.Core.Abstractions.BehavioralFeatures", "Core-Abstractions-BehavioralFeatures", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Changeabilities", "InfrastructureLibrary.Core.Abstractions.Changeabilities", "Core-Abstractions-Changeabilities", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Classifiers", "InfrastructureLibrary.Core.Abstractions.Classifiers", "Core-Abstractions-Classifiers", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Comments", "InfrastructureLibrary.Core.Abstractions.Comments", "Core-Abstractions-Comments", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Constraints", "InfrastructureLibrary.Core.Abstractions.Constraints", "Core-Abstractions-Constraints", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Elements", "InfrastructureLibrary.Core.Abstractions.Elements", "Core-Abstractions-Elements", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Expressions", "InfrastructureLibrary.Core.Abstractions.Expressions", "Core-Abstractions-Expressions", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Generalizations", "InfrastructureLibrary.Core.Abstractions.Generalizations", "Core-Abstractions-Generalizations", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Instances", "InfrastructureLibrary.Core.Abstractions.Instances", "Core-Abstractions-Instances", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Literals", "InfrastructureLibrary.Core.Abstractions.Literals", "Core-Abstractions-Literals", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Multiplicities", "InfrastructureLibrary.Core.Abstractions.Multiplicities", "Core-Abstractions-Multiplicities", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("MultiplicityExpressions", "InfrastructureLibrary.Core.Abstractions.MultiplicityExpressions", "Core-Abstractions-MultiplicityExpressions", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Namespaces", "InfrastructureLibrary.Core.Abstractions.Namespaces", "Core-Abstractions-Namespaces", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Ownerships", "InfrastructureLibrary.Core.Abstractions.Ownerships", "Core-Abstractions-Ownerships", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Redefinitions", "InfrastructureLibrary.Core.Abstractions.Redefinitions", "Core-Abstractions-Redefinitions", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Relationships", "InfrastructureLibrary.Core.Abstractions.Relationships", "Core-Abstractions-Relationships", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("StructuralFeatures", "InfrastructureLibrary.Core.Abstractions.StructuralFeatures", "Core-Abstractions-StructuralFeatures", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Super", "InfrastructureLibrary.Core.Abstractions.Super", "Core-Abstractions-Super", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("TypedElements", "InfrastructureLibrary.Core.Abstractions.TypedElements", "Core-Abstractions-TypedElements", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Visibilities", "InfrastructureLibrary.Core.Abstractions.Visibilities", "Core-Abstractions-Visibilities", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core.Abstractions", this);
        pkg = this.factory.createPackage("Basic", "InfrastructureLibrary.Core.Basic", "Core-Basic", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core", this);
        pkg = this.factory.createPackage("Constructs", "InfrastructureLibrary.Core.Constructs", "Core-Constructs", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary.Core", this);
        pkg = this.factory.createPackage("Profiles", "InfrastructureLibrary.Profiles", "Profiles", pkg, this);
        this.mapping.mapPackage(pkg, "InfrastructureLibrary", this);
        this.mapping.mapPackageMerge(pkg, "Core-Constructs");
    }

    private void constructPrimitiveTypes() {
        Object pkg = null;
        Object packageId = null;
        Object type = null;
    }

    private void constructClasses() {
        Package pkg = null;
        String packageId = null;
        Class_ clss = null;
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-BehavioralFeatures";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("BehavioralFeature", "Core-Abstractions-BehavioralFeatures-BehavioralFeature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.BehavioralFeatures", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-BehavioralFeatures";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Parameter", "Core-Abstractions-BehavioralFeatures-Parameter", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.BehavioralFeatures", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Changeabilities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StructuralFeature", "Core-Abstractions-Changeabilities-StructuralFeature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Changeabilities", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Classifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Classifier", "Core-Abstractions-Classifiers-Classifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Classifiers", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Classifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Feature", "Core-Abstractions-Classifiers-Feature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Classifiers", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Comments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Comment", "Core-Abstractions-Comments-Comment", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Comments", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Constraints";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Constraint", "Core-Abstractions-Constraints-Constraint", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Constraints", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Constraints";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("NamedElement", "Core-Abstractions-Constraints-NamedElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Constraints", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Constraints";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Namespace", "Core-Abstractions-Constraints-Namespace", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Constraints", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Elements";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Element", "Core-Abstractions-Elements-Element", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Elements", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Expressions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Expression", "Core-Abstractions-Expressions-Expression", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Expressions", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Expressions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OpaqueExpression", "Core-Abstractions-Expressions-OpaqueExpression", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Expressions", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Expressions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ValueSpecification", "Core-Abstractions-Expressions-ValueSpecification", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Expressions", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Generalizations";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Classifier", "Core-Abstractions-Generalizations-Classifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Generalizations", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Generalizations";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Generalization", "Core-Abstractions-Generalizations-Generalization", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Generalizations", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Instances";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InstanceSpecification", "Core-Abstractions-Instances-InstanceSpecification", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Instances", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Instances";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("InstanceValue", "Core-Abstractions-Instances-InstanceValue", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Instances", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Instances";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Slot", "Core-Abstractions-Instances-Slot", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Instances", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Literals";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralBoolean", "Core-Abstractions-Literals-LiteralBoolean", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Literals", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Literals";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralInteger", "Core-Abstractions-Literals-LiteralInteger", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Literals", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Literals";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralNull", "Core-Abstractions-Literals-LiteralNull", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Literals", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Literals";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralReal", "Core-Abstractions-Literals-LiteralReal", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Literals", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Literals";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralSpecification", "Core-Abstractions-Literals-LiteralSpecification", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Literals", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Literals";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralString", "Core-Abstractions-Literals-LiteralString", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Literals", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Literals";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("LiteralUnlimitedNatural", "Core-Abstractions-Literals-LiteralUnlimitedNatural", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Literals", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Multiplicities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("MultiplicityElement", "Core-Abstractions-Multiplicities-MultiplicityElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Multiplicities", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-MultiplicityExpressions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("MultiplicityElement", "Core-Abstractions-MultiplicityExpressions-MultiplicityElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.MultiplicityExpressions", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Namespaces";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("NamedElement", "Core-Abstractions-Namespaces-NamedElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Namespaces", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Namespaces";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Namespace", "Core-Abstractions-Namespaces-Namespace", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Namespaces", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Ownerships";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Element", "Core-Abstractions-Ownerships-Element", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Ownerships", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Redefinitions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("RedefinableElement", "Core-Abstractions-Redefinitions-RedefinableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Redefinitions", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Relationships";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DirectedRelationship", "Core-Abstractions-Relationships-DirectedRelationship", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Relationships", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Relationships";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Relationship", "Core-Abstractions-Relationships-Relationship", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Relationships", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-StructuralFeatures";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StructuralFeature", "Core-Abstractions-StructuralFeatures-StructuralFeature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.StructuralFeatures", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Super";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Classifier", "Core-Abstractions-Super-Classifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Super", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-TypedElements";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Type", "Core-Abstractions-TypedElements-Type", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.TypedElements", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-TypedElements";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TypedElement", "Core-Abstractions-TypedElements-TypedElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.TypedElements", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Visibilities";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("NamedElement", "Core-Abstractions-Visibilities-NamedElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Abstractions.Visibilities", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Class", "Core-Basic-Class", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Basic", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Comment", "Core-Basic-Comment", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Basic", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DataType", "Core-Basic-DataType", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Basic", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Element", "Core-Basic-Element", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Basic", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Enumeration", "Core-Basic-Enumeration", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Basic", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("EnumerationLiteral", "Core-Basic-EnumerationLiteral", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Basic", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("MultiplicityElement", "Core-Basic-MultiplicityElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Basic", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("NamedElement", "Core-Basic-NamedElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Basic", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Operation", "Core-Basic-Operation", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Basic", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Package", "Core-Basic-Package", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Basic", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Parameter", "Core-Basic-Parameter", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Basic", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PrimitiveType", "Core-Basic-PrimitiveType", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Basic", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Property", "Core-Basic-Property", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Basic", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Type", "Core-Basic-Type", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Basic", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TypedElement", "Core-Basic-TypedElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Basic", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Association", "Core-Constructs-Association", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("BehavioralFeature", "Core-Constructs-BehavioralFeature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Class", "Core-Constructs-Class", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Classifier", "Core-Constructs-Classifier", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Comment", "Core-Constructs-Comment", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Constraint", "Core-Constructs-Constraint", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DataType", "Core-Constructs-DataType", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("DirectedRelationship", "Core-Constructs-DirectedRelationship", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Element", "Core-Constructs-Element", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ElementImport", "Core-Constructs-ElementImport", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Enumeration", "Core-Constructs-Enumeration", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("EnumerationLiteral", "Core-Constructs-EnumerationLiteral", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Expression", "Core-Constructs-Expression", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Feature", "Core-Constructs-Feature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("MultiplicityElement", "Core-Constructs-MultiplicityElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("NamedElement", "Core-Constructs-NamedElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Namespace", "Core-Constructs-Namespace", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("OpaqueExpression", "Core-Constructs-OpaqueExpression", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Operation", "Core-Constructs-Operation", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Package", "Core-Constructs-Package", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PackageImport", "Core-Constructs-PackageImport", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PackageMerge", "Core-Constructs-PackageMerge", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PackageableElement", "Core-Constructs-PackageableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Parameter", "Core-Constructs-Parameter", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PrimitiveType", "Core-Constructs-PrimitiveType", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Property", "Core-Constructs-Property", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("RedefinableElement", "Core-Constructs-RedefinableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Relationship", "Core-Constructs-Relationship", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("StructuralFeature", "Core-Constructs-StructuralFeature", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Type", "Core-Constructs-Type", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("TypedElement", "Core-Constructs-TypedElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ValueSpecification", "Core-Constructs-ValueSpecification", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Core.Constructs", this);
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Class", "Profiles-Class", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Profiles", this);
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Extension", "Profiles-Extension", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Profiles", this);
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ExtensionEnd", "Profiles-ExtensionEnd", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Profiles", this);
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Image", "Profiles-Image", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Profiles", this);
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("NamedElement", "Profiles-NamedElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Profiles", this);
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Package", "Profiles-Package", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Profiles", this);
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("PackageableElement", "Profiles-PackageableElement", pkg);
        clss.isAbstract = true;
        clss.isAbstract = true;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Profiles", this);
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Profile", "Profiles-Profile", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Profiles", this);
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("ProfileApplication", "Profiles-ProfileApplication", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Profiles", this);
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        clss = this.factory.createClass("Stereotype", "Profiles-Stereotype", pkg);
        clss.isAbstract = false;
        clss.isAbstract = false;
        this.mapping.mapClass(clss, "InfrastructureLibrary.Profiles", this);
    }

    private void constructEnumerations() {
        Enumeration enumeration = null;
        EnumerationLiteral literal = null;
        enumeration = this.factory.createEnumeration("VisibilityKind", "Core-Abstractions-Visibilities-VisibilityKind");
        this.mapping.mapEnumeration(enumeration, "InfrastructureLibrary.Core.Abstractions.Visibilities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "public", "Core-Abstractions-Visibilities-VisibilityKind-public");
        this.mapping.mapEnumerationLiteral(literal, "InfrastructureLibrary.Core.Abstractions.Visibilities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "private", "Core-Abstractions-Visibilities-VisibilityKind-private");
        this.mapping.mapEnumerationLiteral(literal, "InfrastructureLibrary.Core.Abstractions.Visibilities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "protected", "Core-Abstractions-Visibilities-VisibilityKind-protected");
        this.mapping.mapEnumerationLiteral(literal, "InfrastructureLibrary.Core.Abstractions.Visibilities", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "package", "Core-Abstractions-Visibilities-VisibilityKind-package");
        this.mapping.mapEnumerationLiteral(literal, "InfrastructureLibrary.Core.Abstractions.Visibilities", this);
        enumeration = this.factory.createEnumeration("ParameterDirectionKind", "Core-Constructs-ParameterDirectionKind");
        this.mapping.mapEnumeration(enumeration, "InfrastructureLibrary.Core.Constructs", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "in", "Core-Constructs-ParameterDirectionKind-in");
        this.mapping.mapEnumerationLiteral(literal, "InfrastructureLibrary.Core.Constructs", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "inout", "Core-Constructs-ParameterDirectionKind-inout");
        this.mapping.mapEnumerationLiteral(literal, "InfrastructureLibrary.Core.Constructs", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "out", "Core-Constructs-ParameterDirectionKind-out");
        this.mapping.mapEnumerationLiteral(literal, "InfrastructureLibrary.Core.Constructs", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "return", "Core-Constructs-ParameterDirectionKind-return");
        this.mapping.mapEnumerationLiteral(literal, "InfrastructureLibrary.Core.Constructs", this);
        enumeration = this.factory.createEnumeration("VisibilityKind", "Core-Constructs-VisibilityKind");
        this.mapping.mapEnumeration(enumeration, "InfrastructureLibrary.Core.Constructs", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "public", "Core-Constructs-VisibilityKind-public");
        this.mapping.mapEnumerationLiteral(literal, "InfrastructureLibrary.Core.Constructs", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "private", "Core-Constructs-VisibilityKind-private");
        this.mapping.mapEnumerationLiteral(literal, "InfrastructureLibrary.Core.Constructs", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "protected", "Core-Constructs-VisibilityKind-protected");
        this.mapping.mapEnumerationLiteral(literal, "InfrastructureLibrary.Core.Constructs", this);
        literal = this.factory.createEnumerationLiteral(enumeration, "package", "Core-Constructs-VisibilityKind-package");
        this.mapping.mapEnumerationLiteral(literal, "InfrastructureLibrary.Core.Constructs", this);
    }

    private void constructProperties() {
        Class_ clss = null;
        Property prop = null;
        clss = (Class_)this.model.getElementById("Core-Abstractions-BehavioralFeatures-BehavioralFeature").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Abstractions-BehavioralFeatures-Parameter").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Abstractions-Changeabilities-StructuralFeature").getDelegate();
        prop = this.factory.createProperty(clss, "isReadOnly", "Core-Abstractions-Changeabilities-StructuralFeature-isReadOnly", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Abstractions-Changeabilities-StructuralFeature-isReadOnly-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Classifiers-Classifier").getDelegate();
        prop = this.factory.createProperty(clss, "feature", "Core-Abstractions-Classifiers-Classifier-feature", "Core-Abstractions-Classifiers-Feature", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Classifiers-Feature").getDelegate();
        prop = this.factory.createProperty(clss, "featuringClassifier", "Core-Abstractions-Classifiers-Feature-featuringClassifier", "Core-Abstractions-Classifiers-Classifier", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Comments-Comment").getDelegate();
        prop = this.factory.createProperty(clss, "annotatedElement", "Core-Abstractions-Comments-Comment-annotatedElement", "Core-Abstractions-Ownerships-Element", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "body", "Core-Abstractions-Comments-Comment-body", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Constraints-Constraint").getDelegate();
        prop = this.factory.createProperty(clss, "constrainedElement", "Core-Abstractions-Constraints-Constraint-constrainedElement", "Core-Abstractions-Ownerships-Element", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "context", "Core-Abstractions-Constraints-Constraint-context", "Core-Abstractions-Constraints-Namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "specification", "Core-Abstractions-Constraints-Constraint-specification", "Core-Abstractions-Expressions-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Constraints-NamedElement").getDelegate();
        prop = this.factory.createProperty(clss, "namespace", "Core-Abstractions-Constraints-NamedElement-namespace", "Core-Abstractions-Constraints-Namespace", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Constraints-Namespace").getDelegate();
        prop = this.factory.createProperty(clss, "member", "Core-Abstractions-Constraints-Namespace-member", "Core-Abstractions-Constraints-NamedElement", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedMember", "Core-Abstractions-Constraints-Namespace-ownedMember", "Core-Abstractions-Constraints-NamedElement", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedRule", "Core-Abstractions-Constraints-Namespace-ownedRule", "Core-Abstractions-Constraints-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Elements-Element").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Abstractions-Expressions-Expression").getDelegate();
        prop = this.factory.createProperty(clss, "operand", "Core-Abstractions-Expressions-Expression-operand", "Core-Abstractions-Expressions-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "symbol", "Core-Abstractions-Expressions-Expression-symbol", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Expressions-OpaqueExpression").getDelegate();
        prop = this.factory.createProperty(clss, "body", "Core-Abstractions-Expressions-OpaqueExpression-body", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "language", "Core-Abstractions-Expressions-OpaqueExpression-language", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Expressions-ValueSpecification").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Abstractions-Generalizations-Classifier").getDelegate();
        prop = this.factory.createProperty(clss, "general", "Core-Abstractions-Generalizations-Classifier-general", "Core-Abstractions-Generalizations-Classifier", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "generalization", "Core-Abstractions-Generalizations-Classifier-generalization", "Core-Abstractions-Generalizations-Generalization", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Generalizations-Generalization").getDelegate();
        prop = this.factory.createProperty(clss, "general", "Core-Abstractions-Generalizations-Generalization-general", "Core-Abstractions-Generalizations-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "specific", "Core-Abstractions-Generalizations-Generalization-specific", "Core-Abstractions-Generalizations-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Instances-InstanceSpecification").getDelegate();
        prop = this.factory.createProperty(clss, "classifier", "Core-Abstractions-Instances-InstanceSpecification-classifier", "Core-Abstractions-Classifiers-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "slot", "Core-Abstractions-Instances-InstanceSpecification-slot", "Core-Abstractions-Instances-Slot", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "specification", "Core-Abstractions-Instances-InstanceSpecification-specification", "Core-Abstractions-Expressions-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Instances-InstanceValue").getDelegate();
        prop = this.factory.createProperty(clss, "instance", "Core-Abstractions-Instances-InstanceValue-instance", "Core-Abstractions-Instances-InstanceSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Instances-Slot").getDelegate();
        prop = this.factory.createProperty(clss, "definingFeature", "Core-Abstractions-Instances-Slot-definingFeature", "Core-Abstractions-StructuralFeatures-StructuralFeature", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "owningInstance", "Core-Abstractions-Instances-Slot-owningInstance", "Core-Abstractions-Instances-InstanceSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "value", "Core-Abstractions-Instances-Slot-value", "Core-Abstractions-Expressions-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Literals-LiteralBoolean").getDelegate();
        prop = this.factory.createProperty(clss, "value", "Core-Abstractions-Literals-LiteralBoolean-value", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Abstractions-Literals-LiteralBoolean-value-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Literals-LiteralInteger").getDelegate();
        prop = this.factory.createProperty(clss, "value", "Core-Abstractions-Literals-LiteralInteger-value", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Integer", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Integer(0), "", "Core-Abstractions-Literals-LiteralInteger-value-_defaultValue", "uml:LiteralInteger", "");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Literals-LiteralNull").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Abstractions-Literals-LiteralReal").getDelegate();
        prop = this.factory.createProperty(clss, "value", "Core-Abstractions-Literals-LiteralReal-value", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Real", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Literals-LiteralSpecification").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Abstractions-Literals-LiteralString").getDelegate();
        prop = this.factory.createProperty(clss, "value", "Core-Abstractions-Literals-LiteralString-value", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Literals-LiteralUnlimitedNatural").getDelegate();
        prop = this.factory.createProperty(clss, "value", "Core-Abstractions-Literals-LiteralUnlimitedNatural-value", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#UnlimitedNatural", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "", "Core-Abstractions-Literals-LiteralUnlimitedNatural-value-_defaultValue", "uml:LiteralUnlimitedNatural", "");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Multiplicities-MultiplicityElement").getDelegate();
        prop = this.factory.createProperty(clss, "isOrdered", "Core-Abstractions-Multiplicities-MultiplicityElement-isOrdered", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Abstractions-Multiplicities-MultiplicityElement-isOrdered-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isUnique", "Core-Abstractions-Multiplicities-MultiplicityElement-isUnique", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "Core-Abstractions-Multiplicities-MultiplicityElement-isUnique-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "lower", "Core-Abstractions-Multiplicities-MultiplicityElement-lower", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Integer", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Integer(1), "", "Core-Abstractions-Multiplicities-MultiplicityElement-lower-_defaultValue", "uml:LiteralInteger", "");
        prop = this.factory.createProperty(clss, "upper", "Core-Abstractions-Multiplicities-MultiplicityElement-upper", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#UnlimitedNatural", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String("1"), "", "Core-Abstractions-Multiplicities-MultiplicityElement-upper-_defaultValue", "uml:LiteralUnlimitedNatural", "");
        clss = (Class_)this.model.getElementById("Core-Abstractions-MultiplicityExpressions-MultiplicityElement").getDelegate();
        prop = this.factory.createProperty(clss, "lower", "Core-Abstractions-MultiplicityExpressions-MultiplicityElement-lower", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Integer", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Integer(1), "", "Core-Abstractions-MultiplicityExpressions-MultiplicityElement-lower-_defaultValue", "uml:LiteralInteger", "");
        prop = this.factory.createProperty(clss, "lowerValue", "Core-Abstractions-MultiplicityExpressions-MultiplicityElement-lowerValue", "Core-Abstractions-Expressions-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "upper", "Core-Abstractions-MultiplicityExpressions-MultiplicityElement-upper", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#UnlimitedNatural", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String("1"), "", "Core-Abstractions-MultiplicityExpressions-MultiplicityElement-upper-_defaultValue", "uml:LiteralUnlimitedNatural", "");
        prop = this.factory.createProperty(clss, "upperValue", "Core-Abstractions-MultiplicityExpressions-MultiplicityElement-upperValue", "Core-Abstractions-Expressions-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Namespaces-NamedElement").getDelegate();
        prop = this.factory.createProperty(clss, "name", "Core-Abstractions-Namespaces-NamedElement-name", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "namespace", "Core-Abstractions-Namespaces-NamedElement-namespace", "Core-Abstractions-Namespaces-Namespace", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "qualifiedName", "Core-Abstractions-Namespaces-NamedElement-qualifiedName", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Namespaces-Namespace").getDelegate();
        prop = this.factory.createProperty(clss, "member", "Core-Abstractions-Namespaces-Namespace-member", "Core-Abstractions-Namespaces-NamedElement", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedMember", "Core-Abstractions-Namespaces-Namespace-ownedMember", "Core-Abstractions-Namespaces-NamedElement", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Ownerships-Element").getDelegate();
        prop = this.factory.createProperty(clss, "ownedComment", "Core-Abstractions-Ownerships-Element-ownedComment", "Core-Abstractions-Comments-Comment", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedElement", "Core-Abstractions-Ownerships-Element-ownedElement", "Core-Abstractions-Ownerships-Element", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "owner", "Core-Abstractions-Ownerships-Element-owner", "Core-Abstractions-Ownerships-Element", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Redefinitions-RedefinableElement").getDelegate();
        prop = this.factory.createProperty(clss, "redefinedElement", "Core-Abstractions-Redefinitions-RedefinableElement-redefinedElement", "Core-Abstractions-Redefinitions-RedefinableElement", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinitionContext", "Core-Abstractions-Redefinitions-RedefinableElement-redefinitionContext", "Core-Abstractions-Super-Classifier", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Relationships-DirectedRelationship").getDelegate();
        prop = this.factory.createProperty(clss, "source", "Core-Abstractions-Relationships-DirectedRelationship-source", "Core-Abstractions-Ownerships-Element", "", true, true, true);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "target", "Core-Abstractions-Relationships-DirectedRelationship-target", "Core-Abstractions-Ownerships-Element", "", true, true, true);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Relationships-Relationship").getDelegate();
        prop = this.factory.createProperty(clss, "relatedElement", "Core-Abstractions-Relationships-Relationship-relatedElement", "Core-Abstractions-Ownerships-Element", "", true, true, true);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-StructuralFeatures-StructuralFeature").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Abstractions-Super-Classifier").getDelegate();
        prop = this.factory.createProperty(clss, "general", "Core-Abstractions-Super-Classifier-general", "Core-Abstractions-Super-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inheritedMember", "Core-Abstractions-Super-Classifier-inheritedMember", "Core-Abstractions-Namespaces-NamedElement", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isAbstract", "Core-Abstractions-Super-Classifier-isAbstract", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Abstractions-Super-Classifier-isAbstract-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Core-Abstractions-TypedElements-Type").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Abstractions-TypedElements-TypedElement").getDelegate();
        prop = this.factory.createProperty(clss, "type", "Core-Abstractions-TypedElements-TypedElement-type", "Core-Abstractions-TypedElements-Type", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Abstractions-Visibilities-NamedElement").getDelegate();
        prop = this.factory.createProperty(clss, "visibility", "Core-Abstractions-Visibilities-NamedElement-visibility", "Core-Abstractions-Visibilities-VisibilityKind", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Basic-Class").getDelegate();
        prop = this.factory.createProperty(clss, "isAbstract", "Core-Basic-Class-isAbstract", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Basic-Class-isAbstract-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "ownedAttribute", "Core-Basic-Class-ownedAttribute", "Core-Basic-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedOperation", "Core-Basic-Class-ownedOperation", "Core-Basic-Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "superClass", "Core-Basic-Class-superClass", "Core-Basic-Class", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Basic-Comment").getDelegate();
        prop = this.factory.createProperty(clss, "annotatedElement", "Core-Basic-Comment-annotatedElement", "Core-Basic-Element", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "body", "Core-Basic-Comment-body", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Basic-DataType").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Basic-Element").getDelegate();
        prop = this.factory.createProperty(clss, "ownedComment", "Core-Basic-Element-ownedComment", "Core-Basic-Comment", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Basic-Enumeration").getDelegate();
        prop = this.factory.createProperty(clss, "ownedLiteral", "Core-Basic-Enumeration-ownedLiteral", "Core-Basic-EnumerationLiteral", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Basic-EnumerationLiteral").getDelegate();
        prop = this.factory.createProperty(clss, "enumeration", "Core-Basic-EnumerationLiteral-enumeration", "Core-Basic-Enumeration", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Basic-MultiplicityElement").getDelegate();
        prop = this.factory.createProperty(clss, "isOrdered", "Core-Basic-MultiplicityElement-isOrdered", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Basic-MultiplicityElement-isOrdered-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isUnique", "Core-Basic-MultiplicityElement-isUnique", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "Core-Basic-MultiplicityElement-isUnique-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "lower", "Core-Basic-MultiplicityElement-lower", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Integer", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Integer(1), "", "Core-Basic-MultiplicityElement-lower-_defaultValue", "uml:LiteralInteger", "");
        prop = this.factory.createProperty(clss, "upper", "Core-Basic-MultiplicityElement-upper", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#UnlimitedNatural", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String("1"), "", "Core-Basic-MultiplicityElement-upper-_defaultValue", "uml:LiteralUnlimitedNatural", "");
        clss = (Class_)this.model.getElementById("Core-Basic-NamedElement").getDelegate();
        prop = this.factory.createProperty(clss, "name", "Core-Basic-NamedElement-name", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Basic-Operation").getDelegate();
        prop = this.factory.createProperty(clss, "class", "Core-Basic-Operation-class", "Core-Basic-Class", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedParameter", "Core-Basic-Operation-ownedParameter", "Core-Basic-Parameter", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "raisedException", "Core-Basic-Operation-raisedException", "Core-Basic-Type", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Basic-Package").getDelegate();
        prop = this.factory.createProperty(clss, "nestedPackage", "Core-Basic-Package-nestedPackage", "Core-Basic-Package", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "nestingPackage", "Core-Basic-Package-nestingPackage", "Core-Basic-Package", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedType", "Core-Basic-Package-ownedType", "Core-Basic-Type", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Basic-Parameter").getDelegate();
        prop = this.factory.createProperty(clss, "operation", "Core-Basic-Parameter-operation", "Core-Basic-Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Basic-PrimitiveType").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Basic-Property").getDelegate();
        prop = this.factory.createProperty(clss, "class", "Core-Basic-Property-class", "Core-Basic-Class", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "default", "Core-Basic-Property-default", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isComposite", "Core-Basic-Property-isComposite", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Basic-Property-isComposite-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isDerived", "Core-Basic-Property-isDerived", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Basic-Property-isDerived-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isID", "Core-Basic-Property-isID", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Basic-Property-isID-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isReadOnly", "Core-Basic-Property-isReadOnly", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Basic-Property-isReadOnly-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "opposite", "Core-Basic-Property-opposite", "Core-Basic-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Basic-Type").getDelegate();
        prop = this.factory.createProperty(clss, "package", "Core-Basic-Type-package", "Core-Basic-Package", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Basic-TypedElement").getDelegate();
        prop = this.factory.createProperty(clss, "type", "Core-Basic-TypedElement-type", "Core-Basic-Type", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-Association").getDelegate();
        prop = this.factory.createProperty(clss, "endType", "Core-Constructs-Association-endType", "Core-Constructs-Type", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isDerived", "Core-Constructs-Association-isDerived", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Constructs-Association-isDerived-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "memberEnd", "Core-Constructs-Association-memberEnd", "Core-Constructs-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "2");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "navigableOwnedEnd", "Core-Constructs-Association-navigableOwnedEnd", "Core-Constructs-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedEnd", "Core-Constructs-Association-ownedEnd", "Core-Constructs-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-BehavioralFeature").getDelegate();
        prop = this.factory.createProperty(clss, "ownedParameter", "Core-Constructs-BehavioralFeature-ownedParameter", "Core-Constructs-Parameter", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "raisedException", "Core-Constructs-BehavioralFeature-raisedException", "Core-Constructs-Type", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-Class").getDelegate();
        prop = this.factory.createProperty(clss, "isAbstract", "Core-Constructs-Class-isAbstract", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Constructs-Class-isAbstract-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "ownedAttribute", "Core-Constructs-Class-ownedAttribute", "Core-Constructs-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedOperation", "Core-Constructs-Class-ownedOperation", "Core-Constructs-Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "superClass", "Core-Constructs-Class-superClass", "Core-Constructs-Class", "Core-Constructs-Classifier-general", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-Classifier").getDelegate();
        prop = this.factory.createProperty(clss, "attribute", "Core-Constructs-Classifier-attribute", "Core-Constructs-Property", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "feature", "Core-Constructs-Classifier-feature", "Core-Constructs-Feature", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "general", "Core-Constructs-Classifier-general", "Core-Constructs-Classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "inheritedMember", "Core-Constructs-Classifier-inheritedMember", "Core-Constructs-NamedElement", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isFinalSpecialization", "Core-Constructs-Classifier-isFinalSpecialization", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Constructs-Classifier-isFinalSpecialization-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Core-Constructs-Comment").getDelegate();
        prop = this.factory.createProperty(clss, "annotatedElement", "Core-Constructs-Comment-annotatedElement", "Core-Constructs-Element", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "body", "Core-Constructs-Comment-body", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-Constraint").getDelegate();
        prop = this.factory.createProperty(clss, "constrainedElement", "Core-Constructs-Constraint-constrainedElement", "Core-Constructs-Element", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "context", "Core-Constructs-Constraint-context", "Core-Constructs-Namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "specification", "Core-Constructs-Constraint-specification", "Core-Constructs-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-DataType").getDelegate();
        prop = this.factory.createProperty(clss, "ownedAttribute", "Core-Constructs-DataType-ownedAttribute", "Core-Constructs-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedOperation", "Core-Constructs-DataType-ownedOperation", "Core-Constructs-Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-DirectedRelationship").getDelegate();
        prop = this.factory.createProperty(clss, "source", "Core-Constructs-DirectedRelationship-source", "Core-Constructs-Element", "", true, true, true);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "target", "Core-Constructs-DirectedRelationship-target", "Core-Constructs-Element", "", true, true, true);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-Element").getDelegate();
        prop = this.factory.createProperty(clss, "ownedComment", "Core-Constructs-Element-ownedComment", "Core-Constructs-Comment", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedElement", "Core-Constructs-Element-ownedElement", "Core-Constructs-Element", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "owner", "Core-Constructs-Element-owner", "Core-Constructs-Element", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-ElementImport").getDelegate();
        prop = this.factory.createProperty(clss, "alias", "Core-Constructs-ElementImport-alias", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "importedElement", "Core-Constructs-ElementImport-importedElement", "Core-Constructs-PackageableElement", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "importingNamespace", "Core-Constructs-ElementImport-importingNamespace", "Core-Constructs-Namespace", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "visibility", "Core-Constructs-ElementImport-visibility", "Core-Constructs-VisibilityKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "Core-Constructs-VisibilityKind-public", "Core-Constructs-ElementImport-visibility-_defaultValue", "uml:InstanceValue", "Core-Constructs-VisibilityKind");
        clss = (Class_)this.model.getElementById("Core-Constructs-Enumeration").getDelegate();
        prop = this.factory.createProperty(clss, "ownedLiteral", "Core-Constructs-Enumeration-ownedLiteral", "Core-Constructs-EnumerationLiteral", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-EnumerationLiteral").getDelegate();
        prop = this.factory.createProperty(clss, "enumeration", "Core-Constructs-EnumerationLiteral-enumeration", "Core-Constructs-Enumeration", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-Expression").getDelegate();
        prop = this.factory.createProperty(clss, "operand", "Core-Constructs-Expression-operand", "Core-Constructs-ValueSpecification", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-Feature").getDelegate();
        prop = this.factory.createProperty(clss, "featuringClassifier", "Core-Constructs-Feature-featuringClassifier", "Core-Constructs-Classifier", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-MultiplicityElement").getDelegate();
        prop = this.factory.createProperty(clss, "isOrdered", "Core-Constructs-MultiplicityElement-isOrdered", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Constructs-MultiplicityElement-isOrdered-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isUnique", "Core-Constructs-MultiplicityElement-isUnique", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "Core-Constructs-MultiplicityElement-isUnique-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "lower", "Core-Constructs-MultiplicityElement-lower", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Integer", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Integer(1), "", "Core-Constructs-MultiplicityElement-lower-_defaultValue", "uml:LiteralInteger", "");
        prop = this.factory.createProperty(clss, "upper", "Core-Constructs-MultiplicityElement-upper", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#UnlimitedNatural", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String("1"), "", "Core-Constructs-MultiplicityElement-upper-_defaultValue", "uml:LiteralUnlimitedNatural", "");
        clss = (Class_)this.model.getElementById("Core-Constructs-NamedElement").getDelegate();
        prop = this.factory.createProperty(clss, "name", "Core-Constructs-NamedElement-name", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "namespace", "Core-Constructs-NamedElement-namespace", "Core-Constructs-Namespace", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "qualifiedName", "Core-Constructs-NamedElement-qualifiedName", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "visibility", "Core-Constructs-NamedElement-visibility", "Core-Constructs-VisibilityKind", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-Namespace").getDelegate();
        prop = this.factory.createProperty(clss, "elementImport", "Core-Constructs-Namespace-elementImport", "Core-Constructs-ElementImport", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "importedMember", "Core-Constructs-Namespace-importedMember", "Core-Constructs-PackageableElement", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "member", "Core-Constructs-Namespace-member", "Core-Constructs-NamedElement", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedMember", "Core-Constructs-Namespace-ownedMember", "Core-Constructs-NamedElement", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedRule", "Core-Constructs-Namespace-ownedRule", "Core-Constructs-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "packageImport", "Core-Constructs-Namespace-packageImport", "Core-Constructs-PackageImport", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-OpaqueExpression").getDelegate();
        prop = this.factory.createProperty(clss, "body", "Core-Constructs-OpaqueExpression-body", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "language", "Core-Constructs-OpaqueExpression-language", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-Operation").getDelegate();
        prop = this.factory.createProperty(clss, "bodyCondition", "Core-Constructs-Operation-bodyCondition", "Core-Constructs-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "class", "Core-Constructs-Operation-class", "Core-Constructs-Class", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "datatype", "Core-Constructs-Operation-datatype", "Core-Constructs-DataType", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isOrdered", "Core-Constructs-Operation-isOrdered", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Constructs-Operation-isOrdered-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isQuery", "Core-Constructs-Operation-isQuery", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Constructs-Operation-isQuery-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isUnique", "Core-Constructs-Operation-isUnique", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(true), "", "Core-Constructs-Operation-isUnique-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "lower", "Core-Constructs-Operation-lower", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Integer", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Integer(1), "", "Core-Constructs-Operation-lower-_defaultValue", "uml:LiteralInteger", "");
        prop = this.factory.createProperty(clss, "ownedParameter", "Core-Constructs-Operation-ownedParameter", "Core-Constructs-Parameter", "Core-Constructs-BehavioralFeature-ownedParameter", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "postcondition", "Core-Constructs-Operation-postcondition", "Core-Constructs-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "precondition", "Core-Constructs-Operation-precondition", "Core-Constructs-Constraint", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "raisedException", "Core-Constructs-Operation-raisedException", "Core-Constructs-Type", "Core-Constructs-BehavioralFeature-raisedException", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedOperation", "Core-Constructs-Operation-redefinedOperation", "Core-Constructs-Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "type", "Core-Constructs-Operation-type", "Core-Constructs-Type", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "upper", "Core-Constructs-Operation-upper", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#UnlimitedNatural", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String("1"), "", "Core-Constructs-Operation-upper-_defaultValue", "uml:LiteralUnlimitedNatural", "");
        clss = (Class_)this.model.getElementById("Core-Constructs-Package").getDelegate();
        prop = this.factory.createProperty(clss, "URI", "Core-Constructs-Package-URI", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "nestedPackage", "Core-Constructs-Package-nestedPackage", "Core-Constructs-Package", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "nestingPackage", "Core-Constructs-Package-nestingPackage", "Core-Constructs-Package", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedType", "Core-Constructs-Package-ownedType", "Core-Constructs-Type", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "packageMerge", "Core-Constructs-Package-packageMerge", "Core-Constructs-PackageMerge", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "packagedElement", "Core-Constructs-Package-packagedElement", "Core-Constructs-PackageableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-PackageImport").getDelegate();
        prop = this.factory.createProperty(clss, "importedPackage", "Core-Constructs-PackageImport-importedPackage", "Core-Constructs-Package", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "importingNamespace", "Core-Constructs-PackageImport-importingNamespace", "Core-Constructs-Namespace", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "visibility", "Core-Constructs-PackageImport-visibility", "Core-Constructs-VisibilityKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "Core-Constructs-VisibilityKind-public", "Core-Constructs-PackageImport-visibility-_defaultValue", "uml:InstanceValue", "Core-Constructs-VisibilityKind");
        clss = (Class_)this.model.getElementById("Core-Constructs-PackageMerge").getDelegate();
        prop = this.factory.createProperty(clss, "mergedPackage", "Core-Constructs-PackageMerge-mergedPackage", "Core-Constructs-Package", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "receivingPackage", "Core-Constructs-PackageMerge-receivingPackage", "Core-Constructs-Package", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-PackageableElement").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Constructs-Parameter").getDelegate();
        prop = this.factory.createProperty(clss, "default", "Core-Constructs-Parameter-default", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "direction", "Core-Constructs-Parameter-direction", "Core-Constructs-ParameterDirectionKind", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new String(""), "Core-Constructs-ParameterDirectionKind-in", "Core-Constructs-Parameter-direction-_defaultValue", "uml:InstanceValue", "Core-Constructs-ParameterDirectionKind");
        prop = this.factory.createProperty(clss, "operation", "Core-Constructs-Parameter-operation", "Core-Constructs-Operation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-PrimitiveType").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Constructs-Property").getDelegate();
        prop = this.factory.createProperty(clss, "association", "Core-Constructs-Property-association", "Core-Constructs-Association", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "class", "Core-Constructs-Property-class", "Core-Constructs-Class", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "datatype", "Core-Constructs-Property-datatype", "Core-Constructs-DataType", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "default", "Core-Constructs-Property-default", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isComposite", "Core-Constructs-Property-isComposite", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Constructs-Property-isComposite-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isDerived", "Core-Constructs-Property-isDerived", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Constructs-Property-isDerived-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isDerivedUnion", "Core-Constructs-Property-isDerivedUnion", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Constructs-Property-isDerivedUnion-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isID", "Core-Constructs-Property-isID", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Constructs-Property-isID-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "isReadOnly", "Core-Constructs-Property-isReadOnly", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Constructs-Property-isReadOnly-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "opposite", "Core-Constructs-Property-opposite", "Core-Constructs-Property", "", false, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "owningAssociation", "Core-Constructs-Property-owningAssociation", "Core-Constructs-Association", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinedProperty", "Core-Constructs-Property-redefinedProperty", "Core-Constructs-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "subsettedProperty", "Core-Constructs-Property-subsettedProperty", "Core-Constructs-Property", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-RedefinableElement").getDelegate();
        prop = this.factory.createProperty(clss, "isLeaf", "Core-Constructs-RedefinableElement-isLeaf", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Core-Constructs-RedefinableElement-isLeaf-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "redefinedElement", "Core-Constructs-RedefinableElement-redefinedElement", "Core-Constructs-RedefinableElement", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "redefinitionContext", "Core-Constructs-RedefinableElement-redefinitionContext", "Core-Constructs-Classifier", "", true, true, true);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-Relationship").getDelegate();
        prop = this.factory.createProperty(clss, "relatedElement", "Core-Constructs-Relationship-relatedElement", "Core-Constructs-Element", "", true, true, true);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-StructuralFeature").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Constructs-Type").getDelegate();
        prop = this.factory.createProperty(clss, "package", "Core-Constructs-Type-package", "Core-Constructs-Package", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-TypedElement").getDelegate();
        prop = this.factory.createProperty(clss, "type", "Core-Constructs-TypedElement-type", "Core-Constructs-Type", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Core-Constructs-ValueSpecification").getDelegate();
        clss = (Class_)this.model.getElementById("Profiles-Class").getDelegate();
        prop = this.factory.createProperty(clss, "extension", "Profiles-Class-extension", "Profiles-Extension", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Profiles-Extension").getDelegate();
        prop = this.factory.createProperty(clss, "isRequired", "Profiles-Extension-isRequired", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Profiles-Extension-isRequired-_defaultValue", "uml:LiteralBoolean", "");
        prop = this.factory.createProperty(clss, "metaclass", "Profiles-Extension-metaclass", "Profiles-Class", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "ownedEnd", "Profiles-Extension-ownedEnd", "Profiles-ExtensionEnd", "Core-Constructs-Association-ownedEnd", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Profiles-ExtensionEnd").getDelegate();
        prop = this.factory.createProperty(clss, "lower", "Profiles-ExtensionEnd-lower", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Integer", "Core-Constructs-MultiplicityElement-lower", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Integer(0), "", "Profiles-ExtensionEnd-lower-_defaultValue", "uml:LiteralInteger", "");
        prop = this.factory.createProperty(clss, "type", "Profiles-ExtensionEnd-type", "Profiles-Stereotype", "Core-Constructs-TypedElement-type", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Profiles-Image").getDelegate();
        prop = this.factory.createProperty(clss, "content", "Profiles-Image-content", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "format", "Profiles-Image-format", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "location", "Profiles-Image-location", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#String", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Profiles-NamedElement").getDelegate();
        clss = (Class_)this.model.getElementById("Profiles-Package").getDelegate();
        prop = this.factory.createProperty(clss, "ownedStereotype", "Profiles-Package-ownedStereotype", "Profiles-Stereotype", "", true, true, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "packagedElement", "Profiles-Package-packagedElement", "Profiles-PackageableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "profileApplication", "Profiles-Package-profileApplication", "Profiles-ProfileApplication", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Profiles-PackageableElement").getDelegate();
        clss = (Class_)this.model.getElementById("Profiles-Profile").getDelegate();
        prop = this.factory.createProperty(clss, "metaclassReference", "Profiles-Profile-metaclassReference", "Core-Constructs-ElementImport", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "metamodelReference", "Profiles-Profile-metamodelReference", "Core-Constructs-PackageImport", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        clss = (Class_)this.model.getElementById("Profiles-ProfileApplication").getDelegate();
        prop = this.factory.createProperty(clss, "appliedProfile", "Profiles-ProfileApplication-appliedProfile", "Profiles-Profile", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "applyingPackage", "Profiles-ProfileApplication-applyingPackage", "Profiles-Package", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "isStrict", "Profiles-ProfileApplication-isStrict", "http://www.omg.org/spec/UML/20110701/PrimitiveTypes.xmi#Boolean", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
        this.factory.createDefault(prop, new Boolean(false), "", "Profiles-ProfileApplication-isStrict-_defaultValue", "uml:LiteralBoolean", "");
        clss = (Class_)this.model.getElementById("Profiles-Stereotype").getDelegate();
        prop = this.factory.createProperty(clss, "icon", "Profiles-Stereotype-icon", "Profiles-Image", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(clss, prop, this);
        prop = this.factory.createProperty(clss, "profile", "Profiles-Stereotype-profile", "Profiles-Profile", "", true, true, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(clss, prop, this);
    }

    private void constructGeneralizations() {
        Class_ clss = null;
        clss = (Class_)this.model.getElementById("Core-Abstractions-BehavioralFeatures-BehavioralFeature").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Classifiers-Feature");
        this.factory.createGeneralization(clss, "Core-Abstractions-Namespaces-Namespace");
        clss = (Class_)this.model.getElementById("Core-Abstractions-BehavioralFeatures-Parameter").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-TypedElements-TypedElement");
        this.factory.createGeneralization(clss, "Core-Abstractions-Namespaces-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Changeabilities-StructuralFeature").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Abstractions-Classifiers-Classifier").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Namespaces-Namespace");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Classifiers-Feature").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Namespaces-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Comments-Comment").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Ownerships-Element");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Constraints-Constraint").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Constraints-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Constraints-NamedElement").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Ownerships-Element");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Constraints-Namespace").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Constraints-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Elements-Element").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Abstractions-Expressions-Expression").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Expressions-ValueSpecification");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Expressions-OpaqueExpression").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Expressions-ValueSpecification");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Expressions-ValueSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Ownerships-Element");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Generalizations-Classifier").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-TypedElements-Type");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Generalizations-Generalization").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Relationships-DirectedRelationship");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Instances-InstanceSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Namespaces-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Instances-InstanceValue").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Expressions-ValueSpecification");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Instances-Slot").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Ownerships-Element");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Literals-LiteralBoolean").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Literals-LiteralSpecification");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Literals-LiteralInteger").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Literals-LiteralSpecification");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Literals-LiteralNull").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Literals-LiteralSpecification");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Literals-LiteralReal").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Literals-LiteralSpecification");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Literals-LiteralSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Expressions-ValueSpecification");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Literals-LiteralString").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Literals-LiteralSpecification");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Literals-LiteralUnlimitedNatural").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Literals-LiteralSpecification");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Multiplicities-MultiplicityElement").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Elements-Element");
        clss = (Class_)this.model.getElementById("Core-Abstractions-MultiplicityExpressions-MultiplicityElement").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Ownerships-Element");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Namespaces-NamedElement").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Ownerships-Element");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Namespaces-Namespace").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Namespaces-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Ownerships-Element").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Abstractions-Redefinitions-RedefinableElement").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Namespaces-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Relationships-DirectedRelationship").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Relationships-Relationship");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Relationships-Relationship").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Ownerships-Element");
        clss = (Class_)this.model.getElementById("Core-Abstractions-StructuralFeatures-StructuralFeature").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-TypedElements-TypedElement");
        this.factory.createGeneralization(clss, "Core-Abstractions-Classifiers-Feature");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Super-Classifier").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Namespaces-Namespace");
        clss = (Class_)this.model.getElementById("Core-Abstractions-TypedElements-Type").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Namespaces-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Abstractions-TypedElements-TypedElement").getDelegate();
        this.factory.createGeneralization(clss, "Core-Abstractions-Namespaces-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Abstractions-Visibilities-NamedElement").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Basic-Class").getDelegate();
        this.factory.createGeneralization(clss, "Core-Basic-Type");
        clss = (Class_)this.model.getElementById("Core-Basic-Comment").getDelegate();
        this.factory.createGeneralization(clss, "Core-Basic-Element");
        clss = (Class_)this.model.getElementById("Core-Basic-DataType").getDelegate();
        this.factory.createGeneralization(clss, "Core-Basic-Type");
        clss = (Class_)this.model.getElementById("Core-Basic-Element").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Basic-Enumeration").getDelegate();
        this.factory.createGeneralization(clss, "Core-Basic-DataType");
        clss = (Class_)this.model.getElementById("Core-Basic-EnumerationLiteral").getDelegate();
        this.factory.createGeneralization(clss, "Core-Basic-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Basic-MultiplicityElement").getDelegate();
        this.factory.createGeneralization(clss, "Core-Basic-Element");
        clss = (Class_)this.model.getElementById("Core-Basic-NamedElement").getDelegate();
        this.factory.createGeneralization(clss, "Core-Basic-Element");
        clss = (Class_)this.model.getElementById("Core-Basic-Operation").getDelegate();
        this.factory.createGeneralization(clss, "Core-Basic-TypedElement");
        this.factory.createGeneralization(clss, "Core-Basic-MultiplicityElement");
        clss = (Class_)this.model.getElementById("Core-Basic-Package").getDelegate();
        this.factory.createGeneralization(clss, "Core-Basic-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Basic-Parameter").getDelegate();
        this.factory.createGeneralization(clss, "Core-Basic-MultiplicityElement");
        this.factory.createGeneralization(clss, "Core-Basic-TypedElement");
        clss = (Class_)this.model.getElementById("Core-Basic-PrimitiveType").getDelegate();
        this.factory.createGeneralization(clss, "Core-Basic-DataType");
        clss = (Class_)this.model.getElementById("Core-Basic-Property").getDelegate();
        this.factory.createGeneralization(clss, "Core-Basic-TypedElement");
        this.factory.createGeneralization(clss, "Core-Basic-MultiplicityElement");
        clss = (Class_)this.model.getElementById("Core-Basic-Type").getDelegate();
        this.factory.createGeneralization(clss, "Core-Basic-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Basic-TypedElement").getDelegate();
        this.factory.createGeneralization(clss, "Core-Basic-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Constructs-Association").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-Relationship");
        this.factory.createGeneralization(clss, "Core-Constructs-Classifier");
        clss = (Class_)this.model.getElementById("Core-Constructs-BehavioralFeature").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-Namespace");
        this.factory.createGeneralization(clss, "Core-Constructs-Feature");
        clss = (Class_)this.model.getElementById("Core-Constructs-Class").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-Classifier");
        clss = (Class_)this.model.getElementById("Core-Constructs-Classifier").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-Type");
        this.factory.createGeneralization(clss, "Core-Constructs-Namespace");
        clss = (Class_)this.model.getElementById("Core-Constructs-Comment").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-Element");
        clss = (Class_)this.model.getElementById("Core-Constructs-Constraint").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-PackageableElement");
        clss = (Class_)this.model.getElementById("Core-Constructs-DataType").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-Classifier");
        clss = (Class_)this.model.getElementById("Core-Constructs-DirectedRelationship").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-Relationship");
        clss = (Class_)this.model.getElementById("Core-Constructs-Element").getDelegate();
        clss = (Class_)this.model.getElementById("Core-Constructs-ElementImport").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-DirectedRelationship");
        clss = (Class_)this.model.getElementById("Core-Constructs-Enumeration").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-DataType");
        clss = (Class_)this.model.getElementById("Core-Constructs-EnumerationLiteral").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Constructs-Expression").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-ValueSpecification");
        clss = (Class_)this.model.getElementById("Core-Constructs-Feature").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-RedefinableElement");
        clss = (Class_)this.model.getElementById("Core-Constructs-MultiplicityElement").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-Element");
        clss = (Class_)this.model.getElementById("Core-Constructs-NamedElement").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-Element");
        clss = (Class_)this.model.getElementById("Core-Constructs-Namespace").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Constructs-OpaqueExpression").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-ValueSpecification");
        clss = (Class_)this.model.getElementById("Core-Constructs-Operation").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-BehavioralFeature");
        clss = (Class_)this.model.getElementById("Core-Constructs-Package").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-PackageableElement");
        this.factory.createGeneralization(clss, "Core-Constructs-Namespace");
        clss = (Class_)this.model.getElementById("Core-Constructs-PackageImport").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-DirectedRelationship");
        clss = (Class_)this.model.getElementById("Core-Constructs-PackageMerge").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-DirectedRelationship");
        clss = (Class_)this.model.getElementById("Core-Constructs-PackageableElement").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Constructs-Parameter").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-MultiplicityElement");
        this.factory.createGeneralization(clss, "Core-Constructs-TypedElement");
        clss = (Class_)this.model.getElementById("Core-Constructs-PrimitiveType").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-DataType");
        clss = (Class_)this.model.getElementById("Core-Constructs-Property").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-StructuralFeature");
        clss = (Class_)this.model.getElementById("Core-Constructs-RedefinableElement").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Constructs-Relationship").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-Element");
        clss = (Class_)this.model.getElementById("Core-Constructs-StructuralFeature").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-TypedElement");
        this.factory.createGeneralization(clss, "Core-Constructs-MultiplicityElement");
        this.factory.createGeneralization(clss, "Core-Constructs-Feature");
        clss = (Class_)this.model.getElementById("Core-Constructs-Type").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-PackageableElement");
        clss = (Class_)this.model.getElementById("Core-Constructs-TypedElement").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-NamedElement");
        clss = (Class_)this.model.getElementById("Core-Constructs-ValueSpecification").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-TypedElement");
        this.factory.createGeneralization(clss, "Core-Constructs-PackageableElement");
        clss = (Class_)this.model.getElementById("Profiles-Class").getDelegate();
        this.factory.createGeneralization(clss, "Profiles-PackageableElement");
        this.factory.createGeneralization(clss, "Core-Constructs-Classifier");
        clss = (Class_)this.model.getElementById("Profiles-Extension").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-Association");
        clss = (Class_)this.model.getElementById("Profiles-ExtensionEnd").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-Property");
        clss = (Class_)this.model.getElementById("Profiles-Image").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-Element");
        clss = (Class_)this.model.getElementById("Profiles-NamedElement").getDelegate();
        clss = (Class_)this.model.getElementById("Profiles-Package").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-Namespace");
        clss = (Class_)this.model.getElementById("Profiles-PackageableElement").getDelegate();
        clss = (Class_)this.model.getElementById("Profiles-Profile").getDelegate();
        this.factory.createGeneralization(clss, "Profiles-Package");
        this.factory.createGeneralization(clss, "Core-Constructs-Package");
        clss = (Class_)this.model.getElementById("Profiles-ProfileApplication").getDelegate();
        this.factory.createGeneralization(clss, "Core-Constructs-DirectedRelationship");
        clss = (Class_)this.model.getElementById("Profiles-Stereotype").getDelegate();
        this.factory.createGeneralization(clss, "Profiles-Class");
    }

    private void constructAssociations() {
        Package pkg = null;
        String packageId = null;
        Association assoc = null;
        Property prop = null;
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Classifiers";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_feature_featuringClassifier", "Core-Abstractions-Classifiers-A_feature_featuringClassifier");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Classifiers", this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Classifiers-Classifier-feature Core-Abstractions-Classifiers-Feature-featuringClassifier");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Comments";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_annotatedElement_comment", "Core-Abstractions-Comments-A_annotatedElement_comment");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Comments", this);
        prop = this.factory.createProperty(assoc, "comment", "Core-Abstractions-Comments-A_annotatedElement_comment-comment", "Core-Abstractions-Comments-Comment", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Comments-Comment-annotatedElement Core-Abstractions-Comments-A_annotatedElement_comment-comment");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Constraints";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_constrainedElement_constraint", "Core-Abstractions-Constraints-A_constrainedElement_constraint");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Constraints", this);
        prop = this.factory.createProperty(assoc, "constraint", "Core-Abstractions-Constraints-A_constrainedElement_constraint-constraint", "Core-Abstractions-Constraints-Constraint", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Constraints-Constraint-constrainedElement Core-Abstractions-Constraints-A_constrainedElement_constraint-constraint");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Constraints";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_member_memberNamespace", "Core-Abstractions-Constraints-A_member_memberNamespace");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Constraints", this);
        prop = this.factory.createProperty(assoc, "memberNamespace", "Core-Abstractions-Constraints-A_member_memberNamespace-memberNamespace", "Core-Abstractions-Constraints-Namespace", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Constraints-Namespace-member Core-Abstractions-Constraints-A_member_memberNamespace-memberNamespace");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Constraints";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedMember_namespace", "Core-Abstractions-Constraints-A_ownedMember_namespace");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Constraints", this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Constraints-Namespace-ownedMember Core-Abstractions-Constraints-NamedElement-namespace");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Constraints";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedRule_context", "Core-Abstractions-Constraints-A_ownedRule_context");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Constraints", this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Constraints-Namespace-ownedRule Core-Abstractions-Constraints-Constraint-context");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Constraints";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_specification_owningConstraint", "Core-Abstractions-Constraints-A_specification_owningConstraint");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Constraints", this);
        prop = this.factory.createProperty(assoc, "owningConstraint", "Core-Abstractions-Constraints-A_specification_owningConstraint-owningConstraint", "Core-Abstractions-Constraints-Constraint", "Core-Abstractions-Ownerships-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Constraints-Constraint-specification Core-Abstractions-Constraints-A_specification_owningConstraint-owningConstraint");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Expressions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_operand_expression", "Core-Abstractions-Expressions-A_operand_expression");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Expressions", this);
        prop = this.factory.createProperty(assoc, "expression", "Core-Abstractions-Expressions-A_operand_expression-expression", "Core-Abstractions-Expressions-Expression", "Core-Abstractions-Ownerships-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Expressions-Expression-operand Core-Abstractions-Expressions-A_operand_expression-expression");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Generalizations";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_general_classifier", "Core-Abstractions-Generalizations-A_general_classifier");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Generalizations", this);
        prop = this.factory.createProperty(assoc, "classifier", "Core-Abstractions-Generalizations-A_general_classifier-classifier", "Core-Abstractions-Generalizations-Classifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Generalizations-Classifier-general Core-Abstractions-Generalizations-A_general_classifier-classifier");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Generalizations";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_general_generalization", "Core-Abstractions-Generalizations-A_general_generalization");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Generalizations", this);
        prop = this.factory.createProperty(assoc, "generalization", "Core-Abstractions-Generalizations-A_general_generalization-generalization", "Core-Abstractions-Generalizations-Generalization", "Core-Abstractions-Relationships-A_target_directedRelationship-directedRelationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Generalizations-Generalization-general Core-Abstractions-Generalizations-A_general_generalization-generalization");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Generalizations";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_generalization_specific", "Core-Abstractions-Generalizations-A_generalization_specific");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Generalizations", this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Generalizations-Classifier-generalization Core-Abstractions-Generalizations-Generalization-specific");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Instances";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_classifier_instanceSpecification", "Core-Abstractions-Instances-A_classifier_instanceSpecification");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Instances", this);
        prop = this.factory.createProperty(assoc, "instanceSpecification", "Core-Abstractions-Instances-A_classifier_instanceSpecification-instanceSpecification", "Core-Abstractions-Instances-InstanceSpecification", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Instances-InstanceSpecification-classifier Core-Abstractions-Instances-A_classifier_instanceSpecification-instanceSpecification");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Instances";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_definingFeature_slot", "Core-Abstractions-Instances-A_definingFeature_slot");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Instances", this);
        prop = this.factory.createProperty(assoc, "slot", "Core-Abstractions-Instances-A_definingFeature_slot-slot", "Core-Abstractions-Instances-Slot", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Instances-Slot-definingFeature Core-Abstractions-Instances-A_definingFeature_slot-slot");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Instances";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_instance_instanceValue", "Core-Abstractions-Instances-A_instance_instanceValue");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Instances", this);
        prop = this.factory.createProperty(assoc, "instanceValue", "Core-Abstractions-Instances-A_instance_instanceValue-instanceValue", "Core-Abstractions-Instances-InstanceValue", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Instances-InstanceValue-instance Core-Abstractions-Instances-A_instance_instanceValue-instanceValue");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Instances";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_slot_owningInstance", "Core-Abstractions-Instances-A_slot_owningInstance");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Instances", this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Instances-InstanceSpecification-slot Core-Abstractions-Instances-Slot-owningInstance");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Instances";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_specification_owningInstanceSpec", "Core-Abstractions-Instances-A_specification_owningInstanceSpec");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Instances", this);
        prop = this.factory.createProperty(assoc, "owningInstanceSpec", "Core-Abstractions-Instances-A_specification_owningInstanceSpec-owningInstanceSpec", "Core-Abstractions-Instances-InstanceSpecification", "Core-Abstractions-Ownerships-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Instances-InstanceSpecification-specification Core-Abstractions-Instances-A_specification_owningInstanceSpec-owningInstanceSpec");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Instances";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_value_owningSlot", "Core-Abstractions-Instances-A_value_owningSlot");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Instances", this);
        prop = this.factory.createProperty(assoc, "owningSlot", "Core-Abstractions-Instances-A_value_owningSlot-owningSlot", "Core-Abstractions-Instances-Slot", "Core-Abstractions-Ownerships-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Instances-Slot-value Core-Abstractions-Instances-A_value_owningSlot-owningSlot");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-MultiplicityExpressions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_lowerValue_owningLower", "Core-Abstractions-MultiplicityExpressions-A_lowerValue_owningLower");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.MultiplicityExpressions", this);
        prop = this.factory.createProperty(assoc, "owningLower", "Core-Abstractions-MultiplicityExpressions-A_lowerValue_owningLower-owningLower", "Core-Abstractions-MultiplicityExpressions-MultiplicityElement", "Core-Abstractions-Ownerships-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-MultiplicityExpressions-MultiplicityElement-lowerValue Core-Abstractions-MultiplicityExpressions-A_lowerValue_owningLower-owningLower");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-MultiplicityExpressions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_upperValue_owningUpper", "Core-Abstractions-MultiplicityExpressions-A_upperValue_owningUpper");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.MultiplicityExpressions", this);
        prop = this.factory.createProperty(assoc, "owningUpper", "Core-Abstractions-MultiplicityExpressions-A_upperValue_owningUpper-owningUpper", "Core-Abstractions-MultiplicityExpressions-MultiplicityElement", "Core-Abstractions-Ownerships-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-MultiplicityExpressions-MultiplicityElement-upperValue Core-Abstractions-MultiplicityExpressions-A_upperValue_owningUpper-owningUpper");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Namespaces";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_member_memberNamespace", "Core-Abstractions-Namespaces-A_member_memberNamespace");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Namespaces", this);
        prop = this.factory.createProperty(assoc, "memberNamespace", "Core-Abstractions-Namespaces-A_member_memberNamespace-memberNamespace", "Core-Abstractions-Namespaces-Namespace", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Namespaces-Namespace-member Core-Abstractions-Namespaces-A_member_memberNamespace-memberNamespace");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Namespaces";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedMember_namespace", "Core-Abstractions-Namespaces-A_ownedMember_namespace");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Namespaces", this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Namespaces-Namespace-ownedMember Core-Abstractions-Namespaces-NamedElement-namespace");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Ownerships";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedComment_owningElement", "Core-Abstractions-Ownerships-A_ownedComment_owningElement");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Ownerships", this);
        prop = this.factory.createProperty(assoc, "owningElement", "Core-Abstractions-Ownerships-A_ownedComment_owningElement-owningElement", "Core-Abstractions-Ownerships-Element", "Core-Abstractions-Ownerships-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Ownerships-Element-ownedComment Core-Abstractions-Ownerships-A_ownedComment_owningElement-owningElement");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Ownerships";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedElement_owner", "Core-Abstractions-Ownerships-A_ownedElement_owner");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Ownerships", this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Ownerships-Element-ownedElement Core-Abstractions-Ownerships-Element-owner");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Redefinitions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedElement_redefinableElement", "Core-Abstractions-Redefinitions-A_redefinedElement_redefinableElement");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Redefinitions", this);
        prop = this.factory.createProperty(assoc, "redefinableElement", "Core-Abstractions-Redefinitions-A_redefinedElement_redefinableElement-redefinableElement", "Core-Abstractions-Redefinitions-RedefinableElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Redefinitions-RedefinableElement-redefinedElement Core-Abstractions-Redefinitions-A_redefinedElement_redefinableElement-redefinableElement");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Redefinitions";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinitionContext_redefinableElement", "Core-Abstractions-Redefinitions-A_redefinitionContext_redefinableElement");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Redefinitions", this);
        prop = this.factory.createProperty(assoc, "redefinableElement", "Core-Abstractions-Redefinitions-A_redefinitionContext_redefinableElement-redefinableElement", "Core-Abstractions-Redefinitions-RedefinableElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Redefinitions-RedefinableElement-redefinitionContext Core-Abstractions-Redefinitions-A_redefinitionContext_redefinableElement-redefinableElement");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Relationships";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_relatedElement_relationship", "Core-Abstractions-Relationships-A_relatedElement_relationship");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Relationships", this);
        prop = this.factory.createProperty(assoc, "relationship", "Core-Abstractions-Relationships-A_relatedElement_relationship-relationship", "Core-Abstractions-Relationships-Relationship", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Relationships-Relationship-relatedElement Core-Abstractions-Relationships-A_relatedElement_relationship-relationship");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Relationships";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_source_directedRelationship", "Core-Abstractions-Relationships-A_source_directedRelationship");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Relationships", this);
        prop = this.factory.createProperty(assoc, "directedRelationship", "Core-Abstractions-Relationships-A_source_directedRelationship-directedRelationship", "Core-Abstractions-Relationships-DirectedRelationship", "Core-Abstractions-Relationships-A_relatedElement_relationship-relationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Relationships-DirectedRelationship-source Core-Abstractions-Relationships-A_source_directedRelationship-directedRelationship");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Relationships";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_target_directedRelationship", "Core-Abstractions-Relationships-A_target_directedRelationship");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Relationships", this);
        prop = this.factory.createProperty(assoc, "directedRelationship", "Core-Abstractions-Relationships-A_target_directedRelationship-directedRelationship", "Core-Abstractions-Relationships-DirectedRelationship", "Core-Abstractions-Relationships-A_relatedElement_relationship-relationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Relationships-DirectedRelationship-target Core-Abstractions-Relationships-A_target_directedRelationship-directedRelationship");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Super";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_general_classifier", "Core-Abstractions-Super-A_general_classifier");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Super", this);
        prop = this.factory.createProperty(assoc, "classifier", "Core-Abstractions-Super-A_general_classifier-classifier", "Core-Abstractions-Super-Classifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Super-Classifier-general Core-Abstractions-Super-A_general_classifier-classifier");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-Super";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inheritedMember_classifier", "Core-Abstractions-Super-A_inheritedMember_classifier");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.Super", this);
        prop = this.factory.createProperty(assoc, "classifier", "Core-Abstractions-Super-A_inheritedMember_classifier-classifier", "Core-Abstractions-Super-Classifier", "Core-Abstractions-Namespaces-A_member_memberNamespace-memberNamespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-Super-Classifier-inheritedMember Core-Abstractions-Super-A_inheritedMember_classifier-classifier");
        packageId = this.artifact.getUrn() + "#" + "Core-Abstractions-TypedElements";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_type_typedElement", "Core-Abstractions-TypedElements-A_type_typedElement");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Abstractions.TypedElements", this);
        prop = this.factory.createProperty(assoc, "typedElement", "Core-Abstractions-TypedElements-A_type_typedElement-typedElement", "Core-Abstractions-TypedElements-TypedElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Abstractions-TypedElements-TypedElement-type Core-Abstractions-TypedElements-A_type_typedElement-typedElement");
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_annotatedElement_comment", "Core-Basic-A_annotatedElement_comment");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Basic", this);
        prop = this.factory.createProperty(assoc, "comment", "Core-Basic-A_annotatedElement_comment-comment", "Core-Basic-Comment", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Basic-Comment-annotatedElement Core-Basic-A_annotatedElement_comment-comment");
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_nestedPackage_nestingPackage", "Core-Basic-A_nestedPackage_nestingPackage");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Basic", this);
        this.factory.createAssociationEnds(assoc, "Core-Basic-Package-nestedPackage Core-Basic-Package-nestingPackage");
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_opposite_property", "Core-Basic-A_opposite_property");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Basic", this);
        prop = this.factory.createProperty(assoc, "property", "Core-Basic-A_opposite_property-property", "Core-Basic-Property", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Basic-Property-opposite Core-Basic-A_opposite_property-property");
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedAttribute_class", "Core-Basic-A_ownedAttribute_class");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Basic", this);
        this.factory.createAssociationEnds(assoc, "Core-Basic-Class-ownedAttribute Core-Basic-Property-class");
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedComment_owningElement", "Core-Basic-A_ownedComment_owningElement");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Basic", this);
        prop = this.factory.createProperty(assoc, "owningElement", "Core-Basic-A_ownedComment_owningElement-owningElement", "Core-Basic-Element", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Basic-Element-ownedComment Core-Basic-A_ownedComment_owningElement-owningElement");
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedLiteral_enumeration", "Core-Basic-A_ownedLiteral_enumeration");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Basic", this);
        this.factory.createAssociationEnds(assoc, "Core-Basic-Enumeration-ownedLiteral Core-Basic-EnumerationLiteral-enumeration");
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedOperation_class", "Core-Basic-A_ownedOperation_class");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Basic", this);
        this.factory.createAssociationEnds(assoc, "Core-Basic-Class-ownedOperation Core-Basic-Operation-class");
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameter_operation", "Core-Basic-A_ownedParameter_operation");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Basic", this);
        this.factory.createAssociationEnds(assoc, "Core-Basic-Operation-ownedParameter Core-Basic-Parameter-operation");
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedType_package", "Core-Basic-A_ownedType_package");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Basic", this);
        this.factory.createAssociationEnds(assoc, "Core-Basic-Package-ownedType Core-Basic-Type-package");
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_raisedException_operation", "Core-Basic-A_raisedException_operation");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Basic", this);
        prop = this.factory.createProperty(assoc, "operation", "Core-Basic-A_raisedException_operation-operation", "Core-Basic-Operation", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Basic-Operation-raisedException Core-Basic-A_raisedException_operation-operation");
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_superClass_class", "Core-Basic-A_superClass_class");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Basic", this);
        prop = this.factory.createProperty(assoc, "class", "Core-Basic-A_superClass_class-class", "Core-Basic-Class", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Basic-Class-superClass Core-Basic-A_superClass_class-class");
        packageId = this.artifact.getUrn() + "#" + "Core-Basic";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_type_typedElement", "Core-Basic-A_type_typedElement");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Basic", this);
        prop = this.factory.createProperty(assoc, "typedElement", "Core-Basic-A_type_typedElement-typedElement", "Core-Basic-TypedElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Basic-TypedElement-type Core-Basic-A_type_typedElement-typedElement");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_annotatedElement_comment", "Core-Constructs-A_annotatedElement_comment");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "comment", "Core-Constructs-A_annotatedElement_comment-comment", "Core-Constructs-Comment", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Comment-annotatedElement Core-Constructs-A_annotatedElement_comment-comment");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_attribute_classifier", "Core-Constructs-A_attribute_classifier");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "classifier", "Core-Constructs-A_attribute_classifier-classifier", "Core-Constructs-Classifier", "Core-Constructs-RedefinableElement-redefinitionContext Core-Constructs-Feature-featuringClassifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Classifier-attribute Core-Constructs-A_attribute_classifier-classifier");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_bodyCondition_bodyContext", "Core-Constructs-A_bodyCondition_bodyContext");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "bodyContext", "Core-Constructs-A_bodyCondition_bodyContext-bodyContext", "Core-Constructs-Operation", "Core-Constructs-Constraint-context", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Operation-bodyCondition Core-Constructs-A_bodyCondition_bodyContext-bodyContext");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_constrainedElement_constraint", "Core-Constructs-A_constrainedElement_constraint");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "constraint", "Core-Constructs-A_constrainedElement_constraint-constraint", "Core-Constructs-Constraint", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Constraint-constrainedElement Core-Constructs-A_constrainedElement_constraint-constraint");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_elementImport_importingNamespace", "Core-Constructs-A_elementImport_importingNamespace");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Namespace-elementImport Core-Constructs-ElementImport-importingNamespace");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_endType_association", "Core-Constructs-A_endType_association");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "association", "Core-Constructs-A_endType_association-association", "Core-Constructs-Association", "Core-Constructs-A_relatedElement_relationship-relationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Association-endType Core-Constructs-A_endType_association-association");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_feature_featuringClassifier", "Core-Constructs-A_feature_featuringClassifier");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Classifier-feature Core-Constructs-Feature-featuringClassifier");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_general_classifier", "Core-Constructs-A_general_classifier");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "classifier", "Core-Constructs-A_general_classifier-classifier", "Core-Constructs-Classifier", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Classifier-general Core-Constructs-A_general_classifier-classifier");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_importedElement_elementImport", "Core-Constructs-A_importedElement_elementImport");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "elementImport", "Core-Constructs-A_importedElement_elementImport-elementImport", "Core-Constructs-ElementImport", "Core-Constructs-A_target_directedRelationship-directedRelationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-ElementImport-importedElement Core-Constructs-A_importedElement_elementImport-elementImport");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_importedMember_namespace", "Core-Constructs-A_importedMember_namespace");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "namespace", "Core-Constructs-A_importedMember_namespace-namespace", "Core-Constructs-Namespace", "Core-Constructs-A_member_memberNamespace-memberNamespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Namespace-importedMember Core-Constructs-A_importedMember_namespace-namespace");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_importedPackage_packageImport", "Core-Constructs-A_importedPackage_packageImport");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "packageImport", "Core-Constructs-A_importedPackage_packageImport-packageImport", "Core-Constructs-PackageImport", "Core-Constructs-A_target_directedRelationship-directedRelationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-PackageImport-importedPackage Core-Constructs-A_importedPackage_packageImport-packageImport");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_inheritedMember_classifier", "Core-Constructs-A_inheritedMember_classifier");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "classifier", "Core-Constructs-A_inheritedMember_classifier-classifier", "Core-Constructs-Classifier", "Core-Constructs-A_member_memberNamespace-memberNamespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Classifier-inheritedMember Core-Constructs-A_inheritedMember_classifier-classifier");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_memberEnd_association", "Core-Constructs-A_memberEnd_association");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Association-memberEnd Core-Constructs-Property-association");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_member_memberNamespace", "Core-Constructs-A_member_memberNamespace");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "memberNamespace", "Core-Constructs-A_member_memberNamespace-memberNamespace", "Core-Constructs-Namespace", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Namespace-member Core-Constructs-A_member_memberNamespace-memberNamespace");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_mergedPackage_packageMerge", "Core-Constructs-A_mergedPackage_packageMerge");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "packageMerge", "Core-Constructs-A_mergedPackage_packageMerge-packageMerge", "Core-Constructs-PackageMerge", "Core-Constructs-A_target_directedRelationship-directedRelationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-PackageMerge-mergedPackage Core-Constructs-A_mergedPackage_packageMerge-packageMerge");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_navigableOwnedEnd_association", "Core-Constructs-A_navigableOwnedEnd_association");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "association", "Core-Constructs-A_navigableOwnedEnd_association-association", "Core-Constructs-Association", "Core-Constructs-Property-owningAssociation", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Association-navigableOwnedEnd Core-Constructs-A_navigableOwnedEnd_association-association");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_nestedPackage_nestingPackage", "Core-Constructs-A_nestedPackage_nestingPackage");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Package-nestedPackage Core-Constructs-Package-nestingPackage");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_operand_expression", "Core-Constructs-A_operand_expression");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "expression", "Core-Constructs-A_operand_expression-expression", "Core-Constructs-Expression", "Core-Constructs-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Expression-operand Core-Constructs-A_operand_expression-expression");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_opposite_property", "Core-Constructs-A_opposite_property");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "property", "Core-Constructs-A_opposite_property-property", "Core-Constructs-Property", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Property-opposite Core-Constructs-A_opposite_property-property");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedAttribute_class", "Core-Constructs-A_ownedAttribute_class");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Class-ownedAttribute Core-Constructs-Property-class");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedAttribute_datatype", "Core-Constructs-A_ownedAttribute_datatype");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-DataType-ownedAttribute Core-Constructs-Property-datatype");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedComment_owningElement", "Core-Constructs-A_ownedComment_owningElement");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "owningElement", "Core-Constructs-A_ownedComment_owningElement-owningElement", "Core-Constructs-Element", "Core-Constructs-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Element-ownedComment Core-Constructs-A_ownedComment_owningElement-owningElement");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedElement_owner", "Core-Constructs-A_ownedElement_owner");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Element-ownedElement Core-Constructs-Element-owner");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedEnd_owningAssociation", "Core-Constructs-A_ownedEnd_owningAssociation");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Association-ownedEnd Core-Constructs-Property-owningAssociation");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedLiteral_enumeration", "Core-Constructs-A_ownedLiteral_enumeration");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Enumeration-ownedLiteral Core-Constructs-EnumerationLiteral-enumeration");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedMember_namespace", "Core-Constructs-A_ownedMember_namespace");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Namespace-ownedMember Core-Constructs-NamedElement-namespace");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedOperation_class", "Core-Constructs-A_ownedOperation_class");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Class-ownedOperation Core-Constructs-Operation-class");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedOperation_datatype", "Core-Constructs-A_ownedOperation_datatype");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-DataType-ownedOperation Core-Constructs-Operation-datatype");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameter_operation", "Core-Constructs-A_ownedParameter_operation");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Operation-ownedParameter Core-Constructs-Parameter-operation");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedParameter_ownerFormalParam", "Core-Constructs-A_ownedParameter_ownerFormalParam");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "ownerFormalParam", "Core-Constructs-A_ownedParameter_ownerFormalParam-ownerFormalParam", "Core-Constructs-BehavioralFeature", "Core-Constructs-NamedElement-namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-BehavioralFeature-ownedParameter Core-Constructs-A_ownedParameter_ownerFormalParam-ownerFormalParam");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedRule_context", "Core-Constructs-A_ownedRule_context");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Namespace-ownedRule Core-Constructs-Constraint-context");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedType_package", "Core-Constructs-A_ownedType_package");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Package-ownedType Core-Constructs-Type-package");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_packageImport_importingNamespace", "Core-Constructs-A_packageImport_importingNamespace");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Namespace-packageImport Core-Constructs-PackageImport-importingNamespace");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_packageMerge_receivingPackage", "Core-Constructs-A_packageMerge_receivingPackage");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Package-packageMerge Core-Constructs-PackageMerge-receivingPackage");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_packagedElement_owningPackage", "Core-Constructs-A_packagedElement_owningPackage");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "owningPackage", "Core-Constructs-A_packagedElement_owningPackage-owningPackage", "Core-Constructs-Package", "Core-Constructs-NamedElement-namespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Package-packagedElement Core-Constructs-A_packagedElement_owningPackage-owningPackage");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_postcondition_postContext", "Core-Constructs-A_postcondition_postContext");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "postContext", "Core-Constructs-A_postcondition_postContext-postContext", "Core-Constructs-Operation", "Core-Constructs-Constraint-context", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Operation-postcondition Core-Constructs-A_postcondition_postContext-postContext");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_precondition_preContext", "Core-Constructs-A_precondition_preContext");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "preContext", "Core-Constructs-A_precondition_preContext-preContext", "Core-Constructs-Operation", "Core-Constructs-Constraint-context", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Operation-precondition Core-Constructs-A_precondition_preContext-preContext");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_raisedException_behavioralFeature", "Core-Constructs-A_raisedException_behavioralFeature");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "behavioralFeature", "Core-Constructs-A_raisedException_behavioralFeature-behavioralFeature", "Core-Constructs-BehavioralFeature", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-BehavioralFeature-raisedException Core-Constructs-A_raisedException_behavioralFeature-behavioralFeature");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_raisedException_operation", "Core-Constructs-A_raisedException_operation");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "operation", "Core-Constructs-A_raisedException_operation-operation", "Core-Constructs-Operation", "Core-Constructs-A_raisedException_behavioralFeature-behavioralFeature", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Operation-raisedException Core-Constructs-A_raisedException_operation-operation");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedElement_redefinableElement", "Core-Constructs-A_redefinedElement_redefinableElement");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "redefinableElement", "Core-Constructs-A_redefinedElement_redefinableElement-redefinableElement", "Core-Constructs-RedefinableElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-RedefinableElement-redefinedElement Core-Constructs-A_redefinedElement_redefinableElement-redefinableElement");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedOperation_operation", "Core-Constructs-A_redefinedOperation_operation");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "operation", "Core-Constructs-A_redefinedOperation_operation-operation", "Core-Constructs-Operation", "Core-Constructs-A_redefinedElement_redefinableElement-redefinableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Operation-redefinedOperation Core-Constructs-A_redefinedOperation_operation-operation");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinedProperty_property", "Core-Constructs-A_redefinedProperty_property");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "property", "Core-Constructs-A_redefinedProperty_property-property", "Core-Constructs-Property", "Core-Constructs-A_redefinedElement_redefinableElement-redefinableElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Property-redefinedProperty Core-Constructs-A_redefinedProperty_property-property");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_redefinitionContext_redefinableElement", "Core-Constructs-A_redefinitionContext_redefinableElement");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "redefinableElement", "Core-Constructs-A_redefinitionContext_redefinableElement-redefinableElement", "Core-Constructs-RedefinableElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-RedefinableElement-redefinitionContext Core-Constructs-A_redefinitionContext_redefinableElement-redefinableElement");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_relatedElement_relationship", "Core-Constructs-A_relatedElement_relationship");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "relationship", "Core-Constructs-A_relatedElement_relationship-relationship", "Core-Constructs-Relationship", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Relationship-relatedElement Core-Constructs-A_relatedElement_relationship-relationship");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_source_directedRelationship", "Core-Constructs-A_source_directedRelationship");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "directedRelationship", "Core-Constructs-A_source_directedRelationship-directedRelationship", "Core-Constructs-DirectedRelationship", "Core-Constructs-A_relatedElement_relationship-relationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-DirectedRelationship-source Core-Constructs-A_source_directedRelationship-directedRelationship");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_specification_owningConstraint", "Core-Constructs-A_specification_owningConstraint");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "owningConstraint", "Core-Constructs-A_specification_owningConstraint-owningConstraint", "Core-Constructs-Constraint", "Core-Constructs-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Constraint-specification Core-Constructs-A_specification_owningConstraint-owningConstraint");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_subsettedProperty_property", "Core-Constructs-A_subsettedProperty_property");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "property", "Core-Constructs-A_subsettedProperty_property-property", "Core-Constructs-Property", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Property-subsettedProperty Core-Constructs-A_subsettedProperty_property-property");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_superClass_class", "Core-Constructs-A_superClass_class");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "class", "Core-Constructs-A_superClass_class-class", "Core-Constructs-Class", "Core-Constructs-A_general_classifier-classifier", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Class-superClass Core-Constructs-A_superClass_class-class");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_target_directedRelationship", "Core-Constructs-A_target_directedRelationship");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "directedRelationship", "Core-Constructs-A_target_directedRelationship-directedRelationship", "Core-Constructs-DirectedRelationship", "Core-Constructs-A_relatedElement_relationship-relationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-DirectedRelationship-target Core-Constructs-A_target_directedRelationship-directedRelationship");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_type_operation", "Core-Constructs-A_type_operation");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "operation", "Core-Constructs-A_type_operation-operation", "Core-Constructs-Operation", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-Operation-type Core-Constructs-A_type_operation-operation");
        packageId = this.artifact.getUrn() + "#" + "Core-Constructs";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_type_typedElement", "Core-Constructs-A_type_typedElement");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Core.Constructs", this);
        prop = this.factory.createProperty(assoc, "typedElement", "Core-Constructs-A_type_typedElement-typedElement", "Core-Constructs-TypedElement", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Core-Constructs-TypedElement-type Core-Constructs-A_type_typedElement-typedElement");
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_appliedProfile_profileApplication", "Profiles-A_appliedProfile_profileApplication");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Profiles", this);
        prop = this.factory.createProperty(assoc, "profileApplication", "Profiles-A_appliedProfile_profileApplication-profileApplication", "Profiles-ProfileApplication", "Core-Constructs-A_target_directedRelationship-directedRelationship", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Profiles-ProfileApplication-appliedProfile Profiles-A_appliedProfile_profileApplication-profileApplication");
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_extension_metaclass", "Profiles-A_extension_metaclass");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Profiles", this);
        this.factory.createAssociationEnds(assoc, "Profiles-Class-extension Profiles-Extension-metaclass");
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_icon_stereotype", "Profiles-A_icon_stereotype");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Profiles", this);
        prop = this.factory.createProperty(assoc, "stereotype", "Profiles-A_icon_stereotype-stereotype", "Profiles-Stereotype", "Core-Constructs-Element-owner", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Profiles-Stereotype-icon Profiles-A_icon_stereotype-stereotype");
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_metaclassReference_profile", "Profiles-A_metaclassReference_profile");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Profiles", this);
        prop = this.factory.createProperty(assoc, "profile", "Profiles-A_metaclassReference_profile-profile", "Profiles-Profile", "Core-Constructs-ElementImport-importingNamespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Profiles-Profile-metaclassReference Profiles-A_metaclassReference_profile-profile");
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_metamodelReference_profile", "Profiles-A_metamodelReference_profile");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Profiles", this);
        prop = this.factory.createProperty(assoc, "profile", "Profiles-A_metamodelReference_profile-profile", "Profiles-Profile", "Core-Constructs-PackageImport-importingNamespace", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Profiles-Profile-metamodelReference Profiles-A_metamodelReference_profile-profile");
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedEnd_extension", "Profiles-A_ownedEnd_extension");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Profiles", this);
        prop = this.factory.createProperty(assoc, "extension", "Profiles-A_ownedEnd_extension-extension", "Profiles-Extension", "Core-Constructs-Property-owningAssociation", "", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Profiles-Extension-ownedEnd Profiles-A_ownedEnd_extension-extension");
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_ownedStereotype_owningPackage", "Profiles-A_ownedStereotype_owningPackage");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Profiles", this);
        prop = this.factory.createProperty(assoc, "owningPackage", "Profiles-A_ownedStereotype_owningPackage-owningPackage", "Profiles-Package", "", "Profiles-A_packagedElement_owningPackage-owningPackage", false, false, false);
        this.factory.createLowerValue(prop, false, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Profiles-Package-ownedStereotype Profiles-A_ownedStereotype_owningPackage-owningPackage");
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_packagedElement_owningPackage", "Profiles-A_packagedElement_owningPackage");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Profiles", this);
        prop = this.factory.createProperty(assoc, "owningPackage", "Profiles-A_packagedElement_owningPackage-owningPackage", "Profiles-Package", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, false, "");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Profiles-Package-packagedElement Profiles-A_packagedElement_owningPackage-owningPackage");
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_profileApplication_applyingPackage", "Profiles-A_profileApplication_applyingPackage");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Profiles", this);
        this.factory.createAssociationEnds(assoc, "Profiles-Package-profileApplication Profiles-ProfileApplication-applyingPackage");
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_profile_stereotype", "Profiles-A_profile_stereotype");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Profiles", this);
        prop = this.factory.createProperty(assoc, "stereotype", "Profiles-A_profile_stereotype-stereotype", "Profiles-Stereotype", "", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Profiles-Stereotype-profile Profiles-A_profile_stereotype-stereotype");
        packageId = this.artifact.getUrn() + "#" + "Profiles";
        pkg = (Package)this.model.getElementById(packageId).getDelegate();
        assoc = this.factory.createAssociation("A_type_extensionEnd", "Profiles-A_type_extensionEnd");
        this.mapping.mapAssociation(assoc, "InfrastructureLibrary.Profiles", this);
        prop = this.factory.createProperty(assoc, "extensionEnd", "Profiles-A_type_extensionEnd-extensionEnd", "Profiles-ExtensionEnd", "Core-Constructs-A_type_typedElement-typedElement", "", false, false, false);
        this.factory.createLowerValue(prop, true, "");
        this.factory.createUpperValue(prop, true, "*");
        this.mapping.mapProperty(assoc, prop, this);
        this.factory.createAssociationEnds(assoc, "Profiles-ExtensionEnd-type Profiles-A_type_extensionEnd-extensionEnd");
    }
}

