/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Classes.Kernel;

import fUML.Semantics.Classes.Kernel.FeatureValue;
import fUML.Semantics.Classes.Kernel.FeatureValueList;
import fUML.Semantics.Classes.Kernel.Object_;
import fUML.Semantics.Classes.Kernel.Reference;
import fUML.Semantics.Classes.Kernel.StructuredValue;
import fUML.Semantics.Classes.Kernel.Value;
import fUML.Semantics.Classes.Kernel.ValueList;
import fUML.Syntax.Classes.Kernel.ClassifierList;
import fUML.Syntax.Classes.Kernel.StructuralFeature;

public abstract class CompoundValue
extends StructuredValue {
    public FeatureValueList featureValues = new FeatureValueList();

    @Override
    public boolean equals(Value otherValue) {
        boolean isEqual = otherValue instanceof CompoundValue;
        if (isEqual) {
            CompoundValue otherCompoundValue = (CompoundValue)otherValue;
            isEqual = super.equals(otherValue) & otherCompoundValue.featureValues.size() == this.featureValues.size();
            int i = 1;
            while (isEqual & i <= this.featureValues.size()) {
                FeatureValue thisFeatureValue = this.featureValues.getValue(i - 1);
                boolean matched = false;
                int j = 1;
                while (!matched & j <= otherCompoundValue.featureValues.size()) {
                    FeatureValue otherFeatureValue = otherCompoundValue.featureValues.getValue(j - 1);
                    if (thisFeatureValue.feature == otherFeatureValue.feature) {
                        matched = thisFeatureValue.hasEqualValues(otherFeatureValue);
                    }
                    ++j;
                }
                isEqual = matched;
                ++i;
            }
        }
        return isEqual;
    }

    @Override
    public Value copy() {
        CompoundValue newValue = (CompoundValue)super.copy();
        FeatureValueList featureValues = this.featureValues;
        int i = 0;
        while (i < featureValues.size()) {
            FeatureValue featureValue = featureValues.getValue(i);
            newValue.featureValues.addValue(featureValue.copy());
            ++i;
        }
        return newValue;
    }

    @Override
    public FeatureValue getFeatureValue(StructuralFeature feature) {
        FeatureValue featureValue = null;
        int i = 1;
        while (featureValue == null & i <= this.featureValues.size()) {
            if (this.featureValues.getValue((int)(i - 1)).feature == feature) {
                featureValue = this.featureValues.getValue(i - 1);
            }
            ++i;
        }
        return featureValue;
    }

    @Override
    public void setFeatureValue(StructuralFeature feature, ValueList values, int position) {
        FeatureValue featureValue = this.getFeatureValue(feature);
        if (featureValue == null) {
            featureValue = new FeatureValue();
            this.featureValues.addValue(featureValue);
        }
        featureValue.feature = feature;
        featureValue.values = values;
        featureValue.position = position;
    }

    @Override
    public FeatureValueList getFeatureValues() {
        return this.featureValues;
    }

    @Override
    public String toString() {
        String buffer = "(" + this.objectId() + ":";
        ClassifierList types = this.getTypes();
        int i = 1;
        while (i <= types.size()) {
            buffer = String.valueOf(buffer) + " " + types.getValue((int)(i - 1)).name;
            ++i;
        }
        int k = 1;
        while (k <= this.featureValues.size()) {
            FeatureValue featureValue = this.featureValues.getValue(k - 1);
            buffer = String.valueOf(buffer) + "\n\t\t" + featureValue.feature.name + "[" + featureValue.position + "]  =";
            int j = 1;
            while (j <= featureValue.values.size()) {
                Value value = featureValue.values.getValue(j - 1);
                if (value instanceof Reference) {
                    Object_ object = ((Reference)value).referent;
                    buffer = String.valueOf(buffer) + " Reference to (" + object.objectId() + ":";
                    types = object.getTypes();
                    int n = 1;
                    while (n <= types.size()) {
                        buffer = String.valueOf(buffer) + " " + types.getValue((int)(n - 1)).name;
                        ++n;
                    }
                    buffer = String.valueOf(buffer) + ")";
                } else {
                    buffer = String.valueOf(buffer) + " " + value.toString();
                }
                ++j;
            }
            ++k;
        }
        return String.valueOf(buffer) + ")";
    }
}

