/*
 * Decompiled with CFR 0.152.
 */
package fUML.Test;

import fUML.Debug;
import fUML.Syntax.Classes.Kernel.Association;
import fUML.Test.ActivityFactory;
import fUML.Test.ClassifierFactory;
import fUML.Test.ExecutorTest;
import fUML.Test.InitTestEnvironment;
import fUML.Test.Test;
import fUML.Test.VariableUtility;

public class TestSuite
extends Test {
    private ActivityFactory activityFactory = null;
    private ClassifierFactory classifierFactory = null;
    private ExecutorTest executorTest = null;
    private VariableUtility variableUtility = null;

    public TestSuite(InitTestEnvironment init) {
        this.environment = init.environment;
        this.activityFactory = init.activityFactory;
        this.classifierFactory = init.classifierFactory;
        this.executorTest = init.executorTest;
        this.variableUtility = init.variableUtility;
    }

    public void testSimpleActivites() {
        Debug.println("");
        Debug.println("[testSimpleActivites] Setting up...");
        this.activityFactory.createCopier();
        this.activityFactory.createCaller("Copier");
        this.activityFactory.createSimpleDecision(0);
        this.activityFactory.createSimpleDecision(1);
        this.activityFactory.createForkJoin();
        this.activityFactory.createDecisionJoin();
        this.activityFactory.createForkMerge();
        this.activityFactory.createForkMergeData();
        this.activityFactory.createFlowFinal();
        this.activityFactory.createSelfReader();
        Debug.println("[testSimpleActivities] Testing...");
        this.executorTest.testExecute("Copier");
        this.executorTest.testExecute("CopierCaller");
        this.executorTest.testExecute("SimpleDecision0");
        this.executorTest.testExecute("SimpleDecision1");
        this.executorTest.testExecute("ForkJoin");
        this.executorTest.testExecute("DecisionJoin");
        this.executorTest.testExecute("ForkMerge");
        this.executorTest.testExecute("ForkMergeData");
        this.executorTest.testExecute("FlowFinal");
        this.executorTest.testExecute("SelfReader");
        Debug.println("[testSimpleActivities] Done!");
    }

    public void testHelloWorld() {
        Debug.println("");
        Debug.println("[testHelloWorld] Setting up...");
        this.activityFactory.createHelloWorld2();
        Debug.println("[testHelloWorld] Testing...");
        this.executorTest.testExecute("HelloWorld2");
        Debug.println("[testHelloWorld] Done!");
    }

    public void testPolymorphicOperationCall(String superclassMethodName, String subclassMethodName) {
        Debug.println("");
        Debug.println("[testPolymorphicOperationCall] Setting up...");
        if (this.activityFactory.getActivity(superclassMethodName) == null) {
            return;
        }
        if (this.activityFactory.getActivity(subclassMethodName) == null) {
            return;
        }
        String superclassName = "Super_" + superclassMethodName;
        String subclassName = "Sub_" + subclassMethodName;
        if (this.environment.getElement(superclassName) != null) {
            Debug.println("[testPolymorphicOperationCall] Replacing class " + superclassName + ".");
            this.environment.removeElement(superclassName);
        }
        if (this.environment.getElement(subclassName) != null) {
            Debug.println("[testPolymorphicOperationCall] Replacing class " + subclassName + ".");
            this.environment.removeElement(subclassName);
        }
        this.classifierFactory.createClass(superclassName);
        this.classifierFactory.addOperation(superclassName, "", "test", superclassMethodName);
        this.classifierFactory.createClass(subclassName);
        this.classifierFactory.addOperation(subclassName, superclassName, "test", subclassMethodName);
        this.activityFactory.createPolymorphicOperationCaller(subclassName, superclassName, "test");
        Debug.println("[testPolymorphicOperationCall] Testing...");
        this.executorTest.testExecute(String.valueOf(subclassName) + superclassName + "testCaller");
        Debug.println("[testPolymorphicOperationCall] Done!");
    }

    public void testSuperCall(String superclassMethodName, String subclassMethodName) {
        Debug.println("");
        Debug.println("[testSuperCall] Setting up...");
        if (this.activityFactory.getActivity(superclassMethodName) == null) {
            return;
        }
        if (this.activityFactory.getActivity(subclassMethodName) == null) {
            return;
        }
        String superclassName = "Super_" + superclassMethodName;
        String subclassName = "Sub_" + subclassMethodName;
        if (this.environment.getElement(superclassName) != null) {
            Debug.println("[testSuperCall] Replacing class " + superclassName + ".");
            this.environment.removeElement(superclassName);
        }
        if (this.environment.getElement(subclassName) != null) {
            Debug.println("[testSuperCall] Replacing class " + subclassName + ".");
            this.environment.removeElement(subclassName);
        }
        this.classifierFactory.createClass(superclassName);
        this.classifierFactory.addOperation(superclassName, "", "test", superclassMethodName);
        this.activityFactory.createSelfCaller(superclassName, "test");
        this.classifierFactory.addOperation(superclassName, "", "callTest", String.valueOf(superclassName) + "testSelfCaller");
        this.classifierFactory.createClass(subclassName);
        this.classifierFactory.addOperation(subclassName, superclassName, "test", subclassMethodName);
        this.activityFactory.createMethodCaller(superclassName, "callTest");
        this.classifierFactory.addOperation(subclassName, superclassName, "callTest", String.valueOf(superclassName) + "callTestMethodCaller");
        this.classifierFactory.addGeneralization(subclassName, superclassName);
        this.activityFactory.createOperationCaller(subclassName, "callTest");
        Debug.println("[testSuperCall] Testing...");
        this.executorTest.testExecute(String.valueOf(subclassName) + "callTestCaller");
        Debug.println("[testSuperCall] Done!");
    }

    public void testSignalSend() {
        Debug.println("[testSignalSend] Setting up...");
        this.classifierFactory.createSignal("TestSignal");
        this.activityFactory.createSender("TestSignal");
        Debug.println("[testSignalSend] Testing...");
        this.executorTest.testExecute("TestSignalSender");
        Debug.println("[testSignalSend] Done!");
    }

    public void testStructuredNode() {
        Debug.println("");
        Debug.println("[testStructuredNode] Setting up...");
        this.activityFactory.createStructuredNodeTester("ForkMergeInput");
        Debug.println("[testStructuredNode] Testing...");
        this.executorTest.testExecute("StructuredForkMergeInput");
        Debug.println("[testStructuredNode] Done!");
    }

    public void testConditionalNode() {
        Debug.println("");
        Debug.println("[testConditionalNode] Setting up...");
        this.activityFactory.createConditionalNodeTester(0);
        this.activityFactory.createConditionalNodeTester(1);
        this.activityFactory.createConditionalNodeTester(2);
        Debug.println("[testConditionalNode] Testing...");
        this.executorTest.testExecute("ConditionalNodeTester_0");
        this.executorTest.testExecute("ConditionalNodeTester_1");
        this.executorTest.testExecute("ConditionalNodeTester_2");
        Debug.println("[testConditionalNode] Done!");
    }

    public void testLoopNode() {
        Debug.println("");
        Debug.println("[testLoopNode] Setting up...");
        this.activityFactory.createLoopNodeTester(0);
        this.activityFactory.createLoopNodeTester(1);
        this.activityFactory.createLoopNodeTester(2);
        Debug.println("[testLoopNode] Testing...");
        this.executorTest.testExecute("LoopNodeTester_0");
        this.executorTest.testExecute("LoopNodeTester_1");
        this.executorTest.testExecute("LoopNodeTester_2");
        Debug.println("[testLoopNode] Done!");
    }

    public void testExpansionRegion() {
        Debug.println("");
        Debug.println("[testExpansionRegion] Setting up...");
        this.activityFactory.createExpansionRegionTester(0);
        this.activityFactory.createExpansionRegionTester(1);
        this.activityFactory.createExpansionRegionTester(2);
        Debug.println("[testExpansionRegion] Testing...");
        this.executorTest.testExecute("ExpansionRegionTester_0");
        this.executorTest.testExecute("ExpansionRegionTester_1");
        this.executorTest.testExecute("ExpansionRegionTester_2");
        Debug.println("[testExpansionRegion] Done!");
    }

    public void testLinkCreator() {
        Debug.println("[testLinkCreator] Setting up...");
        this.classifierFactory.createClass("A");
        this.classifierFactory.createClass("B");
        this.environment.removeElement("AB");
        this.classifierFactory.createAssociation("AB");
        this.classifierFactory.addEnd("AB", "a", "A", false);
        this.classifierFactory.addEnd("AB", "b", "B", false);
        this.activityFactory.createLinkCreator("AB");
        Debug.println("[testLinkCreator] Testing...");
        this.executorTest.testExecute("ABLinkCreator");
        this.environment.printExtent("AB");
        Debug.println("[testLinkCreator] Done!");
    }

    public void testLinkDestroyer() {
        Debug.println("[testLinkDestroyer] Setting up...");
        this.classifierFactory.createClass("A");
        this.classifierFactory.createClass("B");
        this.environment.removeElement("AB");
        this.classifierFactory.createAssociation("AB");
        this.classifierFactory.addEnd("AB", "a", "A", false);
        this.classifierFactory.addEnd("AB", "b", "B", false);
        this.activityFactory.createLinkDestroyer("AB");
        Debug.println("[testLinkDestroyer] Testing...");
        this.executorTest.testExecute("ABLinkDestroyer");
        this.environment.printExtent("AB");
        Debug.println("[testLinkDestroyer] Done!");
    }

    public void testLinkReader() {
        Debug.println("[testLinkReader] Setting up...");
        this.classifierFactory.createClass("A");
        this.classifierFactory.createClass("B");
        this.environment.removeElement("AB");
        this.classifierFactory.createAssociation("AB");
        this.classifierFactory.addEnd("AB", "a", "A", false);
        this.classifierFactory.addEnd("AB", "b", "B", false);
        ((Association)this.environment.getElement((String)"AB")).memberEnd.getValue((int)1).multiplicityElement.setIsOrdered(true);
        this.activityFactory.createLinkReader("AB");
        Debug.println("[testLinkReader] Testing...");
        this.executorTest.testExecute("ABLinkReader");
        this.environment.printExtent("AB");
        Debug.println("[testLinkReader] Done!");
    }

    public void testLinkWriter() {
        Debug.println("[testLinkWriter] Setting up...");
        this.classifierFactory.createClass("A");
        this.classifierFactory.createClass("B");
        this.environment.removeElement("AB");
        this.classifierFactory.createAssociation("AB");
        this.classifierFactory.addEnd("AB", "a", "A", false);
        this.classifierFactory.addEnd("AB", "b", "B", false);
        ((Association)this.environment.getElement((String)"AB")).memberEnd.getValue((int)1).multiplicityElement.setIsOrdered(true);
        this.activityFactory.createLinkWriter("AB");
        Debug.println("[testLinkWriter] Testing...");
        this.executorTest.testExecute("ABLinkWriter");
        this.environment.printExtent("AB");
        Debug.println("[testLinkWriter] Done!");
    }

    public void testLinkRemover() {
        Debug.println("[testLinkRemover] Setting up (unordered end)...");
        this.classifierFactory.createClass("A");
        this.classifierFactory.createClass("B");
        this.environment.removeElement("AB");
        this.classifierFactory.createAssociation("AB");
        this.classifierFactory.addEnd("AB", "a", "A", false);
        this.classifierFactory.addEnd("AB", "b", "B", false);
        this.activityFactory.createLinkRemover("AB");
        Debug.println("[testLinkRemover] Testing (unordered end)...");
        this.executorTest.testExecute("ABLinkRemover");
        this.environment.printExtent("AB");
        Debug.println("[testLinkRemover] Setting up (ordered end)...");
        this.environment.locus.extensionalValues.clear();
        ((Association)this.environment.getElement((String)"AB")).memberEnd.getValue((int)1).multiplicityElement.setIsOrdered(true);
        ((Association)this.environment.getElement((String)"AB")).memberEnd.getValue((int)1).multiplicityElement.setIsUnique(false);
        this.environment.removeElement("ABLinkWriter");
        this.environment.removeElement("ABLinkRemover");
        this.activityFactory.createLinkRemover("AB");
        Debug.println("[testLinkRemover] Testing (ordered end)...");
        this.executorTest.testExecute("ABLinkRemover");
        this.environment.printExtent("AB");
        Debug.println("[testLinkRemover] Done!");
    }

    public void testWriterReader() {
        Debug.println("[testWriterReader] Setting up...");
        this.environment.removeElement("TestClass");
        this.classifierFactory.createClass("TestClass");
        this.classifierFactory.addAttribute("TestClass", "x", "Integer", false);
        this.activityFactory.createWriterReader("TestClass", "x");
        Debug.println("[testWriterReader] Testing...");
        this.executorTest.testExecute("TestClass_x_WriterReader");
        this.environment.printExtent("TestClass");
        Debug.println("[testWriterReader] Done!");
    }

    public void testIsClassified() {
        Debug.println("[testIsClassified] Setting up...");
        this.classifierFactory.createSignal("Signal");
        this.activityFactory.createIsClassifiedTester("Signal");
        Debug.println("[testIsClassified] Testing...");
        this.executorTest.testExecute("TestIsSignal");
        Debug.println("[testIsClassified] Done!");
    }

    public void testFireAgain() {
        Debug.println("[testFireAgain] Setting up...");
        this.activityFactory.createFireAgainTester();
        Debug.println("[testFireAgain] Testing...");
        this.executorTest.testExecute("FireAgainTester");
        Debug.println("[testFireAgain] Done!");
    }
}

