/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Classes.Kernel;

import fUML.Semantics.Classes.Kernel.IntegerValue;
import fUML.Semantics.Classes.Kernel.PrimitiveValue;
import fUML.Semantics.Classes.Kernel.Value;
import fUML.Syntax.Classes.Kernel.LiteralReal;
import fUML.Syntax.Classes.Kernel.ValueSpecification;

public class RealValue
extends PrimitiveValue {
    public float value = 0.0f;

    @Override
    public ValueSpecification specify() {
        LiteralReal literal = new LiteralReal();
        literal.type = this.type;
        literal.value = this.value;
        return literal;
    }

    @Override
    public boolean equals(Value otherValue) {
        boolean isEqual = false;
        if (otherValue instanceof RealValue) {
            isEqual = ((RealValue)otherValue).value == this.value;
        }
        return isEqual;
    }

    @Override
    public Value copy() {
        RealValue newValue = (RealValue)super.copy();
        newValue.value = this.value;
        return newValue;
    }

    @Override
    protected Value new_() {
        return new RealValue();
    }

    @Override
    public String toString() {
        String stringValue = "";
        if (this.value == 0.0f) {
            stringValue = "0";
        } else {
            float positiveValue = this.value;
            if (positiveValue < 0.0f) {
                positiveValue = -positiveValue;
            }
            int exponent = 0;
            if ((double)positiveValue < 0.1) {
                while ((double)positiveValue < 0.1) {
                    positiveValue *= 10.0f;
                    --exponent;
                }
            } else if (positiveValue > 1.0f) {
                while (positiveValue > 1.0f) {
                    positiveValue /= 10.0f;
                    ++exponent;
                }
            }
            int i = 0;
            while (i < 9) {
                positiveValue *= 10.0f;
                ++i;
            }
            IntegerValue integerValue = new IntegerValue();
            integerValue.value = (int)positiveValue;
            stringValue = "0." + integerValue.toString();
            integerValue.value = exponent;
            stringValue = String.valueOf(stringValue) + "E" + integerValue.toString();
            if (this.value < 0.0f) {
                stringValue = "-" + stringValue;
            }
        }
        return stringValue;
    }
}

