/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.xmi.validation;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class ValidationProperties {
    public static final String PROPERTY_NAME_VALIDATION_PROPERTIES = "foo";
    public static final String PROPERTY_NAME_DEFAULT_VALIDATION_PROPERTIES = "validation.properties";
    private static ValidationProperties instance;
    private Properties props = new Properties();
    private String fileName = System.getProperty("foo", "validation.properties");

    private ValidationProperties() {
        try {
            FileInputStream fis = new FileInputStream(this.fileName);
            this.props.load(fis);
        }
        catch (IOException e) {
            try {
                InputStream inputStream = ValidationProperties.class.getResourceAsStream(this.fileName);
                if (inputStream == null) {
                    throw new IllegalArgumentException("No properties file found for name, '" + this.fileName + "'");
                }
                this.props.load(inputStream);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("No properties file found for name, '" + this.fileName + "'");
            }
        }
        for (String string : this.props.keySet()) {
            this.props.setProperty(string, this.props.getProperty(string).trim());
        }
    }

    public String dumpProperties(String separator) {
        StringBuffer buf = new StringBuffer();
        for (String string : this.props.keySet()) {
            String value = this.props.getProperty(string);
            buf.append(separator + string + "='" + value + "'");
        }
        return buf.toString();
    }

    public static ValidationProperties instance() {
        if (instance == null) {
            ValidationProperties.initInstance();
        }
        return instance;
    }

    private static synchronized void initInstance() {
        if (instance == null) {
            instance = new ValidationProperties();
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    public String getProperty(String name, String defaultValue) {
        return this.props.getProperty(name, defaultValue);
    }

    public String getPropertiesFileName() {
        return this.fileName;
    }
}

