/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.xmi.validation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.config.FumlConfiguration;
import org.modeldriven.fuml.config.ImportAdapter;
import org.modeldriven.fuml.config.NamespaceDomain;
import org.modeldriven.fuml.config.ReferenceMappingType;
import org.modeldriven.fuml.config.ValidationExemption;
import org.modeldriven.fuml.config.ValidationExemptionType;
import org.modeldriven.fuml.environment.Environment;
import org.modeldriven.fuml.library.Library;
import org.modeldriven.fuml.repository.Class_;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.repository.Property;
import org.modeldriven.fuml.xmi.AbstractXmiNodeVisitor;
import org.modeldriven.fuml.xmi.ModelSupport;
import org.modeldriven.fuml.xmi.XmiExternalReferenceElement;
import org.modeldriven.fuml.xmi.XmiInternalReferenceElement;
import org.modeldriven.fuml.xmi.XmiNode;
import org.modeldriven.fuml.xmi.XmiNodeVisitor;
import org.modeldriven.fuml.xmi.XmiNodeVisitorStatus;
import org.modeldriven.fuml.xmi.XmiReference;
import org.modeldriven.fuml.xmi.XmiReferenceAttribute;
import org.modeldriven.fuml.xmi.stream.StreamNode;
import org.modeldriven.fuml.xmi.validation.ErrorCategory;
import org.modeldriven.fuml.xmi.validation.ErrorCode;
import org.modeldriven.fuml.xmi.validation.ErrorSeverity;
import org.modeldriven.fuml.xmi.validation.ValidationError;
import org.modeldriven.fuml.xmi.validation.ValidationErrorEvent;
import org.modeldriven.fuml.xmi.validation.ValidationEvent;
import org.modeldriven.fuml.xmi.validation.ValidationEventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationErrorCollector
extends AbstractXmiNodeVisitor
implements XmiNodeVisitor {
    private static Log log = LogFactory.getLog(ValidationErrorCollector.class);
    private List<ValidationError> errors = new ArrayList<ValidationError>();
    private boolean validateExternalReferences = true;
    private List<ValidationEventListener> eventListeners;

    private ValidationErrorCollector() {
    }

    public ValidationErrorCollector(XmiNode root) {
        this.xmiRoot = root;
        this.modelSupport = new ModelSupport();
    }

    public void validate() {
        if (this.eventListeners != null) {
            for (ValidationEventListener listener : this.eventListeners) {
                listener.validationStarted(new ValidationEvent(this));
            }
        }
        this.xmiRoot.accept(this);
        this.validateReferences();
        if (this.eventListeners != null) {
            for (ValidationEventListener listener : this.eventListeners) {
                listener.validationCompleted(new ValidationEvent(this));
            }
        }
    }

    public void addEventListener(ValidationEventListener eventListener) {
        if (this.eventListeners == null) {
            this.eventListeners = new ArrayList<ValidationEventListener>();
        }
        this.eventListeners.add(eventListener);
    }

    public void removeEventListener(ValidationEventListener eventListener) {
        if (this.eventListeners == null) {
            return;
        }
        this.eventListeners.remove(eventListener);
    }

    @Override
    public void visit(XmiNode target, XmiNode sourceXmiNode, String sourceKey, XmiNodeVisitorStatus status, int level) {
        Property property;
        Class_ sourceClassifier;
        Classifier classifier;
        if (sourceXmiNode == null && "XMI".equals(target.getLocalName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ignoring root XMI node");
            }
            return;
        }
        XmiNode source = sourceXmiNode;
        if (source != null && "XMI".equals(source.getLocalName())) {
            source = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"ignoring source XMI node");
            }
        }
        if (log.isDebugEnabled()) {
            if (source != null) {
                log.debug((Object)("visit: " + target.getLocalName() + " \t\tsource: " + source.getLocalName()));
            } else {
                log.debug((Object)("visit: " + target.getLocalName()));
            }
        }
        StreamNode eventNode = (StreamNode)target;
        if (target.getXmiId() != null) {
            if (this.nodeMap.get(target.getXmiId()) == null) {
                this.nodeMap.put(target.getXmiId(), target);
            } else {
                this.addError(ErrorCode.DUPLICATE_REFERENCE, ErrorSeverity.FATAL, eventNode);
            }
        }
        if ((classifier = this.findClassifier(target, source)) == null) {
            ImportAdapter importAdapter = FumlConfiguration.getInstance().findImportAdapter(target.getLocalName());
            if (importAdapter == null) {
                importAdapter = FumlConfiguration.getInstance().findImportAdapter(target.getXmiType());
            }
            if (source != null) {
                if (importAdapter == null) {
                    importAdapter = FumlConfiguration.getInstance().findImportAdapter(source.getLocalName());
                }
                if (importAdapter == null) {
                    importAdapter = FumlConfiguration.getInstance().findImportAdapter(source.getXmiType());
                }
            }
            if (importAdapter == null) {
                this.addError(ErrorCode.UNDEFINED_CLASS, ErrorSeverity.FATAL, eventNode);
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("identified element '" + target.getLocalName() + "' as classifier, " + classifier.getName()));
        }
        this.classifierMap.put(target, classifier);
        boolean hasAttributes = eventNode.hasAttributes();
        if (this.isPrimitiveTypeElement(eventNode, classifier, hasAttributes)) {
            return;
        }
        if (this.isInternalReferenceElement(eventNode, classifier, hasAttributes)) {
            this.references.add(new XmiInternalReferenceElement(eventNode, classifier));
            return;
        }
        if (this.isExternalReferenceElement(eventNode, classifier, hasAttributes)) {
            this.references.add(new XmiExternalReferenceElement(eventNode, classifier));
            return;
        }
        if (this.isAbstract(classifier)) {
            this.addError(ErrorCode.ABSTRACT_CLASS_INSTANTIATION, ErrorSeverity.FATAL, eventNode);
            return;
        }
        if (source != null && (sourceClassifier = (Class_)this.classifierMap.get(source)) != null && (property = sourceClassifier.findProperty(target.getLocalName())) == null) {
            NamespaceDomain domain = FumlConfiguration.getInstance().findNamespaceDomain(target.getNamespaceURI());
            ValidationExemption exemption = null;
            if (domain != null) {
                exemption = FumlConfiguration.getInstance().findValidationExemptionByProperty(ValidationExemptionType.UNDEFINED_PROPERTY, sourceClassifier, target.getLocalName(), target.getNamespaceURI(), domain);
            }
            if (exemption == null) {
                this.addError(ErrorCode.UNDEFINED_PROPERTY, ErrorSeverity.FATAL, (StreamNode)source, target.getLocalName());
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("undefined property exemption found within domain '" + exemption.getDomain().toString() + "' for property '" + sourceClassifier.getName() + "." + target.getLocalName() + "' - ignoring error"));
            }
        }
        if (eventNode.hasAttributes()) {
            this.validateAttributes(eventNode, source, (Class_)classifier, eventNode.getAttributes());
        }
        this.validateAttributesAgainstModel(eventNode, source, (Class_)classifier);
    }

    private void validateAttributes(StreamNode target, XmiNode source, Class_ classifier, Iterator<Attribute> attributes) {
        NamespaceDomain domain = null;
        while (attributes.hasNext()) {
            Attribute xmlAttrib = attributes.next();
            QName name = xmlAttrib.getName();
            String prefix = name.getPrefix();
            if (prefix != null && prefix.length() > 0 || "href".equals(name.getLocalPart())) continue;
            Property property = classifier.findProperty(name.getLocalPart());
            if (property == null) {
                ValidationExemption exemption;
                if (domain == null) {
                    domain = FumlConfiguration.getInstance().findNamespaceDomain(target.getNamespaceURI());
                }
                if ((exemption = FumlConfiguration.getInstance().findValidationExemptionByProperty(ValidationExemptionType.UNDEFINED_PROPERTY, classifier, name.getLocalPart(), target.getNamespaceURI(), domain)) == null) {
                    this.addError(ErrorCode.UNDEFINED_PROPERTY, ErrorSeverity.FATAL, target, name.getLocalPart());
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("undefined property exemption found within domain '" + exemption.getDomain().toString() + "' for property '" + classifier.getName() + "." + name.getLocalPart() + "' - ignoring error"));
                continue;
            }
            if (this.isReferenceAttribute(property)) {
                XmiReferenceAttribute reference = new XmiReferenceAttribute(target, xmlAttrib, classifier);
                this.references.add(reference);
            }
            if (!property.isDerived() || !this.checkDerivedPropertyInstantiationError(target, source, classifier, property)) continue;
            this.addError(ErrorCode.DERIVED_PROPERTY_INSTANTIATION, ErrorSeverity.FATAL, target, property.getName());
        }
    }

    private boolean checkDerivedPropertyInstantiationError(StreamNode target, XmiNode source, Classifier classifier, Property property) {
        boolean error = false;
        String value = target.getAttributeValue(property.getName());
        if (value != null && value.trim().length() > 0) {
            error = true;
        } else if (target.findChildByName(property.getName()) != null) {
            error = true;
        }
        return error;
    }

    private void validateAttributesAgainstModel(StreamNode target, XmiNode source, Class_ classifier) {
        NamespaceDomain domain = null;
        List<Property> properties = classifier.getNamedProperties();
        for (Property prop : properties) {
            ValidationExemption exemption;
            if (!prop.isRequired() || !this.checkRequiredPropertyError(target, source, classifier, prop)) continue;
            if (domain == null) {
                domain = FumlConfiguration.getInstance().findNamespaceDomain(target.getNamespaceURI());
            }
            if ((exemption = FumlConfiguration.getInstance().findValidationExemptionByProperty(ValidationExemptionType.REQUIRED_PROPERTY, classifier, prop.getName(), target.getNamespaceURI(), domain)) == null) {
                this.addError(ErrorCode.PROPERTY_REQUIRED, ErrorSeverity.FATAL, target, prop.getName());
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("required property exemption found within domain '" + exemption.getDomain().toString() + "' for property '" + classifier.getName() + "." + prop.getName() + "' - ignoring error"));
        }
    }

    private boolean checkRequiredPropertyError(StreamNode target, XmiNode source, Classifier classifier, Property property) {
        boolean error = true;
        if (property.isDerived()) {
            error = false;
            return error;
        }
        String value = target.getAttributeValue(property.getName());
        if (value != null && value.trim().length() > 0) {
            error = false;
        } else {
            String defaultValue = property.findPropertyDefault();
            if (defaultValue != null) {
                error = false;
            }
        }
        if (target.findChildByName(property.getName()) != null) {
            error = false;
        }
        if (error && FumlConfiguration.getInstance().hasReferenceMapping(classifier, property)) {
            ReferenceMappingType mappingType = FumlConfiguration.getInstance().getReferenceMappingType(classifier, property);
            if (mappingType == ReferenceMappingType.PARENT) {
                if (source.getXmiId() != null && source.getXmiId().length() > 0) {
                    error = false;
                } else {
                    log.warn((Object)("no parent XMI id found for, " + classifier.getName() + "." + property.getName()));
                }
            } else {
                log.warn((Object)("unrecognized mapping type, " + mappingType.value() + " ignoring mapping for, " + classifier.getName() + "." + property.getName()));
            }
        }
        return error;
    }

    private void validateReferences() {
        NamespaceDomain domain = null;
        for (XmiReference reference : this.references) {
            Iterator<String> refIter = reference.getXmiIds();
            while (refIter.hasNext()) {
                String id = refIter.next();
                if (reference instanceof XmiExternalReferenceElement) {
                    ValidationExemption exemption;
                    if (!this.validateExternalReferences || Library.getInstance().lookup(id) != null || id != null && id.startsWith("pathmap:")) continue;
                    StreamNode streamNode = (StreamNode)reference.getXmiNode();
                    if (domain == null) {
                        domain = FumlConfiguration.getInstance().findNamespaceDomain(streamNode.getNamespaceURI());
                    }
                    if ((exemption = FumlConfiguration.getInstance().findValidationExemptionByReference(ValidationExemptionType.EXTERNAL_REFERENCE, reference.getClassifier(), id, streamNode.getNamespaceURI(), domain)) != null) continue;
                    this.addError(ErrorCode.INVALID_EXTERNAL_REFERENCE, ErrorSeverity.FATAL, reference, id);
                    continue;
                }
                if (this.nodeMap.get(id) != null || Environment.getInstance().findElementById(id) != null) continue;
                this.addError(ErrorCode.INVALID_REFERENCE, ErrorSeverity.FATAL, reference, id);
            }
        }
    }

    private void addError(ErrorCode code, ErrorSeverity severity, StreamNode eventNode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding " + code.toString() + " error for element '" + eventNode.getLocalName() + "'"));
        }
        ValidationError error = new ValidationError(eventNode, code, severity);
        this.errors.add(error);
        if (this.eventListeners != null) {
            for (ValidationEventListener listener : this.eventListeners) {
                listener.validationError(new ValidationErrorEvent(error, this));
            }
        }
    }

    private void addError(ErrorCode code, ErrorSeverity severity, StreamNode eventNode, String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding " + code.toString() + " error for element '" + eventNode.getLocalName() + "'"));
        }
        ValidationError error = new ValidationError(eventNode, name, code, severity);
        this.errors.add(error);
        if (this.eventListeners != null) {
            for (ValidationEventListener listener : this.eventListeners) {
                listener.validationError(new ValidationErrorEvent(error, this));
            }
        }
    }

    private void addError(ErrorCode code, ErrorSeverity severity, XmiReference reference, String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("adding " + code.toString() + " error for element '" + id + "'"));
        }
        ValidationError error = new ValidationError(reference, id, code, severity);
        this.errors.add(error);
        if (this.eventListeners != null) {
            for (ValidationEventListener listener : this.eventListeners) {
                listener.validationError(new ValidationErrorEvent(error, this));
            }
        }
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public int getErrorCount() {
        return this.errors.size();
    }

    public List<ValidationError> getErrors(ErrorCode code) {
        ArrayList<ValidationError> results = new ArrayList<ValidationError>();
        for (ValidationError error : this.errors) {
            if (error.getCode().ordinal() != code.ordinal()) continue;
            results.add(error);
        }
        return results;
    }

    public int getErrorCount(ErrorCode code) {
        return this.getErrors(code).size();
    }

    public List<ValidationError> getErrors(ErrorCategory category) {
        ArrayList<ValidationError> results = new ArrayList<ValidationError>();
        for (ValidationError error : this.errors) {
            if (error.getCategory().ordinal() != category.ordinal()) continue;
            results.add(error);
        }
        return results;
    }

    public int getErrorCount(ErrorCategory category) {
        return this.getErrors(category).size();
    }

    public List<ValidationError> getErrors(ErrorSeverity severity) {
        ArrayList<ValidationError> results = new ArrayList<ValidationError>();
        for (ValidationError error : this.errors) {
            if (error.getSeverity().ordinal() != severity.ordinal()) continue;
            results.add(error);
        }
        return results;
    }

    public int getErrorCount(ErrorSeverity severity) {
        return this.getErrors(severity).size();
    }

    public boolean isValidateExternalReferences() {
        return this.validateExternalReferences;
    }

    public void setValidateExternalReferences(boolean validateExternalReferences) {
        this.validateExternalReferences = validateExternalReferences;
    }
}

