/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.xmi.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javanet.staxutils.events.EventAllocator;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.xmi.XmiException;
import org.modeldriven.fuml.xmi.XmiReader;
import org.modeldriven.fuml.xmi.stream.StreamContext;
import org.modeldriven.fuml.xmi.stream.StreamNode;
import org.modeldriven.fuml.xmi.stream.StreamNodeEvent;
import org.modeldriven.fuml.xmi.stream.StreamNodeListener;

public class StreamReader
implements XmiReader {
    private static Log log = LogFactory.getLog(StreamReader.class);
    private Stack<StreamNode> nodes = new Stack();
    private Map<String, List<StreamNodeListener>> streamNodeListenerMap;
    private static XMLEventAllocator allocator = null;

    public Collection read(InputStream stream) {
        ArrayList<StreamNode> results = new ArrayList<StreamNode>();
        InputStream source = stream;
        StreamContext context = null;
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setXMLResolver(new XMLResolver(){

                public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                    return null;
                }
            });
            factory.setEventAllocator((XMLEventAllocator)new EventAllocator());
            allocator = factory.getEventAllocator();
            XMLStreamReader streamReader = factory.createXMLStreamReader(stream);
            int eventType = streamReader.getEventType();
            StreamNode node = null;
            StreamNode parent = null;
            int level = 0;
            int ignoredNodeLevel = -1;
            block14: while (streamReader.hasNext()) {
                eventType = streamReader.next();
                switch (eventType) {
                    case 1: {
                        String msg;
                        Location loc;
                        ++level;
                        if (ignoredNodeLevel >= 0) break;
                        XMLEvent event = StreamReader.allocateXMLEvent(streamReader);
                        if (level == 1) {
                            if (context != null) {
                                throw new XmiException("existing context unexpected");
                            }
                            context = new StreamContext(event);
                        }
                        if ((node = new StreamNode(event, context)).isIgnored()) {
                            if (log.isDebugEnabled()) {
                                loc = event.getLocation();
                                msg = "start ignoring elements - level:  " + String.valueOf(level) + " - line:col[" + loc.getLineNumber() + ":" + loc.getColumnNumber() + "] - ";
                                log.debug((Object)msg);
                            }
                            ignoredNodeLevel = level;
                            break;
                        }
                        this.logEventInfo(event);
                        parent = null;
                        if (this.nodes.size() > 0) {
                            parent = this.nodes.peek();
                            parent.add(node);
                            node.setParent(parent);
                            if (this.isRootNode(node, context)) {
                                results.add(node);
                            }
                        } else if (this.isRootNode(node, context)) {
                            results.add(node);
                        }
                        this.nodes.push(node);
                        this.fireStreamNodeCreated(node, parent);
                        break;
                    }
                    case 2: {
                        String msg;
                        Location loc;
                        XMLEvent event;
                        if (ignoredNodeLevel >= 0) {
                            if (ignoredNodeLevel == level) {
                                if (log.isDebugEnabled()) {
                                    event = StreamReader.allocateXMLEvent(streamReader);
                                    loc = event.getLocation();
                                    msg = "end ignoring elements - level:  " + String.valueOf(level) + " - line:col[" + loc.getLineNumber() + ":" + loc.getColumnNumber() + "] - ";
                                    log.debug((Object)msg);
                                }
                                ignoredNodeLevel = -1;
                            }
                            --level;
                            break;
                        }
                        --level;
                        node = this.nodes.pop();
                        parent = null;
                        if (this.nodes.size() > 0) {
                            parent = this.nodes.peek();
                        }
                        this.fireStreamNodeCompleted(node, parent);
                        break;
                    }
                    case 4: {
                        if (ignoredNodeLevel >= 0) break;
                        node = this.nodes.peek();
                        XMLEvent event = StreamReader.allocateXMLEvent(streamReader);
                        String data = event.asCharacters().getData();
                        if (data == null || (data = data.trim()).length() <= 0) continue block14;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("CHARACTERS: '" + data + "'"));
                        }
                        if (data.length() <= 0) continue block14;
                        node = this.nodes.peek();
                        node.addCharactersEvent(event);
                        break;
                    }
                    default: {
                        if (!log.isDebugEnabled()) continue block14;
                        XMLEvent event = StreamReader.allocateXMLEvent(streamReader);
                        this.logEventInfo(event);
                    }
                }
            }
            if (results.size() > 1) {
                throw new XmiException("found multiple root nodes (" + results.size() + ")");
            }
        }
        catch (XMLStreamException e) {
            throw new XmiException(e);
        }
        finally {
            try {
                source.close();
            }
            catch (IOException e) {}
        }
        return results;
    }

    private void fireStreamNodeCreated(StreamNode node, StreamNode parent) {
        List<StreamNodeListener> list;
        if (this.streamNodeListenerMap != null && (list = this.streamNodeListenerMap.get(node.getLocalName())) != null) {
            for (StreamNodeListener listener : list) {
                listener.nodeCreated(new StreamNodeEvent(node, parent));
            }
        }
    }

    private void fireStreamNodeCompleted(StreamNode node, StreamNode parent) {
        List<StreamNodeListener> list;
        if (this.streamNodeListenerMap != null && (list = this.streamNodeListenerMap.get(node.getLocalName())) != null) {
            for (StreamNodeListener listener : list) {
                listener.nodeCompleted(new StreamNodeEvent(node, parent));
            }
        }
    }

    private boolean isRootNode(StreamNode node, StreamContext context) {
        QName name = node.getStartElementEvent().asStartElement().getName();
        return name.getNamespaceURI().equals(context.getUmlNamespace().getNamespaceURI()) && "Model".equalsIgnoreCase(name.getLocalPart());
    }

    private void logEventInfo(XMLEvent event) {
        if (log.isDebugEnabled()) {
            Location loc = event.getLocation();
            String msg = StreamReader.getEventTypeString(event.getEventType());
            msg = msg + " line:col[" + loc.getLineNumber() + ":" + loc.getColumnNumber() + "] - ";
            msg = msg + event.toString();
            log.debug((Object)msg);
        }
    }

    private static XMLEvent allocateXMLEvent(XMLStreamReader reader) throws XMLStreamException {
        return allocator.allocate(reader);
    }

    public static final String getEventTypeString(int eventType) {
        switch (eventType) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
            case 6: {
                return "SPACE";
            }
        }
        return "UNKNOWN_EVENT_TYPE , " + eventType;
    }

    public void addStreamNodeListener(StreamNodeListener listener) {
        if (this.streamNodeListenerMap == null) {
            this.streamNodeListenerMap = new HashMap<String, List<StreamNodeListener>>();
        }
        String[] names = listener.getElementNames();
        for (int i = 0; i < names.length; ++i) {
            List<StreamNodeListener> list = this.streamNodeListenerMap.get(names[i]);
            if (list == null) {
                list = new ArrayList<StreamNodeListener>();
                this.streamNodeListenerMap.put(names[i], list);
            }
            list.add(listener);
        }
    }
}

