/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.xmi;

import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.events.Attribute;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.xmi.XmiException;
import org.modeldriven.fuml.xmi.XmiNode;
import org.modeldriven.fuml.xmi.XmiReference;
import org.modeldriven.fuml.xmi.XmiReferenceElement;
import org.modeldriven.fuml.xmi.stream.StreamNode;

public class XmiInternalReferenceElement
extends XmiReferenceElement
implements XmiReference {
    private static Log log = LogFactory.getLog(XmiInternalReferenceElement.class);

    public XmiInternalReferenceElement(XmiNode node, Classifier classifier) {
        super(node, classifier);
        this.construct();
    }

    private void construct() {
        String data = this.node.getData();
        if (data != null) {
            StringTokenizer st = new StringTokenizer(data);
            if (!st.hasMoreElements()) {
                throw new XmiException("one or more id's expected");
            }
            while (st.hasMoreElements()) {
                String ref = st.nextToken();
                this.ids.add(ref);
            }
        } else {
            StreamNode eventNode = (StreamNode)this.node;
            QName name = new QName(eventNode.getContext().getXmiNamespace().getNamespaceURI(), "idref");
            Attribute idref = eventNode.getAttribute(name);
            if (idref != null) {
                this.ids.add(idref.getValue());
            } else {
                throw new XmiException("expected character data or idref attribute for element, " + eventNode.getLocalName());
            }
        }
    }
}

