/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.xmi;

import fUML.Syntax.Classes.Kernel.Enumeration;
import fUML.Syntax.Classes.Kernel.PrimitiveType;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.repository.Class_;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.repository.Property;
import org.modeldriven.fuml.repository.Repository;
import org.modeldriven.fuml.xmi.XmiException;
import org.modeldriven.fuml.xmi.XmiNode;
import org.modeldriven.fuml.xmi.stream.StreamNode;

public class ModelSupport {
    private static Log log = LogFactory.getLog(ModelSupport.class);

    public Classifier findClassifier(XmiNode target) {
        String name = target.getXmiType();
        if (name == null || name.trim().length() == 0) {
            name = target.getLocalName();
        }
        return this.findClassifierByNamespace(target, name);
    }

    public Classifier findClassifier(XmiNode target, Class_ sourceClassifier) {
        Classifier result = null;
        String xmiType = target.getXmiType();
        if (xmiType != null && xmiType.length() > 0) {
            return this.findClassifierByNamespace(target, xmiType);
        }
        Property property = sourceClassifier.findProperty(target.getLocalName());
        if (property != null) {
            Classifier type = property.getType();
            result = Repository.INSTANCE.getClassifier(type.getName());
        }
        return result;
    }

    private Classifier findClassifierByNamespace(XmiNode target, String name) {
        String qualifiedName;
        Classifier result;
        String uri = target.getNamespaceURI();
        if (uri == null || uri.length() == 0) {
            throw new XmiException("no namespace URI found for '" + name + "'");
        }
        if (target.getPrefix() != null) {
            uri = target.getNamespaceURI();
        }
        if ((result = Repository.INSTANCE.findClassifier(qualifiedName = uri + "#" + name)) == null) {
            qualifiedName = Repository.INSTANCE.getDefaultUMLNamespaceURI() + "#" + name;
            result = Repository.INSTANCE.findClassifier(qualifiedName);
        }
        return result;
    }

    public boolean isPrimitiveTypeElement(XmiNode node, Classifier classifier, boolean hasAttributes) {
        boolean result = false;
        if (PrimitiveType.class.isAssignableFrom(classifier.getDelegate().getClass())) {
            if (node.getNodes() != null && node.getNodes().size() > 0) {
                log.warn((Object)("found child nodes(s) under primitive type, " + classifier.getName()));
            }
            if (hasAttributes) {
                log.warn((Object)("found attribute(s) for primitive type, " + classifier.getName()));
            }
            result = true;
        }
        return result;
    }

    public boolean isInternalReferenceElement(XmiNode node, Classifier classifier, boolean hasAttributes) {
        boolean result = false;
        if (!this.isPrimitiveTypeElement(node, classifier, hasAttributes)) {
            if (node.hasCharacters()) {
                if (hasAttributes) {
                    log.warn((Object)("found attribute(s) for characters node of type, " + classifier.getName()));
                }
                result = true;
            } else {
                StreamNode eventNode = (StreamNode)node;
                QName idref = new QName(eventNode.getContext().getXmiNamespace().getNamespaceURI(), "idref");
                if (node.hasAttribute(idref)) {
                    return true;
                }
            }
        }
        return result;
    }

    public boolean isExternalReferenceElement(XmiNode node, Classifier classifier, boolean hasAttributes) {
        boolean result = false;
        if (!this.isPrimitiveTypeElement(node, classifier, hasAttributes)) {
            StreamNode eventNode = (StreamNode)node;
            QName href = new QName("href");
            if (node.hasAttribute(href)) {
                String hrefValue = node.getAttributeValue(href);
                if (hrefValue == null) {
                    return true;
                }
                int idx = hrefValue.lastIndexOf("#");
                String suffix = hrefValue.substring(idx + 1);
                return !suffix.equals("Integer") && !suffix.equals("String") && !suffix.equals("Boolean") && !suffix.equals("UnlimitedNatural");
            }
        }
        return result;
    }

    public boolean isReferenceAttribute(Property property) {
        Classifier typeClassifier = property.getType();
        return !PrimitiveType.class.isAssignableFrom(typeClassifier.getDelegate().getClass()) && !Enumeration.class.isAssignableFrom(typeClassifier.getDelegate().getClass());
    }
}

