/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.library.unlimitednaturalfunctions;

import UMLPrimitiveTypes.UnlimitedNatural;
import fUML.Debug;
import fUML.Semantics.Classes.Kernel.UnlimitedNaturalValue;
import fUML.Semantics.Classes.Kernel.Value;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.OpaqueBehaviorExecution;
import fUML.Semantics.CommonBehaviors.BasicBehaviors.ParameterValueList;
import org.modeldriven.fuml.library.LibraryFunctions;

public abstract class UnlimitedNaturalFunctionBehaviorExecution
extends OpaqueBehaviorExecution {
    public void doBody(ParameterValueList inputParameters, ParameterValueList outputParameters) {
        if (inputParameters.size() != 2) {
            Debug.println("[doBody] ERROR: expected 2 input args, received " + inputParameters.size());
            throw new IllegalArgumentException("invalid number of arguments");
        }
        UnlimitedNaturalValue unv1 = (UnlimitedNaturalValue)inputParameters.getValue((int)0).values.getValue(0);
        UnlimitedNatural un1 = unv1.value;
        if (un1.naturalValue == -1) {
            Debug.println("[doBody] argument = unbounded(-1)");
        } else {
            Debug.println("[doBody] argument = " + un1.naturalValue);
        }
        if (un1.naturalValue < -1) {
            Debug.println("[doBody] invalid UnlimitedNatural value (throwing exception) = " + un1.naturalValue);
            throw new IllegalArgumentException("UnlimitedNatural cannot be less than -1, where -1 specifies unbounded");
        }
        UnlimitedNaturalValue unv2 = (UnlimitedNaturalValue)inputParameters.getValue((int)1).values.getValue(0);
        UnlimitedNatural un2 = unv2.value;
        if (un2.naturalValue == -1) {
            Debug.println("[doBody] argument = unbounded(-1)");
        } else {
            Debug.println("[doBody] argument = " + un2.naturalValue);
        }
        if (un2.naturalValue < -1) {
            Debug.println("[doBody] invalid UnlimitedNatural value (throwing exception) = " + un1.naturalValue);
            throw new IllegalArgumentException("UnlimitedNatural cannot be less than -1, where -1 specifies unbounded");
        }
        Value resultObj = this.doUnlimitedNaturalFunction(un1, un2);
        if (resultObj == null) {
            LibraryFunctions.addEmptyValueListToOutputList(outputParameters);
        } else {
            LibraryFunctions.addValueToOutputList(resultObj, outputParameters);
        }
    }

    public abstract Value doUnlimitedNaturalFunction(UnlimitedNatural var1, UnlimitedNatural var2);
}

