/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.config;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.modeldriven.fuml.FumlException;
import org.modeldriven.fuml.FumlSystemProperty;
import org.modeldriven.fuml.bind.DefaultValidationEventHandler;
import org.modeldriven.fuml.config.BehaviorExecutionMapping;
import org.modeldriven.fuml.config.Configuration;
import org.modeldriven.fuml.config.FumlConfigDataBinding;
import org.modeldriven.fuml.config.ImportAdapter;
import org.modeldriven.fuml.config.ImportExemption;
import org.modeldriven.fuml.config.NamespaceDomain;
import org.modeldriven.fuml.config.ReferenceMapping;
import org.modeldriven.fuml.config.ReferenceMappingType;
import org.modeldriven.fuml.config.SupportedNamespace;
import org.modeldriven.fuml.config.ValidationExemption;
import org.modeldriven.fuml.config.ValidationExemptionType;
import org.modeldriven.fuml.repository.Classifier;
import org.modeldriven.fuml.repository.Property;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FumlConfiguration {
    private static Log log = LogFactory.getLog(FumlConfiguration.class);
    private static FumlConfiguration instance = null;
    private static String defaultConfigFileName = "DefaultFumlConfig.xml";
    private Map<String, BehaviorExecutionMapping> executions = new HashMap<String, BehaviorExecutionMapping>();
    private Map<String, ImportExemption> importExemptions = new HashMap<String, ImportExemption>();
    private Map<String, ImportAdapter> importAdapters = new HashMap<String, ImportAdapter>();
    private Map<String, List<ValidationExemption>> validationExemptions = new HashMap<String, List<ValidationExemption>>();
    private String activeConfigFileName;
    private Configuration config;

    private FumlConfiguration() {
        log.info((Object)"initializing...");
        try {
            FumlConfigDataBinding configBinding = new FumlConfigDataBinding(new DefaultValidationEventHandler());
            this.activeConfigFileName = System.getProperty(FumlSystemProperty.CONFIG.getProperty(), defaultConfigFileName);
            log.info((Object)("loading configuration, " + this.activeConfigFileName));
            this.config = this.unmarshalConfig(this.activeConfigFileName, configBinding);
            if (this.config.getMappingConfiguration().getBehaviorExecutionMapping() != null) {
                for (BehaviorExecutionMapping mapping : this.config.getMappingConfiguration().getBehaviorExecutionMapping()) {
                    this.executions.put(mapping.getClassName(), mapping);
                    Class.forName(mapping.getExecutionClassName());
                }
            }
            if (this.config.getImportConfiguration().getExemption() != null) {
                for (ImportExemption e : this.config.getImportConfiguration().getExemption()) {
                    this.importExemptions.put(e.getLocalName(), e);
                }
            }
            if (this.config.getImportConfiguration().getAdapter() != null) {
                for (ImportAdapter adapter : this.config.getImportConfiguration().getAdapter()) {
                    this.importAdapters.put(adapter.getClassName(), adapter);
                }
            }
            if (this.config.getValidationConfiguration().getExemption() != null) {
                for (ValidationExemption exemption : this.config.getValidationConfiguration().getExemption()) {
                    List<ValidationExemption> list = this.validationExemptions.get(exemption.getClassifierName());
                    if (list == null) {
                        list = new ArrayList<ValidationExemption>();
                        this.validationExemptions.put(exemption.getClassifierName(), list);
                    }
                    list.add(exemption);
                }
            }
        }
        catch (SAXException e) {
            throw new FumlException(e);
        }
        catch (JAXBException e) {
            throw new FumlException(e);
        }
        catch (ClassNotFoundException e) {
            throw new FumlException(e);
        }
    }

    private Configuration unmarshalConfig(String configFileName, FumlConfigDataBinding binding) {
        try {
            InputStream stream = FumlConfiguration.class.getClassLoader().getResourceAsStream(configFileName);
            if (stream == null) {
                stream = FumlConfiguration.class.getResourceAsStream(configFileName);
            }
            if (stream == null) {
                throw new FumlException("cannot find resource '" + configFileName + "' on current classpath");
            }
            JAXBElement root = (JAXBElement)binding.validate(stream);
            Configuration result = (Configuration)root.getValue();
            return result;
        }
        catch (UnmarshalException e) {
            throw new FumlException(e);
        }
        catch (JAXBException e) {
            throw new FumlException(e);
        }
    }

    public static FumlConfiguration getInstance() throws FumlException {
        if (instance == null) {
            FumlConfiguration.initializeInstance();
        }
        return instance;
    }

    private static synchronized void initializeInstance() throws FumlException {
        if (instance == null) {
            instance = new FumlConfiguration();
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public String[] getSupportedNamespaceURIsForDomain(NamespaceDomain domain) {
        ArrayList<String> list = new ArrayList<String>();
        for (SupportedNamespace namespace : this.getConfig().getImportConfiguration().getSupportedNamespace()) {
            if (!namespace.getDomain().value().equals(domain.value())) continue;
            list.add(namespace.getUri());
        }
        String[] results = new String[list.size()];
        list.toArray(results);
        return results;
    }

    public NamespaceDomain getNamespaceDomain(String namespaceUri) {
        NamespaceDomain result = this.findNamespaceDomain(namespaceUri);
        if (result == null) {
            throw new FumlException("no namespace domain found for URI '" + namespaceUri + "' - please add this URI to the set of supported namespaces for the appropriate domain");
        }
        return result;
    }

    public NamespaceDomain findNamespaceDomain(String namespaceUri) {
        for (SupportedNamespace namespace : this.getConfig().getImportConfiguration().getSupportedNamespace()) {
            if (!namespace.getUri().equals(namespaceUri)) continue;
            return namespace.getDomain();
        }
        return null;
    }

    public boolean hasReferenceMapping(Classifier classifier, Property property) {
        for (ReferenceMapping mapping : this.getConfig().getMappingConfiguration().getReferenceMapping()) {
            if (!mapping.getClassName().equals(classifier.getName()) || !mapping.getPropertyName().equals(property.getName())) continue;
            return true;
        }
        return false;
    }

    public ReferenceMappingType getReferenceMappingType(Classifier classifier, Property property) {
        for (ReferenceMapping mapping : this.getConfig().getMappingConfiguration().getReferenceMapping()) {
            if (!mapping.getClassName().equals(classifier.getName()) || !mapping.getPropertyName().equals(property.getName())) continue;
            return mapping.getType();
        }
        throw new FumlException("no mapping found for, " + classifier.getName() + "." + property.getName());
    }

    public String findExecutionClassName(String name) {
        BehaviorExecutionMapping mapping = this.executions.get(name);
        if (mapping != null) {
            return mapping.getExecutionClassName();
        }
        return null;
    }

    public String getActiveConfigFileName() {
        return this.activeConfigFileName;
    }

    public ImportExemption findImportExemptionByElement(String localName) {
        return this.importExemptions.get(localName);
    }

    public ImportAdapter findImportAdapter(String name) {
        return this.importAdapters.get(name);
    }

    public List<ValidationExemption> findValidationExemptionByClassifierName(String classifierName) {
        return this.validationExemptions.get(classifierName);
    }

    public ValidationExemption findValidationExemptionByProperty(ValidationExemptionType type, Classifier classifier, String propertyName, String namespaceURI, NamespaceDomain domain) {
        ValidationExemption result = null;
        if (domain != null) {
            List<ValidationExemption> exemptions = this.findValidationExemptionByClassifierName(classifier.getName());
            if (exemptions != null) {
                for (ValidationExemption exemption : exemptions) {
                    if (exemption.getPropertyName() == null || !exemption.getPropertyName().equals(propertyName) || exemption.getDomain().ordinal() != domain.ordinal() || exemption.getType().ordinal() != type.ordinal()) continue;
                    result = exemption;
                    break;
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"could not lookup validation exemption for namespace URI 'namespaceURI");
        }
        return result;
    }

    public ValidationExemption findValidationExemptionByReference(ValidationExemptionType type, Classifier classifier, String reference, String namespaceURI, NamespaceDomain domain) {
        ValidationExemption result = null;
        if (domain != null) {
            List<ValidationExemption> exemptions = this.findValidationExemptionByClassifierName(classifier.getName());
            if (exemptions != null) {
                for (ValidationExemption exemption : exemptions) {
                    if (!exemption.getHref().equals(reference) || exemption.getDomain().ordinal() != domain.ordinal() || exemption.getType().ordinal() != type.ordinal()) continue;
                    result = exemption;
                    break;
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"could not lookup validation exemption for namespace URI 'namespaceURI");
        }
        return result;
    }
}

