/*
 * Decompiled with CFR 0.152.
 */
package org.modeldriven.fuml.common.uuid;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.GregorianCalendar;
import org.modeldriven.fuml.common.uuid.MalformedUUIDException;

public class UUID
implements Serializable,
Comparable {
    private static byte[] node = null;
    private static long lastTime = 0L;
    private static long gregorianChange = new GregorianCalendar().getGregorianChange().getTime();
    private static SecureRandom random = null;
    private static int count = 0;
    private static final int SEED_SIZE = 24;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '_', '$'};
    private byte[] uuid;

    private static void initNode() {
        if (node == null) {
            File file = null;
            node = new byte[6];
            try {
                file = new File(System.getProperty("java.home"), "uuid.node");
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (file != null) {
                try {
                    FileInputStream in = new FileInputStream(file);
                    if (in.read(node) == node.length) {
                        random = new SecureRandom(node);
                        FileInputStream seed_in = null;
                        try {
                            byte[] seed = new byte[24];
                            File seed_file = new File(System.getProperty("java.home"), "uuid.seed");
                            seed_in = new FileInputStream(seed_file);
                            if (in.read(seed) == seed.length) {
                                random.setSeed(seed);
                            } else {
                                random.setSeed(System.currentTimeMillis());
                            }
                        }
                        catch (Exception ex) {
                            random.setSeed(System.currentTimeMillis());
                        }
                    }
                    in.close();
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (random == null) {
                random = new SecureRandom();
                random.nextInt();
                random.nextBytes(node);
                node[0] = (byte)(node[0] | 0xFFFFFF80);
                if (file != null) {
                    try {
                        FileOutputStream out = new FileOutputStream(file);
                        out.write(node);
                        out.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static void get16Bytes(byte[] src, char[] buf, int dst, int from, int to) {
        int i = from;
        while (i < to) {
            int b = src[i];
            int j = 0;
            int charPos = dst + 1;
            while (j < 2) {
                buf[charPos] = digits[b & 0xF];
                b >>>= 4;
                ++j;
                --charPos;
            }
            ++i;
            dst += 2;
        }
    }

    private static void get64Bytes(char[] buf, int dst, long n) {
        int i = 0;
        int charPos = dst + 10;
        while (i < 11) {
            buf[charPos] = digits[(int)(n & 0x3FL)];
            ++i;
            --charPos;
            n >>>= 6;
        }
    }

    public static String toString(byte[] uuid) {
        char[] buf = new char[36];
        UUID.get16Bytes(uuid, buf, 0, 0, 4);
        buf[8] = 45;
        UUID.get16Bytes(uuid, buf, 9, 4, 6);
        buf[13] = 45;
        UUID.get16Bytes(uuid, buf, 14, 6, 8);
        buf[18] = 45;
        UUID.get16Bytes(uuid, buf, 19, 8, 10);
        buf[23] = 45;
        UUID.get16Bytes(uuid, buf, 24, 10, 16);
        return new String(buf);
    }

    public static String to64String(byte[] uuid) {
        char[] buf = new char[22];
        long l = (long)uuid[0] << 56 | (long)uuid[1] << 56 >>> 8 | (long)uuid[2] << 56 >>> 16 | (long)uuid[3] << 56 >>> 24 | (long)uuid[4] << 56 >>> 32 | (long)uuid[5] << 56 >>> 40 | (long)uuid[6] << 56 >>> 48 | (long)uuid[7] << 56 >>> 56;
        UUID.get64Bytes(buf, 0, l);
        l = (long)uuid[8] << 56 | (long)uuid[9] << 56 >>> 8 | (long)uuid[10] << 56 >>> 16 | (long)uuid[11] << 56 >>> 24 | (long)uuid[12] << 56 >>> 32 | (long)uuid[13] << 56 >>> 40 | (long)uuid[14] << 56 >>> 48 | (long)uuid[15] << 56 >>> 56;
        UUID.get64Bytes(buf, 11, l);
        return new String(buf);
    }

    public static long getCreationTime(byte[] uuid) throws MalformedUUIDException {
        if (uuid.length != 16) {
            throw new MalformedUUIDException("data is not 16 bytes long");
        }
        long creationTime = (long)(uuid[0] < 0 ? uuid[0] + 256 : uuid[0]) << 24 | (long)(uuid[1] < 0 ? uuid[1] + 256 : uuid[1]) << 16 | (long)(uuid[2] < 0 ? uuid[2] + 256 : uuid[2]) << 8 | (long)(uuid[3] < 0 ? uuid[3] + 256 : uuid[3]) | (long)(uuid[4] < 0 ? uuid[4] + 256 : uuid[4]) << 40 | (long)(uuid[5] < 0 ? uuid[5] + 256 : uuid[5]) << 32 | (long)(uuid[6] & 0xF) << 56 | (long)(uuid[7] < 0 ? uuid[7] + 256 : uuid[7]) << 48;
        creationTime /= 10000L;
        return creationTime += gregorianChange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID() {
        byte[] clockSequence = new byte[2];
        long currentTime = 0L;
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (node == null) {
                UUID.initNode();
            }
        }
        currentTime = System.currentTimeMillis();
        currentTime -= gregorianChange;
        currentTime *= 10000L;
        random.nextBytes(clockSequence);
        int timeLow = (int)((currentTime += (long)count++) & 0xFFFFFFFFL);
        short timeMid = (short)(currentTime >>> 32 & 0xFFFFL);
        short timeHi = (short)(currentTime >>> 48 & 0xFFFFL);
        this.uuid = new byte[16];
        this.uuid[0] = (byte)(timeLow >>> 24 & 0xFF);
        this.uuid[1] = (byte)(timeLow >>> 16 & 0xFF);
        this.uuid[2] = (byte)(timeLow >>> 8 & 0xFF);
        this.uuid[3] = (byte)(timeLow & 0xFF);
        this.uuid[4] = (byte)(timeMid >>> 8 & 0xFF);
        this.uuid[5] = (byte)(timeMid & 0xFF);
        this.uuid[6] = (byte)(timeHi >>> 8 & 0xFF);
        this.uuid[7] = (byte)(timeHi & 0xFF);
        this.uuid[8] = clockSequence[0];
        this.uuid[9] = clockSequence[1];
        this.uuid[10] = node[0];
        this.uuid[11] = node[1];
        this.uuid[12] = node[2];
        this.uuid[13] = node[3];
        this.uuid[14] = node[4];
        this.uuid[15] = node[5];
        this.uuid[6] = (byte)(0x10 | this.uuid[6] & 0xF);
        this.uuid[8] = (byte)(this.uuid[8] | 0xFFFFFF80);
    }

    public UUID(byte[] data) throws MalformedUUIDException {
        if (data.length != 16) {
            throw new MalformedUUIDException("data is not 16 bytes long");
        }
        this.uuid = new byte[16];
        System.arraycopy(data, 0, this.uuid, 0, 16);
    }

    public UUID(String id) throws MalformedUUIDException {
        int len = id.length();
        switch (len) {
            case 22: {
                char[] data = id.toCharArray();
                this.uuid = new byte[16];
                this.read64Bytes(data, 0, this.uuid, 0);
                this.read64Bytes(data, 11, this.uuid, 8);
                break;
            }
            case 36: {
                char[] data = id.toCharArray();
                this.verifyDash(data, 8);
                this.verifyDash(data, 13);
                this.verifyDash(data, 18);
                this.verifyDash(data, 23);
                this.uuid = new byte[16];
                this.read16Bytes(data, 0, this.uuid, 0, 4);
                this.read16Bytes(data, 9, this.uuid, 4, 2);
                this.read16Bytes(data, 14, this.uuid, 6, 2);
                this.read16Bytes(data, 19, this.uuid, 8, 2);
                this.read16Bytes(data, 24, this.uuid, 10, 6);
                break;
            }
            default: {
                throw new MalformedUUIDException("'" + id + "' is not 36 or 22 bytes long");
            }
        }
    }

    public void saveSeedData() {
        FileOutputStream seed_out = null;
        try {
            if (random == null) {
                return;
            }
            byte[] seed = new byte[24];
            random.nextBytes(seed);
            File seed_file = new File(System.getProperty("java.home"), "uuid.seed");
            seed_out = new FileOutputStream(seed_file);
            seed_out.write(seed);
            seed_out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return UUID.toString(this.uuid);
    }

    public String to64String() {
        return UUID.to64String(this.uuid);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof UUID) {
            UUID u = (UUID)o;
            for (int i = 0; i < this.uuid.length; ++i) {
                if (this.uuid[i] == u.uuid[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object o) {
        byte[] uuid = ((UUID)o).getData();
        for (int i = 0; i < 16; ++i) {
            byte b = this.uuid[i];
            byte ub = uuid[i];
            if (b < ub) {
                return -1;
            }
            if (b <= ub) continue;
            return 1;
        }
        return 0;
    }

    public byte[] getData() {
        return this.uuid;
    }

    private void read16Bytes(char[] data, int from, byte[] bytes, int to, int length) throws MalformedUUIDException {
        for (int i = 0; i < length; ++i) {
            int c1 = this.c16Value(data[from++]);
            int c2 = this.c16Value(data[from++]);
            bytes[to++] = (byte)((c1 << 4) + c2);
        }
    }

    private int c16Value(char c) throws MalformedUUIDException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new MalformedUUIDException("'" + c + "' is not a base 16 digit");
    }

    private void read64Bytes(char[] data, int from, byte[] bytes, int to) throws MalformedUUIDException {
        int i;
        long l = 0L;
        for (i = 0; i < 11; ++i) {
            l = (l << 6) + this.c64Value(data[from++]);
        }
        i = 8;
        while (i > 0) {
            bytes[to + --i] = (byte)(l & 0xFFL);
            l >>>= 8;
        }
    }

    private long c64Value(char c) throws MalformedUUIDException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 65 + 10 + 26;
        }
        if (c == '_') {
            return 62L;
        }
        if (c == '$') {
            return 63L;
        }
        throw new MalformedUUIDException("'" + c + "' is not a base 64 digit");
    }

    private void verifyDash(char[] data, int index) throws MalformedUUIDException {
        if (data[index] != '-') {
            throw new MalformedUUIDException("no '-' at position " + index);
        }
    }
}

