/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Classes.Kernel;

import fUML.Debug;
import fUML.Semantics.Classes.Kernel.DataValue;
import fUML.Semantics.Classes.Kernel.EnumerationValue;
import fUML.Semantics.Classes.Kernel.Evaluation;
import fUML.Semantics.Classes.Kernel.Object_;
import fUML.Semantics.Classes.Kernel.Reference;
import fUML.Semantics.Classes.Kernel.StructuredValue;
import fUML.Semantics.Classes.Kernel.Value;
import fUML.Semantics.Classes.Kernel.ValueList;
import fUML.Syntax.Classes.Kernel.Class_;
import fUML.Syntax.Classes.Kernel.Classifier;
import fUML.Syntax.Classes.Kernel.ClassifierList;
import fUML.Syntax.Classes.Kernel.DataType;
import fUML.Syntax.Classes.Kernel.Enumeration;
import fUML.Syntax.Classes.Kernel.EnumerationLiteral;
import fUML.Syntax.Classes.Kernel.InstanceSpecification;
import fUML.Syntax.Classes.Kernel.InstanceValue;
import fUML.Syntax.Classes.Kernel.Slot;
import fUML.Syntax.Classes.Kernel.SlotList;
import fUML.Syntax.Classes.Kernel.ValueSpecification;
import fUML.Syntax.Classes.Kernel.ValueSpecificationList;
import fUML.Syntax.CommonBehaviors.BasicBehaviors.Behavior;

public class InstanceValueEvaluation
extends Evaluation {
    public Value evaluate() {
        Value value;
        InstanceSpecification instance = ((InstanceValue)this.specification).instance;
        ClassifierList types = instance.classifier;
        Classifier myType = types.getValue(0);
        Debug.println("[evaluate] type = " + myType.name);
        if (instance instanceof EnumerationLiteral) {
            EnumerationValue enumerationValue = new EnumerationValue();
            enumerationValue.type = (Enumeration)myType;
            enumerationValue.literal = (EnumerationLiteral)instance;
            value = enumerationValue;
        } else {
            StructuredValue structuredValue = null;
            if (myType instanceof DataType) {
                DataValue dataValue = new DataValue();
                dataValue.type = (DataType)myType;
                structuredValue = dataValue;
            } else {
                Object_ object = null;
                if (myType instanceof Behavior) {
                    object = this.locus.factory.createExecution((Behavior)myType, null);
                } else {
                    object = new Object_();
                    for (int i = 0; i < types.size(); ++i) {
                        Classifier type = types.getValue(i);
                        object.types.addValue((Class_)type);
                    }
                }
                this.locus.add(object);
                Reference reference = new Reference();
                reference.referent = object;
                structuredValue = reference;
            }
            structuredValue.createFeatureValues();
            SlotList instanceSlots = instance.slot;
            for (int i = 0; i < instanceSlots.size(); ++i) {
                Slot slot = instanceSlots.getValue(i);
                ValueList values = new ValueList();
                ValueSpecificationList slotValues = slot.value;
                for (int j = 0; j < slotValues.size(); ++j) {
                    ValueSpecification slotValue = slotValues.getValue(j);
                    values.addValue(this.locus.executor.evaluate(slotValue));
                }
                structuredValue.setFeatureValue(slot.definingFeature, values, 0);
            }
            value = structuredValue;
        }
        return value;
    }
}

