/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Activities.IntermediateActivities;

import fUML.Semantics.Activities.IntermediateActivities.ActivityNodeActivation;
import fUML.Semantics.Activities.IntermediateActivities.ObjectToken;
import fUML.Semantics.Activities.IntermediateActivities.Token;
import fUML.Semantics.Activities.IntermediateActivities.TokenList;

public abstract class ObjectNodeActivation
extends ActivityNodeActivation {
    public int offeredTokenCount = 0;

    public void run() {
        super.run();
        this.offeredTokenCount = 0;
    }

    public void sendOffers(TokenList tokens) {
        if (tokens.size() == 0) {
            tokens.addValue(new ObjectToken());
        }
        super.sendOffers(tokens);
    }

    public void terminate() {
        this.clearTokens();
        super.terminate();
    }

    public void addToken(Token token) {
        if (token.getValue() == null) {
            token.withdraw();
        } else {
            super.addToken(token);
        }
    }

    public int removeToken(Token token) {
        int i = super.removeToken(token);
        if (i > 0 & i <= this.offeredTokenCount) {
            --this.offeredTokenCount;
        }
        return i;
    }

    public void clearTokens() {
        super.clearTokens();
        this.offeredTokenCount = 0;
    }

    public int countOfferedValues() {
        int totalValueCount = 0;
        for (int i = 1; i <= this.incomingEdges.size(); ++i) {
            totalValueCount += this.incomingEdges.getValue(i - 1).countOfferedValues();
        }
        return totalValueCount;
    }

    public void sendUnofferedTokens() {
        TokenList tokens = this.getUnofferedTokens();
        this.offeredTokenCount += tokens.size();
        this.sendOffers(tokens);
    }

    public int countUnofferedTokens() {
        if (this.heldTokens.size() == 0) {
            this.offeredTokenCount = 0;
        }
        return this.heldTokens.size() - this.offeredTokenCount;
    }

    public TokenList getUnofferedTokens() {
        TokenList tokens = new TokenList();
        for (int i = 1; i <= this.countUnofferedTokens(); ++i) {
            tokens.addValue(this.heldTokens.getValue(this.offeredTokenCount + i - 1));
        }
        return tokens;
    }

    public TokenList takeUnofferedTokens() {
        TokenList tokens = this.getUnofferedTokens();
        for (int i = 0; i < tokens.size(); ++i) {
            Token token = tokens.getValue(i);
            token.withdraw();
        }
        return tokens;
    }
}

