/*
 * Decompiled with CFR 0.152.
 */
package fUML.Semantics.Activities.ExtraStructuredActivities;

import fUML.Debug;
import fUML.Semantics.Actions.BasicActions.ActionActivation;
import fUML.Semantics.Actions.BasicActions.OutputPinActivation;
import fUML.Semantics.Actions.BasicActions.OutputPinActivationList;
import fUML.Semantics.Activities.ExtraStructuredActivities.ExpansionActivationGroup;
import fUML.Semantics.Activities.ExtraStructuredActivities.ExpansionActivationGroupList;
import fUML.Semantics.Activities.ExtraStructuredActivities.ExpansionNodeActivation;
import fUML.Semantics.Activities.ExtraStructuredActivities.TokenSet;
import fUML.Semantics.Activities.ExtraStructuredActivities.TokenSetList;
import fUML.Semantics.Activities.IntermediateActivities.TokenList;
import fUML.Syntax.Actions.BasicActions.InputPin;
import fUML.Syntax.Actions.BasicActions.InputPinList;
import fUML.Syntax.Activities.CompleteStructuredActivities.StructuredActivityNode;
import fUML.Syntax.Activities.ExtraStructuredActivities.ExpansionKind;
import fUML.Syntax.Activities.ExtraStructuredActivities.ExpansionNode;
import fUML.Syntax.Activities.ExtraStructuredActivities.ExpansionNodeList;
import fUML.Syntax.Activities.ExtraStructuredActivities.ExpansionRegion;

public class ExpansionRegionActivation
extends ActionActivation {
    public ExpansionActivationGroupList activationGroups = new ExpansionActivationGroupList();
    public TokenSetList inputTokens = new TokenSetList();
    public TokenSetList inputExpansionTokens = new TokenSetList();

    public TokenList takeOfferedTokens() {
        int i;
        ExpansionRegion region = (ExpansionRegion)this.node;
        InputPinList inputPins = region.input;
        ExpansionNodeList inputElements = region.inputElement;
        this.inputTokens.clear();
        this.inputExpansionTokens.clear();
        for (i = 0; i < inputPins.size(); ++i) {
            InputPin inputPin = inputPins.getValue(i);
            TokenSet tokenSet = new TokenSet();
            tokenSet.tokens = this.getPinActivation(inputPin).takeTokens();
            this.inputTokens.addValue(tokenSet);
        }
        for (i = 0; i < inputElements.size(); ++i) {
            ExpansionNode inputElement = inputElements.getValue(i);
            ExpansionNodeActivation expansionNodeActivation = this.getExpansionNodeActivation(inputElement);
            expansionNodeActivation.fire(expansionNodeActivation.takeOfferedTokens());
            TokenSet tokenSet = new TokenSet();
            tokenSet.tokens = expansionNodeActivation.takeTokens();
            this.inputExpansionTokens.addValue(tokenSet);
        }
        return new TokenList();
    }

    public void doAction() {
        if (((StructuredActivityNode)this.node).mustIsolate) {
            ExpansionRegionActivation._beginIsolation();
            this.doStructuredActivity();
            ExpansionRegionActivation._endIsolation();
        } else {
            this.doStructuredActivity();
        }
    }

    public void doStructuredActivity() {
        ExpansionActivationGroup activationGroup3;
        ExpansionRegion region = (ExpansionRegion)this.node;
        InputPinList inputPins = region.input;
        ExpansionNodeList inputElements = region.inputElement;
        ExpansionNodeList outputElements = region.outputElement;
        int n = this.inputExpansionTokens.getValue((int)0).tokens.size();
        for (int k = 1; k <= n; ++k) {
            int j;
            ExpansionActivationGroup activationGroup2 = new ExpansionActivationGroup();
            activationGroup2.regionActivation = this;
            activationGroup2.index = k;
            for (j = 1; j <= inputPins.size(); ++j) {
                OutputPinActivation regionInput = new OutputPinActivation();
                regionInput.run();
                activationGroup2.regionInputs.addValue(regionInput);
            }
            for (j = 1; j <= inputElements.size(); ++j) {
                OutputPinActivation groupInput = new OutputPinActivation();
                groupInput.run();
                activationGroup2.groupInputs.addValue(groupInput);
            }
            for (j = 1; j <= outputElements.size(); ++j) {
                OutputPinActivation groupOutput = new OutputPinActivation();
                groupOutput.run();
                activationGroup2.groupOutputs.addValue(new OutputPinActivation());
            }
            activationGroup2.createNodeActivations(region.node);
            activationGroup2.createEdgeInstances(region.edge);
            this.activationGroups.addValue(activationGroup2);
        }
        ExpansionActivationGroupList activationGroups = this.activationGroups;
        if (region.mode == ExpansionKind.iterative) {
            Debug.println("[doStructuredActivity] Expansion mode = iterative");
            for (int i = 0; i < activationGroups.size(); ++i) {
                activationGroup3 = activationGroups.getValue(i);
                this.runGroup(activationGroup3);
            }
        } else if (region.mode == ExpansionKind.parallel) {
            Debug.println("[doStructuredActivity] Expansion mode = parallel");
            for (ExpansionActivationGroup activationGroup3 : activationGroups) {
                this.runGroup(activationGroup3);
            }
        }
        for (int i = 0; i < activationGroups.size(); ++i) {
            activationGroup3 = activationGroups.getValue(i);
            OutputPinActivationList groupOutputs = activationGroup3.groupOutputs;
            for (int j = 0; j < groupOutputs.size(); ++j) {
                OutputPinActivation groupOutput = groupOutputs.getValue(j);
                ExpansionNode outputElement = outputElements.getValue(j);
                this.getExpansionNodeActivation(outputElement).addTokens(groupOutput.takeTokens());
            }
        }
    }

    public void terminate() {
        ExpansionActivationGroupList activationGroups = this.activationGroups;
        for (int i = 0; i < activationGroups.size(); ++i) {
            ExpansionActivationGroup activationGroup = this.activationGroups.getValue(i);
            activationGroup.terminateAll();
        }
        super.terminate();
    }

    public boolean isReady() {
        ExpansionRegion region = (ExpansionRegion)this.node;
        boolean ready = super.isReady();
        if (ready) {
            int n = this.numberOfValues();
            if (n < 1) {
                return false;
            }
            int i = 1;
            while (ready & i <= region.inputElement.size()) {
                ready = this.getExpansionNodeActivation(region.inputElement.getValue(i - 1)).countOfferedValues() == n;
                ++i;
            }
        }
        return ready;
    }

    public void sendOffers() {
        ExpansionRegion region = (ExpansionRegion)this.node;
        ExpansionNodeList outputElements = region.outputElement;
        for (ExpansionNode outputElement : outputElements) {
            this.getExpansionNodeActivation(outputElement).sendUnofferedTokens();
        }
        super.sendOffers();
    }

    public void runGroup(ExpansionActivationGroup activationGroup) {
        Debug.println("[runGroup] groupInput[0] = " + this.inputExpansionTokens.getValue((int)0).tokens.getValue(activationGroup.index - 1).getValue());
        TokenSetList inputTokens = this.inputTokens;
        for (int j = 0; j < inputTokens.size(); ++j) {
            TokenSet tokenSet = inputTokens.getValue(j);
            OutputPinActivation regionInput = activationGroup.regionInputs.getValue(j);
            regionInput.clearTokens();
            regionInput.addTokens(tokenSet.tokens);
            regionInput.sendUnofferedTokens();
        }
        TokenSetList inputExpansionTokens = this.inputExpansionTokens;
        for (int j = 0; j < inputExpansionTokens.size(); ++j) {
            TokenSet tokenSet = inputExpansionTokens.getValue(j);
            OutputPinActivation groupInput = activationGroup.groupInputs.getValue(j);
            groupInput.clearTokens();
            groupInput.addToken(tokenSet.tokens.getValue(activationGroup.index - 1));
            groupInput.sendUnofferedTokens();
        }
        activationGroup.run(activationGroup.nodeActivations);
        OutputPinActivationList groupOutputs = activationGroup.groupOutputs;
        for (int i = 0; i < groupOutputs.size(); ++i) {
            OutputPinActivation groupOutput = groupOutputs.getValue(i);
            groupOutput.fire(groupOutput.takeOfferedTokens());
        }
        activationGroup.terminateAll();
    }

    public ExpansionNodeActivation getExpansionNodeActivation(ExpansionNode node) {
        return (ExpansionNodeActivation)this.group.getNodeActivation(node);
    }

    public int numberOfValues() {
        ExpansionRegion region = (ExpansionRegion)this.node;
        return this.getExpansionNodeActivation(region.inputElement.getValue(0)).countOfferedValues();
    }
}

