/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.instrument.Instrumentation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.agent.ByteBuddyAgent;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.mockito.exceptions.base.MockitoInitializationException;
import org.mockito.internal.PremainAttach;
import org.mockito.internal.SuppressSignatureCheck;
import org.mockito.internal.util.StringUtil;
import org.mockito.plugins.MemberAccessor;

@SuppressSignatureCheck
class InstrumentationMemberAccessor
implements MemberAccessor {
    private static final Map<Class<?>, Class<?>> WRAPPERS;
    private static final Instrumentation INSTRUMENTATION;
    private static final Dispatcher DISPATCHER;
    private static final Throwable INITIALIZATION_ERROR;
    private final MethodHandle getModule;
    private final MethodHandle isOpen;
    private final MethodHandle redefineModule;
    private final MethodHandle privateLookupIn;

    InstrumentationMemberAccessor() {
        if (INITIALIZATION_ERROR != null) {
            throw new MockitoInitializationException(StringUtil.join("Could not initialize the Mockito instrumentation member accessor", "", "This is unexpected on JVMs from Java 9 or later - possibly, the instrumentation API could not be resolved"), INITIALIZATION_ERROR);
        }
        try {
            Class<?> module = Class.forName("java.lang.Module");
            this.getModule = MethodHandles.publicLookup().findVirtual(Class.class, "getModule", MethodType.methodType(module));
            this.isOpen = MethodHandles.publicLookup().findVirtual(module, "isOpen", MethodType.methodType(Boolean.TYPE, String.class));
            this.redefineModule = MethodHandles.publicLookup().findVirtual(Instrumentation.class, "redefineModule", MethodType.methodType(Void.TYPE, module, Set.class, Map.class, Map.class, Set.class, Map.class));
            this.privateLookupIn = MethodHandles.publicLookup().findStatic(MethodHandles.class, "privateLookupIn", MethodType.methodType(MethodHandles.Lookup.class, Class.class, MethodHandles.Lookup.class));
        }
        catch (Throwable t) {
            throw new MockitoInitializationException("Could not resolve instrumentation invoker", t);
        }
    }

    @Override
    public Object newInstance(Constructor<?> constructor, Object ... arguments) throws InstantiationException, InvocationTargetException {
        return this.newInstance(constructor, MemberAccessor.ConstructionDispatcher::newInstance, arguments);
    }

    @Override
    public Object newInstance(Constructor<?> constructor, MemberAccessor.OnConstruction onConstruction, Object ... arguments) throws InstantiationException, InvocationTargetException {
        if (Modifier.isAbstract(constructor.getDeclaringClass().getModifiers())) {
            throw new InstantiationException("Cannot instantiate abstract " + constructor.getDeclaringClass().getTypeName());
        }
        InstrumentationMemberAccessor.assureArguments(constructor, null, null, arguments, constructor.getParameterTypes());
        try {
            Object module = DISPATCHER.invokeWithArguments(this.getModule.bindTo(constructor.getDeclaringClass()), new Object[0]);
            String packageName = constructor.getDeclaringClass().getPackage().getName();
            this.assureOpen(module, packageName);
            MethodHandle handle = ((MethodHandles.Lookup)DISPATCHER.invokeWithArguments(this.privateLookupIn, constructor.getDeclaringClass(), DISPATCHER.getLookup())).unreflectConstructor(constructor);
            AtomicBoolean thrown = new AtomicBoolean();
            Object value = onConstruction.invoke(() -> {
                try {
                    return DISPATCHER.invokeWithArguments(handle.asFixedArity(), arguments);
                }
                catch (Throwable throwable) {
                    thrown.set(true);
                    return throwable;
                }
            });
            if (thrown.get()) {
                throw new InvocationTargetException((Throwable)value);
            }
            return value;
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Could not construct " + String.valueOf(constructor) + " with arguments " + Arrays.toString(arguments), t);
        }
    }

    @Override
    public Object invoke(Method method, Object target, Object ... arguments) throws InvocationTargetException {
        InstrumentationMemberAccessor.assureArguments(method, Modifier.isStatic(method.getModifiers()) ? null : target, method.getDeclaringClass(), arguments, method.getParameterTypes());
        try {
            Object module = DISPATCHER.invokeWithArguments(this.getModule.bindTo(method.getDeclaringClass()), new Object[0]);
            String packageName = method.getDeclaringClass().getPackage().getName();
            this.assureOpen(module, packageName);
            MethodHandle handle = ((MethodHandles.Lookup)DISPATCHER.invokeWithArguments(this.privateLookupIn, method.getDeclaringClass(), DISPATCHER.getLookup())).unreflect(method);
            if (!Modifier.isStatic(method.getModifiers())) {
                handle = handle.bindTo(target);
            }
            if (handle.isVarargsCollector()) {
                handle = handle.asFixedArity();
            }
            try {
                return DISPATCHER.invokeWithArguments(handle, arguments);
            }
            catch (Throwable t) {
                throw new InvocationTargetException(t);
            }
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IllegalStateException("Could not invoke " + String.valueOf(method) + " on " + String.valueOf(target) + " with arguments " + Arrays.toString(arguments), t);
        }
    }

    @Override
    public Object get(Field field, Object target) {
        InstrumentationMemberAccessor.assureArguments(field, Modifier.isStatic(field.getModifiers()) ? null : target, field.getDeclaringClass(), new Object[0], new Class[0]);
        try {
            Object module = DISPATCHER.invokeWithArguments(this.getModule.bindTo(field.getDeclaringClass()), new Object[0]);
            String packageName = field.getDeclaringClass().getPackage().getName();
            this.assureOpen(module, packageName);
            MethodHandle handle = ((MethodHandles.Lookup)DISPATCHER.invokeWithArguments(this.privateLookupIn, field.getDeclaringClass(), DISPATCHER.getLookup())).unreflectGetter(field);
            if (!Modifier.isStatic(field.getModifiers())) {
                handle = handle.bindTo(target);
            }
            return DISPATCHER.invokeWithArguments(handle, new Object[0]);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Could not read " + String.valueOf(field) + " on " + String.valueOf(target), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(Field field, Object target, Object value) throws IllegalAccessException {
        InstrumentationMemberAccessor.assureArguments(field, Modifier.isStatic(field.getModifiers()) ? null : target, field.getDeclaringClass(), new Object[]{value}, new Class[]{field.getType()});
        boolean illegalAccess = false;
        try {
            boolean isFinal;
            Object module = DISPATCHER.invokeWithArguments(this.getModule.bindTo(field.getDeclaringClass()), new Object[0]);
            String packageName = field.getDeclaringClass().getPackage().getName();
            this.assureOpen(module, packageName);
            if (Modifier.isFinal(field.getModifiers())) {
                isFinal = true;
                try {
                    DISPATCHER.setAccessible(field, true);
                }
                catch (Throwable ignored) {
                    illegalAccess = true;
                    throw new IllegalAccessException("Could not make final field " + String.valueOf(field) + " accessible");
                }
            } else {
                isFinal = false;
            }
            try {
                MethodHandle handle = ((MethodHandles.Lookup)DISPATCHER.invokeWithArguments(this.privateLookupIn, field.getDeclaringClass(), DISPATCHER.getLookup())).unreflectSetter(field);
                if (!Modifier.isStatic(field.getModifiers())) {
                    handle = handle.bindTo(target);
                }
                DISPATCHER.invokeWithArguments(handle, value);
            }
            finally {
                if (isFinal) {
                    DISPATCHER.setAccessible(field, false);
                }
            }
        }
        catch (Throwable t) {
            if (illegalAccess) {
                throw (IllegalAccessException)t;
            }
            throw new IllegalStateException("Could not read " + String.valueOf(field) + " on " + String.valueOf(target), t);
        }
    }

    private void assureOpen(Object module, String packageName) throws Throwable {
        if (!((Boolean)DISPATCHER.invokeWithArguments(this.isOpen, module, packageName)).booleanValue()) {
            DISPATCHER.invokeWithArguments(this.redefineModule.bindTo(INSTRUMENTATION), module, Collections.emptySet(), Collections.emptyMap(), Collections.singletonMap(packageName, Collections.singleton(DISPATCHER.getModule())), Collections.emptySet(), Collections.emptyMap());
        }
    }

    private static void assureArguments(AccessibleObject target, Object owner, Class<?> type, Object[] values, Class<?>[] types) {
        if (owner != null && !type.isAssignableFrom(owner.getClass())) {
            throw new IllegalArgumentException("Cannot access " + String.valueOf(target) + " on " + String.valueOf(owner));
        }
        Object[] args = values;
        if (args == null) {
            args = new Object[]{};
        }
        if (types.length != args.length) {
            throw new IllegalArgumentException("Incorrect number of arguments for " + String.valueOf(target) + ": expected " + types.length + " but recevied " + args.length);
        }
        for (int index = 0; index < args.length; ++index) {
            if (args[index] == null) {
                if (!types[index].isPrimitive()) continue;
                throw new IllegalArgumentException("Cannot assign null to primitive type " + types[index].getTypeName() + " for " + index + " parameter of " + String.valueOf(target));
            }
            Class<?> resolved = WRAPPERS.getOrDefault(types[index], types[index]);
            if (resolved.isAssignableFrom(args[index].getClass())) continue;
            throw new IllegalArgumentException("Cannot assign value of type " + String.valueOf(args[index].getClass()) + " to " + String.valueOf(resolved) + " for " + index + " parameter of " + String.valueOf(target));
        }
    }

    static {
        Throwable throwable;
        Dispatcher dispatcher;
        Instrumentation instrumentation;
        WRAPPERS = new HashMap();
        WRAPPERS.put(Boolean.TYPE, Boolean.class);
        WRAPPERS.put(Byte.TYPE, Byte.class);
        WRAPPERS.put(Short.TYPE, Short.class);
        WRAPPERS.put(Character.TYPE, Character.class);
        WRAPPERS.put(Integer.TYPE, Integer.class);
        WRAPPERS.put(Long.TYPE, Long.class);
        WRAPPERS.put(Float.TYPE, Float.class);
        WRAPPERS.put(Double.TYPE, Double.class);
        try {
            instrumentation = PremainAttach.getInstrumentation();
            if (instrumentation == null) {
                if (ClassFileVersion.ofThisVm().isAtLeast(ClassFileVersion.JAVA_V21)) {
                    System.out.println("Mockito is currently self-attaching to enable the inline-mock-maker. This will no longer work in future releases of the JDK. Please add Mockito as an agent to your build what is described in Mockito's documentation: https://javadoc.io/doc/org.mockito/mockito-core/latest/org/mockito/Mockito.html#0.3");
                }
                instrumentation = ByteBuddyAgent.install();
            }
            if (!instrumentation.isRetransformClassesSupported()) {
                throw new IllegalStateException(StringUtil.join("Mockito requires retransformation for creating inline mocks. This feature is unavailable on the current VM.", "", "You cannot use this mock maker on this VM"));
            }
            dispatcher = (Dispatcher)new ByteBuddy().subclass(Dispatcher.class).method((ElementMatcher)ElementMatchers.named((String)"getLookup")).intercept((Implementation)MethodCall.invoke((Method)MethodHandles.class.getMethod("lookup", new Class[0]))).method((ElementMatcher)ElementMatchers.named((String)"getModule")).intercept((Implementation)MethodCall.invoke((Method)Class.class.getMethod("getModule", new Class[0])).onMethodCall((MethodCall)MethodCall.invoke((Method)Object.class.getMethod("getClass", new Class[0])))).method((ElementMatcher)ElementMatchers.named((String)"setAccessible")).intercept((Implementation)MethodCall.invoke((Method)AccessibleObject.class.getMethod("setAccessible", Boolean.TYPE)).onArgument(0).withArgument(new int[]{1})).method((ElementMatcher)ElementMatchers.named((String)"invokeWithArguments")).intercept((Implementation)MethodCall.invoke((Method)MethodHandle.class.getMethod("invokeWithArguments", Object[].class)).onArgument(0).withArgument(new int[]{1})).make().load(InstrumentationMemberAccessor.class.getClassLoader(), (ClassLoadingStrategy)ClassLoadingStrategy.Default.WRAPPER).getLoaded().getConstructor(new Class[0]).newInstance(new Object[0]);
            throwable = null;
        }
        catch (Throwable t) {
            instrumentation = null;
            dispatcher = null;
            throwable = t;
        }
        INSTRUMENTATION = instrumentation;
        DISPATCHER = dispatcher;
        INITIALIZATION_ERROR = throwable;
    }

    public static interface Dispatcher {
        public MethodHandles.Lookup getLookup();

        public Object getModule();

        public void setAccessible(AccessibleObject var1, boolean var2);

        public Object invokeWithArguments(MethodHandle var1, Object ... var2) throws Throwable;
    }
}

