/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.mockito.ArgumentMatcher;
import org.mockito.internal.invocation.ArgumentMatcherAction;
import org.mockito.internal.invocation.MatcherApplicationStrategy;
import org.mockito.internal.invocation.TypeSafeMatching;
import org.mockito.internal.matchers.CapturesArguments;
import org.mockito.internal.reporting.PrintSettings;
import org.mockito.invocation.DescribedInvocation;
import org.mockito.invocation.Invocation;
import org.mockito.invocation.Location;
import org.mockito.invocation.MatchableInvocation;

public class InvocationMatcher
implements MatchableInvocation,
DescribedInvocation,
Serializable {
    private final Invocation invocation;
    private final List<ArgumentMatcher<?>> matchers;

    public InvocationMatcher(Invocation invocation, List<ArgumentMatcher> matchers) {
        this.invocation = invocation;
        this.matchers = matchers.isEmpty() ? invocation.getArgumentsAsMatchers() : matchers;
    }

    public InvocationMatcher(Invocation invocation) {
        this(invocation, Collections.emptyList());
    }

    public static List<InvocationMatcher> createFrom(List<Invocation> invocations) {
        LinkedList<InvocationMatcher> out = new LinkedList<InvocationMatcher>();
        for (Invocation i : invocations) {
            out.add(new InvocationMatcher(i));
        }
        return out;
    }

    public Method getMethod() {
        return this.invocation.getMethod();
    }

    @Override
    public Invocation getInvocation() {
        return this.invocation;
    }

    @Override
    public List<ArgumentMatcher> getMatchers() {
        return this.matchers;
    }

    @Override
    public String toString() {
        return new PrintSettings().print(this.matchers, this.invocation);
    }

    @Override
    public boolean matches(Invocation candidate) {
        return this.invocation.getMock() == candidate.getMock() && this.hasSameMethod(candidate) && this.argumentsMatch(candidate);
    }

    @Override
    public boolean hasSimilarMethod(Invocation candidate) {
        String candidateMethodName;
        String wantedMethodName = this.getMethod().getName();
        if (!wantedMethodName.equals(candidateMethodName = candidate.getMethod().getName())) {
            return false;
        }
        if (candidate.isVerified()) {
            return false;
        }
        if (this.getInvocation().getMock() != candidate.getMock()) {
            return false;
        }
        if (this.hasSameMethod(candidate)) {
            return true;
        }
        return !this.argumentsMatch(candidate);
    }

    @Override
    public boolean hasSameMethod(Invocation candidate) {
        Method m1 = this.invocation.getMethod();
        Method m2 = candidate.getMethod();
        if (m1.getName() != null && m1.getName().equals(m2.getName())) {
            Object[] params1 = m1.getParameterTypes();
            Object[] params2 = m2.getParameterTypes();
            return Arrays.equals(params1, params2);
        }
        return false;
    }

    @Override
    public Location getLocation() {
        return this.invocation.getLocation();
    }

    @Override
    public void captureArgumentsFrom(Invocation invocation) {
        MatcherApplicationStrategy strategy = MatcherApplicationStrategy.getMatcherApplicationStrategyFor(invocation, this.matchers);
        strategy.forEachMatcherAndArgument(this.captureArgument());
    }

    private ArgumentMatcherAction captureArgument() {
        return new ArgumentMatcherAction(){

            @Override
            public boolean apply(ArgumentMatcher<?> matcher, Object argument) {
                if (matcher instanceof CapturesArguments) {
                    ((CapturesArguments)((Object)matcher)).captureFrom(argument);
                }
                return true;
            }
        };
    }

    private boolean argumentsMatch(Invocation actual) {
        List<ArgumentMatcher<?>> matchers = this.getMatchers();
        return MatcherApplicationStrategy.getMatcherApplicationStrategyFor(actual, matchers).forEachMatcherAndArgument(TypeSafeMatching.matchesTypeSafe());
    }
}

