/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.configuration.CaptorAnnotationProcessor;
import org.mockito.internal.configuration.FieldAnnotationProcessor;
import org.mockito.internal.configuration.MockAnnotationProcessor;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.util.reflection.FieldSetter;

public class IndependentAnnotationEngine
implements org.mockito.plugins.AnnotationEngine,
AnnotationEngine {
    private final Map<Class<? extends Annotation>, FieldAnnotationProcessor<?>> annotationProcessorMap = new HashMap();

    public IndependentAnnotationEngine() {
        this.registerAnnotationProcessor(Mock.class, new MockAnnotationProcessor());
        this.registerAnnotationProcessor(Captor.class, new CaptorAnnotationProcessor());
    }

    private Object createMockFor(Annotation annotation, Field field) {
        return this.forAnnotation(annotation).process(annotation, field);
    }

    private <A extends Annotation> FieldAnnotationProcessor<A> forAnnotation(A annotation) {
        if (this.annotationProcessorMap.containsKey(annotation.annotationType())) {
            return this.annotationProcessorMap.get(annotation.annotationType());
        }
        return new FieldAnnotationProcessor<A>(){

            @Override
            public Object process(A annotation, Field field) {
                return null;
            }
        };
    }

    private <A extends Annotation> void registerAnnotationProcessor(Class<A> annotationClass, FieldAnnotationProcessor<A> fieldAnnotationProcessor) {
        this.annotationProcessorMap.put(annotationClass, fieldAnnotationProcessor);
    }

    @Override
    public AutoCloseable process(Class<?> clazz, Object testInstance) {
        Field[] fields;
        ArrayList<MockedStatic> mockedStatics = new ArrayList<MockedStatic>();
        for (Field field : fields = clazz.getDeclaredFields()) {
            boolean alreadyAssigned = false;
            for (Annotation annotation : field.getAnnotations()) {
                Object mock = this.createMockFor(annotation, field);
                if (mock instanceof MockedStatic) {
                    mockedStatics.add((MockedStatic)mock);
                }
                if (mock == null) continue;
                this.throwIfAlreadyAssigned(field, alreadyAssigned);
                alreadyAssigned = true;
                try {
                    FieldSetter.setField(testInstance, field, mock);
                }
                catch (Exception e) {
                    for (MockedStatic mockedStatic : mockedStatics) {
                        mockedStatic.close();
                    }
                    throw new MockitoException("Problems setting field " + field.getName() + " annotated with " + annotation, e);
                }
            }
        }
        return () -> {
            for (MockedStatic mockedStatic : mockedStatics) {
                mockedStatic.closeOnDemand();
            }
        };
    }

    void throwIfAlreadyAssigned(Field field, boolean alreadyAssigned) {
        if (alreadyAssigned) {
            throw Reporter.moreThanOneAnnotationNotAllowed(field.getName());
        }
    }
}

