/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.junit;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.mockito.internal.creation.settings.CreationSettings;
import org.mockito.internal.junit.ArgMismatchFinder;
import org.mockito.internal.junit.DefaultStubbingLookupListener;
import org.mockito.internal.junit.MockitoTestListener;
import org.mockito.internal.junit.TestFinishedEvent;
import org.mockito.internal.junit.UnusedStubbings;
import org.mockito.internal.junit.UnusedStubbingsFinder;
import org.mockito.internal.util.MockitoLogger;
import org.mockito.mock.MockCreationSettings;
import org.mockito.quality.Strictness;

class UniversalTestListener
implements MockitoTestListener {
    private Strictness currentStrictness;
    private final MockitoLogger logger;
    private Map<Object, MockCreationSettings> mocks = new IdentityHashMap<Object, MockCreationSettings>();
    private DefaultStubbingLookupListener stubbingLookupListener;

    UniversalTestListener(Strictness initialStrictness, MockitoLogger logger) {
        this.currentStrictness = initialStrictness;
        this.logger = logger;
        this.stubbingLookupListener = new DefaultStubbingLookupListener(this.currentStrictness);
    }

    @Override
    public void testFinished(TestFinishedEvent event) {
        Set<Object> createdMocks = this.mocks.keySet();
        this.mocks = new IdentityHashMap<Object, MockCreationSettings>();
        switch (this.currentStrictness) {
            case WARN: {
                UniversalTestListener.emitWarnings(this.logger, event, createdMocks);
                break;
            }
            case STRICT_STUBS: {
                UniversalTestListener.reportUnusedStubs(event, createdMocks);
                break;
            }
            case LENIENT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown strictness: " + (Object)((Object)this.currentStrictness));
            }
        }
    }

    private static void reportUnusedStubs(TestFinishedEvent event, Collection<Object> mocks) {
        if (event.getFailure() == null) {
            UnusedStubbings unused = new UnusedStubbingsFinder().getUnusedStubbings(mocks);
            unused.reportUnused();
        }
    }

    private static void emitWarnings(MockitoLogger logger, TestFinishedEvent event, Collection<Object> mocks) {
        String testName = event.getTestClassInstance().getClass().getSimpleName() + "." + event.getTestMethodName();
        if (event.getFailure() != null) {
            new ArgMismatchFinder().getStubbingArgMismatches(mocks).format(testName, logger);
        } else {
            new UnusedStubbingsFinder().getUnusedStubbings(mocks).format(testName, logger);
        }
    }

    @Override
    public void onMockCreated(Object mock, MockCreationSettings settings) {
        this.mocks.put(mock, settings);
        ((CreationSettings)settings).getStubbingLookupListeners().add(this.stubbingLookupListener);
    }

    public void setStrictness(Strictness strictness) {
        this.currentStrictness = strictness;
        this.stubbingLookupListener.currentStrictness = strictness;
    }
}

