/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.lang.ref.ReferenceQueue;
import java.util.Set;
import java.util.concurrent.Callable;
import net.bytebuddy.TypeCache;
import org.mockito.internal.creation.bytebuddy.BytecodeGenerator;
import org.mockito.internal.creation.bytebuddy.MockFeatures;
import org.mockito.mock.SerializableMode;

class TypeCachingBytecodeGenerator
extends ReferenceQueue<ClassLoader>
implements BytecodeGenerator {
    private final BytecodeGenerator bytecodeGenerator;
    private final TypeCache<SerializationFeatureKey> typeCache;

    public TypeCachingBytecodeGenerator(BytecodeGenerator bytecodeGenerator, boolean weak) {
        this.bytecodeGenerator = bytecodeGenerator;
        this.typeCache = new TypeCache.WithInlineExpunction(weak ? TypeCache.Sort.WEAK : TypeCache.Sort.SOFT);
    }

    public <T> Class<T> mockClass(final MockFeatures<T> params) {
        try {
            return this.typeCache.findOrInsert(params.mockedType.getClassLoader(), (Object)new SerializationFeatureKey(params.mockedType, params.interfaces, params.serializableMode), new Callable<Class<?>>(){

                @Override
                public Class<?> call() throws Exception {
                    return TypeCachingBytecodeGenerator.this.bytecodeGenerator.mockClass(params);
                }
            }, params.mockedType);
        }
        catch (IllegalArgumentException exception) {
            Throwable cause = exception.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw exception;
        }
    }

    private static class SerializationFeatureKey
    extends TypeCache.SimpleKey {
        private final SerializableMode serializableMode;

        private SerializationFeatureKey(Class<?> type, Set<Class<?>> additionalType, SerializableMode serializableMode) {
            super(type, additionalType);
            this.serializableMode = serializableMode;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SerializationFeatureKey that = (SerializationFeatureKey)((Object)object);
            return this.serializableMode.equals((Object)that.serializableMode);
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.serializableMode.hashCode();
            return result;
        }
    }
}

