/**
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

// DO NOT EDIT THIS GENERATED OUTPUT DIRECTLY!
// This file should be overwritten as part of your build process.
// If you need to extend the behavior of the generated service worker, the best approach is to write
// additional code and include it using the importScripts option:
//   https://github.com/GoogleChrome/sw-precache#importscripts-arraystring
//
// Alternatively, it's possible to make changes to the underlying template file and then use that as the
// new base for generating output, via the templateFilePath option:
//   https://github.com/GoogleChrome/sw-precache#templatefilepath-string
//
// If you go that route, make sure that whenever you update your sw-precache dependency, you reconcile any
// changes made to this original template file with your modified copy.

// This generated service worker JavaScript will precache your site's resources.
// The code needs to be saved in a .js file at the top-level of your site, and registered
// from your pages in order to be used. See
// https://github.com/googlechrome/sw-precache/blob/master/demo/app/js/service-worker-registration.js
// for an example of how you can register this script and handle various service worker events.

/* eslint-env worker, serviceworker */
/* eslint-disable indent, no-unused-vars, no-multiple-empty-lines, max-nested-callbacks, space-before-function-paren, quotes, comma-spacing */
'use strict';

var precacheConfig = [["allclasses-frame.html","43b1b83b654057c6deee4650aa3cb438"],["allclasses-noframe.html","d3f822d946480f15f6257b5e1e88ff7b"],["constant-values.html","4efb361904b551eb3f3a008cd3fcf1a5"],["deprecated-list.html","e70c7c120df6f5989163ab13d0de9b5c"],["favicon.ico","05e61206186c2eee9054011bcf15b864"],["help-doc.html","02174e6f178ffbb3794f8ffdfda0ba0f"],["index-files/index-1.html","56faaf55cf07dda093863044303276e6"],["index-files/index-10.html","858aeb0284183c2fa61f62c2d9a5910e"],["index-files/index-11.html","dd1f362d7e118e6561e05d53cdbfe4c3"],["index-files/index-12.html","9c4ce1a123dafe46dc51bca56c3968e7"],["index-files/index-13.html","0849e7fdaaa8ab0b5cdf864720672381"],["index-files/index-14.html","665e939cc2714081d2e1cf8a35a5dca4"],["index-files/index-15.html","f380d62633875ad3bb112564614ffdd4"],["index-files/index-16.html","63478a789aea831208a7df0014ccd05a"],["index-files/index-17.html","4ad33a34f9d8161821d32331b8c1a852"],["index-files/index-18.html","610927690c912ae7fa9eda7c8767a0a8"],["index-files/index-19.html","a4ddd07b19c28dd20448435593506528"],["index-files/index-2.html","ccdfec2e234bdd474bedeecdc38ec7c2"],["index-files/index-20.html","d129feee8bf9d2265d793e39a3c6f88d"],["index-files/index-3.html","42ba2e49a73a96d9e923cec519ac8b9e"],["index-files/index-4.html","7674ca467f44d40f3bd9ddc85270df96"],["index-files/index-5.html","1ec25c1568471b5c6485fd75b62a8c46"],["index-files/index-6.html","87791bb65c89100655e4ed726c92c6b1"],["index-files/index-7.html","3f01f3b9866b1a2fac85e8a6c206ffb7"],["index-files/index-8.html","07bbd32475a68fc11bae515f42bbddf6"],["index-files/index-9.html","542367b41127537fe44543c60053eaab"],["index.html","a6e587d7abae4d4f90a078348c88b252"],["js/highlight-8.6-java/highlight.pack.js","deec56e4bb489b0ce943987284aac274"],["js/highlight-8.6-java/styles/obsidian.css","d60cd29c66c835762c95d2ce6da21142"],["js/index.js","dfc78156c8712ef6c546ea1037a604ef"],["js/jdk6-project-version-insert.js","ddee726b95840e7606e132d95c65ef27"],["js/jdk6-project-version-insert.min.js","a6a8d425f512ba0a8e2340504f134553"],["js/jquery-1.7.min.js","25721ced154b3a99e818431446d7506d"],["org/mockito/AdditionalAnswers.html","9f1b1c99b7dec372d71eb494307649b2"],["org/mockito/AdditionalMatchers.html","d00373ef83987b6c82e3656ee77c61d5"],["org/mockito/Answers.html","3f683fcad862f7a9f8a74af70708bcfe"],["org/mockito/ArgumentCaptor.html","5bfacb781587f25561589dd6de6c2f32"],["org/mockito/ArgumentMatcher.html","f0cc523fd210db9f75d6783338806c72"],["org/mockito/ArgumentMatchers.html","0deb4f68fd28d374ba0a881570aa50f1"],["org/mockito/BDDMockito.BDDMyOngoingStubbing.html","e0471ee210f98385886cbe71eecb3097"],["org/mockito/BDDMockito.BDDStubber.html","14266df581707173125c842764ddcc2f"],["org/mockito/BDDMockito.Then.html","fe27c2101d3fca595e73750edeb9ec91"],["org/mockito/BDDMockito.html","61a356388168cace5a3f0904f10ae29b"],["org/mockito/Captor.html","80ddccbed67c4b5d7287a33274ab298b"],["org/mockito/InOrder.html","78472cc658fd4af74e8c62c17d658283"],["org/mockito/Incubating.html","51e0649e25c2d68c0fd4b1d33e93190d"],["org/mockito/InjectMocks.html","e30d66148fd5789f9a618e2003fff6ee"],["org/mockito/Matchers.html","a614fe982d250469e46079ad7872aa86"],["org/mockito/Mock.html","24c8d1df29e7ecdf8859660610c70325"],["org/mockito/MockSettings.html","1ab54777164df8e1acddeab1a9d40e23"],["org/mockito/MockingDetails.html","c0d76c6e3e8f14287d08f3fcd20cd6fe"],["org/mockito/Mockito.html","2199b3769d69059132d5af9719799e61"],["org/mockito/MockitoAnnotations.html","4fec1953754a401ea8d3809c1924e9fd"],["org/mockito/MockitoDebugger.html","7c447a70359c9cfba116b3443afefbad"],["org/mockito/MockitoFramework.html","af0dd56d471982a9d4dca4c4e6e35b64"],["org/mockito/Spy.html","c64da37df71fcdb38310ce6a732027fc"],["org/mockito/class-use/AdditionalAnswers.html","a9d135a9960af3c8cfdc8c18c3509c79"],["org/mockito/class-use/AdditionalMatchers.html","7835849ffa03d8ce00e777f3876d2814"],["org/mockito/class-use/Answers.html","b1c351f7394872c06b903c817090b6b4"],["org/mockito/class-use/ArgumentCaptor.html","d64185e013c897af9f23a78bab534daa"],["org/mockito/class-use/ArgumentMatcher.html","9832922aa1400650d2ff1325fb2a20e4"],["org/mockito/class-use/ArgumentMatchers.html","6ff8bee4f63970e2d1a8cc79421744f2"],["org/mockito/class-use/BDDMockito.BDDMyOngoingStubbing.html","b5a8c067a071a40995eed5e273570168"],["org/mockito/class-use/BDDMockito.BDDStubber.html","b61f4ecfaee97fc7b20094c77baa8cb6"],["org/mockito/class-use/BDDMockito.Then.html","cd4178e399e19e0f0b9cfa91e85725da"],["org/mockito/class-use/BDDMockito.html","7341fde54fda5e8b1a6b24ae91541309"],["org/mockito/class-use/Captor.html","b07d961179296050a57658a725a21e3a"],["org/mockito/class-use/InOrder.html","85b4d8d3011a83a6b26e91a086f56056"],["org/mockito/class-use/Incubating.html","65b04af2b921130cccb5f14c5480b840"],["org/mockito/class-use/InjectMocks.html","5d329775c7a6ec980de11889e003308d"],["org/mockito/class-use/Matchers.html","9c9caa0c2f0f27a0a765a86ca7df860e"],["org/mockito/class-use/Mock.html","24ec66d3a2ee6f83b373fbb4d316ed34"],["org/mockito/class-use/MockSettings.html","118a81595eba330598894724f88d9a38"],["org/mockito/class-use/MockingDetails.html","971ffe5d7be84a2ac36b6def80810d17"],["org/mockito/class-use/Mockito.html","75b147f995d5a32427bbb33ca7efcd6e"],["org/mockito/class-use/MockitoAnnotations.html","79d1d210a7bd96486dc356a0260f1f53"],["org/mockito/class-use/MockitoDebugger.html","16d2d2e83402e461d3809a5f5d61eb1a"],["org/mockito/class-use/MockitoFramework.html","41a98c11276599567a73d394484c63ca"],["org/mockito/class-use/Spy.html","39b24f08c89c00bb40524f5f46ac4329"],["org/mockito/configuration/AnnotationEngine.html","0ba1f759e9ee7b2076dab3af21ed4e3e"],["org/mockito/configuration/DefaultMockitoConfiguration.html","a73ac90f07169c0164d930ff42a1e776"],["org/mockito/configuration/IMockitoConfiguration.html","e3b9cdccf784e31e029464c8f9ac0d5a"],["org/mockito/configuration/class-use/AnnotationEngine.html","a81a35c6791bef045afbe9a846004568"],["org/mockito/configuration/class-use/DefaultMockitoConfiguration.html","a919a5340bffca1ff7ea3a15a7149ee1"],["org/mockito/configuration/class-use/IMockitoConfiguration.html","e19f42b7fa470bf57eeba0e4aa794d84"],["org/mockito/configuration/package-frame.html","9dcb554357ab7f81e8d812759a938f7a"],["org/mockito/configuration/package-summary.html","1b3d000d34d9da78c02d0f3903a43e97"],["org/mockito/configuration/package-tree.html","90975c4a2086203c72a6288777cd90e8"],["org/mockito/configuration/package-use.html","0a9fd26324cb7a6770709466a0ffff47"],["org/mockito/exceptions/base/MockitoAssertionError.html","4edaa8e20b17c8e9553919ef142f4c46"],["org/mockito/exceptions/base/MockitoException.html","3c1ba5a3046774d68b64b0bf9014cbbf"],["org/mockito/exceptions/base/MockitoInitializationException.html","6b8e83a11e5ad9e5c6087f9934bde6e8"],["org/mockito/exceptions/base/MockitoSerializationIssue.html","6a6f8aca66dc19082fb31aecc75d30ee"],["org/mockito/exceptions/base/class-use/MockitoAssertionError.html","9cb2abea76aa87f1682904bed4cc5c9f"],["org/mockito/exceptions/base/class-use/MockitoException.html","c649ca6c68ce708b8ab320a43bf83731"],["org/mockito/exceptions/base/class-use/MockitoInitializationException.html","38ae52443552419efcbc53a339aae870"],["org/mockito/exceptions/base/class-use/MockitoSerializationIssue.html","ca19f5e69c0a9e67f52814a5910024fb"],["org/mockito/exceptions/base/package-frame.html","1e56cc918efb48734c5b8b258286060e"],["org/mockito/exceptions/base/package-summary.html","16fb55d489e670d8dc6888666c8ab2eb"],["org/mockito/exceptions/base/package-tree.html","940164ba9c7fd967e8d807f907bebd52"],["org/mockito/exceptions/base/package-use.html","c3e88c34ed52d334c4e60dc2b8fb3bc8"],["org/mockito/exceptions/misusing/CannotStubVoidMethodWithReturnValue.html","29ee68c6325b069ef1aac9942990de46"],["org/mockito/exceptions/misusing/CannotVerifyStubOnlyMock.html","141e75af32176e47f601a6f57163020c"],["org/mockito/exceptions/misusing/FriendlyReminderException.html","012fe6a814fdfcf65a28afb16791463e"],["org/mockito/exceptions/misusing/InvalidUseOfMatchersException.html","7fa7e5cbda7b9892ed2a15bb58f5836c"],["org/mockito/exceptions/misusing/MissingMethodInvocationException.html","0fc3e2b151db3496178c09b84154da49"],["org/mockito/exceptions/misusing/MockitoConfigurationException.html","a5326e028060323020ca164889e3600a"],["org/mockito/exceptions/misusing/NotAMockException.html","24bfc193f3ce0bfb648e1e54facd52bf"],["org/mockito/exceptions/misusing/NullInsteadOfMockException.html","4afc9083184bd0d964a049d9b3456207"],["org/mockito/exceptions/misusing/PotentialStubbingProblem.html","4aa0d8da0a34c3cdf7395ce31f829e44"],["org/mockito/exceptions/misusing/RedundantListenerException.html","09050cf425aecf6debc802661ed80baf"],["org/mockito/exceptions/misusing/UnfinishedStubbingException.html","719dc6561c159979bfdfae3973102676"],["org/mockito/exceptions/misusing/UnfinishedVerificationException.html","f11624ca19dc5a5805e1594914f6bb2c"],["org/mockito/exceptions/misusing/UnnecessaryStubbingException.html","0bd7f5ef9e8489f936824ca7b92a620d"],["org/mockito/exceptions/misusing/WrongTypeOfReturnValue.html","4099be5fa413853a01f35377e9b1cade"],["org/mockito/exceptions/misusing/class-use/CannotStubVoidMethodWithReturnValue.html","a14a1084fc20498b7c9dc9ce43c6ef50"],["org/mockito/exceptions/misusing/class-use/CannotVerifyStubOnlyMock.html","3d4c2d821af1bb11f1582facf58bda21"],["org/mockito/exceptions/misusing/class-use/FriendlyReminderException.html","d08d7b6f7a011cb30b6b4908e61bc07b"],["org/mockito/exceptions/misusing/class-use/InvalidUseOfMatchersException.html","4d3fa412d027b360a43028fcca6dfd2e"],["org/mockito/exceptions/misusing/class-use/MissingMethodInvocationException.html","5efeb158739588f868f73ed0ffa70858"],["org/mockito/exceptions/misusing/class-use/MockitoConfigurationException.html","97c602fdc815ae96d0ffc8cdbedbe980"],["org/mockito/exceptions/misusing/class-use/NotAMockException.html","56084dd4c50f17c84aa5426d4d514d92"],["org/mockito/exceptions/misusing/class-use/NullInsteadOfMockException.html","30668a8fd791ec62524632fed95122c4"],["org/mockito/exceptions/misusing/class-use/PotentialStubbingProblem.html","1e311ab5591e29d1cf4f8db277ae132f"],["org/mockito/exceptions/misusing/class-use/RedundantListenerException.html","d17cf50e5be10236f9ab719cf08b3934"],["org/mockito/exceptions/misusing/class-use/UnfinishedStubbingException.html","8ee25e05e6c6527abbfaec2676cf9cb0"],["org/mockito/exceptions/misusing/class-use/UnfinishedVerificationException.html","d94fefadbb4f6cceb55b7a010ba6c3b3"],["org/mockito/exceptions/misusing/class-use/UnnecessaryStubbingException.html","88867803ca8bcedb7a7c6a52c6d71614"],["org/mockito/exceptions/misusing/class-use/WrongTypeOfReturnValue.html","0cbbecec02954f21b6a3f83a2d17f351"],["org/mockito/exceptions/misusing/package-frame.html","04c86997c5cc0cd945bd2fb1ec1ba4fb"],["org/mockito/exceptions/misusing/package-summary.html","f801c880831cfe76b7fd1e4a57db68ad"],["org/mockito/exceptions/misusing/package-tree.html","0d5a4da80371555d6b76f1e4211fd997"],["org/mockito/exceptions/misusing/package-use.html","bdc12c8dd66df40ad93e8601fe4ef803"],["org/mockito/exceptions/stacktrace/StackTraceCleaner.html","f01cbcc7b8fbac38a5ffdcaf896a7587"],["org/mockito/exceptions/stacktrace/class-use/StackTraceCleaner.html","404662c4f518694e1b568e6a959cff07"],["org/mockito/exceptions/stacktrace/package-frame.html","5d117f9b0e456d946c4589f29c7cf201"],["org/mockito/exceptions/stacktrace/package-summary.html","407db1f7c6e80b67e5c913a20562fab6"],["org/mockito/exceptions/stacktrace/package-tree.html","8fa1c660d419e592d942828243007e86"],["org/mockito/exceptions/stacktrace/package-use.html","fd95697ba45d2feaaf54c9b649a8b69c"],["org/mockito/exceptions/verification/ArgumentsAreDifferent.html","c70989211d851d3ad56dab395d9c44b4"],["org/mockito/exceptions/verification/NeverWantedButInvoked.html","f245ed563d1a2c47b7c06d7cfb9ce5dd"],["org/mockito/exceptions/verification/NoInteractionsWanted.html","f1aab29e1fdb05849d87c8b7dfd1e28f"],["org/mockito/exceptions/verification/SmartNullPointerException.html","c5e9c6599d4bd922a31f0f209ee29ef6"],["org/mockito/exceptions/verification/TooLittleActualInvocations.html","475fc6a428df654fc869658dbc582434"],["org/mockito/exceptions/verification/TooManyActualInvocations.html","cf5c510a236c0ee1f698b059b5705aac"],["org/mockito/exceptions/verification/VerificationInOrderFailure.html","8cef42a482e17ff90ef62b56cb185321"],["org/mockito/exceptions/verification/WantedButNotInvoked.html","e676f31766fb60d1f2b8fdbeff329e8a"],["org/mockito/exceptions/verification/class-use/ArgumentsAreDifferent.html","79d47314aaf3458280c56602cf47fe10"],["org/mockito/exceptions/verification/class-use/NeverWantedButInvoked.html","c68bd384c7e6f2c7eb7a3f252cf1b964"],["org/mockito/exceptions/verification/class-use/NoInteractionsWanted.html","534e9d18214ecd3ef459814fbea10465"],["org/mockito/exceptions/verification/class-use/SmartNullPointerException.html","d0d214e3c43c25a003ab5bed7b0d2d21"],["org/mockito/exceptions/verification/class-use/TooLittleActualInvocations.html","8b4ed98f9ff9f4ca0e2f49e5b1368fe6"],["org/mockito/exceptions/verification/class-use/TooManyActualInvocations.html","719a2de9e54a1376200206ff42953154"],["org/mockito/exceptions/verification/class-use/VerificationInOrderFailure.html","2b17a60a2bb86c25d52fe947acca5f37"],["org/mockito/exceptions/verification/class-use/WantedButNotInvoked.html","072407b2240cadfd3586b2f05db82af0"],["org/mockito/exceptions/verification/junit/ArgumentsAreDifferent.html","acaafb6e34e2276f72c9158fe1679cf6"],["org/mockito/exceptions/verification/junit/class-use/ArgumentsAreDifferent.html","741102f8117afd7cc54065a160f77cee"],["org/mockito/exceptions/verification/junit/package-frame.html","755b483a763a15ee8c54485932df8f5f"],["org/mockito/exceptions/verification/junit/package-summary.html","de862344f2e1d2f96be6e75b064e1459"],["org/mockito/exceptions/verification/junit/package-tree.html","75a1ce0d53ce324785d25d2740ab14bd"],["org/mockito/exceptions/verification/junit/package-use.html","e7ad5f7edbb7d41bd777c42f14ad0d70"],["org/mockito/exceptions/verification/package-frame.html","8a9a65a4d9422f1a91634ba633740053"],["org/mockito/exceptions/verification/package-summary.html","af29b9017af3f99b683103e7fad2644c"],["org/mockito/exceptions/verification/package-tree.html","407a78a6e0797774943d70189b572c11"],["org/mockito/exceptions/verification/package-use.html","2734885308767d045ae5395357571842"],["org/mockito/hamcrest/MockitoHamcrest.html","8987f4acbba9b0a222b5feee0e61d9a4"],["org/mockito/hamcrest/class-use/MockitoHamcrest.html","8a25babde3989f198a8572d57008a929"],["org/mockito/hamcrest/package-frame.html","e07489ef1298893ec5717151c04c06de"],["org/mockito/hamcrest/package-summary.html","086e9e807d254e4a67251fa8c647e101"],["org/mockito/hamcrest/package-tree.html","e2305cac8830680c86b70c177b8d28c9"],["org/mockito/hamcrest/package-use.html","17e7943532e2603310c0e8511f47b971"],["org/mockito/invocation/DescribedInvocation.html","b8bdb0566ed6cba2d662e511f98b9dbe"],["org/mockito/invocation/Invocation.html","4b90b3f7d526e40cc042a756dba4dd60"],["org/mockito/invocation/InvocationOnMock.html","ae4ce459f9084cd1501c6053328d48ab"],["org/mockito/invocation/Location.html","0d3a806745842b3910fbc56bd4add2f7"],["org/mockito/invocation/MatchableInvocation.html","7b20c6ad17cc6d8a853f65c7ba3218c8"],["org/mockito/invocation/MockHandler.html","d7bdeadbaced9117b394740e66a7759c"],["org/mockito/invocation/StubInfo.html","d24fa434cdf6e59cafd1a24679ec487c"],["org/mockito/invocation/class-use/DescribedInvocation.html","afb37318897f4b110350cb5921954d68"],["org/mockito/invocation/class-use/Invocation.html","cbd78d64b451c0c9a7bb8f18f5c0ab11"],["org/mockito/invocation/class-use/InvocationOnMock.html","942f8dc910768a93ac8a7da24996c03e"],["org/mockito/invocation/class-use/Location.html","def2f0d6457dc6c5abed2e6385d3e932"],["org/mockito/invocation/class-use/MatchableInvocation.html","c3bb1bbd9459498463ef4f9251d356ad"],["org/mockito/invocation/class-use/MockHandler.html","b8393a9a9dee00ec2e6399cc562a7e24"],["org/mockito/invocation/class-use/StubInfo.html","06da4e765972d20c7f4580da6de6372c"],["org/mockito/invocation/package-frame.html","0070eb9e0610b19f9736bee750e4f585"],["org/mockito/invocation/package-summary.html","c85cf7e89b598ca419eeeefd80a19cac"],["org/mockito/invocation/package-tree.html","44e18528af0ac14afbf1eab5225cb04b"],["org/mockito/invocation/package-use.html","76333e3c53dbde4d6918fa55b64b10a3"],["org/mockito/junit/MockitoJUnit.html","6a8e63c6a55f9b83b16877aedd82d4a5"],["org/mockito/junit/MockitoJUnitRunner.Silent.html","c6642d27521361d6edf42066a01c4c61"],["org/mockito/junit/MockitoJUnitRunner.Strict.html","54f06e0f204757b141bd1bee7b7fd099"],["org/mockito/junit/MockitoJUnitRunner.StrictStubs.html","fe686eabf2b8bb2f9c841ce17d3de14e"],["org/mockito/junit/MockitoJUnitRunner.html","4b8e67adead80961fc92f1c5cf23833a"],["org/mockito/junit/MockitoRule.html","0094c6181d59e2b42125e65d3100d3ac"],["org/mockito/junit/VerificationCollector.html","baba09023ff99f341bec600a12e7a53d"],["org/mockito/junit/class-use/MockitoJUnit.html","9bba500aa3b233c14374d3f3a06e2e26"],["org/mockito/junit/class-use/MockitoJUnitRunner.Silent.html","31ef80e710431808b5d0499cc74441cb"],["org/mockito/junit/class-use/MockitoJUnitRunner.Strict.html","72d5d9c4146f0d67ebbbac8001a4cbc3"],["org/mockito/junit/class-use/MockitoJUnitRunner.StrictStubs.html","538bef576aac1f4411426381fc07b361"],["org/mockito/junit/class-use/MockitoJUnitRunner.html","f67efcd81a44cb7257964a303a876fcc"],["org/mockito/junit/class-use/MockitoRule.html","c8df435f5ed4499761821b72132a7d80"],["org/mockito/junit/class-use/VerificationCollector.html","0d54d9cd478c4a5bfce1d4e2806918dc"],["org/mockito/junit/package-frame.html","2c6d160d38a5bd31a3a45b86d68506e7"],["org/mockito/junit/package-summary.html","a1745e3d202e00c30d091468ff1dde80"],["org/mockito/junit/package-tree.html","14e3f5fd274d9756715e560f9492538a"],["org/mockito/junit/package-use.html","e29e198a3d8ae3d6b4f2ad6e631079cd"],["org/mockito/listeners/InvocationListener.html","00b397683f391a5169db3949e76f7f0a"],["org/mockito/listeners/MethodInvocationReport.html","82df13a47ec11b169dd154d36436d87b"],["org/mockito/listeners/MockCreationListener.html","c7d91ecc64a753bcec92618a3f070fae"],["org/mockito/listeners/MockitoListener.html","782e0ae42161d0ba9c874635e1ffa7bf"],["org/mockito/listeners/VerificationListener.html","881228b827387d1d2db008df6614499e"],["org/mockito/listeners/class-use/InvocationListener.html","bf99f15529feb8c155b66b7f008e3cd6"],["org/mockito/listeners/class-use/MethodInvocationReport.html","ed24932cf68ba2a51419e04289e40e80"],["org/mockito/listeners/class-use/MockCreationListener.html","d0ef7acc3ff83ffc447e06342a0d687d"],["org/mockito/listeners/class-use/MockitoListener.html","736d85a3196e347fc3c76434468b3704"],["org/mockito/listeners/class-use/VerificationListener.html","e0e58e6e45646acf4b022a34640d5f80"],["org/mockito/listeners/package-frame.html","d1fdb29ebdecd7717f9dec97bac6c5a2"],["org/mockito/listeners/package-summary.html","5e65f0985b0f6c52121d0048fd1ba0d1"],["org/mockito/listeners/package-tree.html","bc65566e21ba3e9f3812e6660045c827"],["org/mockito/listeners/package-use.html","d2f47ccb9980f6905d8d0e619b3acaa7"],["org/mockito/mock/MockCreationSettings.html","5d5e1bd1ee0d040bd37eda023e913a3f"],["org/mockito/mock/MockName.html","c09c744dc4573bf0f48205162734115d"],["org/mockito/mock/SerializableMode.html","d2a50b592dd4d12a2f697d789815570e"],["org/mockito/mock/class-use/MockCreationSettings.html","e5bcbde3c06deb545e92b44191ef5000"],["org/mockito/mock/class-use/MockName.html","357b23d3a2f7fe649634f7a9500e9e36"],["org/mockito/mock/class-use/SerializableMode.html","8aad6cc23006db9adf0e105e86c9c73e"],["org/mockito/mock/package-frame.html","687fbbccbe7f79ae834fa87015533dd3"],["org/mockito/mock/package-summary.html","a482bf3d26ecd9d0db80a104b3991a52"],["org/mockito/mock/package-tree.html","d2f2594f7a9141fe67b408731837d7e0"],["org/mockito/mock/package-use.html","1f4b53807009e63824c75fefd1fcbdaa"],["org/mockito/package-frame.html","c881306a1f20c8549839f7db059de317"],["org/mockito/package-summary.html","df51bdf0581a837dea91cd4600360306"],["org/mockito/package-tree.html","a8185b4cf9aa623fc9b43f01eeeb52fc"],["org/mockito/package-use.html","6990ede2999a47d013c3ffcc6339314b"],["org/mockito/plugins/AnnotationEngine.html","ba253a2b38e3c1f8100ee5ba8ec40969"],["org/mockito/plugins/InstantiatorProvider.html","98d8b1584e893ab71d7229d5bc5049ab"],["org/mockito/plugins/MockMaker.TypeMockability.html","38b9de13ebcca865e8d2884ab505af86"],["org/mockito/plugins/MockMaker.html","fc90bfa7aa94ba5df8034953e4544bd8"],["org/mockito/plugins/PluginSwitch.html","93a1d7a0b694424d471e1a0eb9350065"],["org/mockito/plugins/StackTraceCleanerProvider.html","68ecccd89b08e99d0e4fd56a3895e8a4"],["org/mockito/plugins/class-use/AnnotationEngine.html","44fafad06733dfa8e330515565661275"],["org/mockito/plugins/class-use/InstantiatorProvider.html","1300032d9744dedd8f716551c8d1e104"],["org/mockito/plugins/class-use/MockMaker.TypeMockability.html","5b6edb0f710724c231380e4ff037dc80"],["org/mockito/plugins/class-use/MockMaker.html","856f019d6f08193de29cd5e4718b0f8c"],["org/mockito/plugins/class-use/PluginSwitch.html","050a637a3e36bac3f38b703cd26fc8f4"],["org/mockito/plugins/class-use/StackTraceCleanerProvider.html","fa13e39f8ee7116cf4c97a0071f7a8ef"],["org/mockito/plugins/package-frame.html","4a44bbfb661464012df0332f5d1324a7"],["org/mockito/plugins/package-summary.html","c26c4935cee7e6a60f07776da0eb8c7b"],["org/mockito/plugins/package-tree.html","d37bf1820f36aebea24bb08ab58fd626"],["org/mockito/plugins/package-use.html","886686a2a8817460f49d688ad8b27506"],["org/mockito/quality/MockitoHint.html","5e5b75931bb93bf8a175b061ae940245"],["org/mockito/quality/Strictness.html","843bb8abf72723e130a7f47289dc00a0"],["org/mockito/quality/class-use/MockitoHint.html","5400f0c792829a279d556e12e9ffa669"],["org/mockito/quality/class-use/Strictness.html","f1517ad879b0c3aa11e281da9a13c72d"],["org/mockito/quality/package-frame.html","68a6135a64a0bf24134b6974d6bafd3a"],["org/mockito/quality/package-summary.html","cbea003def8d70509b84ebe3f75dc822"],["org/mockito/quality/package-tree.html","3a6dbc2cd8e7a3211edaad08705f4b7b"],["org/mockito/quality/package-use.html","7d9beb97d6e71a35eb6f4dd8637d2552"],["org/mockito/runners/ConsoleSpammingMockitoJUnitRunner.html","6f9affd2bc0c0231e4790e41da11e886"],["org/mockito/runners/MockitoJUnitRunner.Silent.html","5aee8fd7c0aa03ce354027a10765d44a"],["org/mockito/runners/MockitoJUnitRunner.Strict.html","2f3391abd787ee93fbdcc662fbacd4a4"],["org/mockito/runners/MockitoJUnitRunner.html","7e8ce3deac0708dd90dad61389bd356b"],["org/mockito/runners/VerboseMockitoJUnitRunner.html","9fc81b61669a15dac44ec4aed2e117f0"],["org/mockito/runners/class-use/ConsoleSpammingMockitoJUnitRunner.html","275ae04c8b7f2c3d47ad1c8ed624ea9f"],["org/mockito/runners/class-use/MockitoJUnitRunner.Silent.html","cf393c27927cbbb73baa41adc777fe9c"],["org/mockito/runners/class-use/MockitoJUnitRunner.Strict.html","a61ae365bf82840362248b9643405315"],["org/mockito/runners/class-use/MockitoJUnitRunner.html","e16a243667bc9e979877f7627d6917dc"],["org/mockito/runners/class-use/VerboseMockitoJUnitRunner.html","9069318629b19883ec6d45d8d56628f1"],["org/mockito/runners/package-frame.html","2e066711b34b383c291ddb5eb325ac3b"],["org/mockito/runners/package-summary.html","47c1f74e036afc6857cd069979ac9bb1"],["org/mockito/runners/package-tree.html","a073836b9e92de63d2b192edfabe2dea"],["org/mockito/runners/package-use.html","535084f2101fd008fc0d1f8cc444c3d4"],["org/mockito/stubbing/Answer.html","000347a7be3160dcba215ee20ce134c3"],["org/mockito/stubbing/Answer1.html","6bf2e7550dc3a8d878a2f2a2495e88e0"],["org/mockito/stubbing/Answer2.html","c487a29bab48c1b3cbd4292cb073d310"],["org/mockito/stubbing/Answer3.html","3f3825470059c0f5ba46277717f6285d"],["org/mockito/stubbing/Answer4.html","df7f9ef87e70fd35f043f8f21d5e4b81"],["org/mockito/stubbing/Answer5.html","21bf20672903cef3edf43f7c84f0fd67"],["org/mockito/stubbing/OngoingStubbing.html","69a0d5b11fae9d5b7d9e1b70c1ec7eef"],["org/mockito/stubbing/Stubber.html","3d30aed3d02ffb7637e03124d7199fb1"],["org/mockito/stubbing/Stubbing.html","9eb0c6edcf2a2895f16b21b14d265183"],["org/mockito/stubbing/ValidableAnswer.html","888c656f3a3fd7551370725612115727"],["org/mockito/stubbing/VoidAnswer1.html","bd46e7eb2499b3e73e60f37a0663a8c6"],["org/mockito/stubbing/VoidAnswer2.html","353b933c205b0f49e1175d7d943ba160"],["org/mockito/stubbing/VoidAnswer3.html","6e891c1669aa16b8f5f5e10e0a8ab565"],["org/mockito/stubbing/VoidAnswer4.html","ea6e5050ecd93e88e465b2108321b456"],["org/mockito/stubbing/VoidAnswer5.html","db24df17f64c7f278f0806d56149b183"],["org/mockito/stubbing/class-use/Answer.html","5aa262347a4b691725bdd449565adce3"],["org/mockito/stubbing/class-use/Answer1.html","acd54acceafeea6afcb57956e38ca86a"],["org/mockito/stubbing/class-use/Answer2.html","836dd9ab86e07912885f51a26e3d8695"],["org/mockito/stubbing/class-use/Answer3.html","c28cae5146303028a8d66c549c04b789"],["org/mockito/stubbing/class-use/Answer4.html","177ee3cf1ac5a616aba761cbbe874005"],["org/mockito/stubbing/class-use/Answer5.html","1aa3e6271509cda459afce5d09ba88bc"],["org/mockito/stubbing/class-use/OngoingStubbing.html","be4de766e1f272a044df63b27a23034d"],["org/mockito/stubbing/class-use/Stubber.html","4f25207e957f3debc3319c90e1eb70da"],["org/mockito/stubbing/class-use/Stubbing.html","83b8e2b319a37357542bf81475c18927"],["org/mockito/stubbing/class-use/ValidableAnswer.html","9aeff3e1f16a8d649c8aee00c7027dd7"],["org/mockito/stubbing/class-use/VoidAnswer1.html","45f6bd66eb2f476c15eac51e88954297"],["org/mockito/stubbing/class-use/VoidAnswer2.html","f7272f3c47210e9b9f38788cafed2d92"],["org/mockito/stubbing/class-use/VoidAnswer3.html","59d25583609cf2c11a663887f693d987"],["org/mockito/stubbing/class-use/VoidAnswer4.html","795574b1534dbd848b379d06487a1716"],["org/mockito/stubbing/class-use/VoidAnswer5.html","1fb08e2674fca40ab4890aa0d5e270d1"],["org/mockito/stubbing/package-frame.html","62ccf1738da7ea1821bb5f7ca7be254b"],["org/mockito/stubbing/package-summary.html","d61904fadc842cc0c6902dea0838608e"],["org/mockito/stubbing/package-tree.html","ca44f183d14bb889b9db84c08443ef18"],["org/mockito/stubbing/package-use.html","bec426754d550c2b62d34c2e0f531b13"],["org/mockito/verification/After.html","91a0d8428e2d44dd2fe0259dffaf8d4b"],["org/mockito/verification/Timeout.html","f94e988aaa2817917b8cb32e09783cc2"],["org/mockito/verification/VerificationAfterDelay.html","3bbbcb92a04f60f07bbeb2787bbbeb13"],["org/mockito/verification/VerificationEvent.html","d21c2e75f661a72a0c8ea125629acf26"],["org/mockito/verification/VerificationMode.html","dfc6b903407990c1d85eaf6d703f2b77"],["org/mockito/verification/VerificationStrategy.html","a82e30e74d0d4030353427a838dffcd9"],["org/mockito/verification/VerificationWithTimeout.html","fa643c5c2fb3c58f959dd06617c881ee"],["org/mockito/verification/class-use/After.html","785d7cb91d22717ad743a63c16febd84"],["org/mockito/verification/class-use/Timeout.html","ca3f74d6dc4b08843e4126ef6f380e03"],["org/mockito/verification/class-use/VerificationAfterDelay.html","3721858decec4e5ecc482f0ec43b39f6"],["org/mockito/verification/class-use/VerificationEvent.html","05079045b426631814b56887e6574b07"],["org/mockito/verification/class-use/VerificationMode.html","b411ddb5a131c5172c62b87930cb116b"],["org/mockito/verification/class-use/VerificationStrategy.html","48f8a9fa5147cf1714e88c2ceec58bdd"],["org/mockito/verification/class-use/VerificationWithTimeout.html","e585f4f8051b97d1f4fe009785369ab5"],["org/mockito/verification/package-frame.html","bf6f92a745a01fb49a3848bae0262f0f"],["org/mockito/verification/package-summary.html","dfd54e799138c6e12e2f738398c95283"],["org/mockito/verification/package-tree.html","aa2ff8734b356789fd2c97908d713641"],["org/mockito/verification/package-use.html","b2beb2800cac1601cf9629314c51802e"],["overview-frame.html","e6c8a6bbb4abf579b221895ca5fe2725"],["overview-summary.html","f8c1438be948822da92814f419a0d2a0"],["overview-tree.html","41e258731891751255584817d81448e5"],["serialized-form.html","1dbd2ceaf262cd5a974ba8b3c6172165"],["stylesheet.css","3dd9013d4309436be79cba586b6e5454"]];
var cacheName = 'sw-precache-v2-sw-precache-' + (self.registration ? self.registration.scope : '');


var ignoreUrlParametersMatching = [/^utm_/];



var addDirectoryIndex = function (originalUrl, index) {
    var url = new URL(originalUrl);
    if (url.pathname.slice(-1) === '/') {
      url.pathname += index;
    }
    return url.toString();
  };

var createCacheKey = function (originalUrl, paramName, paramValue,
                           dontCacheBustUrlsMatching) {
    // Create a new URL object to avoid modifying originalUrl.
    var url = new URL(originalUrl);

    // If dontCacheBustUrlsMatching is not set, or if we don't have a match,
    // then add in the extra cache-busting URL parameter.
    if (!dontCacheBustUrlsMatching ||
        !(url.toString().match(dontCacheBustUrlsMatching))) {
      url.search += (url.search ? '&' : '') +
        encodeURIComponent(paramName) + '=' + encodeURIComponent(paramValue);
    }

    return url.toString();
  };

var isPathWhitelisted = function (whitelist, absoluteUrlString) {
    // If the whitelist is empty, then consider all URLs to be whitelisted.
    if (whitelist.length === 0) {
      return true;
    }

    // Otherwise compare each path regex to the path of the URL passed in.
    var path = (new URL(absoluteUrlString)).pathname;
    return whitelist.some(function(whitelistedPathRegex) {
      return path.match(whitelistedPathRegex);
    });
  };

var stripIgnoredUrlParameters = function (originalUrl,
    ignoreUrlParametersMatching) {
    var url = new URL(originalUrl);

    url.search = url.search.slice(1) // Exclude initial '?'
      .split('&') // Split into an array of 'key=value' strings
      .map(function(kv) {
        return kv.split('='); // Split each 'key=value' string into a [key, value] array
      })
      .filter(function(kv) {
        return ignoreUrlParametersMatching.every(function(ignoredRegex) {
          return !ignoredRegex.test(kv[0]); // Return true iff the key doesn't match any of the regexes.
        });
      })
      .map(function(kv) {
        return kv.join('='); // Join each [key, value] array into a 'key=value' string
      })
      .join('&'); // Join the array of 'key=value' strings into a string with '&' in between each

    return url.toString();
  };


var hashParamName = '_sw-precache';
var urlsToCacheKeys = new Map(
  precacheConfig.map(function(item) {
    var relativeUrl = item[0];
    var hash = item[1];
    var absoluteUrl = new URL(relativeUrl, self.location);
    var cacheKey = createCacheKey(absoluteUrl, hashParamName, hash, false);
    return [absoluteUrl.toString(), cacheKey];
  })
);

function setOfCachedUrls(cache) {
  return cache.keys().then(function(requests) {
    return requests.map(function(request) {
      return request.url;
    });
  }).then(function(urls) {
    return new Set(urls);
  });
}

self.addEventListener('install', function(event) {
  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return setOfCachedUrls(cache).then(function(cachedUrls) {
        return Promise.all(
          Array.from(urlsToCacheKeys.values()).map(function(cacheKey) {
            // If we don't have a key matching url in the cache already, add it.
            if (!cachedUrls.has(cacheKey)) {
              return cache.add(new Request(cacheKey, {
                credentials: 'same-origin',
                redirect: 'follow'
              }));
            }
          })
        );
      });
    }).then(function() {
      
      // Force the SW to transition from installing -> active state
      return self.skipWaiting();
      
    })
  );
});

self.addEventListener('activate', function(event) {
  var setOfExpectedUrls = new Set(urlsToCacheKeys.values());

  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return cache.keys().then(function(existingRequests) {
        return Promise.all(
          existingRequests.map(function(existingRequest) {
            if (!setOfExpectedUrls.has(existingRequest.url)) {
              return cache.delete(existingRequest);
            }
          })
        );
      });
    }).then(function() {
      
      return self.clients.claim();
      
    })
  );
});


self.addEventListener('fetch', function(event) {
  if (event.request.method === 'GET') {
    // Should we call event.respondWith() inside this fetch event handler?
    // This needs to be determined synchronously, which will give other fetch
    // handlers a chance to handle the request if need be.
    var shouldRespond;

    // First, remove all the ignored parameter and see if we have that URL
    // in our cache. If so, great! shouldRespond will be true.
    var url = stripIgnoredUrlParameters(event.request.url, ignoreUrlParametersMatching);
    shouldRespond = urlsToCacheKeys.has(url);

    // If shouldRespond is false, check again, this time with 'index.html'
    // (or whatever the directoryIndex option is set to) at the end.
    var directoryIndex = 'index.html';
    if (!shouldRespond && directoryIndex) {
      url = addDirectoryIndex(url, directoryIndex);
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond is still false, check to see if this is a navigation
    // request, and if so, whether the URL matches navigateFallbackWhitelist.
    var navigateFallback = '';
    if (!shouldRespond &&
        navigateFallback &&
        (event.request.mode === 'navigate') &&
        isPathWhitelisted([], event.request.url)) {
      url = new URL(navigateFallback, self.location).toString();
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond was set to true at any point, then call
    // event.respondWith(), using the appropriate cache key.
    if (shouldRespond) {
      event.respondWith(
        caches.open(cacheName).then(function(cache) {
          return cache.match(urlsToCacheKeys.get(url)).then(function(response) {
            if (response) {
              return response;
            }
            throw Error('The cached response that was expected is missing.');
          });
        }).catch(function(e) {
          // Fall back to just fetch()ing the request if some unexpected error
          // prevented the cached response from being valid.
          console.warn('Couldn\'t serve response for "%s" from cache: %O', event.request.url, e);
          return fetch(event.request);
        })
      );
    }
  }
});







