/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.configuration;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.configuration.AnnotationEngine;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.exceptions.Reporter;
import org.mockito.internal.util.MockUtil;

public class SpyAnnotationEngine
implements org.mockito.plugins.AnnotationEngine,
AnnotationEngine {
    @Override
    public void process(Class<?> context, Object testInstance) {
        Field[] fields;
        for (Field field : fields = context.getDeclaredFields()) {
            if (!field.isAnnotationPresent(Spy.class) || field.isAnnotationPresent(InjectMocks.class)) continue;
            this.assertNoIncompatibleAnnotations(Spy.class, field, Mock.class, Captor.class);
            field.setAccessible(true);
            try {
                Object instance = field.get(testInstance);
                SpyAnnotationEngine.assertNotInterface(instance, field.getType());
                if (MockUtil.isMock(instance)) {
                    Mockito.reset(instance);
                    continue;
                }
                if (instance != null) {
                    field.set(testInstance, Mockito.mock(instance.getClass(), Mockito.withSettings().spiedInstance(instance).defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field.getName())));
                    continue;
                }
                field.set(testInstance, SpyAnnotationEngine.newSpyInstance(testInstance, field));
            }
            catch (Exception e) {
                throw new MockitoException("Unable to initialize @Spy annotated field '" + field.getName() + "'.\n" + e.getMessage(), e);
            }
        }
    }

    private static void assertNotInterface(Object testInstance, Class<?> type) {
        Class<?> clazz = type = testInstance != null ? testInstance.getClass() : type;
        if (type.isInterface()) {
            throw new MockitoException("Type '" + type.getSimpleName() + "' is an interface and it cannot be spied on.");
        }
    }

    private static Object newSpyInstance(Object testInstance, Field field) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor;
        Class<?> enclosing;
        MockSettings settings = Mockito.withSettings().defaultAnswer(Mockito.CALLS_REAL_METHODS).name(field.getName());
        Class<?> type = field.getType();
        if (type.isInterface()) {
            return Mockito.mock(type, settings.useConstructor());
        }
        if (!Modifier.isStatic(type.getModifiers()) && (enclosing = type.getEnclosingClass()) != null) {
            if (!enclosing.isInstance(testInstance)) {
                throw new MockitoException("@Spy annotation can only initialize inner classes declared in the test. Inner class: '" + type.getSimpleName() + "', " + "outer class: '" + enclosing.getSimpleName() + "'.");
            }
            return Mockito.mock(type, settings.useConstructor().outerInstance(testInstance));
        }
        try {
            constructor = type.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new MockitoException("Please ensure that the type '" + type.getSimpleName() + "' has 0-arg constructor.");
        }
        if (Modifier.isPrivate(constructor.getModifiers())) {
            constructor.setAccessible(true);
            return Mockito.mock(type, settings.spiedInstance(constructor.newInstance(new Object[0])));
        }
        return Mockito.mock(type, settings.useConstructor());
    }

    private void assertNoIncompatibleAnnotations(Class<? extends Annotation> annotation, Field field, Class<? extends Annotation> ... undesiredAnnotations) {
        for (Class<? extends Annotation> u : undesiredAnnotations) {
            if (!field.isAnnotationPresent(u)) continue;
            throw Reporter.unsupportedCombinationOfAnnotations(annotation.getSimpleName(), annotation.getClass().getSimpleName());
        }
    }
}

