/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.creation.bytebuddy;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mockito.internal.creation.bytebuddy.BytecodeGenerator;
import org.mockito.internal.creation.bytebuddy.MockFeatures;

class TypeCachingBytecodeGenerator
extends ReferenceQueue<ClassLoader>
implements BytecodeGenerator {
    private static final ClassLoader BOOT_LOADER = new URLClassLoader(new URL[0], TypeCachingBytecodeGenerator.class.getClassLoader());
    final ConcurrentMap<Key, CachedBytecodeGenerator> avoidingClassLeakageCache = new ConcurrentHashMap<Key, CachedBytecodeGenerator>();
    private final BytecodeGenerator bytecodeGenerator;
    private final boolean weak;

    public TypeCachingBytecodeGenerator(BytecodeGenerator bytecodeGenerator, boolean weak) {
        this.bytecodeGenerator = bytecodeGenerator;
        this.weak = weak;
    }

    public <T> Class<T> mockClass(MockFeatures<T> params) {
        this.cleanUpCachesForObsoleteClassLoaders();
        return this.mockCachePerClassLoaderOf(params.mockedType.getClassLoader()).getOrGenerateMockClass(params);
    }

    void cleanUpCachesForObsoleteClassLoaders() {
        Reference reference;
        while ((reference = this.poll()) != null) {
            this.avoidingClassLeakageCache.remove(reference);
        }
    }

    private CachedBytecodeGenerator mockCachePerClassLoaderOf(ClassLoader classLoader) {
        CachedBytecodeGenerator newGenerator;
        classLoader = classLoader == null ? BOOT_LOADER : classLoader;
        CachedBytecodeGenerator generator = (CachedBytecodeGenerator)this.avoidingClassLeakageCache.get(new LookupKey(classLoader));
        if (generator == null && (generator = this.avoidingClassLeakageCache.putIfAbsent(new WeakKey(classLoader, this), newGenerator = new CachedBytecodeGenerator(this.bytecodeGenerator, this.weak))) == null) {
            generator = newGenerator;
        }
        return generator;
    }

    private static class WeakKey
    extends WeakReference<ClassLoader>
    implements Key {
        private final int hashCode;

        public WeakKey(ClassLoader referent, ReferenceQueue<ClassLoader> q) {
            super(referent, q);
            this.hashCode = System.identityHashCode(referent);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Key)) {
                return false;
            }
            return this.get() == ((Key)object).get();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class LookupKey
    implements Key {
        private final ClassLoader value;
        private final int hashCode;

        public LookupKey(ClassLoader value) {
            this.value = value;
            this.hashCode = System.identityHashCode(value);
        }

        @Override
        public ClassLoader get() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Key)) {
                return false;
            }
            return this.value == ((Key)object).get();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static interface Key {
        public ClassLoader get();
    }

    private static class CachedBytecodeGenerator {
        private ConcurrentHashMap<MockKey, Reference<Class<?>>> generatedClassCache = new ConcurrentHashMap();
        private BytecodeGenerator bytecodeGenerator;
        private final boolean weak;

        private CachedBytecodeGenerator(BytecodeGenerator bytecodeGenerator, boolean weak) {
            this.bytecodeGenerator = bytecodeGenerator;
            this.weak = weak;
        }

        private Class<?> getMockClass(MockKey<?> mockKey) {
            Reference<Class<?>> classReference = this.generatedClassCache.get(mockKey);
            if (classReference != null) {
                return classReference.get();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Class<?> getOrGenerateMockClass(MockFeatures<?> features) {
            MockKey mockKey = MockKey.of(features.mockedType, features.interfaces);
            Class<?> generatedMockClass = this.getMockClass(mockKey);
            if (generatedMockClass == null) {
                Class clazz = features.mockedType;
                synchronized (clazz) {
                    generatedMockClass = this.getMockClass(mockKey);
                    if (generatedMockClass == null) {
                        generatedMockClass = this.bytecodeGenerator.mockClass(features);
                        this.generatedClassCache.put(mockKey, this.weak ? new WeakReference(generatedMockClass) : new SoftReference(generatedMockClass));
                    }
                }
            }
            return generatedMockClass;
        }

        private static class MockKey<T> {
            private final String mockedType;
            private final Set<String> types;

            private MockKey(Class<T> mockedType, Set<Class<?>> interfaces) {
                this.mockedType = mockedType.getName();
                if (interfaces.isEmpty()) {
                    this.types = Collections.emptySet();
                } else {
                    this.types = new HashSet<String>();
                    for (Class<?> anInterface : interfaces) {
                        this.types.add(anInterface.getName());
                    }
                    this.types.add(this.mockedType);
                }
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                MockKey mockKey = (MockKey)other;
                if (!this.mockedType.equals(mockKey.mockedType)) {
                    return false;
                }
                return ((Object)this.types).equals(mockKey.types);
            }

            public int hashCode() {
                int result = this.mockedType.hashCode();
                result = 31 * result + ((Object)this.types).hashCode();
                return result;
            }

            public static <T> MockKey<T> of(Class<T> mockedType, Set<Class<?>> interfaces) {
                return new MockKey<T>(mockedType, interfaces);
            }
        }
    }
}

