/**
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

// DO NOT EDIT THIS GENERATED OUTPUT DIRECTLY!
// This file should be overwritten as part of your build process.
// If you need to extend the behavior of the generated service worker, the best approach is to write
// additional code and include it using the importScripts option:
//   https://github.com/GoogleChrome/sw-precache#importscripts-arraystring
//
// Alternatively, it's possible to make changes to the underlying template file and then use that as the
// new base for generating output, via the templateFilePath option:
//   https://github.com/GoogleChrome/sw-precache#templatefilepath-string
//
// If you go that route, make sure that whenever you update your sw-precache dependency, you reconcile any
// changes made to this original template file with your modified copy.

// This generated service worker JavaScript will precache your site's resources.
// The code needs to be saved in a .js file at the top-level of your site, and registered
// from your pages in order to be used. See
// https://github.com/googlechrome/sw-precache/blob/master/demo/app/js/service-worker-registration.js
// for an example of how you can register this script and handle various service worker events.

/* eslint-env worker, serviceworker */
/* eslint-disable indent, no-unused-vars, no-multiple-empty-lines, max-nested-callbacks, space-before-function-paren, quotes, comma-spacing */
'use strict';

var precacheConfig = [["allclasses-frame.html","66965d49d76a956d403d25a626fc602a"],["allclasses-noframe.html","fe9d4a6dc1193d5a34a52f5667d171bc"],["constant-values.html","47f83f81c6d8988965f30a242bc5e2ee"],["deprecated-list.html","343876adb4b1b7c0f4cce7ed1ee3f2c7"],["favicon.ico","05e61206186c2eee9054011bcf15b864"],["help-doc.html","4cc9a77992d085c7266d042f52b97b44"],["index-files/index-1.html","16e61a3899e5f8aac2b4f179f8aa1958"],["index-files/index-10.html","b4322a5df39e07cb7f997676087cc273"],["index-files/index-11.html","fa7db977a81df358c8b302803aba08c5"],["index-files/index-12.html","cbb7ae792bd149407ecd4477f759d0af"],["index-files/index-13.html","b978965006f94e35199b08e0f2ac8693"],["index-files/index-14.html","c0f8aa267afb3313855d49ebd461100a"],["index-files/index-15.html","529c455a47ccbc52a4e7f72db290bfca"],["index-files/index-16.html","836237b84057b4d6fb3f318340a20c70"],["index-files/index-17.html","2c84003625667233440a8b52f955729d"],["index-files/index-18.html","75ee32204be5dc843107b12b812917cf"],["index-files/index-19.html","00362b2c24b9262e90914cf474d2f317"],["index-files/index-2.html","2b013c3e25f6573e803d2d833faa9447"],["index-files/index-20.html","68161885c9f3eb269897e9558947cd92"],["index-files/index-3.html","115e784c9bde901bae67c32f81cc1c0b"],["index-files/index-4.html","9ef2f24f525f60646c48f03cd65257e1"],["index-files/index-5.html","f75d41ffa36847393a61b2f606a436a9"],["index-files/index-6.html","3b8d5d8f13db9b2dfb69759528fac92f"],["index-files/index-7.html","3ee78cf0cb2adc4c7f9a474a0161fdfe"],["index-files/index-8.html","a4f9f67da32471531e3b5e729147c3c1"],["index-files/index-9.html","9973b132060bf5af4615c0e59bad1154"],["index.html","30eb82af2288aa1234f3d932581a7ea9"],["js/highlight-8.6-java/highlight.pack.js","deec56e4bb489b0ce943987284aac274"],["js/highlight-8.6-java/styles/obsidian.css","d60cd29c66c835762c95d2ce6da21142"],["js/index.js","dfc78156c8712ef6c546ea1037a604ef"],["js/jdk6-project-version-insert.js","ddee726b95840e7606e132d95c65ef27"],["js/jdk6-project-version-insert.min.js","a6a8d425f512ba0a8e2340504f134553"],["js/jquery-1.7.min.js","25721ced154b3a99e818431446d7506d"],["org/mockito/AdditionalAnswers.html","cb35e7a177495bc09011492e060539e6"],["org/mockito/AdditionalMatchers.html","003883eb6d8dd921736e4e0da8c30db1"],["org/mockito/Answers.html","486e50418420fee37fd3780490af7b14"],["org/mockito/ArgumentCaptor.html","3864ad5c52f294dc0a31c169e5b7bd1a"],["org/mockito/ArgumentMatcher.html","310d697128a73ab6ce48cec74e4bf64e"],["org/mockito/ArgumentMatchers.html","66cf659d18417495a69b06990e539fbf"],["org/mockito/BDDMockito.BDDMyOngoingStubbing.html","f013f121c8d9641e6c0d327d1a11ebce"],["org/mockito/BDDMockito.BDDStubber.html","90b412404b0450ce37ef8afde80408c4"],["org/mockito/BDDMockito.Then.html","2abe824ad1a6442440e0394715f65e2c"],["org/mockito/BDDMockito.html","f85e347437fa82dc1fa9a625bd1d5384"],["org/mockito/Captor.html","2eaa3118bdb694f3de65a334f912fb0b"],["org/mockito/InOrder.html","57706ef5945930a6f97afe0d4f62fc46"],["org/mockito/Incubating.html","549ac79e5e10eb7159aa7afa7fc99d21"],["org/mockito/InjectMocks.html","b054fd2196ba75f6d9c7509f458916a7"],["org/mockito/Matchers.html","9fb6f5066097535e48e874aa0808402d"],["org/mockito/Mock.html","ba282ac5b54456c445791cf42bc0dcc9"],["org/mockito/MockSettings.html","ce75b341e30662b44650071557729c0f"],["org/mockito/MockingDetails.html","6fac30a6ba994a9919f4dbb6317851c0"],["org/mockito/Mockito.html","0b70494c258afdb2de253ccc94f0b58c"],["org/mockito/MockitoAnnotations.html","4c145902aebeb53e49e5654319746582"],["org/mockito/MockitoDebugger.html","5a33e0554c312f895015636b3779491f"],["org/mockito/MockitoFramework.html","08be51a92ccfe208faa9964d5b090a4b"],["org/mockito/Spy.html","5846e1cc609cdb34c147eafc43b6087e"],["org/mockito/class-use/AdditionalAnswers.html","b88419296d9fc8da082786b8021bc2f0"],["org/mockito/class-use/AdditionalMatchers.html","be4dd59a54b0aeb314eee5e70c2a6893"],["org/mockito/class-use/Answers.html","7956b3bd6fe000958c911e64c485a177"],["org/mockito/class-use/ArgumentCaptor.html","89f0829429127f62ca519a18699303d4"],["org/mockito/class-use/ArgumentMatcher.html","293b21310dd96df7ad3512b3a08b8862"],["org/mockito/class-use/ArgumentMatchers.html","1821b0928dd2bbfea088dbcd7ecfb48d"],["org/mockito/class-use/BDDMockito.BDDMyOngoingStubbing.html","01ade399f0633666b3f5287e44d57565"],["org/mockito/class-use/BDDMockito.BDDStubber.html","dace5fef006c1af944f74e889ea85f72"],["org/mockito/class-use/BDDMockito.Then.html","1d895ad0dbc288504d7c7a67df97ef73"],["org/mockito/class-use/BDDMockito.html","21856909173d0db7b7e703753d43ab10"],["org/mockito/class-use/Captor.html","a4c92383860d5767f3f9f51dc1d99e9a"],["org/mockito/class-use/InOrder.html","bd34fe950b724acc08e1c5753ce0722f"],["org/mockito/class-use/Incubating.html","19e3b7bda3c8f25b210b64e426f474e9"],["org/mockito/class-use/InjectMocks.html","4247585cac06278cf7946d3f64075078"],["org/mockito/class-use/Matchers.html","2a67ce1d68543b70dc2701070931554f"],["org/mockito/class-use/Mock.html","c9aa8d75edd14660a8a2aaace891cdc8"],["org/mockito/class-use/MockSettings.html","e67823fb5ad071bdc7bf3b61193cb16a"],["org/mockito/class-use/MockingDetails.html","35fb8ecbf3641684ab6b039f67187fac"],["org/mockito/class-use/Mockito.html","4838ce4e9521def9f49a8b50e14ce8bf"],["org/mockito/class-use/MockitoAnnotations.html","87a378373b6136c21b6a4e7c4cbcbb47"],["org/mockito/class-use/MockitoDebugger.html","108b69fe6d832ece4be98d6ebb49b363"],["org/mockito/class-use/MockitoFramework.html","303d55a59e1595e7331d8732618f6721"],["org/mockito/class-use/Spy.html","6fc50c71db9cdd51444e65052c9e6de5"],["org/mockito/configuration/AnnotationEngine.html","af1399bab681bbc8778072df33872c22"],["org/mockito/configuration/DefaultMockitoConfiguration.html","6cbaa6a9404b9e2200ab1e94f289fd4e"],["org/mockito/configuration/IMockitoConfiguration.html","3b4642d005f3c768fc25b83ec3c72509"],["org/mockito/configuration/class-use/AnnotationEngine.html","832280cf1fdc0386f3dd2d8467ae5fd9"],["org/mockito/configuration/class-use/DefaultMockitoConfiguration.html","f4b8246907f25928ed0b1160c5c62a75"],["org/mockito/configuration/class-use/IMockitoConfiguration.html","27e160ba91ffb483cc442e0b204feb41"],["org/mockito/configuration/package-frame.html","b1be7ed5a62e8e7eb24bd359d096e52f"],["org/mockito/configuration/package-summary.html","35893cc772830922c77bf3fe8d2d0a6e"],["org/mockito/configuration/package-tree.html","eb3a11968f9241a72f812b53943bafd0"],["org/mockito/configuration/package-use.html","4260ebcbbe16e139d7f93839722f7f90"],["org/mockito/exceptions/base/MockitoAssertionError.html","418e4bb38aff9c4ffd48e608cc0fe642"],["org/mockito/exceptions/base/MockitoException.html","318b2c5af19d677349fedb9b269d6406"],["org/mockito/exceptions/base/MockitoInitializationException.html","d916ea733c9ff02f6b32bfffbe781da5"],["org/mockito/exceptions/base/MockitoSerializationIssue.html","925da60ba48c2c1d7ebaf5127ebce487"],["org/mockito/exceptions/base/class-use/MockitoAssertionError.html","b13d9a76467795e7bc3b2a02bc8ab23f"],["org/mockito/exceptions/base/class-use/MockitoException.html","254cfee02b025a8a6dcf40dfa4b22817"],["org/mockito/exceptions/base/class-use/MockitoInitializationException.html","4b07cc710598fcda45d69f8005e39a67"],["org/mockito/exceptions/base/class-use/MockitoSerializationIssue.html","7819348644afc05beaadf92f64ccae2f"],["org/mockito/exceptions/base/package-frame.html","b8a0cb6d879b8dd73e18d1bb12491fee"],["org/mockito/exceptions/base/package-summary.html","9a8e604a5352cf0e73f0ced6d082f7c9"],["org/mockito/exceptions/base/package-tree.html","2156c88e299052490a0bcd9721db812f"],["org/mockito/exceptions/base/package-use.html","472f6d224f983adc2dc8d85bfee14f0c"],["org/mockito/exceptions/misusing/CannotStubVoidMethodWithReturnValue.html","ef41b718fe4a657fb5fcbdf4fdbff6fc"],["org/mockito/exceptions/misusing/CannotVerifyStubOnlyMock.html","d93016a27d6981abdfa0218f1d06c099"],["org/mockito/exceptions/misusing/FriendlyReminderException.html","54e073c3627f44b4649014901f7e6d4d"],["org/mockito/exceptions/misusing/InvalidUseOfMatchersException.html","9db7ac6dca63dc67dd4ff30184f98c4a"],["org/mockito/exceptions/misusing/MissingMethodInvocationException.html","6ca097c5a8c18ff47c46ac8a00eb73b9"],["org/mockito/exceptions/misusing/MockitoConfigurationException.html","4a71a3abe0932c137e9e846cbdf7c14a"],["org/mockito/exceptions/misusing/NotAMockException.html","ee1896e01b193a26e5967503529f15b5"],["org/mockito/exceptions/misusing/NullInsteadOfMockException.html","9728e29609a0dfc21927f7028479feff"],["org/mockito/exceptions/misusing/PotentialStubbingProblem.html","1589fc8f315447d11bedde03f33f7424"],["org/mockito/exceptions/misusing/UnfinishedStubbingException.html","4db4829454ddcaff6c5e7f3d656b0d22"],["org/mockito/exceptions/misusing/UnfinishedVerificationException.html","07856bffe7d60aa4995b5ae494250a58"],["org/mockito/exceptions/misusing/UnnecessaryStubbingException.html","a0baac61e9511148b78d81ef3fe6cb85"],["org/mockito/exceptions/misusing/WrongTypeOfReturnValue.html","40798bef71f51cf284dcece1bfa2d6ce"],["org/mockito/exceptions/misusing/class-use/CannotStubVoidMethodWithReturnValue.html","5fcd2f3b062bcce853e96c6c25a4e3f0"],["org/mockito/exceptions/misusing/class-use/CannotVerifyStubOnlyMock.html","79514782ed9c15add0b8a5076625948a"],["org/mockito/exceptions/misusing/class-use/FriendlyReminderException.html","25a50ef8a9ddef42bb32bb15a5a666bf"],["org/mockito/exceptions/misusing/class-use/InvalidUseOfMatchersException.html","666eca20b679607b33a9ed9320d53919"],["org/mockito/exceptions/misusing/class-use/MissingMethodInvocationException.html","a0e6b73ac792a4010808003a96b16748"],["org/mockito/exceptions/misusing/class-use/MockitoConfigurationException.html","d83146bbf4d5e8e26e0e6e7b8a1cee62"],["org/mockito/exceptions/misusing/class-use/NotAMockException.html","e11aa0d173a7c747fd197300a1145fba"],["org/mockito/exceptions/misusing/class-use/NullInsteadOfMockException.html","ca16b8e2cfc81201595d835147676ba7"],["org/mockito/exceptions/misusing/class-use/PotentialStubbingProblem.html","7f9d975b6fec4957c1bfd9e47a352f21"],["org/mockito/exceptions/misusing/class-use/UnfinishedStubbingException.html","f39fb7d4eef32cfab6d7b88cd3b5d6d5"],["org/mockito/exceptions/misusing/class-use/UnfinishedVerificationException.html","b2d90fd25e0c097a984264740a0a897e"],["org/mockito/exceptions/misusing/class-use/UnnecessaryStubbingException.html","06d56b70f84f91c2bd0e0488b6694432"],["org/mockito/exceptions/misusing/class-use/WrongTypeOfReturnValue.html","d3b5291b0001502e494d31c3b3529416"],["org/mockito/exceptions/misusing/package-frame.html","8259cba7c9f21a0f04aab3916c0b93a1"],["org/mockito/exceptions/misusing/package-summary.html","adb3238bb0d70c45691e1c2d9c9ed5e9"],["org/mockito/exceptions/misusing/package-tree.html","07a0eab6efafd9d36d855083e89b7c4e"],["org/mockito/exceptions/misusing/package-use.html","eb6d31159bfd7be8bff874fb66cdb868"],["org/mockito/exceptions/stacktrace/StackTraceCleaner.html","79ecf9d4698caca929a4ac9fdb0f827a"],["org/mockito/exceptions/stacktrace/class-use/StackTraceCleaner.html","3a15617ef9e4a16cc4ceedd7bb5e1e87"],["org/mockito/exceptions/stacktrace/package-frame.html","05093289e2ac908a5f2530c537d27e7a"],["org/mockito/exceptions/stacktrace/package-summary.html","b2ea83a6e78fda413599d5b466886941"],["org/mockito/exceptions/stacktrace/package-tree.html","3d9e6c970ae96dd821ec0c1497c557ff"],["org/mockito/exceptions/stacktrace/package-use.html","3b7cc73a902a9ec948d8c978d387e0f9"],["org/mockito/exceptions/verification/ArgumentsAreDifferent.html","d6cdf8a3e96eeb2c2302e925fbb1eddb"],["org/mockito/exceptions/verification/NeverWantedButInvoked.html","3a4326c428ae7c39787aba176fce5802"],["org/mockito/exceptions/verification/NoInteractionsWanted.html","4aaae9ebab4d35254361e0cf8804cac4"],["org/mockito/exceptions/verification/SmartNullPointerException.html","c4a54a3c10d14fdb2f99aff6ffe08162"],["org/mockito/exceptions/verification/TooLittleActualInvocations.html","f5a32434d7725a7011f89301c712db57"],["org/mockito/exceptions/verification/TooManyActualInvocations.html","9b3888e3c9b8e9845d6dff392a814e83"],["org/mockito/exceptions/verification/VerificationInOrderFailure.html","bda4544887bce626a79cd5a83f7bd926"],["org/mockito/exceptions/verification/WantedButNotInvoked.html","adba8da1150ca7648f6fb0886f1b3135"],["org/mockito/exceptions/verification/class-use/ArgumentsAreDifferent.html","89d5c9c1574631a509a5ff65029da791"],["org/mockito/exceptions/verification/class-use/NeverWantedButInvoked.html","11fa016df375a3916bc6d0dfc73cea8f"],["org/mockito/exceptions/verification/class-use/NoInteractionsWanted.html","d38c592502113f44436f7e22623b8088"],["org/mockito/exceptions/verification/class-use/SmartNullPointerException.html","b79a2de753afef6e365d3ab49c7e7740"],["org/mockito/exceptions/verification/class-use/TooLittleActualInvocations.html","3e9c33b3822d4c4bcb5a8409ab4f8993"],["org/mockito/exceptions/verification/class-use/TooManyActualInvocations.html","88f065f95df6e80ec54f02d166a42f5a"],["org/mockito/exceptions/verification/class-use/VerificationInOrderFailure.html","278cf0f817121ee3203950d1794f63fd"],["org/mockito/exceptions/verification/class-use/WantedButNotInvoked.html","2d9f961efd82cc63aa258cf721a80b4d"],["org/mockito/exceptions/verification/junit/ArgumentsAreDifferent.html","e487c5e105f1bd83af5c78d87edc81a9"],["org/mockito/exceptions/verification/junit/class-use/ArgumentsAreDifferent.html","54712479af1ba87d92f4f0bf06450ca6"],["org/mockito/exceptions/verification/junit/package-frame.html","f6b55e021be2c64a45e0ad3c42eceaa3"],["org/mockito/exceptions/verification/junit/package-summary.html","f15edb4c406c77e8e1ff5a987e822bd1"],["org/mockito/exceptions/verification/junit/package-tree.html","596ba9f7b62a2f0f49df78f7c297526f"],["org/mockito/exceptions/verification/junit/package-use.html","c8f1f288d96ef758d1912ed5733500bb"],["org/mockito/exceptions/verification/package-frame.html","2d56e726f45de8b969fbf78f437690eb"],["org/mockito/exceptions/verification/package-summary.html","ad015ca3b4b14f4a5f5d3c9a5f6e0a32"],["org/mockito/exceptions/verification/package-tree.html","64b20ceb2392f037e78393fb2797af69"],["org/mockito/exceptions/verification/package-use.html","e1514e7982c61d5aab0310c29e1201ee"],["org/mockito/hamcrest/MockitoHamcrest.html","621a45266a7e1a5121f9630d503c7f8a"],["org/mockito/hamcrest/class-use/MockitoHamcrest.html","b93b80838b9f7f8a3438c08149ae9a90"],["org/mockito/hamcrest/package-frame.html","e33ad71d0fb1027f306bbbcc54fd5ae9"],["org/mockito/hamcrest/package-summary.html","f43646475abf927d3ae187c6be2a2987"],["org/mockito/hamcrest/package-tree.html","a9fa63f45e6e6bb8b9930aae691052f8"],["org/mockito/hamcrest/package-use.html","5153d7571e79afebf5b5effa36b34fc9"],["org/mockito/invocation/DescribedInvocation.html","4ff3258221bd37dc275797d7cb8e7061"],["org/mockito/invocation/Invocation.html","35e48cb41f8571e7ff46db289e0814c4"],["org/mockito/invocation/InvocationOnMock.html","33d3d9a45ab4f963ec733d309706768b"],["org/mockito/invocation/Location.html","3a5bd799608b8f86a13d47639cf6f509"],["org/mockito/invocation/MatchableInvocation.html","87fa7bc8fc5d3ab5bbc4b2d7b20c13e3"],["org/mockito/invocation/MockHandler.html","460575342640f7da299d5d9375111b7e"],["org/mockito/invocation/StubInfo.html","e32f5263e3e4f6d4bce19003a1843976"],["org/mockito/invocation/class-use/DescribedInvocation.html","0d31ecc1940b9f3b852de1940be8865f"],["org/mockito/invocation/class-use/Invocation.html","feb411c8233c00c553f25d3d5cbd6e0f"],["org/mockito/invocation/class-use/InvocationOnMock.html","85afd27810a1f5c0699bf502aceab41c"],["org/mockito/invocation/class-use/Location.html","060ff13b38747222359daaa31bb5cf2f"],["org/mockito/invocation/class-use/MatchableInvocation.html","7ad55f673a3e0116919138e6a6de237d"],["org/mockito/invocation/class-use/MockHandler.html","da4238b8d8672227be9a791966e783da"],["org/mockito/invocation/class-use/StubInfo.html","7b26284bfd8c6db96fb01f43dfc7d65c"],["org/mockito/invocation/package-frame.html","dcab8cec0238f6741931b40c8170dede"],["org/mockito/invocation/package-summary.html","33f3b388abc062a07ebcd68aaa75dca3"],["org/mockito/invocation/package-tree.html","f09fd34415e73ec5fc5dcdd2fc116de9"],["org/mockito/invocation/package-use.html","1a86e803bf804700845bef8808f06085"],["org/mockito/junit/MockitoJUnit.html","c9fa2367938cabb7211dd663b2b2493f"],["org/mockito/junit/MockitoJUnitRunner.Silent.html","c38c3cbbcde9179412bef21f68ab33b4"],["org/mockito/junit/MockitoJUnitRunner.Strict.html","12b14bc7789c615df14e9fdc7eb9754b"],["org/mockito/junit/MockitoJUnitRunner.html","0dbd87f233df6b34eea3667d1eb65bca"],["org/mockito/junit/MockitoRule.html","1ea2c1ab42d4737b180d6efa84bf882a"],["org/mockito/junit/VerificationCollector.html","5f15176b8547c512d769cb29b7c66885"],["org/mockito/junit/class-use/MockitoJUnit.html","6c79b3ce74904f5ba77de294ddf8bd01"],["org/mockito/junit/class-use/MockitoJUnitRunner.Silent.html","5759d492c0eedfd41a3b03e4f50d59a8"],["org/mockito/junit/class-use/MockitoJUnitRunner.Strict.html","cad8c640751878b8aa015cf1b6359bde"],["org/mockito/junit/class-use/MockitoJUnitRunner.html","cce771d0e6ed26d324ed8009f8b47f85"],["org/mockito/junit/class-use/MockitoRule.html","ef8ab9f620db12dfaa0f923c8d74054a"],["org/mockito/junit/class-use/VerificationCollector.html","3752fd2be1361d98ba88374936ad6c91"],["org/mockito/junit/package-frame.html","1f0621d70bdebbbac30eacf55f0e7381"],["org/mockito/junit/package-summary.html","adb4f86e4a6605ab4873d992eda2c51b"],["org/mockito/junit/package-tree.html","73d10e82d0c631a3ba35628d65991d94"],["org/mockito/junit/package-use.html","0098d1299b3262d7352a670fd213ce16"],["org/mockito/listeners/InvocationListener.html","a4556ecebd6d62bbfca3ebcc6c92feca"],["org/mockito/listeners/MethodInvocationReport.html","033a88e2a0f046abc392208b22a60d04"],["org/mockito/listeners/MockCreationListener.html","2154aa2b8a15857c47e9cda498260dfc"],["org/mockito/listeners/MockitoListener.html","60c4f602c95bc00ce7c66c667e48a2b8"],["org/mockito/listeners/VerificationListener.html","2c887a8893151fd66a3fb53524b955bf"],["org/mockito/listeners/class-use/InvocationListener.html","c2213045ed418d43470917d15ea5b4a6"],["org/mockito/listeners/class-use/MethodInvocationReport.html","9d522d6bcf76737c7ad663c7768f5f5f"],["org/mockito/listeners/class-use/MockCreationListener.html","b2969a45967007418e6e90799d9b6f7b"],["org/mockito/listeners/class-use/MockitoListener.html","1512d9a5b3e943ead3bb8d8173c86550"],["org/mockito/listeners/class-use/VerificationListener.html","2782a00b0a5c0ec9a60fdd0a8da432f0"],["org/mockito/listeners/package-frame.html","a69dd787cf33342ea56efc9eb1fe0ae3"],["org/mockito/listeners/package-summary.html","de50b8657b51493970c4060da19bac6b"],["org/mockito/listeners/package-tree.html","e5dcdc5b41e171ab814fa5eb4fcc757d"],["org/mockito/listeners/package-use.html","10726cd49ffc8e8e1fa63e8d06b151b3"],["org/mockito/mock/MockCreationSettings.html","c43d2b29c303cb009a8a656a0e9a298f"],["org/mockito/mock/MockName.html","ad65a203a449045df1539e975d60d6e5"],["org/mockito/mock/SerializableMode.html","e516efc244375b9b7f9a752dc39313e6"],["org/mockito/mock/class-use/MockCreationSettings.html","63bc4b3710ca5a4af1c496dba7f6d819"],["org/mockito/mock/class-use/MockName.html","d51451c1746b482da2968d99d7153fb4"],["org/mockito/mock/class-use/SerializableMode.html","f0ce74f298277f1ab8d5859e4f05f3c2"],["org/mockito/mock/package-frame.html","ce8a43b47f0bfcd0a04044cb7d4209ee"],["org/mockito/mock/package-summary.html","86c21c0b91058cffe71cc2c4ea6af439"],["org/mockito/mock/package-tree.html","50a16ae374c2886bebaddd7ec6e3002e"],["org/mockito/mock/package-use.html","95dcc4115c315cc0f06af10cf2779b60"],["org/mockito/package-frame.html","226a05d2b06154a73a7f216c972b33d9"],["org/mockito/package-summary.html","6139c88bfe1e38b44f1abccbd4b2f6de"],["org/mockito/package-tree.html","815e583e90aacbae064a701ba9d7a55c"],["org/mockito/package-use.html","c6a62ea691f5d6199b1cf7ec25097f15"],["org/mockito/plugins/AnnotationEngine.html","9195f98b37f557c893b557a9b5c252f4"],["org/mockito/plugins/InstantiatorProvider.html","ad5f2b93793a86c1abb634c3e08ce1bd"],["org/mockito/plugins/MockMaker.TypeMockability.html","3ea459c64b655471b29975cde4585812"],["org/mockito/plugins/MockMaker.html","edaa7e6783e16aba8a5c67ee6b22f98d"],["org/mockito/plugins/PluginSwitch.html","4cf447747ffbf9b03fc6ea7ec2ea05cc"],["org/mockito/plugins/StackTraceCleanerProvider.html","e71264a80e6a3af78d5c78cb3777c4f9"],["org/mockito/plugins/class-use/AnnotationEngine.html","1c287e8c7a5813a73a3527ecf61be8c7"],["org/mockito/plugins/class-use/InstantiatorProvider.html","ebcc5ce51fbb45f18a6d9c0b6330e0a8"],["org/mockito/plugins/class-use/MockMaker.TypeMockability.html","cf506f77c21aa8fae453ca6f3ab5bf05"],["org/mockito/plugins/class-use/MockMaker.html","612d9f9eed87e30ca5ab5aebb54d3713"],["org/mockito/plugins/class-use/PluginSwitch.html","2823ef0b5f618d90b442180ca8d80da9"],["org/mockito/plugins/class-use/StackTraceCleanerProvider.html","a890cf4744c6acaba219e4adb661c9cf"],["org/mockito/plugins/package-frame.html","051b04f8517c7963451ac042f95774a9"],["org/mockito/plugins/package-summary.html","7f900d0ff09dbd3108949a8af3bd98a3"],["org/mockito/plugins/package-tree.html","982e02621cac290337e80d77fda100da"],["org/mockito/plugins/package-use.html","29146cd608d7d5478ec01e5e05d5ef30"],["org/mockito/quality/MockitoHint.html","2ce183717b9c8ec4ffab9bac24fe1cee"],["org/mockito/quality/Strictness.html","66425b8bee6f5550cf360a7e2a8fd809"],["org/mockito/quality/class-use/MockitoHint.html","9378bf59a155f6194690df2df786f262"],["org/mockito/quality/class-use/Strictness.html","9f79fa5825e4b0c9f92558e2bce756d3"],["org/mockito/quality/package-frame.html","7fc445fbb147fe27974ea70ebb6c0302"],["org/mockito/quality/package-summary.html","6c53c3a3c03e82f9578ea56eb41736f0"],["org/mockito/quality/package-tree.html","88b9d8ea6cc0a398b7f46c1b72c83205"],["org/mockito/quality/package-use.html","d8c08dd7881e3123d0361ccdc8132f54"],["org/mockito/runners/ConsoleSpammingMockitoJUnitRunner.html","0e9aad93a059fd717853de70d52de176"],["org/mockito/runners/MockitoJUnitRunner.Silent.html","c629d2fd97ca4a5cb88e99196974aa4e"],["org/mockito/runners/MockitoJUnitRunner.Strict.html","21de540b8559648fb134706be5dac245"],["org/mockito/runners/MockitoJUnitRunner.html","7715b32103d493c31ec0222e28fed76a"],["org/mockito/runners/VerboseMockitoJUnitRunner.html","c0ce04255ee3afe4120bbcb223827c4d"],["org/mockito/runners/class-use/ConsoleSpammingMockitoJUnitRunner.html","cac56753b90701461cea65957e824504"],["org/mockito/runners/class-use/MockitoJUnitRunner.Silent.html","8409301c481bbd25dda0d42710624be2"],["org/mockito/runners/class-use/MockitoJUnitRunner.Strict.html","20e34db3324e3cc3a99c59a0dcab7455"],["org/mockito/runners/class-use/MockitoJUnitRunner.html","a74f1db9811c0e4678ecbb54ff961010"],["org/mockito/runners/class-use/VerboseMockitoJUnitRunner.html","825252ec2bdb4c0bc545b4578816f2cc"],["org/mockito/runners/package-frame.html","e6ab2e6b5efe2f2ceba75508b052cb3c"],["org/mockito/runners/package-summary.html","8aa9b967d0e6b14657e53f5c6e735884"],["org/mockito/runners/package-tree.html","906cc51fd01f1b12fbffbf600f383b6b"],["org/mockito/runners/package-use.html","23c8890120bb0d5095d94f99673fdde7"],["org/mockito/stubbing/Answer.html","30d2c15c6b3ebd0245430194f59d1730"],["org/mockito/stubbing/Answer1.html","33e9fcc408792d307321b5c768f75fa7"],["org/mockito/stubbing/Answer2.html","7e5b939bb74d02769b5c6de627c79b8e"],["org/mockito/stubbing/Answer3.html","00b94c35841054d38915c0ab9f81aae4"],["org/mockito/stubbing/Answer4.html","41c27f1d2220ba5a5e84aef941e2ec28"],["org/mockito/stubbing/Answer5.html","5f16a7c4b4e8db6d6e22a2f2e5f4a6af"],["org/mockito/stubbing/OngoingStubbing.html","22c1e6c4e0acf43ac3bf47621f9db51d"],["org/mockito/stubbing/Stubber.html","cbeb748950803ad27a2b59d606ae7be2"],["org/mockito/stubbing/Stubbing.html","65b886094de630c4a7b8de80f8a8d496"],["org/mockito/stubbing/ValidableAnswer.html","ce017fe5c1077178984b8cf329b448b1"],["org/mockito/stubbing/VoidAnswer1.html","e630ef70d6b2597610e25242f72ae1b1"],["org/mockito/stubbing/VoidAnswer2.html","572ddbeef79b0a94863d14c17b3d51c3"],["org/mockito/stubbing/VoidAnswer3.html","3f6e7dbf901104f407382a4c81f85523"],["org/mockito/stubbing/VoidAnswer4.html","b2c3f9f1707ec1a982989a203ae546a7"],["org/mockito/stubbing/VoidAnswer5.html","2dff727c0802f4be8f9bf84a52d51990"],["org/mockito/stubbing/class-use/Answer.html","daea5dd0680abe6eef4f6ec2c885c1ed"],["org/mockito/stubbing/class-use/Answer1.html","68d971891c9cf75b85c5cf533a209ec1"],["org/mockito/stubbing/class-use/Answer2.html","657df22c275bb02409815018f4120246"],["org/mockito/stubbing/class-use/Answer3.html","a5535a5c3293281924d7eeb73d92ba3e"],["org/mockito/stubbing/class-use/Answer4.html","1aeb6deaf026d3c20dc78fc29638be97"],["org/mockito/stubbing/class-use/Answer5.html","b2a1bfc8826dd94359df69503a319376"],["org/mockito/stubbing/class-use/OngoingStubbing.html","5a61f065b474eb0375bb1c3b8ac577a1"],["org/mockito/stubbing/class-use/Stubber.html","9cd1e136b94879d4bcdda5f7380d0c1d"],["org/mockito/stubbing/class-use/Stubbing.html","1b7f8c9dda8f8f0ad1f80cbdd58096fa"],["org/mockito/stubbing/class-use/ValidableAnswer.html","dd4de8d054d02f7c04c88a76c4a9858e"],["org/mockito/stubbing/class-use/VoidAnswer1.html","9dec5abf7ba20db7c928ee1e2398588b"],["org/mockito/stubbing/class-use/VoidAnswer2.html","3c00ee60e5168b817409d120fc56a37f"],["org/mockito/stubbing/class-use/VoidAnswer3.html","d762a741cf4ae2a1a88fbf49e58a6c71"],["org/mockito/stubbing/class-use/VoidAnswer4.html","3159a8e409b673a3eb8c78bfc83ab180"],["org/mockito/stubbing/class-use/VoidAnswer5.html","93f23603a7856d7bc4ea7497bb7e2451"],["org/mockito/stubbing/package-frame.html","a58c1edc4a36d1a3fc512e0696956551"],["org/mockito/stubbing/package-summary.html","e7d9603b6f5cbe3d71d3b3a0fa6a0afa"],["org/mockito/stubbing/package-tree.html","9d88b2ec851fec11a1f7cf59a5cdb99e"],["org/mockito/stubbing/package-use.html","c8be592926db6c20d7a3d3b568db8583"],["org/mockito/verification/After.html","4f2b3347732989f0bd4875bb38daf3ea"],["org/mockito/verification/Timeout.html","e54b10e5287a739f0fd6f8bc07fc3211"],["org/mockito/verification/VerificationAfterDelay.html","f18d3f859d56c9fd16c1a8f3b9978a95"],["org/mockito/verification/VerificationEvent.html","ac865806f0d52f4b85b439c1d78bd25d"],["org/mockito/verification/VerificationMode.html","0923b11fefa2c4f9f8fbb54ce7a20d89"],["org/mockito/verification/VerificationStrategy.html","90a4eef38f1bbfdca7fa50a8fa9a6cbe"],["org/mockito/verification/VerificationWithTimeout.html","19829bd6adaba2af1247d07905ec6d08"],["org/mockito/verification/class-use/After.html","7e05ed5747b839409feefaf593a4a995"],["org/mockito/verification/class-use/Timeout.html","aa25e2fe00b1c60f728d0f7fc7e53fa9"],["org/mockito/verification/class-use/VerificationAfterDelay.html","dbba027b538f6bc7007fb8cdfcdf9580"],["org/mockito/verification/class-use/VerificationEvent.html","231b02d71e37432053ed30dc59aa539c"],["org/mockito/verification/class-use/VerificationMode.html","afc14030708fe18dfe0c4a098ab3d393"],["org/mockito/verification/class-use/VerificationStrategy.html","5612b5b089e949708953a911b7a86f51"],["org/mockito/verification/class-use/VerificationWithTimeout.html","cd5d62e1bb5366ac0ccadb0cf02f624b"],["org/mockito/verification/package-frame.html","3cbfeaf99a50a7aadbaa7a88114c8749"],["org/mockito/verification/package-summary.html","c30cce3b86756bd7b7ad51b87435a24a"],["org/mockito/verification/package-tree.html","b01ad11077fa77476f874d6df275f5c2"],["org/mockito/verification/package-use.html","a03db54c97c0161a0defccd4cc00d24b"],["overview-frame.html","6f30efea02eb5d69d3123b2e31a216a1"],["overview-summary.html","b04efc2169a29515900f6c324cb49fa7"],["overview-tree.html","db9a1f34cf8b34598b66bb16c4367d91"],["serialized-form.html","dae227840f295de35575cfbcb1e60f70"],["stylesheet.css","3dd9013d4309436be79cba586b6e5454"]];
var cacheName = 'sw-precache-v2-sw-precache-' + (self.registration ? self.registration.scope : '');


var ignoreUrlParametersMatching = [/^utm_/];



var addDirectoryIndex = function (originalUrl, index) {
    var url = new URL(originalUrl);
    if (url.pathname.slice(-1) === '/') {
      url.pathname += index;
    }
    return url.toString();
  };

var createCacheKey = function (originalUrl, paramName, paramValue,
                           dontCacheBustUrlsMatching) {
    // Create a new URL object to avoid modifying originalUrl.
    var url = new URL(originalUrl);

    // If dontCacheBustUrlsMatching is not set, or if we don't have a match,
    // then add in the extra cache-busting URL parameter.
    if (!dontCacheBustUrlsMatching ||
        !(url.toString().match(dontCacheBustUrlsMatching))) {
      url.search += (url.search ? '&' : '') +
        encodeURIComponent(paramName) + '=' + encodeURIComponent(paramValue);
    }

    return url.toString();
  };

var isPathWhitelisted = function (whitelist, absoluteUrlString) {
    // If the whitelist is empty, then consider all URLs to be whitelisted.
    if (whitelist.length === 0) {
      return true;
    }

    // Otherwise compare each path regex to the path of the URL passed in.
    var path = (new URL(absoluteUrlString)).pathname;
    return whitelist.some(function(whitelistedPathRegex) {
      return path.match(whitelistedPathRegex);
    });
  };

var stripIgnoredUrlParameters = function (originalUrl,
    ignoreUrlParametersMatching) {
    var url = new URL(originalUrl);

    url.search = url.search.slice(1) // Exclude initial '?'
      .split('&') // Split into an array of 'key=value' strings
      .map(function(kv) {
        return kv.split('='); // Split each 'key=value' string into a [key, value] array
      })
      .filter(function(kv) {
        return ignoreUrlParametersMatching.every(function(ignoredRegex) {
          return !ignoredRegex.test(kv[0]); // Return true iff the key doesn't match any of the regexes.
        });
      })
      .map(function(kv) {
        return kv.join('='); // Join each [key, value] array into a 'key=value' string
      })
      .join('&'); // Join the array of 'key=value' strings into a string with '&' in between each

    return url.toString();
  };


var hashParamName = '_sw-precache';
var urlsToCacheKeys = new Map(
  precacheConfig.map(function(item) {
    var relativeUrl = item[0];
    var hash = item[1];
    var absoluteUrl = new URL(relativeUrl, self.location);
    var cacheKey = createCacheKey(absoluteUrl, hashParamName, hash, false);
    return [absoluteUrl.toString(), cacheKey];
  })
);

function setOfCachedUrls(cache) {
  return cache.keys().then(function(requests) {
    return requests.map(function(request) {
      return request.url;
    });
  }).then(function(urls) {
    return new Set(urls);
  });
}

self.addEventListener('install', function(event) {
  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return setOfCachedUrls(cache).then(function(cachedUrls) {
        return Promise.all(
          Array.from(urlsToCacheKeys.values()).map(function(cacheKey) {
            // If we don't have a key matching url in the cache already, add it.
            if (!cachedUrls.has(cacheKey)) {
              return cache.add(new Request(cacheKey, {credentials: 'same-origin'}));
            }
          })
        );
      });
    }).then(function() {
      
      // Force the SW to transition from installing -> active state
      return self.skipWaiting();
      
    })
  );
});

self.addEventListener('activate', function(event) {
  var setOfExpectedUrls = new Set(urlsToCacheKeys.values());

  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return cache.keys().then(function(existingRequests) {
        return Promise.all(
          existingRequests.map(function(existingRequest) {
            if (!setOfExpectedUrls.has(existingRequest.url)) {
              return cache.delete(existingRequest);
            }
          })
        );
      });
    }).then(function() {
      
      return self.clients.claim();
      
    })
  );
});


self.addEventListener('fetch', function(event) {
  if (event.request.method === 'GET') {
    // Should we call event.respondWith() inside this fetch event handler?
    // This needs to be determined synchronously, which will give other fetch
    // handlers a chance to handle the request if need be.
    var shouldRespond;

    // First, remove all the ignored parameter and see if we have that URL
    // in our cache. If so, great! shouldRespond will be true.
    var url = stripIgnoredUrlParameters(event.request.url, ignoreUrlParametersMatching);
    shouldRespond = urlsToCacheKeys.has(url);

    // If shouldRespond is false, check again, this time with 'index.html'
    // (or whatever the directoryIndex option is set to) at the end.
    var directoryIndex = 'index.html';
    if (!shouldRespond && directoryIndex) {
      url = addDirectoryIndex(url, directoryIndex);
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond is still false, check to see if this is a navigation
    // request, and if so, whether the URL matches navigateFallbackWhitelist.
    var navigateFallback = '';
    if (!shouldRespond &&
        navigateFallback &&
        (event.request.mode === 'navigate') &&
        isPathWhitelisted([], event.request.url)) {
      url = new URL(navigateFallback, self.location).toString();
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond was set to true at any point, then call
    // event.respondWith(), using the appropriate cache key.
    if (shouldRespond) {
      event.respondWith(
        caches.open(cacheName).then(function(cache) {
          return cache.match(urlsToCacheKeys.get(url)).then(function(response) {
            if (response) {
              return response;
            }
            throw Error('The cached response that was expected is missing.');
          });
        }).catch(function(e) {
          // Fall back to just fetch()ing the request if some unexpected error
          // prevented the cached response from being valid.
          console.warn('Couldn\'t serve response for "%s" from cache: %O', event.request.url, e);
          return fetch(event.request);
        })
      );
    }
  }
});







